<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Ananaz extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=4, nullable=false)
   */
  public $cdnazi;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dsnazi;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('ananaz');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdnazi' => isset($rec->cdnazi) && (string)$rec->cdnazi !== '' ? (string)$rec->cdnazi : new RawValue('""'),
      'dsnazi' => isset($rec->dsnazi) && (string)$rec->dsnazi !== '' ? (string)$rec->dsnazi : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0
    );

    $query  = 'cdnazi = :cdnazi:';
    $params = array(
      'cdnazi' => $values['cdnazi']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Ananaz objects
   */
  public static function getAllCountries() {
    $query = "SELECT an.cdnazi, an.dsnazi
      FROM Go2B\Models\Ananaz an
      ORDER BY an.dsnazi";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }
  //endregion
}
