<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Mvc\Model;

class Anaiva extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=4, nullable=false)
   */
  public $cdaiva;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dsaiva;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $aliquo;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('anaiva');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdaiva' => isset($rec->cdaiva) && (string)$rec->cdaiva !== '' ? (string)$rec->cdaiva : new RawValue('""'),
      'dsaiva' => isset($rec->dsaiva) && (string)$rec->dsaiva !== '' ? (string)$rec->dsaiva : new RawValue('""'),
      'aliquo' => isset($rec->aliquo) && (string)$rec->aliquo !== '' ? (string)$rec->aliquo : 0,
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0
    );

    $query  = 'cdaiva = :cdaiva:';
    $params = array(
      'cdaiva' => $values['cdaiva']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion
}
