<?php

namespace Go2B\Models;

use Go2B\Controllers\Utility;
use Go2B\Plugins\Nav\ApiKOC;
use Go2B\Plugins\Nav\NewCustomerKOC;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;
use Ramsey\Uuid\Uuid;

class Anagra extends Model
{
    //region Fields
    /**
     *
     * @var string
     * @Primary
     * @Column(type="string", length=2, nullable=false)
     */
    public $tpanag;

    /**
     *
     * @var string
     * @Primary
     * @Column(type="string", length=30, nullable=false)
     */
    public $cdanag;

    /**
     *
     * @var string
     * @Column(type="string", length=80, nullable=false)
     */
    public $descri;

    /**
     *
     * @var string
     * @Column(type="string", length=20, nullable=false)
     */
    public $desvid;

    /**
     *
     * @var string
     * @Column(type="string", length=80, nullable=false)
     */
    public $indiri;

    /**
     *
     * @var string
     * @Column(type="string", length=10, nullable=false)
     */
    public $codcap;

    /**
     *
     * @var string
     * @Column(type="string", length=60, nullable=false)
     */
    public $ccitta;

    /**
     *
     * @var string
     * @Column(type="string", length=10, nullable=false)
     */
    public $provin;

    /**
     *
     * @var string
     * @Column(type="string", length=4, nullable=false)
     */
    public $cdnazi;

    /**
     *
     * @var string
     * @Column(type="string", length=2, nullable=false)
     */
    public $idlang;

    /**
     *
     * @var string
     * @Column(type="string", length=4, nullable=false)
     */
    public $cdzona;

    /**
     *
     * @var string
     * @Column(type="string", length=20, nullable=false)
     */
    public $pariva;

    /**
     *
     * @var string
     * @Column(type="string", length=20, nullable=false)
     */
    public $codfis;

    /**
     *
     * @var string
     * @Column(type="string", length=40, nullable=false)
     */
    public $numtel;

    /**
     *
     * @var string
     * @Column(type="string", length=40, nullable=false)
     */
    public $numcel;

    /**
     *
     * @var string
     * @Column(type="string", length=40, nullable=false)
     */
    public $numfax;

    /**
     *
     * @var string
     * @Column(type="string", length=60, nullable=false)
     */
    public $intern;

    /**
     *
     * @var string
     * @Column(type="string", length=60, nullable=false)
     */
    public $indema;

    /**
     *
     * @var string
     * @Column(type="string", length=60, nullable=false)
     */
    public $indem2;

    /**
     *
     * @var string
     * @Column(type="string", length=60, nullable=false)
     */
    public $percon;

    /**
     *
     * @var string
     * @Column(type="string", length=4, nullable=false)
     */
    public $cdvalu;

    /**
     *
     * @var string
     * @Column(type="string", length=4, nullable=false)
     */
    public $tpaggc;

    /**
     *
     * @var string
     * @Column(type="string", length=10, nullable=false)
     */
    public $nulist;

    /**
     *
     * @var string
     * @Column(type="string", length=10, nullable=false)
     */
    public $rulist;

    /**
     *
     * @var integer
     * @Column(type="integer", length=11, nullable=false)
     */
    public $nuscon;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $scont1;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $scont2;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $scont3;

    /**
     *
     * @var string
     * @Column(type="string", length=4, nullable=false)
     */
    public $tpport;

    /**
     *
     * @var string
     * @Column(type="string", length=10, nullable=false)
     */
    public $tppaga;

    /**
     *
     * @var string
     * @Column(type="string", length=4, nullable=false)
     */
    public $cdesen;

    /**
     *
     * @var integer
     * @Column(type="integer", length=11, nullable=false)
     */
    public $codabi;

    /**
     *
     * @var integer
     * @Column(type="integer", length=11, nullable=false)
     */
    public $codcab;

    /**
     *
     * @var string
     * @Column(type="string", length=40, nullable=false)
     */
    public $cdiban;

    /**
     *
     * @var string
     * @Column(type="string", length=10, nullable=false)
     */
    public $cdvett;

    /**
     *
     * @var integer
     * @Column(type="integer", length=6, nullable=false)
     */
    public $cdagen;

    /**
     *
     * @var integer
     * @Column(type="integer", length=6, nullable=false)
     */
    public $cdblco;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $dtblco;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $provvi;

    /**
     *
     * @var string
     * @Column(type="string", length=30, nullable=false)
     */
    public $cddesm;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $dtvali;

    /**
     *
     * @var integer
     * @Column(type="integer", length=11, nullable=false)
     */
    public $newcod;

    /**
     *
     * @var string
     * @Column(type="string", length=1, nullable=false)
     */
    public $priori;

    /**
     *
     * @var string
     * @Column(type="string", length=10, nullable=false)
     */
    public $cdetic;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $latitu;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $longit;

    /**
     *
     * @var string
     * @Column(type="string", nullable=false)
     */
    public $notdes;

    /**
     *
     * @var integer
     * @Column(type="integer", length=6, nullable=false)
     */
    public $cdage2;

    /**
     *
     * @var integer
     * @Column(type="integer", length=6, nullable=false)
     */
    public $cdage3;

    /**
     *
     * @var integer
     * @Column(type="integer", length=6, nullable=false)
     */
    public $cdage4;

    /**
     *
     * @var integer
     * @Column(type="integer", length=6, nullable=false)
     */
    public $cdage5;

    /**
     *
     * @var string
     * @Column(type="string", length=60, nullable=false)
     */
    public $indpec;

    /**
     *
     * @var string
     * @Column(type="string", length=6, nullable=false)
     */
    public $uffipa;

    /**
     *
     * @var string
     * @Column(type="string", length=7, nullable=false)
     */
    public $codupr;

    /**
     *
     * @var string
     * @Column(type="string", length=255, nullable=false)
     */
    public $websit;

    /**
     *
     * @var string
     * @Column(type="string", length=30, nullable=false)
     */
    public $cdcana;
    //endregion

    //region Default functions

    /**
     * Allows to query the first customer by key 'cdanag' having tpanag = 'CL'
     *
     * @param $tpanag
     * @param $cdanag
     * @return Anagra
     */
    public static function findCustomerByKey($tpanag, $cdanag)
    {
        if (empty($tpanag)) {
            $tpanag = 'CL';
        }
        return Anagra::findFirst("cdanag = '" . $cdanag . "' AND tpanag = '" . $tpanag . "'");
    }

    /**
     * Allows to query the first anagra by key 'tpanag,cdanag'
     *
     * @param $tpanag
     * @param $cdanag
     * @return Anagra
     */
    public static function findFirstByPrimaryKey($tpanag, $cdanag)
    {
        return Anagra::findFirst([
            "cdanag = :cdanag: AND tpanag = :tpanag:",
            'bind' => ['cdanag' => $cdanag, 'tpanag' => $tpanag]
        ]);
    }

    /**
     * Sync from xml
     */
    public static function saveRecord($rec, $tipoagg, $username = null, $password = null, $enabled = 0)
    {
        $values = array(
            'tpanag' => isset($rec->tpanag) && (string)$rec->tpanag !== '' ? (string)$rec->tpanag : new RawValue('""'),
            'cdanag' => isset($rec->cdanag) && (string)$rec->cdanag !== '' ? trim((string)$rec->cdanag) : new RawValue('""'),
            'descri' => isset($rec->descri) && (string)$rec->descri !== '' ? (string)$rec->descri : new RawValue('""'),
            'desvid' => isset($rec->desvid) && (string)$rec->desvid !== '' ? (string)$rec->desvid : new RawValue('""'),
            'indiri' => isset($rec->indiri) && (string)$rec->indiri !== '' ? (string)$rec->indiri : new RawValue('""'),
            'codcap' => isset($rec->codcap) && (string)$rec->codcap !== '' ? (string)$rec->codcap : new RawValue('""'),
            'ccitta' => isset($rec->ccitta) && (string)$rec->ccitta !== '' ? (string)$rec->ccitta : new RawValue('""'),
            'provin' => isset($rec->provin) && (string)$rec->provin !== '' ? (string)$rec->provin : new RawValue('""'),
            'cdnazi' => isset($rec->cdnazi) && (string)$rec->cdnazi !== '' ? (string)$rec->cdnazi : new RawValue('""'),
            'idlang' => isset($rec->idlang) && (string)$rec->idlang !== '' ? (string)$rec->idlang : new RawValue('""'),
            'cdzona' => isset($rec->cdzona) && (string)$rec->cdzona !== '' ? (string)$rec->cdzona : new RawValue('""'),
            'pariva' => isset($rec->pariva) && (string)$rec->pariva !== '' ? (string)$rec->pariva : new RawValue('""'),
            'codfis' => isset($rec->codfis) && (string)$rec->codfis !== '' ? (string)$rec->codfis : new RawValue('""'),
            'numtel' => isset($rec->numtel) && (string)$rec->numtel !== '' ? (string)$rec->numtel : new RawValue('""'),
            'numcel' => isset($rec->numcel) && (string)$rec->numcel !== '' ? (string)$rec->numcel : new RawValue('""'),
            'numfax' => isset($rec->numfax) && (string)$rec->numfax !== '' ? (string)$rec->numfax : new RawValue('""'),
            'intern' => isset($rec->intern) && (string)$rec->intern !== '' ? (string)$rec->intern : new RawValue('""'),
            'indema' => isset($rec->indema) && (string)$rec->indema !== '' ? (string)$rec->indema : new RawValue('""'),
            'indem2' => isset($rec->indem2) && (string)$rec->indem2 !== '' ? (string)$rec->indem2 : new RawValue('""'),
            'percon' => isset($rec->percon) && (string)$rec->percon !== '' ? (string)$rec->percon : new RawValue('""'),
            'cdvalu' => isset($rec->cdvalu) && (string)$rec->cdvalu !== '' ? (string)$rec->cdvalu : new RawValue('""'),
            'tpaggc' => isset($rec->tpaggc) && (string)$rec->tpaggc !== '' ? (string)$rec->tpaggc : new RawValue('""'),
            'nulist' => isset($rec->nulist) && (string)$rec->nulist !== '' ? (string)$rec->nulist : new RawValue('""'),
            'rulist' => isset($rec->rulist) && (string)$rec->rulist !== '' ? (string)$rec->rulist : new RawValue('""'),
            'nuscon' => isset($rec->nuscon) && (string)$rec->nuscon !== '' ? (string)$rec->nuscon : 0,
            'scont1' => isset($rec->scont1) && (string)$rec->scont1 !== '' ? (string)$rec->scont1 : 0,
            'scont2' => isset($rec->scont2) && (string)$rec->scont2 !== '' ? (string)$rec->scont2 : 0,
            'scont3' => isset($rec->scont3) && (string)$rec->scont3 !== '' ? (string)$rec->scont3 : 0,
            'tpport' => isset($rec->tpport) && (string)$rec->tpport !== '' ? (string)$rec->tpport : new RawValue('""'),
            'tppaga' => isset($rec->tppaga) && (string)$rec->tppaga !== '' ? (string)$rec->tppaga : new RawValue('""'),
            'cdesen' => isset($rec->cdesen) && (string)$rec->cdesen !== '' ? (string)$rec->cdesen : new RawValue('""'),
            'codabi' => isset($rec->codabi) && (string)$rec->codabi !== '' ? (string)$rec->codabi : 0,
            'codcab' => isset($rec->codcab) && (string)$rec->codcab !== '' ? (string)$rec->codcab : 0,
            'cdiban' => isset($rec->cdiban) && (string)$rec->cdiban !== '' ? (string)$rec->cdiban : new RawValue('""'),
            'cdvett' => isset($rec->cdvett) && (string)$rec->cdvett !== '' ? (string)$rec->cdvett : new RawValue('""'),
            'cdagen' => isset($rec->cdagen) && (string)$rec->cdagen !== '' ? (string)$rec->cdagen : 0,
            'cdblco' => isset($rec->cdblco) && (string)$rec->cdblco !== '' ? (string)$rec->cdblco : 0,
            'dtblco' => isset($rec->dtblco) && (string)$rec->dtblco !== '' ? (string)$rec->dtblco : '0000-00-00',
            'provvi' => isset($rec->provvi) && (string)$rec->provvi !== '' ? (string)$rec->provvi : 0,
            'cddesm' => isset($rec->cddesm) && (string)$rec->cddesm !== '' ? (string)$rec->cddesm : new RawValue('""'),
            'dtvali' => isset($rec->dtvali) && (string)$rec->dtvali !== '' ? (string)$rec->dtvali : '0000-00-00',
            'newcod' => isset($rec->newcod) && (string)$rec->newcod !== '' ? (string)$rec->newcod : 0,
            'priori' => isset($rec->priori) && (string)$rec->priori !== '' ? (string)$rec->priori : new RawValue('""'),
            'cdetic' => isset($rec->cdetic) && (string)$rec->cdetic !== '' ? (string)$rec->cdetic : new RawValue('""'),
            'latitu' => isset($rec->latitu) && (string)$rec->latitu !== '' ? (string)$rec->latitu : 0,
            'longit' => isset($rec->longit) && (string)$rec->longit !== '' ? (string)$rec->longit : 0,
            'notdes' => isset($rec->notdes) && (string)$rec->notdes !== '' ? (string)$rec->notdes : new RawValue('""'),
            'cdage2' => isset($rec->cdage2) && (string)$rec->cdage2 !== '' ? (string)$rec->cdage2 : 0,
            'cdage3' => isset($rec->cdage3) && (string)$rec->cdage3 !== '' ? (string)$rec->cdage3 : 0,
            'cdage4' => isset($rec->cdage4) && (string)$rec->cdage4 !== '' ? (string)$rec->cdage4 : 0,
            'cdage5' => isset($rec->cdage5) && (string)$rec->cdage5 !== '' ? (string)$rec->cdage5 : 0,
            'indpec' => isset($rec->indpec) && (string)$rec->indpec !== '' ? (string)$rec->indpec : new RawValue('""'),
            'uffipa' => isset($rec->uffipa) && (string)$rec->uffipa !== '' ? (string)$rec->uffipa : new RawValue('""'),
            'codupr' => isset($rec->codupr) && (string)$rec->codupr !== '' ? (string)$rec->codupr : new RawValue('""'),
            'websit' => isset($rec->websit) && (string)$rec->websit !== '' ? (string)$rec->websit : new RawValue('""'),
            'cdcana' => isset($rec->cdcana) && (string)$rec->cdcana !== '' ? (string)$rec->cdcana : new RawValue('""')
        );

        $query = 'tpanag = :tpanag: AND cdanag = :cdanag:';
        $params = array(
            'tpanag' => $values['tpanag'],
            'cdanag' => $values['cdanag']
        );

        $mustCreateSysusr = false;
        if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
            $row = new self();
            $mustCreateSysusr = $values['cdblco'] == 0 && !empty($username);
        }

        $res = 0;
        if ($row->save($values) !== false) {
            $res++;
            if ($mustCreateSysusr && $row->generateSysusr($enabled, $enabled, null, $username, $password)) {
                $res++;
            }
        }

        if ($values['newcod'] > 0) {
            Octest::updateCustomerCode($values['newcod'], $values['cdanag']);
            Pvtest::updateCustomerCode($values['newcod'], $values['cdanag']);
            Ctanag::updateCustomerCode($values['newcod'], $values['cdanag']);
            Desmer::updateCustomerCode($values['newcod'], $values['cdanag']);
            Gopart::updateCustomerCode($values['newcod'], $values['cdanag']);
            Visana::updateCustomerCode($values['newcod'], $values['cdanag']);
            B2bDisana::updateCustomerCode($values['newcod'], $values['cdanag']);
            B2bNdanag::updateCustomerCode($values['newcod'], $values['cdanag']);
            B2bUsrana::updateCustomerCode($values['newcod'], $values['cdanag']);
            self::blockNewCustomer($values['newcod']);
        }

        return $res;
    }

    //endregion

    //region Sync functions

    public function generateSysusr($enabled = null, $orders_enabled = null, $catalogs = null, $username = null, $password = null, $locale = null)
    {
        $everythingOk = true;
        /** @var Utility $utility */
        $utility = $this->getDI()->get('utility');
        $prefix = $utility->getAppUtils('prefix');
        $updateIndex = false;
        $index = null;
        $enabled = $enabled ? 1 : 0;
        $orders_enabled = $orders_enabled ? 1 : 0;

        if (empty($username)) {
            $updateIndex = true;
            $index = $utility->getAppUtils('index');
            $username = $prefix . sprintf('%05d', $index);

            if (empty($password)) {
                $password = $prefix . "SNG" . sprintf('%05d', (100000 - $index));
            }
        } else if (empty($password)) {
            return false;
        }

        if (empty($locale)) {
            $locale = $utility->convertCdnaziToAvailableLocale($this->cdnazi);
        }

        $user = new B2bSysusr();
        $user->username = $username;
        $user->password = sha1($password);
        $user->created_at = new \Phalcon\Db\RawValue('now()');
        $user->enabled = $enabled;
        $user->orders_enabled = $orders_enabled;
        $user->type = 4; // 1 - super admin; 2 - admin; 3 - agent; 4 - customer; 5 - goods destination
        $user->locale = $locale;

        if ($user->save() == false) {
            $everythingOk &= false;
        } else {
            $id_usr = $user->id;

            if ($updateIndex) {
                $utility->setAppUtils('index', $index + 1);
            }

            $usrana = new B2bUsrana();
            $usrana->id_usr = $id_usr;
            $usrana->cdanag = $this->cdanag;
            $usrana->tpanag = $this->tpanag;

            if ($usrana->save() == false) {
                $everythingOk &= false;
            } else {
                if (!empty($catalogs)) {
                    foreach ($catalogs as $cdcata) {
                        $usrctl = new B2bUsrctl();
                        $usrctl->id_usr = $id_usr;
                        $usrctl->cdcata = $cdcata;

                        if ($usrctl->save() == false) {
                            $everythingOk &= false;
                        }
                    }
                } else {
                    // Check for catalogs in ctanag
                    $ctanag = Ctanag::find(array(
                        "tpanag = :tpanag: AND cdanag = :cdanag:",
                        "bind" => array('tpanag' => $this->tpanag, 'cdanag' => $this->cdanag)
                    ));
                    if ($ctanag != null) {
                        foreach ($ctanag as $item) {
                            $usrctl = new B2bUsrctl();
                            $usrctl->id_usr = $id_usr;
                            $usrctl->cdcata = $item->cdcata;

                            if ($usrctl->save() == false) {
                                $everythingOk &= false;
                            }
                        }
                    }
                }

                $notifyToCustomer = $utility->getAppSettings('NotifySysusrToCustomer');

                // If we are enabling user, and we didn't already notify
                if ($notifyToCustomer && $everythingOk && $enabled == 1 && $user->email_sent == 0 && isset($user->id)) {
                    $utility->sendNewAccessEmailToUser($user, $password);
                }
            }
        }

        return $everythingOk;
    }
    //endregion

    //region Custom queries

    /**
     * Query:   UPDATE
     * Return:  void
     */
    public static function blockNewCustomer($cdanag)
    {
        $params = array('cdanag' => $cdanag);
        $query = "UPDATE anagra ag
      SET ag.cdblco = 999
      WHERE ag.tpanag = 'CN' AND ag.cdanag = :cdanag ";
        Di::getDefault()->get('db')->query($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Anagra objects
     */
    public static function getAllCustomers()
    {
        $query = 'SELECT a.tpanag, a.cdanag, a.descri, a.nulist, a.rulist,
      COALESCE(t.tpindo,"") AS default_tpindo
      FROM Go2B\Models\Anagra a
      LEFT JOIN Go2B\Models\Tppaga t ON t.tppaga = a.tppaga
      WHERE a.cdblco < 2
      ORDER BY a.descri, a.cdanag';
        return Di::getDefault()->get('modelsManager')->executeQuery($query);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Anagra objects
     */
    public static function getAllCustomersForAgent($cdagen)
    {
//        $query = 'SELECT a.tpanag, a.cdanag, a.descri, a.nulist, a.rulist,
//          COALESCE(t.tpindo,"") AS default_tpindo
//          FROM Go2B\Models\Anagra a
//          LEFT JOIN Go2B\Models\Tppaga t ON t.tppaga = a.tppaga
//          WHERE (a.cdagen = :cdagen: OR a.cdage2 = :cdagen: OR a.cdage3 = :cdagen: OR a.cdage4 = :cdagen: OR a.cdage5 = :cdagen:) AND a.cdblco < 2
//          ORDER BY a.descri, a.cdanag';
        $query = 'SELECT a.tpanag, a.cdanag, a.descri, a.nulist, a.rulist,
          COALESCE(t.tpindo,"") AS default_tpindo
          FROM Go2B\Models\Ageana ag
          INNER JOIN Go2B\Models\Anagra a ON ag.tpanag = a.tpanag AND ag.codice = a.cdanag AND a.cdblco < 2
          LEFT JOIN Go2B\Models\Tppaga t ON t.tppaga = a.tppaga
          WHERE ag.tipdat = \'C\' AND ag.cdagen = :cdagen:
          ORDER BY a.descri, a.cdanag';

        return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdagen' => $cdagen));
    }

    /**
     * Query:   SELECT
     * Return:  Array of Anagra objects
     */
    public static function getCustomersForShippingUser($id_usr)
    {
        $query = 'SELECT a.tpanag, a.cdanag, a.descri, a.nulist, a.rulist,
      COALESCE(t.tpindo,"") AS default_tpindo
      FROM Go2B\Models\Anagra a
      INNER JOIN Go2B\Models\Desmer d ON d.tpanag = a.tpanag AND d.cdanag = a.cdanag
      INNER JOIN Go2B\Models\B2bUsrdsm u ON u.cddesm = d.cddesm
      LEFT JOIN Go2B\Models\Tppaga t ON t.tppaga = a.tppaga
      WHERE u.id_usr = :id: AND a.cdblco < 2';
        return Di::getDefault()->get('modelsManager')->executeQuery($query, array('id' => $id_usr));
    }

    /**
     * Query:   SELECT
     * Return:  Array of Anagra objects
     */
    public static function getAllAvailableCustomers()
    {
        $query = "SELECT a.tpanag AS tpanag, a.cdanag AS cdanag, a.descri AS descri,
      b.id AS id_usr, b.username AS usrnam, b.enabled AS enable
      FROM Go2B\Models\Anagra a
      INNER JOIN Go2B\Models\B2bUsrana u ON u.tpanag = a.tpanag AND u.cdanag = a.cdanag
      INNER JOIN Go2B\Models\B2bSysusr b ON b.id = u.id_usr
      WHERE a.cdblco < 2
      ORDER BY a.descri";
        return Di::getDefault()->get('modelsManager')->executeQuery($query);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Anagra objects
     */
    public static function getAllEnabledCustomers()
    {
        $query = "SELECT a.tpanag AS tpanag, a.cdanag AS cdanag, a.descri AS descri,
      b.id AS id_usr, b.username AS usrnam, b.enabled AS enable
      FROM Go2B\Models\Anagra a
      INNER JOIN Go2B\Models\B2bUsrana u ON u.tpanag = a.tpanag AND u.cdanag = a.cdanag
      INNER JOIN Go2B\Models\B2bSysusr b ON b.id = u.id_usr
      WHERE b.enabled = 1 AND a.cdblco < 2
      ORDER BY a.descri";
        return Di::getDefault()->get('modelsManager')->executeQuery($query);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Anagra objects
     */
    public static function getOnlyNewCustomers()
    {
        $query = "SELECT ag.tpanag, ag.cdanag, ag.descri, ag.newcod, ag.codfis,
      ag.pariva, ag.indiri, ag.ccitta, ag.provin, ag.codcap, COALESCE(an.dsnazi,ag.cdnazi) AS dsnazi,
      COALESCE(az.dszona,ag.cdzona) AS dszona, ag.intern, ag.numtel, ag.indema,
      ag.indem2, ag.indpec, ag.codupr, ag.websit, ag.numcel, ag.numfax, ag.codabi,
      ag.codcab, ag.cdiban, COALESCE(pg.dspaga,ag.tppaga) AS dspaga, COALESCE(pr.dstpor,ag.tpport) AS dstpor,
      COALESCE(av.dsvett,ag.cdvett) AS dsvett, aa.dsagen
      FROM Go2B\Models\Anagra ag
      INNER JOIN Go2B\Models\Anaage aa ON ag.cdagen = aa.cdagen
      LEFT JOIN Go2B\Models\Ananaz an ON ag.cdnazi = an.cdnazi
      LEFT JOIN Go2B\Models\Anazon az ON ag.cdzona = az.cdzona
      LEFT JOIN Go2B\Models\Tppaga pg ON ag.tppaga = pg.tppaga
      LEFT JOIN Go2B\Models\Tpport pr ON ag.tpport = pr.tpport
      LEFT JOIN Go2B\Models\Anavet av ON ag.cdvett = av.cdvett
      WHERE ag.tpanag = 'CN' AND ag.cdblco < 2
      GROUP BY ag.cdanag
      ORDER BY ag.descri";
        return Di::getDefault()->get('modelsManager')->executeQuery($query);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Anagra objects
     */
    public static function getNewCustomers()
    {
        $query = "SELECT ag.tpanag, ag.cdanag, ag.descri, ag.newcod,
      aa.dsagen, COUNT(ot.nuordc) AS orders
      FROM Go2B\Models\Anagra ag
      INNER JOIN Go2B\Models\Anaage aa ON ag.cdagen = aa.cdagen
      LEFT JOIN Go2B\Models\Octest ot ON ot.tpanag = ag.tpanag AND ot.cdanag = ag.cdanag AND ot.tpanag != 4
      WHERE (ag.tpanag = 'CN' OR ag.newcod != 0) AND ag.cdblco < 2
      GROUP BY ag.cdanag
      ORDER BY ag.descri";
        return Di::getDefault()->get('modelsManager')->executeQuery($query);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Anagra objects
     */
    public static function getCustomersWithPagination($page, $totCustomers, $pageLength, $withPriceList, $searchText = '', $orderBy = '', $limitedIds = [])
    {
        $params = array();
        $additionalConditions = '';
        if ($withPriceList) {
            $additionalConditions = " AND ag.nulist != 0";
        }
        if (!empty($limitedIds)) {
            $additionalConditions = " AND ag.cdanag IN ('" . implode("','", $limitedIds) . "')";
        }
        if ($pageLength > 0 && $totCustomers > $pageLength) {
            $limit = " LIMIT " . ($pageLength * ($page - 1)) . ", $pageLength ";
        } else {
            $limit = '';
        }

        $search = '';
        if ($searchText != '') {
            $search = " AND (ag.cdanag LIKE :search OR ag.indema LIKE :search OR ag.descri LIKE :search)";
            $params['search'] = '%' . $searchText . '%';
        }
        //        $query = "SELECT ag.tpanag, ag.cdanag, ag.cdblco, ag.descri, ag.indema,
        //      COALESCE(su.id,-1) AS id_usr, COALESCE(su.username,'') AS usrnam,
        //      COALESCE(su.enabled,-1) AS enable, COALESCE(az.dszona,'') AS dszona,
        //      COALESCE(su.orders_enabled,1) AS orders_enabled,
        //      COALESCE((SELECT COUNT(dm.cddesm) FROM desmer dm WHERE dm.tpanag = ag.tpanag AND dm.cdanag = ag.cdanag),0) AS shippings
        //      FROM anagra ag
        //      LEFT JOIN anazon az ON ag.cdzona = az.cdzona
        //      LEFT JOIN b2b_usrana ua ON ua.tpanag = ag.tpanag AND ua.cdanag = ag.cdanag
        //      LEFT JOIN b2b_sysusr su ON su.id = ua.id_usr
        //      WHERE ag.tpanag != 'CN'
        //      $additionalConditions
        //      $search
        //      ORDER BY ag.tpanag, ag.cdanag
        //      $limit";
        $orderBy = trim($orderBy);
        if (empty($orderBy)) {
            $orderBy = 'cdanag ASC';
        }
        if (strpos($orderBy, 'ORDER BY ') !== 0) {
            $orderBy = 'ORDER BY ' . $orderBy;
        }

        // COALESCE(COUNT(dm.cddesm), 0) AS shippingsCount,
        // COALESCE(COUNT(uc.cdcata), 0) AS catalogsCount,
        $query = <<<SQL
             SELECT
                cn.*,
                COUNT(DISTINCT dm.cddesm) AS shippingsCount,
                GROUP_CONCAT(DISTINCT dm.cddesm) AS shippings,
                COUNT(DISTINCT uc.cdcata) AS catalogsCount,
                GROUP_CONCAT(DISTINCT uc.cdcata) AS catalogs
            FROM
                (
                SELECT
                    ag.tpanag,
                    ag.cdanag,
                    ag.cdblco,
                    ag.descri,
                    ag.indema,
                    COALESCE(su.id,-1) AS id_usr,
                    COALESCE(su.username, '') AS username,
                    COALESCE(su.enabled,-1) AS enabled,
                    COALESCE(az.dszona, '') AS dszona,
                    COALESCE(su.orders_enabled, 1) AS orders_enabled
                FROM
                    anagra ag
                LEFT JOIN anazon az ON
                    ag.cdzona = az.cdzona
                LEFT JOIN b2b_usrana ua ON
                    ua.tpanag = ag.tpanag
                    AND ua.cdanag = ag.cdanag
                LEFT JOIN b2b_sysusr su ON
                    su.id = ua.id_usr
                WHERE
                    ag.tpanag != 'CN' $additionalConditions $search
                $orderBy
                $limit) cn
            LEFT JOIN desmer dm ON
                dm.tpanag = cn.tpanag
                AND dm.cdanag = cn.cdanag
            LEFT JOIN b2b_usrctl uc ON uc.id_usr = cn.id_usr
            GROUP BY cn.tpanag,  cn.cdanag
            $orderBy
SQL;

        //        (new Utility())->dumpQuery($query, $params, true);
        // WHERE ag.tpanag != 'CN' AND ag.cdblco < 2
        return Di::getDefault()->get('db')->query($query, $params)->fetchAll(\PDO::FETCH_ASSOC);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Anagra objects
     */
    public static function getCustomersFromUser($id_usr, $idlang = 'IT')
    {
        if ($idlang != 'IT') {
            $params = array('id_usr' => $id_usr, 'idlang' => $idlang);
            $dstpor = "COALESCE(d1.descri,pr.dstpor,'') AS dstpor";
            $dspaga = "COALESCE(d2.descri,pg.dspaga,'') AS dspaga";
            $lnJoin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dstpor' AND d1.codic1 = pr.tpport AND d1.idlang = :idlang:
                 LEFT JOIN Go2B\Models\Deslin d2 ON d2.tpdato = 'dspaga' AND d2.codic1 = pg.tppaga AND d2.idlang = :idlang: ";
        } else {
            $params = array('id_usr' => $id_usr);
            $dstpor = "COALESCE(pr.dstpor,'') AS dstpor";
            $dspaga = "COALESCE(pg.dspaga,'') AS dspaga";
            $lnJoin = '';
        }

        $query = "SELECT a.tpanag, a.cdanag, a.descri, a.desvid, a.indiri, a.codcap,
      a.ccitta, a.provin, a.cdnazi, a.cdzona, a.pariva, a.codfis,	a.numtel,
      a.numcel, a.numfax, a.intern, a.indema, a.indem2, a.tpport, a.tppaga,
      a.codabi, a.codcab, a.cdiban, a.cdvett, a.cdagen, a.cdetic, a.nulist,
      COALESCE(n.dsnazi,'') AS dsnazi, COALESCE(z.dszona,'') AS dszona,
      $dstpor, $dspaga, COALESCE(v.dsvett,'') AS dsvett,
      COALESCE(g.dsagen,'') AS dsagen, COALESCE(e.dsetic,'') AS dsetic,
      COALESCE(l.dslist,'') AS dslist, COALESCE(pg.tpindo, '') AS default_tpindo
      FROM Go2B\Models\Anagra a
      INNER JOIN Go2B\Models\B2bUsrana u ON u.tpanag = a.tpanag AND u.cdanag = a.cdanag
      LEFT JOIN Go2B\Models\Ananaz n ON n.cdnazi = a.cdnazi
      LEFT JOIN Go2B\Models\Anazon z ON z.cdzona = a.cdzona
      LEFT JOIN Go2B\Models\Tpport pr ON pr.tpport = a.tpport
      LEFT JOIN Go2B\Models\Tppaga pg ON pg.tppaga = a.tppaga
      LEFT JOIN Go2B\Models\Anavet v ON v.cdvett = a.cdvett
      LEFT JOIN Go2B\Models\Anaage g ON g.cdagen = a.cdagen
      LEFT JOIN Go2B\Models\Anaeti e ON e.cdetic = a.cdetic
      LEFT JOIN Go2B\Models\Lstest l ON l.nulist = a.nulist
      $lnJoin
      WHERE u.id_usr = :id_usr: AND a.cdblco < 2";

        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Anagra objects
     */
    public static function getMainAnagraFromUserId($id_usr)
    {
        $anagra = null;
        // todo forse potremmo prendernli tutti e poi ordinare al query successiva per attivo, id
        $userAnagra = B2bUsrana::findFirst(['id_usr = :id_user:', 'bind' => ['id_user' => $id_usr]]);
        if ($userAnagra instanceof B2bUsrana) {
            $anagra = Anagra::findFirst(['cdanag = :cdanag: AND tpanag = :tpanag:', 'bind' => [
                'cdanag' => $userAnagra->cdanag,
                'tpanag' => $userAnagra->tpanag,
            ]]);
        }

        return $anagra;
    }

    /**
     * Query:   SELECT
     * Return:  Array of Anagra objects
     */
    public static function getTop20QuantityCustomers($whereCatalogs, $whereCustomers, $params)
    {
        $query = "SELECT ot.tpanag, ot.cdanag, aa.descri, SUM(og.quanti) AS qty
      FROM Go2B\Models\Anagra aa
      INNER JOIN Go2B\Models\Octest ot ON aa.tpanag = ot.tpanag AND aa.cdanag = ot.cdanag
      INNER JOIN Go2B\Models\Occorp oc ON ot.nuordc = oc.nuordc
      INNER JOIN Go2B\Models\Octagl og ON oc.nurorc = og.nurorc
      WHERE ot.flstat != 0 AND ot.flstat != 4 AND ot.dtcrea >= :dtiniz: AND ot.dtcrea <= :dtfine:
      $whereCatalogs
      $whereCustomers
      GROUP BY ot.tpanag, ot.cdanag
      ORDER BY qty DESC
      LIMIT 20";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Anagra objects
     */
    public static function getTop20ValueCustomers($whereCatalogs, $whereCustomers, $params)
    {
        $query = "SELECT ot.tpanag, ot.cdanag, aa.descri, SUM(og.quanti * og.prezzo * (1 - og.scont1 / 100)) AS val
      FROM Go2B\Models\Anagra aa
      INNER JOIN Go2B\Models\Octest ot ON aa.tpanag = ot.tpanag AND aa.cdanag = ot.cdanag
      INNER JOIN Go2B\Models\Occorp oc ON ot.nuordc = oc.nuordc
      INNER JOIN Go2B\Models\Octagl og ON oc.nurorc = og.nurorc
      WHERE ot.flstat != 0 AND ot.flstat != 4 AND ot.dtcrea >= :dtiniz: AND ot.dtcrea <= :dtfine:
      $whereCatalogs
      $whereCustomers
      GROUP BY ot.tpanag, ot.cdanag
      ORDER BY val DESC
      LIMIT 20";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Anagra objects
     */
    public static function getAllChannels()
    {
        $query = "SELECT DISTINCT aa.cdcana AS code, aa.cdcana AS description
      FROM Go2B\Models\Anagra aa
      ORDER BY aa.cdcana";
        return Di::getDefault()->get('modelsManager')->executeQuery($query);
    }

    /**
     * Query:   SELECT
     * Return:  Array of Anagra arrays
     */
    public static function getEmailAddressForCustomersAndShippings()
    {
        $query = 'SELECT DISTINCT ag.indema
      FROM anagra ag
      INNER JOIN b2b_usrana ua ON ag.tpanag = ua.tpanag AND ag.cdanag = ua.cdanag
      INNER JOIN b2b_sysusr bu ON ua.id_usr = bu.id
      WHERE bu.enabled = 1 AND bu.type = 4
      UNION
      SELECT DISTINCT ag.indema
      FROM anagra ag
      INNER JOIN desmer dm ON ag.tpanag = dm.tpanag AND ag.cdanag = dm.cdanag 
      INNER JOIN b2b_usrdsm ud ON dm.cddesm = ud.cddesm
      INNER JOIN b2b_usrana ua ON ag.tpanag = ua.tpanag AND ag.cdanag = ua.cdanag
      INNER JOIN b2b_sysusr bu ON ua.id_usr = bu.id
      WHERE bu.enabled = 1 AND bu.type = 5';
        return Di::getDefault()->get('db')->query($query)->fetchAll();
    }

    /**
     * Query:   SELECT
     * Return:  Array of Anagra arrays
     */
    public static function getEmailAddressForCustomers()
    {
        $query = 'SELECT DISTINCT ag.indema
      FROM anagra ag
      INNER JOIN b2b_usrana ua ON ag.tpanag = ua.tpanag AND ag.cdanag = ua.cdanag
      INNER JOIN b2b_sysusr bu ON ua.id_usr = bu.id
      WHERE bu.enabled = 1 AND bu.type = 4';
        return Di::getDefault()->get('db')->query($query)->fetchAll();
    }

    /**
     * Query:   SELECT
     * Return:  Array of Anagra arrays
     */
    public static function getEmailAddressForSelectedCustomers($idusrs)
    {
        $customers = '';
        $params = array();
        for ($i = 0; $i < count($idusrs); $i++) {
            $customers .= ', :id_usr' . $i;
            $params[':id_usr' . $i] .= $idusrs[$i];
        }
        $customers = substr($customers, 1);

        $query = "SELECT DISTINCT ag.indema
      FROM anagra ag
      INNER JOIN b2b_usrana ua ON ag.tpanag = ua.tpanag AND ag.cdanag = ua.cdanag
      INNER JOIN b2b_sysusr bu ON ua.id_usr = bu.id
      WHERE bu.enabled = 1 AND bu.type = 4 AND bu.id IN ($customers)";
        return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
    }

    /**
     * Query:   SELECT
     * Return:  Array of Anagra arrays
     */
    public static function getEmailAddressForShippings()
    {
        $query = 'SELECT DISTINCT ag.indema
      FROM anagra ag
      INNER JOIN desmer dm ON ag.tpanag = dm.tpanag AND ag.cdanag = dm.cdanag
      INNER JOIN b2b_usrdsm ud ON dm.cddesm = ud.cddesm
      INNER JOIN b2b_sysusr bu ON ua.id_usr = bu.id
      WHERE bu.enabled = 1 AND bu.type = 5';
        return Di::getDefault()->get('db')->query($query)->fetchAll();
    }

    /**
     * Query:   SELECT
     * Return:  Array of Anagra arrays
     */
    public static function getEmailAddressForSelectedShippings($idusrs)
    {
        $shippings = '';
        $params = array();
        for ($i = 0; $i < count($idusrs); $i++) {
            $shippings .= ', :id_usr' . $i;
            $params[':id_usr' . $i] .= $idusrs[$i];
        }
        $shippings = substr($shippings, 1);

        $query = "SELECT DISTINCT ag.indema
      FROM anagra ag
      INNER JOIN desmer dm ON ag.tpanag = dm.tpanag AND ag.cdanag = dm.cdanag
      INNER JOIN b2b_usrdsm ud ON dm.cddesm = ud.cddesm
      INNER JOIN b2b_sysusr bu ON ua.id_usr = bu.id
      WHERE bu.enabled = 1 AND bu.type = 5' AND bu.id IN ($shippings)";
        return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
    }

    /**
     * Query:   SELECT
     * Return:  Anagra object
     */
    public static function getCustomer($tpanag, $cdanag, $idlang = 'IT')
    {
        if ($idlang != 'IT') {
            $params = array('tpanag' => $tpanag, 'cdanag' => $cdanag, 'idlang' => $idlang);
            $dstpor = "COALESCE(d1.descri,tr.dstpor,'') AS dstpor";
            $dspaga = "COALESCE(d2.descri,tg.dspaga,'') AS dspaga";
            $lnJoin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dstpor' AND d1.codic1 = tr.tpport AND d1.idlang = :idlang:
                 LEFT JOIN Go2B\Models\Deslin d2 ON d2.tpdato = 'dspaga' AND d2.codic1 = tg.tppaga AND d2.idlang = :idlang: ";
        } else {
            $params = array('tpanag' => $tpanag, 'cdanag' => $cdanag);
            $dstpor = "COALESCE(tr.dstpor,'') AS dstpor";
            $dspaga = "COALESCE(tg.dspaga,'') AS dspaga";
            $lnJoin = '';
        }

        $query = "SELECT an.tpanag, an.cdanag, an.descri, an.desvid, an.indiri,
      an.codcap, an.ccitta, an.provin, an.cdnazi, an.idlang, an.cdzona,
      an.pariva, an.codfis, an.numtel, an.numcel, an.numfax, an.intern,
      an.indema, an.indem2, an.percon, an.cdvalu, an.tpport, an.tppaga,
      an.codabi, an.codcab, an.cdiban, an.cdvett, an.cdagen, an.cdetic,
      an.uffipa, an.codupr, an.indpec, an.websit, an.newcod, an.nulist,
      COALESCE(aa.dsnazi,'') AS dsnazi, COALESCE(az.dszona,'') AS dszona, $dstpor, $dspaga,
      COALESCE(av.dsvett,'') AS dsvett, COALESCE(ag.dsagen,'') AS dsagen,
      COALESCE(ae.dsetic,'') AS dsetic, COALESCE(lt.dslist,'') AS dslist
      FROM Go2B\Models\Anagra an
      LEFT JOIN Go2B\Models\B2bUsrage ua ON ua.cdagen = an.cdagen
      LEFT JOIN Go2B\Models\Ananaz aa ON aa.cdnazi = an.cdnazi
      LEFT JOIN Go2B\Models\Anazon az ON az.cdzona = an.cdzona
      LEFT JOIN Go2B\Models\Tpport tr ON tr.tpport = an.tpport
      LEFT JOIN Go2B\Models\Tppaga tg ON tg.tppaga = an.tppaga
      LEFT JOIN Go2B\Models\Anavet av ON av.cdvett = an.cdvett
      LEFT JOIN Go2B\Models\Anaage ag ON ag.cdagen = an.cdagen
      LEFT JOIN Go2B\Models\Anaeti ae ON ae.cdetic = an.cdetic
      LEFT JOIN Go2B\Models\Lstest lt ON lt.nulist = an.nulist
      $lnJoin
      WHERE an.tpanag = :tpanag: AND an.cdanag = :cdanag:";

        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params)[0];
    }

    /**
     * Query:   SELECT
     * Return:  Anagra object
     */
    public static function getCustomerForPdf($tpanag, $cdanag, $idlang = 'IT')
    {
        if ($idlang != 'IT') {
            $params = array('tpanag' => $tpanag, 'cdanag' => $cdanag, 'idlang' => $idlang);
            $dstpor = "COALESCE(d1.descri,r.dstpor,'') AS dstpor";
            $dspaga = "COALESCE(d2.descri,g.dspaga,'') AS dspaga";
            $lnJoin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dstpor' AND d1.codic1 = r.tpport AND d1.idlang = :idlang:
                 LEFT JOIN Go2B\Models\Deslin d2 ON d2.tpdato = 'dspaga' AND d2.codic1 = g.tppaga AND d2.idlang = :idlang: ";
        } else {
            $params = array('tpanag' => $tpanag, 'cdanag' => $cdanag);
            $dstpor = "COALESCE(r.dstpor,'') AS dstpor";
            $dspaga = "COALESCE(g.dspaga,'') AS dspaga";
            $lnJoin = '';
        }

        $query = "SELECT a.tpanag, a.cdanag, a.descri, a.desvid, a.indiri, a.codcap,
      a.ccitta, a.provin, a.cdnazi, a.pariva, a.codfis, a.numtel, a.numcel, a.numfax,
      a.indema, a.indem2, a.idlang,
      COALESCE(n.dsnazi,'') AS dsnazi, COALESCE(i.dsaiva,'') AS dsaiva,
      COALESCE(i.aliquo,0) AS aliquo, a.codabi, a.codcab,
      a.scont1, a.scont2, a.scont3,
      $dstpor, $dspaga
      FROM Go2B\Models\Anagra a
      LEFT JOIN Go2B\Models\Ananaz n ON a.cdnazi = n.cdnazi
      LEFT JOIN Go2B\Models\Tpport r ON a.tpport = r.tpport
      LEFT JOIN Go2B\Models\Tppaga g ON a.tppaga = g.tppaga
      LEFT JOIN Go2B\Models\Anaiva i ON i.cdaiva = a.cdesen
      $lnJoin
      WHERE a.tpanag = :tpanag: AND a.cdanag = :cdanag: ";

        return Di::getDefault()->get('modelsManager')->executeQuery($query, $params)[0];
    }

    /**
     * Query:   SELECT
     * Return:  int
     */
    public static function getCountCustomers($withPriceList, $searchText = '')
    {
        $params = array();
        $fltNulist = '';
        if ($withPriceList) {
            $fltNulist = " AND a.nulist != 0";
        }

        $search = '';
        if ($searchText != '') {
            $search = " AND (a.cdanag LIKE :search: OR a.indema LIKE :search: OR a.descri LIKE :search:)";
            $params['search'] = '%' . $searchText . '%';
        }

        $query = "SELECT COUNT(*) AS count
      FROM Go2B\Models\Anagra a
      WHERE a.tpanag != 'CN' AND a.cdblco < 2
      $fltNulist
      $search";
        $result = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
        return $result[0]->count;
    }

    /**
     * Query:   SELECT
     * Return:  int
     */
    public static function getCountActiveCustomers()
    {
        $query = "SELECT COUNT(ag.cdanag) AS total
      FROM Go2B\Models\Anagra ag
      INNER JOIN Go2B\Models\B2bUsrana ua ON ua.tpanag = ag.tpanag AND ua.cdanag = ag.cdanag
      INNER JOIN Go2B\Models\B2bSysusr bu ON bu.id = ua.id_usr
      WHERE bu.enabled = 1 AND ag.cdblco < 2";
        $result = Di::getDefault()->get('modelsManager')->executeQuery($query);
        return count($result) > 0 ? $result[0]->total : 0;
    }

    /**
     * Query:   SELECT
     * Return:  int
     */
    public static function getCustomerPriceListCodeFromUser($id_usr)
    {
        $query = "SELECT a.nulist
      FROM Go2B\Models\Anagra a
      INNER JOIN Go2B\Models\B2bUsrana u ON u.tpanag = a.tpanag AND u.cdanag = a.cdanag
      WHERE u.id_usr = :id_usr:";
        $result = Di::getDefault()->get('modelsManager')->executeQuery($query, array('id_usr' => $id_usr));
        return count($result) > 0 ? $result[0]->nulist : 0;
    }

    /**
     * Query:   SELECT
     * Return:  int
     */
    public static function getCustomerPriceListCodeFromCustomer($tpanag, $cdanag)
    {
        $query = 'SELECT a.nulist
      FROM Go2B\Models\Anagra a
      WHERE a.tpanag = :tpanag: AND a.cdanag = :cdanag:';
        $result = Di::getDefault()->get('modelsManager')->executeQuery($query, array('tpanag' => $tpanag, 'cdanag' => $cdanag));
        return count($result) > 0 ? $result[0]->nulist : 0;
    }

    /**
     * Query:   SELECT
     * Return:  bool
     */
    public static function checkIfCustomerExists($codfis, $pariva, $cdnazi)
    {
        $query = "SELECT COUNT(a.cdanag) AS customers
      FROM Go2B\Models\Anagra a
      WHERE a.cdnazi = :cdnazi:
      AND ((a.codfis != '' AND a.codfis = :codfis:) OR (a.pariva != '' AND a.pariva = :pariva:))";
        $params = array('codfis' => $codfis, 'pariva' => $pariva, 'cdnazi' => $cdnazi);
        $result = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
        return count($result) > 0 ? $result[0]->customers : 0;
    }

    /**
     * Query:   SELECT
     * Return:  string
     */
    public static function getCustomerEmailFromUser($b2bSysusr)
    {
        $join = '';
        switch ($b2bSysusr->type) {
            case 4:
                $join .= 'INNER JOIN Go2B\Models\B2bUsrana u ON u.tpanag = a.tpanag AND u.cdanag = a.cdanag ';
                break;
            case 5:
                $join .= 'INNER JOIN Go2B\Models\Desmer d ON d.tpanag = a.tpanag AND d.cdanag = a.cdanag
                INNER JOIN Go2B\Models\B2bUsrdsm u ON u.cddesm = d.cddesm ';
                break;
        }

        $query = "SELECT a.indema
      FROM Go2B\Models\Anagra a
      $join
      WHERE u.id_usr = :id_usr: LIMIT 1";
        return Di::getDefault()->get('modelsManager')->executeQuery($query, array('id_usr' => $b2bSysusr->id))[0]->indema;
    }

    /**
     * Query:   SELECT
     * Return:  string
     */
    public static function getDefaultShippingForUser($id_usr, $idlang = 'IT')
    {
        if ($idlang != 'IT') {
            $dstpor = "COALESCE(d1.descri,t.dstpor,'') AS dstpor ";
            $lnJoin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dstpor' AND d1.codic1 = t.tpport AND d1.idlang = :idlang: ";
            $params = array('id_usr' => $id_usr, 'idlang' => $idlang);
        } else {
            $dstpor = 't.dstpor AS dstpor ';
            $lnJoin = '';
            $params = array('id_usr' => $id_usr);
        }
        $query = "SELECT $dstpor
      FROM Go2B\Models\Anagra a
      INNER JOIN Go2B\Models\Octest o ON o.tpanag = a.tpanag AND o.cdanag = a.cdanag
      INNER JOIN Go2B\Models\Tpport t ON t.tpport = a.tpport
      $lnJoin
      WHERE o.id_usr = :id_usr: AND o.flstat = 0";
        $anagra = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
        return count($anagra) > 0 ? $anagra[0]->dstpor : '';
    }

    /**
     * Query:   SELECT
     * Return:  string
     */
    public static function getDefaultShippingForCustomer($tpanag, $cdanag, $idlang = 'IT')
    {
        if ($idlang != 'IT') {
            $dstpor = "COALESCE(d1.descri,t.dstpor,'') AS dstpor ";
            $lnJoin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dstpor' AND d1.codic1 = t.tpport AND d1.idlang = :idlang: ";
            $params = array('tpanag' => $tpanag, 'cdanag' => $cdanag, 'idlang' => $idlang);
        } else {
            $dstpor = 't.dstpor AS dstpor ';
            $lnJoin = '';
            $params = array('tpanag' => $tpanag, 'cdanag' => $cdanag);
        }

        $query = "SELECT $dstpor
      FROM Go2B\Models\Anagra a
      INNER JOIN Go2B\Models\Tpport t ON t.tpport = a.tpport
      $lnJoin
      WHERE a.tpanag = :tpanag: AND a.cdanag = :cdanag:";
        $anagra = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
        return count($anagra) > 0 ? $anagra[0]->dstpor : '';
    }

    /**
     * Query:   SELECT
     * Return:  string
     */
    public static function getDefaultPaymentForUser($id_usr, $idlang = 'IT')
    {
        if ($idlang != 'IT') {
            $dspaga = "COALESCE(d1.descri,t.dspaga,'') AS dspaga ";
            $lnJoin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dspaga' AND d1.codic1 = t.tppaga AND d1.idlang = :idlang: ";
            $params = array('id_usr' => $id_usr, 'idlang' => $idlang);
        } else {
            $dspaga = 't.dspaga AS dspaga ';
            $lnJoin = '';
            $params = array('id_usr' => $id_usr);
        }

        $query = "SELECT $dspaga
      FROM Go2B\Models\Anagra a
      INNER JOIN Go2B\Models\Octest o ON o.tpanag = a.tpanag AND o.cdanag = a.cdanag
      INNER JOIN Go2B\Models\Tppaga t ON t.tppaga = a.tppaga
      $lnJoin
      WHERE o.id_usr = :id_usr: AND o.flstat = 0";

        $anagra = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
        return count($anagra) > 0 ? $anagra[0]->dspaga : '';
    }

    /**
     * Query:   SELECT
     * Return:  string
     */
    public static function getDefaultPaymentForCustomer($tpanag, $cdanag, $idlang = 'IT')
    {
        if ($idlang != 'IT') {
            $dspaga = "COALESCE(d1.descri,t.dspaga,'') AS dspaga ";
            $lnJoin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dspaga' AND d1.codic1 = t.tppaga AND d1.idlang = :idlang: ";
            $params = array('tpanag' => $tpanag, 'cdanag' => $cdanag, 'idlang' => $idlang);
        } else {
            $dspaga = 't.dspaga AS dspaga ';
            $lnJoin = '';
            $params = array('tpanag' => $tpanag, 'cdanag' => $cdanag);
        }

        $query = "SELECT $dspaga
      FROM Go2B\Models\Anagra a
      INNER JOIN Go2B\Models\Tppaga t ON t.tppaga = a.tppaga
      $lnJoin
      WHERE a.tpanag = :tpanag: AND a.cdanag = :cdanag:";

        $anagra = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
        return count($anagra) > 0 ? $anagra[0]->dspaga : '';
    }

    /**
     * Query:   SELECT
     * Return:  string
     */
    public static function getDefaultIndicativeForCustomer($tpanag, $cdanag)
    {
        $params = array('tpanag' => $tpanag, 'cdanag' => $cdanag);
        $query = 'SELECT COALESCE(t.tpindo,"") AS default_tpindo
      FROM Go2B\Models\Anagra a
      LEFT JOIN Go2B\Models\Tppaga t ON t.tppaga = a.tppaga
      WHERE a.tpanag = :tpanag: AND a.cdanag = :cdanag: ';
        $result = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);;
        return count($result) == 1 ? $result[0]->default_tpindo : '';
    }

    /**
     * Query:   SELECT
     * Return:  int
     */
    public static function getRulist($id_usr)
    {
        $query = "SELECT a.rulist
      FROM Go2B\Models\Anagra a
      INNER JOIN Go2B\Models\Octest o ON o.tpanag = a.tpanag AND o.cdanag = a.cdanag
      WHERE o.id_usr = :id_usr: AND o.flstat = 0";
        $result = Di::getDefault()->get('modelsManager')->executeQuery($query, array('id_usr' => $id_usr));
        return count($result) > 0 ? $result[0]->rulist : '';
    }

    /**
     * Query:   SELECT
     * Return:  string
     */
    public static function getDefaultTpindo($tpanag, $cdanag)
    {
        $query = "SELECT t.tpindo
      FROM Go2B\Models\Anagra a
      INNER JOIN Go2B\Models\Tppaga t ON t.tppaga = a.tppaga
      WHERE a.tpanag = :tpanag: AND a.cdanag = :cdanag:";
        $result = Di::getDefault()->get('modelsManager')->executeQuery($query, array('tpanag' => $tpanag, 'cdanag' => $cdanag));
        return count($result) > 0 ? $result[0]->tpindo : '';
    }

    /**
     * Query:   INSERT
     * Return:  void
     */
    public static function saveNewCustomer($values)
    {
        $query =
            "INSERT INTO anagra (tpanag, cdanag, descri, desvid, indiri, codcap,
      ccitta, provin, cdnazi, idlang, cdzona, pariva, codfis, numtel, numcel,
      numfax, intern, indema, indem2, percon, cdvalu, tpaggc, nulist, rulist,
      nuscon, scont1, scont2, scont3, tpport, tppaga, cdesen, codabi, codcab,
      cdiban, cdvett, cdagen, cdblco, dtblco, provvi, cddesm, dtvali, newcod,
      priori, cdetic, latitu, longit, notdes, cdage2, cdage3, cdage4, cdage5,
      indpec, uffipa, codupr, websit)
      VALUES ('CN',COALESCE((SELECT MAX(CAST(b.cdanag AS UNSIGNED)) + 1 FROM anagra b WHERE b.tpanag = 'CN'),1),
      :descri,:desvid,:indiri,:codcap,:ccitta,:provin,:cdnazi,'',:cdzona,
      :pariva,:codfis,:numtel,:numcel,:numfax,:intern,:indema,:indem2,
      '','','',:nulist,'',0,0,0,0,:tpport,:tppaga,'',:codabi,:codcab,:cdiban,
      :cdvett,:cdagen,0,'',0,'','',0,'','',0,0,'',0,0,0,0,:indpec,:uffipa,
      :codupr,:websit)";
        $params = array(
            'descri' => $values['descri'],
            'desvid' => $values['desvid'],
            'indiri' => $values['indiri'],
            'codcap' => $values['codcap'],
            'ccitta' => $values['ccitta'],
            'provin' => $values['provin'],
            'cdnazi' => $values['cdnazi'],
            'cdzona' => $values['cdzona'],
            'pariva' => $values['pariva'],
            'codfis' => $values['codfis'],
            'numtel' => $values['numtel'],
            'numcel' => $values['numcel'],
            'numfax' => $values['numfax'],
            'intern' => $values['intern'],
            'indema' => $values['indema'],
            'indem2' => $values['indem2'],
            'nulist' => $values['nulist'],
            'tpport' => $values['tpport'],
            'tppaga' => $values['tppaga'],
            'codabi' => $values['codabi'],
            'codcab' => $values['codcab'],
            'cdiban' => $values['cdiban'],
            'cdvett' => $values['cdvett'],
            'cdagen' => $values['cdagen'],
            'indpec' => $values['indpec'],
            'uffipa' => $values['uffipa'],
            'codupr' => $values['codupr'],
            'websit' => $values['websit'],
        );
        Di::getDefault()->get('db')->query($query, $params);

//        // NON SE RIESCE A REFRESHALLO!!!!
//        $anagra = new Anagra([
//            'tpanag' => 'CN',
//            'cdanag' => new RawValue("COALESCE((SELECT MAX(CAST(b.cdanag AS UNSIGNED)) + 1 FROM anagra b WHERE b.tpanag = 'CN'),1)"),
//            'descri' => $values['descri'],
//            'desvid' => $values['desvid'],
//            'indiri' => $values['indiri'],
//            'codcap' => $values['codcap'],
//            'ccitta' => $values['ccitta'],
//            'provin' => $values['provin'],
//            'cdnazi' => $values['cdnazi'],
//            'idlang' => '',
//            'cdzona' => $values['cdzona'],
//            'pariva' => $values['pariva'],
//            'codfis' => $values['codfis'],
//            'numtel' => $values['numtel'],
//            'numcel' => $values['numcel'],
//            'numfax' => $values['numfax'],
//            'intern' => $values['intern'],
//            'indema' => $values['indema'],
//            'indem2' => $values['indem2'],
//            'percon' => '',
//            'cdvalu' => '',
//            'tpaggc' => '',
//            'nulist' => $values['nulist'],
//            'rulist' => '',
//            'nuscon' => 0,
//            'scont1' => 0,
//            'scont2' => 0,
//            'scont3' => 0,
//            'tpport' => $values['tpport'],
//            'tppaga' => $values['tppaga'],
//            'cdesen' => '',
//            'codabi' => $values['codabi'],
//            'codcab' => $values['codabi'],
//            'cdiban' => $values['cdiban'],
//            'cdvett' => $values['cdvett'],
//            'cdagen' => $values['cdagen'],
//            'cdblco' => 0,
//            'dtblco' => new RawValue("''"),
//            'provvi' => 0,
//            'cddesm' => '',
//            'dtvali' => new RawValue("''"),
//            'newcod' => 0,
//            'priori' => '',
//            'cdetic' => '',
//            'latitu' => 0,
//            'longit' => 0,
//            'notdes' => new RawValue("''"),
//            'cdage2' => 0,
//            'cdage3' => 0,
//            'cdage4' => 0,
//            'cdage5' => 0,
//            'indpec' => $values['indpec'],
//            'uffippa' => $values['uffipa'],
//            'codupr' => $values['codupr'],
//            'websit' => $values['websit'],
//        ]);
//
//        if ($anagra->save() === false) {
//            return false;
//        }
//        $anagra->refresh();

        $anagra = Anagra::findFirst(
            array(
                'tpanag = "CN" AND descri = :d: AND pariva = :p: AND codfis = :c:',
                'bind' => array(
                    "d" => $values['descri'],
                    'p' => $values['pariva'],
                    'c' => $values['codfis'],
                )
            )
        );

        // Salviamo anche l'associazione tra cliente e agente nella nuova tabella agaana
        $ageana = new Ageana([
            'tipdat' => 'C',
            'cdagen' => $values['cdagen'],
            'tpanag' => $anagra->tpanag,
            'codice' => $anagra->cdanag,
        ]);

        if ($ageana->save() === false) {
            $anagra->delete();
            return false;
        }

        $utility = new Utility();
        if (strtolower($utility->getAppUtils('company')) == "koc") {

            if ($anagra instanceof Anagra) {
                do {
                    $uuid = Uuid::uuid4();
                    $result = Di::getDefault()->get('db')->query(
                        "SELECT * FROM cnv_datast WHERE tipdat = :tp AND dato01 = :d AND newdat = :dt",
                        array(
                            'tp' => "anagra.newcod",
                            'd' => "CN",
                            'dt' => $uuid->toString()
                        )
                    )->fetchAll();
                } while ($result);

                Di::getDefault()->get('db')->query(
                    "INSERT INTO cnv_datast VALUES(
                        :tpdato, :dato01, :id, '', :uuid, '', ''
                    )",
                    array(
                        "tpdato" => 'anagra.newcod',
                        "dato01" => 'CN',
                        "id" => $anagra->cdanag,
                        "uuid" => $uuid->toString()
                    )
                );

                try {
                    $sendToKoc = new ApiKOC();
                    $sendToKoc->sendNewCustomer($anagra);
                    return true;
                } catch (\Exception $e) {
                    $ageana->delete();
                    $anagra->delete();

                    Di::getDefault()->get('db')->query(
                        "DELETE FROM cnv_datast WHERE newdat = :uuid",
                        array(
                            "uuid" => $uuid->toString()
                        )
                    );
                    return $e->getMessage();
                }
            }
        }
        return true;
    }

    /**
     * Query:   UPDATE
     * Return:  void
     */
    public static function changeBlockStatus($cdanag, $banLevel)
    {
        $query = "UPDATE anagra ag
      SET ag.cdblco = :banLevel
      WHERE ag.cdanag = :cdanag";
        Di::getDefault()->get('db')->query($query, array('cdanag' => $cdanag, 'banLevel' => $banLevel));
    }

    /**
     * Query:   UPDATE
     * Return:  void
     */
    public static function blockAllCustomers()
    {
        $query = "UPDATE anagra ag
      SET ag.cdblco = 999 ";
        Di::getDefault()->get('db')->query($query);
    }

    /**
     * Query:   DELET
     * Return:  void
     */
    public static function deleteNewCustomer($cdanag)
    {
        $params = array('cdanag' => $cdanag);
        $query = "DELETE FROM anagra WHERE tpanag = 'CN' AND cdanag = :cdanag ";
        Di::getDefault()->get('db')->query($query, $params);
    }

    //endregion

    public static function existsAndUnlockedCustomer($cdanag)
    {
        $query = "SELECT cl.cdanag
            FROM Go2B\Models\Anagra cl
            WHERE cl.tpanag = 'CL'
            AND cl.cdanag = :cdanag:
            AND cl.cdblco <> 999  
            LIMIT 1";
        $result = Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdanag' => $cdanag));
        return (count($result) > 0);
    }

    /**
     * Initialize method for model.
     */
    public function initialize()
    {
        // $path = realpath('..') . '/app/config/config.ini';
        // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
        $this->setSchema($config->database->dbname);
        $this->setSource('anagra');
    }

    /**
     * Torna l'oggetto NewCustomerKOC
     *
     * @return NewCustomerKOC
     */
    public function exportToNav()
    {
        $cnvDat = Di::getDefault()->get('db')->query(
            "SELECT * FROM cnv_datast WHERE tipdat = :tp AND dato01 = :d and dato02 = :i",
            array(
                'tp' => "anagra.newcod",
                'd' => "CN",
                'i' => $this->cdanag
            )
        )->fetch();

        if ($cnvDat) {
            $uuid = $cnvDat["newdat"];
        } else {
            $u = Uuid::uuid4();
            $uuid = $u->toString();
        }

        /**@var NewCustomerKOC $customerJson */
        $customerJson = new NewCustomerKOC($this);
        $customerJson->newCustomerGuid = $uuid;

        $customerJson->address = $this->indiri;
        $customerJson->city = $this->ccitta;
        $customerJson->companyName = $this->descri;
        $customerJson->countryCode = $this->cdnazi;
        $customerJson->email = $this->indema;
        $customerJson->emailPec = $this->indpec;
        $customerJson->municipality = "";
        $customerJson->note = "";

        $pagamento = CnvDatast::findFirst(array(
            "tipdat = :t: AND newnum = :n:",
            "bind" => array(
                "t" => 'tppaga.tppaga',
                "n" => $this->tppaga
            )
        ));

        $customerJson->paymentMethodcode = ($pagamento instanceof CnvDatast ? $pagamento->dato01 : "");

        $customerJson->phone = $this->numtel;
        $customerJson->province = $this->provin;
        $customerJson->sdiCode = "";

        $spedizione = CnvDatast::findFirst(array(
            "tipdat = :t: AND newnum = :n:",
            "bind" => array(
                "t" => 'tpport.tpport',
                "n" => $this->tpport
            )
        ));

        $customerJson->shipmentMethodcode = ($spedizione instanceof CnvDatast ? $spedizione->dato01 : "");
        $customerJson->vatNo = $this->pariva;
        $customerJson->zipCode = $this->codcap;

        $codiceAgente = CnvDatast::findFirst(
            array(
                "tipdat = :tipo: and newnum = :numero:",
                "bind" => array(
                    "tipo" => "anaage.cdagen",
                    "numero" => $this->cdagen
                )
            )
        );
        $customerJson->salespersonCode = ($codiceAgente instanceof CnvDatast ? $codiceAgente->dato01 : "");

        $customerJson->CustomerNo = "";
        $customerJson->ABI = $this->codabi;
        $customerJson->CAB = $this->codcab;
        $customerJson->storeSign = "";

        $customerJson->setEtag($uuid);

        return $customerJson;
    }
}
