<?php

namespace Go2B\Models;

use Go2B\Controllers\Utility;
use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Anaart extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdarti;

  /**git
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dsarti;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdartn;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdpers;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $flbloc;

  /**
   *
   * @var string
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdcolo;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dscolo;

  /**
   *
   * @var string
   * @Column(type="string", length=10, nullable=false)
   */
  public $tpvend;

  /**
   *
   * @var string
   * @Column(type="string", length=20, nullable=false)
   */
  public $cdmisu;

  /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=false)
   */
  public $flimag;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('anaart');
  }
  //endregion

  //region Sync functions
  /**
   * Save flawlessly record
   */
  public static function safelySave($anaart) {
    $anaart->save(array(
      'cdarti' => (string)$anaart->cdarti !== '' ? (string)$anaart->cdarti : new RawValue('""'),
      'dsarti' => (string)$anaart->dsarti !== '' ? (string)$anaart->dsarti : new RawValue('""'),
      'cdartn' => (string)$anaart->cdartn !== '' ? trim((string)$anaart->cdartn) : new RawValue('""'),
      'cdpers' => (string)$anaart->cdpers !== '' ? (string)$anaart->cdpers : new RawValue('""'),
      'flbloc' => (string)$anaart->flbloc !== '' ? (string)$anaart->flbloc : 0,
      'cdcolo' => (string)$anaart->cdcolo !== '' ? (string)$anaart->cdcolo : new RawValue('""'),
      'dscolo' => (string)$anaart->dscolo !== '' ? (string)$anaart->dscolo : new RawValue('""'),
      'tpvend' => (string)$anaart->tpvend !== '' ? (string)$anaart->tpvend : new RawValue('""'),
      'cdmisu' => (string)$anaart->cdmisu !== '' ? (string)$anaart->cdmisu : new RawValue('""'),
      'flimag' => (string)$anaart->flimag !== '' ? (string)$anaart->flimag : new RawValue('""')
    ));
  }

  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg, $updateImage = true) {
    $values = array(
      'cdarti' => isset($rec->cdarti) && (string)$rec->cdarti !== '' ? (string)$rec->cdarti : new RawValue('""'),
      'dsarti' => isset($rec->dsarti) && (string)$rec->dsarti !== '' ? (string)$rec->dsarti : new RawValue('""'),
      'cdartn' => isset($rec->cdartn) && (string)$rec->cdartn !== '' ? trim((string)$rec->cdartn) : new RawValue('""'),
      'cdpers' => isset($rec->cdpers) && (string)$rec->cdpers !== '' ? (string)$rec->cdpers : new RawValue('""'),
      'flbloc' => isset($rec->flbloc) && (string)$rec->flbloc !== '' ? (string)$rec->flbloc : 0,
      'cdcolo' => isset($rec->cdcolo) && (string)$rec->cdcolo !== '' ? (string)$rec->cdcolo : new RawValue('""'),
      'dscolo' => isset($rec->dscolo) && (string)$rec->dscolo !== '' ? (string)$rec->dscolo : new RawValue('""'),
      'tpvend' => isset($rec->tpvend) && (string)$rec->tpvend !== '' ? (string)$rec->tpvend : new RawValue('""'),
      'cdmisu' => isset($rec->cdmisu) && (string)$rec->cdmisu !== '' ? (string)$rec->cdmisu : new RawValue('""'),
      'flimag' => isset($rec->flimag) && (string)$rec->flimag !== '' ? (string)$rec->flimag : new RawValue('""')
    );

    $query  = 'cdarti = :cdarti:';
    $params = array(
      'cdarti' => $values['cdarti']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $values['flimag'] = $updateImage ? $values['flimag'] : $row->flimag;

    $row->save($values);
  }
  //endregion

  //region Utility functions
  /**
   * Returns translations for dsarti and dsartn
   */
  private static function getTranslatedFields($cdarti, $idlang, &$dsarti, &$dsartn, &$lnJoin, &$params) {
    if ($idlang != 'IT') {
      $params = array('cdarti' => $cdarti, 'idlang' => $idlang);
      $dsartn = 'COALESCE(d1.descri,tp.dsartn) AS dsartn';
      $dsarti = 'COALESCE(d2.descri,aa.dsarti) AS dsarti';
      $lnJoin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = tp.cdartn AND d1.idlang = :idlang:
                 LEFT JOIN Go2B\Models\Deslin d2 ON d2.tpdato = 'dsarti' AND d2.codic1 = aa.cdarti AND d2.idlang = :idlang: ";
    } else {
      $params = array('cdarti' => $cdarti);
      $dsartn = 'tp.dsartn AS dsartn';
      $dsarti = 'aa.dsarti AS dsarti';
      $lnJoin = '';
    }
  }

  private static function getCatalogPriceSubquery() {
    return "COALESCE(
      IF(
        (SELECT COUNT(DISTINCT lc.prezzo)
        FROM Go2B\Models\Lscorp lc
        INNER JOIN Go2B\Models\Anaart aa2 ON aa2.cdarti = lc.cdarti
        INNER JOIN Go2B\Models\Tipolo tp2 ON aa2.cdartn = tp2.cdartn
        WHERE lc.nulist = :nulist: AND tp.cdartn = tp2.cdartn) = 1,

        (SELECT lc.prezzo
        FROM Go2B\Models\Lscorp lc
        INNER JOIN Go2B\Models\Anaart aa2 ON aa2.cdarti = lc.cdarti
        INNER JOIN Go2B\Models\Tipolo tp2 ON aa2.cdartn = tp2.cdartn
        WHERE lc.nulist = :nulist: AND tp.cdartn = tp2.cdartn LIMIT 1),

        IF(
          (SELECT COUNT(DISTINCT lc.prezzo)
          FROM Go2B\Models\Lscorp lc
          INNER JOIN Go2B\Models\Anaart aa2 ON aa2.cdarti = lc.cdarti
          INNER JOIN Go2B\Models\Tipolo tp2 ON aa2.cdartn = tp2.cdartn
          WHERE lc.nulist = :nulist: AND tp.cdartn = tp2.cdartn) > 1,

          (SELECT CONCAT('#',MIN(lc.prezzo),'*',MAX(lc.prezzo))
          FROM Go2B\Models\Lscorp lc
          INNER JOIN Go2B\Models\Anaart aa2 ON aa2.cdarti = lc.cdarti
          INNER JOIN Go2B\Models\Tipolo tp2 ON aa2.cdartn = tp2.cdartn
          WHERE lc.nulist = :nulist: AND tp.cdartn = tp2.cdartn),

          0
        )
      ), 0) as catalogPrice";
  }

  private static function getRetailPriceSubquery() {
    return "COALESCE(
      IF(
        (SELECT COUNT(DISTINCT lc.prezzo)
        FROM Go2B\Models\Lscorp lc
        INNER JOIN Go2B\Models\Anaart aa2 ON aa2.cdarti = lc.cdarti
        INNER JOIN Go2B\Models\Tipolo tp2 ON aa2.cdartn = tp2.cdartn
        WHERE lc.nulist = :rulist: AND tp.cdartn = tp2.cdartn) = 1,

        (SELECT lc.prezzo
        FROM Go2B\Models\Lscorp lc
        INNER JOIN Go2B\Models\Anaart aa2 ON aa2.cdarti = lc.cdarti
        INNER JOIN Go2B\Models\Tipolo tp2 ON aa2.cdartn = tp2.cdartn
        WHERE lc.nulist = :rulist: AND tp.cdartn = tp2.cdartn LIMIT 1),
      0), 0) as retailPrice";
  }

  private static function getCustomDiscountLeftJoins() {
    return
      "LEFT JOIN Go2B\Models\B2bDisbdy c1
        ON c1.numdis = :numdis: AND c1.cdtitl = tl.cdtitl AND c1.cdtitl != ''
      LEFT JOIN Go2B\Models\B2bDisbdy c2
        ON c2.numdis = :numdis: AND c2.cdtitl = '' AND c2.cdlinm = tp.cdlinm AND c2.cdlinm != '' AND c2.cdserm = ''
      LEFT JOIN Go2B\Models\B2bDisbdy c3
        ON c3.numdis = :numdis: AND c3.cdtitl = '' AND c3.cdlinm = tp.cdlinm AND c3.cdlinm != '' AND c3.cdserm = tp.cdserm AND c3.cdserm != ''
      LEFT JOIN Go2B\Models\B2bDisbdy c4
        ON c4.numdis = :numdis: AND c4.cdtitl = '' AND c4.cdlinm = '' AND c4.cdserm = '' AND c4.tpmode = tp.tpmode AND c4.tpmode != ''
      LEFT JOIN Go2B\Models\B2bDisbdy c5
        ON c5.numdis = :numdis: AND c5.cdtitl = '' AND c5.cdlinm = '' AND c5.cdserm = '' AND c5.tpmode = '' AND c5.cdartn = tp.cdartn AND c5.cdartn != ''
      LEFT JOIN Go2B\Models\B2bDisbdy c6
        ON c6.numdis = :numdis: AND c6.cdtitl = '' AND c6.cdlinm = '' AND c6.cdserm = '' AND c6.tpmode = '' AND c6.cdartn = '' AND c6.cdarti = aa.cdarti AND c6.cdarti != '' ";
  }

  private static function getCustomDiscountFields() {
    return 'COALESCE(c6.sconto,c5.sconto,c4.sconto,c3.sconto,c2.sconto,c1.sconto,0) AS cust_disc, COALESCE(c6.sconto,0) AS art_cust_disc ';
  }

  private static function getDescriptionTranslation($prefix, $idlang, &$dsarti, &$leftJoinDsarti, &$params, $lowercase = false) {
    if ($idlang != 'IT') {
      $deslinField = $lowercase ? 'deslin' : 'Go2B\Models\Deslin';
      $idlangField = $lowercase ? ':idlang' : ':idlang:';
      $dsarti = "COALESCE(d1.descri,$prefix.dsarti) AS dsarti";
      $leftJoinDsarti = "LEFT JOIN $deslinField d1 ON d1.tpdato = 'dsarti' AND d1.codic1 = $prefix.cdarti AND d1.idlang = $idlangField ";
      $params['idlang'] = $idlang;
    } else {
      $dsarti = "$prefix.dsarti AS dsarti";
      $leftJoinDsarti = '';
    }
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Anaart objects
   */
  public static function getAllArticlesForCatalog($items) {
    $params = array('cdcata' => $items['cdcata'], 'nulist' => $items['nulist']);

    $having = '';

    // Catalog price
    $catalogPrice = self::getCatalogPriceSubquery();

    // Retail price
    if ($items['rulist'] != '') {
      $retailPrice = self::getRetailPriceSubquery();
      $params['rulist'] = $items['rulist'];
    } else {
      $retailPrice = '0 AS retailPrice';
    }

    // Dsartn, dslinm, dsserm translation
    $leftJoinTransl =
      "LEFT JOIN Go2B\Models\B2bAddinf i1 ON i1.tabell = 'linmod' AND i1.codic1 = lm.cdlinm AND i1.codic2 = '' AND i1.tpdato = :tpdato:
       LEFT JOIN Go2B\Models\B2bAddinf i2 ON i2.tabell = 'sermod' AND i2.codic1 = sm.cdserm AND i2.codic2 = sm.cdlinm AND i2.tpdato = :tpdato: ";
    $params['tpdato'] = 'des_' . strtolower($items['idlang']);

    if ($items['idlang'] != 'IT') {
      $dsartn = 'COALESCE(d1.descri,tp.dsartn) AS dsartn';
      $dsarti = 'COALESCE(d2.descri,aa.dsarti) AS dsarti';
      $dslinm = 'COALESCE(i1.valore,d1.descri,lm.dslinm)';
      $dsserm = 'COALESCE(i2.valore,d1.descri,sm.dsserm)';
      $leftJoinTransl .= "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = tp.cdartn AND d1.idlang = :idlang:
                          LEFT JOIN Go2B\Models\Deslin d2 ON d2.tpdato = 'dsarti' AND d2.codic1 = aa.cdarti AND d2.idlang = :idlang: ";
      $params['idlang'] = $items['idlang'];
    } else {
      $dsartn = 'tp.dsartn AS dsartn';
      $dsarti = 'aa.dsarti AS dsarti';
      $dslinm = 'COALESCE(i1.valore,lm.dslinm)';
      $dsserm = 'COALESCE(i2.valore,sm.dsserm)';
    }

    // Presence and availability
    $presence = '';
    $isAvailable = '';
    $leftJoinArtcol = '';
    if ($items['isOrder']) {
      // Presence
      $whr1_pr = '';
      if ($items['isPT']) {
          $leftJoinArtcol = ' LEFT JOIN Go2B\Models\Artcol arcol ON arcol.cdarti = aa.cdarti ';
          // 08/01/2024 Da adeguare a Anaart::getAllArtColForCatalog() ???
//        $leftJoinArtcol = ' INNER JOIN Go2B\Models\Artcol arcol ON arcol.cdarti = aa.cdarti AND arcol.flbloc = 0 ';
        $whr1_pr = ' AND oc1.cdcolo = arcol.cdcolo ';
      }

      $params['id_usr'] = $items['idUsr'];
      $presence = ",
        COALESCE(
          (SELECT oc1.nurorc
          FROM Go2B\Models\Occorp oc1
          INNER JOIN Go2B\Models\Octest ot1 ON ot1.nuordc = oc1.nuordc
          WHERE aa.cdarti = oc1.cdarti $whr1_pr AND ot1.id_usr = :id_usr: AND ot1.flstat = 0
          LIMIT 1),
          -1) AS presence ";

      // If availability order, add is_available field
      if ($items['isAvailability']) {
        $whr1_av = '';
        $whr2_av = '';
        $whr3_av = in_array('TG', $items['filters']['contexts']) ? $items['filters']['aatgl'] : '';
        if ($items['isPT']) {
          $whr1_av = ' AND oc2.cdcolo = dc2.cdcolo AND oc2.cdvari = dc2.cdvari ';
          $whr2_av = ' AND dc2.cdcolo = arcol.cdcolo ';
        }

        $isAvailable = ",
          IF(MAX(
            COALESCE(
              (SELECT MAX(dc2.quanti -
                COALESCE(
                  (SELECT SUM(og2.quanti)
                  FROM Go2B\Models\Octagl og2
                  INNER JOIN Go2B\Models\Occorp oc2 ON oc2.nurorc = og2.nurorc
                  INNER JOIN Go2B\Models\Octest ot2 ON ot2.nuordc = oc2.nuordc
                  WHERE oc2.cdarti = dc2.cdarti $whr1_av AND ot2.flstat = 2 AND og2.dstagl = dc2.taglia), 0)
                ) AS quanti
              FROM Go2B\Models\Dscorp dc2
              WHERE dc2.cdarti = aa.cdarti $whr2_av $whr3_av),
            0)
          ) > 0, true, false) AS is_available ";

        // If parameter "show not available" is false, filter not available items
        if (!$items['showNotAvailable']) {
          $having = ' HAVING is_available = 1 ';
        }
      }
    }

    // Custom discount
    if ($items['numdis'] > 0) {
      $custDisc = self::getCustomDiscountFields();
      $leftJoinDisbdy = self::getCustomDiscountLeftJoins();
      $params['numdis'] = $items['numdis'];
    } else {
      $custDisc = '0 AS cust_disc, 0 AS art_cust_disc ';
      $leftJoinDisbdy = '';
    }

    // Sales items
    if ($items['isSales']) {
      $having .= ($having != '' ? ' AND ' : 'HAVING ') . ' (cust_disc > 0 OR art_cust_disc > 0) ';
    }

    // Section selected
    $whereSection = $items['section']['where'];
    if ($whereSection != '') {
      if (isset($items['section']['code'])) {
        $params['code'] = $items['section']['code'];
      } else if (isset($items['section']['code1']) && isset($items['section']['code2'])) {
        $params['code1'] = $items['section']['code1'];
        $params['code2'] = $items['section']['code2'];
      }
    }

    // Tag
    $innerJoinArtcla = '';
    if ($items['tag'] != '') {
      $innerJoinArtcla = 'INNER JOIN Go2B\Models\Artcla ac ON ac.tpinpu = "AN" AND ac.codice = tp.cdartn AND ac.tpclas LIKE "TB2%" AND ac.valore = :tag:' ;
      $params['tag'] = $items['tag'];
    }

    // Filters
    $innerJoinFilters = in_array('TG', $items['filters']['contexts']) ? ' INNER JOIN Go2B\Models\Postgl pt ON pt.cdtagl = tp.cdtagl ' : '';
    $innerJoinFilters .= $items['filters']['joins'];
    $whereFilters     = $items['filters']['where'];

    // Price filter
    if ($items['filters']['price'] != '') {
      $having .= ($having != '' ? ' AND ' : ' HAVING ') . $items['filters']['price'];
    }

    // Different sorting
    if ($items['isSpecialSorting']) {
      $seqrapField = "COALESCE(tpsr.valore,0) AS seqrap,";
      $leftJoinSeqrap = "LEFT JOIN Go2B\Models\B2bAddinf tpsr ON tpsr.tabell = 'tipolo' AND tpsr.codic1 = tp.cdartn AND tpsr.codic2 = '' AND tpsr.tpdato = 'seqra2' ";
      $seqrapOrder = 'seqrap';
    } else {
      $seqrapField = '';
      $leftJoinSeqrap = '';
      $seqrapOrder = 'tp.seqrap';
    }

    $query = "SELECT aa.cdarti, $dsarti, tp.cdartn, $dsartn, lm.cdtitl, tl.dstitl, tp.cdlinm,
      $dslinm AS dslinm, COALESCE(limg.valore,'') AS banner_linm, $seqrapField
      tp.cdserm, $dsserm AS dsserm, COALESCE(simg.valore,'') AS banner_serm,
      tp.tpgene, tp.tpmode, tp.cdtagl, tp.tppers, aa.flimag,
      COALESCE(im.flimag,'') AS flimg2, COUNT(ca.cdarti) AS numvariations,
      $catalogPrice, $retailPrice, $custDisc
      $presence $isAvailable
      FROM Go2B\Models\Ctarti ca
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = ca.cdarti AND aa.flbloc = 0
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn AND tp.flbloc = 0
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN Go2B\Models\Sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
      LEFT JOIN Go2B\Models\Imgart im ON im.codic1 = aa.cdarti AND im.tpimag = 'AR02'
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      LEFT JOIN Go2B\Models\B2bAddinf limg ON limg.tabell = 'linmod' AND limg.codic1 = lm.cdlinm AND limg.codic2 = '' AND limg.tpdato = 'banner'
      LEFT JOIN Go2B\Models\B2bAddinf simg ON simg.tabell = 'sermod' AND simg.codic1 = sm.cdlinm AND simg.codic2 = sm.cdserm AND simg.tpdato = 'banner'
      $innerJoinArtcla
      $innerJoinFilters
      $leftJoinDisbdy
      $leftJoinTransl
      $leftJoinArtcol
      $leftJoinSeqrap
      WHERE ca.cdcata = :cdcata:
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      $whereSection
      $whereFilters
      GROUP BY aa.cdarti
      $having
      ORDER BY lm.cdtitl, tp.cdlinm, tp.cdserm, $seqrapOrder, tp.cdartn, aa.cdarti";

    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Artcol objects
   */
  public static function getAllArtColForCatalog($items) {
    $params = array('cdcata' => $items['cdcata'], 'nulist' => $items['nulist']);

    $having = '';

    // Catalog price
    $catalogPrice = self::getCatalogPriceSubquery();

    // Retail price
    if ($items['rulist'] != '') {
      $retailPrice = self::getRetailPriceSubquery();
      $params['rulist'] = $items['rulist'];
    } else {
      $retailPrice = '0 AS retailPrice';
    }

    // Dsartn, dslinm, dsserm translation
    $leftJoinTransl =
      "LEFT JOIN Go2B\Models\B2bAddinf i1 ON i1.tabell = 'linmod' AND i1.codic1 = lm.cdlinm AND i1.codic2 = '' AND i1.tpdato = :tpdato:
       LEFT JOIN Go2B\Models\B2bAddinf i2 ON i2.tabell = 'sermod' AND i2.codic1 = sm.cdserm AND i2.codic2 = sm.cdlinm AND i2.tpdato = :tpdato: ";
    $params['tpdato'] = 'des_' . strtolower($items['idlang']);

    if ($items['idlang'] != 'IT') {
      $dsartn = 'COALESCE(d1.descri,tp.dsartn) AS dsartn';
      $dsarti = 'COALESCE(d2.descri,aa.dsarti) AS dsarti';
      $dslinm = 'COALESCE(i1.valore,d1.descri,lm.dslinm)';
      $dsserm = 'COALESCE(i2.valore,d1.descri,sm.dsserm)';
      $leftJoinTransl .= "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = tp.cdartn AND d1.idlang = :idlang:
                          LEFT JOIN Go2B\Models\Deslin d2 ON d2.tpdato = 'dsarti' AND d2.codic1 = aa.cdarti AND d2.idlang = :idlang: ";
      $params['idlang'] = $items['idlang'];
    } else {
      $dsartn = 'tp.dsartn AS dsartn';
      $dsarti = 'aa.dsarti AS dsarti';
      $dslinm = 'COALESCE(i1.valore,lm.dslinm)';
      $dsserm = 'COALESCE(i2.valore,sm.dsserm)';
    }

    // Presence and availability
    $presence = '';
    $isAvailable = '';
    $leftJoinArtcol = '';
    $whr1_pr = '';
    if ($items['isPT']) {
      $leftJoinArtcol = ' INNER JOIN Go2B\Models\Artcol arcol ON arcol.cdarti = aa.cdarti AND arcol.flbloc = 0';
      $whr1_pr = ' AND oc1.cdcolo = arcol.cdcolo ';
    }
    if ($items['isOrder']) {
      // Presence
      $params['id_usr'] = $items['idUsr'];
      $presence = ",
        COALESCE(
          (SELECT oc1.nurorc
          FROM Go2B\Models\Occorp oc1
          INNER JOIN Go2B\Models\Octest ot1 ON ot1.nuordc = oc1.nuordc
          WHERE aa.cdarti = oc1.cdarti $whr1_pr AND ot1.id_usr = :id_usr: AND ot1.flstat = 0
          LIMIT 1),
          -1) AS presence ";

      // If availability order, add is_available field
      if ($items['isAvailability']) {
        $whr1_av = '';
        $whr2_av = '';
        $whr3_av = in_array('TG', $items['filters']['contexts']) ? $items['filters']['aatgl'] : '';
        if ($items['isPT']) {
          $whr1_av = ' AND oc2.cdcolo = dc2.cdcolo AND oc2.cdvari = dc2.cdvari ';
          $whr2_av = ' AND dc2.cdcolo = arcol.cdcolo ';
        }

        $isAvailable = ",
          IF(MAX(
            COALESCE(
              (SELECT MAX(dc2.quanti -
                COALESCE(
                  (SELECT SUM(og2.quanti)
                  FROM Go2B\Models\Octagl og2
                  INNER JOIN Go2B\Models\Occorp oc2 ON oc2.nurorc = og2.nurorc
                  INNER JOIN Go2B\Models\Octest ot2 ON ot2.nuordc = oc2.nuordc
                  WHERE oc2.cdarti = dc2.cdarti $whr1_av AND ot2.flstat = 2 AND og2.dstagl = dc2.taglia), 0)
                ) AS quanti
              FROM Go2B\Models\Dscorp dc2
              WHERE dc2.cdarti = aa.cdarti $whr2_av $whr3_av),
            0)
          ) > 0, true, false) AS is_available ";

        // If parameter "show not available" is false, filter not available items
        if (!$items['showNotAvailable']) {
          $having = ' HAVING is_available = 1 ';
        }
      }
    }

    // Custom discount
    if ($items['numdis'] > 0) {
      $custDisc = self::getCustomDiscountFields();
      $leftJoinDisbdy = self::getCustomDiscountLeftJoins();
      $params['numdis'] = $items['numdis'];
    } else {
      $custDisc = '0 AS cust_disc, 0 AS art_cust_disc ';
      $leftJoinDisbdy = '';
    }

    // Sales items
    if ($items['isSales']) {
      $having .= ($having != '' ? ' AND ' : 'HAVING ') . ' (cust_disc > 0 OR art_cust_disc > 0) ';
    }

    // Section selected
    $whereSection = $items['section']['where'];
    if ($whereSection != '') {
      if (isset($items['section']['code'])) {
        $params['code'] = $items['section']['code'];
      } else if (isset($items['section']['code1']) && isset($items['section']['code2'])) {
        $params['code1'] = $items['section']['code1'];
        $params['code2'] = $items['section']['code2'];
      }
    }

    // Tag
    $innerJoinArtcla = '';
    if ($items['tag'] != '') {
      $innerJoinArtcla = 'INNER JOIN Go2B\Models\Artcla ac ON ac.tpinpu = "AN" AND ac.codice = tp.cdartn AND ac.tpclas LIKE "TB2%" AND ac.valore = :tag:' ;
      $params['tag'] = $items['tag'];
    }

    // Filters
    $innerJoinFilters = in_array('TG', $items['filters']['contexts']) ? ' INNER JOIN Go2B\Models\Postgl pt ON pt.cdtagl = tp.cdtagl ' : '';
    $innerJoinFilters .= $items['filters']['joins'];
    $whereFilters     = $items['filters']['where'];

    // Price filter
    if ($items['filters']['price'] != '') {
      $having .= ($having != '' ? ' AND ' : ' HAVING ') . $items['filters']['price'];
    }

    // Different sorting
    if ($items['isSpecialSorting']) {
      $seqrapField = "COALESCE(tpsr.valore,0) AS seqrap,";
      $leftJoinSeqrap = "LEFT JOIN Go2B\Models\B2bAddinf tpsr ON tpsr.tabell = 'tipolo' AND tpsr.codic1 = tp.cdartn AND tpsr.codic2 = '' AND tpsr.tpdato = 'seqra2' ";
      $seqrapOrder = 'seqrap';
    } else {
      $seqrapField = '';
      $leftJoinSeqrap = '';
      $seqrapOrder = 'tp.seqrap';
    }

    $query = "SELECT aa.cdarti, arcol.cdcolo as color, $dsarti, tp.cdartn, $dsartn, lm.cdtitl, tl.dstitl, tp.cdlinm,
      $dslinm AS dslinm, COALESCE(limg.valore,'') AS banner_linm, $seqrapField
      tp.cdserm, $dsserm AS dsserm, COALESCE(simg.valore,'') AS banner_serm,
      tp.tpgene, tp.tpmode, tp.cdtagl, tp.tppers, arcol.flimag,
      COALESCE(im.flimag,'') AS flimg2, COUNT(ca.cdarti) AS numvariations,
      $catalogPrice, $retailPrice, $custDisc
      $presence $isAvailable
      FROM Go2B\Models\Ctarti ca
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = ca.cdarti AND aa.flbloc = 0
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn AND tp.flbloc = 0
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN Go2B\Models\Sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
      LEFT JOIN Go2B\Models\Imgart im ON im.codic1 = aa.cdarti AND im.tpimag = 'AR02'
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      LEFT JOIN Go2B\Models\B2bAddinf limg ON limg.tabell = 'linmod' AND limg.codic1 = lm.cdlinm AND limg.codic2 = '' AND limg.tpdato = 'banner'
      LEFT JOIN Go2B\Models\B2bAddinf simg ON simg.tabell = 'sermod' AND simg.codic1 = sm.cdlinm AND simg.codic2 = sm.cdserm AND simg.tpdato = 'banner'
      $innerJoinArtcla
      $innerJoinFilters
      $leftJoinDisbdy
      $leftJoinTransl
      $leftJoinArtcol
      $leftJoinSeqrap
      WHERE ca.cdcata = :cdcata:
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      $whereSection
      $whereFilters
      GROUP BY arcol.cdcolo, aa.cdarti
      $having
      ORDER BY lm.cdtitl, tp.cdlinm, tp.cdserm, $seqrapOrder, tp.cdartn, aa.cdarti, arcol.cdcolo";

      // Di::getDefault()->get('logger')->info($query);
      // Di::getDefault()->get('logger')->info(print_r($params, true));
//      (new Utility())::dumpQuery($query, $params, true, true);

    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaart objects
   */
  public static function getAllArticlesForCatalogFromSearch($items) {
    $params = array('cdcata' => $items['cdcata'], 'nulist' => $items['nulist'], 'search' => $items['search']);

    $having = '';

    // Catalog price
    $catalogPrice = self::getCatalogPriceSubquery();

    // Retail price
    if ($items['rulist'] != '') {
      $retailPrice = self::getRetailPriceSubquery();
      $params['rulist'] = $items['rulist'];
    } else {
      $retailPrice = '0 AS retailPrice';
    }

    // Dsarti, dsartn descriptions
    $leftJoinTransl = '';
    if ($items['idlang'] != 'IT') {
      $dsartn = 'COALESCE(d1.descri,tp.dsartn) AS dsartn';
      $dsarti = 'COALESCE(d2.descri,aa.dsarti) AS dsarti';
      $dslinm = 'COALESCE(i1.valore,d1.descri,lm.dslinm)';
      $dsserm = 'COALESCE(i2.valore,d1.descri,sm.dsserm)';
      $leftJoinTransl .= "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = tp.cdartn AND d1.idlang = :idlang:
                          LEFT JOIN Go2B\Models\Deslin d2 ON d2.tpdato = 'dsarti' AND d2.codic1 = aa.cdarti AND d2.idlang = :idlang: ";
      $params['idlang'] = $items['idlang'];
    } else {
      $dsartn = 'tp.dsartn AS dsartn';
      $dsarti = 'aa.dsarti AS dsarti';
      $dslinm = 'COALESCE(i1.valore,lm.dslinm)';
      $dsserm = 'COALESCE(i2.valore,sm.dsserm)';
    }

    // Search type
    if ($items['searchType'] == 0) {
      $searchFields = '';
      $leftJoinSearchType = '';
      $andWhereSearchType = '';
    } else {
      $searchFields = ", tp.tpmode, COALESCE(tm.dstmod,'') AS dstmod, lm.dslinm, COALESCE(sm.dsserm,'') AS dsserm ";
      $leftJoinSearchType = 'LEFT JOIN Go2B\Models\Sermod sm ON tp.cdlinm = sm.cdlinm AND tp.cdserm = sm.cdserm
                             LEFT JOIN Go2B\Models\Tpmode tm ON tp.tpmode = tm.tpmode ';
      $andWhereSearchType = ' OR (tp.tpmode LIKE :search: OR dstmod LIKE :search:) OR (lm.dslinm LIKE :search: OR dsserm LIKE :search:)';

      if ($items['searchType'] == 2) {
        $searchFields .= ", COALESCE(sa.valore,'') AS bolla ";
        $leftJoinSearchType .= "LEFT JOIN Go2B\Models\Sparti sa ON aa.cdarti = sa.cdarti AND sa.tpcomp = 'BOLLA' ";
        $andWhereSearchType .= ' OR (sa.valore LIKE :search:)';
      }
    }

    // Presence
    $presence = '';
    $isAvailable = '';
    $leftJoinArtcol = '';
    if ($items['isOrder']) {
      // Presence
      $whr1_pr = '';
      if ($items['isPT']) {
        $leftJoinArtcol = ' LEFT JOIN Go2B\Models\Artcol ac ON ac.cdarti = aa.cdarti ';
        $whr1_pr = ' AND oc1.cdcolo = ac.cdcolo ';
      }

      $params['id_usr'] = $items['idUsr'];
      $presence = ",
        COALESCE(
          (SELECT oc1.nurorc
          FROM Go2B\Models\Occorp oc1
          INNER JOIN Go2B\Models\Octest ot1 ON ot1.nuordc = oc1.nuordc
          WHERE aa.cdarti = oc1.cdarti $whr1_pr AND ot1.id_usr = :id_usr: AND ot1.flstat = 0
          LIMIT 1),
          -1) AS presence ";

      // If availability order, add is_available field
      if ($items['isAvailability']) {
        $whr1_av = '';
        $whr2_av = '';
        $whr3_av = in_array('TG', $items['filters']['contexts']) ? $items['filters']['aatgl'] : '';
        if ($items['isPT']) {
          $whr1_av = ' AND oc2.cdcolo = dc2.cdcolo AND oc2.cdvari = dc2.cdvari ';
          $whr2_av = ' AND dc2.cdcolo = ac.cdcolo ';
        }

        $isAvailable = ",
          IF(MAX(
            COALESCE(
              (SELECT MAX(dc2.quanti -
                COALESCE(
                  (SELECT SUM(og2.quanti)
                  FROM Go2B\Models\Octagl og2
                  INNER JOIN Go2B\Models\Occorp oc2 ON oc2.nurorc = og2.nurorc
                  INNER JOIN Go2B\Models\Octest ot2 ON ot2.nuordc = oc2.nuordc
                  WHERE oc2.cdarti = dc2.cdarti $whr1_av AND ot2.flstat = 2 AND og2.dstagl = dc2.taglia), 0)
                ) AS quanti
              FROM Go2B\Models\Dscorp dc2
              WHERE dc2.cdarti = aa.cdarti $whr2_av $whr3_av),
            0)
          ) > 0, true, false) AS is_available ";

        // If parameter "show not available" is false, filter not available items
        if (!$items['showNotAvailable']) {
          $having = ' HAVING is_available = 1 ';
        }
      }
    }

    // Custom discount
    if ($items['numdis'] > 0) {
      $custDisc = self::getCustomDiscountFields();
      $leftJoinDisbdy = self::getCustomDiscountLeftJoins();
      $params['numdis'] = $items['numdis'];
    } else {
      $custDisc = '0 AS cust_disc, 0 AS art_cust_disc ';
      $leftJoinDisbdy = '';
    }

    // Filters
    $innerJoinFilters = in_array('TG', $items['filters']['contexts']) ? ' INNER JOIN Go2B\Models\Postgl pt ON pt.cdtagl = tp.cdtagl ' : '';
    $innerJoinFilters .= in_array('CF', $items['filters']['contexts']) ? ' INNER JOIN Go2B\Models\B2bModinf mi ON tp.cdartn = mi.cdartn ' : '';
    $innerJoinFilters .= $items['filters']['joins'];
    $whereFilters     = $items['filters']['where'];

    // Price filter
    if ($items['filters']['price'] != '') {
      $having .= ($having != '' ? ' AND ' : ' HAVING ') . $items['filters']['price'];
    }

    // Different sorting
    if ($items['isSpecialSorting']) {
      $seqrapField = "COALESCE(tpsr.valore,0) AS seqrap,";
      $leftJoinSeqrap = "LEFT JOIN Go2B\Models\B2bAddinf tpsr ON tpsr.tabell = 'tipolo' AND tpsr.codic1 = tp.cdartn AND tpsr.codic2 = '' AND tpsr.tpdato = 'seqra2' ";
      $seqrapOrder = 'seqrap';
    } else {
      $seqrapField = '';
      $leftJoinSeqrap = '';
      $seqrapOrder = 'tp.seqrap';
    }

    $query = "SELECT aa.cdarti, $dsarti, tp.cdartn, $dsartn, lm.cdtitl, tp.cdlinm, tp.cdserm,
      tp.tpgene, tp.tpmode, tp.cdtagl, tp.tppers, aa.flimag, $seqrapField
      COALESCE(im.flimag,'') AS flimg2, COUNT(ca.cdarti) AS numvariations,
      $catalogPrice, $retailPrice, $custDisc
      $searchFields $presence $isAvailable
      FROM Go2B\Models\Ctarti ca
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = ca.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      $innerJoinFilters
      LEFT JOIN Go2B\Models\Imgart im ON im.codic1 = aa.cdarti AND im.tpimag = 'AR02'
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      $leftJoinDisbdy
      $leftJoinTransl
      $leftJoinArtcol
      $leftJoinSeqrap
      $leftJoinSearchType
      WHERE ca.cdcata = :cdcata:
      AND tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      AND ((aa.cdarti LIKE :search: OR dsarti LIKE :search:) $andWhereSearchType)
      $whereFilters
      GROUP BY aa.cdarti
      $having
      ORDER BY $seqrapOrder, tp.cdartn, aa.cdarti";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaart objects
   */
  public static function getAllArtColForCatalogFromSearch($items) {
    $params = array('cdcata' => $items['cdcata'], 'nulist' => $items['nulist'], 'search' => $items['search']);

    $having = '';

    // Catalog price
    $catalogPrice = self::getCatalogPriceSubquery();

    // Retail price
    if ($items['rulist'] != '') {
      $retailPrice = self::getRetailPriceSubquery();
      $params['rulist'] = $items['rulist'];
    } else {
      $retailPrice = '0 AS retailPrice';
    }

    // Dsarti, dsartn descriptions
    $leftJoinTransl = '';
    if ($items['idlang'] != 'IT') {
      $dsartn = 'COALESCE(d1.descri,tp.dsartn) AS dsartn';
      $dsarti = 'COALESCE(d2.descri,aa.dsarti) AS dsarti';
      $dslinm = 'COALESCE(i1.valore,d1.descri,lm.dslinm)';
      $dsserm = 'COALESCE(i2.valore,d1.descri,sm.dsserm)';
      $leftJoinTransl .= "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = tp.cdartn AND d1.idlang = :idlang:
                          LEFT JOIN Go2B\Models\Deslin d2 ON d2.tpdato = 'dsarti' AND d2.codic1 = aa.cdarti AND d2.idlang = :idlang: ";
      $params['idlang'] = $items['idlang'];
    } else {
      $dsartn = 'tp.dsartn AS dsartn';
      $dsarti = 'aa.dsarti AS dsarti';
      $dslinm = 'COALESCE(i1.valore,lm.dslinm)';
      $dsserm = 'COALESCE(i2.valore,sm.dsserm)';
    }

    // Search type
    if ($items['searchType'] == 0) {
      $searchFields = '';
      $leftJoinSearchType = '';
      $andWhereSearchType = '';
    } else {
      $searchFields = ", tp.tpmode, COALESCE(tm.dstmod,'') AS dstmod, lm.dslinm, COALESCE(sm.dsserm,'') AS dsserm ";
      $leftJoinSearchType = 'LEFT JOIN Go2B\Models\Sermod sm ON tp.cdlinm = sm.cdlinm AND tp.cdserm = sm.cdserm
                             LEFT JOIN Go2B\Models\Tpmode tm ON tp.tpmode = tm.tpmode ';
      $andWhereSearchType = ' OR (tp.tpmode LIKE :search: OR dstmod LIKE :search:) OR (lm.dslinm LIKE :search: OR dsserm LIKE :search:)';

      if ($items['searchType'] == 2) {
        $searchFields .= ", COALESCE(sa.valore,'') AS bolla ";
        $leftJoinSearchType .= "LEFT JOIN Go2B\Models\Sparti sa ON aa.cdarti = sa.cdarti AND sa.tpcomp = 'BOLLA' ";
        $andWhereSearchType .= ' OR (sa.valore LIKE :search:)';
      }
    }

    // Presence
    $presence = '';
    $isAvailable = '';
    $whr1_pr = '';
    $leftJoinArtcol = '';
    if ($items['isPT']) {
      $leftJoinArtcol = ' LEFT JOIN Go2B\Models\Artcol ac ON ac.cdarti = aa.cdarti ';
      $whr1_pr = ' AND oc1.cdcolo = ac.cdcolo ';
    }
    if ($items['isOrder']) {
      // Presence

      $params['id_usr'] = $items['idUsr'];
      $presence = ",
        COALESCE(
          (SELECT oc1.nurorc
          FROM Go2B\Models\Occorp oc1
          INNER JOIN Go2B\Models\Octest ot1 ON ot1.nuordc = oc1.nuordc
          WHERE aa.cdarti = oc1.cdarti $whr1_pr AND ot1.id_usr = :id_usr: AND ot1.flstat = 0
          LIMIT 1),
          -1) AS presence ";

      // If availability order, add is_available field
      if ($items['isAvailability']) {
        $whr1_av = '';
        $whr2_av = '';
        $whr3_av = in_array('TG', $items['filters']['contexts']) ? $items['filters']['aatgl'] : '';
        if ($items['isPT']) {
          $whr1_av = ' AND oc2.cdcolo = dc2.cdcolo AND oc2.cdvari = dc2.cdvari ';
          $whr2_av = ' AND dc2.cdcolo = ac.cdcolo ';
        }

        $isAvailable = ",
          IF(MAX(
            COALESCE(
              (SELECT MAX(dc2.quanti -
                COALESCE(
                  (SELECT SUM(og2.quanti)
                  FROM Go2B\Models\Octagl og2
                  INNER JOIN Go2B\Models\Occorp oc2 ON oc2.nurorc = og2.nurorc
                  INNER JOIN Go2B\Models\Octest ot2 ON ot2.nuordc = oc2.nuordc
                  WHERE oc2.cdarti = dc2.cdarti $whr1_av AND ot2.flstat = 2 AND og2.dstagl = dc2.taglia), 0)
                ) AS quanti
              FROM Go2B\Models\Dscorp dc2
              WHERE dc2.cdarti = aa.cdarti $whr2_av $whr3_av),
            0)
          ) > 0, true, false) AS is_available ";

        // If parameter "show not available" is false, filter not available items
        if (!$items['showNotAvailable']) {
          $having = ' HAVING is_available = 1 ';
        }
      }
    }

    // Custom discount
    if ($items['numdis'] > 0) {
      $custDisc = self::getCustomDiscountFields();
      $leftJoinDisbdy = self::getCustomDiscountLeftJoins();
      $params['numdis'] = $items['numdis'];
    } else {
      $custDisc = '0 AS cust_disc, 0 AS art_cust_disc ';
      $leftJoinDisbdy = '';
    }

    // Filters
    $innerJoinFilters = in_array('TG', $items['filters']['contexts']) ? ' INNER JOIN Go2B\Models\Postgl pt ON pt.cdtagl = tp.cdtagl ' : '';
    $innerJoinFilters .= in_array('CF', $items['filters']['contexts']) ? ' INNER JOIN Go2B\Models\B2bModinf mi ON tp.cdartn = mi.cdartn ' : '';
    $innerJoinFilters .= $items['filters']['joins'];
    $whereFilters     = $items['filters']['where'];

    // Price filter
    if ($items['filters']['price'] != '') {
      $having .= ($having != '' ? ' AND ' : ' HAVING ') . $items['filters']['price'];
    }

    // Different sorting
    if ($items['isSpecialSorting']) {
      $seqrapField = "COALESCE(tpsr.valore,0) AS seqrap,";
      $leftJoinSeqrap = "LEFT JOIN Go2B\Models\B2bAddinf tpsr ON tpsr.tabell = 'tipolo' AND tpsr.codic1 = tp.cdartn AND tpsr.codic2 = '' AND tpsr.tpdato = 'seqra2' ";
      $seqrapOrder = 'seqrap';
    } else {
      $seqrapField = '';
      $leftJoinSeqrap = '';
      $seqrapOrder = 'tp.seqrap';
    }

    $query = "SELECT aa.cdarti, ac.cdcolo as color, $dsarti, tp.cdartn, $dsartn, lm.cdtitl, tp.cdlinm, tp.cdserm,
      tp.tpgene, tp.tpmode, tp.cdtagl, tp.tppers, ac.flimag, $seqrapField
      COALESCE(im.flimag,'') AS flimg2, COUNT(ca.cdarti) AS numvariations,
      $catalogPrice, $retailPrice, $custDisc
      $searchFields $presence $isAvailable
      FROM Go2B\Models\Ctarti ca
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = ca.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      $innerJoinFilters
      LEFT JOIN Go2B\Models\Imgart im ON im.codic1 = aa.cdarti AND im.tpimag = 'AR02'
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      $leftJoinDisbdy
      $leftJoinTransl
      $leftJoinArtcol
      $leftJoinSeqrap
      $leftJoinSearchType
      WHERE ca.cdcata = :cdcata:
      AND tp.flbloc = 0 AND aa.flbloc = 0 AND ac.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      AND ((aa.cdarti LIKE :search: OR dsarti LIKE :search:) $andWhereSearchType)
      $whereFilters
      GROUP BY ac.cdcolo, aa.cdarti
      $having
      ORDER BY $seqrapOrder, tp.cdartn, aa.cdarti, ac.cdcolo";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaart objects
   */
  public static function getAllArticlesForSelection($items) {
    $params = array('cdcata' => $items['cdcata'], 'cdspsl' => $items['cdspsl'], 'nulist' => $items['nulist']);

    $having = '';

    // Catalog price
    $catalogPrice = self::getCatalogPriceSubquery();

    // Retail price
    if ($items['rulist'] != '') {
      $retailPrice = self::getRetailPriceSubquery();
      $params['rulist'] = $items['rulist'];
    } else {
      $retailPrice = '0 AS retailPrice';
    }

    // Dsartn, dslinm, dsserm translation
    $leftJoinTransl =
      "LEFT JOIN Go2B\Models\B2bAddinf i1 ON i1.tabell = 'linmod' AND i1.codic1 = lm.cdlinm AND i1.codic2 = '' AND i1.tpdato = :tpdato:
       LEFT JOIN Go2B\Models\B2bAddinf i2 ON i2.tabell = 'sermod' AND i2.codic1 = sm.cdserm AND i2.codic2 = sm.cdlinm AND i2.tpdato = :tpdato: ";
    $params['tpdato'] = 'des_' . strtolower($items['idlang']);

    if ($items['idlang'] != 'IT') {
      $dsartn = 'COALESCE(d1.descri,tp.dsartn) AS dsartn';
      $dsarti = 'COALESCE(d2.descri,aa.dsarti) AS dsarti';
      $dslinm = 'COALESCE(i1.valore,d1.descri,lm.dslinm)';
      $dsserm = 'COALESCE(i2.valore,d1.descri,sm.dsserm)';
      $leftJoinTransl .= "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = tp.cdartn AND d1.idlang = :idlang:
                          LEFT JOIN Go2B\Models\Deslin d2 ON d2.tpdato = 'dsarti' AND d2.codic1 = aa.cdarti AND d2.idlang = :idlang: ";
      $params['idlang'] = $items['idlang'];
    } else {
      $dsartn = 'tp.dsartn AS dsartn';
      $dsarti = 'aa.dsarti AS dsarti';
      $dslinm = 'COALESCE(i1.valore,lm.dslinm)';
      $dsserm = 'COALESCE(i2.valore,sm.dsserm)';
    }

    // Presence and availability
    $presence = '';
    $isAvailable = '';
    $leftJoinArtcol = '';
    if ($items['isOrder']) {
      // Presence
      $whr1_pr = '';
      if ($items['isPT']) {
        $leftJoinArtcol = ' LEFT JOIN Go2B\Models\Artcol ac ON ac.cdarti = aa.cdarti ';
        $whr1_pr = ' AND oc1.cdcolo = ac.cdcolo ';
      }

      $params['id_usr'] = $items['idUsr'];
      $presence = ",
        COALESCE(
          (SELECT oc1.nurorc
          FROM Go2B\Models\Occorp oc1
          INNER JOIN Go2B\Models\Octest ot1 ON ot1.nuordc = oc1.nuordc
          WHERE aa.cdarti = oc1.cdarti $whr1_pr AND ot1.id_usr = :id_usr: AND ot1.flstat = 0
          LIMIT 1),
          -1) AS presence ";

      // If availability order, add is_available field
      if ($items['isAvailability']) {
        $whr1_av = '';
        $whr2_av = '';
        $whr3_av = in_array('TG', $items['filters']['contexts']) ? $items['filters']['aatgl'] : '';
        if ($items['isPT']) {
          $whr1_av = ' AND oc2.cdcolo = dc2.cdcolo AND oc2.cdvari = dc2.cdvari ';
          $whr2_av = ' AND dc2.cdcolo = ac.cdcolo ';
        }

        $isAvailable = ",
          IF(MAX(
            COALESCE(
              (SELECT MAX(dc2.quanti -
                COALESCE(
                  (SELECT SUM(og2.quanti)
                  FROM Go2B\Models\Octagl og2
                  INNER JOIN Go2B\Models\Occorp oc2 ON oc2.nurorc = og2.nurorc
                  INNER JOIN Go2B\Models\Octest ot2 ON ot2.nuordc = oc2.nuordc
                  WHERE oc2.cdarti = dc2.cdarti $whr1_av AND ot2.flstat = 2 AND og2.dstagl = dc2.taglia), 0)
                ) AS quanti
              FROM Go2B\Models\Dscorp dc2
              WHERE dc2.cdarti = aa.cdarti $whr2_av $whr3_av),
            0)
          ) > 0, true, false) AS is_available ";

        // If parameter "show not available" is false, filter not available items
        if (!$items['showNotAvailable']) {
          $having = ' HAVING is_available = 1 ';
        }
      }
    }

    // Custom discount
    if ($items['numdis'] > 0) {
      $custDisc = self::getCustomDiscountFields();
      $leftJoinDisbdy = self::getCustomDiscountLeftJoins();
      $params['numdis'] = $items['numdis'];
    } else {
      $custDisc = '0 AS cust_disc, 0 AS art_cust_disc ';
      $leftJoinDisbdy = '';
    }

    // Section selected
    $whereSection = $items['section']['where'];
    if ($whereSection != '') {
      if (isset($items['section']['code'])) {
        $params['code'] = $items['section']['code'];
      } else {
        $params['code1'] = $items['section']['code1'];
        $params['code2'] = $items['section']['code2'];
      }
    }

    // Filters
    $innerJoinFilters = in_array('TG', $items['filters']['contexts']) ? ' INNER JOIN Go2B\Models\Postgl pt ON pt.cdtagl = tp.cdtagl ' : '';
    $innerJoinFilters .= $items['filters']['joins'];
    $whereFilters     = $items['filters']['where'];

    // Price filter
    if ($items['filters']['price'] != '') {
      $having .= ($having != '' ? ' AND ' : ' HAVING ') . $items['filters']['price'];
    }

    $query = "SELECT aa.cdarti, $dsarti, tp.cdartn, $dsartn, lm.cdtitl, tl.dstitl, tp.cdlinm,
      $dslinm AS dslinm, '' AS banner_linm, tp.cdserm, $dsserm AS dsserm, '' AS banner_serm,
      tp.tpgene, tp.tpmode, tp.cdtagl, tp.tppers, aa.flimag,
      sc.seqrap, sc.flimag AS custom_flimag, 1 AS is_selection,
      COALESCE(im.flimag,'') AS flimg2, COUNT(ca.cdarti) AS numvariations,
      $catalogPrice, $retailPrice, $custDisc
      $presence $isAvailable
      FROM Go2B\Models\Ctarti ca
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = ca.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      INNER JOIN Go2B\Models\B2bSscorp sc ON sc.codice = aa.cdarti
      INNER JOIN Go2B\Models\B2bSstest st ON st.cdspsl = sc.cdspsl
      LEFT JOIN Go2B\Models\Sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
      LEFT JOIN Go2B\Models\Imgart im ON im.codic1 = aa.cdarti AND im.tpimag = 'AR02'
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      $innerJoinFilters
      $leftJoinDisbdy
      $leftJoinTransl
      $leftJoinArtcol
      WHERE ca.cdcata = :cdcata: AND st.cdspsl = :cdspsl: AND st.flbloc = 0
      AND tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      $whereSection
      $whereFilters
      GROUP BY aa.cdarti
      $having
      ORDER BY sc.seqrap";

    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaart objects
   */
  public static function getAllArticleColorsFromCatalog($cdcata, $items) {
    $params = array('cdcata' => $cdcata, 'tpdato' => 'des_' . strtolower($items['lang']));

    $innerJoinAnaper = '';
    $andWhere = '';
    if (isset($items['cdpers'])) {
      $params['cdpers'] = $items['cdpers'];
      $andWhere .= ' AND ap.cdpers = :cdpers: ';
      $innerJoinAnaper = 'INNER JOIN Go2B\Models\Anaper ap ON ap.cdpers = aa.cdpers ';
    }

    $join = '';
    if ($items['from'] != 'all') {
      switch ($items['from']) {
        case 'sermod':
          $params['code1'] = $items['code1'];
          $params['code2'] = $items['code2'];
          $andWhere .= ' AND tp.cdlinm = :code1: AND tp.cdserm = :code2: ';
          break;
        case 'linmod':
          $params['code'] = $items['code'];
          $andWhere .= ' AND tp.cdlinm = :code: ';
          break;
        case 'titlin':
          $params['code'] = $items['code'];
          $join = 'INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
                   INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl';
          $andWhere .= ' AND tl.cdtitl = :code: ';
          break;
      }
    }

    $query = "SELECT aa.cdcolo, aa.dscolo AS codice, COALESCE(ai.valore,aa.dscolo) AS descri
      FROM Go2B\Models\Anaart aa
      INNER JOIN Go2B\Models\Ctarti ca ON aa.cdarti = ca.cdarti
      $innerJoinAnaper
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      $join
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      LEFT JOIN Go2B\Models\B2bAddinf ai ON ai.tabell = 'dscolo' AND ai.codic1 = aa.cdcolo AND ai.codic2 = '' AND ai.tpdato = :tpdato:
      WHERE ca.cdcata = :cdcata:
      $andWhere
      AND tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      GROUP BY aa.dscolo
      ORDER BY aa.dscolo, aa.cdcolo";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaart objects
   */
  public static function getAllArticleFabricsFromCatalog($cdcata, $items) {
    $params = array('cdcata' => $cdcata, 'tpdato' => 'des_' . strtolower($items['lang']));

    $andWhere = '';
    $join = '';
    if ($items['from'] != 'all') {
      switch ($items['from']) {
        case 'sermod':
          $params['code1'] = $items['code1'];
          $params['code2'] = $items['code2'];
          $andWhere .= ' AND tp.cdlinm = :code1: AND tp.cdserm = :code2: ';
          break;
        case 'linmod':
          $params['code'] = $items['code'];
          $andWhere .= ' AND tp.cdlinm = :code: ';
          break;
        case 'titlin':
          $params['code'] = $items['code'];
          $join = 'INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
                   INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl';
          $andWhere .= ' AND tl.cdtitl = :code: ';
          break;
      }
    }

    $query = "SELECT aa.cdpers AS codice, COALESCE(ai.valore,aa.cdpers) AS descri
      FROM Go2B\Models\Anaart aa
      INNER JOIN Go2B\Models\Ctarti ca ON aa.cdarti = ca.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      $join
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      LEFT JOIN Go2B\Models\B2bAddinf ai ON ai.tabell = 'cdpers' AND ai.codic1 = aa.cdpers AND ai.codic2 = '' AND ai.tpdato = :tpdato:
      WHERE ca.cdcata = :cdcata:
      $andWhere
      AND tp.flbloc = 0 AND aa.flbloc = 0 AND aa.tpvend != 'CUSTOM' AND aa.cdpers != ''
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      GROUP BY aa.cdpers
      ORDER BY aa.cdpers";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaart objects
   */
  public static function getAllArticlesFromModel($items, $filterForNotCustoms = false) {
    $params = array(
      'cdartn' => $items['cdartn'],
      'cdcata' => $items['cdcata'],
      'nulist' => $items['nulist'],
      'id_usr' => $items['id_usr'],
      'idlang' => $items['idlang']
    );

    // Dsarti translation
    self::getDescriptionTranslation('a', $items['idlang'], $dsarti, $leftJoinDsarti, $params);

    // Custom discount
    if ($items['numdis'] > 0) {
      $custDisc = 'COALESCE(c6.sconto,0) AS cust_disc ';
      $leftJoinDisbdy = 'LEFT JOIN Go2B\Models\B2bDisbdy c6 ON c6.cdarti = a.cdarti AND c6.numdis = :numdis: ';
      $params['numdis'] = $items['numdis'];
    } else {
      $custDisc = '0 AS cust_disc ';
      $leftJoinDisbdy = '';
    }

    // Filter not customs
    $andWhere = $filterForNotCustoms ? 'AND a.tpvend != "CUSTOM" ' : '';

    // Filter not available
    $innerJoinArtcla = '';
    if ($items['filterNotAvailable']) {
      $innerJoinArtcla = 'INNER JOIN Go2B\Models\Artcla ac ON ac.tpinpu = "AR" AND ac.codice = a.cdarti AND ac.tpclas = "DISP" AND ac.valore > 0';
    }

    // Has availability flag
    $hasAvailabilityFlag = '0 AS hasAvailabilityFlag';
    $leftJoinArtcla = '';
    if ($items['showAvailabilityFlag']) {
      $hasAvailabilityFlag = 'COALESCE(ac2.valore, 0) AS hasAvailabilityFlag';
      $leftJoinArtcla = 'LEFT JOIN Go2B\Models\Artcla ac2 ON ac2.tpinpu = "AR" AND ac2.codice = a.cdarti AND ac2.tpclas = "DISP"';
    }

    // Quick Order
    $prezzo_fd = !$items['isQuickOrder'] ? "COALESCE(IF(l.taglia > '', '-1', MAX(l.prezzo)), 0) as prezzo, " : '';

    $query = "SELECT a.cdartn, a.cdarti, $dsarti, a.cdpers, a.cdcolo, a.dscolo, a.flimag,
      COALESCE(dc.descri,'') AS descomm, COALESCE(dt.descri,'') AS destecn, $hasAvailabilityFlag, $custDisc, $prezzo_fd
      COALESCE(
        (SELECT MAX(c.nurorc)
        FROM Go2B\Models\Occorp c
        INNER JOIN Go2B\Models\Octest t ON t.nuordc = c.nuordc
        WHERE a.cdarti = c.cdarti AND t.id_usr = :id_usr: AND t.flstat = 0),
        -1) AS presence
      FROM Go2B\Models\Anaart a
      INNER JOIN Go2B\Models\Ctarti c ON c.cdarti = a.cdarti
      $innerJoinArtcla
      $leftJoinArtcla
      LEFT JOIN Go2B\Models\Lscorp l ON a.cdarti = l.cdarti AND l.nulist = :nulist:
      LEFT JOIN Go2B\Models\Desart dc ON dc.tpinpu = 'AR' AND dc.codice = a.cdarti AND dc.tpdesc = 'COMM' AND dc.idlang = :idlang:
      LEFT JOIN Go2B\Models\Desart dt ON dt.tpinpu = 'AR' AND dt.codice = a.cdarti AND dt.tpdesc = 'TECN' AND dt.idlang = :idlang:
      $leftJoinDisbdy
      $leftJoinDsarti
      WHERE a.cdartn = :cdartn: AND a.flbloc = 0 AND c.cdcata = :cdcata:
      $andWhere
      GROUP BY a.cdarti
      ORDER BY a.cdarti";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaart objects
   */
  public static function getAllAvailabileArticlesForModelDetailStyle2($items) {
    $params = array('cdcata' => $items['cdcata'], 'cdartn' => $items['cdartn'], 'nulist' => $items['nulist'], 'idlang' => $items['idlang'], 'id_usr' => $items['id_usr']);

    // Dsarti translation
    self::getDescriptionTranslation('a', $items['idlang'], $dsarti, $leftJoinDsarti, $params);

    if ($items['numdis'] > 0) {
      $custDisc = 'COALESCE(c6.sconto,0) AS cust_disc, ';
      $leftJoinDisbdy = 'LEFT JOIN Go2B\Models\B2bDisbdy c6 ON c6.cdarti = a.cdarti AND c6.numdis = :numdis: ';
      $params['numdis'] = $items['numdis'];
    } else {
      $leftJoinDisbdy = '';
      $custDisc = '0 AS cust_disc, ';
    }

    if (in_array($items['modelDetailStyle'], [1, 6, 7, 8, 9])) {
      switch ($items['colorAssignmentSource']) {
        case 0:
          $codice = 'dscolo';
          break;
        case 1:
        case 2:
        default:
          $codice = 'cdcolo';
          break;
      }
      $leftJoinColors = "LEFT JOIN Go2B\Models\B2bColors bc ON a.$codice = bc.codice";
      $colors = "a.$codice AS col_codice, COALESCE(bc.rgbcd1,'') AS col_rgbcd1, COALESCE(bc.rgbcd2,'') AS col_rgbcd2,
        COALESCE(bc.rgbcd3,'') AS col_rgbcd3, COALESCE(bc.flimag,'') AS col_flimag, COALESCE(bc.flmult, 0) AS col_flmult,";
    } else {
      $colors = '';
      $leftJoinColors = '';
    }

    $query = "SELECT a.cdarti, $dsarti, a.cdpers, a.cdcolo, a.dscolo, a.flimag,
      COALESCE(dc.descri,'') AS descom, COALESCE(dt.descri,'') AS destec, $custDisc
      $colors
      COALESCE(IF(l.taglia > '', -1, MAX(l.prezzo)), 0) as prezzo,
      COALESCE((SELECT MAX(c.nurorc) FROM Go2B\Models\Occorp c
        INNER JOIN Go2B\Models\Octest t ON t.nuordc = c.nuordc
        WHERE a.cdarti = c.cdarti AND t.id_usr = :id_usr: AND t.flstat = 0),-1) AS presence,
      COALESCE((SELECT SUM(c.quanti) FROM Go2B\Models\Occorp c
        INNER JOIN Go2B\Models\Octest t ON t.nuordc = c.nuordc
        WHERE a.cdarti = c.cdarti AND t.id_usr = :id_usr: AND t.flstat = 0),-1) AS quantity,
      IF(MAX(
        COALESCE(
          (SELECT MAX(dc2.quanti -
            COALESCE(
              (SELECT SUM(og2.quanti)
              FROM Go2B\Models\Octagl og2
              INNER JOIN Go2B\Models\Occorp oc2 ON oc2.nurorc = og2.nurorc
              INNER JOIN Go2B\Models\Octest ot2 ON ot2.nuordc = oc2.nuordc
              WHERE oc2.cdarti = dc2.cdarti AND oc2.cdcolo = dc2.cdcolo AND ot2.flstat = 2 AND og2.dstagl = dc2.taglia), 0)
            ) AS quanti
          FROM Go2B\Models\Dscorp dc2
          WHERE dc2.cdarti = a.cdarti AND dc2.cdcolo = ac.cdcolo),
        0)
      ) > 0, true, false) AS is_available
      FROM Go2B\Models\Ctarti c
      INNER JOIN Go2B\Models\Anaart a ON a.cdarti = c.cdarti
      INNER JOIN Go2B\Models\Artcol ac ON a.cdarti = ac.cdarti
      $leftJoinColors
      LEFT JOIN Go2B\Models\Desart dc ON a.cdarti = dc.codice AND dc.tpinpu = 'AR' AND dc.idlang = :idlang: AND dc.tpdesc = 'COMM'
      LEFT JOIN Go2B\Models\Desart dt ON a.cdarti = dt.codice AND dt.tpinpu = 'AR' AND dt.idlang = :idlang: AND dt.tpdesc = 'TECN'
      LEFT JOIN Go2B\Models\Lscorp l ON a.cdarti = l.cdarti AND l.nulist = :nulist:
      $leftJoinDsarti
      $leftJoinDisbdy
      WHERE c.cdcata = :cdcata: AND a.cdartn = :cdartn: AND a.flbloc = 0
      GROUP BY a.cdarti
      HAVING is_available = 1
      ORDER BY a.cdarti";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaart objects
   */
  public static function getAllArticlesForModelDetail($items) {
    $params = array('cdcata' => $items['cdcata'], 'cdartn' => $items['cdartn'], 'nulist' => $items['nulist'], 'idlang' => $items['idlang'], 'id_usr' => $items['id_usr']);

    // Dsarti translation
    self::getDescriptionTranslation('a', $items['idlang'], $dsarti, $leftJoinDsarti, $params);

    if ($items['numdis'] > 0) {
      $custDisc = 'COALESCE(c6.sconto,0) AS cust_disc, ';
      $leftJoinDisbdy = 'LEFT JOIN Go2B\Models\B2bDisbdy c6 ON c6.cdarti = a.cdarti AND c6.numdis = :numdis: ';
      $params['numdis'] = $items['numdis'];
    } else {
      $leftJoinDisbdy = '';
      $custDisc = '0 AS cust_disc, ';
    }

    if (in_array($items['modelDetailStyle'], [1, 6, 7, 8, 9])) {
      switch ($items['colorAssignmentSource']) {
        case 0:
          $codice = 'dscolo';
          break;
        case 1:
        case 2:
        default:
          $codice = 'cdcolo';
          break;
      }
      $leftJoinColors = "LEFT JOIN Go2B\Models\B2bColors bc ON a.$codice = bc.codice";
      $colors = "a.$codice AS col_codice, COALESCE(bc.rgbcd1,'') AS col_rgbcd1, COALESCE(bc.rgbcd2,'') AS col_rgbcd2,
        COALESCE(bc.rgbcd3,'') AS col_rgbcd3, COALESCE(bc.flimag,'') AS col_flimag, COALESCE(bc.flmult, 0) AS col_flmult,";
    } else {
      $colors = '';
      $leftJoinColors = '';
    }

    // TODO fix problema [gdm] degli occorp con cdcolo che incasinano gli ordini sul gestionale
    // se vogliamo intervenire a livello di occorp dobbiamo rimuove a.cdcolo da questa query
    $query = "SELECT a.cdarti, $dsarti, a.cdpers, a.cdcolo, a.dscolo, a.flimag,
      COALESCE(dc.descri,'') AS descom, COALESCE(dt.descri,'') AS destec,
      COALESCE(ai.codic2,'') AS dtdrop, $custDisc
      $colors
      COALESCE(IF(l.taglia > '', -1, MAX(l.prezzo)), 0) as prezzo,
      COALESCE((SELECT MAX(c.nurorc) FROM Go2B\Models\Occorp c
        INNER JOIN Go2B\Models\Octest t ON t.nuordc = c.nuordc
        WHERE a.cdarti = c.cdarti AND t.id_usr = :id_usr: AND t.flstat = 0),-1) AS presence,
      COALESCE((SELECT SUM(c.quanti) FROM Go2B\Models\Occorp c
        INNER JOIN Go2B\Models\Octest t ON t.nuordc = c.nuordc
        WHERE a.cdarti = c.cdarti AND t.id_usr = :id_usr: AND t.flstat = 0),-1) AS quantity
      FROM Go2B\Models\Ctarti c
      INNER JOIN Go2B\Models\Anaart a ON a.cdarti = c.cdarti
      $leftJoinColors
      LEFT JOIN Go2B\Models\Desart dc ON a.cdarti = dc.codice AND dc.tpinpu = 'AR' AND dc.idlang = :idlang: AND dc.tpdesc = 'COMM'
      LEFT JOIN Go2B\Models\Desart dt ON a.cdarti = dt.codice AND dt.tpinpu = 'AR' AND dt.idlang = :idlang: AND dt.tpdesc = 'TECN'
      LEFT JOIN Go2B\Models\Lscorp l ON a.cdarti = l.cdarti AND l.nulist = :nulist:
      LEFT JOIN Go2B\Models\B2bAddinf ai ON ai.tabell = 'anaart' AND ai.codic1 = a.cdarti AND ai.tpdato = 'dtmcli'
      $leftJoinDsarti
      $leftJoinDisbdy
      WHERE c.cdcata = :cdcata: AND a.cdartn = :cdartn: AND a.flbloc = 0
      GROUP BY a.cdarti
      ORDER BY a.cdarti";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaart objects
   */
  public static function getAllArticlesForCurrentFabric($items) {
    $params = array('cdcata' => $items['cdcata'], 'cdarti' => $items['cdarti'], 'nulist' => $items['nulist'], 'idlang' => $items['idlang'], 'id_usr' => $items['id_usr']);

    // Dsarti translation
    self::getDescriptionTranslation('a', $items['idlang'], $dsarti, $leftJoinDsarti, $params);

    $query = "SELECT a.cdarti, $dsarti, a.cdpers, a.cdcolo, a.dscolo, a.flimag,
      COALESCE(IF(l.taglia > '', -1, MAX(l.prezzo)), 0) as prezzo,
      COALESCE((SELECT MAX(c.nurorc) FROM Go2B\Models\Occorp c
        INNER JOIN Go2B\Models\Octest t ON t.nuordc = c.nuordc
        WHERE a.cdarti = c.cdarti AND t.id_usr = :id_usr: AND t.flstat = 0),-1) AS presence,
      COALESCE((SELECT SUM(c.quanti) FROM Go2B\Models\Occorp c
        INNER JOIN Go2B\Models\Octest t ON t.nuordc = c.nuordc
        WHERE a.cdarti = c.cdarti AND t.id_usr = :id_usr: AND t.flstat = 0),-1) AS quantity
      FROM Go2B\Models\Ctarti c
      INNER JOIN Go2B\Models\Anaart a ON a.cdarti = c.cdarti
      LEFT JOIN Go2B\Models\Lscorp l ON a.cdarti = l.cdarti AND l.nulist = :nulist:
      $leftJoinDsarti
      WHERE c.cdcata = :cdcata: AND a.cdpers = (SELECT aa.cdpers FROM Go2B\Models\Anaart aa WHERE aa.cdarti = :cdarti:) AND a.cdarti != :cdarti: AND a.flbloc = 0
      GROUP BY a.cdarti
      ORDER BY a.cdarti";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaart objects
   */
  public static function getAllCustomArticlesFromModel($cdartn, $id_usr) {
    $params = array('cdartn' => $cdartn, 'id_usr' => $id_usr);

    $query = "SELECT a.cdartn, a.cdarti, a.dsarti, a.cdpers, a.cdcolo, a.dscolo, a.flimag,
      COALESCE(
        (SELECT MAX(c.nurorc)
        FROM Go2B\Models\Occorp c
        INNER JOIN Go2B\Models\Octest t ON t.nuordc = c.nuordc
        WHERE a.cdarti = c.cdarti AND t.id_usr = :id_usr: AND t.flstat = 0),
        -1) AS presence
      FROM Go2B\Models\Anaart a
      WHERE a.cdartn = :cdartn: AND a.flbloc = 0 AND a.tpvend = 'CUSTOM'
      GROUP BY a.cdarti
      ORDER BY CAST(a.dsarti AS UNSIGNED)";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaart objects
   */
  public static function getAllCustomArticles($onlySpecial = false) {
    $params = array();

    $innerJoinFilter = '';
    if ($onlySpecial) {
      $innerJoinFilter = "
        INNER JOIN Go2B\Models\Occorp oc ON a.cdarti = oc.cdarti
        INNER JOIN Go2B\Models\Octest ot ON oc.nuordc = ot.nuordc
        INNER JOIN Go2B\Models\B2bUsrage ua ON ot.id_usr = ua.id_usr
        INNER JOIN Go2B\Models\B2bAddinf ai ON ai.tabell = 'anaage' AND ai.codic1 = ua.cdagen AND ai.codic2 = '' AND ai.tpdato = 'fldfbh' AND ai.valore = 1 ";
    }

    $query = "SELECT a.cdartn, a.cdarti, a.dsarti,
      COALESCE(
        (SELECT COUNT(t.nuordc)
        FROM Go2B\Models\Octest t
        INNER JOIN Go2B\Models\Occorp c ON t.nuordc = c.nuordc
        WHERE a.cdarti = c.cdarti),
        0) AS presence
      FROM Go2B\Models\Anaart a
      $innerJoinFilter
      WHERE a.tpvend = 'CUSTOM' AND a.flbloc = 0
      GROUP BY a.cdarti
      ORDER BY CAST(a.dsarti AS UNSIGNED)";

    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaart objects
   */
  public static function getAllCustomArticlesWithOrderQuantities() {
    $query = "SELECT a.cdartn, a.cdarti, a.dsarti,
      COALESCE(
        (SELECT COUNT(t.nuordc)
        FROM Go2B\Models\Octest t
        INNER JOIN Go2B\Models\Occorp c ON t.nuordc = c.nuordc
        WHERE a.cdarti = c.cdarti),
        0) AS presence
      FROM Go2B\Models\Anaart a
      INNER JOIN Go2B\Models\Occorp oc ON oc.cdarti = a.cdarti
      WHERE a.tpvend = 'CUSTOM' AND a.flbloc = 0 AND oc.quanti > 0
      GROUP BY a.cdarti
      ORDER BY CAST(a.dsarti AS UNSIGNED)";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaart objects
   */
  public static function getAllCustomArticlesWithoutOrderQuantities() {
    $query = "SELECT
            a.*, COALESCE(SUM(oc.quanti), 0) quantita_ordinate
        FROM
            anaart a
        LEFT JOIN occorp oc ON
            oc.cdarti = a.cdarti
        WHERE
            a.tpvend = 'CUSTOM'
            AND a.flbloc = 0
        GROUP BY
            a.cdarti
        HAVING 
            quantita_ordinate = 0
        ORDER BY
           a.cdarti";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaart objects
   */
  public static function getAllArticles() {
    $query = 'SELECT t.cdartn, t.dsartn, a.cdarti, a.dsarti
      FROM Go2B\Models\Anaart a
      INNER JOIN Go2B\Models\Tipolo t ON a.cdartn = t.cdartn
      ORDER BY t.cdartn, a.cdarti';
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaart objects
   */
  public static function getAllArticlesForPromo($cdprom) {
    if (!empty($cdprom)) {
      $presPvcorp = 'COALESCE((SELECT COUNT(c.cdarti) FROM Go2B\Models\Pvcorp c WHERE c.cdarti = a.cdarti AND c.cdprom = :cdprom:), 0) AS presPvcorp';
      $presPvgrup = 'COALESCE((SELECT COUNT(g.cdarti) FROM Go2B\Models\Pvgrup g WHERE g.cdarti = a.cdarti AND g.cdprom = :cdprom:), 0) AS presPvgrup';
      $params = array('cdprom' => $cdprom);
    } else {
      $presPvcorp = '0 AS presPvcorp';
      $presPvgrup = '0 AS presPvgrup';
      $params = array();
    }
    $query = "SELECT a.cdarti, a.dsarti, $presPvcorp, $presPvgrup
      FROM Go2B\Models\Anaart a
      ORDER BY a.cdarti";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaart objects
   */
  public static function getCompleteArticle($cdarti, $cdcata, $nulist, $numdis, $idlang = 'IT', $isCompact = false) {
    $params = array('cdcata' => $cdcata, 'cdarti' => $cdarti, 'nulist' => $nulist, 'idlang' => $idlang);

    if ($idlang != 'IT') {
      $dsartn = 'COALESCE(d1.descri,tp.dsartn) AS dsartn';
      $dsarti = 'COALESCE(d2.descri,aa.dsarti) AS dsarti';
      $dslinm = 'COALESCE(d3.descri,lm.dslinm) AS dslinm';
      $lnJoin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = tp.cdartn AND d1.idlang = :idlang:
                 LEFT JOIN Go2B\Models\Deslin d2 ON d2.tpdato = 'dsarti' AND d2.codic1 = aa.cdarti AND d2.idlang = :idlang:
                 LEFT JOIN Go2B\Models\Deslin d3 ON d3.tpdato = 'dslinm' AND d3.codic1 = tp.cdlinm AND d3.idlang = :idlang: ";
    } else {
      $dsartn = 'tp.dsartn AS dsartn';
      $dsarti = 'aa.dsarti AS dsarti';
      $dslinm = 'lm.dslinm AS dslinm';
      $lnJoin = '';
    }

    $composition    = '';
    $leftJoinAnaper = '';
    if ($isCompact){
      // Di::getDefault()->get('logger')->info('isCompact == true');
      $composition    = "ap.compos,";
      $leftJoinAnaper = "LEFT JOIN Go2B\Models\Anaper ap ON aa.cdpers = ap.cdpers ";
    }

    if ($numdis > 0) {
      $custDisc = self::getCustomDiscountFields();
      $leftJoinDisbdy = self::getCustomDiscountLeftJoins();
      $params['numdis'] = $numdis;
    } else {
      $custDisc = '0 AS cust_disc';
      $leftJoinDisbdy = '';
    }

    $query = "SELECT aa.cdarti, $dsarti, tp.cdartn, $dsartn, aa.cdpers, $composition tl.cdtitl,
      tl.dstitl, tp.cdlinm, $dslinm, tp.cdserm, sm.dsserm, tp.tpgene, tg.dsgene,
      tp.tpmode, tm.dstmod, tp.cdtagl, tp.tppers, aa.flimag, tp.flvide,
      COALESCE(dc1.descri,dc2.descri,'') AS descom, COALESCE(dt1.descri,dt2.descri,'') AS destec,
      IFNULL(dd.descri,'') AS descmp, IFNULL(dm.descri,'') AS desmad,
      COALESCE(ai.codic2,'') AS dtdrop,
      COALESCE(IF(lc.taglia > '', -1, MAX(lc.prezzo)), 0) as prezzo,
      $custDisc, tp.tglini, tp.tglfin
      FROM Go2B\Models\Anaart aa
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      LEFT JOIN Go2B\Models\Lscorp lc ON aa.cdarti = lc.cdarti AND lc.nulist = :nulist:
      LEFT JOIN Go2B\Models\Sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm
      LEFT JOIN Go2B\Models\Tpgene tg ON tg.tpgene = tp.tpgene
      LEFT JOIN Go2B\Models\Tpmode tm ON tm.tpmode = tp.tpmode
      LEFT JOIN Go2B\Models\Desart dc1 ON aa.cdarti = dc1.codice AND dc1.tpinpu = 'AR' AND dc1.idlang = :idlang: AND dc1.tpdesc = 'COMM'
      LEFT JOIN Go2B\Models\Desart dc2 ON tp.cdartn = dc2.codice AND dc2.tpinpu = 'AN' AND dc2.idlang = :idlang: AND dc2.tpdesc = 'COMM'
      LEFT JOIN Go2B\Models\Desart dt1 ON aa.cdarti = dt1.codice AND dt1.tpinpu = 'AR' AND dt1.idlang = :idlang: AND dt1.tpdesc = 'TECN'
      LEFT JOIN Go2B\Models\Desart dt2 ON tp.cdartn = dt2.codice AND dt2.tpinpu = 'AN' AND dt2.idlang = :idlang: AND dt2.tpdesc = 'TECN'
      LEFT JOIN Go2B\Models\Desart dd ON tp.cdartn = dd.codice AND dd.tpinpu = 'AN' AND dd.idlang = '' AND dd.tpdesc = 'COMD'
      LEFT JOIN Go2B\Models\Desart dm ON tp.cdartn = dm.codice AND dm.tpinpu = 'AN' AND dm.idlang = '' AND dm.tpdesc = 'MADE'
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      LEFT JOIN Go2B\Models\B2bAddinf ai ON ai.tabell = 'anaart' AND ai.codic1 = aa.cdarti AND ai.tpdato = 'dtmcli'
      $lnJoin
      $leftJoinAnaper
      $leftJoinDisbdy
      WHERE aa.cdarti LIKE :cdarti: AND aa.flbloc = 0 AND tp.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      GROUP BY aa.cdarti";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaart objects
   */
  public static function getArticleColors($codice) {
    $query = "SELECT DISTINCT aa.$codice AS codice,
      COALESCE(bc.rgbcd1,'') AS rgbcd1, COALESCE(bc.rgbcd2,'') AS rgbcd2,
      COALESCE(bc.rgbcd3,'') AS rgbcd3, COALESCE(bc.flimag,'') AS flimag,
      COALESCE(bc.flmult, 0) AS flmult
      FROM Go2B\Models\Anaart aa
      LEFT JOIN Go2B\Models\B2bColors bc ON aa.$codice = bc.codice
      ORDER BY aa.$codice";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaart arrays
   */
  public static function getArticlesFromModel($cdartn, $cdcata) {
    $params = array('cdcata' => $cdcata, 'cdarti' => $cdarti);

    if ($idlang != 'IT') {
      $dsarti = 'COALESCE(d1.descri,aa.dsarti) AS dsarti';
      $lnJoin = "LEFT JOIN deslin d1 ON d1.tpdato = 'dsarti' AND d1.codic1 = aa.cdarti AND d2.idlang = :idlang ";
      $params['idlang'] = $idlang;
    } else {
      $dsarti = 'aa.dsarti AS dsarti';
      $lnJoin = '';
    }

    $query = "SELECT aa.cdarti, $dsarti, aa.flimag
      FROM anaart aa
      INNER JOIN ctarti ca ON aa.cdarti = ca.cdarti
      $lnJoin
      WHERE aa.cdartn = :cdartn AND aa.flbloc = 0 AND ca.cdcata = :cdcata";
    return Di::getDefault()->get('db')->query($query, array('cdarti' => (string)$cdarti, 'cdcata' => (string)$cdcata))->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaart objects
   */
  public static function getArticleCodesFromBrand($cdtitl) {
    $query = 'SELECT a.cdarti
      FROM Go2B\Models\Anaart a
      INNER JOIN Go2B\Models\Tipolo t ON a.cdartn = t.cdartn
      INNER JOIN Go2B\Models\Linmod l ON t.cdlinm = l.cdlinm
      WHERE l.cdtitl = :cdtitl:';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdtitl' => $cdtitl));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaart objects
   */
  public static function getArticleCodesFromLine($cdlinm) {
    $query = 'SELECT a.cdarti
      FROM Go2B\Models\Anaart a
      INNER JOIN Go2B\Models\Tipolo t ON a.cdartn = t.cdartn
      WHERE t.cdlinm = :cdlinm:';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdlinm' => $cdlinm));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaart objects
   */
  public static function getArticleCodesFromSeries($cdlinm, $cdserm) {
    $query = 'SELECT a.cdarti
      FROM Go2B\Models\Anaart a
      INNER JOIN Go2B\Models\Tipolo t ON a.cdartn = t.cdartn
      WHERE t.cdlinm = :cdlinm: AND t.cdserm = :cdserm:';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdlinm' => $cdlinm, 'cdserm' => $cdserm));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaart objects
   */
  public static function getArticleCodesFromModel($cdartn) {
    $query = 'SELECT a.cdarti
      FROM Go2B\Models\Anaart a
      INNER JOIN Go2B\Models\Tipolo t ON a.cdartn = t.cdartn
      WHERE t.cdartn = :cdartn:';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdartn' => $cdartn));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaart objects
   */
  public static function getAllArticlesFromCatalog($cdcata = '', $cdstag = '') {
    if ($cdcata != '') {
      $params = array('cdcata' => $cdcata);
      $where  = 'WHERE aa.cdarti NOT IN (
        SELECT ca.cdarti
        FROM Go2B\Models\Ctarti ca
        WHERE ca.cdcata = :cdcata:
        AND ca.cdarti IS NOT NULL) ';
    } else {
      $where  = '';
      $params = array();
    }

    $seasonJoin = '';
    if ($cdstag != '') {
      $where .= $where != '' ? ' AND ' : ' WHERE ';
      $where .= ' ct.cdstag = :cdstag: ';
      $seasonJoin = 'INNER JOIN Go2B\Models\Ctarti ca ON aa.cdarti = ca.cdarti
        INNER JOIN Go2B\Models\Cttest ct ON ct.cdcata = ca.cdcata';
      $params['cdstag'] = $cdstag;
    }

    // articles
    $query = "SELECT aa.cdarti, aa.dsarti, tp.cdartn, tp.dsartn, lm.cdlinm,
      COALESCE(sm.cdserm,'') AS cdserm, tl.cdtitl
      FROM Go2B\Models\Anaart aa
      $seasonJoin
      INNER JOIN Go2B\Models\Tipolo tp ON aa.cdartn = tp.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON tp.cdlinm = lm.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON lm.cdtitl = tl.cdtitl
      LEFT JOIN Go2B\Models\Sermod sm ON tp.cdlinm = sm.cdlinm AND tp.cdserm = sm.cdserm
      $where
      ORDER BY tl.cdtitl, lm.seqrap, lm.cdlinm, tp.cdartn";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaart objects
   */
  public static function getArticlesAndRules($whereCatalogs, $whereLines, $params) {
    $where = $whereCatalogs != '' ? "WHERE ca.cdcata IN ($whereCatalogs) " : '';
    if ($whereLines != '') {
      $where .= ($whereCatalogs != '' ? "AND " : "WHERE ") . " tp.cdlinm IN ($whereLines)";
    }

    $query = "SELECT DISTINCT aa.cdarti AS code, aa.dsarti AS description,
      COALESCE(ra.qtamin,1) AS ra_qtamin, COALESCE(ra.qtamul,1) AS ra_qtamul, COALESCE(ra.qtamax,0) AS ra_qtamax,
      COALESCE(rm.qtamin,1) AS rm_qtamin, COALESCE(rm.qtamul,1) AS rm_qtamul
      FROM Go2B\Models\Anaart aa
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON ca.cdarti = aa.cdarti
      LEFT JOIN Go2B\Models\Regqta ra ON ra.cdarti = aa.cdarti AND ra.cdcolo = '' AND ra.taglia = ''
      LEFT JOIN Go2B\Models\Regqtm rm ON rm.cdarti = aa.cdarti AND rm.cdcolo = ''
      $where";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaart objects
   */
  public static function getArticlesWithDiscountFromCatalogs($whereCatalogs, $params) {
    $query = "SELECT DISTINCT aa.cdarti, aa.dsarti, aa.cdartn, tp.dsartn, COALESCE(cb.sconto,0) AS sconto
      FROM Go2B\Models\Anaart aa
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON ca.cdarti = aa.cdarti
      LEFT JOIN Go2B\Models\B2bDisbdy cb ON cb.cdarti = aa.cdarti AND cb.numdis = :numdis:
      WHERE ca.cdcata IN ($whereCatalogs)";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaart objects
   */
  public static function getArticlesFromLookbook($cdlkbk) {
    $query = 'SELECT aa.cdarti, aa.dsarti, aa.cdartn, tp.cdlinm, tp.cdserm
      FROM Go2B\Models\Anaart aa
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON aa.cdarti = ca.cdarti
      INNER JOIN Go2B\Models\Cttest ct ON ca.cdcata = ct.cdcata
      INNER JOIN Go2B\Models\Lktest lt ON ct.cdcata = lt.cdcata
      WHERE lt.cdlkbk = :cdlkbk:
      GROUP BY aa.cdarti
      ORDER BY tp.cdlinm, tp.cdserm, aa.cdartn, aa.cdarti';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdlkbk' => $cdlkbk));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaart objects
   */
  public static function getLardiniArticlesFromLookbook($cdlkbk) {
    $query = 'SELECT aa.cdarti, aa.cdpers, ac.cdcolo, aa.dsarti, ap.dspers, aa.cdartn, tp.cdlinm, tp.cdserm
      FROM Go2B\Models\Anaart aa
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON aa.cdarti = ca.cdarti
      INNER JOIN Go2B\Models\Cttest ct ON ca.cdcata = ct.cdcata
      INNER JOIN Go2B\Models\Lktest lt ON ct.cdcata = lt.cdcata
      INNER JOIN Go2B\Models\Artcol ac ON aa.cdarti = ac.cdarti
      INNER JOIN Go2B\Models\Anaper ap ON aa.cdpers = ap.cdpers
      WHERE lt.cdlkbk = :cdlkbk:
      GROUP BY aa.cdarti, aa.cdpers, ac.cdcolo
      ORDER BY tp.cdlinm, tp.cdserm, aa.cdartn, aa.cdarti';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdlkbk' => $cdlkbk));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaart objects
   */
  public static function getLinkedBuyProducts($items) {
    $params = array('cdarti' => $items['cdarti'], 'nulist' => $items['nulist']);

    // Dsarti translation
    self::getDescriptionTranslation('aa', $items['idlang'], $dsarti, $leftJoinDsarti, $params, true);

    // Custom discount
    $custDisc = '0 AS cust_disc ';
    $leftJoinDisbdy = '';
    if ($items['numdis'] > 0) {
      $custDisc = 'COALESCE(c5.sconto,c4.sconto,c3.sconto,c2.sconto,c1.sconto,0) AS cust_disc ';
      $leftJoinDisbdy =
        "INNER JOIN linmod lm ON lm.cdlinm = tp.cdlinm
        LEFT JOIN b2b_disbdy c1 ON c1.cdtitl = lm.cdtitl AND c1.numdis = :numdis
        LEFT JOIN b2b_disbdy c2 ON c2.cdlinm = tp.cdlinm AND c2.cdserm = '' AND c2.numdis = :numdis
        LEFT JOIN b2b_disbdy c3 ON c3.cdlinm = tp.cdlinm AND c3.cdserm = tp.cdserm AND c3.numdis = :numdis
        LEFT JOIN b2b_disbdy c4 ON c4.tpmode = tp.tpmode AND c4.numdis = :numdis
        LEFT JOIN b2b_disbdy c5 ON c5.cdartn = tp.cdartn AND c5.numdis = :numdis
        LEFT JOIN b2b_disbdy c6 ON c5.cdartn = aa.cdarti AND c5.numdis = :numdis ";
      $params['numdis'] = $items['numdis'];
    }

    // Presence and availability
    $presence = '';
    $isAvailable = '';
    $leftJoinArtcol = '';
    $havingNotAvailable = '';
    if ($items['isOrder']) {
      // Presence
      $whr1_pr = '';
      if ($items['isPT']) {
        $leftJoinArtcol = ' LEFT JOIN artcol ac ON ac.cdarti = aa.cdarti ';
        $whr1_pr = ' AND oc1.cdcolo = ac.cdcolo ';
      }

      $params['id_usr'] = $items['idUsr'];
      $presence = ",
        COALESCE(
          (SELECT oc1.nurorc
          FROM occorp oc1
          INNER JOIN octest ot1 ON ot1.nuordc = oc1.nuordc
          WHERE nn.cdarti = oc1.cdarti $whr1_pr AND ot1.id_usr = :id_usr AND ot1.flstat = 0
          LIMIT 1),
          -1) AS presence ";

      // If availability order, add is_available field
      if ($items['isAvailability']) {
        $whr1_av = '';
        $whr2_av = '';
        if ($items['isPT']) {
          $whr1_av = ' AND oc2.cdcolo = dc2.cdcolo AND oc2.cdvari = dc2.cdvari ';
          $whr2_av = ' AND dc2.cdcolo = ac.cdcolo ';
        }

        $isAvailable = ",
          IF(MAX(
            COALESCE(
              (SELECT MAX(dc2.quanti -
                COALESCE(
                  (SELECT SUM(og2.quanti)
                  FROM octagl og2
                  INNER JOIN occorp oc2 ON oc2.nurorc = og2.nurorc
                  INNER JOIN octest ot2 ON ot2.nuordc = oc2.nuordc
                  WHERE oc2.cdarti = dc2.cdarti $whr1_av AND ot2.flstat = 2 AND og2.dstagl = dc2.taglia), 0)
                  ) AS quanti
              FROM dscorp dc2
              WHERE dc2.cdarti = nn.cdarti $whr2_av),
            0)
          ) > 0, true, false) AS is_available ";

        // If parameter "show not available" is false, filter not available items
        if (!$items['showAvailables']) {
          $havingNotAvailable = ' HAVING is_available = 1 ';
        }
      }
    }

    $query = "SELECT aa.cdarti, $dsarti, tp.tppers, tp.flimag, COALESCE(im.flimag,'') AS flimg2,
      COALESCE(IF(lc.taglia > '', -1, MAX(lc.prezzo)), 0) as catalogPrice,
      $custDisc,
      nn.quanti $presence $isAvailable
      FROM (
        SELECT oc.cdarti, oc.quanti
        FROM (
          SELECT DISTINCT oc3.nuordc, oc3.cdarti
          FROM occorp oc3
          WHERE oc3.cdarti = :cdarti
        ) AS oo
        INNER JOIN occorp oc ON oc.nuordc = oo.nuordc
        WHERE oc.cdarti != oo.cdarti
        GROUP BY oc.cdarti
      ) AS nn
      INNER JOIN anaart aa ON aa.cdarti = nn.cdarti
      INNER JOIN tipolo tp ON tp.cdartn = aa.cdartn
      LEFT JOIN lscorp lc ON lc.nulist = :nulist AND lc.cdarti = nn.cdarti
      LEFT JOIN imgart im ON im.codic1 = tp.cdartn AND im.tpimag = 'MOD2'
      $leftJoinDisbdy
      $leftJoinDsarti
      $leftJoinArtcol
      $havingNotAvailable
      ORDER BY nn.quanti DESC
      LIMIT 4";
    return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaart objects
   */
  public static function getZanottiArticlesForSalesAnalysis($items, $channels, $idlang = 'IT') {
    $params = array();
    // Description
    if ($idlang != 'IT') {
      $params['idlang'] = $idlang;
      $dsarti = 'COALESCE(d1.descri,aa.dsarti) AS dsarti';
      $leftJoinDeslin = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsarti' AND d1.codic1 = aa.cdarti AND d1.idlang = :idlang:
                         LEFT JOIN Go2B\Models\Deslin d2 ON d1.tpdato = 'dsartn' AND d1.codic1 = aa.cdarti AND d1.idlang = :idlang: ";
    } else {
      $dsarti = 'aa.dsarti AS dsarti';
      $dsartn = 'tp.dsartn AS dsartn';
      $leftJoinDeslin = '';
    }

    $innerJoinCtarti = '';
    $innerJoinCttest = '';
    $innerJoinLinmod = '';
    $innerJoinSermod = '';
    $innerJoinTitlin = '';
    $innerJoinTpmode = '';
    $whereCdcata = '';
    $whereCdstag = '';
    $whereCdcana = '';
    $whereTpindo = '';
    if (!empty($items) && !empty($items->filters)) {
      if (!empty($items->filters->catalogs) && count($items->filters->catalogs) > 0) {
        $catalogs = array();
        for ($i = 0; $i < count($items->filters->catalogs); $i++) {
          $params['cdcata' . $i] = $items->filters->catalogs[$i];
          $catalogs[] = ':cdcata' . $i;
        }
        $cdcata = implode(',', $catalogs);
        $whereCdcata = " ot.cdcata IN ($cdcata) ";
      }
      if (!empty($items->filters->seasons) && count($items->filters->seasons) > 0) {
        $seasons = array();
        for ($i = 0; $i < count($items->filters->seasons); $i++) {
          $params['cdstag' . $i] = $items->filters->seasons[$i];
          $seasons[] = ':cdstag' . $i;
        }
        $cdstag = implode(',', $seasons);
        $whereCdstag = " ot.cdstag IN ($cdstag)";
      }
      if (!empty($items->filters->channels) && count($items->filters->channels) > 0) {
        $channelsFilter = array();
        for ($i = 0; $i < count($items->filters->channels); $i++) {
          $params['f_cdcana' . $i] = $items->filters->channels[$i];
          $channelsFilter[] = ':f_cdcana' . $i;
        }
        $cdcana = implode(',', $channelsFilter);
        $whereCdcana = " ag.cdcana IN ($cdcana) ";
      }
      if (!empty($items->filters->drops) && count($items->filters->drops) > 0) {
        $drops = array();
        for ($i = 0; $i < count($items->filters->drops); $i++) {
          $params['tpindo' . $i] = $items->filters->drops[$i];
          $drops[] = ':tpindo' . $i;
        }
        $tpindo = implode(',', $drops);
        $whereTpindo = " ot.tpindo IN ($tpindo) ";
      }
      if (!empty($items->filters->lines) && count($items->filters->lines) > 0) {
        $lines = array();
        for ($i = 0; $i < count($items->filters->lines); $i++) {
          $params['cdlinm' . $i] = $items->filters->lines[$i];
          $lines[] = ':cdlinm' . $i;
        }
        $cdlinm = implode(',', $lines);
        $innerJoinLinmod = " AND tp.cdlinm IN ($cdlinm) ";
      }
      if (!empty($items->filters->series) && count($items->filters->series) > 0) {
        $series = '';
        for ($i = 0; $i < count($items->filters->series); $i++) {
          $params['s_cdlinm' . $i] = $items->filters->series[$i]->cdlinm;
          $params['s_cdserm' . $i] = $items->filters->series[$i]->cdserm;
          $series .= '(tp.cdlinm = :s_cdlinm' . $i . ' AND tp.cdserm = :s_cdserm' . $i . ') OR ';
        }
        $series = substr($series, 0, -4);
        $innerJoinSermod = " AND ($series)";
      }
      if (!empty($items->filters->modelTypes) && count($items->filters->modelTypes) > 0) {
        $modelTypes = array();
        for ($i = 0; $i < count($items->filters->modelTypes); $i++) {
          $params['tpmode' . $i] = $items->filters->modelTypes[$i];
          $modelTypes[] = ':tpmode' . $i;
        }
        $tpmode = implode(',', $modelTypes);
        $innerJoinTpmode = " AND tp.tpmode IN ($tpmode) ";
      }
      if (!empty($items->filters->brands) && count($items->filters->brands) > 0) {
        $brands = array();
        for ($i = 0; $i < count($items->filters->brands); $i++) {
          $params['cdtitl' . $i] = $items->filters->brands[$i];
          $brands[] = ':cdtitl' . $i;
        }
        $cdtitl = implode(',', $brands);
        $innerJoinTitlin = "INNER JOIN linmod lm ON lm.cdlinm = tp.cdlinm AND lm.cdtitl IN ($cdtitl) ";
      }
    }

    $totChannels = '';
    if (count($channels) > 0) {
      for ($i = 0; $i < count($channels); $i++) {
        $params['cdcana' . $i] = $channels[$i]['code'];
        $channelCode = str_replace(array('-', ' ', '<', '>', '.'), '', $channels[$i]['code']);
        $totChannels .= ', SUM(IF(ag.cdcana = :cdcana' . $i . ', og.quanti, 0)) AS tot_' . $channelCode;
      }
    }

    $where = 'WHERE ot.flstat != 4 ';
    $where .= $whereCdcata != '' ? ' AND ' . $whereCdcata : '';
    $where .= $whereCdstag != '' ? ' AND ' . $whereCdstag : '';
    $where .= $whereCdcana != '' ? ' AND ' . $whereCdcana : '';
    $where .= $whereTpindo != '' ? ' AND ' . $whereTpindo : '';

    $orderBy = $items->viewType == 0 ? 'ORDER BY tp.cdartn, aa.cdarti' : 'ORDER BY aa.cdarti';

    $query = "SELECT DISTINCT aa.cdarti, $dsarti, aa.cdartn, $dsartn, ag.cdcana,
      aa.flimag AS articleImage, tp.flimag AS modelImage,
      COALESCE(sa.valore,'') AS bolla, SUM(og.quanti) AS tot_ALL $totChannels
      FROM anaart aa
      INNER JOIN occorp oc ON oc.cdarti = aa.cdarti
      INNER JOIN octest ot ON ot.nuordc = oc.nuordc
      INNER JOIN octagl og ON og.nurorc = oc.nurorc
      INNER JOIN anagra ag ON ot.tpanag = ag.tpanag AND ot.cdanag = ag.cdanag
      INNER JOIN tipolo tp ON tp.cdartn = aa.cdartn
      $innerJoinLinmod
      $innerJoinSermod
      $innerJoinTpmode
      $innerJoinTitlin
      LEFT JOIN sparti sa ON sa.cdarti = aa.cdarti AND sa.tpcomp = 'BOLLA'
      $innerJoinCtarti
      $innerJoinCttest
      $leftJoinDeslin
      $where
      GROUP BY aa.cdarti
      $orderBy";
    return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Anaart object
   */
  public static function getMinimalArticle($cdarti) {
    $query = "SELECT a.cdarti, a.dsarti, a.flimag
      FROM Go2B\Models\Anaart a
      WHERE a.cdarti = :cdarti:";
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdarti' => $cdarti));
    return count($result) == 1 ? $result[0] : null;
  }

  /**
   * Query:   SELECT
   * Return:  Anaart object
   */
  public static function getFullArticleFromCdarti($items) {
    $params = array('cdarti' => $items['cdarti'], 'nulist' => $items['nulist'], 'id_usr' => $items['id_usr']);

    if (isset($items['rulist']) && $items['rulist'] != '') {
      $params['rulist'] = $items['rulist'];
      $rulistPrice    = "COALESCE(IF(r.taglia > '', '-1', MAX(r.prezzo)), 0) AS prezzo_r ";
      $rulistCurrency = "COALESCE(r.cdvalu,'') AS cdvalu_r ";
      $leftJoinRulist = 'LEFT JOIN Go2B\Models\Lscorp r ON a.cdarti = r.cdarti AND r.nulist = :rulist:';
    } else {
      $rulistPrice    = "'' AS prezzo_r ";
      $rulistCurrency = "'' AS cdvalu_r ";
      $leftJoinRulist = '';
    }

    // Custom discount
    if ($items['numdis'] > 0) {
      $custDisc = self::getCustomDiscountFields();
      $leftJoinDisbdy = self::getCustomDiscountLeftJoins();
      $params['numdis'] = $items['numdis'];
    } else {
      $custDisc = '0 AS cust_disc, 0 AS art_cust_disc ';
      $leftJoinDisbdy = '';
    }

    $query = "SELECT a.cdartn, a.cdarti, a.dsarti, a.cdpers, a.cdcolo, a.dscolo, a.flimag, a.tpvend,
      $custDisc, COALESCE(IF(l.taglia > '', '-1', MAX(l.prezzo)), 0) AS prezzo,
      $rulistPrice, $rulistCurrency,
      COALESCE(
        (SELECT MAX(c.nurorc)
        FROM Go2B\Models\Occorp c
        INNER JOIN Go2B\Models\Octest t ON t.nuordc = c.nuordc
        WHERE a.cdarti = c.cdarti AND t.id_usr = :id_usr: AND t.flstat = 0),
        -1) AS presence
      FROM Go2B\Models\Anaart a
      LEFT JOIN Go2B\Models\Lscorp l ON a.cdarti = l.cdarti AND l.nulist = :nulist:
      $leftJoinDisbdy
      $leftJoinRulist
      WHERE a.cdarti = :cdarti: AND a.flbloc = 0
      GROUP BY a.cdarti";

    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params)[0];
  }

  /**
   * Query:   SELECT
   * Return:  Anaart object
   */
  public static function getArticleFromCdarti($cdarti, $idlang = 'IT') {
    $dsarti = $dsartn = $lnJoin = '';
    $params = array();
    self::getTranslatedFields($cdarti, $idlang, $dsarti, $dsartn, $lnJoin, $params);

    $query = "SELECT tp.flimag AS flimag_artn, tp.cdartn, $dsartn, aa.cdpers,
      $dsarti, aa.flimag AS flimag_arti
      FROM Go2B\Models\Anaart aa
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      $lnJoin
      WHERE aa.cdarti = :cdarti:";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params)[0];
  }

  /**
   * Query:   SELECT
   * Return:  Anaart object
   */
  public static function getArticleFromCdartiAndCdcolo($cdarti, $cdcolo, $idlang = 'IT') {
    $dsarti = $dsartn = $lnJoin = '';
    $params = array();
    self::getTranslatedFields($cdarti, $idlang, $dsarti, $dsartn, $lnJoin, $params);

    $query = "SELECT tp.flimag AS flimag_artn, tp.cdartn, $dsartn, aa.cdpers,
      $dsarti, aa.flimag AS flimag_arti, ac.flimag AS flimag_artv
      FROM Go2B\Models\Anaart aa
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Artcol ac ON ac.cdarti = aa.cdarti
      $lnJoin
      WHERE aa.cdarti = :cdarti: AND ac.cdcolo = :cdcolo:";
    $params['cdcolo'] = $cdcolo;
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params)[0];
  }

  /**
   * Query:   SELECT
   * Return:  Anaart object
   */
  public static function getSimpleArticle($cdarti) {
    $query = "SELECT aa.cdarti, aa.cdartn, tp.tpmode, tp.cdlinm, tp.cdserm, tp.tppers
      FROM Go2B\Models\Anaart aa
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      WHERE aa.cdarti = :cdarti: ";
    $params = array('cdarti' => $cdarti);
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params)[0];
  }

  /**
   * Query:   SELECT
   * Return:  Anaart object
   */
  public static function getArticleForNotification($cdarti, $cdcolo, $cdvari) {
    if ($cdcolo != '') {
      $color = ':cdcolo:';
    } else {
      $color = 'aa.cdcolo';
    }
    $query = "SELECT tp.cdartn, tp.dsartn, aa.cdarti, aa.dsarti, $color AS cdcolo,
      COALESCE(ac.dscolo,'') AS dscolo, :cdvari: AS cdvari, COALESCE(av.dsvari,'') AS dsvari,
      tp.cdstag, COALESCE(ts.dsstag,'') AS dsstag, tl.cdtitl, tl.dstitl, lm.cdlinm, lm.dslinm,
      tp.cdserm, COALESCE(sm.dsserm,'') AS dsserm, tp.tpgene, tg.dsgene, tp.tpmode, tm.dstmod
      FROM Go2B\Models\Anaart aa
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl
      INNER JOIN Go2B\Models\Tpgene tg ON tg.tpgene = tp.tpgene
      INNER JOIN Go2B\Models\Tpmode tm ON tm.tpmode = tp.tpmode
      LEFT JOIN Go2B\Models\Sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = sm.cdserm
      LEFT JOIN Go2B\Models\Tabstg ts ON ts.cdstag = tp.cdstag
      LEFT JOIN Go2B\Models\Artcol ac ON ac.cdarti = aa.cdarti AND ac.cdcolo = :cdcolo:
      LEFT JOIN Go2B\Models\Artvar av ON av.cdarti = aa.cdarti AND av.cdvari = :cdvari:
      WHERE aa.cdarti = :cdarti: ";
    $params = array('cdarti' => $cdarti, 'cdcolo' => $cdcolo, 'cdvari' => $cdvari);
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params)[0];
  }

  /**
   * Query:   SELECT
   * Return:  Anaart object
   */
  public static function getArticleForGallery($cdarti, $idlang = 'IT') {
    $dsarti = $dsartn = $lnJoin = '';
    $params = array();
    self::getTranslatedFields($cdarti, $idlang, $dsarti, $dsartn, $lnJoin, $params);
    $params['cdarti'] = $cdarti;
    $params['idlang'] = $idlang;
    $query = "SELECT tp.cdartn, $dsartn, aa.cdarti, $dsarti, aa.flimag,
      aa.cdpers, COALESCE(ap.dspers,'') AS dspers, COALESCE(ap.flimag,'') AS flimag_p,
      COALESCE(ap.compos,'') AS compos, COALESCE(dc.descri,'') AS descomm,
      COALESCE(dt.descri,'') AS destecn
      FROM Go2B\Models\Anaart aa
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      LEFT JOIN Go2B\Models\Anaper ap ON ap.cdpers = aa.cdpers
      LEFT JOIN Go2B\Models\Desart dt ON dt.tpinpu = 'AR' AND dt.codice = aa.cdarti AND dt.tpdesc = 'TECN' AND dt.idlang = :idlang:
      LEFT JOIN Go2B\Models\Desart dc ON dc.tpinpu = 'AR' AND dc.codice = aa.cdarti AND dc.tpdesc = 'COMM' AND dc.idlang = :idlang:
      $lnJoin
      WHERE aa.cdarti = :cdarti: ";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params)[0];
  }

  /**
   * Query:   SELECT
   * Return:  int
   */
  public static function getCountArticles() {
    $query = "SELECT DISTINCT aa.cdarti
      FROM Go2B\Models\Anaart aa
      INNER JOIN Go2B\Models\Ctarti ca ON ca.cdarti = aa.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Cttest ct ON ct.cdcata = ca.cdcata
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      WHERE ct.dtiniz <= CURRENT_DATE() AND ct.dtfine >= CURRENT_DATE()
      AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE()
      AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      GROUP BY aa.cdarti";
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query);
    return count($result);
  }

  /**
   * Query:   SELECT
   * Return:  int
   */
  public static function getCountArticlesForCdartn($cdartn, $cdcata) {
    $query = "SELECT ca.cdarti
      FROM Go2B\Models\Ctarti ca
      INNER JOIN Go2B\Models\Anaart aa ON ca.cdarti = aa.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Cttest ct ON ct.cdcata = ca.cdcata
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      WHERE ct.cdcata = :cdcata: AND ct.dtiniz <= CURRENT_DATE() AND ct.dtfine >= CURRENT_DATE()
      AND aa.cdartn = :cdartn:
      AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE()
      AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      GROUP BY aa.cdarti";
    $params = array('cdartn' => $cdartn, 'cdcata' => $cdcata);
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    return count($result);
  }

  /**
   * Query:   SELECT
   * Return:  double
   */
  public static function getArticleDiscountForWizard($cdarti, $numdis) {
    if ($numdis > 0) {
      $query = "SELECT aa.cdarti, COALESCE(cb.sconto,0) AS sconto
        FROM Go2B\Models\Anaart aa
        LEFT JOIN Go2B\Models\B2bDisbdy cb ON cb.cdarti = aa.cdarti AND cb.numdis = :numdis:
        WHERE aa.cdarti = :cdarti:";
      $params = array('cdarti' => $cdarti, 'numdis' => $numdis);
      return Di::getDefault()->get('modelsManager')->executeQuery($query, $params)[0]->sconto;
    } else {
      return 0;
    }
  }

  /**
   * Query:   SELECT
   * Return:  string
   */
  public static function getCdartiFromCdartnAndCdpers($cdartn, $cdpers) {
    $query = "SELECT aa.cdarti
      FROM Go2B\Models\Anaart aa
      WHERE aa.cdartn = :cdartn: AND aa.cdpers = :cdpers:";
    $params = array('cdartn' => $cdartn, 'cdpers' => $cdpers);
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    return count($result) > 0 ? $result[0]->cdarti : '';
  }

  /**
   * Query:   SELECT
   * Return:  string
   */
  public static function getCdpersFromCdarti($cdarti) {
    $query = "SELECT aa.cdpers
      FROM Go2B\Models\Anaart aa
      WHERE aa.cdarti = :cdarti:";
    $params = array('cdarti' => $cdarti);
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    return count($result) > 0 ? $result[0]->cdpers : '';
  }

  /**
   * Query:   SELECT
   * Return:  string
   */
  public static function getMaxCustomArticleIndex() {
    $query = "SELECT COALESCE(MAX(CAST(aa.dsarti AS UNSIGNED)) + 1, 1) AS dsarti
      FROM Go2B\Models\Anaart aa
      WHERE aa.tpvend = 'CUSTOM'";
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query);
    return count($result) > 0 ? $result[0]->dsarti : '';
  }

  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function createCustomArticle($cdartn, $dsarti, $cdcolo) {
    $params = array(
      'cdarti' => $cdartn . '-C' . $cdcolo . '-' . $dsarti,
      'dsarti' => $dsarti,
      'cdartn' => $cdartn,
      'cdcolo' => $cdcolo
    );
    $query = "INSERT INTO anaart (cdarti, dsarti, cdartn, cdpers, flbloc, cdcolo, dscolo, tpvend, cdmisu, flimag)
      VALUES (:cdarti, :dsarti, :cdartn, '', 0, :cdcolo, '', 'CUSTOM', '', '')";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateBlockFlagForFabric($cdpers, $flbloc) {
    $params = array('cdpers' => $cdpers, 'flbloc' => $flbloc);
    $query = 'UPDATE anaart aa
      INNER JOIN anaper ap ON aa.cdpers = ap.cdpers
      SET aa.flbloc = :flbloc
      WHERE ap.cdpers = :cdpers';
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateArticleImage($cdarti, $flimag) {
    $params = array(
      'cdarti' => $cdarti,
      'flimag' => $flimag != '' ? $flimag : ''
    );

    $query = "UPDATE anaart a
      SET a.flimag = :flimag
      WHERE a.cdarti = :cdarti";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateImage($cdarti, $dummyCode, $flimag) {
    $params = array('cdarti' => $cdarti, 'flimag' => $flimag);
    $query = "UPDATE anaart a
      SET a.flimag = :flimag
      WHERE a.cdarti = :cdarti";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function emptyFabric($cdarti) {
    $params = array('cdarti' => $cdarti);
    $query = "UPDATE anaart a
      SET a.cdpers = ''
      WHERE a.cdarti = :cdarti";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function blockArticle($cdarti) {
    $params = array('cdarti' => $cdarti);
    $query = "UPDATE anaart a
      SET a.flbloc = 1
      WHERE a.cdarti = :cdarti";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function blockAllArticles() {
    $query = "UPDATE anaart a SET a.flbloc = 1";
    Di::getDefault()->get('db')->query($query);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteCustomVariant($cdarti) {
    $params = array('cdarti' => $cdarti);
    $query = "DELETE a.*
      FROM anaart a
      WHERE a.cdarti = :cdarti AND a.tpvend = 'CUSTOM' ";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllCustomArticlesForOrder($nuordc) {
    $params = array('nuordc' => $nuordc);
    $query = "DELETE a.*
      FROM anaart a
      INNER JOIN occorp o ON o.cdarti = a.cdarti
      WHERE a.tpvend = 'CUSTOM' AND o.nuordc = :nuordc ";
    Di::getDefault()->get('db')->query($query, $params);
  }
  //endregion
}
