<?php

namespace Go2B\Library;

use Phalcon\Di;
use Phalcon\Http\Response;

class SimpleCsv
{
    protected $headers = true;

    protected $filename;

    public function __construct($filename = null)
    {
        $this->filename = $filename ?: time();
    }

    public function send($records, $response = null)
    {
        if (empty($response)) {
            $response = Di::getDefault()->get('response');
        }

        /** @var Response $response */
        // Headers for a CSV
        $response->setHeader('Content-type', 'application/csv');

        // By default, filename is just a timestamp. You should probably change this.
        $response->setHeader('Content-Disposition', 'attachment; filename="' . $this->filename . '.csv"');
        $response->setHeader('Pragma', 'no-cache');
        $response->setHeader('Expires', '0');

        // We write directly to out, which means we don't ever save this file to disk.
        $handle = fopen('php://output', 'w');

        // The keys of the first result record will be the first line of the CSV (headers)
        if ($this->headers) {
            fputcsv($handle, array_keys($records[0]));
        }

        // Write each record as a csv line.
        foreach ($records as $line) {
            fputcsv($handle, $line);
        }

        fclose($handle);

        $response->send();
    }

    public function useHeaderRow($headers)
    {
        $this->headers = (bool)$headers;
        return $this;
    }
}
