<?php

namespace Go2B\Library;

use Go2B\Models\B2bClassificazione;
use Go2B\Models\Lstest;
use Phalcon\Di;
use Phalcon\Mvc\User\Component;

/**
 * NavbarBuilder
 *
 * Helps to build UI elements for the application
 */
class NavbarBuilder extends Component
{
    //region Top header items
    public function getCatalogButton($isOrder, $controllerName, $selectedCatalog, $useMoreCatalogs)
    {
        $translator = Di::getDefault()->get('i18n');
        if ($controllerName != 'account' && $controllerName != 'info' && $controllerName != 'statistics') {
            echo "<div class='menu-icon-ctlg'>";
            echo $translator->_('_common.header.currentcatalog') . ": ";
            echo $selectedCatalog != '' ? "&nbsp;" . $selectedCatalog->dscata : "";
            if (!$isOrder || $useMoreCatalogs == 1) {
                echo " | <span class='toggle-cat-sidebar'>" . $translator->_('_common.header.changecatalog') . "</span>";
            }
            echo "</div>";

            echo "<div class='menu-icon-ctlg-mobile'>";
            echo "<span " . (!$isOrder || $useMoreCatalogs == 1 ? "class='toggle-cat-sidebar'" : "") . ">";
            echo $selectedCatalog != '' ? $selectedCatalog->dscata : "";
            echo "</span>";
            echo "</div>";
        }
    }

    public function getSupportButton($isOrder, $supportAvailable, $userType)
    {
        if (!$isOrder && $supportAvailable && $userType == '4') {
            $href = $this->url->get('support/list');
            $title = Di::getDefault()->get('i18n')->_('user.menu.support');
            $src = $this->url->getStatic('assets/img/support.png');
            echo "<div class='menu-icon'>";
            echo "<a href='$href'><img src='$src' alt='$title' title='$title'/></a>";
            echo "</div>";
        }
    }

    public function getStatsButton($isOrder, $type)
    {
        if (!$isOrder && $type == 3) {
            $href = $this->url->get('statistics/index');
            $title = Di::getDefault()->get('i18n')->_('user.menu.statistics');
            $src = $this->url->getStatic('assets/img/stats.png');
            echo "<div class='menu-icon menu-icon-stats'>";
            echo "<a href='$href'><img src='$src' alt='$title' title='$title'/></a>";
            echo "</div>";
        }
    }

    public function getShipmentInfoButton($isOrder)
    {
        $href = $this->url->get('info/shipmentconditions');
        $title = Di::getDefault()->get('i18n')->_('user.menu.shipmentInfo');
        $src = $this->url->getStatic('assets/img/condizioni_vendita.png');
        echo "<div class='menu-icon menu-icon-stats'>";
        echo "<a href='$href'><img src='$src' alt='$title' title='$title'/></a>";
        echo "</div>";
    }

    public function getAccountButton($isOrder)
    {
        if (!$isOrder) {
            $title = Di::getDefault()->get('i18n')->_('user.menu.account');
            $src = $this->url->getStatic('assets/img/account.png');
            echo "<div class='menu-icon'>";
            echo "<img src='$src' alt='$title' title='$title' class='toggle-acc-sidebar'/>";
            echo "</div>";
        }
    }

    public function getOrdersButton($isOrder, $showOrders)
    {
        if (!$isOrder && $showOrders == 1) {
            $href = $this->url->get('account/info/ord');
            $title = Di::getDefault()->get('i18n')->_('_common.orders');
            $src = $this->url->getStatic('assets/img/orders.png');
            echo "<div class='menu-icon'>";
            echo "<a href='$href'><img src='$src' alt='$title' title='$title'/></a>";
            echo "</div>";
        }
    }

    public function getDownloadButton($isOrder)
    {
        if (!$isOrder) {
            $href = $this->url->get('data/media');
            $title = Di::getDefault()->get('i18n')->_('_common.downloadarea');
            $src = $this->url->getStatic('assets/img/media.png');
            echo "<div class='menu-icon'>";
            echo "<a href='$href' target='_blank'><img src='$src' alt='$title' title='$title'/></a>";
            echo "</div>";
        }
    }

    public function getPromoButton($isOrder, $controllerName, $promoParameter)
    {
        if ($isOrder && in_array($controllerName, array('catalog', 'model')) && $promoParameter == 2) {
            $title = Di::getDefault()->get('i18n')->_('user.menu.promo');
            $src = $this->url->getStatic('assets/img/promo.png');
            echo "<div class='menu-icon menu-promo'>";
            echo "<img src='$src' alt='$title' title='$title' class='toggle-prm-sidebar'/>";
            echo "</div>";
        }
    }

    public function getSearchBoxForSmartphone($controllerName)
    {
        if (in_array($controllerName, array('cart', 'catalog', 'model'))) {
            $title = Di::getDefault()->get('i18n')->_('user.menu.search');
            $src = $this->url->getStatic('assets/img/search.png');
            echo "<div class='menu-icon menu-icon-search-smaller toggle-src-sidebar d-sm-none'>";
            echo "<img src='$src' alt='$title' title='$title'/>";
            echo "</div>";
        }
    }

    /**
     * @param $isOrder
     * @param $enableBarcode
     * @return void
     *
     * @deprecated
     */
    public function getBarcodeButton($isOrder, $enableBarcode)
    {
        return;
        $translator = Di::getDefault()->get('i18n');
        if ($isOrder && $enableBarcode > 0) {
            $title = $translator->_('_common.barcode');
            $src = $this->url->getStatic('assets/img/promo.png');
            if ($enableBarcode != 3) {
                $modal = $enableBarcode == 1 ? 'bulk' : 'single';
                echo "<div class='menu-icon'>";
                echo "<a href='#' class='barcode-btn' data-toggle='modal' data-target='.modal-barcode-$modal'>";
                echo "<img src='$src' alt='$title' title='$title'/>";
                echo "</a>";
                echo "</div>";
            } else {
                echo "<div class='menu-icon lang-switcher'>";
                echo "<div class='lang-toggle'>";
                echo "<img src='$src' alt='$title' title='$title'/>";
                echo "<ul class='lang-dropdown' style='width:200px'>";
                echo "<li><a href='#' class='barcode-btn' data-toggle='modal' data-target='.modal-barcode-bulk'>" . $translator->_('_common.header.barcode.bulk') . "</a></li>";
                echo "<li><a href='#' class='barcode-btn' data-toggle='modal' data-target='.modal-barcode-single'>" . $translator->_('_common.header.barcode.single') . "</a></li>";
                echo "</ul>";
                echo "</div>";
                echo "</div>";
            }
        }
    }

    public function getQuickOrderButton($isOrder, $showQuickOrder, $tpordc)
    {
        if ($isOrder && $showQuickOrder == 1 && $tpordc == 1) {
            $href = $this->url->get('catalog/quickorder');
            $title = Di::getDefault()->get('i18n')->_('_common.quickorder');
            echo "<div class='menu-icon text-capitalize'>";
            echo "<a href='$href' target='_blank'>$title</a>";
            echo "</div>";
        }
    }

    public function getExcelCartButton($isOrder, $allowExcelCart)
    {
        if ($isOrder && $allowExcelCart) {
            $translator = Di::getDefault()->get('i18n');
            $title = $translator->_('_common.load') . ' ';
            $title .= $translator->_('_common.file');
            echo "<div class='menu-icon text-capitalize'>";
            echo "<a href='#' class='slider-exit' data-toggle='modal' data-target='.modal-excel-cart'>$title</a>";
            echo "</div>";
        }
    }

    public function getCancelOrderButton($isOrder)
    {
        if ($isOrder) {
            $title = Di::getDefault()->get('i18n')->_('_common.cancelorder');
            $src = $this->url->getStatic('assets/img/orders.png');
            echo "<div class='menu-icon text-capitalize'>";
            echo "<a href='#' class='slider-exit' data-toggle='modal' data-target='.modal-cancel-order'>$title</a>";
            echo "</div>";
        }
    }

    public function getLanguageButton($isOrder, $language)
    {
        if (!$isOrder) {
            $selectedLanguage = '';
            switch ($language) {
                case 'de':
                    $selectedLanguage = 'Deutsch';
                    break;
                case 'en':
                    $selectedLanguage = 'English';
                    break;
                case 'es':
                    $selectedLanguage = 'Español';
                    break;
                case 'fr':
                    $selectedLanguage = 'Français';
                    break;
                case 'it':
                default:
                    $selectedLanguage = 'Italiano';
                    break;
            }
            $title = Di::getDefault()->get('i18n')->_('_common.header.changelanguage');
            echo "<div class='menu-icon lang-switcher'>";

            echo "<div class='lang-toggle'>";
            echo "<span title='$title'>$selectedLanguage</span>";
            echo "<i class='material-icons arrow_drop_down'></i>";
            echo "<ul class='lang-dropdown'>";
            echo $language != 'it' ? "<li><a href='#' class='change-language' id='it'>Italiano</a></li>" : '';
            echo $language != 'en' ? "<li><a href='#' class='change-language' id='en'>English</a></li>" : '';
            echo $language != 'de' ? "<li><a href='#' class='change-language' id='de'>Deutsch</a></li>" : '';
            echo $language != 'es' ? "<li><a href='#' class='change-language' id='es'>Español</a></li>" : '';
            echo $language != 'fr' ? "<li><a href='#' class='change-language' id='fr'>Français</a></li>" : '';
            echo "</ul>";
            echo "</div>";

            echo "</div>";
        }
    }

    public function getLogoutButton()
    {
        $href = $this->url->get('session/end');
        $title = Di::getDefault()->get('i18n')->_('_common.logout');
        echo "<div class='menu-icon menu-icon-logout'>";
        echo "<a href='$href' title='$title'>$title</a>";
        echo "</div>";
    }
    //endregion

    //region Middle header items
    public function getNewOrderButton($controllerName, $isOrder, $catalogsLength, $canDoOrder, $orderInfoBtn = 0, $orderInfo = null)
    {
        if ($controllerName != 'cart' || $isOrder) {
            if ($catalogsLength > 0 && $canDoOrder) {
                $translator = $this->di->get('i18n');
                $sngCustomer = $this->di->get('config')->release->user;
                if ($isOrder) {
                    if ($orderInfoBtn == 0 || empty($orderInfo)) {
//                        echo "<div class='toggle-ord-sidebar btn btn-custom' style='width:225px'>";
                        echo "<div class='toggle-ord-sidebar btn btn-custom px-4'>";
                        echo $translator->_('user.menu.orderinfo');
                        echo "</div>";
                    } else {
//                        echo "<div class='toggle-ord-sidebar btn btn-custom' style='width:225px'>";
                        echo "<div class='toggle-ord-sidebar btn btn-custom px-4'>";
                        echo $translator->_('user.menu.orderinfo');
                        echo "</div>";
//                        echo "<div class='info-order-sub-btn btn btn-custom'>";
                        echo "<div class='btn btn-light disabled ml-4 px-3' style='font-size:12px;line-height:22px;cursor:default'>";
                        echo "<span class='info-order-sub-text d-none d-md-block'>";
                        echo $translator->_('_common.customer') . ': ';
                        echo $orderInfo->dsanag;
                        echo "</span>";
                        echo "<span class='info-order-sub-text'>";
                        echo $translator->_('_common.ordernumber') . ': ';
                        echo $orderInfo->nuordc;
                        echo "</span>";
                        echo '</div>';
                    }
                } else {
                    echo "<span class='btn btn-custom'";
                    echo ' data-toggle="modal" data-target=".modal-new-order" data-backdrop="static" data-keyboard="false">';
                    echo $translator->_('user.menu.neworder');
                    echo "</span>";
                }
            }
        } else {
            echo '';
        }
    }

    public function getAdditionalButton($text, $link)
    {
        echo "<span class='btn-custom' style='color:#b20000'>";
        echo "<a href='" . (substr($link, 0, 4) == 'http' ? $link : 'https://' . $link) . "' target='_blank'>" . $text . "</a>";
        echo "</span>";
    }

    public function getLogo($logoImage, $homepageStyle)
    {
        $href = $homepageStyle == 0 ? $this->url->get('catalog/index') : $this->url->get('catalog/collection');
        $src = $this->getLogoImage($logoImage);

        echo "<a href='$href'><img src='$src' alt='Logo' title='Logo' class='Logo'/></a>";
    }

    public function getLogoImage($logoImage)
    {
        $imgurl = "img/" . $logoImage;
        $exist = $logoImage != '' && file_exists($imgurl);
        return $exist ? $this->url->getStatic($imgurl) : $this->url->getStatic("assets/img/logo_home.jpg");
    }

    public function getSearchBoxForDesktop($controllerName)
    {
        if (in_array($controllerName, array('cart', 'catalog', 'model'))) {
            $title = Di::getDefault()->get('i18n')->_('user.menu.search');
            $src = $this->url->getStatic('assets/img/search.png');
            echo "<div id='ajax_search_results'></div>";
//            echo "<div class='btn btn-custom'><div class='menu-icon menu-icon-search' style='border-bottom:1px black solid'>";
            echo "<div class='btn btn-custom px-3 d-none d-sm-inline-block'>";
            echo "<div class='menu-icon menu-icon-search toggle-src-sidebar d-none d-sm-inline-block d-lg-none' style='border-bottom:1px black solid'>";
            echo "<img src='$src' alt='$title' title='$title'/>";
            echo "</div>";
            echo "<div class='menu-icon menu-icon-search m-0 px-2 d-none d-lg-inline-block' style='border-bottom:1px black solid'>";

            echo '<form class="search-model-form p-1" action="' . $this->getSearchActionUrl() . '" method="get">';
            echo "<input type='text' name='search' class='search-product' id='ajax_search_field' placeholder='" . $title . "' />";
            echo '<input type="image" width="24" name="submit" src="' . $src . '" alt="' . $title . '" title="' . $title . '" style="margin-top:5px;margin-bottom:-5px"/>';
            echo "</form></div></div>";
        }
    }

    public function getSearchBoxForTablet($controllerName)
    {
        return '';

        if (in_array($controllerName, array('cart', 'catalog', 'model'))) {
            $title = Di::getDefault()->get('i18n')->_('user.menu.search');
            $src = $this->url->getStatic('assets/img/search.png');
            echo "<div class='menu-icon menu-icon-search-small toggle-src-sidebar'>";
            echo "<img src='$src' alt='$title' title='$title'/>";
            echo "</div>";
        }
    }

    public function getCartButton($isOrder, $controllerName, $hideDeliveryDate, $orderInfo, $dateMgmtAva, $dateMgmtRes, $totRows, $totCart, $totSpend)
    {
        if (in_array($controllerName, array('cart', 'catalog', 'model'))) {
            $i18n = Di::getDefault()->get('i18n');
            $dtmcli = $orderInfo && $orderInfo->dtmcli ? $orderInfo->dtmcli : '00/00/0000';
            $dtmcoi = $orderInfo && $orderInfo->dtmcoi ? $orderInfo->dtmcoi : '00/00/0000';
            $dtmcof = $orderInfo && $orderInfo->dtmcof ? $orderInfo->dtmcof : '00/00/0000';
            $tpordc = $orderInfo && $orderInfo->tpordc ? $orderInfo->tpordc : 0;
            $title = $i18n->_('user.menu.shoppingbag');
            $src = $this->url->getStatic('assets/img/shopping_bag.png');

            echo "<div class='btn btn-custom ml-4 p-0 px-3 " . ($isOrder ? '' : ' d-none') . "'><div class='menu-icon menu-icon-cart m-0 px-2'>";
            if ($isOrder && (
                    $hideDeliveryDate == 1 ||
                    (!empty($dtmcli) && $dtmcli != '00/00/0000') ||
                    (!empty($dtmcoi) && $dtmcoi != '00/00/0000' && !empty($dtmcof) && $dtmcof != '00/00/0000') ||
                    ($tpordc == 0 && ($dateMgmtAva == 1 || $dateMgmtAva == 3)) ||
                    ($tpordc == 1 && ($dateMgmtRes == 1 || $dateMgmtRes == 3))
                )) {
                $href = $this->url->get('cart/index');
                echo '<a href="' . $href . '" class="shopping-bag '. ($totRows > 0 ? "full-bag" : "empty-bag") . '">';
                echo "<img src='$src' alt='$title' title='$title' class='mx-1'/>";
                echo "<div class='menu-shopping-bag'>";
                $articlesLabel = $i18n->_('user.menu.shoppingbag.articles');
                $quantityLabel = $i18n->_('user.menu.shoppingbag.quantity');
                $spendLabel = $i18n->_('user.menu.shoppingbag.spend');
                echo $articlesLabel . ' <span data-items="'. $totRows . '">' . $totRows .
                    '</span> - ' . $quantityLabel . ' <span data-quantity="'. $totCart . '">' . $totCart .
                    '</span> - ' . $spendLabel . ' <span data-spend="'. $totSpend . '">'
                    . $this->getDI()->get('utility')->formatValue($totSpend, $orderInfo->cdvalu)['value'] . '</span>';
                echo "</div>";
                echo "</a></div>";
            } else {
                echo "<img src='$src' alt='$title' title='$title' data-toggle='modal' data-target='.modal-dtmcli-error'/>";
            }
            echo "</div>";
        }
    }

    public function getMobileMenuButton()
    {
        $src = $this->url->getStatic('assets/img/menu.png');
        echo "<div class='menu-icon menu-icon-menu'>";
        echo "<img src='$src' class='toggle-men-sidebar'/>";
        echo "</div>";
    }
    //endregion

    //region Bottom header items
    public function getBreadcrumbs($controllerName, $actionName, $whichHomepage, $cdlkbk, $tag, $catalogAccessType, $ctg_vt, $ctg_br, $ctg_ln, $ctg_sm)
    {
        if ($controllerName == 'catalog' && $actionName == "index") {
            echo "Home";
        } else {
            $href = $this->url->get($whichHomepage == 0 ? 'catalog/index' : 'catalog/collection');
            echo "<a href='" . $href . "'>Home</a> > ";
            $translator = Di::getDefault()->get('i18n');
            switch ($controllerName) {
                case 'account':
                    echo $translator->_('_common.accountarea');
                    break;
                case 'cart':
                    echo $translator->_('_common.cart');
                    break;
                case 'catalog':
                    switch ($actionName) {
                        case 'collection':
                            echo $translator->_('_common.collections');
                            break;
                        case 'fabric':
                            echo $translator->_('_common.tissues');
                            break;
                        case 'fabricDetail':
                            $href = $this->url->get('catalog/fabric');
                            echo '<a href="' . $href . '">' . $translator->_('_common.tissues') . '</a> > ';
                            echo $translator->_('_common.models');
                            break;
                        case 'gallery':
                            echo $translator->_('_common.gallery');
                            break;
                        case 'list':
                            echo $translator->_('_common.list');
                            break;
                        case 'look':
                            $href = $this->url->get('catalog/lookbook/' . $cdlkbk);
                            echo '<a href="' . $href . '">' . $translator->_('_common.lookbook') . '</a> > ';
                            echo $translator->_('_common.look');
                            break;
                        case 'lookbook':
                            echo $translator->_('_common.lookbook');
                            break;
                        case 'sales':
                            echo $translator->_('_common.onsale');
                            break;
                        case 'selection':
                            echo $translator->_('_common.selection');
                            break;
                        case 'quickorder':
                            echo $translator->_('_common.quickorder');
                            break;
                        case 'promo':
                            echo $translator->_('_common.promotion');
                            break;
                        case 'results':
                        case 'resultslist':
                        case 'resultsquickorder':
                            echo $translator->_('_common.searchresults');
                            break;
                        case 'tag':
                            echo $tag;
                            break;
                    }
                    break;
                case 'info':
                    if ($actionName == 'salesconditions') {
                        echo $translator->_('_common.salesconditions');
                    } else {
                        echo $translator->_('_common.contacts');
                    }
                    break;
                case 'model':
                    if ($catalogAccessType == 0) {
                        if ($ctg_vt == 'all') {
                            $addHref = '';
                        } else {
                            $addHref = '/' . $ctg_br;
                            if ($ctg_vt != 'titlin') {
                                $addHref .= '/' . $ctg_ln;
                                if ($ctg_vt != 'linmod') {
                                    $addHref .= '/' . $ctg_sm;
                                }
                            }
                        }
                        $href = $this->url->get('catalog/collection' . $addHref);
                        echo '<a href="' . $href . '">' . $translator->_('_common.collections') . '</a> > ';
                        echo $translator->_('_common.modelcard');
                    } else {
                        $href = $this->url->get('catalog/list');
                        echo '<a href="' . $href . '">' . $translator->_('_common.list') . '</a> > ';
                        echo $translator->_('_common.modelcard');
                    }
                    break;
                case 'statistics':
                    echo $translator->_('_common.statsarea');
                    break;
                case 'support':
                    echo $translator->_('_common.support');
                    break;
            }
        }
    }

    public function getLeftButtonsOnBottomHeader($controllerName, $actionName, $catalogAccessType, $isOrder, $tpordc,
                                                 $enableFabricView, $cdtitl, $cdlinm, $showQuickOrder, $showList, $showVisual)
    {
        $translator = Di::getDefault()->get('i18n');

        $additionalUrlParams = '';
        $currentUrl = $this->getDI()->get('request')->getQuery();
        if (!empty($currentUrl['_url']) && (strpos($currentUrl['_url'], '/catalog/collection') === 0 || strpos($currentUrl['_url'], '/catalog/list') === 0)) {
            $additionalUrlParams = str_replace(['/catalog/collection', '/catalog/list'], '', $currentUrl['_url']);
        }

        if ($controllerName == 'catalog') {
            switch ($actionName) {
                case 'collection':
                case 'list':
                case 'selection':
                    $isListing = $actionName == 'list';
                    $listUrl = $this->url->get('catalog/list' . $additionalUrlParams);
                    $collectionUrl = $this->url->get('catalog/collection' . $additionalUrlParams);
                    $isVisible = !$isListing
                        ? $showList == 1
                        : $showVisual;
                    $label = !$isListing
                        ? $translator->_('_common.list')
                        : $translator->_('_common.visual');

                    echo $this->getDi()->getView()->getPartial('components/header/visual-mode', [
                        'actionName' => $actionName,
                        'isVisible' => $isVisible,
                        'listUrl' => $listUrl,
                        'collectionUrl' => $collectionUrl,
                        'label' => $label
                    ]);

                    break;
            }
        }
    }

    public function getRightButtonsOnBottomHeader($controllerName, $actionName, $catalogAccessType, $isOrder, $tpordc,
                                                  $enableFabricView, $cdtitl, $cdlinm, $showQuickOrder, $showList, $showVisual)
    {
        $translator = Di::getDefault()->get('i18n');
        $additionalUrlParams = '';
        $currentUrl = $this->getDI()->get('request')->getQuery();
        if (!empty($currentUrl['_url']) && (strpos($currentUrl['_url'], '/catalog/collection') === 0 || strpos($currentUrl['_url'], '/catalog/list') === 0)) {
            $additionalUrlParams = str_replace(['/catalog/collection', '/catalog/list'], '', $currentUrl['_url']);
        }
        // TODO Quando uniremo tutte le modifiche grafiche di kocca dovremo sostituire le classi 'btn btn-sm btn-custom' con 'btn-header-sidebar'
        if ($controllerName == 'catalog') {
            switch ($actionName) {
                case 'classification':
                case 'results':
                case 'resultslist':
                    $href = $this->url->get($catalogAccessType == 0 ? 'catalog/collection' : 'catalog/list') . $additionalUrlParams;
                    if ($this->utility->getAppSettings('ShowFilterLeftSide') == 0) {
                        echo '<a href="#" class="toggle-flt-sidebar btn btn-sm btn-custom mx-2">' . $translator->_('_common.filter') . '</a>';
                    } else {
                        echo '';
                    }

                    echo '<a href="' . $href . '" class="btn btn-sm btn-custom mx-2">' . $translator->_('_common.resetsearch') . '</a>';
                    break;
                case 'resultsfabric':
                    $href = $this->url->get('catalog/fabric');
                    echo '<a href="' . $href . '" class="btn btn-sm btn-custom mx-2">' . $translator->_('_common.resetsearch') . '</a>';
                    break;
                case 'collection':
                case 'list':
                case 'selection':
                    if ($isOrder && $tpordc == 0 && $this->di->get('utility')->getAppSettings('ExportAvailabilityXls') == 1) {
                        $href = $this->url->get('catalog/exportAvailability');
                        echo '<a href="' . $href . '" class="btn-header-sidebar mx-2" target="_blank">' . $translator->_('_common.exportavailability') . '</a>';
                    }

                    if ($this->utility->getAppSettings('ShowFilterLeftSide') == 0) {
                        echo '<a href="#" class="toggle-flt-sidebar btn-header-sidebar mx-2">' . $translator->_('_common.filter') . '</a>';
                    }

                    echo '<a href="#" class="toggle-oby-sidebar btn-header-sidebar mx-2">' . $translator->_('_common.ordering') . '</a>';
                    if ($enableFabricView == 1) {
                        $href = $this->url->get('catalog/fabric' . ($cdtitl != '' ? '/' . $cdtitl : '') . ($cdlinm != '' ? '/' . $cdlinm : ''));
                        echo '<a href="' . $href . '" class="btn-header-sidebar mx-2">' . $translator->_('_common.tissues') . '</a>';
                    }
                    if ($showQuickOrder && $isOrder && $tpordc != 0) {
                        $href = $this->url->get('catalog/quickorder');
                        echo '<a href="' . $href . '" class="btn-header-sidebar mx-2">' . $translator->_('_common.quickorder') . '</a>';
                    }
//                    if ($actionName == 'collection' || $actionName == 'selection') {
//                        if ($showList == 1) {
//                            $href = $this->url->get('catalog/list' . $additionalUrlParams);
//                            echo '<a href="' . $href . '" class="btn-header-sidebar mx-2">' . $translator->_('_common.list') . '</a>';
//                        }
//                    } else {
//                        if ($showVisual) {
//                            $href = $this->url->get('catalog/collection' . $additionalUrlParams);
//                            echo '<a href="' . $href . '" class="btn-header-sidebar mx-2">' . $translator->_('_common.visual') . '</a>';
//                        }
//                    }
                    break;
                case 'fabric':
                case 'fabricDetail':
                    $title = $translator->_('user.menu.search');
                    $src = $this->url->getStatic('assets/img/search.png');
                    $href = $actionName == 'fabric'
                        ? $this->url->get('catalog/collection' . ($cdtitl != '' ? '/' . $cdtitl : '') . ($cdlinm != '' ? '/' . $cdlinm : ''))
                        : $this->url->get('catalog/collection');

                    if ($this->utility->getAppSettings('ShowFilterLeftSide') == 0) {
                        echo '<a href="#"  class="toggle-flt-sidebar btn btn-sm btn-custom mx-2">' . $translator->_('_common.filter') . '</a>';
                    }

                    echo '<a href="#" class="toggle-oby-sidebar btn btn-sm btn-custom mx-2">' . $translator->_('_common.ordering') . '</a>';
                    echo '<a href="' . $href . '" class="btn btn-sm btn-custom mx-2">' . $translator->_('_common.models') . '</a>';
                    echo '<div class="breadcrumbs"><div class="menu-icon menu-icon-search breadcrumbs-btn mr-20x mt-1" style="border-bottom:1px black solid;margin-top:-9px">';
                    echo '<input type="text" class="search-fabric" id="ajax_search_fabric_field" ';
                    echo 'placeholder="' . $translator->_('user.menu.search.fabric') . '" />';
                    echo "<img src='$src' alt='$title' title='$title' id='ajax_search_fabric_img'/>";
                    echo '</div>';
                    echo '<div id="ajax_search_fabric_results" class="breadcrumbs-btn"></div></div>';
                    break;
                case 'quickorder':
                    if ($enableFabricView == 1) {
                        $href = $this->url->get('catalog/fabric' . ($cdtitl != '' ? '/' . $cdtitl : '') . ($cdlinm != '' ? '/' . $cdlinm : ''));
                        echo '<a href="' . $href . '" class="btn btn-sm btn-custom mx-2">' . $translator->_('_common.tissues') . '</a>';
                    }
                    if ($showList == 1) {
                        $href = $this->url->get('catalog/list') . $additionalUrlParams;
                        echo '<a href="' . $href . '" class="btn btn-sm btn-custom mx-2">' . $translator->_('_common.list') . '</a>';
                    }
                    break;
                case 'tag':
                    if ($this->utility->getAppSettings('ShowFilterLeftSide') == 0) {
                        echo '<a href="#" class="toggle-flt-sidebar btn btn-sm btn-custom mx-2">' . $translator->_('_common.filter') . '</a>';
                    }
                    break;
            }
        } else if ($controllerName == 'model' && $actionName == 'wizard') {
            $href = $this->url->get($catalogAccessType == 0 ? 'catalog/collection' : 'catalog/list') . $additionalUrlParams;
            echo '<a href="' . $href . '" class="btn btn-sm btn-custom mx-2">' . $translator->_('_common.models') . '</a>';
            if ($enableFabricView == 1) {
                $href = $this->url->get('catalog/fabric');
                echo '<a href="' . $href . '" class="btn btn-sm btn-custom mx-2">' . $translator->_('_common.tissues') . '</a>';
            }
        }
    }
    //endregion

    //region Navbar Content
    public function getDefaultNavbarNavigation($brands, $lines, $series, $lookbooks, $sales, $galleries, $catalogAccessType, $hide, $noSubmenus = false, $catalogMenuAlignment = 'standard')
    {
        $totColumns = (count($brands) != 1 ? count($brands) : count($lines));
        $totColumns += count($lookbooks) > 0 ? 1 : 0;
        $totColumns += count($sales) > 0 ? 1 : 0;
        $totColumns += count($galleries) > 0 ? 1 : 0;
        $width = 15 * $totColumns;
        $marginleft = (100 - $width) / 2;
        $style = $width < 50 ? "width:$width%;margin-left:$marginleft%" : '';
        $hideStyle = $hide ? 'style="display:none!important"' : '';

        // Main navigation header
        echo "<div class='catalogs-header d-none d-lg-block w-100 py-20x px-0' $hideStyle>";
        echo "<div class='row' style='$style'>";
        if (count($brands) > 1) {
            $i = 1;
            foreach ($brands as $brand) {
                if ($noSubmenus) {
                    $href = $this->url->get('catalog/collection/' . urlencode($brand->cdtitl));
                    $this->getNavigationButton($i, $brand->dstitl, $href);
                } else {
                    $this->getNavigationButton($i, $brand->dstitl);
                }
                $i++;
            }
        } else if (count($lines) > 0) {
            $i = 1;
            foreach ($lines as $line) {
                if (count($series[$line->cdlinm]) > 0 && !$noSubmenus) {
                    $this->getNavigationButton($i, $line->dslinm);
                } else {
                    $where = ($catalogAccessType == 0 ? 'catalog/collection/' : 'catalog/list/') . urlencode($line->cdtitl) . '/' . $line->cdlinm;
                    $href = $this->url->get($where);
                    $this->getNavigationButton($i, $line->dslinm, $href);
                }
                $i++;
            }
        }
        if (count($lookbooks) > 0) {
            $this->getLookbookButton();
        }
        if (count($sales) > 0) {
            $this->getSalesButton();
        }
        if (count($galleries) > 0) {
            $this->getGalleriesButton();
        }
        echo "</div>"; // Close .row
        echo "</div>"; // Close .catalogs-header

        // Navigation sub-header
        if (!$noSubmenus) {
            $menuRowClasses = '';
            $menuTitleClasses = '';
            $menuColClasses = 'col-md-3 offset-md-3 text-right';
            if (!empty($catalogMenuAlignment) && $catalogMenuAlignment != 'standard') {
                list($catalogMenuAlignmentMode, $catalogMenuAlignmentText) = explode('-', $catalogMenuAlignment, 2);
                if ($catalogMenuAlignmentMode == 'central') {
                    $menuTitleClasses = 'text-center';
                    $menuRowClasses = 'justify-content-center';
                    $menuColClasses = '';
                    if ($catalogMenuAlignmentText != 'center') {
                        $menuColClasses = 'col-md-3 col-lg-2 ';
                    }
                    $menuColClasses .= "text-$catalogMenuAlignmentText";
                }
            }

            if (count($brands) > 1) {
                $i = 1;
                foreach ($brands as $brand) {
                    if (!empty($lines[$brand->cdtitl]) && count($lines[$brand->cdtitl]) > 0) {
                        $title = Di::getDefault()->get('i18n')->_('_common.brandtext');
                        $where = $catalogAccessType == 0 ? 'catalog/collection/' . urlencode($brand->cdtitl) : 'catalog/list';
                        $href = $this->url->get($where);

                        echo "<div class='catalogs-header-below fadeout w-100' id='cdtitl$i'>";

                        echo "<div class='row mx-0 $menuRowClasses'>";
//            echo "<div class='col-lg-6 text-right'>";
                        echo "<div class='col-12 $menuColClasses'>";
                        echo "<div class='$menuTitleClasses'>";
                        $this->getBrandTitle($title, $href, $brand->dstitl);
                        echo "</div>";
                        $class = $this->getListClass(count($lines[$brand->cdtitl]));
                        foreach ($lines[$brand->cdtitl] as $line) {
                            $where = ($catalogAccessType == 0 ? 'catalog/collection/' : 'catalog/list/') . urlencode($brand->cdtitl) . '/' . urlencode($line->cdlinm);
                            $href = $this->url->get($where);
                            $this->getBrandLine($href, $line->dslinm, $class);
                        }
                        echo "</div>";
//            echo "<div class='col-lg-6'>&nbsp;</div>";
                        echo "</div>"; // close .row.mx-0

                        echo "</div>"; // close .catalogs-header-below.fadeout.w-100
                    }
                    $i++;
                }
            } else if (count($lines) > 0) {
                $i = 1;
                foreach ($lines as $line) {
                    if (!empty($series[$line->cdlinm]) && count($series[$line->cdlinm]) > 0) {
                        $title = Di::getDefault()->get('i18n')->_('_common.linetext');
                        $where = ($catalogAccessType == 0 ? 'catalog/collection/' : 'catalog/list/') . urlencode($line->cdtitl) . '/' . urlencode($line->cdlinm);
                        $href = $this->url->get($where);

                        echo "<div class='catalogs-header-below fadeout w-100' id='cdtitl$i'>";

//            echo "<div class='row mx-0'>";
//            echo "<div class='col-lg-6 text-right'>";
                        echo "<div class='row mx-0 $menuRowClasses'>";
                        echo "<div class='col-12 $menuColClasses'>";
                        echo "<div class='$menuTitleClasses'>";
                        $this->getBrandTitle($title, $href, $line->dslinm);
                        echo "</div>";
                        $class = $this->getListClass(count($series[$line->cdlinm]));
                        foreach ($series[$line->cdlinm] as $serie) {
                            $where = ($catalogAccessType == 0 ? 'catalog/collection/' : 'catalog/list/') . urlencode($line->cdtitl) . '/' . urlencode($line->cdlinm) . '/' . urlencode($serie->cdserm);
                            $href = $this->url->get($where);
                            $this->getBrandLine($href, $serie->dsserm, $class);
                        }
                        echo "</div>";
//            echo "<div class='col-lg-6'>&nbsp;</div>";
                        echo "</div>"; // close .row.mx-0

                        echo "</div>"; // close .catalogs-header-below.fadeout.w-100
                    }
                    $i++;
                }
            }
        }
        if (count($lookbooks) > 0) {
            $this->getLookbookButtonSubHeader($lookbooks);
        }
    }

    public function getNavigationButton($i, $title, $href = null)
    {
        echo "<div class='col open-header-lines' data-cdtitl='cdtitl$i' title='$title'>";
        if ($href == null) {
            echo $title;
        } else {
            echo "<a href='$href' style='text-decoration:none'>$title</a>";
        }
        echo "</div>";
    }

    public function getLookbookButton()
    {
        $title = Di::getDefault()->get('i18n')->_('_common.lookbook');
        echo "<div class='col open-header-lookbooks' title='$title' style='color:#b20000'>$title</div>";
    }

    public function getSalesButton()
    {
        $title = Di::getDefault()->get('i18n')->_('_common.onsale');
        $href = $this->url->get('catalog/sales');
        echo "<div class='col' title='$title'><a href='$href' style='color:#b20000;text-decoration:none'>$title</a></div>";
    }

    public function getGalleriesButton()
    {
        $title = Di::getDefault()->get('i18n')->_('_common.gallery');
        $href = $this->url->get('catalog/gallery');
        echo "<div class='col' title='$title'><a href='$href' style='color:#b20000;text-decoration:none'>$title</a></div>";
    }

    public function getBrandTitle($title, $href, $description)
    {
        echo "<div class='brand-title'>$title <a href='$href'>$description</a></div>";
    }

    private function getListClass($numItems)
    {
        if ($numItems <= 10) {
            return '';
        }
        if ($numItems <= 20) {
            return 'float-left w-50';
        }
        if ($numItems <= 30) {
            return 'float-left w-33';
        }
        if ($numItems <= 40) {
            return 'float-left w-25';
        }
        if ($numItems > 40) {
            return 'float-left w-20';
        };
    }

    public function getBrandLine($href, $description, $style = null)
    {
        echo "<div class='brand-line $style'><a href='$href'>$description</a></div>";
    }

    public function getLookbookButtonSubHeader($lookbooks)
    {
        $title = Di::getDefault()->get('i18n')->_('_common.lookbooktext');
        echo "<div class='catalogs-header-below fadeout w-100' id='lookbooks'>";

        echo "<div class='row mx-0'>";
        echo "<div class='col-lg-6 brand-title text-right'>$title</div>";
        echo "<div class='col-lg-6'>&nbsp;</div>";
        echo "</div>";

        foreach ($lookbooks as $lookbook) {
            $href = $this->url->get('catalog/lookbook/' . $lookbook->cdlkbk);
            echo "<div class='row mx-0'>";
            echo "<div class='col-lg-6 text-right'><a href='$href'>$lookbook->dslkbk</a></div>";
            echo "<div class='col-lg-6'>&nbsp;</div>";
            echo "</div>";
        }

        echo "</div>";
    }

    public function getDefaultNavbarNavigationPlus($brands, $lines, $series, $lookbooks, $sales, $galleries, $classifications, $catalogAccessType, $hide, $noSubmenus = false, $catalogMenuAlignment = 'standard')
    {
        $lang = Di::getDefault()->get('session')->get('language');
        $translator = Di::getDefault()->get('i18n');

        $classificationsCount = count($classifications);
        $totColumns = (count($brands) != 1 ? count($brands) : count($lines)) + $classificationsCount;
        $totColumns += count($lookbooks) > 0 ? 1 : 0;
        $totColumns += count($sales) > 0 ? 1 : 0;
        $totColumns += count($galleries) > 0 ? 1 : 0;

        if ($totColumns > 5 && $classificationsCount > 1) {
            $classifications = [[
                'element' => B2bClassificazione::fakeRootClassification(),
                'sub' => $classifications,
            ]];
            $totColumns -= ($classificationsCount - 1);
        }

        $width = 15 * $totColumns;
        $marginleft = (100 - $width) / 2;
        $style = $width < 50 ? "width:$width%;margin-left:$marginleft%" : '';
        $style2 = $width < 50 ? '' : 'overflow:unset;white-space:normal;padding:0 5px';
        $hideStyle = $hide ? 'style="display:none!important"' : '';

        // Main navigation header
        echo "<div class='catalogs-header d-none d-lg-block w-100 py-20x px-0' $hideStyle>";
        echo "<div class='row' style='$style'>";
        if (count($brands) > 1) {
            $i = 1;
            foreach ($brands as $brand) {
                if ($noSubmenus) {
                    $href = $this->url->get('catalog/collection/' . urlencode($brand->cdtitl));
                    $this->getNavigationButton($i, $brand->dstitl, $href);
                } else {
                    $this->getNavigationButton($i, $brand->dstitl);
                }
                $i++;
            }
        } else if (count($lines) > 0) {
            $i = 1;
            foreach ($lines as $line) {
                if (count($series[$line->cdlinm]) > 0 && !$noSubmenus) {
                    $this->getNavigationButton($i, $line->dslinm);
                } else {
                    $where = ($catalogAccessType == 0 ? 'catalog/collection/' : 'catalog/list/') . urlencode($line->cdtitl) . '/' . $line->cdlinm;
                    $href = $this->url->get($where);
                    $this->getNavigationButton($i, $line->dslinm, $href);
                }
                $i++;
            }
        }

        // Classificazioni
        $i = 1;
        foreach ($classifications as $classification) {
            if (!$classification['element']->enabled) {
                continue;
            }
            $label = $classification['element']->getLabel($lang);
//            $baseUrl = 'catalog/classification/' . urlencode($classification['element']->slug);
            if ($classification['element']->slug !== 'root') {
                $baseUrl = 'catalog/classification/' . $classification['element']->slug;
            } else {
                $baseUrl = 'catalog/classification';
            }
            $href = $this->url->get($baseUrl);
            if (count($classification['sub']) > 0 && !$noSubmenus) {
                $this->getNavigationButtonWithStyle('clsfzn' . $i, $label, $style2);
            } else {
                $this->getNavigationButtonWithStyle('clsfzn' . $i, $label, $style2, $href);
            }
            $i++;
        }

        if (count($lookbooks) > 0) {
            $this->getLookbookButton();
        }
        if (count($sales) > 0) {
            $this->getSalesButton();
        }
        if (count($galleries) > 0) {
            $this->getGalleriesButton();
        }
        echo "</div>"; // Close .row
        echo "</div>"; // Close .catalogs-header

        // Navigation sub-header
        if (!$noSubmenus) {
            $menuRowClasses = '';
            $menuTitleClasses = '';
            $menuColClasses = 'col-md-3 offset-md-3 text-right';
            if (!empty($catalogMenuAlignment) && $catalogMenuAlignment != 'standard') {
                list($catalogMenuAlignmentMode, $catalogMenuAlignmentText) = explode('-', $catalogMenuAlignment, 2);
                if ($catalogMenuAlignmentMode == 'central') {
                    $menuTitleClasses = 'text-center';
                    $menuRowClasses = 'justify-content-center';
                    $menuColClasses = '';
                    if ($catalogMenuAlignmentText != 'center') {
                        $menuColClasses = 'col-md-3 col-lg-2 ';
                    }
                    $menuColClasses .= "text-$catalogMenuAlignmentText";
                }
            }

            if (count($brands) > 1) {
                $i = 1;
                foreach ($brands as $brand) {
                    if (!empty($lines[$brand->cdtitl]) && count($lines[$brand->cdtitl]) > 0) {
                        $title = Di::getDefault()->get('i18n')->_('_common.brandtext');
                        $where = ($catalogAccessType == 0 ? 'catalog/collection/' : 'catalog/list/') . urlencode($brand->cdtitl);
                        $href = $this->url->get($where);

                        echo "<div class='catalogs-header-below fadeout w-100' id='cdtitl$i'>";

                        echo "<div class='row mx-0 $menuRowClasses'>";
//            echo "<div class='col-lg-6 text-right'>";
                        echo "<div class='col-12 $menuColClasses'>";
                        echo "<div class='$menuTitleClasses'>";
                        $this->getBrandTitle($title, $href, $brand->dstitl);
                        echo "</div>";
                        $class = $this->getListClass(count($lines[$brand->cdtitl]));
                        foreach ($lines[$brand->cdtitl] as $line) {
                            $where = ($catalogAccessType == 0 ? 'catalog/collection/' : 'catalog/list/') . urlencode($brand->cdtitl) . '/' . urlencode($line->cdlinm);
                            $href = $this->url->get($where);
                            $this->getBrandLine($href, $line->dslinm, $class);
                        }
                        echo "</div>";
//            echo "<div class='col-lg-6'>&nbsp;</div>";
                        echo "</div>"; // close .row.mx-0

                        echo "</div>"; // close .catalogs-header-below.fadeout.w-100
                    }
                    $i++;
                }
            } else if (count($lines) > 0) {
                $i = 1;
                foreach ($lines as $line) {
                    if (!empty($series[$line->cdlinm]) && count($series[$line->cdlinm]) > 0) {
                        $title = Di::getDefault()->get('i18n')->_('_common.linetext');
                        $where = ($catalogAccessType == 0 ? 'catalog/collection/' : 'catalog/list/') . urlencode($line->cdtitl) . '/' . urlencode($line->cdlinm);
                        $href = $this->url->get($where);

                        echo "<div class='catalogs-header-below fadeout w-100' id='cdtitl$i'>";

//            echo "<div class='row mx-0'>";
//            echo "<div class='col-lg-6 text-right'>";
                        echo "<div class='row mx-0 $menuRowClasses'>";
                        echo "<div class='col-12 $menuColClasses'>";
                        echo "<div class='$menuTitleClasses'>";
                        $this->getBrandTitle($title, $href, $line->dslinm);
                        echo "</div>";
                        $class = $this->getListClass(count($series[$line->cdlinm]));
                        foreach ($series[$line->cdlinm] as $serie) {
                            $where = ($catalogAccessType == 0 ? 'catalog/collection/' : 'catalog/list/') . urlencode($line->cdtitl) . '/' . urlencode($line->cdlinm) . '/' . urlencode($serie->cdserm);
                            $href = $this->url->get($where);
                            $this->getBrandLine($href, $serie->dsserm, $class);
                        }
                        echo "</div>";
//            echo "<div class='col-lg-6'>&nbsp;</div>";
                        echo "</div>"; // close .row.mx-0

                        echo "</div>"; // close .catalogs-header-below.fadeout.w-100
                    }
                    $i++;
                }
            }
            // Classificazioni
            $i = 1;
            foreach ($classifications as $classification) {
                if (!$classification['element']->enabled) {
                    continue;
                }
                $label = $classification['element']->getLabel($lang);
//            $baseUrl = 'catalog/classification/' . urlencode($classification['element']->slug);
                if ($classification['element']->slug !== 'root') {
                    $baseUrl = 'catalog/classification/' . $classification['element']->slug;
                } else {
                    $baseUrl = 'catalog/classification';
                }
                $href = $this->url->get($baseUrl);
                if (count($classification['sub']) > 0) {
                    echo "<div class='catalogs-header-below fadeout w-100' id='clsfzn$i'>";

                    echo "<div class='row mx-0 $menuRowClasses'>";
                    echo "<div class='col-12 $menuColClasses'>";
                    echo "<div class='$menuTitleClasses'>";
                    $this->getBrandTitle($translator->_('_common.classification') . ': ', $href, $label);
                    echo "</div>";
                    $class = $this->getListClass(count($classification['sub']));
                    foreach ($classification['sub'] as $subC) {
                        if (!$subC['element']->enabled) {
                            continue;
                        }
//                    $this->getBrandLine($this->url->get($baseUrl . '/' . urlencode($subC['element']->slug)), $subC['element']->getLabel($lang), $class);
                        $this->getBrandLine($this->url->get($baseUrl . '/' . $subC['element']->slug), $subC['element']->getLabel($lang), $class);
                    }
                    echo "</div>";
                    echo "</div>"; // close .row.mx-0
                    echo "</div>"; // close .catalogs-header-below.fadeout.w-100
                }
                $i++;
            }
        }
        if (count($lookbooks) > 0) {
            $this->getLookbookButtonSubHeader($lookbooks);
        }
    }

    public function getNavigationButtonWithStyle($cdtitl, $title, $style, $href = null)
    {
        echo "<div class='col open-header-lines' data-cdtitl='$cdtitl' title='$title' style='$style'>";
        if ($href == null) {
            echo $title;
        } else {
            echo "<a href='$href' style='text-decoration:none'>$title</a>";
        }
        echo "</div>";
    }

    public function getModelTypesNavigation($modelTypes, $lookbooks, $sales, $galleries)
    {
        $totColumns = count($modelTypes) + (count($lookbooks) > 0 ? 1 : 0) + (count($sales) > 0 ? 1 : 0);
        $width = 20 * $totColumns;
        $marginleft = (100 - $width) / 2;
        $style1 = $width < 50 ? "width:$width%;margin-left:$marginleft%" : 'width:90%;margin-left:5%';
        $style2 = $width < 50 ? '' : 'overflow:unset;white-space:normal;padding:0 5px';

        echo "<div class='catalogs-header d-none d-lg-block w-100 py-20x px-0'>";
        echo "<div class='row' style='$style1'>";
        $i = 1;
        foreach ($modelTypes as $modelType) {
            $href = $this->url->get('catalog/setFilterFromHomepage/TM/' . $modelType->codice);
            $this->getNavigationButtonWithStyle('tpmode' . $i, $modelType->descri, $style2, $href);
            $i++;
        }
        if (count($lookbooks) > 0) {
            $this->getLookbookButton();
        }
        if (count($sales) > 0) {
            $this->getSalesButton();
        }
        if (count($galleries) > 0) {
            $this->getGalleriesButton();
        }
        echo "</div>"; // Close .row
        echo "</div>"; // Close .catalogs-header

        // Navigation sub-header
        if (count($lookbooks) > 0) {
            $this->getLookbookButtonSubHeader($lookbooks);
        }
    }

    public function getGenresNavigation($genres, $lookbooks, $sales, $galleries, $noSubmenus = false, $catalogMenuAlignment = 'standard')
    {
        $totColumns = count($genres) + (count($lookbooks) > 0 ? 1 : 0) + (count($sales) > 0 ? 1 : 0);
        $width = 20 * $totColumns;
        $marginleft = (100 - $width) / 2;
        $style1 = $width < 50 ? "width:$width%;margin-left:$marginleft%" : 'width:90%;margin-left:5%';
        $style2 = $width < 50 ? '' : 'overflow:unset;white-space:normal;padding:0 5px';

        echo "<div class='catalogs-header d-none d-lg-block w-100 py-20x px-0'>";
        echo "<div class='row' style='$style1'>";
        $i = 1;
        foreach ($genres as $genre) {
            if (count($genre['lines']) > 0) {
                $this->getNavigationButtonWithStyle('tpgene' . $i, $genre->descri, $style2);
            } else {
                $href = $this->url->get('catalog/setFilterFromHomepage/GE/' . $genre->codice);
                $this->getNavigationButtonWithStyle('tpgene' . $i, $genre->descri, $style2, $href);
            }
            $i++;
        }
        if (count($lookbooks) > 0) {
            $this->getLookbookButton();
        }
        if (count($sales) > 0) {
            $this->getSalesButton();
        }
        if (count($galleries) > 0) {
            $this->getGalleriesButton();
        }
        echo "</div>"; // Close .row
        echo "</div>"; // Close .catalogs-header

        // Navigation sub-header
        $menuRowClasses = '';
        $menuTitleClasses = '';
        $menuColClasses = 'col-md-3 offset-md-3 text-right';
        if (!empty($catalogMenuAlignment) && $catalogMenuAlignment != 'standard') {
            list($catalogMenuAlignmentMode, $catalogMenuAlignmentText) = explode('-', $catalogMenuAlignment, 2);
            if ($catalogMenuAlignmentMode == 'central') {
                $menuTitleClasses = 'text-center';
                $menuRowClasses = 'justify-content-center';
                $menuColClasses = '';
                if ($catalogMenuAlignmentText != 'center') {
                    $menuColClasses = 'col-md-3 col-lg-2 ';
                }
                $menuColClasses .= "text-$catalogMenuAlignmentText";
            }
        }

        $i = 1;
        foreach ($genres as $genre) {
            if (!empty($genre['lines']) && count($genre['lines']) > 0) {
                $title = Di::getDefault()->get('i18n')->_('_common.brandtext');
                $href = $this->url->get('catalog/setFilterFromHomepage/GE/' . $genre->codice);

                echo "<div class='catalogs-header-below fadeout w-100' id='tpgene$i'>";

//            echo "<div class='row mx-0'>";
//            echo "<div class='col-lg-6 text-right'>";
                echo "<div class='row mx-0 $menuRowClasses'>";
                echo "<div class='col-12 $menuColClasses'>";
                echo "<div class='$menuTitleClasses'>";
                $this->getBrandTitle($title, $href, $genre->descri);
                echo "</div>";
                $class = $this->getListClass(count($genre['lines']));
                foreach ($genre['lines'] as $line) {
                    if ($noSubmenus) {
                        $href = $this->url->get('catalog/setFilterFromHomepage/GL/' . $genre->codice . '/' . urlencode($line->cdtitl) . '/' . urlencode($line->cdlinm));
                        $this->getBrandLine($href, $line->dslinm, $class);
                    } else {
                        $filter = '&fl=GE&cd=' . urlencode($genre->codice);
                        if (count($line['series']) > 0) {
                            $this->getBrandLineButton($class, $line->cdtitl, $line->dslinm, $line['series'], $filter);
                        } else {
                            // TODO ?? qui non era contemplato il listing ??
                            $where = 'catalog/collection/' . urlencode($line->cdtitl) . '/' . urlencode($line->cdlinm) . $filter;
                            $href = $this->url->get($where);
                            $this->getBrandLine($href, $line->dslinm, $class);
                        }
                    }
                }
                echo "</div>";
//        echo "<div class='col-lg-6'>&nbsp;</div>";
                echo "</div>"; // close .row.mx-0

                echo "</div>"; // close .catalogs-header-below.fadeout.w-100
            }
            $i++;
        }
        if (count($lookbooks) > 0) {
            $this->getLookbookButtonSubHeader($lookbooks);
        }
    }

    public function getBrandLineButton($class, $cdtitl, $description, $series, $filter = '')
    {
        echo "<div class='brand-line $class'>";
        echo "<div class='show-series' style='text-transform:none'>$description</div>";
        echo "<div class='brand-line-series-container' style='display:none'>";
        echo "<div class='brand-line-series-content py-10x pr-30x'>";
        $href = $this->url->get('catalog/collection/' . urlencode($cdtitl) . '/' . urlencode($series[0]->cdlinm) . $filter);
        $this->getBrandLine($href, Di::getDefault()->get('i18n')->_('_common.brandalltext'), "m-0");
        foreach ($series as $serie) {
            $where = 'catalog/collection/' . urlencode($cdtitl) . '/' . urlencode($serie->cdlinm) . '/' . urlencode($serie->cdserm) . $filter;
            $href = $this->url->get($where);
            $this->getBrandLine($href, $serie->dsserm, "m-0");
        }
        echo "</div>";
        echo "</div>";
        echo "</div>";
    }

    public function getClassificationsNavigation($classifications, $sales, $noSubmenus = false, $catalogMenuAlignment = 'standard')
    {
        $totColumns = count($classifications) + (count($sales) > 0 ? 1 : 0);

        $lang = Di::getDefault()->get('session')->get('language');
        $translator = Di::getDefault()->get('i18n');

        /* Es. di come potrebbe essere un menu con dropdown a cascata
           <nav class="navbar navbar-light bg-light justify-content-center">
              <ul class="navbar-nav">
                  <li class="nav-item dropdown">
                      <a href="#" id="menu"
                          data-toggle="dropdown" class="nav-link dropdown-toggle"
                          data-display="static">Dropdown</a>
                      <ul class="dropdown-menu">
                          <li class="dropdown-item dropdown-submenu">
                              <a href="#" data-toggle="dropdown" class="dropdown-toggle">Submenu-1</a>
                              <ul class="dropdown-menu">
                                  <li class="dropdown-item">
                                      <a href="#">Item-1</a>
                                  </li>
                                  <li class="dropdown-item">
                                      <a href="#">Item-2</a>
                                  </li>
                                  <li class="dropdown-item">
                                      <a href="#">Item-3</a>
                                  </li>
                              </ul>
                          </li>
                          <li class="dropdown-item dropdown-submenu">
                              <a href="#" data-toggle="dropdown" class="dropdown-toggle">Submenu-2</a>
                              <ul class="dropdown-menu">
                                  <li class="dropdown-item dropdown-submenu">
                                      <a href="#" data-toggle="dropdown" class="dropdown-toggle">Submenu-3</a>
                                      <ul class="dropdown-menu">
                                          <li class="dropdown-item dropdown-submenu">
                                              <a href="#" data-toggle="dropdown" class="dropdown-toggle">Submenu-1</a>
                                              <ul class="dropdown-menu">
                                                  <li class="dropdown-item">
                                                      <a href="#">Item-1</a>
                                                  </li>
                                                  <li class="dropdown-item">
                                                      <a href="#">Item-2</a>
                                                  </li>
                                                  <li class="dropdown-item">
                                                      <a href="#">Item-3</a>
                                                  </li>
                                              </ul>
                                          </li>
                                          <li class="dropdown-item dropdown-submenu">
                                              <a href="#" data-toggle="dropdown" class="dropdown-toggle">Submenu-2</a>
                                              <ul class="dropdown-menu">
                                                  <li class="dropdown-item">
                                                      <a href="#">Item-1</a>
                                                  </li>
                                                  <li class="dropdown-item">
                                                      <a href="#">Item-2</a>
                                                  </li>
                                                  <li class="dropdown-item">
                                                      <a href="#">Item-3</a>
                                                  </li>
                                              </ul>
                                          </li>
                                      </ul>
                                  </li>
                                  <li class="dropdown-item">
                                      <a href="#">Item-2</a>
                                  </li>
                                  <li class="dropdown-item">
                                      <a href="#">Item-3</a>
                                  </li>
                              </ul>
                          </li>
                      </ul>
                  </li>
              </ul>
          </nav>
        */

        if ($totColumns > 5) {
            $classifications = [[
                'element' => B2bClassificazione::fakeRootClassification(),
                'sub' => $classifications,
            ]];
            $totColumns = 1 + (count($sales) > 0 ? 1 : 0);
        }

        $width = 20 * $totColumns;
        $marginLeft = (100 - $width) / 2;
        $style1 = $width < 50 ? "width:$width%;margin-left:$marginLeft%" : 'width:90%;margin-left:5%';
        $style2 = $width < 50 ? '' : 'overflow:unset;white-space:normal;padding:0 5px';

        // Navigation sub-header
        $menuRowClasses = '';
        $menuTitleClasses = '';
        $menuColClasses = 'col-md-3 offset-md-3 text-right';
        if (!empty($catalogMenuAlignment) && $catalogMenuAlignment != 'standard') {
            list($catalogMenuAlignmentMode, $catalogMenuAlignmentText) = explode('-', $catalogMenuAlignment, 2);
            if ($catalogMenuAlignmentMode == 'central') {
                $menuTitleClasses = 'text-center';
                $menuRowClasses = 'justify-content-center';
                $menuColClasses = '';
                if ($catalogMenuAlignmentText != 'center') {
                    $menuColClasses = 'col-md-3 col-lg-2 ';
                }
                $menuColClasses .= "text-$catalogMenuAlignmentText";
            }
        }

        echo "<div class='catalogs-header d-none d-lg-block w-100 py-20x px-0'>";
        echo "<div class='row' style='$style1'>";
        $i = 1;

        $submenuContent = '';
        foreach ($classifications as $classification) {
            if (!$classification['element']->enabled) {
                continue;
            }
            $label = $classification['element']->getLabel($lang);
//            $baseUrl = 'catalog/classification/' . urlencode($classification['element']->slug);
            if ($classification['element']->slug !== 'root') {
                $baseUrl = 'catalog/classification/' . $classification['element']->slug;
            } else {
                $baseUrl = 'catalog/classification';
            }
            $href = $this->url->get($baseUrl);
            if (count($classification['sub']) > 0 && !$noSubmenus) {
                $this->getNavigationButtonWithStyle('clsfzn' . $i, $label, $style2);
                ob_start();
                echo "<div class='catalogs-header-below fadeout w-100' id='clsfzn$i'>";

                echo "<div class='row mx-0 $menuRowClasses'>";
                echo "<div class='col-12 $menuColClasses'>";
                echo "<div class='$menuTitleClasses'>";
                $this->getBrandTitle($translator->_('_common.classification') . ': ', $href, $label);
                echo "</div>";
                $class = $this->getListClass(count($classification['sub']));
                foreach ($classification['sub'] as $subC) {
                    if (!$subC['element']->enabled) {
                        continue;
                    }
//                    $this->getBrandLine($this->url->get($baseUrl . '/' . urlencode($subC['element']->slug)), $subC['element']->getLabel($lang), $class);
                    $this->getBrandLine($this->url->get($baseUrl . '/' . $subC['element']->slug), $subC['element']->getLabel($lang), $class);
                }
                echo "</div>";
                echo "</div>"; // close .row.mx-0
                echo "</div>"; // close .catalogs-header-below.fadeout.w-100
                $submenuContent .= ob_get_clean();
            } else {
                $this->getNavigationButtonWithStyle('clsfzn' . $i, $label, $style2, $href);
            }
            $i++;
        }

        if (count($sales) > 0) {
            $this->getSalesButton();
        }

        echo "</div>"; // Close .row
        echo "</div>"; // Close .catalogs-header
        echo $submenuContent;
    }

    public function getCustomMenuNavigation($customMenuItems, $lookbooks, $sales, $galleries, $catalogMenuAlignment = 'standard')
    {
        $totColumns = count($customMenuItems) + (count($lookbooks) > 0 ? 1 : 0) + (count($sales) > 0 ? 1 : 0);
        $width = 20 * $totColumns;
        $marginleft = (100 - $width) / 2;
        $style1 = $width < 50 ? "width:$width%;margin-left:$marginleft%" : 'width:90%;margin-left:5%';
        $style2 = $width < 50 ? '' : 'overflow:unset;white-space:normal;padding:0 5px';

        $descriptionVar = 'des_' . ($this->session->has('language') ? $this->session->get('language') : 'it');
        echo "<div class='catalogs-header d-none d-lg-block w-100 py-20x px-0'>";
        echo "<div class='row' style='$style1'>";

        $i = 1;
        foreach ($customMenuItems as $item) {
            switch ($item->tpdato) {
                case 'BR':
                    if ($item->flsblv == 1 && count($item->subItems) > 0) {
                        $this->getNavigationButtonWithStyle('BR' . $i, $item->$descriptionVar, $style2);
                    } else {
                        $href = $this->url->get('catalog/collection/' . urlencode($item->codic1));
                        $this->getNavigationButtonWithStyle('BR' . $i, $item->$descriptionVar, $style2, $href);
                    }
                    break;
                case 'LM':
                    if ($item->flsblv == 1 && count($item->subItems) > 0) {
                        $this->getNavigationButtonWithStyle('LM' . $i, $item->$descriptionVar, $style2);
                    } else {
                        $href = $this->url->get('catalog/collection/' . urlencode($item->lm_cdtitl) . '/' . $item->codic1);
                        $this->getNavigationButtonWithStyle('LM' . $i, $item->$descriptionVar, $style2, $href);
                    }
                    break;
                case 'SM':
                    $href = $this->url->get('catalog/collection/' . urlencode($item->sm_cdtitl) . '/' . $item->codic1 . '/' . $item->codic2);
                    $this->getNavigationButtonWithStyle('SM' . $i, $item->$descriptionVar, $style2, $href);
                    break;
                case 'TG':
                    if ($item->flsblv == 1 && count($item->subItems) > 0) {
                        $this->getNavigationButtonWithStyle('TG' . $i, $item->$descriptionVar, $style2);
                    } else {
                        $href = $this->url->get('catalog/setFilterFromHomepage/GE/' . $item->codic1);
                        $this->getNavigationButtonWithStyle('TG' . $i, $item->$descriptionVar, $style2, $href);
                    }
                    break;
                case 'TM':
                    if ($item->flsblv == 1 && count($item->subItems) > 0) {
                        $this->getNavigationButtonWithStyle('TM' . $i, $item->$descriptionVar, $style2);
                    } else {
                        $href = $this->url->get('catalog/setFilterFromHomepage/TM/' . $item->codic1);
                        $this->getNavigationButtonWithStyle('TM' . $i, $item->$descriptionVar, $style2, $href);
                    }
                    break;
                case 'SS':
                    $href = $this->url->get('catalog/selection/' . $item->codic1);
                    $this->getNavigationButtonWithStyle('SS' . $i, $item->$descriptionVar, $style2, $href);
                    break;
                case 'LK':
                    // TODO
                    break;
                case 'SL':
                    // TODO
                    break;
                case 'GL':
                    // TODO
                    break;
            }
            $i++;
        }
        if (count($lookbooks) > 0) {
            $this->getLookbookButton();
        }
        if (count($sales) > 0) {
            $this->getSalesButton();
        }
        if (count($galleries) > 0) {
            $this->getGalleriesButton();
        }
        echo "</div>"; // Close .row
        echo "</div>"; // Close .catalogs-header

        // Navigation sub-header
        $menuRowClasses = '';
        $menuTitleClasses = '';
        $menuColClasses = 'col-md-3 offset-md-3 text-right';
        if (!empty($catalogMenuAlignment) && $catalogMenuAlignment != 'standard') {
            list($catalogMenuAlignmentMode, $catalogMenuAlignmentText) = explode('-', $catalogMenuAlignment, 2);
            if ($catalogMenuAlignmentMode == 'central') {
                $menuTitleClasses = 'text-center';
                $menuRowClasses = 'justify-content-center';
                $menuColClasses = '';
                if ($catalogMenuAlignmentText != 'center') {
                    $menuColClasses = 'col-md-3 col-lg-2 ';
                }
                $menuColClasses .= "text-$catalogMenuAlignmentText";
            }
        }

        $i = 1;
        foreach ($customMenuItems as $item) {
            if ($item->flsblv == 1 && !empty($item->subItems) && count($item->subItems) > 0) {
                switch ($item->tpdato) {
                    case 'BR':
                        $title = Di::getDefault()->get('i18n')->_('_common.brandtext');
                        $href = $this->url->get('catalog/collection/' . urlencode($item->codic1));

                        echo "<div class='catalogs-header-below fadeout w-100' id='BR$i'>";

//            echo "<div class='row mx-0'>";
//            echo "<div class='col-lg-6 text-right'>";
                        echo "<div class='row mx-0 $menuRowClasses'>";
                        echo "<div class='col-12 $menuColClasses'>";
                        echo "<div class='$menuTitleClasses'>";
                        $this->getBrandTitle($title, $href, $item->$descriptionVar);
                        echo "</div>";

                        $class = $this->getListClass(count($item->subItems));
                        foreach ($item->subItems as $line) {
                            if (count($line->subItems) > 0) {
                                $this->getBrandLineButton($class, $item->codic1, $line->dslinm, $line->subItems);
                            } else {
                                $href = $this->url->get('catalog/collection/' . urlencode($item->codic1) . '/' . urlencode($line->cdlinm));
                                $this->getBrandLine($href, $line->dslinm, $class);
                            }
                        }
                        echo "</div>";
//            echo "<div class='col-lg-6'>&nbsp;</div>";
                        echo "</div>"; // close .row.mx-0

                        echo "</div>"; // close .catalogs-header-below.fadeout.w-100
                        break;
                    case 'LM':
                        $title = Di::getDefault()->get('i18n')->_('_common.linetext');
                        $href = $this->url->get('catalog/collection/' . urlencode($item->lm_cdtitl) . '/' . urlencode($item->codic1));

                        echo "<div class='catalogs-header-below fadeout w-100' id='LM$i'>";

//            echo "<div class='row mx-0'>";
//            echo "<div class='col-lg-6 text-right'>";
                        echo "<div class='row mx-0 $menuRowClasses'>";
                        echo "<div class='col-12 $menuColClasses'>";
                        echo "<div class='$menuTitleClasses'>";
                        $this->getBrandTitle($title, $href, $item->$descriptionVar);
                        echo "</div>";
                        $class = $this->getListClass(count($item->subItems));
                        foreach ($item->subItems as $serie) {
                            $href = $this->url->get('catalog/collection/' . urlencode($item->lm_cdtitl) . '/' . urlencode($item->codic1) . '/' . urlencode($serie->cdserm));
                            $this->getBrandLine($href, $serie->dsserm, $class);
                        }
                        echo "</div>";
//            echo "<div class='col-lg-6'>&nbsp;</div>";
                        echo "</div>"; // close .row.mx-0

                        echo "</div>"; // close .catalogs-header-below.fadeout.w-100
                        break;
                    case 'SM':
                    case 'SS':
                    case 'SL':
                        // Nothing to do here.
                        break;
                    case 'TG':
                        $title = Di::getDefault()->get('i18n')->_('_common.brandtext');
                        $href = $this->url->get('catalog/setFilterFromHomepage/GE/' . $item->codic1);

                        echo "<div class='catalogs-header-below fadeout w-100' id='TG$i'>";

//            echo "<div class='row mx-0'>";
//            echo "<div class='col-lg-6 text-right'>";
                        echo "<div class='row mx-0 $menuRowClasses'>";
                        echo "<div class='col-12 $menuColClasses'>";
                        echo "<div class='$menuTitleClasses'>";
                        $this->getBrandTitle($title, $href, $item->$descriptionVar);
                        echo "</div>";
                        $class = $this->getListClass(count($item->subItems));
                        foreach ($item->subItems as $line) {
                            $filter = '&fl=GE&cd=' . urlencode($item->codic1);
                            if (count($line->subItems) > 0) {
                                $this->getBrandLineButton($class, $line->cdtitl, $line->dslinm, $line->subItems, $filter);
                            } else {
                                // TODO ?? qui non era contemplato il listing ??
                                $where = 'catalog/collection/' . urlencode($line->cdtitl) . '/' . urlencode($line->cdlinm) . $filter;
                                $href = $this->url->get($where);
                                $this->getBrandLine($href, $line->dslinm, $class);
                            }
                        }
                        echo "</div>";
//            echo "<div class='col-lg-6'>&nbsp;</div>";
                        echo "</div>"; // close .row.mx-0

                        echo "</div>"; // close .catalogs-header-below.fadeout.w-100
                        break;
                    case 'TM':
                        $title = Di::getDefault()->get('i18n')->_('_common.brandtext');
                        $href = $this->url->get('catalog/setFilterFromHomepage/TM/' . $item->codic1);

                        echo "<div class='catalogs-header-below fadeout w-100' id='TM$i'>";

//            echo "<div class='row mx-0'>";
//            echo "<div class='col-lg-6 text-right'>";
                        echo "<div class='row mx-0 $menuRowClasses'>";
                        echo "<div class='col-12 $menuColClasses'>";
                        echo "<div class='$menuTitleClasses'>";
                        $this->getBrandTitle($title, $href, $item->$descriptionVar);
                        echo "</div>";
                        $class = $this->getListClass(count($item->subItems));
                        foreach ($item->subItems as $line) {
                            $filter = '&fl=TM&cd=' . urlencode($item->codic1);
                            if (count($line->subItems) > 0) {
                                $this->getBrandLineButton($class, $line->cdtitl, $line->dslinm, $item->subItems, $filter);
                            } else {
                                // TODO ?? qui non era contemplato il listing ??
                                $where = 'catalog/collection/' . urlencode($line->cdtitl) . '/' . urlencode($line->cdlinm) . $filter;
                                $href = $this->url->get($where);
                                $this->getBrandLine($href, $line->dslinm, $class);
                            }
                        }
                        echo "</div>";
//            echo "<div class='col-lg-6'>&nbsp;</div>";
                        echo "</div>"; // close .row.mx-0

                        echo "</div>"; // close .catalogs-header-below.fadeout.w-100
                        break;
                    case 'LK':
                        // TODO
                        break;
                    case 'SL':
                        // TODO
                        break;
                    case 'GL':
                        // TODO
                        break;
                }
            }
            $i++;
        }

        if (count($lookbooks) > 0) {
            $this->getLookbookButtonSubHeader($lookbooks);
        }
    }

    //endregion


    public function getSearchActionUrl()
    {
        $di = $this->getDI();
        $utility = $di->get('utility');
        $urlUtil = $di->get('url');
        $actionUrl = $urlUtil->get('catalog/results');
        $session = $di->get('session');
        if ($session->has('ctl_view_mode')) {
            $viewMode = $session->get('ctl_view_mode');
            if ($viewMode == 'quickorder') {
                $actionUrl = $urlUtil->get('catalog/resultsquickorder');
            } else if (empty($utility->getAppSettings('EnableVisualView')) || $viewMode == 'list') {
                $actionUrl = $urlUtil->get('catalog/resultslist');
            }
        } else if ($utility->getAppSettings('CatalogAccessType') == 1) {
            $actionUrl = $urlUtil->get('catalog/resultslist');
        }

        return $actionUrl;
    }
}
