<?php

namespace Go2B\Library;

use Go2B\Controllers\ControllerBase;
use Go2B\Controllers\Utility;
use Go2B\Models\Anaart;
use Go2B\Models\Artcla;
use Go2B\Models\Artcrt;
use Go2B\Models\B2bFlcorp;
use Go2B\Models\B2bFltest;
use Go2B\Models\B2bFlvisi;
use Go2B\Models\Linmod;
use Go2B\Models\Postgl;
use Go2B\Models\Sermod;
use Go2B\Models\Tipcla;
use Go2B\Models\Titlin;
use Go2B\Models\Tpcrar;
use Go2B\Models\Tpgene;
use Go2B\Models\Tpmode;
use Phalcon\Di;

class Filters
{
    //region Get filters
    public function getDefaultFilters($cdcata, $itemsAndLang, $getFabric = true)
    {
        $filters = array();

        $lang = $itemsAndLang['lang'];

        $commonFilters = array('dscolo', 'tpmode', 'tpgene', 'taglia', 'cdpers', 'prezzo');
        $classificationFilters = Tipcla::getFilterTagsByCatalog($cdcata);
        $additionalFilters = Tpcrar::getAdditionalFilters();
        $translator = Utility::getTranslatorFor();

        foreach ($commonFilters as $filter) {
            $currentFilter = B2bFlvisi::getCommonFilterVisibility($filter);
            $filters[$filter] = array(
                'type' => 0,
                'index' => $currentFilter['seqrap'],
                'name' => $filter,
                'hidden' => $currentFilter['flbloc']
            );
            if ($currentFilter['flbloc'] == 0 && $filter != 'prezzo') {
                $filters[$filter]['custom'] = B2bFltest::getAllArticleCustomFilterFromCatalog($cdcata, $filter, $itemsAndLang);
                switch ($filter) {
                    case 'dscolo':
                        $filters[$filter]['default'] = Anaart::getAllArticleColorsFromCatalog($cdcata, $itemsAndLang);
                        $filters[$filter]['context'] = 'AR';
                        $filters[$filter]['description'] = $currentFilter['des_' . $lang] != '' ? $currentFilter['des_' . $lang] :  $translator->_('_common.filter.color');
                        break;
                    case 'tpmode':
                        $filters[$filter]['default'] = Tpmode::getAllArticleModelTypesFromCatalog($cdcata, $itemsAndLang);
                        $filters[$filter]['context'] = 'AN';
                        $filters[$filter]['description'] = $currentFilter['des_' . $lang] != '' ? $currentFilter['des_' . $lang] : $translator->_('_common.filter.type');
                        break;
                    case 'tpgene':
                        $filters[$filter]['default'] = Tpgene::getAllArticleGenresFromCatalog($cdcata, $itemsAndLang);
                        $filters[$filter]['context'] = 'AN';
                        $filters[$filter]['description'] = $currentFilter['des_' . $lang] != '' ? $currentFilter['des_' . $lang] : $translator->_('_common.filter.genre');
                        break;
                    case 'cdpers':
                        $filters[$filter]['default'] = Anaart::getAllArticleFabricsFromCatalog($cdcata, $itemsAndLang);
                        $filters[$filter]['context'] = 'AR';
                        $filters[$filter]['description'] = $currentFilter['des_' . $lang] != '' ? $currentFilter['des_' . $lang] : $translator->_('_common.filter.tissue');
                        break;
                    case 'taglia':
                        $filters[$filter]['default'] = Postgl::getAllArticleSizeCodesFromCatalog($cdcata, $itemsAndLang);
                        $filters[$filter]['context'] = 'TG';
                        $filters[$filter]['description'] = $currentFilter['des_' . $lang] != '' ? $currentFilter['des_' . $lang] : $translator->_('_common.filter.size');
                        break;
                }
            } else {
                $filters[$filter]['context'] = 'LS';
                $filters[$filter]['description'] = $currentFilter['des_' . $lang] != '' ? $currentFilter['des_' . $lang] : $translator->_('_common.filter.price');
            }
        }

        $i = 1;
        foreach ($classificationFilters as $filter) {
            $filters['tipcla' . $i] = array(
                'type' => 2,
                'index' => $filter['seqrap'],
                'description' => $filter['des_' . $lang],
                'name' => 'tipcla',
                'context' => 'TC',
                'hidden' => $currentFilter['flbloc'],
                'default' => Artcla::getTags($cdcata)
            );
            $i++;
        }

        $i = 1;
        foreach ($additionalFilters as $filter) {
            $currentFilter = B2bFlvisi::getAdditionalFilterVisibility($filter['tpinpu'], $filter['tpcrar']);
            $filters['addflt' . $i] = array(
                'type' => 1,
                'index' => $currentFilter['seqrap'],
                'description' => $currentFilter['des_' . $lang] != '' ? $currentFilter['des_' . $lang] : $filter['dscrar'],
                'name' => $filter['tpcrar'],
                'context' => $filter['tpinpu'],
                'hidden' => $currentFilter['flbloc'],
                'default' => Artcrt::getAllAdditionalTypeFromCatalog($cdcata, $itemsAndLang, $filter['tpinpu'], $filter['tpcrar'])
            );
            $i++;
        }

        return $filters;
    }

    public function getFiltersFromSeries($cdcata, $cdlinm, $cdserm, $lang)
    {
        $itemsAndLang = array('from' => 'sermod', 'code1' => $cdlinm, 'code2' => $cdserm, 'lang' => $lang);
        $filters = $this->getDefaultFilters($cdcata, $itemsAndLang);
        return $filters;
    }

    public function getFiltersFromLine($cdcata, $cdlinm, $lang)
    {
        $itemsAndLang = array('from' => 'linmod', 'code' => $cdlinm, 'lang' => $lang);
        $filters = $this->getDefaultFilters($cdcata, $itemsAndLang);
        $filters['sermod'] = Sermod::getAllSeriesFromLine($cdcata, $cdlinm);
        return $filters;
    }

    public function getFiltersFromBrand($cdcata, $cdtitl, $lang)
    {
        $itemsAndLang = array('from' => 'titlin', 'code' => $cdtitl, 'lang' => $lang);
        $filters = $this->getDefaultFilters($cdcata, $itemsAndLang);
        $filters['linmod'] = $this->getAllLinesSeriesFromBrand($cdcata, $cdtitl);
        return $filters;
    }

    public function getFilters($cdcata, $lang)
    {
        $itemsAndLang = array('from' => 'all', 'lang' => $lang);
        $filters = $this->getDefaultFilters($cdcata, $itemsAndLang);
        $filters['titlin'] = $this->getAllBrands($cdcata);
        return $filters;
    }

    public function getFiltersForFabric($cdcata, $cdpers, $lang)
    {
        $itemsAndLang = array('from' => 'all', 'cdpers' => $cdpers, 'lang' => $lang);
        $filters = $this->getDefaultFilters($cdcata, $itemsAndLang, false);
        $filters['titlin'] = $this->getAllBrands($cdcata);
        return $filters;
    }
    //endregion

    //region Set filters
    public function setFilters($filters)
    {
        $session = Di::getDefault()->get('session');
        $session->remove('filters');
        $indexedFilters = [];
        foreach ($filters as $filter) {
            $indexedFilters[$filter['name']] = $filter;
        }
        $session->set('filters', $indexedFilters);
    }

    public function resetFilters()
    {
        $session = Di::getDefault()->get('session');
        $session->remove('filters');
    }
    //endregion

    //region Get applied filters
    public function getApplyFilters()
    {
        $controller = new ControllerBase();
        $filters = $controller->session->get('filters');
        return $filters;
    }
    //endregion

    //region Get sub query filter
    public function getFilterSubQuery()
    {
        $filters = $this->getApplyFilters();

        $andWhere = '';
        $innerJoins = '';
        $contexts = array();
        $indexArtcrt = 0;
        $arttgl = '';
        if (!empty($filters) && count($filters) > 0) {
            foreach ($filters as $filter) {
                if (isset($filter['filter']) && count($filter['filter']) > 0) {
                    if (!in_array($filter['context'], $contexts)) {
                        $contexts[] = $filter['context'];
                    }

                    if ($filter['type'] == 1) {
                        // Additional filters
                        $inClause = '';
                        foreach ($filter['filter'] as $el) {
                            $inClause .= "'" . $el . "',";
                        }
                        $alias = 'a' . $indexArtcrt;
                        $codice = $filter['context'] == 'AN' ? 'tp.cdartn' : 'aa.cdarti';
                        $innerJoins .= ' INNER JOIN Go2B\Models\Artcrt ' . $alias . ' ';
                        $innerJoins .= 'ON ' . $alias . '.tpinpu = "' . $filter['context'] . '" ';
                        $innerJoins .= 'AND ' . $alias . '.codice = ' . $codice . ' ';
                        $innerJoins .= 'AND ' . $alias . '.tpcrar = "' . $filter['name'] . '" ';
                        $innerJoins .= 'AND ' . $alias . '.valore IN (' . rtrim($inClause, ',') . ') ';

                        $indexArtcrt++;
                    } else if ($filter['type'] == 2) {
                        // Tipcla filters
                        foreach ($filter['filter'] as $item) {
                            $innerJoins .= ' INNER JOIN Go2B\Models\Artcla ac ON ac.tpinpu = "AN" AND ac.codice = aa.cdartn AND ac.tpclas = "' . $item['code1'] . '" AND ac.valore = "' . $item['code2'] . '" ';
                        }
                    } else if ($filter['type'] == 0) {
                        // Common filters
                        $field = $filter['name'];
                        $values = $filter['filter'];
                        if ($filter['custom'] == 1) {
                            // Custom filters
                            // Leonardo Bravi - tanto questa riga non funzionava dato che stava sola soletta in questo blocco e non settava nulla
                            // $inClause .= $this->getCodesFromNutpfl($el);

                            if (in_array($filter['name'], ['b2bcla']) && !empty($values)) {
                                switch ($filter['context']) {
                                    case 'CF':
                                        $field = 'mi.' . $filter['name'];
                                        break;
                                }

                                $andWhere .= 'AND (';
                                for ($i = 1; $i < 5; $i++) {
                                    // Campi custom presenti in B2bModInf [clsfz1, clsfz2, clsfz3, clsfz4]
                                    if ($i > 1) {
                                        $andWhere .= ' OR ';
                                    }
                                    $andWhere .= 'mi.clsfz' . $i . ' IN (\'' . implode('\',\'', $values) . '\')';
                                }
                                $andWhere .= ')';

                                // Resetto values dato che ho gestito i campi multipli direttamente in questo blocco
                                $values = [];
                            }
                        } else if (in_array($filter['name'], ['titlin', 'linmod', 'sermod', 'prezzo'])) {
                            continue;
                        } else {
                            switch ($filter['context']) {
                                case 'AN':
                                    $field = 'tp.' . $filter['name'];
                                    break;
                                case 'AR':
                                    $field = 'aa.' . $filter['name'];
                                    break;
                                case 'TG':
                                    $field = 'pt.' . $filter['name'];
                                    $arttgl = ' AND dc2.taglia IN (' . implode(',', $values) . ')';
                                    break;
                            }
                        }

                        if (!empty($values)) {
                            if (is_string($values)) {
                                $andWhere .= ' AND ' . $field . ' IN (' . rtrim($values, ',') . ')';
                            } else if (is_array($values)) {
                                $andWhere .= ' AND ' . $field . ' IN (\'' . implode('\',\'', $values) . '\')';
                            }
                        }
                    }
                }
            }
        }

        // Structure filter
        $structureFilter = '';
        $brandWhere = $lineWhere = $seriesWhere = "";
        if (isset($filters['titlin']['filter']) && count($filters['titlin']['filter']) > 0) {
            foreach ($filters['titlin']['filter'] as $el) {
                $brandWhere .= "'" . $el . "',";
            }
        }
        if (isset($filters['linmod']['filter']) && count($filters['linmod']['filter']) > 0) {
            foreach ($filters['linmod']['filter'] as $el) {
                $lineWhere .= "'" . $el . "',";
            }
        }
        if (isset($filters['sermod']['filter']) && count($filters['sermod']['filter']) > 0) {
            foreach ($filters['sermod']['filter'] as $el) {
                $seriesWhere .= " OR (tp.cdlinm = '" . $el[0] . "' AND tp.cdserm = '" . $el[1] . "') ";
            }
        }
        if ($brandWhere != '' || $lineWhere != '' || $seriesWhere != '') {
            if ($brandWhere != '') {
                $structureFilter = " lm.cdtitl IN (" . rtrim($brandWhere, ",") . ")";
            }
            if ($lineWhere != '') {
                $structureFilter .= ($structureFilter != '' ? " AND " : '') . "  tp.cdlinm IN (" . rtrim($lineWhere, ",") . ")";
            }
            if ($seriesWhere != '') {
                $structureFilter .= ($structureFilter != '' ? " AND " : '') . "  (" . substr($seriesWhere, 3) . ")";
            }

            $andWhere .= ' AND (' . $structureFilter . ')';
        }

        // Price filter
        $priceWhere = '';
        if (isset($filters['prezzo']) && isset($filters['prezzo']['filter'])) {
            if (isset($filters['prezzo']['filter']['min']) && $filters['prezzo']['filter']['min'] > -1) {
                $priceWhere .= ($priceWhere != '' ? ' AND ' : '') . " catalogPrice >= " . $filters['prezzo']['filter']['min'];
            }
            if (isset($filters['prezzo']['filter']['max']) && $filters['prezzo']['filter']['max'] > -1) {
                $priceWhere .= ($priceWhere != '' ? ' AND ' : '') . " catalogPrice <= " . $filters['prezzo']['filter']['max'];
            }
        }

        return array(
            'apply' => $filters,
            'where' => $andWhere,
            'aatgl' => $arttgl,
            'price' => $priceWhere,
            'joins' => $innerJoins,
            'contexts' => $contexts,
        );
    }

    public function getCodesFromNutpfl($nutpfl)
    {
        $flcorp = B2bFlcorp::findByNutpfl($nutpfl);
        $res = '';
        foreach ($flcorp as $el) {
            $res .= "'" . $el->codice . "',";
        }
        return $res;
    }
    //endregion

    //region Brands, lines, series
    public function getAllLinesSeriesFromBrand($cdcata, $cdtitl, $linmod = null)
    {
        $linmod = Linmod::getAllLinesFromBrand($cdcata, $cdtitl);

        $full_linmod = array();
        for ($i = 0; $i < count($linmod); $i++) {
            $curr_linmod = $linmod[$i];
            $curr_linmod->sermod = Sermod::getAllSeriesFromLine($cdcata, $linmod[$i]->cdlinm);
            $full_linmod[] = $curr_linmod;
        }

        return $full_linmod;
    }

    public function getAllBrands($cdcata, $titlin = null)
    {
        $titlin = $titlin != null ? Titlin::getAllBrandsFromCode($titlin) : Titlin::getAllSimpleFromCatalog($cdcata);

        $full_titlin = array();
        for ($i = 0; $i < count($titlin); $i++) {
            $curr_titlin = $titlin[$i];
            $curr_titlin->linmod = $this->getAllLinesSeriesFromBrand($cdcata, $titlin[$i]->cdtitl);
            $full_titlin[] = $curr_titlin;
        }

        return $full_titlin;
    }

    public function setFilterForSeries($cdlinm, $cdserm)
    {
        // Set filter for current series and brand and line that it belongs
        $controller = new ControllerBase();
        $filters = $controller->session->has('filters') ? $controller->session->get('filters') : array();
        $filters['sermod'] = array(
            'name' => 'sermod',
            'context' => 'AN',
            'type' => 0,
            'custom' => 0,
            'filter' => array(array($cdlinm, $cdserm))
        );
        $filters['linmod'] = array(
            'name' => 'linmod',
            'context' => 'AN',
            'type' => 0,
            'custom' => 0,
            'filter' => array($cdlinm)
        );

        $linmod = Linmod::findFirstByCdlinm($cdlinm);
        $filters['titlin'] = array(
            'name' => 'titlin',
            'context' => 'LM',
            'type' => 0,
            'custom' => 0,
            'filter' => array($linmod->cdtitl)
        );
        $controller->session->set('filters', $filters);
    }

    public function setFilterForLine($cdlinm)
    {
        // Set filter for current line and all its series and brand it belongs
        $controller = new ControllerBase();
        $filters = $controller->session->has('filters') ? $controller->session->get('filters') : array();
        $filters['linmod'] = array(
            'name' => 'linmod',
            'context' => 'AN',
            'type' => 0,
            'custom' => 0,
            'filter' => array($cdlinm)
        );

        $linmod = Linmod::findFirstByCdlinm($cdlinm);
        $filters['titlin'] = array(
            'name' => 'titlin',
            'context' => 'LM',
            'type' => 0,
            'custom' => 0,
            'filter' => array($linmod->cdtitl)
        );

        $sm_flt = [];

        $sermod = Sermod::findByCdlinm($cdlinm);
        for ($j = 0; $j < count($sermod); $j++) {
            $sm_flt[] = array($sermod[$j]->cdlinm, $sermod[$j]->cdserm);
        }

        $filters['sermod'] = array(
            'name' => 'sernmod',
            'context' => 'AN',
            'type' => 0,
            'custom' => 0,
            'filter' => $sm_flt
        );
        $controller->session->set('filters', $filters);
    }

    public function setFilterForBrand($cdtitl)
    {
        // Set filter for current brand and all its lines and series
        $controller = new ControllerBase();
        $filters = $controller->session->has('filters') ? $controller->session->get('filters') : array();
        $filters['titlin'] = array(
            'name' => 'titlin',
            'context' => 'LM',
            'type' => 0,
            'custom' => 0,
            'filter' => array($cdtitl)
        );

        $linmod = Linmod::findByCdtitl($cdtitl);

        $lm_flt = [];
        $sm_flt = [];

        for ($i = 0; $i < count($linmod); $i++) {
            $lm_flt[] = $linmod[$i]->cdlinm;

            $sermod = Sermod::findByCdlinm($linmod[$i]->cdlinm);

            for ($j = 0; $j < count($sermod); $j++) {
                $sm_flt[] = array($sermod[$j]->cdlinm, $sermod[$j]->cdserm);
            }
        }

        $filters['linmod'] = array(
            'name' => 'linmod',
            'context' => 'AN',
            'type' => 0,
            'custom' => 0,
            'filter' => $lm_flt
        );

        $filters['sermod'] = array(
            'name' => 'sernmod',
            'context' => 'AN',
            'type' => 0,
            'custom' => 0,
            'filter' => $sm_flt
        );
        $controller->session->set('filters', $filters);
    }
    //endregion
}
