<?php

namespace Go2B\Library;

use Go2B\Controllers\ControllerBase;
use Go2B\Controllers\Utility;
use Phalcon\Mvc\User\Component;
use Go2B\Models\Anaart;

/**
 * Elements
 *
 * Helps to build UI elements for the application
 */
class Elements extends Component
{
    //region Model detail image sliders
    public function getModelThumbnailList($model, $description, $isMobile)
    {
        $class = $isMobile ? 'model-thumblist-mobile d-block d-lg-none' : 'model-thumblist-desktop d-none d-lg-block';

        echo '<ul class="product-gallery-thumblist ' . $class . ' model-gallery">';

        echo '<li class="active"><a href="#preview0">' . $this->getModelImgOrDefaultHtml($model->flimag, $description) . '</a></li>';
        for ($i = 0; $i < count($model->imgart); $i++) {
            $index = $i + 1;
            echo '<li>';
            echo '<a href="#preview' . $index . '">' . $this->getModelImgOrDefaultHtml($model->imgart[$i]->flimag, $description) . '</a>';
            echo '</li>';
        }

        echo '</ul>';
    }

    public function getArticleThumbnailList($article, $isMobile)
    {
        $class = $isMobile ? 'article-thumblist-mobile d-block d-lg-none' : 'article-thumblist-desktop d-none d-lg-block';

        echo '<ul class="product-gallery-thumblist ' . $class . ' article-gallery" data-cdarti="' . $article->cdarti . '">';

        $id = str_replace(' ', '-', $article->cdarti);
        echo '<li class="active"><a href="#preview0-' . $id . '">';
        echo $this->getModelImgOrDefaultHtml($article->flimag, $article->cdarti);
        echo '</a></li>';
        for ($i = 0; $i < count($article->imgart); $i++) {
            $index = $i + 1;
            echo '<li><a href="#preview' . $index . '-' . $id . '">';
            echo $this->getModelImgOrDefaultHtml($article->imgart[$i]->flimag, $article->cdarti);
            echo '</a></li>';
        }

        echo '</ul>';
    }

    public function getColorThumbnailList($color, $isMobile)
    {
        $class = $isMobile ? 'article-thumblist-mobile d-block d-lg-none' : 'article-thumblist-desktop d-none d-lg-block';

        echo '<ul class="product-gallery-thumblist ' . $class . ' article-gallery" data-cdcolo="' . $color['cdcolo'] . '">';

        $id = str_replace(' ', '-', $color['cdcolo']);
        echo '<li class="active"><a href="#preview0-' . $id . '">';
        echo $this->getModelImgOrDefaultHtml($color['flimag'], $color['cdcolo']);
        echo '</a></li>';
        for ($i = 0; $i < count($color['imgart']); $i++) {
            $index = $i + 1;
            echo '<li><a href="#preview' . $index . '-' . $id . '">';
            echo $this->getModelImgOrDefaultHtml($color['imgart'][$i]->flimag, $color['cdcolo']);
            echo '</a></li>';
        }

        echo '</ul>';
    }

    public function getModelPreviewList($model, $description)
    {
        echo '<ul class="product-gallery-preview model-gallery">';

        echo '<li id="preview0" class="current">';
        echo $this->getModelImgOrDefaultHtml($model->flimag, $description, array("class" => "fullscreen_slider_image"));
        echo '</li>';
        for ($i = 0; $i < count($model->imgart); $i++) {
            $index = $i + 1;
            echo '<li id="preview' . $index . '">';
            echo $this->getModelImgOrDefaultHtml($model->imgart[$i]->flimag, $description, array("class" => "fullscreen_slider_image"));
            echo '</li>';
        }

        echo '</ul>';
    }

    public function getArticlePreviewList($article)
    {
        echo '<ul class="product-gallery-preview article-gallery" data-cdarti="' . $article->cdarti . '">';

        $id = str_replace(' ', '-', $article->cdarti);
        echo '<li id="preview0-' . $id . '" class="current">';
        echo $this->getModelImgOrDefaultHtml($article->flimag, $article->cdarti, array('data-enlargable' => 'true'));
        echo '</li>';
        for ($i = 0; $i < count($article->imgart); $i++) {
            $index = $i + 1;
            echo '<li id="preview' . $index . '-' . $id . '">';
            echo $this->getModelImgOrDefaultHtml($article->imgart[$i]->flimag, $article->cdarti, array('data-enlargable' => 'true'));
            echo '</li>';
        }

        echo '</ul>';
    }

    public function getColorPreviewList($color)
    {
        echo '<ul class="product-gallery-preview article-gallery" data-cdcolo="' . $color['cdcolo'] . '">';

        $id = str_replace(' ', '-', $color['cdcolo']);
        echo '<li id="preview0-' . $id . '" class="current">';
        echo $this->getModelImgOrDefaultHtml($color['flimag'], $color['cdcolo'], array('data-enlargable' => 'true'));
        echo '</li>';
        for ($i = 0; $i < count($color['imgart']); $i++) {
            $index = $i + 1;
            echo '<li id="preview' . $index . '-' . $id . '">';
            echo $this->getModelImgOrDefaultHtml($color['imgart'][$i]->flimag, $color['cdcolo'], array('data-enlargable' => 'true'));
            echo '</li>';
        }

        echo '</ul>';
    }

    public function getMainImagesScroller($hasMoreImages, $model, $description)
    {
        echo '<div class="model-images-container">';

        if ($hasMoreImages) {
            echo '<!-- Model Thumblist Desktop -->';
            $this->getModelThumbnailList($model, $description, false);
        }

        echo '<!-- Model Preview -->';
        $this->getModelPreviewList($model, $description);

        if ($hasMoreImages) {
            echo '<!-- Model Thumblist Mobile -->';
            $this->getModelThumbnailList($model, $description, true);
        }

        echo '</div>';
    }

    public function getArticleImagesScroller($article)
    {
        echo '<div class="article-images-container" data-cdarti="' . $article->cdarti . '">';
        echo '<!-- Article Thumblist Desktop -->';
        $this->getArticleThumbnailList($article, false);
        echo '<!-- Article Preview -->';
        $this->getArticlePreviewList($article);
        echo '<!-- Article Thumblist Mobile -->';
        $this->getArticleThumbnailList($article, true);
        echo '</div>';
    }

    public function getModelAndArticleImagesScroller($article, $model)
    {
        $article2 = clone $article;
        $article2->imgart = array_merge(iterator_to_array($model->imgart), iterator_to_array($article->imgart));
        echo '<div class="article-images-container" data-cdarti="' . $article2->cdarti . '">';
        echo '<!-- Article Thumblist Desktop -->';
        $this->getArticleThumbnailList($article2, false);
        echo '<!-- Article Preview -->';
        $this->getArticlePreviewList($article2);
        echo '<!-- Article Thumblist Mobile -->';
        $this->getArticleThumbnailList($article2, true);
        echo '</div>';
    }

    public function getColorImagesScroller($color)
    {
        echo '<div class="color-images-container" data-cdcolo="' . $color['cdcolo'] . '">';

        echo '<!-- Color Thumblist Desktop -->';
        $this->getColorThumbnailList($color, false);
        echo '<!-- Color Preview -->';
        $this->getColorPreviewList($color);
        echo '<!-- Color Thumblist Mobile -->';
        $this->getColorThumbnailList($color, true);

        echo '</div>';
    }

    public function getArticleImagePreview()
    {
        echo '<!-- Preview -->';
        echo '<ul class="product-gallery-preview article-gallery">';
        echo '<li id="preview0" class="current"><img src="" class="big_article_image m-0 fullscreenvar_artn" alt=""/></li>';
        echo '</ul>';
    }
    //endregion

    //region Color background
    public function getCustomColorBackgroundFromObject($item, $showItemImage = false)
    {
        if (!empty($item->col_rgbcd1) || !empty($item->col_rgbcd2) || !empty($item->col_rgbcd3)) {
            $color1 = $item->col_rgbcd1 != '' ? $item->col_rgbcd1 : ($item->col_rgbcd2 != '' ? $item->col_rgbcd2 : $item->col_rgbcd3);
            $color2 = $item->col_rgbcd2 != '' ? $item->col_rgbcd2 : $item->col_rgbcd3;
            $color3 = $item->col_rgbcd3;
            if ($color3 != '') {
                echo "background: linear-gradient(to right, #" . $color1 . ", #" . $color1 . " 33.33%, #" . $color2 . " 33.33%, ";
                echo "#" . $color2 . " 66.66%, #" . $color3 . " 66.66%)";
            } else if ($color2 != '') {
                echo "background: linear-gradient(to right, #" . $color1 . ", #" . $color1 . " 50%, #" . $color2 . " 50%)";
            } else if ($color1 != '') {
                echo "background-color: #" . $color1;
            }
        } else if ($item->col_flimag != '') {
            echo "background-size: contain;background-image: url('../upload/colors/" . $item->col_flimag . "')";
        } else if ($item->col_flmult == 1) {
            echo "background-size: contain;background-image: url('../assets/img/multicolor.png')";
        } else if ($showItemImage) {
            $imgurl = $this->utility->getImageModelLink($item->flimag);
            $exist = $item->flimag != '' && $this->diskManager->fileExistsInPublic("img/model/" . $item->flimag);
            $src = ($exist ? $imgurl : '../assets/img/default_model.jpg');
            echo "background-size: contain;background-image: url('" . $src . "')";
        } else {
            echo "background-size: contain;background-image: url('../assets/img/nocolor.png')";
        }
    }

    public function getCustomColorBackgroundFromArray($item)
    {
        if (!empty($item['col_rgbcd1']) || !empty($item['col_rgbcd2']) || !empty($item['col_rgbcd3'])) {
            $color1 = $item['col_rgbcd1'] != '' ? $item['col_rgbcd1'] : ($item['col_rgbcd2'] != '' ? $item['col_rgbcd2'] : $item['col_rgbcd3']);
            $color2 = $item['col_rgbcd2'] != '' ? $item['col_rgbcd2'] : $item['col_rgbcd3'];
            $color3 = $item['col_rgbcd3'];
            if ($color3 != '') {
                echo "background: linear-gradient(to right, #" . $color1 . ", #" . $color1 . " 33.33%, ";
                echo "#" . $color2 . " 33.33%, #" . $color2 . " 66.66%, #" . $color3 . " 66.66%)";
            } else if ($color2 != '') {
                echo "background: linear-gradient(to right, #" . $color1 . ", #" . $color1 . " 50%, #" . $color2 . " 50%)";
            } else if ($color1 != '') {
                echo "background-color: #" . $color1;
            }
        } else if (isset($item['fabricColorImage']) && !empty($item['fabricColorImage']) && $this->diskManager->fileExistsInPublic('img/model/' . $item['fabricColorImage'])) {
            echo "background-size: contain;background-image: url('" . $this->utility->getImageModelLink($item['fabricColorImage']) . "')";
        } else if ($item['col_flimag'] != '') {
            if ($this->diskManager->fileExistsInPublic('img/model/' . $item['col_flimag'])) {
                echo "background-size: contain;background-image: url('" . $this->utility->getImageModelLink($item['col_flimag']) . "')";
            } else if ($this->diskManager->fileExistsInPublic('upload/colors/' . $item['col_flimag'])) {
                echo "background-size: contain;background-image: url('../upload/colors/" . $item['col_flimag'] . "')";
            } else {
                echo "background-size: contain;background-image: url('../assets/img/nocolor.png')";
            }
        } else if ($item['col_flmult'] == 1) {
            echo "background-size: contain;background-image: url('../assets/img/multicolor.png')";
        } else {
            echo "background-size: contain;background-image: url('../assets/img/nocolor.png')";
        }
    }
    //endregion

    //region Prices
    public function getPriceDivWithRetail($catalogPrice, $nulist, $retailPrice, $rulist, $custDisc, $align = 'center')
    {
        $controller = new ControllerBase();


        $withDiscount = false;
        $printCatalogPrice = false;
        if ($catalogPrice > 0) {
            $printCatalogPrice = true;

            // Set initial price as "real price"
            $catalogPrice = $controller->utility->getFormattedPrice($nulist, $catalogPrice);
            $real_price = $catalogPrice['value_raw'];

            // Calculate discount if exists
            $cust_disc = $custDisc > 0 ? $custDisc : 0;
            $disc_price = $real_price * (1 - $custDisc / 100);
            $withDiscount = $disc_price != $real_price;

            // Now, format real price to print
            $real_price = $catalogPrice['value'];

            // Update with discount and format catalog price
            $catalogPrice = $controller->utility->getFormattedPrice($nulist, $disc_price);
            $catalogPrice = $catalogPrice['value'];
        }

        if ($rulist != '' && $retailPrice != 0) {
            $price = $this->utility->getFormattedPrice($rulist, $retailPrice);
            $retail_price = $price['value'];
        } else {
            $retail_price = '';
        }

        if ($printCatalogPrice) {
            if ($withDiscount) {
                echo "<div class='price-model-box-discounted' style='text-align:$align'>";
                echo "WHS <span class='discounted'>" . $real_price . "</span> " . $catalogPrice;
                echo "</div>";
            } else {
                echo "<div class='price-model-box' style='text-align:$align'>WHS " . $catalogPrice . "</div>";
            }

            echo $retail_price != '' ? "<div class='price-model-box'>RTL " . $retail_price . "</div>" : '';
        }
    }

    public function getPriceDiv($catalogPrice, $custDisc, $currency, $cdvalu, $align = 'center', $link = "", $cdartn = null)
    {
        echo $this->getPriceDivHtml($catalogPrice, $custDisc, $currency, $cdvalu, $align, $link, $cdartn);
    }

    public function getPriceDivHtml($catalogPrice, $custDisc, $currency, $cdvalu, $align = 'center', $link = '', $cdartn = null)
    {
        $utility = $this->getDI()->get('utility');
        $i18n = $this->getDI()->get('i18n');
        $id_usr = $this->session->get('auth')['id'];
        $order_info = Utility::getOrderInfo($id_usr);
        $idlang = $utility->getLanguage();
        $nulist = $order_info != null ? $order_info->nulist : $utility->getDefaultNulist($id_usr);
        $cdcata = $this->getDI()->get('session')->get('cdcata');

        $items = array(
            'cdcata' => $cdcata,
            'cdartn' => $cdartn,    // TI MANCA SOLO QUESTO
            'nulist' => $nulist,
            'idlang' => $idlang,
            'id_usr' => $this->session->get('auth')['id'],
            'numdis' => 0, // ASK - Questo va bene a zero nella prossima query???
            'modelDetailStyle' => $utility->getAppSettings('ModelDetailStyle'),
            'colorAssignmentSource' => $utility->getAppSettings('ColorAssignmentSource'),
        );
        $variantItems = Anaart::getAllArticlesForModelDetail($items);

        $sconto = floatval(!empty($custDisc) ? $custDisc : 0);
        $withDiscount = $utility->getAppSettings('MaxDiscountInCollection') == 1 && $sconto > 0;
        // CALCOLO MAX DISCOUNT

        // Marco e Samuele 02.12.2022
        // Leo 20/12/2023 ho commentato questa parte perche' non capisco come mai dovremmo fare queste query in piu'
        // per controllare lo sconto dato che mi sembra che abbiamo gia' il valore che intendiamo mostrare su $custDisc
//        $prezzo_cust = 0;
//        $numdis = $utility->getCustomDiscount();
//        foreach ($variantItems as $vari) {
//            if ($numdis > 0) {
//                $discount = B2bDisbdy::getCustomDiscountForCdarti($numdis, $vari->cdarti);
//                if (count($discount) > 0) {
//                    if ($discount[1] > $sconto) {
//                        $sconto = $discount[1];
//
//                        // qua ci va il controllo per capire quello maggiore e scriverlo
//                        // e poi bisogna fare i conti
//                    }
//                }
//            }
//            if ($vari->prezzo > $prezzo_cust) {
//                $prezzo_cust = $vari->prezzo;
//            }
//        }

        $html = '';
        if ($catalogPrice < 0) {
            $catalogPrice = $i18n->_('quantity.priceforsize.short');
        } else if ($catalogPrice == 0) {
            $catalogPrice = '-';
        } else {
            // Set initial price as "real price"
            $catalogPrice = $utility->getFormattedPriceCurrencyPresent($catalogPrice, $currency, $cdvalu);
            $real_price = $catalogPrice['value_raw'];

            // Calculate discount if exists
            $custDisc = max($custDisc, 0);
            $disc_price = $real_price * (1 - $custDisc / 100);
            $withDiscount = $disc_price != $real_price;

            // Now, format real price to print
            $real_price = $catalogPrice['value'];

            // Update with discount and format catalog price
            $catalogPrice = $utility->getFormattedPriceCurrencyPresent($disc_price, $currency, $cdvalu)['value'];
        }

        if ($utility->getAppSettings('VariantInCollection') == 1) {
            $varianti = $this->getColorVariantForProduct($variantItems, $link);
            $html .= $varianti;
        }

        $classDiscountPrice = ($utility->getAppSettings('ColoredPriceBackground') == 1) ? 'price-model-box-discounted-btn' : 'price-model-box-discounted-btn-nobg';
        $classPrice = ($utility->getAppSettings('ColoredPriceBackground') == 1) ? 'price-model-box-btn' : 'price-model-box-btn-nobg';

        if ($withDiscount) {
            //$html .= "<div class='price-model-box-discounted' style='text-align:$align'>";
            //$html .= "<span class='discounted'>" . $real_price . "</span> " . $catalogPrice;
            //$html .= "</div>";

            $html .= "<span class='product-ribbon product-ribbon-right product-ribbon--style-1 text-uppercase' style='margin-right: 30px;z-index: 9;display: block;'>" . $sconto . "%</span>";
            $html .= "<a style='text-decoration: none;' href='" . $link . "'><div class='" . $classDiscountPrice . " text-center'><div style='display: flex;'><span class='discounted'>" . $real_price . "</span><span>" . $catalogPrice . "</span></div><div class='availability-model-box text-center'></div><span>Scopri</span></div></a>";
        } else {
//            if ($catalogPrice != "") {
//                $html .= "<a style='text-decoration: none;' href='" . $link . "'><div class='" . $classDiscountPrice . " text-center'><div style='display: flex;'><span>" . $catalogPrice . "</span></div><div class='availability-model-box text-center'></div><span>Scopri</span></div></a>";
//            } else {
//                $html .= "<a style='text-decoration: none;' href='" . $link . "'><div class='" . $classDiscountPrice . " text-center'><div style='display: flex;'><span>" . $i18n->_('quantity.priceforsize.short') . "</span></div><div class='availability-model-box text-center'></div><span>Scopri</span></div></a>";
//            }
            if ($catalogPrice != "") {
                $html .= "<a style='text-decoration: none;' href='" . $link . "'><div class='" . $classPrice . " text-center'><div style='display: flex;'><span>" . $catalogPrice . "</span></div><div class='availability-model-box text-center'></div><span>Scopri</span></div></a>";
            } else {
                $html .= "<a style='text-decoration: none;' href='" . $link . "'><div class='" . $classPrice . " text-center'><div style='display: flex;'><span>" . $i18n->_('quantity.priceforsize.short') . "</span></div><div class='availability-model-box text-center'></div><span>Scopri</span></div></a>";
            }
        }

        return $html;
    }

    public function getColorVariantForProduct($model, $modelLink = '')
    {
        if ($this->utility->getAppSettings('VariantInCollection') == 0) {
            return '';
        }

        $html = '<div class="row pt-10x px-15x" style="justify-content: center;">';

        if (count($model) == 0) {
            return $html . ' </div>';
        }

        $indice = 0;

        foreach ($model as $anaart) {

            if ($indice == 3) {
                if (count($model) > 3) {

                    if (substr($modelLink, 0, 1) != "/") {

                        $modelLink = '/' . $modelLink;

                    };

                    $html .= '<div class="px-2 pb-20x" style="margin-top:10px;">';
                    $html .= '<a href="' . $modelLink . '"><span class="mt-5"><i class="fa fa-plus" aria-hidden="true"></i></span></a>';
                    $html .= '</div>';
                }
                break;
            }

            // if ($common['order_info']->tpordc == 1 || $anaart->is_available == 'true') {
            $html .= '<div class="px-2 pb-20x model-color-picker-container">';

            $background = "background-size: contain;background-image: url('../assets/img/nocolor.png')";

            if ($anaart->flimag != '') {

                $background = "background-size: contain;background-image: url('" . $this->utility->getImageModelLink($anaart->flimag, ['w' => '100']) . "')";
            } else if ($anaart->col_flmult == 1) {
                $background = "background-size: contain;background-image: url('../assets/img/multicolor.png')";
            }

            $html .=
                '<div class="small-model-color-picker-catalog" style="' . $background . '"
            data-toggle="tooltip" title="' . $anaart->col_codice . '" data-id="' . $anaart->col_codice . '"
            data-cdarti="' . $anaart->cdarti . '" data-dsarti="' . $anaart->dsarti . '"
            data-cdcolo="' . $anaart->cdcolo . '" data-dscolo="' . $anaart->dscolo . '"
            data-realprice="0" data-discprice="0"
            data-flimag="' . $anaart->flimag . '">&nbsp;</div>
          </div>';
            //}

            $indice++;

        }

        $html .= '</div>';

        return $html;
    }

    public function getModelPriceSpan($catalogPrice, $custDisc, $currency, $cdvalu)
    {

        $catalogPriceText = '';
        $real_price = '';
        $this->getPrices($catalogPrice, $custDisc, $currency, $cdvalu, $catalogPriceText, $real_price);

        $withDiscount = $catalogPriceText != $real_price;

        echo "<span class='pr-20x' style='color:#999'>" . $this->di->get('i18n')->_('_common.price') . ":</span>";
        echo "<span " . (!$withDiscount ? "style='display:none'" : "") . "id='realprice' ";
        echo "class='discounted-price discounted pr-10x'>" . $real_price . "</span>";
        echo "<span " . (!$withDiscount ? "style='display:none'" : "") . "id='discprice' ";
        echo "class='discounted-price price-model-box-discounted'>" . $catalogPriceText . "</span>";
        echo "<span " . ($withDiscount ? "style='display:none'" : "") . "id='price' ";
        echo "class='not-discounted-price font-weight-bold'>" . $catalogPriceText . "</span>";
    }

    public function getPrices($catalogPrice, $custDisc, $currency, $cdvalu, &$catalogPriceText, &$real_price)
    {
        $controller = new ControllerBase();

        if ($catalogPrice < 0) {
            $catalogPriceText = $this->di->get('i18n')->_('quantity.priceforsize.short');
        } else if ($catalogPrice == 0) {
            $catalogPriceText = '-';
        } else {
            // Set initial price as "real price"
            /** @var Utility $utility */
            $utility = $this->di->get('utility');
            $catalogPriceText = $utility->getFormattedPriceCurrencyPresent($catalogPrice, $currency, $cdvalu);
            $real_price = $catalogPriceText['value_raw'];

            // Calculate discount if exists
            $cust_disc = $custDisc > 0 ? $custDisc : 0;
            $disc_price = $real_price * (1 - $custDisc / 100);

            // Now, format real price to print
            $real_price = $catalogPriceText['value'];

            // Update with discount and format catalog price
            $catalogPriceText = $utility->getFormattedPriceCurrencyPresent($disc_price, $currency, $cdvalu);
            $catalogPriceText = $catalogPriceText['value'];
        }
    }
    //endregion

    //region New order widgets
    public function getCustomerOptionForNewOrder($index, $anagra)
    {
        echo '<option class="customer_selector" id="customer-option-' . $index . '" value="' . $index . '" ';
        echo 'data-tpanag="' . $anagra->tpanag . '" data-cdanag="' . $anagra->cdanag . '" data-nulist="' . $anagra->nulist . '" ';
        echo 'data-defaulttpindo="' . $anagra->default_tpindo . '" ';
        if ($anagra->tpanag == 'CN') {
            echo 'style="font-style:italic"';
        }
        echo '>' . $anagra->descri . ' - ' . $anagra->cdanag;
        echo($anagra->tpanag == 'CN' ? ' (' . Utility::getTranslatorFor()->_('_common.provisional') . ')' : '');
        echo '</option>';
    }

    public function closeDestinationSelector()
    {
        echo '</select>';
        echo '<span class="pointer"><i class="fa fa-caret-down"></i></span>';
        echo '</label>';
    }

    public function openDestinationSelector($isHidden, $tpanag, $cdanag)
    {
        echo '<label class="form-custom-select destination-selector" id="tp-' . $tpanag . '-cd-' . $cdanag . '" ';
        if ($isHidden) {
            echo 'style="display:none"';
        }
        echo '>';
        echo '<select name="destination">';
        echo '<option class="destination_selector" value="">';
        echo Utility::getTranslatorFor()->_('_common.address.main') . ' - ';
        echo Utility::getTranslatorFor()->_('account.customer.businessname');
        echo '</option>';
    }

    public function getDestinationOption($desmer)
    {
        echo '<option class="destination_selector" ';
        echo 'title="' . $desmer->desvid . ' - ';
        $this->printAddress($desmer);
        echo '" value="' . $desmer->cddesm . '">';
        echo $desmer->desvid . ' - ';
        $this->printAddress($desmer);
        echo '</option>';
    }
    //endregion

    //region Budget analysis
    private function getBudgetCellHtml($style, $text, $perc = -1)
    {
        if ($perc < 0 && $perc != '') {
            $title = $text;
            $text = $text;
        } else {
            $title = $text . ' (' . $perc . '%)';
            $text = '<span style="color:' . ($perc < 100 ? 'red' : 'green') . '">' . $title . '</span>';
        }
        return '<div class="float-left" style="' . $style . '" title="' . $title . '">' . $text . '</div>';
    }

    private function getBudgetTotalRowHtml($lineColumnWidth, $otherColumnWidth, $measureUnit, $subtotals,
                                           $backgroundColor, $currency, $hideBudget = true, $hideTarget = true, $isTotal = false)
    {
        $controller = new ControllerBase;
        $html = '';

        $totalWidth = 'width:' . ($lineColumnWidth + ($otherColumnWidth * count($subtotals))) . 'px';

        $html .= '<!-- Subtotal -->';
        //$html .= $hideBudget ? '<div class="col-12">' : '';
        $html .= '<div class="row cart-summary-lines-footer m-0" style="background-color:' . $backgroundColor . ';' . $totalWidth . '">';
        $style = ($isTotal ? 'border-top:0;' : '') . 'width:';
        $html .= $this->getBudgetCellHtml('background-color:' . $backgroundColor . ';position:absolute;' . $style . $lineColumnWidth . $measureUnit,
            $isTotal ? $controller->translate('_common.total') : $controller->translate('_common.total.sub'));
        // Empty cell under absolute cell
        $html .= $this->getBudgetCellHtml($style . $lineColumnWidth . $measureUnit, '');

        $truncate = ';white-space:nowrap;overflow:hidden;text-overflow:ellipsis;';
        $style = ($isTotal ? 'border-top:0;' : '') . 'text-align:right;width:';
        $style1 = $style . ($otherColumnWidth - 1) . $measureUnit . $truncate;
        $style2 = $style . ($otherColumnWidth + 1) . $measureUnit . $truncate;

        $index = 0;

        // Target
        $totQtatrg = 0;
        $totValtrg = 0;
        if (!$hideTarget) {
            $totQtatrg = $subtotals[$index];
            $html .= $this->getBudgetCellHtml($style1, $totQtatrg);
            $index++;
            $totValtrg = $subtotals[$index];
            $html .= $this->getBudgetCellHtml($style2, number_format(floatval($totValtrg), 2, ',', '.') . ' ' . $currency);
            $index++;
        }

        // Budget
        if (!$hideBudget) {
            $html .= $this->getBudgetCellHtml($style1, $subtotals[$index]);
            $index++;
            $html .= $this->getBudgetCellHtml($style2, number_format(floatval($subtotals[$index]), 2, ',', '.') . ' ' . $currency);
            $index++;
        }

        // Actual
        if (!$hideTarget) {
            $html .= $this->getBudgetCellHtml($style1, $subtotals[$index], $this->utility->getPerc($subtotals[$index], $totQtatrg));
            $index++;
            $html .= $this->getBudgetCellHtml($style2, number_format(floatval($subtotals[$index]), 2, ',', '.') . ' ' . $currency,
                $this->utility->getPerc($subtotals[$index], $totValtrg));
            $index++;
        } else {
            $html .= $this->getBudgetCellHtml($style1, $subtotals[$index]);
            $index++;
            $html .= $this->getBudgetCellHtml($style2, number_format(floatval($subtotals[$index]), 2, ',', '.') . ' ' . $currency);
            $index++;
        }

        $remainingColumns = count($subtotals) - $index;

        for ($i = 0; $i < $remainingColumns; $i++) {
            if ($i % 2 == 0) {
                $html .= $this->getBudgetCellHtml($style1, $subtotals[$index + $i]);
            } else {
                $html .= $this->getBudgetCellHtml($style2, number_format(floatval($subtotals[$index + $i]), 2, ',', '.') . ' ' . $currency);
            }
        }

        $html .= '</div>';
        //$html .= $hideBudget ? '</div>' : '';
        return $html;
    }

    private function getGlobalBudgetTotalRowHtml($lineColumnWidth, $otherColumnWidth, $measureUnit, $totals,
                                                 $hideBudget = true, $hideTarget = true)
    {
        $controller = new ControllerBase;

        $html = '';

        $isFirst = true;
        foreach ($totals as $key => $total) {
            $totalWidth = 'width:' . ($lineColumnWidth + ($otherColumnWidth * count($total))) . 'px';
            $currency = $this->utility->getCurrencySymbol($key);

            $html .= '<!-- Subtotal -->';
            //$html .= $hideBudget ? '<div class="col-12">' : '';
            $html .= '<div class="row cart-summary-lines-footer m-0" style="background-color:white;' . $totalWidth . '">';
            $style = ($isFirst ? '' : 'border-top:0;') . 'width:';
            $html .= $this->getBudgetCellHtml('background-color:white;position:absolute;' . $style . $lineColumnWidth . $measureUnit,
                $controller->translate('_common.total') . ' ' . $currency);
            // Empty cell under absolute cell
            $html .= $this->getBudgetCellHtml($style . $lineColumnWidth . $measureUnit, '');

            $style = ($isFirst ? '' : 'border-top:0;') . 'text-align:right;width:';
            $truncate = ';white-space:nowrap;overflow:hidden;text-overflow:ellipsis;';
            $style1 = $style . ($otherColumnWidth - 1) . $measureUnit . $truncate;
            $style2 = $style . ($otherColumnWidth + 1) . $measureUnit . $truncate;

            $index = 0;

            // Target
            $totQtatrg = 0;
            $totValtrg = 0;
            if (!$hideTarget) {
                $totQtatrg = $total[$index];
                $html .= $this->getBudgetCellHtml($style1, $total[$index]);
                $index++;
                $totValtrg = $total[$index];
                $html .= $this->getBudgetCellHtml($style2, number_format(floatval($total[$index]), 2, ',', '.') . ' ' . $currency);
                $index++;
            }

            // Budget
            if (!$hideBudget) {
                $html .= $this->getBudgetCellHtml($style1, $total[$index]);
                $index++;
                $html .= $this->getBudgetCellHtml($style2, number_format(floatval($total[$index]), 2, ',', '.') . ' ' . $currency);
                $index++;
            }

            // Actual
            if (!$hideTarget) {
                $html .= $this->getBudgetCellHtml($style1, $total[$index], $this->utility->getPerc($total[$index], $totQtatrg));
                $index++;
                $html .= $this->getBudgetCellHtml($style2, number_format(floatval($total[$index]), 2, ',', '.') . ' ' . $currency,
                    $this->utility->getPerc($total[$index], $totValtrg));
                $index++;
            } else {
                $html .= $this->getBudgetCellHtml($style1, $total[$index]);
                $index++;
                $html .= $this->getBudgetCellHtml($style2, number_format(floatval($total[$index]), 2, ',', '.') . ' ' . $currency);
                $index++;
            }

            $remainingColumns = count($total) - $index;

            for ($i = 0; $i < $remainingColumns; $i++) {
                if ($i % 2 == 0) {
                    $html .= $this->getBudgetCellHtml($style1, $total[$index + $i]);
                } else {
                    $html .= $this->getBudgetCellHtml($style2, number_format(floatval($total[$index + $i]), 2, ',', '.') . ' ' . $currency);
                }
            }

            $html .= '</div>';
            $isFirst = false;
        }

        //$html .= $hideBudget ? '</div>' : '';
        return $html;
    }

    private function getBudgetRowHtml($lineColumnWidth, $otherColumnWidth, $measureUnit, $item, $backgroundColor,
                                      $style, $addBrand, $currency, $isLineSorting = true, $hideBudget = true, $hideTarget = true)
    {

        $controller = new ControllerBase;
        $html = '';
        $numStg0Col = 2 + (!$hideBudget ? 2 : 0) + (!$hideTarget ? 2 : 0);

        $totalWidth = 'width:' . ($lineColumnWidth + ($otherColumnWidth * $numStg0Col) + ($otherColumnWidth * 2 * $item->totstg)) . 'px';

        $html .= '<!-- Line analysis -->';
        //$html .= $hideBudget ? '<div class="col-12">' : '';
        $html .= '<div class="row cart-summary-lines-row m-0" style="background-color:' . $backgroundColor . ';' . $totalWidth . '">';
        if ($isLineSorting) {
            $title = ($addBrand ? $item->dstitl . ' - ' : '') . $item->dslinm;
            $title .= $item->dsserm != '' ? ' - ' . $item->dsserm : '';
            $title .= ' - ' . ($item->dsuscc != '' ? $item->dsuscc : $item->cduscc);
        } else {
            $title = ($item->dsuscc != '' ? $item->dsuscc : $item->cduscc) . ' - ' . ($addBrand ? $item->dstitl . ' - ' : '') . $item->dslinm;
            $title .= $item->dsserm != '' ? ' - ' . $item->dsserm : '';;
        }
        $truncate = ';white-space:nowrap;overflow:hidden;text-overflow:ellipsis;';
        $html .= $this->getBudgetCellHtml('position:absolute;background-color:' . $backgroundColor . ';width:' . $lineColumnWidth . $measureUnit . ';' . $style . $truncate, $title);
        // Empty cell under absolute cell
        $html .= $this->getBudgetCellHtml('width:' . $lineColumnWidth . $measureUnit, '');
        $style .= ';text-align:right;';
        $style1 = 'width:' . ($otherColumnWidth - 1) . $measureUnit . ';' . $style;
        $style2 = 'width:' . ($otherColumnWidth + 1) . $measureUnit . ';' . $style;
        // Target
        if (!$hideTarget) {
            $html .= $this->getBudgetCellHtml($style1, $item->qtatrg);
            $html .= $this->getBudgetCellHtml($style2, number_format(floatval($item->valtrg), 2, ',', '.') . ' ' . $currency);
        }
        // Budget
        if (!$hideBudget) {
            $html .= $this->getBudgetCellHtml($style1, $item->qtabdg);
            $html .= $this->getBudgetCellHtml($style2, number_format(floatval($item->valbdg), 2, ',', '.') . ' ' . $currency);
        }
        // Actual
        if (!$hideTarget) {
            $html .= $this->getBudgetCellHtml($style1, $item->currentSituation['totQty'],
                $this->utility->getPerc($item->currentSituation['totQty'], $item->qtatrg));
            $html .= $this->getBudgetCellHtml($style2, number_format(floatval($item->currentSituation['totAmt']), 2, ',', '.') . ' ' . $currency,
                $this->utility->getPerc($item->currentSituation['totAmt'], $item->valtrg));
        } else {
            $html .= $this->getBudgetCellHtml($style1, $item->currentSituation['totQty']);
            $html .= $this->getBudgetCellHtml($style2, number_format(floatval($item->currentSituation['totAmt']), 2, ',', '.') . ' ' . $currency);
        }

        for ($i = 0; $i < $item->totstg; $i++) {
            $qtastg = 'qtast' . ($i + 1);
            $valstg = 'valst' . ($i + 1);
            $html .= $this->getBudgetCellHtml($style1, $item->$qtastg);
            $html .= $this->getBudgetCellHtml($style2, number_format(floatval($item->$valstg), 2, ',', '.') . ' ' . $currency);
        }

        $html .= '</div>';
        //$html .= $hideBudget ? '</div>' : '';
        return $html;
    }

    private function getGlobalBudgetRowHtml($lineColumnWidth, $otherColumnWidth, $measureUnit, $item,
                                            $backgroundColor, $style, $currency, $hideBudget = true, $hideTarget = true)
    {
        $controller = new ControllerBase;
        $html = '';
        $numStg0Col = 2 + (!$hideBudget ? 2 : 0) + (!$hideTarget ? 2 : 0);

        $totalWidth = 'width:' . ($lineColumnWidth + ($otherColumnWidth * $numStg0Col) + ($otherColumnWidth * 2 * $item->totstg)) . 'px';

        $html .= '<!-- Customer analysis -->';
        //$html .= $hideBudget ? '<div class="col-12">' : '';
        $html .= '<div class="row cart-summary-lines-row m-0" style="background-color:' . $backgroundColor . ';' . $totalWidth . '">';
        $truncate = 'white-space:nowrap;overflow:hidden;text-overflow:ellipsis;';
        $html .= $this->getBudgetCellHtml('background-color:' . $backgroundColor . ';position:absolute;width:' . $lineColumnWidth . $measureUnit . ';' . $style . $truncate, $item->tpanag . ' - ' . $item->cdanag . ' - ' . $item->descri);
        // Empty cell under absolute cell
        $html .= $this->getBudgetCellHtml('width:' . $lineColumnWidth . $measureUnit, '');
        $style .= ';text-align:right;';
        $style1 = 'width:' . ($otherColumnWidth - 1) . $measureUnit . ';' . $style;
        $style2 = 'width:' . ($otherColumnWidth + 1) . $measureUnit . ';' . $style;
        // Target
        if (!$hideTarget) {
            $html .= $this->getBudgetCellHtml($style1, $item->qtatrg);
            $html .= $this->getBudgetCellHtml($style2, number_format(floatval($item->valtrg), 2, ',', '.') . ' ' . $currency);
        }
        // Budget
        if (!$hideBudget) {
            $html .= $this->getBudgetCellHtml($style1, $item->qtabdg);
            $html .= $this->getBudgetCellHtml($style2, number_format(floatval($item->valbdg), 2, ',', '.') . ' ' . $currency);
        }
        // Actual
        if (!$hideTarget) {
            $html .= $this->getBudgetCellHtml($style1, $item->currentSituation['totQty'],
                $this->utility->getPerc($item->currentSituation['totQty'], $item->qtatrg));
            $html .= $this->getBudgetCellHtml($style2, number_format(floatval($item->currentSituation['totAmt']), 2, ',', '.') . ' ' . $currency,
                $this->utility->getPerc($item->currentSituation['totAmt'], $item->valtrg));
        } else {
            $html .= $this->getBudgetCellHtml($style1, $item->currentSituation['totQty']);
            $html .= $this->getBudgetCellHtml($style2, number_format(floatval($item->currentSituation['totAmt']), 2, ',', '.') . ' ' . $currency);
        }

        for ($i = 0; $i < $item->totstg; $i++) {
            $qtastg = 'qtast' . ($i + 1);
            $valstg = 'valst' . ($i + 1);
            $html .= $this->getBudgetCellHtml($style1, $item->$qtastg);
            $html .= $this->getBudgetCellHtml($style2, number_format(floatval($item->$valstg), 2, ',', '.') . ' ' . $currency);
        }

        $html .= '</div>';
        //$html .= $hideBudget ? '</div>' : '';
        return $html;
    }

    public function getBudgetHeaderHtml($lineColumnWidth, $otherColumnWidth, $measureUnit, $budget,
                                        $firstColumnTitle, $hideBudget = true, $hideTarget = true, $printHtml = false)
    {

        $controller = new ControllerBase;
        $numStg0Col = 2 + (!$hideBudget ? 2 : 0) + (!$hideTarget ? 2 : 0);

        $html = '';
        $totalWidth = 'width:' . ($lineColumnWidth + ($otherColumnWidth * $numStg0Col) + ($otherColumnWidth * 2 * $budget->totstg)) . 'px';
        $title = $firstColumnTitle;
        //$html .= $hideBudget ? '<div class="col-12 mt-10x">' : '';
        $html .= '<div class="row cart-summary-lines-header m-0 text-center" style="' . $totalWidth . '">';
        $html .= $this->getBudgetCellHtml('background-color:white;position:absolute;width:' . $lineColumnWidth . $measureUnit, $title);
        // Empty cell under absolute cell
        $html .= $this->getBudgetCellHtml('width:' . $lineColumnWidth . $measureUnit, '');
        $html .= $this->getBudgetCellHtml('width:' . ($otherColumnWidth * $numStg0Col) . $measureUnit, !empty($budget->dsstag) ? $budget->dsstag : $budget->cdstag);
        for ($i = 0; $i < $budget->totstg; $i++) {
            $cdstag = 'cdstg' . ($i + 1);
            $dsstag = 'dsstg' . ($i + 1);
            $description = !empty($budget->$dsstag) ? $budget->$dsstag : $budget->$cdstag;
            $html .= $this->getBudgetCellHtml('width:' . ($otherColumnWidth * 2) . $measureUnit, $description);
        }
        $html .= '</div>';
        //$html .= $hideBudget ? '</div>' : '';

        //$html .= $hideBudget ? '<div class="col-12">' : '';
        $html .= '<div class="row cart-summary-lines-header m-0 text-center" style="' . $totalWidth . '">';
        $html .= $this->getBudgetCellHtml('background-color:white;position:absolute;width:' . $lineColumnWidth . $measureUnit . ';border-top:0', '&nbsp;');
        $html .= $this->getBudgetCellHtml('width:' . $lineColumnWidth . $measureUnit . ';border-top:0', '&nbsp;');
        // Target
        if (!$hideTarget) {
            $html .= $this->getBudgetCellHtml('width:' . ($otherColumnWidth - 1) . $measureUnit, $controller->translate('cart.analysis.target.qty'));
            $html .= $this->getBudgetCellHtml('width:' . ($otherColumnWidth + 1) . $measureUnit, $controller->translate('cart.analysis.target.amt'));
        }
        // Budget
        if (!$hideBudget) {
            $html .= $this->getBudgetCellHtml('width:' . ($otherColumnWidth - 1) . $measureUnit, $controller->translate('cart.analysis.budget.qty'));
            $html .= $this->getBudgetCellHtml('width:' . ($otherColumnWidth + 1) . $measureUnit, $controller->translate('cart.analysis.budget.amt'));
        }
        // Actual
        $html .= $this->getBudgetCellHtml('width:' . ($otherColumnWidth - 1) . $measureUnit, $controller->translate('cart.analysis.current.qty'));
        $html .= $this->getBudgetCellHtml('width:' . ($otherColumnWidth + 1) . $measureUnit, $controller->translate('cart.analysis.current.amt'));
        // Comparison seasons
        for ($i = 0; $i < $budget->totstg; $i++) {
            $html .= $this->getBudgetCellHtml('width:' . ($otherColumnWidth - 1) . $measureUnit, $controller->translate('cart.analysis.tot.qty'));
            $html .= $this->getBudgetCellHtml('width:' . ($otherColumnWidth + 1) . $measureUnit, $controller->translate('cart.analysis.tot.amt'));
        }
        $html .= '</div>';
        //$html .= $hideBudget ? '</div>' : '';

        if ($printHtml) {
            echo $html;
        } else {
            return $html;
        }
    }

    public function getBudgetForCustomerBodyHtml($lineColumnWidth, $otherColumnWidth, $measureUnit, $budget,
                                                 $addBrand, $currency, $isLineSorting = true, $hideBudget = true, $hideTarget = true, $printHtml = false)
    {
        if ($isLineSorting) {
            $currentBrandCode = $budget[0]->cdtitl;
            $currentLineCode = $budget[0]->cdlinm;
            $currentSeriesCode = $budget[0]->cdserm;
        } else {
            $currentDropCode = $budget[0]->cduscc;
        }
        $noTopBorder = false;
        $backgroundColor = '#fafafa';
        $html = '';

        $numColumns = 2 + ($hideBudget ? 0 : 2) + ($hideTarget ? 0 : 2) + ($budget[0]->totstg * 2);
        $subtotals = $totals = array_fill(0, $numColumns, 0);
        foreach ($budget as $item) {
            if ($isLineSorting) {
                if ($item->cdtitl != $currentBrandCode || $item->cdlinm != $currentLineCode || $item->cdserm != $currentSeriesCode) {
                    $html .= $this->getBudgetTotalRowHtml($lineColumnWidth, $otherColumnWidth, $measureUnit,
                        $subtotals, '#ddd', $currency, $hideBudget, $hideTarget);
                    $subtotals = array_fill(0, $numColumns, 0);
                    $currentBrandCode = $item->cdtitl;
                    $currentLineCode = $item->cdlinm;
                    $currentSeriesCode = $item->cdserm;
                    $noTopBorder = true;
                    $backgroundColor = '#fafafa';
                }
            } else {
                if ($item->cduscc != $currentDropCode) {
                    $html .= $this->getBudgetTotalRowHtml($lineColumnWidth, $otherColumnWidth, $measureUnit,
                        $subtotals, '#ddd', $currency, $hideBudget, $hideTarget);
                    $subtotals = array_fill(0, $numColumns, 0);
                    $currentDropCode = $item->cduscc;
                    $noTopBorder = true;
                    $backgroundColor = '#fafafa';
                }
            }

            $style = '';
            if ($noTopBorder) {
                $noTopBorder = false;
                $style = 'border-top:0';
            }

            $html .= $this->getBudgetRowHtml($lineColumnWidth, $otherColumnWidth, $measureUnit, $item,
                $backgroundColor, $style, $addBrand, $currency, $isLineSorting, $hideBudget, $hideTarget);

            $backgroundColor = $backgroundColor == '#fafafa' ? '#eaeaea' : '#fafafa';

            $index = 0;
            // Target
            if (!$hideTarget) {
                $subtotals[$index] += $item->qtatrg;
                $totals[$index] += $item->qtatrg;
                $index++;
                $subtotals[$index] += $item->valtrg;
                $totals[$index] += $item->valtrg;
                $index++;
            }

            // Budget
            if (!$hideBudget) {
                $subtotals[$index] += $item->qtabdg;
                $totals[$index] += $item->qtabdg;
                $index++;
                $subtotals[$index] += $item->valbdg;
                $totals[$index] += $item->valbdg;
                $index++;
            }

            // Actual
            $subtotals[$index] += $item->currentSituation['totQty'];
            $totals[$index] += $item->currentSituation['totQty'];
            $index++;
            $subtotals[$index] += $item->currentSituation['totAmt'];
            $totals[$index] += $item->currentSituation['totAmt'];
            $index++;

            // Comparison seasons
            for ($i = 0; $i < $item->totstg; $i++) {
                $qtastg = 'qtast' . ($i + 1);
                $valstg = 'valst' . ($i + 1);
                $subtotals[$index] += $item->$qtastg;
                $totals[$index] += $item->$qtastg;
                $index++;
                $subtotals[$index] += $item->$valstg;
                $totals[$index] += $item->$valstg;
                $index++;
            }
        }

        // Last subtotal row
        $html .= $this->getBudgetTotalRowHtml($lineColumnWidth, $otherColumnWidth, $measureUnit,
            $subtotals, '#ddd', $currency, $hideBudget, $hideTarget);

        // Global total
        $html .= $this->getBudgetTotalRowHtml($lineColumnWidth, $otherColumnWidth, $measureUnit,
            $totals, 'white', $currency, $hideBudget, $hideTarget, true);

        if ($printHtml) {
            echo $html;
        } else {
            return $html;
        }
    }

    public function getGlobalBudgetBodyHtml($lineColumnWidth, $otherColumnWidth, $measureUnit, $budget,
                                            $hideBudget = true, $hideTarget = true, $printHtml = false)
    {

        $noTopBorder = false;
        $backgroundColor = '#fafafa';
        $html = '';

        $totals = array();
        $numColumns = 2 + ($hideBudget ? 0 : 2) + ($hideTarget ? 0 : 2) + ($budget[0]->totstg * 2);
        foreach ($budget as $item) {
            if ($item->tpanag != '' && $item->cdanag != '') {
                $currency = $this->utility->getCurrencySymbol($item->cdvalu);
                if (!isset($totals[$item->cdvalu])) {
                    $totals[$item->cdvalu] = array_fill(0, $numColumns, 0);
                }

                $style = '';
                if ($noTopBorder) {
                    $noTopBorder = false;
                    $style = 'border-top:0';
                }

                $html .= $this->getGlobalBudgetRowHtml($lineColumnWidth, $otherColumnWidth,
                    $measureUnit, $item, $backgroundColor, $style, $currency, $hideBudget, $hideTarget);

                $backgroundColor = $backgroundColor == '#fafafa' ? '#eaeaea' : '#fafafa';
                $index = 0;

                // Target
                if (!$hideTarget) {
                    $totals[$item->cdvalu][$index] += $item->qtatrg;
                    $index++;
                    $totals[$item->cdvalu][$index] += $item->valtrg;
                    $index++;
                }

                // Budget
                if (!$hideBudget) {
                    $totals[$item->cdvalu][$index] += $item->qtabdg;
                    $index++;
                    $totals[$item->cdvalu][$index] += $item->valbdg;
                    $index++;
                }

                // Actual
                $totals[$item->cdvalu][$index] += $item->currentSituation['totQty'];
                $index++;
                $totals[$item->cdvalu][$index] += $item->currentSituation['totAmt'];
                $index++;

                // Comparison seasons
                for ($i = 0; $i < $item->totstg; $i++) {
                    $qtastg = 'qtast' . ($i + 1);
                    $valstg = 'valst' . ($i + 1);
                    $totals[$item->cdvalu][$index] += $item->$qtastg;
                    $index++;
                    $totals[$item->cdvalu][$index] += $item->$valstg;
                    $index++;
                }
            }
        }

        // Global total
        $html .= $this->getGlobalBudgetTotalRowHtml($lineColumnWidth, $otherColumnWidth, $measureUnit, $totals,
            $hideBudget, $hideTarget);

        if ($printHtml) {
            echo $html;
        } else {
            return $html;
        }
    }
    //endregion

    //region Admin widgets
    public function printModalWindowForSaleAnalysis($type, $title, $elements, $isSeries = false)
    {
        echo '<div class="modal fade modal-' . $type . '" tabindex="-1" role="dialog" aria-hidden="true" style="font-size:13px" data-type="' . $type . '">';

        echo '<div class="modal-dialog modal-lg">';
        echo '<div class="modal-content">';

        echo '<div class="modal-header">';
        echo '<button type="button" class="close" data-dismiss="modal" aria-label="' . Utility::getTranslatorFor()->_('_common.close') . '">';
        echo '<span aria-hidden="true">×</span>';
        echo '</button>';
        echo '<h4 class="modal-title">' . $title . '</h4>';
        echo '</div>';

        echo '<div class="modal-body">';
        if (count($elements) > 0) {
            echo '<div class="modal-section">';
            echo '<div class="row pb-10x">';
            echo '<div class="col-md-3">';
            echo '<button type="button" class="btn btn-default btn-check-all">' . Utility::getTranslatorFor()->_('_common.all.check') . '</button>';
            echo '</div>';
            echo '<div class="col-md-3">';
            echo '<button type="button" class="btn btn-default btn-uncheck-all">' . Utility::getTranslatorFor()->_('_common.all.uncheck') . '</button>';
            echo '</div>';
            echo '<div class="col-md-2 right pt-8x capitalize">' . Utility::getTranslatorFor()->_('_common.search') . '</div>';
            echo '<div class="col-md-4"><input type="text" class="p-5x search-field"/></div>';
            echo '</div>'; // Close .row.pb-10x
            echo '</div>'; // Close .modal-section

            echo '<div class="modal-section mb-10x" style="border-bottom:1px #eee solid">';
            echo '<div class="row mt-10x">';
            echo '<div class="col-md-1"></div>';
            echo '<div class="col-md-2">' . Utility::getTranslatorFor()->_('_common.code') . '</div>';
            echo '<div class="col-md-9">' . Utility::getTranslatorFor()->_('_common.description') . '</div>';
            echo '</div>'; // Close .row.mt-10x
            echo '</div>'; // Close .modal-section.mb-10x

            echo '<div class="modal-section" style="height:300px;overflow-y:scroll;overflow-x:hidden">';
            foreach ($elements as $item) {
                echo '<div class="row ' . $type . '-row pb-10x">';
                echo '<div class="col-md-1">';
                echo '<label class="checkbox-container mb-0">';
                if (!$isSeries) {
                    echo '<input type="checkbox" name="' . $type . '-box[]" value="' . $item->code . '"/>';
                } else {
                    echo '<input type="checkbox" name="' . $type . '-box[]" data-cdlinm="' . $item->lineCode . '" data-cdserm="' . $item->seriesCode . '"/>';
                }
                echo '<span class="checkbox-checkmark"></span>';
                echo '</label>';
                echo '</div>';
                if (!$isSeries) {
                    echo '<div class="col-md-2 descri" style="line-height:20px;padding-top:3px">' . $item->code . '</div>';
                    echo '<div class="col-md-9 descri" style="line-height:20px;padding-top:3px">' . $item->description . '</div>';
                } else {
                    echo '<div class="col-md-2 descri" style="line-height:20px;padding-top:3px">' . $item->lineCode . ' - ' . $item->seriesCode . '</div>';
                    echo '<div class="col-md-9 descri" style="line-height:20px;padding-top:3px">' . $item->lineDescription . ' - ' . $item->seriesDescription . '</div>';
                }
                echo '</div>'; // Close .row.pb-10x
            }
            echo '</div>'; // Close .modal-section
        }
        echo '</div>'; // Close .modal-body

        echo '<div class="modal-footer">';
        echo '<div class="row">';
        echo '<div class="col-md-6 col-sm-6 col-xs-6">';
        echo '<button type="button" class="btn btn-default left-btn w-50" data-dismiss="modal">' . Utility::getTranslatorFor()->_('_common.cancel') . '</button>';
        echo '</div>';
        echo '<div class="col-md-6 col-sm-6 col-xs-6">';
        echo '<button type="button" class="btn btn-primary right-btn w-50 capitalize btn-confirm" ';
        echo 'data-dismiss="modal">' . Utility::getTranslatorFor()->_('_common.confirm') . '</button>';
        echo '</div>';
        echo '</div>';
        echo '</div>';

        echo '</div>'; // Close .modal-content
        echo '</div>'; // Close .modal-dialog.modal-lg

        echo '</div>'; // Close .modal.fade
    }
    //endregion

    //region Images
    public function getLookImgOrDefaultFromImgurl($file, $descr, $prop = array())
    {
        $imgurl = "/upload/looks/" . $file;
        $exist = $file != '' && $this->diskManager->fileExistsInPublic($imgurl);
        if (!$exist) {
            $imgurl = $this->utility->getImageModelLink($file);
            $exist = $file != '' && $this->diskManager->fileExistsInPublic("img/model/" . $file);
        }
        echo "<img src='" . ($exist ? $imgurl : $this->config->application->baseUri . "assets/img/default_model.jpg") . "' alt='" . $descr . "' ";
        if (count($prop) > 0) {
            foreach ($prop as $key => $value) {
                echo $key . "='" . $value . "' ";
            }
        }
        echo "/>";
    }

    public function getModelImgOrDefaultFromImgurl($file, $descr, $prop = array())
    {
        $imgurl = $this->utility->getImageModelLink($file);
        $exist = $file != '' && $this->diskManager->fileExistsInPublic("img/model/" . $file);
        echo "<img src='" . ($exist ? $imgurl : $this->config->application->baseUri . "assets/img/default_model.jpg") . "' alt='" . $descr . "' ";
        if (count($prop) > 0) {
            foreach ($prop as $key => $value) {
                echo $key . "='" . $value . "' ";
            }
        }
        echo "/>";
    }

    public function getModelImageUrl($file)
    {
        $imgurl = $this->utility->getImageModelLink($file);
        $exist = $file != '' && $this->diskManager->fileExistsInPublic("img/model/" . $file);
        return ($exist ? $imgurl : $this->config->application->baseUri . "assets/img/default_model.jpg");
    }

    public function getModelImgOrDefault($file, $descr, $prop = array(), $isLazy = false, $checkUpload = false)
    {
        if ($checkUpload) {
            $imgurl = 'upload/' . $file;
            $exist = $file != '' && $this->diskManager->fileExistsInPublic($imgurl);
            if (!$exist) {
                $imgurl = $this->utility->getImageModelLink($file);
                $exist = $file != '' && $this->diskManager->fileExistsInPublic('img/model/' . $file);
            }
        } else {
            $imgurl = $this->utility->getImageModelLink($file);
            $exist = $file != '' && $this->diskManager->fileExistsInPublic('img/model/' . $file);
        }

        $dataSrc = ($exist ? $imgurl : $this->config->application->baseUri . 'assets/img/default_model.jpg');
        $url = ($exist ? $imgurl : $this->config->application->baseUri . 'assets/img/default_model.jpg');
        if ($isLazy) {
            $dataSrc = $url;
            $url = $this->config->application->baseUri . 'assets/img/blank.gif';
        }

        echo "<img src='$url' data-src='$dataSrc' alt='$descr' ";
        if (count($prop) > 0) {
            foreach ($prop as $key => $value) {
                echo $key . "='$value' ";
            }
        }

        echo "/>";
    }

    public function getVariantImgOrDefaultHtml($file, $descr, $prop = array())
    {
        $html = '';
        $imgurl = "upload/variants/" . $file;
        $exist = $file != '' && $this->diskManager->fileExistsInPublic($imgurl);
        $html .= "<img src='" . $this->config->application->baseUri . ($exist ? $imgurl : "assets/img/default_model.jpg") . "' alt='" . $descr . "' ";
        if (count($prop) > 0) {
            foreach ($prop as $key => $value) {
                $html .= $key . "='" . $value . "' ";
            }
        }
        $html .= "/>";
        return $html;
    }

    public function getModelImgOrDefaultHtml($file, $descr, $prop = array(), $isLazy = false)
    {
        $html = '';
        $imgurl = $this->utility->getImageModelLink($file);
        $exist = $file != '' && $this->diskManager->fileExistsInPublic("img/model/" . $file);

        $dataSrc = ($exist ? $imgurl : $this->config->application->baseUri . 'assets/img/default_model.jpg');
        $url = $exist ? $imgurl : $this->config->application->baseUri . 'assets/img/default_model.jpg';
        if ($isLazy) {
            $dataSrc = $url;
            $url = $this->config->application->baseUri . 'assets/img/blank.gif';
        }

        $html .= "<img src='$url' data-src='$dataSrc' alt='$descr' ";
        if (count($prop) > 0) {
            foreach ($prop as $key => $value) {
                $html .= $key . "='" . $value . "' ";
            }
        }
        $html .= "/>";
        return $html;
    }

    public function getVariantImgOrDefault($file, $descr, $prop = array())
    {
        $imgurl = "upload/variants/" . $file;
        $exist = $file != '' && $this->diskManager->fileExistsInPublic($imgurl);
        echo "<img src='" . $this->config->application->baseUri . ($exist ? $imgurl : "assets/img/default_model.jpg") . "' alt='" . $descr . "' ";
        if (count($prop) > 0) {
            foreach ($prop as $key => $value) {
                echo $key . "='" . $value . "' ";
            }
        }
        echo "/>";
    }
    //endregion

    //region Order info slider
    public function getOrderSliderDate($orderInfo, $dateTypeAvaOrder, $dateTypeResOrder, $periods, $controllerName)
    {
        $isDisabled = $controllerName == 'cart' ? 'disabled' : '';
        if ($orderInfo->tpordc == 0 && $dateTypeAvaOrder == 4) {
            echo $orderInfo->dtmcli;
        } else if (($orderInfo->tpordc == 1 && $dateTypeResOrder < 2) || ($orderInfo->tpordc == 0 && $dateTypeAvaOrder < 2)) {
            echo '<div class="form-element form-select mt-10x">';
            echo '<label class="form-custom-select">';
            echo '<select name="period" id="period">';
            echo '<option value="0000-00-00" ' . ($orderInfo->dtmcli_n == "0000-00-00" ? 'selected' : '') . '></option>';
            foreach ($periods as $scacon) {
                echo '<option value="' . $scacon->dtmcli . '" ' . ($orderInfo->dtmcli_n == $scacon->dtmcli ? 'selected' : '') . '>' . $scacon->dsscad . '</option>';
            }
            echo '</select>';
            echo '</label>';
            echo '</div>';
        } else if ($orderInfo->tpordc == 1 && $dateTypeResOrder == 4) {
            echo '<input type="text" id="date-range-order" class="form-control general-dtmcli m-0" style="border:1px solid #606060" ';
            echo 'value="' . ($orderInfo->dtmcoi != '00/00/0000' ? $orderInfo->dtmcoi : '') . ' - ' . ($orderInfo->dtmcof != '00/00/0000' ? $orderInfo->dtmcof : '') . '" ';
            echo $isDisabled . '>';
        } else if ($dateTypeResOrder == 5) {
            $selectedTpcond = 0;
            echo '<div class="form-element form-select mt-10x">';
            echo '<label class="form-custom-select">';
            echo '<select id="per-res-step-1" name="period">';
            foreach ($periods as $scacon) {
                if ($orderInfo->dtmcli_n >= $scacon['dtmcoi'] && $orderInfo->dtmcli_n <= $scacon['dtmcof']) {
                    $selectedTpcond = $scacon['tpcond'];
                }
                echo '<option value="' . $scacon['tpcond'] . '" ' . ($orderInfo->dtmcli_n >= $scacon['dtmcoi'] && $orderInfo->dtmcli_n <= $scacon['dtmcof'] ? 'selected' : '') . '>';
                echo $scacon['dsscad'];
                echo '</option>';
            }
            echo '</select>';
            echo '</label>';
            echo '</div>';

            echo '<div class="form-element form-select mt-10x">';
            echo '<label class="form-custom-select">';

            echo '<select name="period" id="period">';
            foreach ($periods as $scacon) {
                foreach ($scacon['secondStep'] as $date) {
                    echo '<option value="' . $date . '" data-tpcond="' . $scacon['tpcond'] . '" ';
                    echo $orderInfo->dtmcli_n == $date ? 'selected' : '';
                    echo $scacon['tpcond'] != $selectedTpcond ? 'style="display:none"' : '';
                    echo '>';
                    echo date('d/m/Y', strtotime($date));
                    echo '</option>';
                }
            }
            echo '</select>';
            echo '</label>';
            echo '</div>';
        } else {
            if ($isDisabled) {
                echo $orderInfo->dtmcli != '00/00/0000' ? $orderInfo->dtmcli : '';
            } else {
                echo '<input type="text" id="datepicker" class="general-dtmcli" value="' . ($orderInfo->dtmcli != '00/00/0000' ? $orderInfo->dtmcli : '') . '">';
            }
        }
    }
    //endregion

    //region Configurator wizard widgets
    public function getMultilevelMaterialTypeDiv($material)
    {
        $html = '<div class="component-box ' . (isset($material['isDefault']) && $material['isDefault'] ? 'selected' : '') . '" ';
        $html .= ' data-code="' . $material['cdmate'] . '" ';
        $html .= 'data-description="' . $material['dsmate'] . '">';
        $html .= '<div class="check"><i class="fa fa-check"></i></div>';
        $html .= '<div>';
        $html .= $this->getModelImgOrDefaultHtml(
            $material['flimag'],
            $material['dsmate'],
            array('class' => 'configurator-preview', 'data-toggle' => 'tooltip', 'data-placement' => 'top', 'title' => $material['dsmate']),
            false
        );
        $html .= '</div>';
        $html .= '<div class="description">' . $material['cdcolo'] . '</div>';
        $html .= '</div>'; // Close .component-box
        return $html;
    }

    private function getMultilevelComponentTypeDiv($type, $tpcomp)
    {
        $componentsHtml = '';
        foreach ($type['materials'] as $material) {
            if ($type['isDefault']) {
                $componentsHtml .= $this->getMultilevelMaterialTypeDiv($material);
            }
        }

        $html = '<div class="selector-component-container ' . ($type['isDefault'] ? 'content-ready' : '') . '" ';
        $html .= 'data-checkable="0" ';
        $html .= 'data-cdmatn="' . $type['cdmatn'] . '" ';
        $html .= 'data-tpcomp="' . $tpcomp . '" ';
        $html .= 'style="width:' . ((count($type['materials']) * 60) + 10) . 'px;' . (isset($type['isDefault']) && $type['isDefault'] ? '' : 'display:none') . '">';
        $html .= $componentsHtml;
        $html .= '</div>'; // Close .selector-component-container
        return $html;
    }

    private function getComponentTypeOption($type, $isDefault)
    {
        $html = '<option value="' . $type['cdmatn'] . '" ';
        $html .= $isDefault ? 'selected' : '';
        $html .= ' data-code="' . $type['cdmatn'] . '" ';
        $html .= 'data-description="' . $type['dsmatn'] . '" ';
        $html .= 'data-image="' . (isset($type['image']) ? $this->getModelImageUrl($type['image']) : '') . '">';
        $html .= $type['dsmatn'] . ' (' . $type['cdmatn'] . ')';
        $html .= '</option>';
        return $html;
    }

    public function getCustomComponentTool($component)
    {
        $defaultDataInfo = 'data-tpcomp="' . $component['tpcomp'] . '" ';
        $defaultDataInfo .= 'data-code="' . $component['defaultTypeCode'] . '" ';
        $defaultDataInfo .= 'data-description="' . $component['defaultTypeDescription'] . '"';

        $html = '<div class="row m-0 my-5x">';

        $html .= '<div class="col-3 col-md-2 component-title">' . $component['dscomp'] . '</div>';
        if (!$component['multilevel']) {
            if ($component['inplib'] == 0) {
                $html .= '<div class="col-9 col-md-10 selector-component-container-outer">';

                $html .= '<div class="selector-component-container" ';
                $html .= $defaultDataInfo . ' ';
                $html .= 'style="width:' . ((count($component['types']) * 60) + 10) . 'px">';

                foreach ($component['types'] as $type) {
                    $cdmatn = $type['cdmatn'];
                    $materials = isset($type['materials']) ? $type['materials'] : array();
                    $currentMaterial = isset($materials[$cdmatn]) ? $materials[$cdmatn] : $materials[$component['defaultMaterialCode']];
                    $currentImage = $currentMaterial['flimag'];

                    $html .= '<div class="component-box ' . ($type['isDefault'] ? 'selected' : '') . '" ';
                    $html .= 'data-code="' . $currentMaterial['cdmate'] . '" data-description="' . $currentMaterial['dsmate'] . '">';
                    $html .= '<div class="check"><i class="fa fa-check"></i></div>';
                    $html .= '<div>';
                    $html .= $this->getModelImgOrDefaultHtml(
                        $currentImage,
                        $type['dsmatn'],
                        array('class' => 'configurator-preview', 'data-toggle' => 'tooltip', 'data-placement' => 'top', 'title' => $type['dsmatn']),
                        false
                    );
                    $html .= '</div>';
                    $html .= '<div class="description">' . $type['dsmatn'] . '</div>';
                    $html .= '</div>'; // Close .component-box
                }

                $html .= '</div>'; // Close .selector-component-container
                $html .= '</div>'; // Close .selector-component-container-outer
            } else {
                $html .= '<div class="col-9 col-md-10 selector-component-container" ';
                $html .= $defaultDataInfo . '>';

                $html .= '<div class="component-box selected">';
                $html .= '<div class="check"><i class="fa fa-check"></i></div>';
                $html .= '<div>';
                $html .= $this->getModelImgOrDefaultHtml(
                    $component['defaultMaterialImage'],
                    $component['defaultTypeDescription'],
                    array('class' => 'configurator-preview', 'data-toggle' => 'tooltip', 'data-placement' => 'top', 'title' => $component['defaultTypeDescription']),
                    false
                );
                $html .= '</div>';
                $html .= '<div class="description">' . $component['defaultTypeDescription'] . '</div>';
                $html .= '</div>'; // Close .component-box

                $html .= '<select class="selectpicker" data-live-search="true">';
                foreach ($component['types'] as $type) {
                    $html .= $this->getComponentTypeOption($type, $type['cdmatn'] == $component['defaultTypeCode']);
                }
                $html .= '</select>';

                $html .= '</div>'; // Close .selector-component-container
            }
        } else {
            $html .= '<div class="col-9 col-md-10 selector-component-container" data-multilevel="1" ';
            $html .= $defaultDataInfo . '>';

            $html .= '<div class="row">';

            $html .= '<div class="col-6">';
            $html .= '<select class="selectpicker" data-live-search="true">';
            foreach ($component['types'] as $type) {
                $html .= $this->getComponentTypeOption($type, $type['cdmatn'] == $component['defaultTypeCode']);
            }
            $html .= '</select>';
            $html .= '</div>'; // Close .col-6

            $html .= '<div class="col-6"><a href="#" class="view-component" style="line-height:50px">' . Utility::getTranslatorFor()->_('_common.view') . '</a></div>';

            $html .= '<div class="col-12 selector-component-container-outer">';
            foreach ($component['types'] as $type) {
                $html .= $this->getMultilevelComponentTypeDiv($type, $component['tpcomp']);
            }
            $html .= '</div>'; // Close .col-12.selector-component-container-outer

            $html .= '</div>'; // Close .row
            $html .= '</div>'; // Close .selector-component-container
        }

        $html .= '</div>'; // Close .row.m-0.my-5x

        return $html;
    }

    //endregion

    public function printAddress($item, $printCountry = true)
    {
        echo $item->indiri;
        if ($item->ccitta != '') {
            echo ' - ' . $item->ccitta;
        }
        if ($item->provin != '') {
            echo ' (' . $item->provin . ')';
        }
        if ($printCountry && isset($item->dsnazi) && $item->dsnazi != '') {
            echo ' - ' . $item->dsnazi;
        }
    }

    public function getAddress($item)
    {
        $address = $item->indiri;
        if ($item->ccitta != '') {
            $address .= ' - ' . $item->ccitta;
        }
        if ($item->provin != '') {
            $address .= ' (' . $item->provin . ')';
        }
        if (isset($item->dsnazi) && $item->dsnazi != '') {
            $address .= ' - ' . $item->dsnazi;
        }
        return $address;
    }

    public function getImageSlide($image, $accessType, $buttonPosition)
    {
        echo '<div class="slide" style="background-image:url(\'' . $this->url->get('upload/' . $image) . '\')">';
        echo '<div class="container text-center">';
        echo '<a href="' . $this->url->get('catalog/' . ($accessType == 0 ? 'collection' : 'list')) . '" ';
        echo 'class="btn btn-generic scale-up btn-hp-ctlg" style="bottom:' . $buttonPosition . '">' . Utility::getTranslatorFor()->_('_common.brandalltext') . '</a>';
        echo '</div>';
        echo '</div>';
    }

    public function getVideoSlide($image, $accessType, $buttonPosition)
    {
        echo '<div class="slide">';
        echo '<video class="video-slide" autoplay loop muted>';
        echo '<source src="' . $this->url->get('upload/' . $image) . '" type="video/mp4"/>';
        echo '</video>';
        echo '<div class="container text-center">';
        echo '<a href="' . $this->url->get('catalog/' . ($accessType == 0 ? 'collection' : 'list')) . '" ';
        echo 'class="btn btn-generic scale-up btn-hp-ctlg" style="bottom:' . $buttonPosition . '">' . Utility::getTranslatorFor()->_('_common.brandalltext') . '</a>';
        echo '</div>';
        echo '</div>';
    }

    public function printOrderAddress($orderInfo)
    {
        if ($orderInfo->dsdesm != '') {
            echo $orderInfo->dsdesm . ' - ' . $orderInfo->indiri_d;

            if ($orderInfo->indiri_d != '') {
                echo ' - ' . $orderInfo->ccitta_d;
            }

            if ($orderInfo->provin_d != '' &&
                ($orderInfo->dsnazi_d == 'Italia' || $orderInfo->dsnazi_d == 'ITALIA' || $orderInfo->dsnazi_d == 'italia' ||
                    $orderInfo->dsnazi_d == 'Italy' || $orderInfo->dsnazi_d == 'ITALY' || $orderInfo->dsnazi_d == 'italy')) {
                echo ' (' . $orderInfo->provin_d . ')';
            }

            if ($orderInfo->dsnazi_d != '' && $orderInfo->dsnazi_d != $orderInfo->ccitta_d &&
                $orderInfo->dsnazi_d != 'Italia' && $orderInfo->dsnazi_d != 'ITALIA' && $orderInfo->dsnazi_d != 'italia' &&
                $orderInfo->dsnazi_d != 'Italy' && $orderInfo->dsnazi_d != 'ITALY' && $orderInfo->dsnazi_d != 'italy') {
                echo ' - ' . $orderInfo->dsnazi_d;
            }
        } else {
            echo $orderInfo->indiri_a;

            if ($orderInfo->indiri_a != '') {
                echo ' - ' . $orderInfo->ccitta_a;
            }

            if ($orderInfo->provin_a != '' &&
                ($orderInfo->dsnazi_a == 'Italia' || $orderInfo->dsnazi_a == 'ITALIA' || $orderInfo->dsnazi_a == 'italia' ||
                    $orderInfo->dsnazi_a == 'Italy' || $orderInfo->dsnazi_a == 'ITALY' || $orderInfo->dsnazi_a == 'italy')) {
                echo ' (' . $orderInfo->provin_a . ')';
            }

            if ($orderInfo->dsnazi_a != '' && $orderInfo->dsnazi_a != $orderInfo->ccitta_a &&
                $orderInfo->dsnazi_a != 'Italia' && $orderInfo->dsnazi_a != 'ITALIA' && $orderInfo->dsnazi_a != 'italia' &&
                $orderInfo->dsnazi_a != 'Italy' && $orderInfo->dsnazi_a != 'ITALY' && $orderInfo->dsnazi_a != 'italy') {
                echo ' - ' . $orderInfo->dsnazi_a;
            }
        }
    }

    public function getCatalogPresentationBox($selCatalog, $catalogs)
    {
        $controller = new ControllerBase();
        echo '<div class="form-group col-md-6 px-30x mb-40x catalog-box">';

        echo '<div class="row mb-20x">';

        echo '<label class="control-label col-md-3 col-sm-3 col-xs-12 text-right" style="margin-top:11px">';
        echo $controller->translate('order.selectcatalog');
        echo '</label>';

        echo '<div class="col-md-6 col-sm-6 col-xs-12">';
        echo '<select class="select2_single form-control catalog-pres" tabindex="-1">';
        foreach ($catalogs as $cttest) {
            echo '<option value="' . $cttest->cdcata . '" ';
            if ($cttest->cdcata == $selCatalog->cdcata) {
                echo 'selected';
            }
            echo '>' . $cttest->cdcata . ' - ' . $cttest->dscata . '</option>';
        }
        echo '</select>';
        echo '</div>';

        echo '<div class="col-md-1 col-sm-1 col-xs-12">';
        echo '<a href="#" class="btn btn-default delete-catalog-box capitalize">' . $controller->translate('_common.delete') . '</a>';
        echo '</div>';

        echo '</div>';

        echo '<div class="row">';
        echo '<div class="col-md-10 col-sm-10 col-xs-12">';
        echo '<form action="' . $this->url->get('admin/uploadImage') . '" class="dropzone dropzone-slide" ';
        echo 'style="max-width:158px;margin:0 auto" ';
        echo 'id="box-ct' . $selCatalog->cdcata . '-sr' . $selCatalog->seqrap . '"></form>';
        echo '</div>';
        echo '</div>';

        echo '</div>';
    }

    public function getFilterLi($el, $apply)
    {
        $isChecked = '';


        if (isset($apply) && isset($apply['filter'])) {
            if (!empty($el->codice)) {
                if (in_array($el->codice, $apply['filter'])) {
                    $isChecked = 'checked';
                }
            } else if (!empty($el->codic1) && !empty($el->codic2)) {
                foreach ($apply['filter'] as $item) {
                    if ($item['code1'] == $el->codic1 && $item['code2'] == $el->codic2) {
                        $isChecked = 'checked';
                        break;
                    }
                }
            }
        }

        $id = substr(str_shuffle(MD5(microtime())), 0, 10);

        echo '<li>';
        echo '<div>';
        if (!empty($el->codice)) {
            echo '<input type="checkbox" data-code="' . $el->codice . '" id="' . $id . '" ';
            echo 'class="flt-generic checkbox-custom" ' . $isChecked . '/>';
        } else if (!empty($el->codic1) && !empty($el->codic2)) {
            echo '<input type="checkbox" data-code1="' . $el->codic1 . '" data-code2="' . $el->codic2 . '" id="' . $id . '" ';
            echo 'class="flt-generic checkbox-custom" ' . $isChecked . '/>';
        }
        echo '<label class="checkbox-custom-label text-capitalize" for="' . $id . '">' . $el->descri . '</label>';
        echo '</div>';
        echo '</li>';
    }

    public function getCartDescr($article, $type, $typeDescr = 0)
    {
        switch ($type) {
            case 1:
                echo $article['cdarti'] . ($article['tppers'] == 'PT' ? ' - ' . $article['cdcolo'] : '');
                break;
            case 2:
                switch ($typeDescr) {
                    case 0:
                        echo $article['dsarti'];
                        break;
                    case 1:
                        echo $article['cdcolo'] . ' - ' . $article['dsartn'] . ' - ' . $article['dsarti'];
                        break;
                    case 2:
                        echo $article['dsartn'] . ($article['dscolo'] != '' ? ' - ' . $article['dscolo'] : '');
                        break;
                    case 3:
                        echo $article['dstitl'] . ' - ' . $article['dsarti'];
                        break;
                    case 4:
                        echo $article['dsarti'] . ($article['dscolo'] != '' ? ' - ' . $article['dscolo'] : '');
                        break;
                    default:
                        echo '';
                        break;
                }
                break;
            case 3:
                if (isset($article['features']) && count($article['features']) > 0) {
                    foreach ($article['features'] as $feature) {
                        if ($feature->tpcomp == 'TOMAIA') {
                            echo $feature->valore;
                        }
                    }
                } else {
                    echo '&nbsp;';
                }
                break;
        }
    }

    public function getCartShippingText($info)
    {
        if ($info->dsdesm != '') {
            echo $info->dsdesm . ' - ' . $info->indiri_d;
            echo $info->indiri_d != '' ? ' - ' . $info->ccitta_d : '';
            echo $info->provin_d != '' && in_array($info->dsnazi_d, ['Italia', 'ITALIA', 'italia', 'Italy', 'ITALY', 'italy']) ? ' (' . $info->provin_d . ')' : '';
            echo $info->dsnazi_d != '' && !in_array($info->dsnazi_d, ['Italia', 'ITALIA', 'italia', 'Italy', 'ITALY', 'italy']) ? ' - ' . $info->dsnazi_d : '';
        } else {
            echo $info->indiri_a;
            echo $info->indiri_a != '' ? ' - ' . $info->ccitta_a : '';
            echo $info->provin_a != '' && in_array($info->dsnazi_a, ['Italia', 'ITALIA', 'italia', 'Italy', 'ITALY', 'italy']) ? ' (' . $info->provin_a . ')' : '';
            echo $info->dsnazi_a != '' && !in_array($info->dsnazi_a, ['Italia', 'ITALIA', 'italia', 'Italy', 'ITALY', 'italy']) ? ' - ' . $info->dsnazi_a : '';
        }
    }

    public function getHighlightClass($force = false)
    {
        /** @var Utility $utility */
        $utility = $this->getDI()->get('utility');
        $highlightEffects = $utility->getAppSettings('HighlightEffects');
        if (!empty($highlightEffects)) {
            return "$highlightEffects-underline";
        }
    }
}
