<?php

namespace Go2B\Library;

use Go2B\Controllers\ControllerBase;
use Go2B\Controllers\Utility;
use Phalcon\Mvc\User\Component;

class AjaxHtmlBuilder extends Component
{
  //region Catalog > Gallery functions
  public function getHtmlCodeForGalleryProduct($product, $isArticle = false) {
    $prefix = $this->config->application->baseUri;

    $flimag = $product->flimag != '' && file_exists('img/model/' . $product->flimag)
      ? $this->utility->getImageModelLink($product->flimag)
      : $prefix . 'assets/img/default_model.jpg';

    $html = '<div class="row mx-0 my-10x"><!-- open .row -->';
    $html .= '<input type="hidden" id="selected-product-code" value="' . ($isArticle ? $product->cdarti : $product->cdartn) . '"/>';

    // First column
    $html .= '<div class="col-12 col-lg-6"><!-- open .col-12.col-lg-6 -->';

    $html .= '<div class="row" id="modal-product-slider" style="overflow-y:hidden;max-height:450px" ';
    $html .= 'data-max-index="' . count($product->images) . '"><!-- open #modal-product-slider -->';

    // Left arrow
    if (count($product->images) > 0) {
      $html .= '<div class="col-2 text-center gallery-modal-arrow"><i class="fa fa-chevron-left" style="margin-top:200px"></i></div>';
    }

    // Default Image
    $html .= '<div class="' . (count($product->images) > 0 ? 'col-8' : 'col-12') . ' modal-img-wrapper text-center" data-index="0">';
    $html .= '<img src="' . $flimag . '" alt="' . ($isArticle ? $product->dsarti : $product->dsartn) . '" style="max-height:450px"/>';
    $html .= '</div>';

    // Additional images
    $i = 1;
    foreach ($product->images as $imgart) {
      $flimag = $imgart->flimag != '' && file_exists('img/model/' . $imgart->flimag)
        ? $this->utility->getImageModelLink($imgart->flimag)
        : $prefix . 'assets/img/default_model.jpg';
      $html .= '<div class="col-8 modal-img-wrapper" data-index="' . $i . '" style="display:none">';
      $html .= '<img src="' . $flimag . '" alt="' . ($isArticle ? $product->dsarti : $product->dsartn) . '" style="max-height:450px"/>';
      $html .= '</div>';
      $i++;
    }

    // Right arrow
    if (count($product->images) > 0) {
      $html .= '<div class="col-2 text-center gallery-modal-arrow"><i class="fa fa-chevron-right" style="margin-top:200px"></i></div>';
    }

    $html .= '</div><!-- close #modal-product-slider -->';

    $html .= '<div class="row mt-20x" style="height:200px;overflow-y:auto"><!-- open .row -->';

    $html .= '<div class="' . (count($product->images) > 0 ? 'col-8 offset-2' : 'col-12') . '">';
    $html .= '<div class="row">';

    // Selector on first column footer
    if ($isArticle) {
      foreach ($product->colors as $artcol) {
        $flimag = $artcol['flimag'] != '' && file_exists('img/model/' . $artcol['flimag'])
          ? $this->utility->getImageModelLink($artcol['flimag'])
          : $prefix . 'assets/img/default_model.jpg';
        $html .= '<div class="col-3 text-center mb-10x product-gallery-selector" data-cdcolo="' . $artcol['cdcolo'] . '">';
        $html .= '<div>';
        $html .= '<div class="check"><i class="fa fa-check"></i></div>';
        $html .= '<img src="' . $flimag . '" title="' . $artcol['dscolo'] . '" alt="' . $artcol['dscolo'] . '"/>';
        $html .= '</div>';
        $html .= '<div>';
        $html .= $artcol['cdcolo'] == $artcol['dscolo']
          ? (empty($artcol['cdcolo']) ? $artcol['dscolo'] : $artcol['cdcolo'])
          : $artcol['cdcolo'] . '<br/>' . $artcol['dscolo'];
        $html .= '</div>';
        $html .= '</div>';
      }
    } else {
      foreach ($product->articles as $anaart) {
        $flimag = $anaart->flimag != '' && file_exists('img/model/' . $anaart->flimag)
          ? $this->utility->getImageModelLink($anaart->flimag)
          : $prefix . 'assets/img/default_model.jpg';
        $html .= '<div class="col-3 text-center mb-10x product-gallery-selector" data-cdarti="' . $anaart->cdarti . '">';
        $html .= '<div>';
        $html .= '<div class="check"><i class="fa fa-check"></i></div>';
        $html .= '<img src="' . $flimag . '" title="' . $anaart->dsarti . '" alt="' . $anaart->dsarti . '"/>';
        $html .= '</div>';
        $html .= '<div>' . $anaart->cdarti . '<br/>' . $anaart->dsarti . '</div>';
        $html .= '</div>';
      }
    }

    $html .= '</div>';
    $html .= '</div>';

    $html .= '</div><!-- close .row -->';
    $html .= '</div><!-- close .col-12.col-lg-6 -->';

    // Second column
    $html .= '<div class="col-12 col-lg-6"><!-- open .col-12.col-lg-6 -->';

    $html .= '<div class="row"><!-- open .row -->';
    $html .= '<div class="' . ($isArticle ? 'col-6' : 'col-12') . ' font-weight-bold" style="height:20px">';
    $html .= $isArticle ? $product->dsartn . '<br/>' . $product->dsarti : $product->dsartn;
    $html .= '</div>';

    if ($isArticle && !empty($product->cdpers)) {
      $html .= '<div class="col-6">';
      $html .= '<div style="float:left;width:80px;text-align:center">';
      $html .= $this->elements->getModelImgOrDefaultHtml($product->flimag_p, $product->dspers, array('style' => 'width:60px'));
      $html .= '</div>';
      $html .= '<div>' . $product->cdpers . '</div>';
      $html .= '<div id="selected-fabric-composition">';
      $html .= '<span data-toggle="tooltip" data-placement="top" title="' . $product->compos . '">' . Utility::getTranslatorFor()->_('_common.composition') . '</span>';
      $html .= '</div>';
      $html .= '<div style="text-transform:none">';
      $html .= '<a href="' . $this->url->get('catalog/fabricDetail/' . $product->cdpers) . '">';
      $html .= Utility::getTranslatorFor()->_('_common.see.models');
      $html .= '</a>';
      $html .= '</div>';
      $html .= '</div>';
    }

    $html .= '<div class="col-12 mb-20x" style="height:160px"><!-- open .col-12.mb-20x -->';
    $html .= '<div class="model-tabs"><!-- open .model-tabs -->';

    $html .= '<ul class="nav nav-tabs nav-justified w-100 ml-0 d-sm-block" role="tablist" data-tabs="tabs">';
    $html .= '<li class="nav-item">';
    $html .= '<a class="active" href="#tab-info-inf" role="tab" data-toggle="tab" aria-expanded="true">' . Utility::getTranslatorFor()->_('_common.details') . '</a>';
    $html .= '</li>';
    $html .= '<li class="nav-item">';
    $html .= '<a href="#tab-info-not" role="tab" data-toggle="tab" aria-expanded="true">' . Utility::getTranslatorFor()->_('_common.notes') . '</a>';
    $html .= '</li>';
    if ($isArticle) {
      $html .= '<li class="nav-item">';
      $html .= '<a href="#tab-info-fab" role="tab" data-toggle="tab" aria-expanded="true">' . Utility::getTranslatorFor()->_('_common.tissue') . '</a>';
      $html .= '</li>';
    }
    $html .= '</ul>';

    $html .= '<div class="tab-content account-info"><!-- open .tab-content -->';
    $html .= '<div id="tab-info-inf" role="tabpanel" class="tab-pane fade show active">';
    $html .= $product->descomm != "" ? $product->descomm : Utility::getTranslatorFor()->_('_common.details.no');
    $html .= '</div>';
    $html .= '<div id="tab-info-not" role="tabpanel" class="tab-pane fade">';
    $html .= $product->destecn != "" ? $product->destecn : Utility::getTranslatorFor()->_('_common.notes.no');
    $html .= '</div>';
    if ($isArticle) {
      $html .= '<div id="tab-info-fab" role="tabpanel" class="tab-pane fade">' . $product->compos . '</div>';
    }
    $html .= '</div><!-- close .tab-content -->';

    $html .= '</div><!-- close .model-tabs -->';
    $html .= '</div><!-- close .col-12.mb.20x -->';

    $html .= '<div class="col-12" id="modal-insert-quantity" style="height:400px;overflow-y:auto"><!-- open #modal-insert-quantity -->';
    $html .= '<div class="preloader"><img src="' . $prefix . 'assets/img/preloader.gif" alt="Preloader"/></div>';
    $html .= '<div class="insert-quantity-content" style="display:none"></div>';
    $html .= '</div><!-- close #modal-insert-quantity -->';

    $html .= '<div class="col-12 p-0" style="height:60px">';
    $html .= '<a class="btn btn-main add-to-cart w-100 p-0" style="display:none">' . Utility::getTranslatorFor()->_('_common.addtocart')  . '</a>';
    $html .= '</div>';

    $html .= '<div class="col-12 success-box" style="padding:10px 0;display:none">';
    $html .= '<div id="go-to-cart">';
    $html .= Utility::getTranslatorFor()->_(
                'quantity.insert.success',
                ["cart" => "<a href='" . $this->url->get('cart/index') . "' style='color:#606060'>" . Utility::getTranslatorFor()->_('_common.cart') . "</a>"]);
    $html .= '</div>';
    $html .= '</div>';

    $html .= '<div class="col-12 unsuccess-box" style="padding:10px 0;display:none">';
    $html .= '<div>' . Utility::getTranslatorFor()->_('quantity.insert.unsuccess') . '</div>';
    $html .= '</div>';

    $html .= '</div><!-- close .row -->';

    $html .= '</div><!-- close .col-12.col-lg-6 -->';

    return $html;
  }
  //endregion

  //region Insert quantity functions for Catalog Controller
  public function getHtmlCodeForAvaTissue($sizes, $tipolo, $order_rows, $ava,
    $variants, $dateOffset, $showInfo, $modal, $canGoToCart,
    $discount, $addAddToCartButton = true, $showNotes = false) {
    $html = "";

    /*
     * NO_CDVARI: add row for cdvari == '' for every delivery date
     */
    $index = 1;

    // Get availability array for no_cdvari article
    $curr_ava = null;
    for ($i = 0; $i < count($ava); $i++) {
      if ($ava[$i]["cdvari"] == "no_cdvari") {
        $curr_ava = $ava[$i];
        break;
      }
    }

    // Get number of availability dates
    $num_dates = 0;
    if (!empty($curr_ava)) {
      $num_dates = count($curr_ava["alldsp"]);
    }

    // For each date get html row
    if ($num_dates > 0) {
      for ($i = 0; $i < $num_dates; $i++) {
        $this_ava = $curr_ava["alldsp"][$i];

        // Get order row for current
        $curr_row = null;
        for ($j = 0; $j < count($order_rows); $j++) {
          $dtmcli = date("d/m/Y", strtotime(str_replace("/","-",$order_rows[$j]->dtmcli) . " -" . $dateOffset . " days"));
          if ($dtmcli == $this_ava["dtdisp"] && $order_rows[$j]->cdvari == '') {
            $curr_row = $order_rows[$j];
            break;
          }
        }

        // Get html row
        $html .= $this->getHtmlCodeForAvaTissue_Row($sizes, $tipolo, $this_ava,
          $index, $curr_row, "", $dateOffset, $showInfo, $modal, $canGoToCart,
          $discount, $addAddToCartButton, $showNotes);
        $index++;
      }
    }

    /*
     * CDVARI: add row for cdvari != '' for every delivery date
     */
    if (count($variants) > 0) {
      for ($i = 0; $i < count($variants); $i++) {
        // Get availability array for no_cdvari article
        $curr_ava = array();
        for ($j = 0; $j < count($ava); $j++) {
          if ($ava[$j]["cdvari"] == $variants[$i]["cdvari"]) {
            $curr_ava = $ava[$j];
            break;
          }
        }

        // Get number of availability dates
        $num_dates = 0;
        if (!empty($curr_ava)) {
          $num_dates = count($curr_ava["alldsp"]);
        }

        // For each date get html row
        if ($num_dates > 0) {
          for ($j = 0; $j < $num_dates; $j++) {
            $this_ava = $curr_ava["alldsp"][$j];

            // Get order row for current
            $curr_row = null;
            for ($k = 0; $k < count($order_rows); $k++) {
              $dtmcli = date("d/m/Y", strtotime(str_replace("/","-",$order_rows[$j]->dtmcli) . " -" . $dateOffset . " days"));
              if ($dtmcli && $order_rows[$k]->cdvari == $variants[$i]["cdvari"]) {
                $curr_row = $order_rows[$k];
                break;
              }
            }

            // Get html row
            $html .= $this->getHtmlCodeForAvaTissue_Row($sizes, $tipolo, $this_ava,
              $index, $curr_row, $variants[$i], $dateOffset, $showInfo, $modal, $canGoToCart,
              $discount, $addAddToCartButton, $showNotes);
            $index++;
          }
        }
      }
    }

    if (empty($html)) {
      $html .= '<span class="text-capitalize font-italic">' . Utility::getTranslatorFor()->_('_common.notavailable') . '</span>';
    }

    return $html;
  }

  public function getHtmlCodeForResTissue($sizes, $tipolo, $order_rows,
    $variants, $dtmcli, $showInfo, $modal, $canGoToCart,
    $discount, $addAddToCartButton = true, $showNotes = false) {
    $html = "";

    // NO_CDVARI: add row for cdvari == '' for every delivery date
    $index = 1;

    // Get order row for current
    $curr_row = null;
    for ($j = 0; $j < count($order_rows); $j++) {
      if ($order_rows[$j]->cdvari == '') {
        $curr_row = $order_rows[$j];
        break;
      }
    }

    // Get html row
    $html .= $this->getHtmlCodeForResTissue_Row($sizes, $tipolo, $index,
      $curr_row, "", $dtmcli, $showInfo, $modal, $canGoToCart,
      $discount, $addAddToCartButton, $showNotes);
    $index++;

    // CDVARI: add row for cdvari != '' for every delivery date
    if (count($variants) > 0) {
      for ($i = 0; $i < count($variants); $i++) {
        // Get order row for current
        $curr_row = null;
        for ($k = 0; $k < count($order_rows); $k++) {
          if ($order_rows[$k]->cdvari == $variants[$i]["cdvari"]) {
            $curr_row = $order_rows[$k];
            break;
          }
        }

        // Get html row
        $html .= $this->getHtmlCodeForResTissue_Row($sizes, $tipolo, $index,
          $curr_row, $variants[$i], $dtmcli, $showInfo, $modal, $canGoToCart,
          $discount, $addAddToCartButton, $showNotes);
        $index++;
      }
    }

    return $html;
  }

  public function getHtmlCodeForAvaColor($sizes, $tipolo, $order_rows,
    $ava_sizes, $assortments, $dateOffset, $showInfo, $modal, $canGoToCart,
    $discount, $addAddToCartButton = true, $showNotes = false) {
    $html = "";

    $index = 1;

    // Get number of availability dates
    $num_dates = count($ava_sizes);

    // For each date get html row
    if ($num_dates > 0) {
      for ($i = 0; $i < $num_dates; $i++) {
        $this_ava = $ava_sizes[$i];

        // Get order row for current
        $curr_row = null;
        for ($j = 0; $j < count($order_rows); $j++) {
          $date_row = date("d/m/Y", strtotime(str_replace("/","-",$order_rows[$j]->dtmcli) . " -" . $dateOffset . " days"));
          if ($date_row == $this_ava["dtdisp"]) {
            $curr_row = $order_rows[$j];
            break;
          }
        }

        // Get html row
        $html .= $this->getHtmlCodeForAvaColor_Row($sizes, $assortments, $tipolo,
          $this_ava, $index, $curr_row, $dateOffset, $showInfo, $modal, $canGoToCart,
          $discount, $addAddToCartButton, $showNotes);
        $index++;
      }
    }

    if (empty($html)) {
      $html .= '<span class="text-capitalize font-italic">' . Utility::getTranslatorFor()->_('_common.notavailable') . '</span>';
    }

    return $html;
  }

  public function getHtmlCodeForResColor($sizes, $assortments, $tipolo, $order_rows,
    $dateType, $periods, $multipledelivery, $showInfo, $modal, $canGoToCart,
    $discount, $addAddToCartButton = true, $showNotes = false) {
    $html = "";
    $index = 1;

    // Get number of delivery dates
    $num_dates = $multipledelivery ? 3 : 1;

    // For each date get html row
    if ($num_dates > 0) {
      for ($i = 0; $i < $num_dates; $i++) {
        $order_row = count($order_rows) > $i ? $order_rows[$i] : null;

        // Get html row
        $html .= $this->getHtmlCodeForResColor_Row($sizes, $assortments, $tipolo,
          $order_row, $index, $dateType, $periods, $showInfo, $modal, $canGoToCart,
          $discount, $addAddToCartButton, $showNotes);
        $index++;
      }
    }

    return $html;
  }

  public function getHtmlCodeForAvaTissue_Row($sizes, $tipolo, $ava, $index,
    $order_row, $variant, $dateOffset, $showInfo, $modal, $canGoToCart, $discount,
    $addAddToCartButton, $showNotes) {
    $html = "<div class='insert-quantity-block' " . (!$addAddToCartButton ? 'style="margin-bottom:0;padding-bottom:0"' : '') . ">";

    $html .= $this->getHeaderAvaTissueBlock($ava, $index, $order_row, $variant, $dateOffset, $showInfo, $sizes, $modal);

    $html .= $this->getInfoHeaderRow($showNotes, $order_row);

    $html .= $this->getHeaderTable(true, $modal);

    for ($i = 0; $i < count($sizes); $i++) {
      $quanti = 0;
      if (isset($order_row) && $order_row->detail[$sizes[$i]->taglia]) {
        $quanti = $order_row->detail[$sizes[$i]->taglia];
      }
      $blocked = (($i + 1) < $tipolo->tglini && $tipolo->tglini != 0) || (($i + 1) > $tipolo->tglfin && $tipolo->tglfin != 0);
      $html .= $this->getInsertQuantityRow($sizes[$i],
        isset($ava["qtysiz"][$sizes[$i]->taglia]) && $ava["qtysiz"][$sizes[$i]->taglia] > 0 ? $ava["qtysiz"][$sizes[$i]->taglia] : 0, $variant,
        $index . "_" . $i, $quanti, $modal, $discount, true, $blocked);
    }

    if ($addAddToCartButton) {
      $html .= $this->getFooterBlock($modal, $canGoToCart);
    }

    $html .= "</div>";

    return $html;
  }

  public function getHtmlCodeForResTissue_Row($sizes, $tipolo, $index, $order_row,
    $variant, $dtmcli, $showInfo, $modal, $canGoToCart, $discount,
    $addAddToCartButton, $showNotes) {
    $html = "<div class='insert-quantity-block'>";

    $html .= $this->getHeaderResTissueBlock($index, $order_row, $variant, $dtmcli, $showInfo, $sizes, $modal);

    $html .= $this->getInfoHeaderRow($showNotes, $order_row);

    $html .= $this->getHeaderTable(false, $modal);

    for ($i = 0; $i < count($sizes); $i++) {
      $quanti = 0;
      if (isset($order_row) && $order_row->detail[$sizes[$i]->taglia]) {
        $quanti = $order_row->detail[$sizes[$i]->taglia];
      }
      $blocked = (($i + 1) < $tipolo->tglini && $tipolo->tglini != 0) || (($i + 1) > $tipolo->tglfin && $tipolo->tglfin != 0);
      $html .= $this->getInsertQuantityRow($sizes[$i], -1, $variant, $index . "_" . $i, $quanti, $modal, $discount, true, $blocked);
    }

    if ($addAddToCartButton) {
      $html .= $this->getFooterBlock($modal, $canGoToCart);
    }

    $html .= "</div>";

    return $html;
  }

  public function getHtmlCodeForAvaColor_Row($sizes, $assortments, $tipolo,
    $ava, $index, $order_row, $dateOffset, $showInfo, $modal, $canGoToCart, $discount,
    $addAddToCartButton, $showNotes) {
    $html = "<div class='insert-quantity-block'>";

    $html .= $this->getHeaderAvaColorBlock($ava, $index, $order_row, $dateOffset, $showInfo, $sizes, $modal);

    $html .= $this->getInfoHeaderRow($showNotes, $order_row);

    $html .= $this->getHeaderTable(true, $modal);
    $html .= $this->getAvaColorContent($sizes, $assortments, $tipolo, $ava, $index, $order_row, $modal, $discount);

    if ($addAddToCartButton) {
      $html .= $this->getFooterBlock($modal, $canGoToCart);
    }

    $html .= '</div>';

    return $html;
  }

  public function getHtmlCodeForResColor_Row($sizes, $assortments, $tipolo,
    $order_row, $index, $dateType, $periods, $showInfo, $modal, $canGoToCart, $discount,
    $addAddToCartButton, $showNotes) {
    $html = "<div class='insert-quantity-block'" . ($index > 1 && !isset($order_row) ? " style='display:none'" : '') . '>';

    $html .= $this->getHeaderResColorBlock($index, $order_row, $dateType, $periods, $showInfo, $sizes, $modal);

    $html .= $this->getInfoHeaderRow($showNotes, $order_row);

    $html .= $this->getHeaderTable(false, $modal);
    $html .= $this->getResColorContent($sizes, $assortments, $tipolo, $index, $order_row, $modal, $discount);

    if ($addAddToCartButton) {
      $html .= $this->getFooterBlock($modal, $canGoToCart);
      $html .= $this->getAddRemoveButtons($index);
    }

    $html .= '</div>';

    return $html;
  }

  public function getHeaderAvaTissueBlock($ava, $index, $order_row, $variant, $dateOffset, $showInfo, $sizes, $modal) {
    // Open row
    $html = "<div id='row-" . $index . "' class='row header-insert-block' ";
    $html .= "data-nurorc='" . (isset($order_row) ? $order_row->nurorc : '-1') . "' ";
    $html .= "data-cdvari='" . ($variant != "" ? $variant["cdvari"] : '') . "' ";
    $html .= "data-dtmcli='" . date("Y-m-d", strtotime(str_replace("/","-",$ava["dtdisp"]) . " +" . $dateOffset . " days")) . "' ";
    $html .= "data-indorc='" . ($showInfo['showIndicative'] && isset($order_row) ? htmlentities($order_row->indorc) : '') . "' ";
    $html .= "data-dsnoco='" . ($showInfo['showNotes'] && isset($order_row) ? htmlentities($order_row->dsnoco) : '') . "' ";
    $html .= "data-sgrifc='" . ($showInfo['showReference'] && isset($order_row) ? htmlentities($order_row->sgrifc) : '') . "'>";

    // Index
    $html .= "<div class='col-1'>" . $index . ".</div>";

    // Delivery Date
    $text1 = Utility::getTranslatorFor()->_('cart.deliverydate') . ": ";
    $text2 = date("d/m/Y", strtotime(str_replace("/","-",$ava["dtdisp"]) . " +" . $dateOffset . " days"));

    $html .= "<div class='truncate " . ($modal ? "col-11 col-md-7" : "col-6 col-md-5") . "'
      title='" . date("d/m/Y", strtotime(str_replace("/","-",$ava["dtdisp"]) . " +" . $dateOffset . " days")) . "'>";
    $html .= $modal ? "<div class='float-left'>" . $text1 . "</div>" : "<span>" . $text1 . "</span>";
    $html .= $modal ? "<div class='float-left ml-5x' style='color:black'>" . $text2 . "</div>" : "<span style='color:black'>" . $text2 . "</span>";
    $html .= "</div>";

    // Variant
    if ($variant != "") {
      $html .= "<div class='truncate " . ($modal ? "col-12 col-md-5" : "col-3 col-md-4") . "' title='" . htmlentities($variant['dsvari'], ENT_COMPAT, 'UTF-8') . "'>";
      $html .= "<span>" . Utility::getTranslatorFor()->_('_common.variant') . ": </span>";
      $html .= "<span style='color:black'>" . htmlentities($variant['dsvari'], ENT_COMPAT, 'UTF-8') . "</span>";
      $html .= "</div>";
    } else {
      $html .= "<div class='" . ($modal ? "col-12 col-md-5" : "col-3 col-md-4") . "'>";
      $html .= Utility::getTranslatorFor()->_('_common.variant.no');
      $html .= "</div>";
    }

    // Info - you can see it if you can select date (tppers != PT and reservation order) or indicative or rif or note
    if (!$modal) {
      if ($showInfo['showIndicative'] || $showInfo['showNotes'] || $showInfo['showReference']) {
        $html .= "<div class='col-2 info-order-row' data-toggle='modal' data-target='.modal-info-row'>";
        $html .= Utility::getTranslatorFor()->_('_common.info');
        $html .= "</div>";
      }
    } else {
      $html .= $this->getInfoHeaderRow($showInfo['showNotes'], $order_row);
    }

    // Close row
    $html .= "</div>";

    // Public price, if needed
    if ($this->utility->getAppSettings('ParamPriceSellPublicVisible')) {
      $html .= $this->addPublicPrice($sizes);
    }

    return $html;
  }

  public function getHeaderResTissueBlock($index, $order_row, $variant, $dtmcli, $showInfo, $sizes, $modal) {
    $showHeaderVariants = ($this->utility->getAppSettings('ModelDetailStyle') != 1 && $this->utility->getAppSettings('ModelDetailStyle') != 9);
    // Open row
    $html = "<div id='row-" . $index . "' class='row header-insert-block' ";
    $html .= "data-nurorc='" . (isset($order_row) ? $order_row->nurorc : '-1') . "' ";
    $html .= "data-cdvari='" . ($variant != "" ? $variant["cdvari"] : '') . "' ";
    $html .= "data-dtmcli='" . $dtmcli . "' ";
    $html .= "data-indorc='" . ($showInfo['showIndicative'] && isset($order_row) ? htmlentities($order_row->indorc) : '') . "' ";
    $html .= "data-dsnoco='" . ($showInfo['showNotes'] && isset($order_row) ? htmlentities($order_row->dsnoco) : '') . "' ";
    $html .= "data-sgrifc='" . ($showInfo['showReference'] && isset($order_row) ? htmlentities($order_row->sgrifc) : '') . "'>";

    if ($showHeaderVariants) {
      // Index
      $html .= "<div class='col-1'>" . $index . ".</div>";

      // Variant
      if ($variant != "") {
        $html .= "<div class='truncate " . ($modal ? "col-11" : "col-7") . "' title='" . htmlentities($variant['dsvari'], ENT_COMPAT, 'UTF-8') . "'>";
        $html .= "<span>" . Utility::getTranslatorFor()->_('_common.variant') . ": " . "</span>";
        $html .= "<span style='color:black'>" . htmlentities($variant['dsvari'], ENT_COMPAT, 'UTF-8') . "</span>";
        $html .= "</div>";
      } else {
        $html .= "<div class='" . ($modal ? "col-11" : "col-7") . "'>" . Utility::getTranslatorFor()->_('_common.variant.no') . "</div>";
      }
    } else {
      $html .= "<div class='" . ($modal ? "col-12" : "col-8") . "'>&nbsp;</div>";
    }

    // Info - you can see it if you can select date (tppers != PT and reservation order) or indicative or rif or note
    if (!$modal) {
      if ($showInfo['showIndicative'] || $showInfo['showNotes'] || $showInfo['showReference']) {
        $html .= "<div class='col-4 info-order-row' data-toggle='modal' data-target='.modal-info-row'>";
        $html .= Utility::getTranslatorFor()->_('_common.info');
        $html .= "</div>";
      }
    } else {
      $html .= $this->getInfoHeaderRow($showInfo['showNotes'], $order_row);
    }

    // Close row
    $html .= "</div>";

    // Public price, if needed
    if ($this->utility->getAppSettings('ParamPriceSellPublicVisible')) {
      $html .= $this->addPublicPrice($sizes);
    }

    return $html;
  }

  public function getHeaderAvaColorBlock($ava, $index, $order_row, $dateOffset, $showInfo, $sizes, $modal) {
    // Open row
    $html = "<div id='row-" . $index . "' class='row header-insert-block " . ($modal ? 'mb-0' : '') . "' ";
    $html .= "data-nurorc='" . (isset($order_row) ? $order_row->nurorc : '-1') . "' ";
    $html .= "data-cdvari='' ";
    $html .= "data-dtmcli='" . date("Y-m-d", strtotime(str_replace("/","-",$ava["dtdisp"]) . " +" . $dateOffset . " days")). "' ";
    $html .= "data-indorc='" . ($showInfo['showIndicative'] && isset($order_row) ? htmlentities($order_row->indorc) : '') . "' ";
    $html .= "data-dsnoco='" . ($showInfo['showNotes'] && isset($order_row) ? htmlentities($order_row->dsnoco) : '') . "' ";
    $html .= "data-sgrifc='" . ($showInfo['showReference'] && isset($order_row) ? htmlentities($order_row->sgrifc) : '') . "'>";

    // Index
    $html .= "<div class='col-1'>" . $index . ".</div>";

    // Delivery Date
    $text1 = $this->translate('cart.deliverydate') . ": ";
    $text2 = date("d/m/Y", strtotime(str_replace("/","-",$ava["dtdisp"]) . " +" . $dateOffset . " days"));

    $html .= "<div class='truncate " . ($modal ? "col-11" : "col-7") . "' ";
    $html .= "title='" . date("d/m/Y", strtotime(str_replace("/","-",$ava["dtdisp"]) . " +" . $dateOffset . " days")) . "'>";
    $html .= $modal ? "<div class='float-left'>" . $text1 . "</div>" : "<span>" . $text1 . "</span>";
    $html .= $modal ? "<div class='float-left ml-5x' style='color:black'>" . $text2 . "</div>" : "<span style='color:black'>" . $text2 . "</span>";
    $html .= "</div>";

    // Info - you can see it if you can select date (tppers != PT and reservation order) or indicative or rif or note
    if (!$modal) {
      if ($showInfo['showIndicative'] || $showInfo['showNotes'] || $showInfo['showReference']) {
        $html .= "<div class='col-4 info-order-row' data-toggle='modal' data-target='.modal-info-row'>";
        $html .= $this->translate('_common.info');
        $html .= "</div>";
      }
    } else {
      $html .= $this->getInfoHeaderRow($showInfo['showNotes'], $order_row);
    }

    // Close row
    $html .= "</div>";

    // Public price, if needed
    if ($this->utility->getAppSettings('ParamPriceSellPublicVisible')) {
      $html .= $this->addPublicPrice($sizes);
    }

    return $html;
  }

  public function getHeaderResColorBlock($index, $order_row, $dateType, $periods, $showInfo, $sizes, $modal) {
    // Open row
    $html = "<div id='row-" . $index . "' class='row header-insert-block' ";
    $html .= "data-nurorc='" . (isset($order_row) ? $order_row->nurorc : '-1') . "' ";
    $html .= "data-cdvari='' ";
    $html .= "data-dtmcli='" . ($showInfo['showDelivery'] && isset($order_row) ? date("Y-m-d", strtotime(str_replace("/","-",$order_row->dtmcli))) : '') . "' ";
    $html .= "data-indorc='" . ($showInfo['showIndicative'] && isset($order_row) ? htmlentities($order_row->indorc) : '') . "' ";
    $html .= "data-dsnoco='" . ($showInfo['showNotes'] && isset($order_row) ? htmlentities($order_row->dsnoco) : '') . "' ";
    $html .= "data-sgrifc='" . ($showInfo['showReference'] && isset($order_row) ? htmlentities($order_row->sgrifc) : '') . "'>";

    if ($showInfo['showDelivery']) {
      // Index
      $html .= "<div class='col-1'>" . $index . ".</div>";

      // Delivery Date
      $html .= "<div class='truncate " . ($modal ? "col-2" : "col-7") . "' ";
      $html .= $modal ? "style='text-align:right'>" : "><div class='float-left'>";
      $html .= Utility::getTranslatorFor()->_('cart.deliverydate') . ": ";
      $html .= "</div>";
      if ($modal) {
        $html .= "<div class='col-8'>";
      }
      if ($dateType > 1) {
        $html .= "<div class='float-left ml-5x' style='color:black'>";
        $html .= "<input type='text' data-index='" . $index . "' class='dtmcli' ";
        $html .= " value='" . (isset($order_row) && $order_row->dtmcli != '0000-00-00' ? $order_row->dtmcli : '') . "'>";
        $html .= "</div>";
      } else {
        $html .= "<div style='color:black'>";
        $html .= "<select class='form-control dtmcli mb-0' data-index='" . $index . "'>";
        $html .= "<option value='0000-00-00'></option>";
        foreach ($periods as $scacon) {
          $html .= "<option value='" . $scacon->dtmcli . "'";
          if (isset($order_row) && $order_row->dtmcli == $scacon->dtmcli) {
            $html .= " selected";
          }
          $html .= ">" . htmlentities($scacon->dsscad) . "</option>";
        }
        $html .= "</select>";
        $html .= "</div>";
      }

      $html .= "</div>";
    }

    // Info - you can see it if you can select date (tppers != PT and reservation order) or indicative or rif or note
    if (!$modal) {
      if ($showInfo['showIndicative'] || $showInfo['showNotes'] || $showInfo['showReference']) {
        $html .= "<div class='col-" . ($showInfo['showDelivery'] ? '4' : '12 text-left') . " info-order-row' data-toggle='modal' data-target='.modal-info-row'>";
        $html .= $this->translate('_common.info');
        $html .= "</div>";
      }
    } else {
      $html .= $this->getInfoHeaderRow($showInfo['showNotes'], $order_row);
    }

    // Close row
    $html .= "</div>";

    // Public price, if needed
    if ($this->utility->getAppSettings('ParamPriceSellPublicVisible')) {
      $html .= $this->addPublicPrice($sizes);
    }

    return $html;
  }

  public function getAvaColorContent($sizes, $assortments, $tipolo, $ava, $index, $order_row, $modal, $discount, $fromCompactModel = false) {
    $html = '';
    for ($i = 0; $i < count($sizes); $i++) {
      $quanti = 0;
      if (isset($order_row) && $order_row->detail[$sizes[$i]->taglia]) {
        $quanti = $order_row->detail[$sizes[$i]->taglia];
      }

      if ($fromCompactModel) {
        $html .= '<div class="col-12 px-40x">';
      }

      $blocked = (($i + 1) < $tipolo->tglini && $tipolo->tglini != 0) || (($i + 1) > $tipolo->tglfin && $tipolo->tglfin != 0);
      $html .= $this->getInsertQuantityRow($sizes[$i],
        isset($ava['alldsp']['size'][$sizes[$i]->taglia]) && $ava['alldsp']['size'][$sizes[$i]->taglia] > 0 ? $ava['alldsp']['size'][$sizes[$i]->taglia] : 0, "",
        $index . '_' . $i, $quanti, $modal, $discount, true, $blocked);
      if ($fromCompactModel) {
        $html .= '</div>';
      }
    }

    $showAssortements = $this->utility->getAppSettings('showAssortments');

    if ($showAssortements == '1'){

     for ($i = 0; $i < count($assortments); $i++) {
      $quanti = 0;
      if (isset($order_row) && $order_row->assortments[$assortments[$i]->cdasso]) {
        $quanti = $order_row->assortments[$assortments[$i]->cdasso];
      }

      if ($fromCompactModel) {
        $html .= '<div class="col-12 px-40x">';
      }
      $html .= $this->getInsertQuantityRow($assortments[$i],
        isset($ava['alldsp']['asso'][$assortments[$i]->cdasso]) ? $ava['alldsp']['asso'][$assortments[$i]->cdasso] : 0, "",
        $index . '_' . $i, $quanti, $modal, $discount, false);
      if ($fromCompactModel) {
        $html .= '</div>';
      }
    }

  }

    return $html;
  }

  public function getResColorContent($sizes, $assortments, $tipolo, $index, $order_row, $modal, $discount, $fromCompactModel = false) {
    $html = '';

    for ($i = 0; $i < count($sizes); $i++) {
      $quanti = 0;
      if (isset($order_row) && $order_row->detail[$sizes[$i]->taglia]) {
        $quanti = $order_row->detail[$sizes[$i]->taglia];
      }

      if ($fromCompactModel) {
        $html .= '<div class="col-12 px-40x">';
      }

      $blocked = (($i + 1) < $tipolo->tglini && $tipolo->tglini != 0) || (($i + 1) > $tipolo->tglfin && $tipolo->tglfin != 0);
      $html .= $this->getInsertQuantityRow($sizes[$i], -1, '', $index . '_' . $i, $quanti, $modal, $discount, true, $blocked);
      if ($fromCompactModel) {
        $html .= '</div>';
      }
    }
    $showAssortements = $this->utility->getAppSettings('showAssortments');

    if ($showAssortements == '1'){
      for ($i = 0; $i < count($assortments); $i++) {
        $quanti = 0;
        if (isset($order_row) && $order_row->assortments[$assortments[$i]->cdasso]) {
          $quanti = $order_row->assortments[$assortments[$i]->cdasso];
        }

        if ($fromCompactModel) {
          $html .= '<div class="col-12 px-40x">';
        }
        $html .= $this->getInsertQuantityRow($assortments[$i], -1, '', $index . '_' . $i, $quanti, $modal, $discount, false);
        if ($fromCompactModel) {
          $html .= '</div>';
        }
      } 
    }

    return $html;
  }

  public function getInfoHeaderRow($showNotes, $order_row) {
    $html = '';

    if ($showNotes) {
      $html .= "<div class='col-12 mt-10x'>" . Utility::getTranslatorFor()->_('_common.notes') . "</div>";
      $html .= "<div class='col-12 form-element mb-0'>";
      $html .= "<textarea rows='2' class='form-control dsnoco-info'>";
      if (isset($order_row)) {
        $html .= htmlentities($order_row->dsnoco);
      }
      $html .= "</textarea>";
      $html .= "<div class='col-12 mt-10x'>" . Utility::getTranslatorFor()->_('_common.gallery.info') . "</div>";
      $html .= "</div>";
    }

    return $html;
  }

  public function getHeaderTable($isAvailability, $modal) {
    $hideAvailability = $this->utility->getAppSettings('HideAvailabilityOnAvailabilityOrder') == 1;

    // Open row
    $class = $modal ? 'mx-0' : '';
    $html = "<div class='row header-insert-table $class'>";

    // Size
    $html .= "<div class='col'>" . Utility::getTranslatorFor()->_('_common.sizes.qty') . "</div>";

    // Availability, if needed
    if ($isAvailability && !$hideAvailability) {
      $html .= "<div class='col'>" . Utility::getTranslatorFor()->_('_common.availability.short') . "</div>";
    }

    // Price
    if ($this->utility->getAppSettings('ModelDetailStyle') != 3) {
      $html .= "<div class='col'>" . Utility::getTranslatorFor()->_('_common.price') . "</div>";
    }

    // Quantity
    $html .= "<div class='col-4'>" . Utility::getTranslatorFor()->_('_common.quantity') . "</div>";

    // Close row
    $html .= "</div>";

    return $html;
  }

  public function getInsertQuantityRow($size_info, $availability, $variant, $index, $quanti, $modal, $discount, $is_size = true, $blocked = false) {
    // Open Row
    $class = '';
    $title = '';
    $inp_cls = '';
    $isAvailability = $availability >= 0;
    if ($is_size && $size_info->flprom == 1) {
      $class = " row-flprom";
      $title = " title='" . Utility::getTranslatorFor()->_('quantity.promo') . "'";
    }
    if ($isAvailability && $quanti > $availability) {
      $inp_cls .= $class . " over-max";
    }

    // Get price
    $withDiscount = false;
    if ($is_size) {
      $size_info->sconto = 0;
      $locale = ( isset($_COOKIE['locale']) ) ? $_COOKIE['locale'] : $_SERVER['HTTP_ACCEPT_LANGUAGE'];
      setlocale(LC_ALL, $locale);
      if ($variant != '' && is_numeric($size_info->prezzo)) {
        $size_info->prezzo = $size_info->prezzo + $variant['preagg'];
      }

      if (is_numeric($size_info->prezzo)) {
        $currency = $this->utility->getCurrencySymbol($size_info->cdvalu);

        if ($size_info->prezzo == 0) {
          $price = '-';
        } else {
          $cust_disc = $discount != null && isset($discount['sconto']) && $discount['sconto'] > 0 ? $discount['sconto'] : 0;
          $disc_price = $size_info->prezzo * (1 - $cust_disc / 100);
          $withDiscount = $disc_price != $size_info->prezzo;
          $real_price = $this->utility->getFormattedPriceCurrencyPresent($size_info->prezzo, $currency, $size_info->cdvalu)['value'];
          $price = $this->utility->getFormattedPriceCurrencyPresent($disc_price, $currency, $size_info->cdvalu)['value'];
          $size_info->sconto = $cust_disc;
        }
      } else {
        $price = $size_info->prezzo;
      }
    }

    $html = "<div class='row insert-quantity-row ";

    if ($is_size) {
      $html .= "is-size' ";
      $html .= "data-qtamin='" . $size_info->qtamin . "' ";
      $html .= "data-qtamul='" . $size_info->qtamul . "' ";
      $html .= "data-qtamax='" . (isset($size_info->qtamax) && $size_info->qtamax > 0 ? $size_info->qtamax : 0) . "' ";
      $html .= "data-flbloc='" . $size_info->flbloc . "' ";
      $html .= "data-flprom='" . $size_info->flprom . "' ";
      $html .= "data-taglia='" . $size_info->taglia . "' ";
      $html .= "data-prezzo='" . $size_info->prezzo . "' ";
      $html .= "data-sconto='" . $size_info->sconto . "' ";
    } else {
      $html .= "is-asso' ";
      $html .= "data-qtamin='1' ";
      $html .= "data-qtamul='1' ";
      $html .= "data-qtamax='0' ";
      $html .= "data-flbloc='0' ";
      $html .= "data-flprom='0' ";
      $html .= "data-cdasso='" . $size_info->cdasso . "' ";
      $html .= "data-qtasso='" . $size_info->quanti . "' ";
      $html .= "data-prezzo='0' ";
      $html .= "data-sconto='0' ";
    }

    $html .= "data-disp='" . ($isAvailability ? $availability : "-1") . "' ";
    $html .= $modal ? "style='margin-left:0;margin-right:0'" : "";
    $html .= ">";

    // Size
    $html .= "<div class='col" . $class . "'" . $title . ">" . ($is_size ? $size_info->taglia : $size_info->cdasso);

    $html .= "<!-- Eseguita Query completamente inutile :( -->";
    if ($is_size && $this->utility->getAppSettings('ShowMinMulOnModelDetail') == 1) {
      $html .= '<span style="font-size:10px;padding-left:10px">(Min: ' . $size_info->qtamin . ', Mul: ' . $size_info->qtamul;
      if (isset($size_info->qtamax) && $size_info->qtamax > 0) {
        $html .= ', ' . $this->translate('_common.qty.max.short') . ': ' .  $size_info->qtamax;
      }
      $html .= ')</span>';
    }

    if (!$is_size) {
      $tooltip = "";
      foreach ($size_info->detail as $key => $value) {
        if ($value > 0) {
          $tooltip .= " " . $value . " x " . $key . " /";
        }
      }
      $tooltip = substr($tooltip, 0, -1);
      $html .= " <i class='fa fa-info-circle' aria-hidden='true' ";
      $html .= "data-toggle='tooltip' data-placement='top' title='" . $tooltip . "'></i>";
    }

    $html .= "</div>";

    // Availability
    $hideAvailability = $this->utility->getAppSettings('HideAvailabilityOnAvailabilityOrder') == 1;
    if ($isAvailability && !$hideAvailability) {
      $html .= "<div class='col'>" . ($availability > 0 ? $availability : "&nbsp;") . "</div>";
    }

    // Price
    if ($this->utility->getAppSettings('ModelDetailStyle') != 3) {
      if ($is_size) {
        $html .= "<div class='col'>" . ($withDiscount
          ? "<div class='price-model-box-discounted'><span class='discounted'>" . $real_price . "</span> " . $price . "</div>"
          : "<div class='price-model-box'>" . $price . "</div>") .
          "</div>";
      } else {
        $html .= "<div class='col'>&nbsp;</div>";
      }
    }

    // Quantity
    $html .= "<div class='col-4'>";

    if ($isAvailability && $availability == 0) {
      $html .= "<span class='blocked'>" . Utility::getTranslatorFor()->_('_common.notavailable') . "</span>";
    } else if ($is_size && ($size_info->flbloc > 0 || $blocked)) {
      $html .= "<span class='blocked'>" . Utility::getTranslatorFor()->_('quantity.blocked') . "</span>";
    } else {
      if ($quanti > 0) {
        $minus_cls = 'enabled';
      } else {
        $minus_cls = 'disabled';
      }

      if (!$isAvailability ||
        ($quanti < $availability &&
          (!$is_size || ($size_info->qtamin <= $availability && $quanti + $size_info->qtamul <= $availability))
        )
      ) {
        $plus_cls = 'enabled';
      } else {
        $plus_cls = 'disabled';
      }

      $html .= "<div class='btn-number minus-qty $minus_cls ' data-type='minus'>";
      $html .= "<i class='fa fa-minus' aria-hidden='true'></i>";
      $html .= "</div>";
      $html .= "<div class='float-left w-40'>";
      $html .= "<input type='text' class='input-number $inp_cls ' ";
      if ($minus_cls == 'disabled' && $plus_cls == 'disabled') {
        $html .= 'disabled ';
      }
      $html .= "data-old_value='" . ($quanti > 0 ? $quanti : "") . "' ";
      $html .= "value='" . ($quanti > 0 ? $quanti : '') . "' min='0' ". ($isAvailability ? "max='" . $availability . "'" : '') . ">";
      $html .= "</div>";
      $html .= "<div class='btn-number plus-qty $plus_cls ' data-type='plus'>";
      $html .= "<i class='fa fa-plus' aria-hidden='true'></i>";
      $html .= "</div>";

      if ($this->utility->getAppSettings('EnableMinMulLabel') > 0) {
        $html .= "<div class='regqta-info'>";
        $html .= $this->translate('_common.qty.min.short') . ': ' .  $size_info['qtamin'] . ', ';
        $html .= $this->translate('_common.qty.mul.short') . ': ' .  $size_info['qtamul'];
        if (isset($size_info['qtamax']) && $size_info['qtamax'] > 0) {
          $html .= ', ' . $this->translate('_common.qty.max.short') . ': ' .  $size_info['qtamax'];
        }
        $html .= "</div>";
      }
    }

    $html .= "</div>";

    // Close row
    $html .= "</div>";

    return $html;
  }

  public function getFooterBlock($modal, $canGoToCart) {
    $html =
    "<div class='row footer-insert-block " . ($modal ? 'mx-0' : '') . "'>
      <div class='col-12 p-0'><a class='btn btn-main add-to-cart w-100'>" . Utility::getTranslatorFor()->_('_common.addtocart')  . "</a></div>
    </div>
    <div class='row success-box' style='display:none'>
      <div class='col-12'>";
    if ($canGoToCart) {
      $param = "<a href='" . $this->url->get("cart/index") . "' style='color:#606060'>" . Utility::getTranslatorFor()->_('_common.cart') . "</a>";
      $html .= "<span>" . Utility::getTranslatorFor()->_('quantity.insert.success', ["cart" => $param]) . "</span>";
    } else {
      $html .= "<span>" . Utility::getTranslatorFor()->_('quantity.insert.success.nocart') . "</span>";
    }
    $html .=
      "</div>
    </div>";

    $html .=
    "<div class='row unsuccess-box' style='display:none'>
      <div class='col-12'><span>" . Utility::getTranslatorFor()->_('quantity.insert.unsuccess') . "</span></div>
    </div>";

    return $html;
  }

  public function addPublicPrice($sizes) {
    $html = '';
    $isPublicPricePresent = false;
    $isPublicPricePerSize = false;
    $currPublicPrice = count($sizes) > 0 ? $sizes[0]->preven : 0;
    $tooltip = '';
    $currency = $this->utility->getCurrencySymbol($sizes[0]->cdvalu);
    foreach ($sizes as $size) {
      $preven = $this->utility->getFormattedPriceCurrencyPresent($size->preven, $currency, $sizes[0]->cdvalu)['value'];
      $tooltip .= '<li>' . $size->taglia . ': ' . $preven . '</li>';
      if ($size->preven > 0 || $size->preven != $currPublicPrice) {
        $isPublicPricePresent = true;
      }
    }

    if ($isPublicPricePresent) {
      $html .= "<div class='row pt-10x'><div class='col-6 public-price' ";

      if (!$isPublicPricePerSize) {
        $html .= ">";
        $html .= Utility::getTranslatorFor()->_('_common.price.public') . ': ';
        $html .= $this->utility->getFormattedPriceCurrencyPresent($currPublicPrice, $currency, $sizes[0]->cdvalu)['value'];
      } else {
        $html .= 'data-toggle="tooltip" data-placement="left" data-html="true" title="<ul>' . $tooltip . '</ul>">';
        $html .= Utility::getTranslatorFor()->_('_common.price.public') . ': ';
        $html .= Utility::getTranslatorFor()->_('quantity.priceforsize.short');
      }

      $html .= "</div></div>";
    }

    return $html;
  }

  public function getAddRemoveButtons($index) {
    $html = '';

    $html .= "<div class='row'>";

    if ($index < 3) {
      $html .= "<div class='col btn-add-delete' id='btn-add-" . $index . "'>";
      $html .= Utility::getTranslatorFor()->_('quantity.adddeliverydate');
      $html .= "</div>";
    } else {
      $html .= "<div class='col'>&nbsp;</div>";
    }

    if ($index > 1) {
      $html .= "<div class='col btn-add-delete text-right' id='btn-delete-" . $index . "'>";
      $html .= Utility::getTranslatorFor()->_('quantity.deletedeliverydate');
      $html .= "</div>";
    } else {
      $html .= "<div class='col'>&nbsp;</div>";
    }

    $html .= "</div>";

    return $html;
  }
  //endregion
}

?>
