<?php

namespace Go2B\Forms;

use Phalcon\Forms\Form;
use Phalcon\Forms\Element\Text;
use Phalcon\Forms\Element\Password;
use Phalcon\Validation\Validator\PresenceOf;
use Phalcon\Validation\Validator\Email;

class RegisterForm extends Form
{
  public function initialize($entity = null, $options = null) {
    // Username
    $name = new Text('username');
    $name->setLabel('Username');
    $name->setFilters(array('alpha'));
    $name->addValidators(array(
      new PresenceOf(array(
        'message' => 'Please enter your desired user name'
      ))
    ));
    $this->add($name);

    // Password
    $password = new Password('password');
    $password->setLabel('Password');
    $password->addValidators(array(
      new PresenceOf(array(
        'message' => 'Password is required'
      ))
    ));
    $this->add($password);

    // Confirm Password
    $repeatPassword = new Password('repeatPassword');
    $repeatPassword->setLabel('Repeat Password');
    $repeatPassword->addValidators(array(
      new PresenceOf(array(
       'message' => 'Confirmation password is required'
      ))
    ));
    $this->add($repeatPassword);
  }
}
