<?php

namespace Go2B\Forms;

use Phalcon\Forms\Form;
use Phalcon\Forms\Element\Text;
use Phalcon\Validation\Validator\PresenceOf;
use Phalcon\Validation\Validator\Regex;

class CatalogForm extends Form
{
  /**
  * Initialize the catalog form
  */
  public function initialize($entity = null, $options = array())
  {

    $cdstag = new Text("input-code");
    $cdstag->setFilters(array('striptags', 'string'));
    $cdstag->addValidators(array(
      new PresenceOf(array(
        'message' => 'Il codice stagione è obbligatorio'
      ))
    ));
    $this->add($cdstag);

    $dsstag = new Text("input-description");
    $dsstag->setFilters(array('striptags', 'string'));
    $dsstag->addValidators(array(
      new PresenceOf(array(
        'message' => 'La descrizione della stagione è obbligatoria'
      ))
    ));
    $this->add($dsstag);

    $seqrap = new Text("input-seqrap");
    $seqrap->setFilters(array('striptags', 'string'));
    $seqrap->addValidators(array(
      new PresenceOf(array(
        'message' => 'La sequenza di rappresentazione è obbligatoria'
      )),
      new Regex(array(
        'pattern' => '/^0*[0-9]\d*$/',
        'message' => 'La sequenza di rappresentazione deve essere un numero intero positivo'
      ))
    ));
    $this->add($seqrap);
  }
}
