<?php

namespace Go2B\Controllers\Api;

use Go2B\Models\ApiAppusr;
use \Firebase\JWT\JWT;
use \Firebase\JWT\ExpiredException;

class DbController extends RestController {
  public function getCatalogsAction() {
    $this->logger->info('getCatalogsAction');
    $this->view->disable();

    if ($this->request->isAjax()) {
      // Phalcon bug: don't get Authorization header
      //$headers = $this->request->getHeaders();
      $headers = getallheaders();

      if (!isset($headers["Authorization"]) || empty($headers["Authorization"])) {
        $this->response->setStatusCode(403, "Forbidden");
        $this->response->send();
        die();
      }

      $token = explode(" ", $headers["Authorization"]);
      $token = trim($token[1], '"');

      try {
        JWT::$leeway = 60; // 60 seconds
        $user = JWT::decode($token, $this->config->api->secret, array('HS256'));
      } catch (\Firebase\JWT\ExpiredException $e) {
        $this->response->setStatusCode(405, $e->getMessage());
        $this->response->send();
        die();
      }

      $username = $user->username;
      $password = $user->password;

      $user = ApiAppusr::findFirstByUsername($user->username);

      $this->logger->info(print_r('user',true));
      $this->logger->info(print_r($user,true));

      /*
      //si no existe
      if ($logged == false) {
        //no es un token correcto
        //devolvemos un 401, Unauthorized
        $this->response->setStatusCode(401, "Unauthorized");
        $this->response->send();
        die();
      }

      //obtenemos los registros
      $contactos = Contactos::find(
        array(
          "conditions"=> "id_usuario = :id:",
          "bind"      => array("id" => $user->id_usuario),
          "order"     => "nombre ASC",
          "limit"     => 10
        )
      );

      //comprobamos si hay filas
      if ($contactos->count() > 0) {
        $data = array();

        foreach ($contactos as $contacto) {
          $data[] = array(
            "id_contacto"   => $contacto->id_contacto,
            "nombre"        => $contacto->nombre,
            "numero"        => $contacto->numero,
            "email"         => $contacto->email,
            "status"        => $contacto->status,
            "fecha_crea"    => $contacto->fecha_crea,
            "fecha_mod"     => $contacto->fecha_mod
          );
        }

        $user = array(
          "id_usuario"=> $user->id_usuario,
          "username"  => $user->username,
          "password"  => $user->password
        );

        $getConfig = $this->getConfigToken();

        //devolvemos los registros y el token
        $this->response->setJsonContent(array(
          "res"       => "success",
          "code"      => 0,
          "contactos" => $data,
          "token"     => JWT::encode($getConfig + $user, $this->getConfigApp()->key)
        ));

        //devolvemos un 200, todo ha ido bien
        $this->response->setStatusCode(200, "OK");
      } else {
        $this->response->setStatusCode(204, "No Content");
      }
*/
      $this->response->send();
    } else {
      $this->response->setStatusCode(405, "Method Not Allowed");
      $this->response->send();
    }
  }
}
