<?php

namespace Go2B\Controllers;

use Go2B\Library\Environment;
use Go2B\Library\Translator;
use Go2B\Models\Anaage;
use Go2B\Models\Anaart;
use Go2B\Models\Anagra;
use Go2B\Models\Ananaz;
use Go2B\Models\Anavet;
use Go2B\Models\Anazon;
use Go2B\Models\B2bAddinf;
use Go2B\Models\B2bAppset;
use Go2B\Models\B2bApputi;
use Go2B\Models\B2bBgtest;
use Go2B\Models\B2bClassificazione;
use Go2B\Models\B2bCoupon;
use Go2B\Models\B2bCsmenu;
use Go2B\Models\B2bDishea;
use Go2B\Models\B2bFlvisi;
use Go2B\Models\B2bGltest;
use Go2B\Models\B2bMngpar;
use Go2B\Models\B2bMsgque;
use Go2B\Models\B2bOrdadd;
use Go2B\Models\B2bSysusr;
use Go2B\Models\B2bTipord;
use Go2B\Models\B2bTkcorp;
use Go2B\Models\B2bTktest;
use Go2B\Models\B2bUsrage;
use Go2B\Models\B2bUsrana;
use Go2B\Models\B2bUsrdsm;
use Go2B\Models\Ctetic;
use Go2B\Models\Cttest;
use Go2B\Models\Desmer;
use Go2B\Models\Dscorp;
use Go2B\Models\Gopart;
use Go2B\Models\Indorc;
use Go2B\Models\Linmod;
use Go2B\Models\Lktest;
use Go2B\Models\Lstest;
use Go2B\Models\Noccom;
use Go2B\Models\Ocasso;
use Go2B\Models\Occorp;
use Go2B\Models\Ocperc;
use Go2B\Models\Ocpert;
use Go2B\Models\Ocproc;
use Go2B\Models\Ocprot;
use Go2B\Models\Octagl;
use Go2B\Models\Octest;
use Go2B\Models\Pvcorp;
use Go2B\Models\Pvgrup;
use Go2B\Models\Pvtest;
use Go2B\Models\Regqta;
use Go2B\Models\Scacon;
use Go2B\Models\Sermod;
use Go2B\Models\Sparti;
use Go2B\Models\Spmate;
use Go2B\Models\Tipolo;
use Go2B\Models\Titlin;
use Go2B\Models\Tpgene;
use Go2B\Models\Tpmode;
use Go2B\Library\DiskManager;
use Go2B\Plugins\Nav\ApiKOC;
use PHPMailer\PHPMailer\PHPMailer;
use Phalcon\Di;
use Phalcon\Translate\Adapter\NativeArray;
use Phalcon\Mvc\Model\Transaction\Failed as TxFailed;
use Phalcon\Mvc\Model\Transaction\Manager as TxManager;
use Phalcon\Logger\Formatter\Line as LineFormatter;

class Utility
{
    private $appSettings;
    private $appUtils;
    private $mngParams;

    private static $translators = [];

    private static $is_order;
    private static $order_info;

    public static function loadTranslatorFor($language)
    {
        //OLD
        //// Load translations
        //$translationPath = '../app/messages/' . $language;
        //require $translationPath . '/main.php';
        ///** @global $messages */
        //$mainTranslate = new NativeArray(array(
        //    'content' => $messages
        //));

        // Return a translation object
        return new NativeArray(array(
            'content' => (new Translator())->getTranslatedStrings($language)
        ));
    }

    public static function getTranslatorFor($language = null)
    {

        if (empty($language)) {
            $language = Di::getDefault()->get('session')->get('language');
        }
        $language = strtolower($language);

        if (!array_key_exists($language, self::$translators)) {
            self::$translators[$language] = self::loadTranslatorFor($language);
        }

        return self::$translators[$language];
    }

    public static function getOrderInfo($id_usr = null)
    {

        if (is_null(self::$is_order)) {
            self::$is_order = Octest::findOrderInProgress($id_usr) != null;
        }
        if (self::$is_order && is_null(self::$order_info)) {
            self::$order_info = Octest::getCurrentOrder($id_usr);
        }
        return self::$order_info;
    }

    //region Debug
    public function getCurrentTime()
    {
        $t = microtime(true);
        $micro = sprintf("%06d", ($t - floor($t)) * 1000000);
        $d = new \DateTime(date('Y-m-d H:i:s.' . $micro, $t));
        return $d->format("Y-m-d H:i:s.u");
    }

    public function getDbError($result)
    {
        $messages = $result->getMessages();
        $error = '';
        foreach ($messages as $message) {
            $error .= $message . "\n";
        }

        Di::getDefault()->get('logger')->error(print_r($error, true));
    }
    //endregion

    //region Settings/Utils
    public function reloadParameters()
    {
        $this->appSettings = B2bAppset::getCurrentAppSettings();
        $this->appUtils = B2bApputi::getCurrentAppUtils();
        $this->mngParams = B2bMngpar::getCurrentManagementParams();
    }

    function mb_unserialize($string)
    {
        $string2 = preg_replace_callback(
            '!s:(\d+):"(.*?)";!s',
            function ($m) {
                $len = strlen($m[2]);
                $result = "s:$len:\"{$m[2]}\";";
                return $result;
            },
            $string
        );
        return unserialize($string2);
    }

    public function getAppSettings($settingName)
    {
        return Environment::getCustomParam($settingName);
        //        $setting = B2bAppset::findFirst(array('name = ?1', 'bind' => array(1 => $settingName), 'order' => 'tab DESC'));
        //
        //        if ($setting != null) {
        //            try {
        //                $setting->descr = $fixed_data = preg_replace_callback('!s:(\d+):"(.*?)";!', function ($match) {
        //                    return ($match[1] == strlen($match[2])) ? $match[0] : 's:' . strlen($match[2]) . ':"' . $match[2] . '";';
        //                }, $setting->descr);
        //                $setting->options = $fixed_data = preg_replace_callback('!s:(\d+):"(.*?)";!', function ($match) {
        //                    return ($match[1] == strlen($match[2])) ? $match[0] : 's:' . strlen($match[2]) . ':"' . $match[2] . '";';
        //                }, $setting->options);
        //                $setting->tab = $fixed_data = preg_replace_callback('!s:(\d+):"(.*?)";!', function ($match) {
        //                    return ($match[1] == strlen($match[2])) ? $match[0] : 's:' . strlen($match[2]) . ':"' . $match[2] . '";';
        //                }, $setting->tab);
        //                return $setting;
        //            } catch (\Exception $e) {
        //                Di::getDefault()->get('logger')->error($e->getMessage);
        //                Di::getDefault()->get('logger')->error(print_r($setting, true));
        //            }
        //        } else {
        //            return $this->insertSettingByName($settingName);
        //        }
    }

    public function insertSettingByName($settingName)
    {
        $this->reloadParameters();

        foreach ($this->appSettings as $key => $value) {
            if ($value['name'] == $settingName) {
                return $this->insertSetting($value);
            }
        }
    }

    public function insertSetting($newSetting)
    {
        $setting = new B2bAppset();
        $setting->name = $newSetting['name'];
        $setting->descr = $newSetting['descr'];
        $setting->privileges = $newSetting['privileges'];
        $setting->value = $newSetting['value'];
        $setting->options = $newSetting['options'];
        $setting->tab = $newSetting['tab'];

//        if ($newSetting['name'] == "ExportOrderType") {
//            var_dump($setting);
//            exit;
//        }

        $setting->save();

        $setting->descr = unserialize($setting->descr);
        $setting->options = unserialize($setting->options);
        $setting->tab = unserialize($setting->tab);

        return $setting;
    }

    public function updateSettings()
    {
        $this->reloadParameters();

        foreach ($this->appSettings as $key => $value) {
            $setting = B2bAppset::findFirst(array('name = :name:', 'bind' => array('name' => $value['name'])));
            if ($setting != null) {
                $setting->descr = $value['descr'];
                $setting->options = $value['options'];
                $setting->tab = $value['tab'];
                $setting->save();
            }
        }
    }

    public function getAppSettingsList()
    {
        $this->reloadParameters();

        foreach ($this->appSettings as $key => $value) {
            if (B2bAppset::findFirst(array('name = :name:', 'bind' => array('name' => $value['name']))) == null) {
                $this->insertSetting($value);
            }
        }

        $settingsList = B2bAppset::find(array('order' => 'tab DESC, name ASC'));

        $unserializedSettingsList = array();
        foreach ($settingsList as $key => $value) {
            $value->descr = unserialize($value->descr);
            $value->options = unserialize($value->options);
            $value->tab = unserialize($value->tab);

            $unserializedSettingsList[] = $value;
        }
        return $unserializedSettingsList;
    }

    public function getAppUtils($utilName)
    {
        return Environment::getSystemParam($utilName);
        //        try {
        //            $util = B2bApputi::findFirst(array('param = ?1', 'bind' => array(1 => $utilName)));
        //
        //            if ($util != null) {
        //                return $util;
        //            } else {
        //                return $this->insertUtilByName($utilName);
        //            }
        //        } catch (\Exception $ex) {
        //            // Update table name if doesn't exist
        //            $sql = 'RENAME TABLE `app_utils` TO `b2b_apputi`';
        //            Di::getDefault()->get('db')->prepare($sql)->execute();
        //            $this->getAppUtils($utilName);
        //        }
    }

    public function setAppUtils($utilName, $utilValue)
    {
        $util = B2bApputi::findFirst(array('param = ?1', 'bind' => array(1 => $utilName)));

        if ($util == null) {
            $this->reloadParameters();
            $this->insertUtil($utilName);
            $util = B2bApputi::findFirst(array('param = ?1', 'bind' => array(1 => $utilName)));
        }

        $util->value = $utilValue;
        $util->save();
    }

    public function insertUtilByName($utilName)
    {
        $this->reloadParameters();

        foreach ($this->appUtils as $key => $value) {
            if ($value['param'] == $utilName) {
                return $this->insertUtil($value);
            }
        }
    }

    public function insertUtil($newUtil)
    {
        $util = new B2bApputi();
        $util->param = $newUtil['param'];
        $util->value = $newUtil['value'];
        $util->save();

        return $util;
    }

    public function getAppUtilsList()
    {
        $this->reloadParameters();

        foreach ($this->appUtils as $key => $value) {
            if (B2bApputi::findFirst(array('param = :param:', 'bind' => array('param' => $value['param']))) == null) {
                $this->insertUtil($value);
            }
        }

        return B2bApputi::find();
    }

    public function getHumanDate($mysqlDate = null)
    {
        $format = 'd/m/Y';
        $date = '';

        if (!empty($mysqlDate)) {
            $date = date_create_from_format('!Y-m-d', $mysqlDate);

            if ($date == false) {
                $date = date_create_from_format('!Y-m-d H:i:s', $mysqlDate);
            }
            if ($date == false) {
                $date = date($format, strtotime($mysqlDate));
                return $date;
            }
            return date_format($date, $format);
        }
        return date($format);
    }

    public function getHumanDateTime($mysqlDateTime = null)
    {
        $format = 'd/m/Y H:i';
        $date = '';

        if (!empty($mysqlDateTime)) {
            $date = date_create_from_format('!Y-m-d H:i:s', $mysqlDateTime);

            if ($date == false) {
                $date = date_create_from_format('!Y-m-d', $mysqlDateTime);
            }

            if ($date == false) {
                $date = date($format, strtotime($mysqlDateTime . "+ 1 hour"));
                // caso peggiore, ritorno la data con possibilità di errore
                return $date;
            }
            $date->setTimezone(new \DateTimeZone('Europe/Rome'));
            return date_format($date, $format);
        }
        return date($format); // return NOW
    }

    public function getManagementParam($param)
    {
        try {
            $mngParam = B2bMngpar::findFirst(array('param = ?1', 'bind' => array(1 => $param)));
            return $mngParam != null ? $mngParam : $this->insertManagementParamByName($param);
        } catch (\Exception $ex) {
        }
    }

    public function setManagementParam($param, $value)
    {
        $mngParam = B2bMngpar::findFirst(array('param = ?1', 'bind' => array(1 => $param)));

        if ($mngParam == null) {
            $this->reloadParameters();
            $this->insertUtil($param);
            $mngParam = B2bMngpar::findFirst(array('param = ?1', 'bind' => array(1 => $param)));
        }

        $mngParam->value = $value;
        $mngParam->save();
    }

    public function insertManagementParamByName($param)
    {
        $this->reloadParameters();

        foreach ($this->mngParams as $key => $value) {
            if ($value['param'] == $param) {
                return $this->insertManagementParam($value);
            }
        }
    }

    public function insertManagementParam($newParam)
    {
        $mngParam = new B2bMngpar();
        $mngParam->param = $newParam['param'];
        $mngParam->value = $newParam['value'];
        $mngParam->save();

        return $mngParam;
    }

    public function getManagementParamsList()
    {
        $this->reloadParameters();

        foreach ($this->mngParams as $key => $value) {
            if (B2bMngpar::findFirst(array('param = :param:', 'bind' => array('param' => $value['param']))) == null) {
                $this->insertManagementParam($value);
            }
        }

        return B2bMngpar::find();
    }

    public function updateDatabase()
    {
        $currentVersion = $this->getAppUtils('db_version');
        $di = Di::getDefault();

        if ($currentVersion < $di->get('config')->dbupdate->currentversion) {
            $dbConn = $di->get('db');
            $dbConn->begin();
            try {
                $vers = 'N.D.';
                for ($i = $currentVersion + 1; $i <= $di->get('config')->dbupdate->currentversion; $i++) {
                    $di->get('logger')->info("dbupdate step: $i");
                    $vers = 'vers' . $i;
                    $query = $di->get('config')->dbupdate->$vers;
                    $dbConn->execute($query);
                }
                $this->setAppUtils('db_version', $di->get('config')->dbupdate->currentversion);
                $dbConn->commit();
                $di->get('logger')->info("DATABASE AGGIORNATO ALLA VERSIONE: $vers");
            } catch (\Exception $th) {
                $di->get('logger')->error("IMPOSSIBILE AGGIORNARE IL DATABASE ALLA VERSIONE SUCCESSIVA.\n\t{$th->getMessage()}");
                $di->get('logger')->error($th->getTraceAsString());
                $dbConn->rollback();
            }
        }
    }
    //endregion

    //region Admin functions
    public function getPerc($x, $y)
    {
        if ($y > 0) {
            return round((100 * $x) / $y, 2);
        }
        return -1;
    }

    public function manualSync($tipoSync= null)
    {
        set_time_limit(0);
        $di = Di::getDefault();
        $diskManager = new DiskManager();
        $diskManager->manualSync($di->get('config')->release->user , $tipoSync);

        /*
    $param = $this->getAppSettings('SyncType');

    switch ($param) {
      case 0:
        Sync\StandardSync::sync(false);
        break;
      case 1:
        Sync\CsvLardini::sync(false);
        break;
      case 2:
        Sync\CsvZanotti::sync(false);
        break;
    }
    */

        set_time_limit(30);
    }
    //endregion

    //region Cart functions
    // Used by Utility, CartController, CatalogController and ModelController
    public function getDefaultNulist($id)
    {
        $user = B2bSysusr::findFirstById($id);

        switch ($user->type) {
            case 3:
                $nulist = Anaage::getAgentPriceListCodeFromUser($id);
                break;
            case 4:
                $nulist = Anagra::getCustomerPriceListCodeFromUser($id);
                break;
            case 5:
                $nulist = Desmer::getShippingPriceListCodeFromUser($id);
                break;
        }

        $res = !empty($nulist) ? $nulist : Lstest::findFirst()->nulist;
        return $res;
    }

    public function getDefaultNulistFromCustomer($tpanag, $cdanag)
    {
        $nulist = Anagra::getCustomerPriceListCodeFromCustomer($tpanag, $cdanag);
        $res = isset($nulist) && $nulist != '0' ? $nulist : Lstest::findFirst()->nulist;
        return $res;
    }

    public function calculateRowDiscountsSummary($nuordc, $numdis)
    {
        $new_total = 0;
        $octagl = Octagl::getSizeQuantityWithDiscount($nuordc, $numdis);

        for ($i = 0; $i < count($octagl); $i++) {
            $curr_octagl = Octagl::findFirst(array(
                'nurorc = :nurorc: AND dstagl = :dstagl:',
                'bind' => array('nurorc' => $octagl[$i]->nurorc, 'dstagl' => $octagl[$i]->dstagl)
            ));
            $curr_octagl->scont1 = $octagl[$i]->cust_sconto;
            $new_total += $curr_octagl->quanti * $curr_octagl->prezzo * (1 - $curr_octagl->scont1 / 100);
            $curr_octagl->save();
        }

        return $new_total;
    }

    public function getLinesSummary($articles, $octest = null)
    {
        $linesSummary = array();

        foreach ($articles as $article) {
            $article = (array)$article;
            $codice = $article['cdlinm'] . '#' . $article['cdserm'];
            if (!isset($linesSummary[$codice])) {
                $linesSummary[$codice] = array(
                    'descri' => $article['dslinm'] . ' - ' . $article['dsserm'],
                    'numrow' => 0,
                    'quanti' => 0,
                    'implor' => 0,
                    'impnet' => 0,
                );
            }

            $linesSummary[$codice]['numrow']++;

            foreach ($article['octagl'] as $octagl) {
                $discount = 1;
                if ($octest != null && $octest['flnosc'] == 0) {
                    $discount = (1 - ($octagl['scont1'] / 100)) * (1 - ($octagl['scont2'] / 100)) * (1 - ($octagl['scont3'] / 100)) *
                        ($octest != null && $octagl['scont1'] == 0 && $octagl['scont2'] == 0 && $octagl['scont3'] == 0
                            ? (1 - ($octest['anagra_scont1'] / 100)) * (1 - ($octest['anagra_scont2'] / 100)) * (1 - ($octest['anagra_scont3'] / 100))
                            : 1);
                }

                $linesSummary[$codice]['quanti'] += $octagl['quanti'];
                $linesSummary[$codice]['implor'] += $octagl['quanti'] * $octagl['prezzo'];
                $linesSummary[$codice]['impnet'] += $octagl['quanti'] * $octagl['prezzo'] * $discount;
            }
        }

        return $linesSummary;
    }

    public function getModelTypesSummary($articles)
    {
        $modelTypeSummary = array();

        foreach ($articles as $article) {
            $article = (array)$article;
            $codice = $article['tpmode'];
            if (!isset($modelTypeSummary[$codice])) {
                $modelTypeSummary[$codice] = array(
                    'descri' => $article['tpmode'] . ' - ' . $article['dstmod'],
                    'numrow' => 0,
                    'quanti' => 0,
                    'implor' => 0,
                    'impnet' => 0,
                );
            }

            $modelTypeSummary[$codice]['numrow']++;

            foreach ($article['octagl'] as $octagl) {
                $modelTypeSummary[$codice]['quanti'] += $octagl['quanti'];
                $modelTypeSummary[$codice]['implor'] += $octagl['quanti'] * $octagl['prezzo'];
                $modelTypeSummary[$codice]['impnet'] += $octagl['quanti'] * $octagl['prezzo'] * (1 - ($octagl['scont1'] / 100)) * (1 - ($octagl['scont2'] / 100)) * (1 - ($octagl['scont3'] / 100));
            }
        }

        return $modelTypeSummary;
    }

    /**
     * Funzione standard contenente la procedura corretta di invio di un ordine
     *
     * N.B.
     * In questa funzione non aggiorniamo più, ne controlliamo in alcun modo i porti e i pagamenti (custom o no)
     *
     * @param $octest
     * @param $flstat
     * @param $additionalData
     * @return string
     */
    public function sendOrder($octest, $flstat, $additionalData = null, $forceFromAdmin = false)
    {
        if ($octest instanceof Octest) {
            $di = Di::getDefault();
            /** @var \Phalcon\Db\Adapter $db */
            $db = $di->get('db');
            $logger = $di->get('logger');

            //            // TODO studiare un modo per fare queste queste operazioni in una transaction
            //            try {
            ////
            //                $db->begin();
            //                $octest->notazi = 'prova';
            //
            //
            //                // Create a transaction manager
            //                $manager = new TxManager();
            //
            //                // Request a transaction
            //                $transaction = $manager->get();
            //                $octest->setTransaction($transaction);
            //
            //                if ($octest->save() === false) {
            //                    $db->rollback(
            //                        'Cannot save robot part'
            //                    );
            //                }
            //
            //                var_dump($db->isUnderTransaction());
            //
            //                $db->query('UPDATE octest SET nuordn = \'TEST\' WHERE nuordc = 134')->execute();
            //
            //                $db->rollback(
            //                    'test roolback'
            //                );
            //
            //
            ////
            ////                $transaction->rollback(
            ////                    'test roolback'
            ////                );
            //
            //                // Everything's gone fine, let's commit the transaction
            ////                $transaction->commit();
            //                $db->commit();
            //                var_dump($db->isUnderTransaction());
            //            } catch (TxFailed $e) {
            //                echo 'Failed, reason: ', $e->getMessage();
            //            }
            //
            //            exit();

            if (!is_null($additionalData)) {
                //                $noteCliente = preg_replace('/^###\n(.*\n)*###\n\n/i','', $octest->notcli);
                $i18n = Di::getDefault()->get('i18n');

                // Ricaviamo le note cliente eliminando le intestazioni
                $openingTagPosition = strpos($octest->notcli, "###");
                $closingTagPosition = $openingTagPosition !== false ? strpos($octest->notcli, "###", $openingTagPosition + 3) : false;
                if ($closingTagPosition) {
                    $noteCliente = '';
                    if ($openingTagPosition > 0) {
                        $noteCliente .= trim(substr($octest->notcli, 0, $openingTagPosition)) . ' ';
                    }
                    $noteCliente .= trim(substr($octest->notcli, $closingTagPosition + 3));
                    $noteCliente = trim($noteCliente);
                } else {
                    $noteCliente = (!empty($octest->notcli) ? $octest->notcli : '');
                }

                $noteAutomatiche = '';
                $noteAddizionali = [];
                // Aggiorniamo i dati aggiuntivi dell'ordine
                B2bOrdadd::find(['conditions' => 'nuordc = :nuordc:', 'bind' => ['nuordc' => $octest->nuordc]])->delete();
                foreach ($additionalData as $campo => $valore) {
                    if (!empty($valore)) {
                        $b2bOrdadd = new B2bOrdadd();
                        $b2bOrdadd->nuordc = $octest->nuordc;
                        $b2bOrdadd->addfld = $campo;
                        $b2bOrdadd->addval = $valore;
                        if (!$b2bOrdadd->save()) {
                            $errorMsg = "B2bOrdadd ERROR: \n";
                            foreach ($b2bOrdadd->getMessages() as $message) {
                                $errorMsg = "\t$message\n";
                            }

                            $logger->error($errorMsg);
                        }
                        // Aggiungiamo questa riga alle intestazioni
                        $valoreFormattato = $this->getFormattedPrice($octest->nulist, $valore);
                        switch ($campo) {
                            case B2bOrdadd::SPESA_AGGIUNTIVA_PAGAMENTO:
                                $noteAddizionali[] = $i18n->_('export.order.noteadd.payment', $valoreFormattato);
                                break;
                            case B2bOrdadd::SPESA_AGGIUNTIVA_SPEDIZIONE:
                                $noteAddizionali[] = $i18n->_('export.order.noteadd.shipment', $valoreFormattato);
                                break;
                            case B2bOrdadd::SPESA_AGGIUNTIVA_CONTRASSEGNO:
                                $noteAddizionali[] = $i18n->_('export.order.noteadd.cachet', $valoreFormattato);
                                break;
                        }
                    }
                }

                if (!empty($noteAddizionali)) {
                    $noteAutomatiche = "###\n" . implode("\n", $noteAddizionali) . "\n###\n\n";
                }
                $octest->notcli = $noteAutomatiche . $noteCliente;
            }

            // Aggiorniamo il vettore
            $anagra = Anagra::findCustomerByKey($octest->tpanag, $octest->cdanag);
            $destinazioni = Desmer::getShippingsForCustomer($octest->tpanag, $octest->cdanag);

            $cdvettPapabili = [$anagra->cdvett];
            $vettoreDefault = $anagra->cdvett;
            /** @var Desmer $destinazione */
            foreach ($destinazioni as $destinazione) {
                $cdvettPapabili[] = $destinazione->cdvett;
                if (!empty($octest->cddesm) && $destinazione->cddesm == $octest->cddesm) {
                    $vettoreDefault = $destinazione->cdvett;
                }
            }
            if (empty($octest->cdvett) || !in_array($octest->cdvett, $cdvettPapabili)) {
                $octest->cdvett = $vettoreDefault;
            }

            // Settiamo la data di invio
            $octest->dtinvi = date('Y-m-d');

            // Settiamo la data di consegna prevista
            if ($octest->tpordc == 0 && $this->getAppSettings('ParamDateManagementAvailability') == 4) {
                $dateOffset = $this->getAppSettings('ParamAvailabilityDateManagement');
                $dateOffset = !empty($dateOffset) && $dateOffset != 0 ? $dateOffset : 7;
                $octest->dtmcli = date('Y-m-d', strtotime('+' . $dateOffset . ' day'));
            }

            if (!$forceFromAdmin && $this->getAppSettings('ModelDetailStyle') >= 2) {
                if ($flstat == 1 || $flstat == 2) {
                    if (Occorp::isWaitingForQuantity($octest->nuordc)) {
                        $octest->flstat = 5;
                    } else {
                        if ($flstat == 1) {
                            $octest->flstat = 1;
                        } else {
                            if ($this->getAppSettings('OrderStateManagement') == 0) {
                                $octest->flstat = 2;
                            } else {
                                $octest->flstat = 6;
                            }
                        }
                    }
                }
            } else {
                $octest->flstat = $flstat;
            }

            if ($octest->flstat == 2 && $octest->flnosc == 0 && empty($octest->cdcoup)) {
                // Aggiorniamo gli sconti perché fino a questo punto non abbiamo veramente applicato lo sconto cliente,
                // ma lo mostravamo solo sull'interfaccia utente
                try {
                    $queryUpdateScontiParams = ['scont1' => $anagra->scont1, 'scont2' => $anagra->scont2, 'scont3' => $anagra->scont3, 'nuordc' => $octest->nuordc];
                    $queryUpdateSconti = 'UPDATE octagl SET 
                                scont1=IF(scont1 = 0, :scont1, scont1), 
                                scont2=IF(scont2 = 0, :scont2, scont2), 
                                scont3=IF(scont3 = 0, :scont3, scont3) 
                            WHERE nurorc IN (SELECT nurorc FROM occorp WHERE nuordc = :nuordc)';
                    $db->query($queryUpdateSconti, $queryUpdateScontiParams);
                } catch (\Exception $ex) {
                    $logger->error($ex->getTraceAsString());
                    return 'ER1';
                }
            }

            // Controlliamo limite minimo articoli o spesa minima
            if (
                $octest->flstat == 2 &&
                ($orderLimitMode = $this->getAppSettings('OrderLimit')) && !empty($orderLimitMode) &&
                ($orderLimitMinValue = $this->getAppSettings('OrderLimitMinValue')) && !empty($orderLimitMinValue)
            ) {
                if ($orderLimitMode == 1) {
                    $totArticoli = Octest::countArticlesInOrder($octest->nuordc);
                    if ($totArticoli < $orderLimitMinValue) {
                        return 'LE1';
                    }
                } else if ($orderLimitMode == 2) {
                    $totSpesa = Octest::retriveSpendInOrder($octest->nuordc);
                    if ($totSpesa < $orderLimitMinValue) {
                        return 'LE2';
                    }
                }
            }

            // Spostato il salvataggio prima dell'export, dato che poi in alcuni punti rifacciamo le query,
            // quindi se non aggiorniamo prima i dati poi ce li perdiamo.
            if ($octest->save() === false) {
                return 'OE';
            }

            if ($octest->flstat == 2) {
                // Questo oggetto su sto framework (demmerda) ha alcuni valori impostati a RawValue('""');
                // quindi il loro valore verra interpretato da php come una stringa di 2 caratteri contenente i doppi apici ( string(2) """" )
                // non saprei se risolviamo al 100% cmq, per evitare questo genere di errori, provo a fare il refresh dal db
                // $this->utility->exportOrder($octest);
                $this->exportOrder($octest->refresh());
            }

            return 'OK';
        }

        return 'ER';
    }
    //endregion

    //region Sales models functions
    public function getSalesModels($cdcata, $order_info, $shownotavailable)
    {
        // $numdis = $this->getCustomDiscountSummary($order_info->tpanag, $order_info->cdanag, $order_info->nulist, $cdcata);
        // NON capisco come mai passiamo il catalogo a parte rispetto all'ordine
        $numdis = $this->getCustomDiscount($order_info);

        $items = array(
            'cdcata' => $cdcata,
            'numdis' => $numdis,
            'isPT' => Tipolo::findFirstByTppers('PT') != null,
            'isAvailabilityOrder' => $order_info->tpordc == 0,
            'showNotAvailable' => $shownotavailable == 1
        );

        return Tipolo::getSalesModels($items);
    }
    //endregion

    //region Promo functions
    public function getPromos($nuordc, $tpanag, $cdanag)
    {
        $promos = Pvtest::getPromosFromOrderAndCustomer($nuordc, $tpanag, $cdanag);

        $full_promos = array();
        for ($i = 0; $i < count($promos); $i++) {
            $curr_promo = $promos[$i];
            $curr_promo['cndsod'] = $this->checkPromoFullfilled($curr_promo['cdprom'], $curr_promo['tputil'], $nuordc);
            $full_promos[] = $curr_promo;
        }

        return $full_promos;
    }

    public function verifyPromos($nuordc)
    {
        $ocprot = Ocprot::findByNuordc($nuordc);
        for ($i = 0; $i < count($ocprot); $i++) {
            $this->applyPromo($ocprot[$i]);
        }
    }

    public function checkPromoFullfilled($cdprom, $tputil, $nuordc)
    {
        switch ($tputil) {
            case 'CA':
                return $this->checkCAPromoFullfilled($cdprom, $nuordc);
            case 'DN':
                return $this->checkDNPromoFullfilled($cdprom, $nuordc);
            case 'OC':
                return $this->checkOCPromoFullfilled($cdprom, $nuordc);
            case 'OT':
            case 'SL':
                // not implemented
                return false;
        }
    }

    public function applyPromo($ocprot)
    {
        // Reset current promo
        Ocproc::deleteArticlesPromo($ocprot->cdprom, $ocprot->nuordc);

        $pvtest = Pvtest::findFirstByCdprom($ocprot->cdprom);
        $articles = [];
        switch ($pvtest->tputil) {
            case 'CA':
                $fullfilled = $this->checkCAPromoStepsFullfilled($ocprot->cdprom, $ocprot->nuordc, $articles);
                if ($fullfilled) {
                    $this->saveCAPromoArticles($articles, $ocprot, $pvtest->tipapp);
                    return true;
                }
                break;
            case 'DN':
                $fullfilled = $this->checkDNPromoStepsFullfilled($ocprot->cdprom, $ocprot->nuordc, $articles);
                if ($fullfilled) {
                    $this->saveDNPromoArticles($articles, $ocprot, $pvtest->tipapp);
                    return true;
                }
                break;
            case 'OC':
                $step = array();
                $fullfilled = $this->checkOCPromoStepsFullfilled($ocprot->cdprom, $ocprot->nuordc, $articles, $step);
                if ($fullfilled) {
                    $this->saveOCPromoArticles($articles, $ocprot, $step, $pvtest->tipapp);
                    return true;
                }
                break;
            case 'OT':
            case 'SL':
                // not implemented
                break;
        }

        return false;
    }

    //region CA Promo
    public function saveCAPromoArticles($articles, $ocprot, $tipapp)
    {
        for ($i = 0; $i < count($articles); $i++) {
            if ($articles[$i]['quanti'] > 0) {
                $success = Ocproc::insertArticlePromo(
                    $ocprot->nuordc,
                    $ocprot->cdprom,
                    $articles[$i]['cdarti'],
                    $articles[$i]['prezzo'],
                    $articles[$i]['scont1'],
                    $articles[$i]['scont2'],
                    $articles[$i]['scont3'],
                    $tipapp
                );
                if ($success === false) {
                    return false;
                }
            }
        }
    }

    public function getCAPromoArticles($conditions, $nuordc)
    {
        $articles = [];

        $params = array('nuordc' => $nuordc);

        $phql = '';
        for ($i = 0; $i < count($conditions); $i++) {
            $condition = $conditions[$i];
            $params['prezzo' . $i] = $condition['prezzo'];
            $params['scont1' . $i] = $condition['scont1'];
            $params['scont2' . $i] = $condition['scont2'];
            $params['scont3' . $i] = $condition['scont3'];

            switch ($condition['tpinpu']) {
                case 'TL':
                    $params['code' . $i] = $condition['cdtitl'];
                    $join = 'INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn INNER JOIN linmod lm ON tp.cdlinm = lm.cdlinm INNER JOIN titlin tl ON lm.cdtitl = tl.cdtitl ';
                    $where = "WHERE tl.cdtitl = :code$i ";
                    break;
                case 'LI':
                    $params['code' . $i] = $condition['cdlinm'];
                    $join = 'INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn INNER JOIN linmod lm ON tp.cdlinm = lm.cdlinm ';
                    $where = "WHERE lm.cdlinm = :code$i ";
                    break;
                case 'SE':
                    $params['code' . $i] = $condition['cdserm'];
                    $dsinpu = 'sm.dsserm';
                    $where = "WHERE sm.cdserm = :cod$i ";
                    break;
                case 'TM':
                    $params['code' . $i] = $condition['tpmode'];
                    $join = 'INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn INNER JOIN tpmode tm ON tp.tpmode = tm.tpmode ';
                    $where = "WHERE tm.tpmode = :code$i ";
                    break;
                case 'AN':
                    $params['code' . $i] = $condition['cdartn'];
                    $join = 'INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn';
                    $where = "WHERE tp.cdartn = :code$i ";
                    break;
                case 'AR':
                    $params['code' . $i] = $condition['cdarti'];
                    $join = '';
                    $where = "WHERE aa.cdarti = :code$i ";
                    break;
                case 'TV':
                    $params['code' . $i] = $condition['tpvend'];
                    $join = 'INNER JOIN cratve cv ON cv.tpvend = aa.tpvend ';
                    $where = "WHERE cv.tpvend = :code$i ";
                    break;
                case 'MI':
                    $params['code' . $i] = $condition['cdmisu'];
                    $join = 'INNER JOIN cramis cm ON cm.cdmisu = aa.cdmisu ';
                    $where = "WHERE cm.cdmisu = :code$i ";
                    break;
                case 'CO':
                    $params['code' . $i] = $condition['cdcolo'];
                    $join = 'INNER JOIN cracol cc ON cc.cdcolo = aa.cdcolo ';
                    $where = "WHERE cc.cdcolo = :code$i ";
                    break;
                case 'XX':
                    $join = '';
                    $where = '';
                    break;
            }

            $phql .= "SELECT aa.cdarti AS cdarti, :prezzo$i AS prezzo,
        :scont1$i AS scont1, :scont2$i AS scont2, :scont3$i AS scont3,
        oc.quanti
        FROM anaart aa
        LEFT JOIN occorp oc ON oc.cdarti = aa.cdarti AND oc.nuordc = :nuordc
        $join
        $where
        UNION ";
        }

        // Remove last 'UNION' from the query and add group by and order by
        $phql = substr($phql, 0, -6) . " GROUP BY cdarti ORDER BY cdarti";
        $articles = Di::getDefault()->get('db')->query($phql, $params)->fetchAll();

        return $articles;
    }

    public function getCAPromoDetail($cdprom, $cdcata, $nuordc, $nulist, $tpordc)
    {
        $params = array('cdprom' => $cdprom, 'cdcata' => $cdcata, 'nuordc' => $nuordc, 'nulist' => $nulist);
        $is_available = '';
        $havingNotAvailable = '';

        // If availability order, add is_available field
        if ($tpordc == 0) {
            $is_available = ",
        MAX(
          COALESCE(
            (SELECT MAX(dc2.quanti -
              COALESCE(
                (SELECT SUM(og2.quanti)
                FROM octagl og2
                INNER JOIN occorp oc2 ON oc2.nurorc = og2.nurorc
                INNER JOIN octest ot2 ON ot2.nuordc = oc2.nuordc
                WHERE oc2.cdarti = dc2.cdarti AND ot2.flstat = 2 AND og2.dstagl = dc2.taglia), 0)
              ) AS quanti
            FROM dscorp dc2
            WHERE dc2.cdarti = pc.cdarti),
          0)
        ) AS availability ";

            // If parameter "show not available" is false, filter not available items
            if ($this->getAppSettings('ParamShowNotAvailableItems') == 0) {
                $havingNotAvailable = ' HAVING availability > 0 ';
            }
        }

        $phql = "SELECT pc.seqrap, pc.tpinpu, aa.cdartn, pc.cdarti,
      aa.dsarti, aa.flimag, aa.cdcolo,
      GROUP_CONCAT(pc.scont1 ORDER BY pc.seqsca ASC SEPARATOR ';') AS scont1,
      GROUP_CONCAT(pc.scont2 ORDER BY pc.seqsca ASC SEPARATOR ';') AS scont2,
      GROUP_CONCAT(pc.scont3 ORDER BY pc.seqsca ASC SEPARATOR ';') AS scont3,
      GROUP_CONCAT(pc.prezzo ORDER BY pc.seqsca ASC SEPARATOR ';') AS prezzo,
      GROUP_CONCAT(pc.quanti ORDER BY pc.seqsca ASC SEPARATOR ';') AS quanti,
      GROUP_CONCAT(pc.valore ORDER BY pc.seqsca ASC SEPARATOR ';') AS valore,
      COALESCE(IF(lc.taglia > '', -1, MAX(lc.prezzo)), 0) as catalogPrice,
      COALESCE(ord.nurorc, -1) AS nurorc, COALESCE(ord.quanti, 0) AS ord_quanti,
      COALESCE(ord.valore, 0) AS ord_valore,
      IF(aa.flbloc >= COALESCE(rq.flbloc, 0), aa.flbloc, rq.flbloc) AS aa_flbloc,
      tp.flbloc AS tp_flbloc,
      IF((SELECT COUNT(ct.seqrap) FROM ctarti ct WHERE ct.cdarti = aa.cdarti AND ct.cdcata = :cdcata) > 0,1,-1) AS ctlg_presence,
      COALESCE(rq.qtamin, 1) AS qtamin, COALESCE(rq.qtamul, 1) AS qtamul, COALESCE(rq.qtamax, 0) AS qtamax,
      COALESCE(rq.flprom, 0) AS flprom, pt.taglia
      $is_available
      FROM pvcorp pc
      INNER JOIN anaart aa ON pc.cdarti = aa.cdarti AND pc.tpinpu = 'AR'
      INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn
      INNER JOIN postgl pt ON tp.cdtagl = pt.cdtagl
      LEFT JOIN regqta rq ON rq.cdarti = aa.cdarti
      LEFT JOIN lscorp lc ON lc.nulist = :nulist AND lc.cdarti = aa.cdarti
      LEFT JOIN (
        SELECT aa.cdarti AS cdarti, oc.nurorc AS nurorc, COALESCE(SUM(ot.quanti), 0) AS quanti, COALESCE(SUM(ot.prezzo * ot.quanti), 0) AS valore
        FROM anaart aa
        LEFT JOIN occorp oc ON aa.cdarti = oc.cdarti AND oc.nuordc = :nuordc
        LEFT JOIN octagl ot ON oc.nurorc = ot.nurorc
        GROUP BY cdarti
      ) AS ord ON pc.cdarti = ord.cdarti
      WHERE pc.cdprom = :cdprom
      GROUP BY pc.cdarti
      $havingNotAvailable
      ORDER BY pc.seqrap ASC, pc.seqsca ASC";

        $articles = Di::getDefault()->get('db')->query($phql, $params)->fetchAll();
        return $articles;
    }

    public function checkCAPromoStepsFullfilled($cdprom, $nuordc, &$articles)
    {
        // Check all steps
        $pvcorp = Pvcorp::getAllPromoDetailsForPromo($cdprom);

        $details = [];
        for ($i = 0; $i < count($pvcorp); $i++) {
            $details[$pvcorp[$i]->seqsca][] = array(
                'seqrap' => $pvcorp[$i]->seqrap,
                'tpinpu' => $pvcorp[$i]->tpinpu,
                'cdtitl' => $pvcorp[$i]->cdtitl,
                'cdlinm' => $pvcorp[$i]->cdlinm,
                'cdserm' => $pvcorp[$i]->cdserm,
                'tpmode' => $pvcorp[$i]->tpmode,
                'cdartn' => $pvcorp[$i]->cdartn,
                'cdarti' => $pvcorp[$i]->cdarti,
                'seqsca' => $pvcorp[$i]->seqsca,
                'valore' => $pvcorp[$i]->valore,
                'quanti' => $pvcorp[$i]->quanti,
                'prezzo' => $pvcorp[$i]->prezzo,
                'scont1' => $pvcorp[$i]->scont1,
                'scont2' => $pvcorp[$i]->scont2,
                'scont3' => $pvcorp[$i]->scont3
            );
        }

        $fullfilled = true;
        $step = -1;
        foreach ($details as $key => $value) {
            if (!$fullfilled)
                break;

            for ($j = 0; $j < count($value) && $fullfilled; $j++) {
                $fullfilled = $this->checkCAPromoQueryFullfilled($value[$j], $nuordc);
            }

            if ($fullfilled) {
                $step = $key;
            }
        }

        if ($step > 0) {
            $articles = $this->getCAPromoArticles($details[$step], $nuordc);
            return true;
        }

        return false;
    }

    public function checkCAPromoQueryFullfilled($condition, $nuordc)
    {
        $params = array('minqty' => $condition['quanti'], 'minval' => $condition['valore'], 'nuordc' => $nuordc);
        $where = '';
        switch ($condition['tpinpu']) {
            case 'TL':
                $params['code'] = $condition['cdtitl'];
                $join = 'INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn INNER JOIN linmod lm ON tp.cdlinm = lm.cdlinm ';
                $where = 'WHERE lm.cdtitl = :code ';
                break;
            case 'LI':
                $params['code'] = $condition['cdlinm'];
                $join = 'INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn INNER JOIN linmod lm ON tp.cdlinm = lm.cdlinm ';
                $where = 'WHERE lm.cdlinm = :code ';
                break;
            case 'SE':
                $params['code1'] = $condition['cdlinm'];
                $params['code2'] = $condition['cdserm'];
                $join = 'INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn INNER JOIN sermod sm ON tp.cdlinm = sm.cdlinm AND tp.cdserm = sm.cdserm ';
                $where = 'WHERE sm.cdlinm = :code1 AND sm.cdserm = :code2 ';
                break;
            case 'TM':
                $params['code'] = $condition['tpmode'];
                $join = 'INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn INNER JOIN tpmode tm ON tp.tpmode = tm.tpmode ';
                $where = 'WHERE tm.tpmode = :code ';
                break;
            case 'AN':
                $params['code'] = $condition['cdartn'];
                $join = 'INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn ';
                $where = 'WHERE tp.cdartn = :code ';
                break;
            case 'AR':
                $params['code'] = $condition['cdarti'];
                $join = '';
                $where = 'WHERE aa.cdarti = :code ';
                break;
        }

        $phql = "SELECT SUM(COALESCE(ot.quanti, 0)) >= :minqty AND
      SUM(COALESCE(ot.prezzo * ot.quanti, 0)) >= :minval AS fullfill
      FROM anaart aa
      $join
      LEFT JOIN occorp oc ON aa.cdarti = oc.cdarti AND oc.nuordc = :nuordc
      LEFT JOIN octagl ot ON oc.nurorc = ot.nurorc ";
        $phql .= $condition['tpinpu'] != 'XX' ? $where : '';

        $result = Di::getDefault()->get('db')->query($phql, $params)->fetchAll();

        $fullfilled = $result[0]['fullfill'] > 0;

        return $fullfilled;
    }

    public function checkCAPromoFullfilled($cdprom, $nuordc)
    {
        // We need to check if promo conditions are satisfied at least for first step
        $details = Pvcorp::getPromoDetailsForFirstPromoStep($cdprom);

        $fullfilled = true;
        for ($i = 0; $i < count($details) && $fullfilled; $i++) {
            $fullfilled = $this->checkCAPromoQueryFullfilled($details[$i], $nuordc);
        }

        return $fullfilled;
    }
    //endregion

    //region DN Promo
    public function saveDNPromoArticles($articles, $ocprot, $tipapp)
    {
        for ($i = 0; $i < count($articles); $i++) {
            if ($articles[$i]['quanti'] > 0) {
                $ocproc = new Ocproc();
                $ocproc->nuordc = $ocprot->nuordc;
                $ocproc->cdprom = $ocprot->cdprom;
                $ocproc->cdarti = $articles[$i]['cdarti'];
                $ocproc->prezzo = $articles[$i]['prezzo'];
                $ocproc->scont1 = $articles[$i]['scont1'];
                $ocproc->scont2 = $articles[$i]['scont2'];
                $ocproc->scont3 = $articles[$i]['scont3'];
                $ocproc->tipapp = $tipapp;

                if ($ocproc->save() === false) {
                    return false;
                }
            }
        }
    }

    public function getDNPromoArticles($conditions, $nuordc)
    {
        $articles = [];

        $params = array('nuordc' => $nuordc);

        $phql = '';
        for ($i = 0; $i < count($conditions); $i++) {
            $condition = $conditions[$i];
            $params['prezzo' . $i] = $condition['prezzo'];
            $params['scont1' . $i] = $condition['scont1'];
            $params['scont2' . $i] = $condition['scont2'];
            $params['scont3' . $i] = $condition['scont3'];

            switch ($condition['tpinpu']) {
                case 'TL':
                    $params['code' . $i] = $condition['cdtitl'];
                    $join = 'INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn INNER JOIN linmod lm ON tp.cdlinm = lm.cdlinm INNER JOIN titlin tl ON lm.cdtitl = tl.cdtitl ';
                    $where = "WHERE tl.cdtitl = :code$i ";
                    break;
                case 'LI':
                    $params['code' . $i] = $condition['cdlinm'];
                    $join = 'INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn INNER JOIN linmod lm ON tp.cdlinm = lm.cdlinm ';
                    $where = "WHERE lm.cdlinm = :code$i ";
                    break;
                case 'SE':
                    $params['code' . $i] = $condition['cdserm'];
                    $dsinpu = 'sm.dsserm';
                    $where = "WHERE sm.cdserm = :cod$i ";
                    break;
                case 'TM':
                    $params['code' . $i] = $condition['tpmode'];
                    $join = 'INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn INNER JOIN tpmode tm ON tp.tpmode = tm.tpmode ';
                    $where = "WHERE tm.tpmode = :code$i ";
                    break;
                case 'AN':
                    $params['code' . $i] = $condition['cdartn'];
                    $join = 'INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn';
                    $where = "WHERE tp.cdartn = :code$i ";
                    break;
                case 'AR':
                    $params['code' . $i] = $condition['cdarti'];
                    $join = '';
                    $where = "WHERE aa.cdarti = :code$i ";
                    break;
                case 'TV':
                    $params['code' . $i] = $condition['tpvend'];
                    $join = 'INNER JOIN cratve cv ON cv.tpvend = aa.tpvend ';
                    $where = "WHERE cv.tpvend = :code$i ";
                    break;
                case 'MI':
                    $params['code' . $i] = $condition['cdmisu'];
                    $join = 'INNER JOIN cramis cm ON cm.cdmisu = aa.cdmisu ';
                    $where = "WHERE cm.cdmisu = :code$i ";
                    break;
                case 'CO':
                    $params['code' . $i] = $condition['cdcolo'];
                    $join = 'INNER JOIN cracol cc ON cc.cdcolo = aa.cdcolo ';
                    $where = "WHERE cc.cdcolo = :code$i ";
                    break;
                case 'XX':
                    $join = '';
                    $where = '';
                    break;
            }

            $phql .= "SELECT aa.cdarti AS cdarti, :prezzo$i AS prezzo,
        :scont1$i AS scont1, :scont2$i AS scont2, :scont3$i AS scont3,
        oc.quanti
        FROM anaart aa
        LEFT JOIN occorp oc ON oc.cdarti = aa.cdarti AND oc.nuordc = :nuordc
        $join
        $where
        UNION ";
        }

        // Remove last 'UNION' from the query and add group by and order by
        $phql = substr($phql, 0, -6) . " GROUP BY cdarti ORDER BY cdarti";
        $articles = Di::getDefault()->get('db')->query($phql, $params)->fetchAll();

        return $articles;
    }

    public function checkDNPromoStepsFullfilled($cdprom, $nuordc, &$articles)
    {
        // Check all steps
        $pvcorp = Pvcorp::getAllPromoDetailsForPromo($cdprom);

        $details = [];
        for ($i = 0; $i < count($pvcorp); $i++) {
            $details[$pvcorp[$i]->seqsca][] = array(
                'seqrap' => $pvcorp[$i]->seqrap,
                'tpinpu' => $pvcorp[$i]->tpinpu,
                'cdtitl' => $pvcorp[$i]->cdtitl,
                'cdlinm' => $pvcorp[$i]->cdlinm,
                'cdserm' => $pvcorp[$i]->cdserm,
                'tpmode' => $pvcorp[$i]->tpmode,
                'cdartn' => $pvcorp[$i]->cdartn,
                'cdarti' => $pvcorp[$i]->cdarti,
                'seqsca' => $pvcorp[$i]->seqsca,
                'valore' => $pvcorp[$i]->valore,
                'quanti' => $pvcorp[$i]->quanti,
                'prezzo' => $pvcorp[$i]->prezzo,
                'scont1' => $pvcorp[$i]->scont1,
                'scont2' => $pvcorp[$i]->scont2,
                'scont3' => $pvcorp[$i]->scont3
            );
        }

        $fullfilled = true;
        $step = -1;
        foreach ($details as $key => $value) {
            if (!$fullfilled)
                break;

            for ($j = 0; $j < count($value) && $fullfilled; $j++) {
                $fullfilled = $this->checkDNPromoQueryFullfilled($value[$j], $nuordc);
            }

            if ($fullfilled) {
                $step = $key;
            }
        }

        if ($step > 0) {
            $articles = $this->getDNPromoArticles($details[$step], $nuordc);
            return true;
        }

        return false;
    }

    public function checkDNPromoQueryFullfilled($condition, $nuordc)
    {
        $params = array('minqty' => $condition['quanti'], 'minval' => $condition['valore'], 'nuordc' => $nuordc);
        $where = '';
        switch ($condition['tpinpu']) {
            case 'TL':
                $params['code'] = $condition['cdtitl'];
                $join = 'INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn INNER JOIN linmod lm ON tp.cdlinm = lm.cdlinm ';
                $where = 'WHERE lm.cdtitl = :code ';
                break;
            case 'LI':
                $params['code'] = $condition['cdlinm'];
                $join = 'INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn INNER JOIN linmod lm ON tp.cdlinm = lm.cdlinm ';
                $where = 'WHERE lm.cdlinm = :code ';
                break;
            case 'SE':
                $params['code1'] = $condition['cdlinm'];
                $params['code2'] = $condition['cdserm'];
                $join = 'INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn INNER JOIN sermod sm ON tp.cdlinm = sm.cdlinm AND tp.cdserm = sm.cdserm ';
                $where = 'WHERE sm.cdlinm = :code1 AND sm.cdserm = :code2 ';
                break;
            case 'TM':
                $params['code'] = $condition['tpmode'];
                $join = 'INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn INNER JOIN tpmode tm ON tp.tpmode = tm.tpmode ';
                $where = 'WHERE tm.tpmode = :code ';
                break;
            case 'AN':
                $params['code'] = $condition['cdartn'];
                $join = 'INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn ';
                $where = 'WHERE tp.cdartn = :code ';
                break;
            case 'AR':
                $params['code'] = $condition['cdarti'];
                $join = '';
                $where = 'WHERE aa.cdarti = :code ';
                break;
        }

        $phql = "SELECT SUM(COALESCE(ot.quanti, 0)) >= :minqty AND
      SUM(COALESCE(ot.prezzo * ot.quanti, 0)) >= :minval AS fullfill
      FROM anaart aa
      $join
      LEFT JOIN occorp oc ON aa.cdarti = oc.cdarti AND oc.nuordc = :nuordc
      LEFT JOIN octagl ot ON oc.nurorc = ot.nurorc ";
        $phql .= $condition['tpinpu'] != 'XX' ? $where : '';

        $result = Di::getDefault()->get('db')->query($phql, $params)->fetchAll();

        $fullfilled = $result[0]['fullfill'] > 0;

        return $fullfilled;
    }

    public function checkDNPromoFullfilled($cdprom, $nuordc)
    {
        // We need to check if promo conditions are satisfied at least for first step
        $details = Pvcorp::getPromoDetailsForFirstPromoStep($cdprom);

        $fullfilled = true;
        for ($i = 0; $i < count($details) && $fullfilled; $i++) {
            $fullfilled = $this->checkDNPromoQueryFullfilled($details[$i], $nuordc);
        }

        return $fullfilled;
    }
    //endregion

    //region OC Promo
    public function saveOCPromoArticles($articles, $ocprot, $step, $tipapp)
    {
        for ($i = 0; $i < count($articles); $i++) {
            if ($articles[$i]['quanti'] > 0) {
                $ocproc = new Ocproc();
                $ocproc->nuordc = $ocprot->nuordc;
                $ocproc->cdprom = $ocprot->cdprom;
                $ocproc->cdarti = $articles[$i]['cdarti'];
                $ocproc->prezzo = $step['prezzo'];
                $ocproc->scont1 = $step['scont1'];
                $ocproc->scont2 = $step['scont2'];
                $ocproc->scont3 = $step['scont3'];
                $ocproc->tipapp = $tipapp;

                if ($ocproc->save() === false) {
                    return false;
                }
            }
        }
    }

    public function getOCPromoConditions($cdprom, &$minQty, &$minVal, &$steps)
    {
        $steps = Pvcorp::getPromoDetails($cdprom);
        $groups = Pvgrup::getPromoGroups($cdprom);

        if (count($details) > 0) {
            $minQty = $details[0]['quanti'];
            $minVal = $details[0]['valore'];

            foreach ($details as $detail) {
                if ($detail['quanti'] < $minQty || $detail['valore'] < $minVal) {
                    $minQty = $detail['quanti'];
                    $minVal = $detail['valore'];
                }
            }
        }

        $conditions = array();
        if (count($details) > 0) {
            $quanti = $details[0]['quanti'];
            $valore = $details[0]['valore'];

            if ($details[0]['tpinpu'] != 'GR') {
                switch ($details[0]['tpinpu']) {
                    case 'TL': // cdtitl
                        $conditions[] = array('tpinpu' => 'TL', 'quanti' => $quanti, 'valore' => $valore, 'cdtitl' => $details[0]['cdtitl']);
                        break;
                    case 'LI': // cdlinm
                        $conditions[] = array('tpinpu' => 'LI', 'quanti' => $quanti, 'valore' => $valore, 'cdlinm' => $details[0]['cdlinm']);
                        break;
                    case 'SE': // cdserm
                        $conditions[] = array('tpinpu' => 'SE', 'quanti' => $quanti, 'valore' => $valore, 'cdlinm' => $details[0]['cdlinm'], 'cdserm' => $details[0]['cdserm']);
                        break;
                    case 'TM': // tpmode
                        $conditions[] = array('tpinpu' => 'TM', 'quanti' => $quanti, 'valore' => $valore, 'tpmode' => $details[0]['tpmode']);
                        break;
                    case 'AN': // cdartn
                        $conditions[] = array('tpinpu' => 'AN', 'quanti' => $quanti, 'valore' => $valore, 'cdartn' => $details[0]['cdartn']);

                        if (isset($details[0]['tpvend']) && trim($details[0]['tpvend']) !== '') {
                            $conditions[] = array('tpinpu' => 'TV', 'quanti' => $quanti, 'valore' => $valore, 'tpvend' => $details[0]['tpvend']);
                        }
                        if (isset($details[0]['cdmisu']) && trim($details[0]['cdmisu']) !== '') {
                            $conditions[] = array('tpinpu' => 'MI', 'quanti' => $quanti, 'valore' => $valore, 'cdmisu' => $details[0]['cdmisu']);
                        }
                        if (isset($details[0]['cdcolo']) && trim($details[0]['cdcolo']) !== '') {
                            $conditions[] = array('tpinpu' => 'CO', 'quanti' => $quanti, 'valore' => $valore, 'cdcolo' => $details[0]['cdcolo']);
                        }
                        break;
                    case 'AR': // cdarti
                        $conditions[] = array('tpinpu' => 'AR', 'quanti' => $quanti, 'valore' => $valore, 'cdarti' => $details[0]['cdarti']);
                        break;
                    case 'XX': // all
                        $conditions[] = array('tpinpu' => 'XX', 'quanti' => $quanti, 'valore' => $valore);
                        break;
                }
            } else {
                if (count($groups) > 0) {
                    foreach ($groups as $group) {
                        switch ($group['tpinpu']) {
                            case 'TL': // cdtitl
                                $conditions[] = array('tpinpu' => 'TL', 'quanti' => $quanti, 'valore' => $valore, 'cdtitl' => $group['cdtitl']);
                                break;
                            case 'LI': // cdlinm
                                $conditions[] = array('tpinpu' => 'LI', 'quanti' => $quanti, 'valore' => $valore, 'cdlinm' => $group['cdlinm']);
                                break;
                            case 'SE': // cdserm
                                $conditions[] = array('tpinpu' => 'SE', 'quanti' => $quanti, 'valore' => $valore, 'cdlinm' => $group['cdlinm'], 'cdserm' => $group['cdserm']);
                                break;
                            case 'TM': // tpmode
                                $conditions[] = array('tpinpu' => 'TM', 'quanti' => $quanti, 'valore' => $valore, 'tpmode' => $group['tpmode']);
                                break;
                            case 'AN': // cdartn
                                $conditions[] = array('tpinpu' => 'AN', 'quanti' => $quanti, 'valore' => $valore, 'cdartn' => $group['cdartn']);

                                if (isset($group['tpvend']) && trim($group['tpvend']) !== '') {
                                    $conditions[] = array('tpinpu' => 'TV', 'quanti' => $quanti, 'valore' => $valore, 'tpvend' => $group['tpvend']);
                                }
                                if (isset($group['cdmisu']) && trim($group['cdmisu']) !== '') {
                                    $conditions[] = array('tpinpu' => 'MI', 'quanti' => $quanti, 'valore' => $valore, 'cdmisu' => $group['cdmisu']);
                                }
                                if (isset($group['cdcolo']) && trim($group['cdcolo']) !== '') {
                                    $conditions[] = array('tpinpu' => 'CO', 'quanti' => $quanti, 'valore' => $valore, 'cdcolo' => $group['cdcolo']);
                                }
                                break;
                            case 'AR': // cdarti
                                $conditions[] = array('tpinpu' => 'AR', 'quanti' => $quanti, 'valore' => $valore, 'cdarti' => $group['cdarti']);
                                break;
                        }
                    }
                }
            }
        }

        return $conditions;
    }

    public function getOCPromoArticles($condition, $nuordc)
    {
        $params = array('tpinpu' => $condition['tpinpu'], 'nuordc' => $nuordc);
        $where = '';
        $join = '';
        $dsinpu = '';
        switch ($condition['tpinpu']) {
            case 'TL': // cdtitl
                $params['code'] = $condition['cdtitl'];
                $dsinpu = 'tl.dstitl';
                $join = 'INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn INNER JOIN linmod lm ON tp.cdlinm = lm.cdlinm INNER JOIN titlin tl ON lm.cdtitl = tl.cdtitl ';
                $where = 'WHERE tl.cdtitl = :code';
                break;
            case 'LI': // cdlinm
                $idlang = $this->getLanguage();
                $params['code'] = $condition['cdlinm'];
                $dsinpu = 'lm.dslinm';
                $join = 'INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn INNER JOIN linmod lm ON tp.cdlinm = lm.cdlinm ';
                $where = 'WHERE lm.cdlinm = :code';
                if ($idlang != 'IT') {
                    $dsinpu = 'COALESCE(d1.descri,lm.dslinm)';
                    $params['idlang'] = $idlang;
                    $join .= "LEFT JOIN deslin d1 ON d1.tpdato = 'dslinm' AND d1.codic1 = lm.cdlinm AND d1.idlang = :idlang: ";
                }
                break;
            case 'SE': // cdserm
                $params['code1'] = $condition['cdlinm'];
                $params['code2'] = $condition['cdserm'];
                $dsinpu = 'sm.dsserm';
                $join = 'INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn INNER JOIN sermod sm ON tp.cdlinm = sm.cdlinm AND tp.cdserm = sm.cdserm ';
                $where = 'WHERE sm.cdlinm = :code1 AND sm.cdserm = :code2';
                break;
            case 'TM': // tpmode
                $params['code'] = $condition['tpmode'];
                $dsinpu = 'tm.dstmod';
                $join = 'INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn INNER JOIN tpmode tm ON tp.tpmode = tm.tpmode ';
                $where = 'WHERE tm.tpmode = :code';
                break;
            case 'AN': // cdartn
                $params['code'] = $condition['cdartn'];
                $dsinpu = 'tp.dsartn';
                $join = 'INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn ';
                $where = 'WHERE aa.cdartn = :code';
                break;
            case 'AR': // cdarti
                $params['code'] = $condition['cdarti'];
                $dsinpu = 'aa.dsarti';
                $where = 'WHERE aa.cdarti = :code';
                break;
            case 'TV': // tpvend
                $params['code'] = $condition['tpvend'];
                $dsinpu = 'ct.dstven';
                $join = 'INNER JOIN cratve ct ON ct.tpvend = aa.tpvend ';
                $where = 'WHERE aa.tpvend = :code';
                break;
            case 'MI': // cdmisu
                $params['code'] = $condition['cdmisu'];
                $dsinpu = 'cm.dsmisu';
                $join = 'INNER JOIN cramis cm ON cm.cdmisu = aa.cdmisu ';
                $where = 'WHERE aa.cdmisu = :code';
                break;
            case 'CO': // cdcolo
                $params['code'] = $condition['cdcolo'];
                $dsinpu = 'cc.dscolo';
                $join = 'INNER JOIN cracol cc ON cc.cdcolo = aa.cdcolo ';
                $where = 'WHERE aa.cdcolo = :code';
                break;
            case 'XX': // all
                $params['code'] = '';
                break;
        }

        $phql = "SELECT aa.cdarti, aa.dsarti, :tpinpu AS tpinpu, :code AS cdinpu, $dsinpu AS dsinpu,
      COALESCE(ot.quanti, 0) AS quanti, COALESCE(ot.prezzo * ot.quanti, 0) AS valore
      FROM anaart aa
      LEFT JOIN occorp oc ON aa.cdarti = oc.cdarti AND oc.nuordc = :nuordc
      LEFT JOIN octagl ot ON oc.nurorc = ot.nurorc
      $join
      $where ";
        $rows = Di::getDefault()->get('db')->query($phql, $params)->fetchAll();

        return $rows;
    }

    public function getOCPromoDetail($cdprom, $nuordc, &$articles, &$steps, &$merged)
    {
        $articles = array();
        $steps = array();
        $merged = array();

        $minQty = 0;
        $minVal = 0;
        $conditions = $this->getOCPromoConditions($cdprom, $minQty, $minVal, $steps);

        $currQty = 0;
        $currVal = 0;
        for ($i = 0; $i < count($conditions); $i++) {
            $rows = $this->getOCPromoArticles($conditions[$i], $nuordc);

            $partQty = 0;
            $partVal = 0;
            foreach ($rows as $row) {
                $currQty += $row['quanti'];
                $currVal += $row['valore'];
                $partQty += $row['quanti'];
                $partVal += $row['valore'];
                $articles[] = $row;
            }

            $mergedItem = array(
                'tpinpu' => $conditions[$i]['tpinpu'],
                'cdinpu' => count($rows) > 0 ? $rows[0]['cdinpu'] : '',
                'dsinpu' => count($rows) > 0 ? $rows[0]['dsinpu'] : '',
                'quanti' => $partQty,
                'valore' => $partVal
            );
            $merged[] = $mergedItem;
        }

        for ($i = 0; $i < count($steps); $i++) {
            $steps[$i]['fullfi'] = $currQty >= $steps[$i]['quanti'] && $currVal >= $steps[$i]['valore'];
        }
    }

    public function checkOCPromoStepsFullfilled($cdprom, $nuordc, &$articles, &$step)
    {
        $minQty = 0;
        $minVal = 0;
        $steps = array();
        $conditions = $this->getOCPromoConditions($cdprom, $minQty, $minVal, $steps);

        $currQty = 0;
        $currVal = 0;
        $articles = array();
        for ($i = 0; $i < count($conditions); $i++) {
            $rows = $this->getOCPromoArticles($conditions[$i], $nuordc);

            foreach ($rows as $row) {
                $currQty += $row['quanti'];
                $currVal += $row['valore'];
                $articles[] = $row;
            }
        }

        $fullfilled = $currQty >= $minQty && $currVal >= $minVal;

        $step = array('prezzo' => 0, 'scont1' => 0, 'scont2' => 0, 'scont3' => 0);
        for ($i = 0; $i < count($steps); $i++) {
            if ($currQty >= $steps[$i]['quanti'] && $currVal >= $steps[$i]['valore']) {
                $step['prezzo'] = $steps[$i]['prezzo'];
                $step['scont1'] = $steps[$i]['scont1'];
                $step['scont2'] = $steps[$i]['scont2'];
                $step['scont3'] = $steps[$i]['scont3'];
            }
        }

        return $fullfilled;
    }

    public function checkOCPromoFullfilled($cdprom, $nuordc)
    {
        $minQty = 0;
        $minVal = 0;
        $dummy = array();
        $conditions = $this->getOCPromoConditions($cdprom, $minQty, $minVal, $dummy);

        $currQty = 0;
        $currVal = 0;
        for ($i = 0; $i < count($conditions); $i++) {
            $rows = $this->getOCPromoArticles($conditions[$i], $nuordc);
            foreach ($rows as $row) {
                $currQty += $row['quanti'];
                $currVal += $row['valore'];
            }
        }

        $fullfilled = $currQty >= $minQty && $currVal >= $minVal;

        return $fullfilled;
    }
    //endregion
    //endregion

    //region Media functions
    public function checkOrCreateFile($file)
    {
        if (!file_exists($file)) {
            file_put_contents($file, '');
            chmod($file, 0777);
        }
    }

    // Used by AdminController and DataController
    public function getMediaFiles()
    {
        // Set directory
        $directory = './upload/media/';
        if (!is_dir($directory) && !mkdir($directory, 0777, true)) {
            die("Error creating folder $directory");
        }
        //chmod($directory,0755);

        // Get the directory array
        $directoryArray = array();

        // Get directory contents
        $files = scandir($directory);

        // Read files/folders from the directory
        foreach ($files as $file) {
            if ($file != '.' && $file != '..') {
                // Get files relative path
                $relativePath = $directory . '/' . $file;

                if (substr($relativePath, 0, 2) == './') {
                    $relativePath = substr($relativePath, 2);
                }

                // Get files absolute path
                $realPath = realpath($relativePath);

                // Determine file type by extension
                if (is_dir($realPath)) {
                    $iconClass = 'fa-folder';
                    $sort = 1;
                } else {
                    // Get file extension
                    $fileExt = strtolower(pathinfo($realPath, PATHINFO_EXTENSION));
                    $iconClass = self::getFileIconByExtension($fileExt);
                }

                // Build the file path
                $urlPath = implode('/', array_map('rawurlencode', explode('/', $relativePath)));

                $fileSize = '-';

                if (!is_dir($realPath)) {
                    // Get file size
                    $bytes = filesize($realPath);
                    // Get file size
                    $fileSize = self::getHumanReadableFileSize($bytes);
                }

                // Add the info to the main array
                $directoryArray[pathinfo($relativePath, PATHINFO_BASENAME)] = array(
                    'file_path' => $relativePath,
                    'file' => $file,
                    'file_size' => $fileSize,
                    'mod_time' => date('d-m-Y H:i:s', filemtime($realPath)),
                    'icon_class' => $iconClass
                );
            }
        }

        return $directoryArray;
    }

    public static function getHumanReadableFileSize($bytes)
    {
        // Array of file size suffixes
        $sizes = array('B', 'KB', 'MB', 'GB', 'TB', 'PB');

        // Calculate file size suffix factor
        $factor = floor((strlen($bytes) - 1) / 3);

        // Calculate the file size
        return sprintf('%.2f', $bytes / pow(1024, $factor)) . ' ' . $sizes[$factor];
    }

    public static function getFileIconByExtension($fileExtension)
    {
        switch (strtolower($fileExtension)) {
                // Archives
            case '7z':
            case 'bz':
            case 'gz':
            case 'rar':
            case 'tar':
            case 'zip':
                return 'fa-file-archiv-o';
                break;
                // Audio
            case 'aac':
            case 'flac':
            case 'mid':
            case 'midi':
            case 'mp3':
            case 'ogg':
            case 'wma':
            case 'wav':
                return 'fa-music';
                break;
                // Code
            case 'c':
            case 'class':
            case 'cpp':
            case 'css':
            case 'erb':
            case 'htm':
            case 'html':
            case 'java':
            case 'js':
            case 'php':
            case 'pl':
            case 'py':
            case 'rb':
            case 'xhtml':
            case 'xml':
                return 'fa-code';
                break;
                // Databases
            case 'accdb':
            case 'db':
            case 'dbf':
            case 'mdb':
            case 'pdb':
            case 'sql':
                return 'fa-hdd-o';
                break;
                // Text
            case 'cfg':
            case 'ini':
            case 'log':
            case 'md':
            case 'rtf':
            case 'txt':
                // Documents
            case 'csv':
            case 'doc':
            case 'docx':
            case 'odt':
            case 'pdf':
            case 'xls':
            case 'xlsx':
                return 'fa-file-text';
                break;
                // Executables
            case 'app':
                //case 'bat':
            case 'com':
            case 'exe':
            case 'jar':
            case 'msi':
            case 'vb':
                return 'fa-list-alt';
                break;
                // Fonts
            case 'eot':
            case 'otf':
            case 'ttf':
            case 'woff':
                return 'fa-font';
                break;
                // Game Files
            case 'gam':
            case 'nes':
            case 'rom':
            case 'sav':
                return 'fa-floppy-o';
                break;
                // Images
            case 'bmp':
            case 'gif':
            case 'jpg':
            case 'jpeg':
            case 'png':
            case 'psd':
            case 'tga':
            case 'tif':
                // Vector Images
            case 'ai':
            case 'drw':
            case 'eps':
            case 'ps':
            case 'svg':
                return 'fa-picture-o';
                break;
                // Package Files
            case 'box':
            case 'deb':
            case 'rpm':
                return 'fa-archive';
                break;
                // Scripts
            case 'bat':
            case 'cmd':
            case 'sh':
                return 'fa-terminal';
                break;
                // Video
            case 'avi':
            case 'flv':
            case 'mkv':
            case 'mov':
            case 'mp4':
            case 'mpg':
            case 'ogv':
            case 'webm':
            case 'wmv':
            case 'swf':
                return 'fa-youtube-play';
                break;
                // Other
            case 'bak':
            case 'msg':
                return 'fa-envelope';
                break;
                // Blank
            case 'blank':
            default:
                return 'fa-file';
                break;
        }
    }
    //endregion

    //region Email functions
    public function sendCouponEmailToUser($coupon, $customers, $shippings)
    {
        switch ($coupon->tpuser) {
            case 0:
                // all customers and shippings
                $emails = Anagra::getEmailAddressForCustomersAndShippings();
                break;
            case 1:
            case 2:
                // agents -- do nothing
                break;
            case 3:
                // all customers
                $emails = Anagra::getEmailAddressForCustomers();
                break;
            case 4:
                // only selected customers
                $emails = Anagra::getEmailAddressForSelectedCustomers($customers);
                break;
            case 5:
                // all shippings
                $emails = Anagra::getEmailAddressForShippings();
                break;
            case 6:
                // only selected shippings
                $emails = Anagra::getEmailAddressForSelectedShippings($shippings);
                break;
        }

        $discount_it = "";
        $discount_en = "";

        switch ($coupon->tpcoup) {
            case 0:
                $discount_it = "per la spedizione gratuita";
                $discount_en = "for free shipping";
                break;
            case 1:
                $discount_it = "pari al " . $coupon->impsco . "%";
                $discount_en = "equal to " . $coupon->impsco . "%";
                break;
            case 2:
                $discount_it = "pari a " . $coupon->impsco . " nella tua valuta";
                $discount_en = "equal to " . $coupon->impsco . " in your currency";
                break;
        }

        $catalogs = "";

        if ($coupon->tpcata == 1) {
            $cttests = Cttest::getCatalogsForCoupon($coupon->cdcoup);

            foreach ($cttests as $cttest) {
                $catalogs .= ', ' . $cttest->dscata;
            }
            $catalogs = substr($catalogs, 2);
        }

        $validity_it = "";
        $validity_en = "";
        if ($coupon->dtiniz != '0000-00-00' && $coupon->dtfine != '0000-00-00') {
            $validity_it = 'Il coupon &egrave; valido dal ' . date("d/m/Y", strtotime($coupon->dtiniz)) . ' al ' . date("d/m/Y", strtotime($coupon->dtfine));
            $validity_en = 'The coupon is valid from ' . date("d/m/Y", strtotime($coupon->dtiniz)) . ' to ' . date("d/m/Y", strtotime($coupon->dtfine));
        } else if ($coupon->dtiniz != '0000-00-00') {
            $validity_it = 'Il coupon &egrave; valido dal ' . date("d/m/Y", strtotime($coupon->dtiniz));
            $validity_en = 'The coupon is valid from ' . date("d/m/Y", strtotime($coupon->dtiniz));
        } else if ($coupon->dtfine != '0000-00-00') {
            $validity_it = 'Il coupon &egrave; valido fino al ' . date("d/m/Y", strtotime($coupon->dtfine));
            $validity_en = 'The coupon is valid until ' . date("d/m/Y", strtotime($coupon->dtfine));
        } else {
            $validity_it = 'Il coupon &egrave; valido sempre.';
            $validity_en = 'The coupon is valid forever.';
        }

        $content = 'Gentile Cliente,<br/>abbiamo pensato di fare cosa gradita riservandole un coupon sconto ' . $discount_it . '.<br/><br/>';
        $content .= 'Il coupon &egrave; valido per i seguenti cataloghi prodotti: ' . $catalogs;
        $content .= 'Il codice coupon che dovrà essere inserito al carrello &egrave; ' . $coupon->dscoup . '<br/>';
        $content .= $validity_it;
        $content .= $this->getEmailInfoIt() . '<br/><br/><br/><hr/><br/>';
        $content .= 'Dear Customer,<br/>we are glad to inform you that we have reserved to you a discount coupon ' . $discount_en . '.<br/><br/>';
        $content .= 'The coupon is valid for the following product catalogs: ' . $catalogs;
        $content .= 'The coupon code to add on the cart is ' . $coupon->dscoup . '<br/>';
        $content .= $validity_en;
        $content .= $this->getEmailInfoEn() . '<br/><br/><br/>';
        $content .= $this->getDisclaimer();

        $subject = $this->getAppUtils('company_extended') . ' GO-2B new coupon';

        $plain_emails = "";
        foreach ($emails as $email) {
            if (!empty($email['indema'])) {
                $plain_emails .= $email['indema'] . ";";
            }
        }

        // TODO Dobbiamo riattivare l'invio di queste email?
        // Add email to mail queue
        //B2bMsgque::saveRecord($plain_emails, $subject, $content, 1);
    }

    /**
     * @param B2bSysusr $user
     * @param string $password
     * @return false|mixed
     */
    public function sendNewAccessEmailToUser($user, $password = null)
    {
        $email = Anagra::getCustomerEmailFromUser($user);

        $company = strtolower($this->getAppUtils('company'));
        $link = $company . '.go-2b.it';
        if (empty($password)) {
            $password = $user::generateUserPasswordString($user->username, true);
        }

        if (empty($password)) {
            $password_it = 'contattaci per averla';
            $password_en = 'contact us to get it';
        } else {
            $password_it = $password;
            $password_en = $password;
        }

        $content = 'Gentile Cliente,<br/>abbiamo pensato di fare cosa gradita riservandole l\'accesso al nostro portale aziendale per effettuare gli ordini autonomamente.<br/><br/>';
        $content .= 'Il link di accesso &egrave; il seguente: <a href="http://' . $link . '">' . $link . '</a><br/><br/>';
        $content .= 'Le sue credenziali di accesso sono:<br/>';
        $content .= '&nbsp;&nbsp;&nbsp;- Username: ' . $user->username . '<br/>';
        $content .= '&nbsp;&nbsp;&nbsp;- Password: ' . $password_it . '<br/><br/>';
        $content .= $this->getEmailInfoIt() . '<br/><br/><br/><hr/><br/>';
        $content .= 'Dear Customer,<br/>We\'re glad to share that we\'ve set up dedicated access for you to our exclusive B2B portal. This personalized access allows you to effortlessly place orders at your convenience.<br/><br/>';
        $content .= 'Please use the following link to access the portal: <a href="http://' . $link . '">' . $link . '</a><br/><br/>';
        $content .= 'Your login credentials are as follows:<br/>';
        $content .= '&nbsp;&nbsp;&nbsp;- Username: ' . $user->username . '<br/>';
        $content .= '&nbsp;&nbsp;&nbsp;- Password: ' . $password_en . '<br/><br/>';
        $content .= $this->getEmailInfoEn() . '<br/><br/><br/>';
        $content .= $this->getDisclaimer();

        $nomeAzienda = $this->getAppUtils('company_extended');
        $subject = $nomeAzienda . ' GO-2B access';

        $senderConfig = $this->getAppUtils('noreply_address');

        if (!empty($email) && !empty($senderConfig)) {
            B2bMsgque::createRecord($email, $subject, $content, 0, $nomeAzienda);
            $user->email_sent = 1;
            return $user->save();
        }

        return false;
    }

    /**
     * @param B2bSysusr $user
     * @param string $password
     * @return false|mixed
     */
    public function sendPasswordResetEmailToUser($user, $password = null)
    {
        $email = Anagra::getCustomerEmailFromUser($user);

        $company = strtolower($this->getAppUtils('company'));
        $link = $company . '.go-2b.it';
        if (empty($password)) {
            $password = $user::generateUserPasswordString($user->username, true);
        }

        if (empty($password)) {
            $password_it = 'contattaci per averla';
            $password_en = 'contact us to get it';
        } else {
            $password_it = $password;
            $password_en = $password;
        }

        $content = 'Gentile Cliente,<br/>la password del suo account presso il nostro portale aziendale &egrave; stata resettata.<br/><br/>';
        $content .= 'Il link di accesso &egrave; il seguente: <a href="http://' . $link . '">' . $link . '</a><br/><br/>';
        $content .= 'Le sue nuove credenziali di accesso sono:<br/>';
        $content .= '&nbsp;&nbsp;&nbsp;- Username: ' . $user->username . '<br/>';
        $content .= '&nbsp;&nbsp;&nbsp;- Password: ' . $password_it . '<br/><br/>';
        $content .= $this->getEmailInfoIt() . '<br/><br/><br/><hr/><br/>';
        $content .= 'Dear Customer,<br/the password for your account on our company portal is been reset.<br/><br/>';
        $content .= 'The access link is as follows: <a href="http://' . $link . '">' . $link . '</a><br/><br/>';
        $content .= 'Your new login credentials are:<br/>';
        $content .= '&nbsp;&nbsp;&nbsp;- Username: ' . $user->username . '<br/>';
        $content .= '&nbsp;&nbsp;&nbsp;- Password: ' . $password_en . '<br/><br/>';
        $content .= $this->getEmailInfoEn() . '<br/><br/><br/>';
        $content .= $this->getDisclaimer();

        $nomeAzienda = $this->getAppUtils('company_extended');
        $subject = $nomeAzienda . ' GO-2B access';

        $senderConfig = $this->getAppUtils('noreply_address');

        if (!empty($email) && !empty($senderConfig)) {
            B2bMsgque::createRecord($email, $subject, $content, 0, $nomeAzienda);
            $user->email_sent = 1;
            return $user->save();
        }

        return false;
    }

    public function getEmailInfoIt()
    {
        return 'Per qualsiasi informazione o supporto pu&ograve; contattarci ai recapiti che trova di seguito.';
    }

    public function getEmailInfoEn()
    {
        return 'For further information or support please feel free to contact us at the following addresses.';
    }

    public function getDisclaimer()
    {
        return $this->getAppUtils('business_name') . '<br/>' .
            $this->getAppUtils('address') . '<br/>' .
            $this->getAppUtils('cap') . ' - ' . $this->getAppUtils('city') . ' (' . $this->getAppUtils('province') . ')<br/>' .
            $this->getAppUtils('country') . '<br/>' .
            $this->getAppUtils('tel') . '<br/>' .
            $this->getAppUtils('email') . '<br/>' .
            '<br/><hr/><br/>' .
            'Il messaggio trasmesso &egrave; rivolto esclusivamente alla persona o al soggetto al quale &egrave; indirizzato e potrebbe contenere informazioni riservate o confidenziali. ' .
            'Ne sono proibiti qualunque modifica, inoltro o divulgazione a terzi e qualunque altro uso. ' .
            'Chiunque riceva questa comunicazione per errore &egrave; pregato di contattare il mittente e distruggere il messaggio. Grazie.<br/><br/>' .
            'Please be advised that the contents of this email, including all attachments, are confidential and intended solely for the recipient specified in the message. Unauthorized disclosure, copying, or distribution of the information contained herein is strictly prohibited. ' .
            'If you are not the intended recipient, we request that you inform the sender immediately by replying to this email and then delete the message from your system to help maintain its confidentiality. Thanks<br/>' .
            '<br/><hr/><br/>';
    }

    public function sendNewCustomersEmail($language = 'it')
    {
        // Get customers
        $customers = Anagra::getOnlyNewCustomers();

        //    // Load translations
        //    $translationPath = '../app/messages/' . $language;
        //    require $translationPath . '/main.php';
        //
        //    /** @global $messages */
        //    $mainTranslate = new NativeArray(array(
        //      'content' => $messages
        //    ));
        $mainTranslate = self::loadTranslatorFor($language);

        // Create file dir
        $fileName = date('Y_m_d') . '_' . str_replace(' ', '_', strtolower($mainTranslate->_('admin.menu.newcustomers'))) . '.csv';
        $filePath = '../public/io/csv/email/';
        if (!file_exists('../public/io/csv/email/')) {
            if (!file_exists('../public/io/csv/')) {
                mkdir('../public/io/csv/', 0777, true);
            }
            mkdir('../public/io/csv/email/', 0777, true);
        }

        if (count($customers) > 0) {
            // Get email content and csv file
            $csvContent = '';
            $header =
                $mainTranslate->_('_common.code.provisional') . ';' .
                $mainTranslate->_('account.customer.businessname') . ';' .
                $mainTranslate->_('account.customer.taxcode') . ';' .
                $mainTranslate->_('account.customer.vatcode') . ';' .
                $mainTranslate->_('account.customer.address') . ';' .
                $mainTranslate->_('account.customer.city') . ';' .
                $mainTranslate->_('account.customer.province') . ';' .
                $mainTranslate->_('account.customer.capzip') . ';' .
                $mainTranslate->_('account.customer.country') . ';' .
                $mainTranslate->_('account.customer.zone') . ';' .
                $mainTranslate->_('account.customer.countrycode') . ';' .
                $mainTranslate->_('account.customer.telephone') . ';' .
                $mainTranslate->_('_common.email') . ';' .
                $mainTranslate->_('_common.email.other') . ';' .
                $mainTranslate->_('account.customer.pec') . ';' .
                $mainTranslate->_('account.customer.code.pr') . ';' .
                $mainTranslate->_('_common.website') . ';' .
                $mainTranslate->_('account.customer.mobilephone') . ';' .
                $mainTranslate->_('account.customer.fax') . ';' .
                'ABI;' .
                'CAB;' .
                'IBAN;' .
                $mainTranslate->_('account.customer.payment') . ';' .
                $mainTranslate->_('account.customer.shipment') . ';' .
                $mainTranslate->_('account.customer.carrier') . ';' .
                $mainTranslate->_('account.customer.agent') . "\n";

            $subject = $mainTranslate->_('admin.menu.newcustomers');
            $mailContent = $mainTranslate->_('admin.customers.email');
            foreach ($customers as $customer) {
                $csvContent .=
                    $customer->cdanag . ';' . $customer->descri . ';' . $customer->codfis . ';' .
                    $customer->pariva . ';' . $customer->indiri . ';' . $customer->ccitta . ';' .
                    $customer->provin . ';' . $customer->codcap . ';' . $customer->dsnazi . ';' .
                    $customer->dszona . ';' . $customer->intern . ';' . $customer->numtel . ';' .
                    $customer->indema . ';' . $customer->indem2 . ';' . $customer->indpec . ';' .
                    $customer->codupr . ';' . $customer->websit . ';' . $customer->numcel . ';' .
                    $customer->numfax . ';' . $customer->codabi . ';' . $customer->codcab . ';' .
                    $customer->cdiban . ';' . $customer->dspaga . ';' . $customer->dstpor . ';' .
                    $customer->dsvett . ';' . $customer->dsagen . "\n";
                $mailContent .= $mainTranslate->_('_common.code') . ': ' . $customer->cdanag . ' - ';
                $mailContent .= $mainTranslate->_('account.customer.businessname') . ': ' . $customer->descri . ' - ';
                $mailContent .= $mainTranslate->_('_common.agent') . ': ' . $customer->dsagen . '<br/>';
            }

            // Load file
            file_put_contents($filePath . $fileName, $header . $csvContent);

            $recipient = '';
            $recipients = explode(';', $this->getAppUtils('email_for_newcustomers'));

            if (count($recipients) > 0 && $recipients[0] != '') {
                $recipient = $recipients[0];
                // Remove To recipients from BCC recipients
                unset($recipients[0]);
            }

            if ($recipient != '') {
                $this->sendEmail('Sinergiattiva B2B', $recipient, $subject, $mailContent, $recipients, $filePath . $fileName);
            }
        }
    }

    public function sendAbandonedOrderClosureEmail($nuordc, $expirationEpoch = 0, $language = 'it')
    {
        // Get customers
        $order = Octest::findFirstByNuordc($nuordc);
        /** @var B2bSysusr $user */
        $user = B2bSysusr::findFirstById($order->id_usr);

        //    // Load translations
        //    $translationPath = '../app/messages/' . $language;
        //    require $translationPath . '/main.php';
        //    /** @global array $messages */
        //    $mainTranslate = new NativeArray(array(
        //      'content' => $messages
        //    ));
        $mainTranslate = self::loadTranslatorFor($language);

        $sender = $this->getAppUtils('company_extended');
        $recipient = '';
        $subject = $mainTranslate->_('email.abandonedOrder.subject', ['companyname' => $sender]);
        // TODO sarebbe meglio salvare non solo la data anche l'orario e stampare getHumanDateTime
        $mailContent = $mainTranslate->_('email.abandonedOrder.content', [
            'ordernumber' => $nuordc,
            'creationdate' => $this->getHumanDate($order->datdoc),
            'expiresdate' => date('d/m/Y H:i:s', $expirationEpoch),
            'supportemail' => $this->getAppUtils('email_for_notifyorder'),
            'companyname' => $sender,
        ]);

        if ($user->type == 3) {
            $recipient = B2bAddinf::getEmailForAgentFromUserId($order->id_usr);
        } else {
            $emails = Anagra::getEmailAddressForSelectedCustomers([$order->id_usr]);
            if (!empty($emails) && !empty($emails[0]['indema'])) {
                $recipient = $emails[0]['indema'];
            }
        }
        if ($recipient != '') {
            $this->sendEmail($sender, $recipient, $subject, $mailContent);
        }
    }

    public function getCustomVariantsCsv($mustSendEmail, $language = 'it', $manageOnlySpecial = false)
    {
        // Get custom variants
        if ($manageOnlySpecial) {
            $customs = Anaart::getAllCustomArticles(true);
        } else {
            $customs = $mustSendEmail
                ? Anaart::getAllCustomArticlesWithOrderQuantities()
                : Anaart::getAllCustomArticles(false);
        }

        $fullCustoms = array();
        for ($i = 0; $i < count($customs); $i++) {
            $currCustom = $customs[$i];
            $currCustom->features = Sparti::getAllFeaturesForCsv($currCustom->cdarti);
            $currCustom->orders = Occorp::getOrdersAndQuantityForCustomArticle($currCustom->cdarti);
            $fullCustoms[] = $currCustom;
        }
        $customs = $fullCustoms;

        // Load translations
        //    $translationPath = '../app/messages/' . $language;
        //    require $translationPath . '/main.php';
        //    /** @global $messages */
        //    $mainTranslate = new NativeArray(array(
        //      'content' => $messages
        //    ));
        $mainTranslate = self::loadTranslatorFor($language);

        // Create file dir
        $fileName = date('Y_m_d') . '_' . str_replace(' ', '_', strtolower($mainTranslate->_('admin.menu.customvariants'))) . '.csv';
        $filePath = '../public/io/csv/email/';
        if (!file_exists('../public/io/csv/email/')) {
            if (!file_exists('../public/io/csv/')) {
                mkdir('../public/io/csv/', 0777, true);
            }
            mkdir('../public/io/csv/email/', 0777, true);
        }

        if (count($customs) > 0) {
            // Get email content and csv file
            $csvContent = '';
            $header = $mainTranslate->_('_common.code.provisional') . ';' . $mainTranslate->_('_common.model') . ';';

            $numFeatures = count($customs[0]->features);
            for ($i = 0; $i < $numFeatures; $i++) {
                $header .= $customs[0]->features[$i]->dscomp . ';';
            }
            for ($i = 1; $i <= 10; $i++) {
                $header .= $mainTranslate->_('_common.ordernumber') . $i . ';';
                $header .= $mainTranslate->_('_common.qty') . $i . ';';
            }
            $header .= "\n";

            $subject = $mainTranslate->_('admin.menu.customvariants');
            $mailContent = '';
            foreach ($customs as $custom) {
                $csvContent .= $custom->cdarti . ';' . $custom->cdartn . ';';
                $mailContent .= $custom->cdarti . '<br/>';

                for ($i = 0; $i < $numFeatures; $i++) {
                    $csvContent .= $custom->features[$i]->valore . ';';
                }

                $numOrders = count($custom->orders);
                if ($numOrders > 0) {
                    for ($i = 0; $i < $numOrders; $i++) {
                        $csvContent .= $custom->orders[$i]->nuordc . ';';
                        $csvContent .= $custom->orders[$i]->quanti . ';';
                    }
                }
                $csvContent .= "\n";
            }

            // Load file
            file_put_contents($filePath . $fileName, $header . $csvContent);

            if ($mustSendEmail) {
                $recipient = '';
                $recipients = explode(';', $this->getAppUtils('email_for_customvariants'));

                if (count($recipients) > 0 && $recipients[0] != '') {
                    $recipient = $recipients[0];
                    // Remove To recipients from BCC recipients
                    unset($recipients[0]);
                }

                if ($recipient != '') {
                    $this->sendEmail('Sinergiattiva B2B', $recipient, $subject, $mailContent, $recipients, $filePath . $fileName);
                }
            } else {
                return array('fullPath' => $filePath . $fileName, 'filename' => $fileName);
            }
        } else {
            return array('fullPath' => '', 'filename' => '');
        }
    }

    public function sendEmail($sender, $recipient, $subject, $content, $recipients = null, $attachment = null)
    {
        $di = Di::getDefault();
        $logger = $di->get('logger');
        $mail = new PHPMailer(true); // Passing `true` enables exceptions
        try {
            //Server settings
            $mail->isHTML(true);                                  // Set email format to HTML
            $mail->CharSet = "text/html; charset=UTF-8;";
            $mail->SMTPDebug = false; // Enable verbose debug output
            $mail->isSMTP(); // Set mailer to use SMTP
            $mail->Host = $this->getAppUtils('smtp_server'); // Specify main and backup SMTP servers
            $mail->Port = $this->getAppUtils('smtp_port'); // TCP port to connect to

            if ($this->getAppUtils('smtp_auth') == 'true') {
                $mail->SMTPAuth = true; // Enable SMTP authentication
                $mail->Username = $this->getAppUtils('noreply_address');
                $mail->Password = $this->getAppUtils('noreply_password');
                // Should be ssl/465 or tls/587
                $protocol = $this->getAppUtils('smtp_protocol');
                $mail->SMTPSecure = $protocol; // Enable TLS encryption, `ssl` also accepted

                if ($protocol == 'ssl') {
                    $mail->SMTPOptions = array(
                        'ssl' => array(
                            'verify_peer' => false,
                            'verify_peer_name' => false,
                            'allow_self_signed' => true
                        )
                    );
                }
            }

            if ($attachment != null) {
                $mail->addAttachment($attachment);
            }

            //Recipients
            $mail->setFrom($this->getAppUtils('noreply_address'), $sender);
            $mail->addAddress($recipient);  // Add a recipient
            $mail->addReplyTo($this->getAppUtils('email'), 'Customer Service');
            if ($recipients != null && count($recipients) > 0) {
                foreach ($recipients as $bccRecipient) {
                    if ($bccRecipient != '') {
                        $mail->addBCC($bccRecipient);
                    }
                }
            }

            //Content
            $mail->Subject = $subject;
            $mail->Body = $content;

            if ($di->get('config')->release->user != 'test') {
                if (!$mail->send()) {
                    $logger->error(print_r($mail->ErrorInfo, true));
                } else {
                    //            $logger->info("Email [$subject] correttamente inviata a $recipient");
                }
            } else {
                $logger->debug("Email [$subject] NON inviata a $recipient a causa delle impostazioni del portale");
            }
        } catch (\Exception $e) {
            $logger->error(print_r($mail->ErrorInfo, true));
        }

        // Always return true
        return true;
    }

    // Marco 12.09.2022 - Creare  access request csv
    public function accessRequestCreateCsv($data, $language = 'it')
    {

        // Load translations
        $mt = self::loadTranslatorFor($language);
        $useNewCustomerRef = $this->getAppSettings('UseNewCustomerReferent');

        // Create file dir
        // Il nome del file ho aggiunto anche l'ora per evitare l'overwrite del file
        $fileName = date('Y_m_d_H_i_s') . '_' . str_replace(' ', '_', strtolower($mt->_('account.csv.accessrequest'))) . '.csv';
        $filePath = '../public/io/csv/accreq/';
        if (!file_exists('../public/io/csv/accreq/')) {
            if (!file_exists('../public/io/csv/')) {
                mkdir('../public/io/csv/', 0777, true);
            }
            mkdir('../public/io/csv/accreq/', 0777, true);
        }

        $csvContent = '';
        $header =
            $mt->_('export.csv.newcustomer.businessname') . ';' .
            $mt->_('export.csv.newcustomer.signboard') . ';' .
            $mt->_('export.csv.newcustomer.vatcode') . ';' .
            $mt->_('export.csv.newcustomer.email') . ';' .
            $mt->_('export.csv.newcustomer.telephone') . ';' .
            $mt->_('export.csv.newcustomer.address') . ';' .
            $mt->_('export.csv.newcustomer.city') . ';' .
            $mt->_('export.csv.newcustomer.country') . ';' .
            $mt->_('export.csv.newcustomer.province') . ';' .
            $mt->_('export.csv.newcustomer.sidcode') . ';' .
            $mt->_('export.csv.newcustomer.pec') . ';' .
            $mt->_('export.csv.newcustomer.capzip');
        if ($useNewCustomerRef) {
            $header .= ';' .
                $mt->_('export.csv.newcustomer.refname') . ';' .
                $mt->_('export.csv.newcustomer.refnote') . ';' .
                $mt->_('export.csv.newcustomer.refemail') . ';' .
                $mt->_('export.csv.newcustomer.refntel');
        }
        $header .= "\n";

        $csvContent .=
            $data['descri'] . ';' .
            $data['dsetic'] . ';' .
            $data['ivacfi'] . ';' .
            $data['indema'] . ';' .
            $data['numtel'] . ';' .
            $data['indiri'] . ';' .
            $data['ccitta'] . ';' .
            $data['dsnazi'] . ';' .
            $data['provin'] . ';' .
            $data['codsid'] . ';' .
            $data['emapec'] . ';' .
            $data['capind'];
        if ($useNewCustomerRef) {
            $csvContent .= ';' .
                $data['refname'] . ';' .
                $data['refnote'] . ';' .
                $data['refemail'] . ';' .
                $data['refntel'];
        }

        $csvContent .= "\n";

        $csvContent .=
            $data['desragsoc1'] . ';' .
            ';' .
            $data['ivacfi'] . ';' .
            ';' .
            ';' .
            $data['desindi1'] . ';' .
            $data['descitta1'] . ';' .
            $data['desdsnazi1'] . ';' .
            $data['desprov1'] . ';' .
            ';' .
            ';' .
            $data['descap1'];
        if ($useNewCustomerRef) {
            $csvContent .= ';' . ';' . ';' . ';';
        }
        $csvContent .= "\n";

        if (!empty($data['desindi2'])) {
            $csvContent .= $data['desragsoc2'] . ';' .
                ';' .
                $data['ivacfi'] . ';' .
                ';' .
                ';' .
                $data['desindi2'] . ';' .
                $data['descitta2'] . ';' .
                $data['desdsnazi2'] . ';' .
                $data['desprov2'] . ';' .
                ';' .
                ';' .
                $data['descap2'];
            if ($useNewCustomerRef) {
                $csvContent .= ';' . ';' . ';' . ';';
            }
            $csvContent .= "\n";
        }
        if (!empty($data['desindi3'])) {
            $csvContent .= $data['desragsoc3'] . ';' .
                ';' .
                $data['ivacfi'] . ';' .
                ';' .
                ';' .
                $data['desindi3'] . ';' .
                $data['descitta3'] . ';' .
                $data['desdsnazi3'] . ';' .
                $data['desprov3'] . ';' .
                ';' .
                ';' .
                $data['descap3'];
            if ($useNewCustomerRef) {
                $csvContent .= ';' . ';' . ';' . ';';
            }
            $csvContent .= "\n";
        }
        //      $data['desragsoc2']. ';'. $data['desindi2'] . ';' . $data['descitta2'] . ';' . $data['desdsnazi2']. ';'.
        //      $data['desprov2'] . ';' . "\n" .
        //      $data['desragsoc3'] . ';'. $data['desindi3'] . ';' . $data['descitta3']. ';'.
        //      $data['desdsnazi3'] . ';' . $data['desprov3'] ."\n";
        // Load file
        file_put_contents($filePath . $fileName, $header . $csvContent);

        // Send file to ftp
        $file = $filePath . $fileName;
        $remote_file = $fileName;

        if ($this->getAppUtils('ftp_url') != '') {

            // Send by FTP
            $ftp = ftp_connect($this->getAppUtils('ftp_url'));

            if ($ftp !== false) {

                $ftp_login = ftp_login($ftp, $this->getAppUtils('ftp_user'), $this->getAppUtils('ftp_password'));
                ftp_pasv($ftp, true);

                if ($ftp_login) {

                    if (ftp_put($ftp, $remote_file, $file, FTP_ASCII)) {
                        //echo "OK";
                    } else {
                        echo "FTP PUT ERROR";
                    }
                } else {
                    echo "FTP LOGIN FAILED!";
                }

                ftp_close($ftp);
            }
        }
    }

    //endregion

    //region Chat functions
    /**
     * @param $message B2bTkcorp
     * @param $msgtype
     * @param $user
     * @param $usertype
     * @return string
     */
    public function getHtmlChatMessage($message, $msgtype, $user, $usertype)
    {

        $avatar = "";
        $html = "";

        if (!empty($message->descri)) {
            if ($usertype <= B2bSysusr::TYPE_ADMIN || $usertype == B2bSysusr::TYPE_SUPPORT) {
                $avatar .= "<div class='bg-success align-middle support-avatar'><i class='fa fa-gear'></i></div>";
            } else {
                $avatar .= "<div class='bg-primary align-middle rounded-circle support-avatar'><i class='fa fa-user'></i></div>";
            }

            $attachmentsStr = '';
            foreach ($message->getAllegati() as $allegato) {
                $iconClass = self::getFileIconByExtension(pathinfo($allegato->filename, PATHINFO_EXTENSION));
                $fileSize = self::getHumanReadableFileSize($allegato->size);
                $attachmentsStr .= '<div class="chat-attachment"><i class="fa ' . $iconClass . '"></i> <a href="' . $allegato->url . '" target="_blank">' . $allegato->filename . '</a> - <small>' . $fileSize . '</small></div>';
            }

            if (!empty($attachmentsStr)) {
                $attachmentsStr = '<div class="row"><div class="chat-attachments col-10 col-xs-10 offset-sm-1 col-sm-offset-1">' . $attachmentsStr . '</div></div>';
            }

            $html .= <<<HTML
            <!-- divider -->
            <div class='row'>
                  <div class='col-2 col-xs-2 col-sm-1'></div>
                  <div class='col-8 col-xs-8 col-sm-10'><hr></div>
                  <div class='col-2 col-xs-2 col-sm-1'></div>
            </div>
            <div class="row chat-row direction-$msgtype">
                <div class="row message">
                    <div class='col-2 col-xs-3 col-sm-1 text-center'>$avatar</div>
                    <div class="col-8 col-xs-8">
                      <h6>$user</h6>
                      <p>$message->descri</p>
                    </div>
                </div>
                $attachmentsStr
            </div>
HTML;
        }

        return $html;
    }

    public function getHtmlChat($chat, $user = '')
    {
        $date = substr($chat, 0, 16);
        $type = substr($chat, 17, 1);
        $message = substr($chat, 20);

        $auth = Di::getDefault()->get('session')->get('auth');

        $curr_user = '';
        $isOnline = false;
        if ($type == 'i' && $auth['type'] != 6) {
            $curr_user = B2bSysusr::findFirst(array('type = 6'));
        } else if ($type == 'o' && $auth['type'] == 6) {
            $curr_user = B2bSysusr::findFirst(array('username = :username:', 'bind' => array('username' => $user)));
        }

        if ($curr_user != '') {
            $now = time();
            $target1 = strtotime($curr_user->last_active);
            $target2 = strtotime($curr_user->last_login);
            $diff1 = $now - $target1;
            $diff2 = $now - $target2;
            $isOnline = $diff1 <= 900 || $diff2 <= 900;
        }

        $html = '<div class="popup-message" data-verse="' . ($type == 'i' ? 'in' : 'out') . '">
        <div class="' . ($type == 'i' ? 'support' : 'user') . '-avatar">';

        if ($type == 'i') {
            if ($auth['type'] == 6) {
                $html .= '<div class="short-name">' . substr($auth['username'], 0, 1) . '</div>
          <div class="long-name">' . $auth['username'] . '</div>';
            } else {

                $html .= '<div class="led-green" ' . ($isOnline ? '' : 'style="display:none"') . '></div>
          <div class="short-name">' . substr(self::getTranslatorFor()->_('chat.support'), 0, 1) . '</div>
          <div class="long-name">' . self::getTranslatorFor()->_('chat.support') . '</div>';
            }
        } else {
            if ($auth['type'] == 6) {
                $html .= '<div class="led-green" ' . ($isOnline ? '' : 'style="display:none"') . '></div>
          <div class="short-name">' . substr($user, 0, 1) . '</div>
          <div class="long-name">' . $user . '</div>';
            } else {
                $html .= '<div class="short-name">' . substr($auth['username'], 0, 1) . '</div>
          <div class="long-name">' . $auth['username'] . '</div>';
            }
        }

        $html .= '</div>
        <div class="content ' . ($type == 'i' ? 'in' : 'out') . '">
          <div class="message">' . htmlspecialchars($message) . '</div>
          <div class="date">' . $date . '</div>
        </div>
      </div>';

        return $html;
    }

    public function isSupportAvailable()
    {
        $support = B2bAppset::findFirstByName('SupportAvailable');
        return !empty($support) ? $support->value : 0;
    }
    //endregion

    //region Excel functions
    public function checkOrCreateResizeFolder()
    {
        if (!file_exists('img/temp/resize/model')) {
            if (!file_exists('img/temp/resize')) {
                if (!file_exists('img/temp')) {
                    mkdir('./img/temp', 0777, true);
                }
                mkdir('./img/temp/resize', 0777, true);
            }
            mkdir('./img/temp/resize/model', 0777, true);
        }
    }

    public function resizeImageForExcel($curr_image, $temp_image)
    {
        $fixed_height = 200;
        // If it's not present resized image and it's present image, resize it
        try {
            if (!file_exists($temp_image) && file_exists($curr_image)) {
                list($width, $height, $type, $attr) = getimagesize($curr_image);
                $target_filename = $curr_image;
                $fn = $curr_image;
                $size = getimagesize($fn);
                $width = $size[1] != 0 ? $size[0] * $fixed_height / $size[1] : $fixed_height;
                $height = $fixed_height;
                $src = imagecreatefromstring(file_get_contents($fn));
                $dst = imagecreatetruecolor($width, $height);
                imagecopyresampled($dst, $src, 0, 0, 0, 0, $width, $height, $size[0], $size[1]);
                imagejpeg($dst, $temp_image);
            }
            return true;
        } catch (\Exception $ex) {
            return false;
        }
    }

    public function getNameFromNumber($num)
    {
        $numeric = $num % 26;
        $letter = chr(65 + $numeric);
        $num2 = intval($num / 26);
        if ($num2 > 0) {
            return $this->getNameFromNumber($num2 - 1) . $letter;
        } else {
            return $letter;
        }
    }

    public function sanitizeStringForXls($string)
    {
        $sanitizedString = $string;
        $sanitizedString = str_replace('\\', '_', $sanitizedString);
        $sanitizedString = str_replace('/', '_', $sanitizedString);
        $sanitizedString = str_replace('*', '_', $sanitizedString);
        $sanitizedString = str_replace('?', '_', $sanitizedString);
        $sanitizedString = str_replace(':', '_', $sanitizedString);
        $sanitizedString = str_replace('[', '_', $sanitizedString);
        $sanitizedString = str_replace(']', '_', $sanitizedString);
        $sanitizedString = str_replace(' ', '_', $sanitizedString);
        $sanitizedString = str_replace('$', '_', $sanitizedString);
        $sanitizedString = str_replace('!', '_', $sanitizedString);
        return $sanitizedString;
    }
    //endregion

    //region Images functions
    public function assignAllImages($index = 0)
    {
        $catalogs = Cttest::find();
        $reassi = 1;
        $syncType = $this->getAppSettings('SyncType');
        if ($syncType == 0) {
            foreach ($catalogs as $catalog) {
                $models = Tipolo::getModelCodesFromCatalog($catalog->cdcata);
                foreach ($models as $model) {
                    (new AdminBase)->assignImageModelCtarti($model->cdartn);
                    (new AdminBase)->assignImageModAggCtarti($model->cdartn, $reassi);
                    (new AdminBase)->assignImageModArtCtarti($model->cdartn, $catalog->cdcata, $reassi);
                }
            }
        } else {
            $totCatalogs = count($catalogs);
            for ($i = 0; $i < $totCatalogs; $i++) {
                $catalog = $catalogs[$i];
                $text = self::getTranslatorFor()->_('_common.catalog') . ': ' . $catalog->cdcata . ' (' . ($i + 1) . '/' . $totCatalogs . ')';
                (new AdminBase)->assignImagesSpecial($catalog->cdcata, $syncType, $reassi == 1, $text);
            }
        }
    }
    //endregion

    //region Account info
    public function getOrdersSummary($id_usr)
    {
        $octest = array();

        $usrage = B2bUsrage::findFirst(array('id_usr = :id_usr:', 'bind' => array('id_usr' => $id_usr)));
        $usrana = B2bUsrana::findFirst(array('id_usr = :id_usr:', 'bind' => array('id_usr' => $id_usr)));
        $usrdsm = B2bUsrdsm::findFirst(array('id_usr = :id_usr:', 'bind' => array('id_usr' => $id_usr)));

        if ($usrage) {
            // agent -- get all orders created from agent (read + write)
            $octest = Octest::getAllOrdersCreatedByAgent($id_usr, $usrage->cdagen);
        } else if ($usrana) {
            // customer -- get all orders created from agents (only read), himself (read + write), destinations (only read)
            $octest1 = Octest::getAllOrdersCreatedByCustomer($id_usr);
            $octest2 = Octest::getAllOrdersCreatedByAgentForCustomer($usrana->tpanag, $usrana->cdanag);
            $octest3 = Octest::getAllOrdersCreatedByDestinationForCustomer($usrana->tpanag, $usrana->cdanag);
            $octest = array_merge($octest1->toArray(), $octest2->toArray(), $octest3->toArray());
        } else if ($usrdsm) {
            // goods destination
        }

        $full_octest = array();
        for ($i = 0; $i < count($octest); $i++) {
            $curr_octest = $octest[$i];


            // lbravi 01/12/2023 - fix
            // L'applicazione di questi sconti era gia contemplata nelle query precedenti quindi lo sconto veniva applicato 2 volte nel summary
            //
            //            // We need to recalculate all row discounts if customer and/or at least one row have discounts and it is NOT already sent
            //            if ($curr_octest['flstat'] == 1 && $curr_octest['flnosc'] == 0) {
            //                // $numdis = $this->getCustomDiscountSummary($curr_octest['tpanag'], $curr_octest['cdanag'], $curr_octest['nulist'], $curr_octest['cdcata']);
            //                $numdis = $this->getCustomDiscount($curr_octest);
            //                $hasdis = Octagl::hasSizeQuantityDiscount($curr_octest['nuordc']);
            //                if ($numdis > 0 && $hasdis && $curr_octest['chmod'] == 'all') {
            //                    $curr_octest['tot_prc'] = $this->calculateRowDiscountsSummary($curr_octest['nuordc'], $numdis);
            //                } else if (!$hasdis && ($curr_octest['anagra_scont1'] != 0 || $curr_octest['anagra_scont2'] != 0 || $curr_octest['anagra_scont3'] != 0)) {
            //                    $curr_octest['tot_prc'] = $curr_octest['tot_prc'] * (1 - ($curr_octest['anagra_scont1'] / 100)) *
            //                        (1 - ($curr_octest['anagra_scont2'] / 100)) * (1 - ($curr_octest['anagra_scont3'] / 100));
            //                }
            //            }

            $lstest = Lstest::findFirstByNulist($curr_octest['nulist']);
            $currency = $this->getCurrencySymbol($lstest->cdvalu);

            if ($curr_octest['tpordc'] == 0) {
                $occorp = Occorp::getOrderRows($octest[$i]['nuordc']);

                $is_available = true;
                for ($j = 0; $j < count($occorp); $j++) {
                    if ($occorp[$j]->tppers != 'PT') {
                        $is_available &= $this->isArticleAvailable_OrderList($occorp[$j]->nurorc);
                    } else {
                        $is_available &= $this->isColorVariantArticleAvailable_OrderList($occorp[$j]->nurorc);
                    }
                }

                $curr_octest['is_available'] = $is_available;
            }
            $curr_octest['currency'] = $currency;

            $curr_octest['is_sendable'] = $this->getAppSettings('PreventOrderToBeSentWithoutPrices') == 1
                ? Occorp::hasPriceForEveryRow($octest[$i]['nuordc'])
                : true;

            // Recuperata dal volt (vedi account/info.volt:931)
            $isDisabled = !(($octest[$i]['flstat'] == 1 || (!in_array($octest[$i]['flstat'], [2, 3, 4]) && B2bAddinf::isSpecialAgent($id_usr))) && $octest[$i]['chmod'] == 'all');

            $orderLimitMode = $this->getAppSettings('OrderLimit');

            // Send button
            if (!$isDisabled && $orderLimitMode > 0) {
                $orderLimitMinValue = $this->getAppSettings('OrderLimitMinValue');
                if ($orderLimitMode == 1) {
                    $totArticoli = Octest::countArticlesInOrder($octest[$i]['nuordc']);
                    if ($totArticoli < $orderLimitMinValue) {
                        $isDisabled = true;
                    }
                } else if ($orderLimitMode == 2) {
                    $totSpesa = Octest::retriveSpendInOrder($octest[$i]['nuordc']);
                    if ($totSpesa < $orderLimitMinValue) {
                        $isDisabled = true;
                    }
                }
            }
            $curr_octest['is_disabled'] = $isDisabled;

            $full_octest[] = $curr_octest;
        }

        $nuordc = array();
        foreach ($full_octest as $key => $row) {
            $nuordc[$key] = $row['nuordc'];
        }
        array_multisort($nuordc, SORT_DESC, $full_octest);

        return $full_octest;
    }

    public function getDeadlines($type, $customers)
    {
        if ($type == 3) {
            $full_deadline = array();
            for ($i = 0; $i < count($customers); $i++) {
                $curr_deadline = array();

                $gopart = Gopart::getMinimalDeadlinesForCustomer($customers[$i]->tpanag, $customers[$i]->cdanag);

                if (count($gopart) > 0) {
                    $curr_deadline['tpanag'] = $customers[$i]->tpanag;
                    $curr_deadline['cdanag'] = $customers[$i]->cdanag;
                    $curr_deadline['descri'] = $customers[$i]->descri;
                    $curr_deadline['numdoc'] = count($gopart);
                    $curr_deadline['totdoc'] = 0;

                    for ($j = 0; $j < count($gopart); $j++) {
                        $curr_deadline['totdoc'] += $gopart[$j]->impdoc;
                    }

                    $gopart = Gopart::getValuesDeadlinesForCustomer($customers[$i]->tpanag, $customers[$i]->cdanag);

                    $curr_deadline['scadra'] = 0;
                    $curr_deadline['scadut'] = 0;
                    for ($j = 0; $j < count($gopart); $j++) {
                        if ($gopart[$j]->expired > 0) {
                            $curr_deadline['scadut'] += $gopart[$j]->impsca;
                        } else {
                            $curr_deadline['scadra'] += $gopart[$j]->impsca;
                        }
                    }

                    $full_deadline[] = $curr_deadline;
                }
            }

            return $full_deadline;
        } else {
            return Gopart::getDeadlinesForCustomer($customers[0]->tpanag, $customers[0]->cdanag);
        }
    }
    //endregion

    //region Get default payment/shipping type
    public function getDefaultShipping($id_usr)
    {
        if ($this->getAppSettings('ShippingOnCloseOrder') == 0 || $this->getAppSettings('ShippingOnCloseOrder') == 2) {
            return Anagra::getDefaultShippingForUser($id_usr, $this->getLanguage());
        } else {
            return '';
        }
    }

    public function getDefaultShippingFromCustomer($tpanag, $cdanag)
    {
        if ($this->getAppSettings('ShippingOnCloseOrder') == 0 || $this->getAppSettings('ShippingOnCloseOrder') == 2) {
            return Anagra::getDefaultShippingForCustomer($tpanag, $cdanag, $this->getLanguage());
        } else {
            return '';
        }
    }

    public function getDefaultPayment($id_usr)
    {
        if ($this->getAppSettings('PaymentOnCloseOrder') == 0 || $this->getAppSettings('PaymentOnCloseOrder') == 2) {
            return Anagra::getDefaultPaymentForUser($id_usr, $this->getLanguage());
        } else {
            return '';
        }
    }

    public function getDefaultPaymentFromCustomer($tpanag, $cdanag)
    {
        if ($this->getAppSettings('PaymentOnCloseOrder') == 0 || $this->getAppSettings('PaymentOnCloseOrder') == 2) {
            return Anagra::getDefaultPaymentForCustomer($tpanag, $cdanag, $this->getLanguage());
        } else {
            return '';
        }
    }
    //endregion

    //region Catalog functions
    public function hasWizard($modelDetailStyle)
    {
        return !in_array($modelDetailStyle, [0, 1, 6, 7, 8, 9]);
    }

    public function getAvailableCatalogs($id_usr = -1)
    {
        if ($id_usr != -1) {
            return Cttest::getCatalogForUser($id_usr);
        } else {
            return Cttest::find(
                array(
                    "(dtiniz <= :dtoggi: AND dtfine >= :dtoggi:) OR dtiniz = '0000-00-00' OR dtfine = '0000-00-00' ",
                    'order' => 'seqrap',
                    'bind' => array('dtoggi' => date('Y-m-d'))
                )
            );
        }
    }

    public function getSelectedCatalog($isOrder, $orderInfo, $catalogs)
    {
        // Get selected catalog from session
        $sessionCdcata = Di::getDefault()->get('session')->get('cdcata');
        $sessionCdcata = $sessionCdcata !== null && !empty($sessionCdcata) ? $sessionCdcata : '';

        $selectedCatalog = '';
        if ($isOrder) {
            // Get selected catalog
            $selectedCatalog = Cttest::findFirstByCdcata($orderInfo->cdcata);
        } else {
            if ($sessionCdcata != '') {
                $selectedCatalog = Cttest::findFirstByCdcata($sessionCdcata);
            } else {
                if ($this->getAppUtils('default_catalog') != '') {
                    for ($i = 0; $i < count($catalogs); $i++) {
                        if ($catalogs[$i]->cdcata == $this->getAppUtils('default_catalog')) {
                            $selectedCatalog = $catalogs[$i];
                        }
                    }

                    $selectedCatalog = $selectedCatalog != '' ? $selectedCatalog : (count($catalogs) > 0 ? $catalogs[0] : '');
                } else {
                    $selectedCatalog = count($catalogs) > 0 ? $catalogs[0] : '';
                }
            }
        }

        if ($selectedCatalog != '') {
            Di::getDefault()->get('session')->set('cdcata', $selectedCatalog->cdcata);
        }

        return $selectedCatalog != '' ? $selectedCatalog : Cttest::findFirst();
    }

    public function getLines($cdcata)
    {
        $idlang = $this->getLanguage();
        return Linmod::getLinesFromCatalogWithConditions($cdcata, $idlang);
    }

    public function getLinesFromBrands($brands, $cdcata)
    {
        $idlang = $this->getLanguage();

        $lines = array();
        foreach ($brands as $titlin) {
            $lines[$titlin->cdtitl] = Linmod::getLinesFromCatalogAndBrandWithConditions($cdcata, $titlin->cdtitl, $idlang);
        }
        return $lines;
    }

    public function getSeriesFromLines($lines, $cdcata)
    {
        $idlang = $this->getLanguage();

        $series = array();
        foreach ($lines as $linmod) {
            $series[$linmod->cdlinm] = Sermod::getSeriesFromCatalogAndLineWithConditions($cdcata, $linmod->cdlinm, $idlang);
        }
        return $series;
    }

    public function getBlocksArrayForHomepage($hpcorp)
    {
        $blocks = array();

        foreach ($hpcorp as $box) {
            if (!isset($blocks[$box->nubloc])) {
                $blocks[$box->nubloc] = array(
                    'size' => $box->blsize,
                    'boxes' => array()
                );
            }

            $blocks[$box->nubloc]['boxes'][$box->seqrap] = $box;
        }
        return $blocks;
    }

    public function getFullGenreForNavbar($genre, $cdcata)
    {
        $currGenre = $genre;
        $currGenre->lines = array();

        $simpleLines = Linmod::getLinesFilteredByGenreFromCatalog($cdcata, $currGenre->codice);
        foreach ($simpleLines as $line) {
            $currLine = $line;
            $currLine->series = Sermod::getSeriesFilteredByGenreAndLineFromCatalog($cdcata, $currGenre->codice, $currLine->cdlinm);
            $currGenre->lines[] = $currLine;
        }

        return $currGenre;
    }

    public function getImageModelLink($image, $params = [])
    {
        $full_link = "";

        $imageConf = $this->getAppUtils('images_prefix');
        if (!empty($image)) {
            if ($imageConf == "") {
                $full_link = '/img/model/' . $image;
            } else {
                $base_url = $imageConf . '/_' . Di::getDefault()->get('config')->release->user . '_';
                if (!empty($params)) {
                    // modifica che se il parametro è vuoto allora prende il vecchio link
                    if (file_exists('./img/model/' . $image)) {
                        $data_img = filemtime('./img/model/' . $image);
                    } else {
                        $data_img = date("Y-m-d");
                    }

                    $new_params = array_merge($params, ["lasttime" => $data_img]);
                    $full_link = $base_url . '/' . $image . '?' . http_build_query($new_params);
                } else {
                    $full_link = $base_url . '/' . $image;
                }
            }
        }
        return $full_link;
    }
    //endregion

    //region Insert quantity functions
    public function getArticleAvailability($cdarti)
    {
        $availability = Dscorp::getArticleAvailability($cdarti);

        $fullAvailability = array();
        if (count($availability) > 0) {
            $curr_dtdisp = date("d/m/Y", strtotime(date('Y-m-d') > $availability[0]['dtdisp'] ? date('Y-m-d') : $availability[0]['dtdisp']));
            $curr_isasso = $availability[0]['isasso'];
            $ass_availability = array();
            $dsp_availability = array();
            for ($i = 0; $i < count($availability); $i++) {
                if ($curr_dtdisp != date("d/m/Y", strtotime(date('Y-m-d') > $availability[$i]['dtdisp'] ? date('Y-m-d') : $availability[$i]['dtdisp']))) {
                    $label = $curr_isasso == 1 ? 'asso' : 'size';
                    $ass_availability[$label] = $dsp_availability;
                    $fullAvailability[] = array(
                        'dtdisp' => $curr_dtdisp,
                        'alldsp' => $ass_availability
                    );
                    $ass_availability = array();
                    $dsp_availability = array();

                    $curr_dtdisp = date("d/m/Y", strtotime($availability[$i]['dtdisp']));
                    $curr_isasso = $availability[$i]['isasso'];
                } else if ($curr_isasso != $availability[$i]['isasso']) {
                    $label = $curr_isasso == 1 ? 'asso' : 'size';
                    $ass_availability[$label] = $dsp_availability;

                    $dsp_availability = array();
                    $curr_isasso = $availability[$i]['isasso'];
                }

                $dsp_availability[$availability[$i]['item']] = $availability[$i]['quanti'];
            }

            $label = $curr_isasso == 1 ? 'asso' : 'size';
            $ass_availability[$label] = $dsp_availability;

            $fullAvailability[] = array(
                'dtdisp' => $curr_dtdisp,
                'alldsp' => $ass_availability
            );
        }

        return $fullAvailability;
    }

    public function getColorVariantArticleAvailability($cdarti, $cdcolo, $cdtagl)
    {
        $availability = Dscorp::getColorAvailability($cdarti, $cdcolo, $cdtagl);

        $fullAvailability = array();
        if (count($availability) > 0) {
            $curr_cdvari = $availability[0]->cdvari;
            $curr_dtdisp = $availability[0]->dtdisp;
            $var_availability = array();
            $dsp_availability = array();
            for ($i = 0; $i < count($availability); $i++) {
                if ($curr_cdvari != $availability[$i]->cdvari) {
                    $curr_cdvari = !isset($curr_cdvari) || $curr_cdvari == '' ? 'no_cdvari' : $curr_cdvari;
                    $var_availability[] = array(
                        'dtdisp' => date("d/m/Y", strtotime($curr_dtdisp)),
                        'qtysiz' => $dsp_availability
                    );
                    $fullAvailability[] = array(
                        'cdvari' => $curr_cdvari,
                        'alldsp' => $var_availability
                    );
                    $var_availability = array();
                    $dsp_availability = array();

                    $curr_dtdisp = $availability[$i]->dtdisp;
                    $curr_cdvari = $availability[$i]->cdvari;
                } else if ($curr_dtdisp != $availability[$i]->dtdisp) {
                    $var_availability[] = array(
                        'dtdisp' => date("d/m/Y", strtotime($curr_dtdisp)),
                        'qtysiz' => $dsp_availability
                    );
                    $dsp_availability = array();

                    $curr_dtdisp = $availability[$i]->dtdisp;
                }

                $dsp_availability[$availability[$i]->taglia] = $availability[$i]->quanti;
            }

            $curr_cdvari = !isset($curr_cdvari) || $curr_cdvari == '' ? 'no_cdvari' : $curr_cdvari;
            $var_availability[] = array(
                'dtdisp' => date("d/m/Y", strtotime($curr_dtdisp)),
                'qtysiz' => $dsp_availability
            );
            $fullAvailability[] = array(
                'cdvari' => $curr_cdvari,
                'alldsp' => $var_availability
            );
        }

        return $fullAvailability;
    }

    public function getOrderRows($cdarti, $cdcolo, $nuordc, $nurorc = null)
    {
        $occorp = Occorp::getMinimalOrderRows($nuordc, $cdarti, $cdcolo, $nurorc);

        $full_occorp = array();
        if (count($occorp) > 0) {
            for ($i = 0; $i < count($occorp); $i++) {
                $curr_occorp = $occorp[$i];
                $curr_occorp->detail = '';
                $curr_occorp->assortments = '';
                $curr_occorp->writeAttribute('detail', $this->getOrderRowDetail($curr_occorp->nurorc));
                $curr_occorp->writeAttribute('assortments', $this->getOrderAssortmentRowDetail($curr_occorp->nurorc));
                $full_occorp[] = $curr_occorp;
            }
        }

        return $full_occorp;
    }

    public function getOrderRowDetail($nurorc)
    {
        $octagl = Octagl::getAllSizeQuantities($nurorc);

        $full_octagl = array();
        if (count($octagl) > 0) {
            for ($i = 0; $i < count($octagl); $i++) {
                $full_octagl[$octagl[$i]->dstagl] = $octagl[$i]->quanti;
            }
        }

        return $full_octagl;
    }

    public function getOrderAssortmentRowDetail($nurorc)
    {
        $ocasso = Ocasso::getAssortmentQuantity($nurorc, false);

        $full_ocasso = array();
        if (count($ocasso) > 0) {
            for ($i = 0; $i < count($ocasso); $i++) {
                $full_ocasso[$ocasso[$i]->cdasso] = $ocasso[$i]->quanti;
            }
        }

        return $full_ocasso;
    }

    public function getRules($sizes, $cdartn, $cdarti, $cdcolo, $order_rows = null, $discount = 0)
    {
        $regqta = Regqta::getRules($cdartn, $cdarti, $cdcolo);
        $availabilityFroSizes = Dscorp::getArticleAvailabilityForSizes($cdarti);

        $full_sizes = array();
        // Check regqta for flbloc/flprom, while qtamin, qtamul taken by regqtm
        for ($x = 0; $x < count($sizes); $x++) {
            $curr_size = $sizes[$x];
            $curr_size->qtamin = 1;
            $curr_size->qtamul = 1;
            $curr_size->qtamax = 0;
            $curr_size->flbloc = 0;
            $curr_size->flprom = 0;
            $curr_size->available = false;
            $curr_size->availability = 0;
            $curr_size->quantity = 0;
            $curr_size->prezzo = floatval($curr_size->prezzo);
            $curr_size->sconto = $discount;
            $curr_size->prezzoScontato = $curr_size->prezzo * (1 - $curr_size->sconto / 100);

            if (!empty($order_rows)) {
                foreach ($order_rows as $order_row) {
                    if ($order_row->cdarti == $cdarti && $order_row->cdcolo == $cdcolo) {
                        if (!empty($order_row->detail[$curr_size->taglia])) {
                            $curr_size->quantity = intval($order_row->detail[$curr_size->taglia]);
                        }
                        break;
                    }
                }
            }

            if (!empty($availabilityFroSizes[$curr_size->taglia])) {
                $qta = intval($availabilityFroSizes[$curr_size->taglia]);
                $curr_size->available = $qta > 0;
                $curr_size->availability = $qta;
            }

            // Translated from GoApp code (DeMorgan applied)
            $priority = 5;

            for ($y = 0; $y < count($regqta); $y++) {
                if ($regqta[$y]->postgl > 0 && $regqta[$y]->taglia != "") {
                    if ($regqta[$y]->taglia == $curr_size->taglia) {
                        if ($regqta[$y]->cdcolo != "") {
                            if ($regqta[$y]->cdcolo == $cdcolo) {
                                // Priority 0 (top): same taglia and cdcolo (and cdartn/cdarti)
                                $curr_size->flbloc = $regqta[$y]->flbloc;
                                $curr_size->flprom = $regqta[$y]->flprom;
                                $curr_size->qtamin = $regqta[$y]->qtamin;
                                $curr_size->qtamul = $regqta[$y]->qtamul;
                                $curr_size->qtamax = $regqta[$y]->qtamax;
                                break;
                            }
                        } else {
                            if ($regqta[$y]->cdarti != "") {
                                // Priority 1: same taglia and cdarti (no cdcolo)
                                $curr_size->flbloc = $regqta[$y]->flbloc;
                                $curr_size->flprom = $regqta[$y]->flprom;
                                $curr_size->qtamin = $regqta[$y]->qtamin;
                                $curr_size->qtamul = $regqta[$y]->qtamul;
                                $curr_size->qtamax = $regqta[$y]->qtamax;
                                $priority = 1;
                            }
                        }
                    }
                } else {
                    if ($regqta[$y]->cdcolo != "") {
                        if ($regqta[$y]->cdcolo == $cdcolo && $priority > 2) {
                            // Priority 2: same taglia and no cdcolo (and cdartn/cdarti)
                            $curr_size->flbloc = $regqta[$y]->flbloc;
                            $curr_size->flprom = $regqta[$y]->flprom;
                            $curr_size->qtamin = $regqta[$y]->qtamin;
                            $curr_size->qtamul = $regqta[$y]->qtamul;
                            $curr_size->qtamax = $regqta[$y]->qtamax;
                            $priority = 2;
                        }
                    } else {
                        if ($regqta[$y]->cdcolo == "") {
                            if ($regqta[$y]->cdarti != "") {
                                // Priority 3: same cdarti (no cdcolo)
                                if ($priority > 3) {
                                    $curr_size->flbloc = $regqta[$y]->flbloc;
                                    $curr_size->flprom = $regqta[$y]->flprom;
                                    $curr_size->qtamin = $regqta[$y]->qtamin;
                                    $curr_size->qtamul = $regqta[$y]->qtamul;
                                    $curr_size->qtamax = $regqta[$y]->qtamax;
                                    $priority = 3;
                                }
                            } else {
                                // Priority 4: same cdartn (no cdcolo and cdarti should be null)
                                if ($priority > 4) {
                                    $curr_size->flbloc = $regqta[$y]->flbloc;
                                    $curr_size->flprom = $regqta[$y]->flprom;
                                    $curr_size->qtamin = $regqta[$y]->qtamin;
                                    $curr_size->qtamul = $regqta[$y]->qtamul;
                                    $curr_size->qtamax = $regqta[$y]->qtamax;
                                    $priority = 4;
                                }
                            }
                        }
                    }
                }
            }

            $full_sizes[] = $curr_size;
        }

        return $full_sizes;
    }
    //endregion

    //region Check availability
    // Used from Utility and ModelController
    public function isArticleAvailable($cdarti)
    {
        $dscorp = Dscorp::getMaxArticleAvailability($cdarti);
        return $dscorp->quanti > 0 ? 'true' : 'false';
    }

    // Check if order row is still available on order list
    public function isArticleAvailable_OrderList($nurorc)
    {
        $availability = Dscorp::getArticleAvailabilityForOrderList($nurorc);

        $is_available = true;
        for ($i = 0; $i < count($availability); $i++) {
            if (($availability[$i]->quant1 - $availability[$i]->quant2 - $availability[$i]->quant3) < 0) {
                $is_available = false;
            }
        }

        return $is_available;
    }

    // Check if order row is still available on order list -- Paoloni
    public function isColorVariantArticleAvailable_OrderList($nurorc)
    {
        $availability = Dscorp::getColorVariantArticleAvailabilityForOrderList($nurorc);

        $is_available = true;
        for ($i = 0; $i < count($availability); $i++) {
            if ($availability[$i]->quanti_c < 0) {
                $is_available = false;
            }
        }

        return $is_available;
    }
    //endregion

    //region Custom discount
    public function getCustomDiscount($order_info = null)
    {
        $numdis = -1;
        $session = Di::getDefault()->get('session');
        $id_usr = $session->get('auth')['id'];

        // DOMANDONA 'Se non c'e' un ordine in corso... ma che cazzo de sconti dovremmo tirare fuori e perche'?'
        //    $isOrder = Octest::findOrderInProgress($id_usr) != null;
        //    if ($isOrder) {
        //      $order_info = Octest::getCurrentOrder($id_usr);
        //      $tpanag = $order_info->tpanag;
        //      $cdanag = $order_info->cdanag;
        //      $nulist = $order_info->nulist;
        //      $cdcata = $order_info->cdcata;
        //      $tpport = $order_info->tpport;
        //      $tppaga = $order_info->tppaga;
        //    } else {
        //      $usrana = B2bUsrana::findFirst(array('id_usr = :id_usr:', 'bind' => array('id_usr' => $id_usr)));
        //      if ($usrana) {
        //        $tpanag = $usrana->tpanag;
        //        $cdanag = $usrana->cdanag;
        //      } else {
        //        $tpanag = null;
        //        $cdanag = null;
        //      }
        //      $nulist = $this->getDefaultNulist($id_usr);
        //      $cdcata = Di::getDefault()->get('session')->get('cdcata');
        //      $tpport = null;
        //      $tppaga = null;
        //    }

        // Se non ce li passano da fuori recupero i dati dell'ordine aperto
        if (empty($order_info) && Octest::findOrderInProgress($id_usr) != null) {
            $order_info = Octest::getCurrentOrder($id_usr);
        }

        // Se non si sono ancora i dati prendiamo degli sconti generici (ndr. me sembra na cazzata!)
        if (empty($order_info)) {
            // Credo che questa serva proprio per prendere tutti gli articoli (del catalogo selezionato) IN SALDO
            $usrana = B2bUsrana::findFirst(array('id_usr = :id_usr:', 'bind' => array('id_usr' => $id_usr)));
            if ($usrana) {
                $tpanag = $usrana->tpanag;
                $cdanag = $usrana->cdanag;
            } else {
                $tpanag = null;
                $cdanag = null;
            }
            $nulist = $this->getDefaultNulist($id_usr);
            $cdcata = $session->get('cdcata');
            $tpport = null;
            $tppaga = null;
        } else {
            $order_info_clone = (array)$order_info;
            $tpanag = $order_info_clone['tpanag'];
            $cdanag = $order_info_clone['cdanag'];
            $nulist = $order_info_clone['nulist'];
            $cdcata = $order_info_clone['cdcata'];
            $tpport = $order_info_clone['tpport'];
            $tppaga = $order_info_clone['tppaga'];
        }

        // Get ALL discount ordered by importance
        $cdhead = B2bDishea::getAllAvailableCustomDiscountCodes($nulist, $cdcata, $tpanag, $cdanag, $tpport, $tppaga);
        // TODO prendiamo il primo sconto, ma potremmo fare di meglio?
        if ($cdhead != null && count($cdhead) > 0) {
            $numdis = $cdhead[0]->numdis;
        }
        return $numdis;
    }

    //  // TODO Cioe'????????
    //  public function getCustomDiscountSummary($tpanag, $cdanag, $nulist, $cdcata) {
    //    $numdis = -1;
    //    // First, get custom discount for current customer (fltota = 0)
    //    $cdhead = B2bDishea::getAllAvailableCustomDiscountCodes($tpanag, $cdanag, $nulist, $cdcata);
    //    if ($cdhead != null && count($cdhead) > 0) {
    //      $numdis = $cdhead[0]->numdis;
    //    } else {
    //      // If custom discount with fltota = 0 doesn't exist, get custom discount for all customers (fltota = 0)
    //      $cdhead = B2bDishea::getAllAvailableGlobalCustomDiscountCodes(
    //        $nulist,
    //        $cdcata
    //      );
    //    }
    //    return $numdis;
    //  }
    //endregion

    //region Custom menu
    public function getCustomMenuItems($cdcata)
    {
        $items = array();
        $customMenuItems = B2bCsmenu::getCustomMenuForCatalog($cdcata);

        foreach ($customMenuItems as $item) {
            if ($item->flsblv == 1) {
                $item->subItems = array();
                switch ($item->tpdato) {
                    case 'BR':
                        $simpleLines = Linmod::getAllLinesFromBrand($cdcata, $item->codic1);
                        foreach ($simpleLines as $line) {
                            $currLine = $line;
                            $currLine->subItems = Sermod::getAllSeriesFromLine($cdcata, $line->cdlinm);
                            $item->subItems[] = $currLine;
                        }
                        break;
                    case 'LM':
                        $item->subItems = Sermod::getAllSeriesFromLine($cdcata, $item->codic1);
                        break;
                    case 'SM':
                    case 'SS':
                    case 'LK':
                    case 'SL':
                        // no sublevels here
                        break;
                    case 'TG':
                        $simpleLines = Linmod::getLinesFilteredByGenreFromCatalog($cdcata, $item->codic1);
                        foreach ($simpleLines as $line) {
                            $currLine = $line;
                            $currLine->subItems = Sermod::getSeriesFilteredByGenreAndLineFromCatalog($cdcata, $item->codic1, $currLine->cdlinm);
                            $item->subItems[] = $currLine;
                        }
                        break;
                    case 'TM':
                        $simpleLines = Linmod::getLinesFilteredByModelTypeFromCatalog($cdcata, $item->codic1);
                        foreach ($simpleLines as $line) {
                            $currLine = $line;
                            $currLine->subItems = Sermod::getSeriesFilteredByModelTypeAndLineFromCatalog($cdcata, $item->codic1, $currLine->cdlinm);
                            $item->subItems[] = $currLine;
                        }
                        break;
                }
            }

            $items[] = $item;
        }

        return $items;
    }
    //endregion

    //region Localization (price, currency, language, ...)
    public function getCurrencySymbol($currency)
    {
        $currencyCode = substr($currency, 0, 3);
        //    $locale = $this->getLocale();//'en-US'; //browser or user locale
        ////    $fmt = new \NumberFormatter($locale . "@currency=$currencyCode", \NumberFormatter::CURRENCY); // work wrong with it_IT
        //    $fmt = new \NumberFormatter('en' . "@currency=$currency", \NumberFormatter::CURRENCY);
        //    $symbol = $fmt->getSymbol(\NumberFormatter::CURRENCY_SYMBOL);
        //    header("Content-Type: text/html; charset=UTF-8;");
        //      return $symbol;

        return (new \NumberFormatter('en@currency=' . $currencyCode, \NumberFormatter::CURRENCY))
            ->getSymbol(\NumberFormatter::CURRENCY_SYMBOL);
    }

    public function getValidCurrencyCode($currencyCode)
    {
        switch (strtolower($currencyCode)) {
            case 'euro':
                $currencyCode = 'EUR';
                break;
        }

        return $currencyCode;
    }

    public function getLocale()
    {
        $locale = (isset($_COOKIE['locale'])) ? $_COOKIE['locale'] : $_SERVER['HTTP_ACCEPT_LANGUAGE'];
        setlocale(LC_ALL, $locale);
        return str_replace('-', '_', substr($locale, 0, 5));
    }

    /**
     * @param $number
     * @param $cdvalu
     * @return array{value: string, value_raw: int|float|string, value_2d: string, currency: string}
     */
    public function formatValue($number, $cdvalu)
    {
        $locale = $this->getLocale();

        $currency = $this->getCurrencySymbol($cdvalu);
        $cdvalu = $this->getValidCurrencyCode($cdvalu);

        $fmt = new \NumberFormatter($locale, \NumberFormatter::CURRENCY);
        $fmt->setSymbol(\NumberFormatter::CURRENCY_SYMBOL, $currency);
        $formatted = $fmt->formatCurrency($number, $cdvalu);

        return array('value' => $formatted, 'value_raw' => $number, 'value_2d' => number_format(floatval($number), 2), 'currency' => $currency);
    }

    public function convertCdnaziToAvailableLocale($cdnazi)
    {
        $availableLocale = ['it', 'en', 'es', 'fr', 'de'];
        $locale = 'it';
        if (!empty($cdnazi)) {
            if (in_array(strtolower($cdnazi), $availableLocale)) {
                $locale = strtolower($cdnazi);
            } else {
                // TODO mappare meglio il collegamento tra nazioni e locale
                // per adesso lascio it
            }
        }
        return $locale;
    }

    public function getFormattedPrice($nulist, $number)
    {
        $lstest = Lstest::findFirstByNulist($nulist);
        return $this->formatValue($number, $lstest != null ? $lstest->cdvalu : 'EUR');
    }

    public function getFormattedPriceWithCdvalu($cdvalu, $number)
    {
        return $this->formatValue($number, $cdvalu);
    }

    public function getFormattedPriceCurrencyPresent($number, $currency, $cdvalu)
    {
        $number = is_numeric($number) ? $number : 0;
        return $this->formatValue($number, $cdvalu);
    }

    public function getLanguage()
    {
        $session = Di::getDefault()->get('session');
        $language = $session->get('language');
        if (!empty($language)) {
            return strtoupper($language);
        } else {

            $user = B2bSysusr::findFirstById($session->get('auth')['id']);
            if ($user) {
                $session->set('language', $user->locale);
                return strtoupper($user->locale);
            } else {
                $session->set('language', 'it');
                return 'IT';
            }
        }
    }
    //endregion

    //region Cookie functions
    public function destroyCookie($cookie)
    {
        $cookie = Di::getDefault()->get('cookies')->get($cookie);

        // Delete the cookie
        $cookie->delete();
    }
    //endregion

    //region Export functions
    public function exportOrder($octest)
    {
        switch ($this->getAppSettings('ExportOrderType')) {
            case 0:
                $this->exportXmlOrder($octest);
                break;
            case 1:
                $this->exportCsvLardiniOrder($octest);
                break;
            case 2:
                $this->exportCsvZanottiOrder($octest);
                break;
            case 3:
                $this->exportNav($octest);
                break;
        }
    }

    /**
     * @param Octest $octest
     * @return void
     * @throws \DOMException
     */
    public function exportXmlOrder($octest)
    {
        $xml = new \DOMDocument();
        $xml->formatOutput = true;
        $xml->preserveWhiteSpace = false;

        // Root node: octest
        $octestParent = $xml->createElement('octest');

        // octest > octest fields as children
        foreach (['nuordc', 'id_usr', 'tpanag', 'cdanag', 'nulist', 'tpordc', 'cdcata', 'cdvett', 'cdstag'] as $field) {
            $octestChild = $xml->createElement($field);
            $octestChild->nodeValue = htmlspecialchars($octest->$field);
            $octestParent->appendChild($octestChild);
        }

        if ($octest->cddesm) {
            $octestChild = $xml->createElement('cddesm');
            $octestChild->nodeValue = htmlspecialchars($octest->cddesm);
            $octestParent->appendChild($octestChild);
        }

        foreach (['tppaga', 'tpport', 'dtcrea', 'dtmcli', 'dtmcoi', 'dtmcof', 'cdcoup'] as $field) {
            $octestChild = $xml->createElement($field);
            $octestChild->nodeValue = $octest->$field ? htmlspecialchars($octest->$field) : '0';
            $octestParent->appendChild($octestChild);
        }

        foreach (['tpindo', 'notcli', 'notazi'] as $field) {
            $octestChild = $xml->createElement($field);
            $value = $octest->$field;
            if ($field === 'notcli') {
                // Dobbiamo aggiustare le intestazioni delle note
                $openingTagPosition = strpos($octest->notcli, "###");
                $closingTagPosition = $openingTagPosition !== false ? strpos($octest->notcli, "###", $openingTagPosition + 3) : false;
                if ($closingTagPosition) {
                    $intestazioniStr = substr($octest->notcli, $openingTagPosition, $closingTagPosition + 3);
                    $value = trim(str_replace($intestazioniStr, '', $octest->notcli));
                    $intestazioniStr = trim(str_replace('###', '', $intestazioniStr));
                    $additionalH = $this->getAppUtils('additional_order_header_notecli');
                    if (!empty($additionalH)) {
                        $intestazioniStr .= "\n" . trim($additionalH);
                    }
                    $intestazioni = explode("\n", $intestazioniStr);
                    if (!empty($intestazioni)) {
                        foreach ($intestazioni as $idx => $intestazione) {
                            // settiamo la lunghezza delle righe di intestazione a minimo 40 per consentire al gestionale di splittarli bene
                            $charMancanti = 40 - (mb_strlen($intestazione, 'utf8') % 40); // 39???
                            if ($charMancanti > 0 && $charMancanti < 40) {
                                $value .= (!empty($value) ? "\n" : '') . $intestazione . str_repeat(' ', $charMancanti);
                            }
                        }
                    }
                }
            }
            $octestChild->nodeValue = $octest->$field ? htmlspecialchars($value) : ' ';
            $octestParent->appendChild($octestChild);
        }

        /** @var B2bOrdadd $additionalPayment */
        foreach ($octest->getAdditionalPayments() as $additionalPayment) {
            $octestChild = $xml->createElement($additionalPayment->addfld);
            $octestChild->nodeValue = htmlspecialchars($additionalPayment->addval);
            $octestParent->appendChild($octestChild);
        }

        // octest > b2b_sysusr
        $sysusrParent = $xml->createElement('sysusr');
        $sysusr = B2bSysusr::findFirstById($octest->id_usr);
        foreach (['id', 'username', 'type'] as $field) {
            $sysusrChild = $xml->createElement($field);
            $sysusrChild->nodeValue = $sysusr->$field ? htmlspecialchars($sysusr->$field) : '0';
            $sysusrParent->appendChild($sysusrChild);
        }
        $octestParent->appendChild($sysusrParent);

        // octest > anagra
        $anagraParent = $xml->createElement('anagra');
        $anagra = Anagra::findCustomerByKey($octest->tpanag, $octest->cdanag);
        foreach (get_object_vars(new Anagra) as $field => $value) {
            $anagraChild = $xml->createElement($field);
            $anagraChild->nodeValue = htmlspecialchars($anagra->$field);
            $anagraParent->appendChild($anagraChild);
        }
        // octest > anagra > desmer
        $desmerParent = $xml->createElement('desmer');
        if ($octest->cddesm) {
            $desmer = Desmer::findFirst(array(
                'tpanag = :tpanag: AND cdanag = :cdanag: AND cddesm = :cddesm:',
                'bind' => array('tpanag' => $octest->tpanag, 'cdanag' => $octest->cdanag, 'cddesm' => $octest->cddesm)
            ));
            foreach (get_object_vars(new Desmer) as $field => $value) {
                $desmerChild = $xml->createElement($field);
                $desmerChild->nodeValue = htmlspecialchars($desmer->$field);
                $desmerParent->appendChild($desmerChild);
            }
        }
        $anagraParent->appendChild($desmerParent);
        $octestParent->appendChild($anagraParent);

        if ($octest->cdcoup) {
            $coupon = B2bCoupon::findFirstByCdcoup($octest->cdcoup);
        }

        // Add every order row
        $occorpRows = Occorp::findByNuordc($octest->nuordc);

        // Counters for email
        $totrow = 0;
        $totitm = 0;
        $totval = 0;

        $hasConfigurator = $this->getAppSettings('ModelDetailStyle') == 5;

        // octest > occorp > octagl, ocperc, ocasso
        foreach ($occorpRows as $occorp) {
            if ($hasConfigurator) {
                if ($occorp->cdcolo == 'CUSTOM') {
                    $ocpert = Ocpert::findFirstByNupers($occorp->cdarti);
                    $cdarti = $ocpert->cdartn;
                } elseif ($occorp->cdcolo == 'DEFCUSTOM') {
                    $cdarti = $occorp->cdarti;
                }
            }

            $occorpParent = $xml->createElement('occorp');

            // octest > occorp > occorp fields as children
            foreach ([
                'nurorc', 'nuordc', 'seqrap', 'cdarti', 'cdcolo', 'cdvari', 'cdcata', 'quanti',
                'seqdet', 'sgrifc', 'tpindo', 'indorc', 'tpnoco', 'dsnoco'
            ] as $field) {
                $occorpChild = $xml->createElement($field);

                if (!$hasConfigurator || $occorp->cdcolo == '' || ($field != 'cdcolo' && $field != 'cdarti')) {
                    if ($field == 'dsnoco' && !empty($occorp->tpnoco)) {
                        $noccom = Noccom::findFirstByTpnoco($occorp->tpnoco);
                        $occorpChild->nodeValue = !empty($noccom) ? $noccom->dsnoco : $occorp->tpnoco;
                    } else if ($field == 'tpindo' && empty($occorp->tpindo)) {
                        $occorpChild->nodeValue = $octest->tpindo;
                    } else {
                        $occorpChild->nodeValue = $occorp->$field ? htmlspecialchars($occorp->$field) : ' ';
                    }
                } else {
                    if ($field == 'cdcolo' && $occorp->cdcolo != '') {
                        $occorpChild->nodeValue = ' ';
                    } else if ($field == 'cdarti' && $occorp->cdcolo != '') {
                        $occorpChild->nodeValue = $cdarti;
                    }
                }
                $occorpParent->appendChild($occorpChild);
            }
            $occorpChild = $xml->createElement('dtmcli');
            $occorpChild->nodeValue = $occorp->dtmcli != "-0001-11-30" && $occorp->dtmcli != "0000-00-00"
                ? htmlspecialchars($occorp->dtmcli)
                : htmlspecialchars($octest->dtmcli);
            $occorpParent->appendChild($occorpChild);

            // octest > occorp > ocperc
            if ($hasConfigurator && $occorp->cdcolo != '') {
                if ($occorp->cdcolo == 'CUSTOM') {
                    $ocperc = Ocperc::findByNupers($occorp->cdarti);
                } else if ($occorp->cdcolo == 'DEFCUSTOM') {
                    $ocperc = Spmate::getDefaultMaterialTypes($occorp->cdarti);
                }
                if (count($ocperc) > 0) {
                    foreach ($ocperc as $item) {
                        $ocpercParent = $xml->createElement('ocperc');

                        $ocpercChild = $xml->createElement('tpcomp');
                        $ocpercChild->nodeValue = !empty($item) ? htmlspecialchars($item->tpcomp) : ' ';
                        $ocpercParent->appendChild($ocpercChild);

                        $ocpercChild = $xml->createElement('cdmate');
                        $ocpercChild->nodeValue = !empty($item) ? htmlspecialchars($item->cdmate) : ' ';
                        $ocpercParent->appendChild($ocpercChild);

                        $occorpParent->appendChild($ocpercParent);
                    }
                }
            }

            // octest > occorp > octagl
            $octaglRows = Octagl::getTotalSizesQuantity($occorp->nurorc);
            foreach ($octaglRows as $octagl) {
                $octaglParent = $xml->createElement('octagl');

                foreach (['dstagl', 'quanti'] as $field) {
                    $octaglChild = $xml->createElement($field);
                    $octaglChild->nodeValue = htmlspecialchars($octagl->$field);
                    $octaglParent->appendChild($octaglChild);
                }

                $totitm += $octagl->quanti;

                // Get price/discounts hierarchy
                $ocproc = Ocproc::findFirst(array(
                    'nuordc = :nuordc: AND cdarti = :cdarti:',
                    'bind' => array('nuordc' => $octest->nuordc, 'cdarti' => $occorp->cdarti)
                ));

                $octaglChild = $xml->createElement('prezzo');
                $prezzo = $ocproc != null && $ocproc->prezzo > 0 ? $ocproc->prezzo : $octagl->prezzo;
                // Coupon should be applied after all discounts, so I put it on scont2
                //if ($octest->cdcoup && $coupon->tpcoup == 1) {
                //  $prezzo = $octagl->prezzo * (1 - $coupon->impsco / 100);
                //}
                $octaglChild->nodeValue = htmlspecialchars($prezzo);
                $octaglParent->appendChild($octaglChild);

                // Calcoliamo gli sconti in maniera scalare 1,2,3
                if ($octest->cdcoup && !empty($coupon) && $coupon->tpcoup == 1) {
                    $octagl->scont2 = $coupon->impsco;
                }

                $sconti = [
                    $ocproc != null && $ocproc->scont1 > 0 ? $ocproc->scont1 : $octagl->scont1,
                    $ocproc != null && $ocproc->scont2 > 0 ? $ocproc->scont2 : $octagl->scont2,
                    $ocproc != null && $ocproc->scont3 > 0 ? $ocproc->scont3 : $octagl->scont3,
                ];

                // poi rimuoviamo i vuoti per far scalare in alto quelli presenti
                $sconti = array_values(array_filter($sconti));

                $octaglChild = $xml->createElement('scont1');
                $scont1 = (isset($sconti[0])) ? $sconti[0] : 0;
                $octaglChild->nodeValue = htmlspecialchars($scont1);
                $octaglParent->appendChild($octaglChild);

                $octaglChild = $xml->createElement('scont2');
                $scont2 = (isset($sconti[1])) ? $sconti[1] : 0;
                $octaglChild->nodeValue = htmlspecialchars($scont2);
                $octaglParent->appendChild($octaglChild);

                $octaglChild = $xml->createElement('scont3');
                $scont3 = (isset($sconti[2])) ? $sconti[2] : 0;
                $octaglChild->nodeValue = htmlspecialchars($scont3);
                $octaglParent->appendChild($octaglChild);

                $totval += $octagl->quanti * $prezzo * (1 - $scont1 / 100) * (1 - $scont2 / 100) * (1 - $scont3 / 100);
                $occorpParent->appendChild($octaglParent);
            }

            // octest > occorp > ocasso
            $ocassoRows = Ocasso::findByNurorc($occorp->nurorc);
            foreach ($ocassoRows as $ocasso) {
                $ocassoParent = $xml->createElement('ocasso');

                foreach (['cdasso', 'quanti'] as $field) {
                    $ocassoChild = $xml->createElement($field);
                    $ocassoChild->nodeValue = htmlspecialchars($ocasso->$field);
                    $ocassoParent->appendChild($ocassoChild);
                }

                $occorpParent->appendChild($ocassoParent);
            }

            $octestParent->appendChild($occorpParent);

            $totrow++;
        }

        $xml->appendChild($octestParent);

        $date = new \DateTime();
        $filename = 'ord' . $octest->nuordc . '_' . $date->format('YmdHis') . '.xml';

        // Double copy on io/xml/orders and io/export
        if (!file_exists('./io/xml/orders')) {
            if (!file_exists('./io/xml')) {
                mkdir('./io/xml', 0777, true);
            }
            mkdir('./io/xml/orders', 0777, true);
        }

        $filePath = './io/xml/orders/' . $filename;
        $xml->save($filePath);
        chmod($filePath, 0777);

        if (!file_exists('./io/export')) {
            mkdir('./io/export', 0777, true);
        }
        $filePath = './io/export/' . $filename;
        $xml->save($filePath);
        chmod($filePath, 0777);

        if ($this->getAppSettings('SendEmailWhenClosingOrder') > 0) {
            $this->prepareAndSendOrderEmail($octest, $anagra, $totval, $totitm, $totrow);
        }
    }

    /**
     * Invio ordine a NAV e poi converto con altra chiamata BC
     * @param Octest $octest
     * @return void
     */
    public function exportNav($octest)
    {
        return true;
        $di = \Phalcon\DI::getDefault();

        $tentativiCicliMassimi = 3;
        $currentCiclo = 0;

        try {
            $api = new ApiKOC();
            $objOcTest = $api->sendHeader($octest);

            if ($objOcTest instanceof Octest) {
                $api->sendLines($objOcTest);
            }

            //sleep(2);
            //while di controllo per poi inviare XML su SOAP
            $oc = $di->get('db')->query(
                "SELECT
                    * 
                FROM
                    occorp
                    LEFT JOIN octagl ON octagl.nurorc = occorp.nurorc 
                WHERE
                    nuordc = :nu
                    AND octagl.uuid IS NULL 
                    AND octagl.quanti > 0",
                array(
                    "nu" => $objOcTest->nuordc
                )
            )->fetchAll();

            while ($oc && $currentCiclo < $tentativiCicliMassimi) {
                $di->get('logger')->info("GIRO " . $currentCiclo . PHP_EOL);
                $api->sendLines($objOcTest);
                $currentCiclo += 1;
                $oc->refresh();
            }

            if ($currentCiclo == $tentativiCicliMassimi) {
                $message = "HO RAGGIUNTO IL MASSIMO DI TENATIVI PER L'ORDINE N." . $objOcTest->nuordc;
                $di->get('logger')->error($message);
                throw new \Exception($message);
                exit;
            }

            if ($oc instanceof Octagl) {
                $oc = $oc->refresh();
            }

            if ($oc == false) {
                $api->sendToBC($objOcTest);
                //echo "OPERAZIONE TERMINATA - ORDINE N. " . $objOcTest->nuordc . " inviato" . PHP_EOL;
            }
        } catch (\Exception $e) {
            $di->get('logger')->error($e->getMessage());
        }
    }

    public function filter_filename($filename, $beautify = true)
    {
        // sanitize filename
        // [<>:"/\\|?*]|            # file system reserved https://en.wikipedia.org/wiki/Filename#Reserved_characters_and_words
        // [\x00-\x1F]|             # control characters http://msdn.microsoft.com/en-us/library/windows/desktop/aa365247%28v=vs.85%29.aspx
        // [\x7F\xA0\xAD]|          # non-printing characters DEL, NO-BREAK SPACE, SOFT HYPHEN
        // [#\[\]@!$&\'()+,;=]|     # URI reserved https://tools.ietf.org/html/rfc3986#section-2.2
        // [{}^\~`]                 # URL unsafe characters https://www.ietf.org/rfc/rfc1738.txt
        $filename = preg_replace(
            '~
      [<>:"/\\|?*]|
      [\x00-\x1F]|
      [\x7F\xA0\xAD]|
      [#\[\]@!$&\'()+,;=]|
      [{}^\~`]
      ~x',
            '-',
            $filename
        );
        // avoids ".", ".." or ".hiddenFiles"
        $filename = ltrim($filename, '.-');
        // optional beautification
        if ($beautify)
            $filename = $this->beautify_filename($filename);
        // maximize filename length to 255 bytes http://serverfault.com/a/9548/44086
        $ext = pathinfo($filename, PATHINFO_EXTENSION);
        $filename = mb_strcut(pathinfo($filename, PATHINFO_FILENAME), 0, 255 - ($ext ? strlen($ext) + 1 : 0), mb_detect_encoding($filename)) . ($ext ? '.' . $ext : '');
        return $filename;
    }

    private function beautify_filename($filename)
    {
        // reduce consecutive characters
        $filename = preg_replace(array(
            // "file   name.zip" becomes "file-name.zip"
            '/ +/',
            // "file___name.zip" becomes "file-name.zip"
            '/_+/',
            // "file---name.zip" becomes "file-name.zip"
            '/-+/'
        ), '-', $filename);
        $filename = preg_replace(array(
            // "file--.--.-.--name.zip" becomes "file.name.zip"
            '/-*\.-*/',
            // "file...name..zip" becomes "file.name.zip"
            '/\.{2,}/'
        ), '.', $filename);
        // lowercase for windows/unix interoperability http://support.microsoft.com/kb/100625
        $filename = mb_strtolower($filename, mb_detect_encoding($filename));
        // ".file-name.-" becomes "file-name"
        $filename = trim($filename, '.-');
        return $filename;
    }

    public function exportCsvLardiniOrder($octest)
    {
        $ordering = $this->getAppSettings('ParamTypeOrdering');
        $splitType = $this->getAppSettings('SplitLardiniOrderCsv');

        $rows = Octest::getOrderForLardiniCsv($octest->nuordc, $ordering);

        $rowEmpty1 = '  ;';
        $rowEmpty1 .= '                              ;';
        $rowEmpty1 .= '                              ;';
        $rowEmpty1 .= '                              ;';
        $rowEmpty1 .= '                              ;';
        $rowEmpty1 .= '                              ;';
        $rowEmpty1 .= '                              ;';

        $rowEmpty2 = '  ;';
        $rowEmpty2 .= '                              ;';
        $rowEmpty2 .= '                              ;';
        $rowEmpty2 .= '                              ;';
        $rowEmpty2 .= '                              ;';

        // Counters for email
        $totrow = count($rows);
        $totitm = 0;
        $totval = 0;

        $diskManager = new DiskManager();

        $i = 0;
        $csvIndex = 1;
        $currentCddrop = $rows[0]['cddrop'];
        $currentCddesm = $rows[0]['cddesm'];
        $currentCdlinm = $rows[0]['cdlinm'];
        $orderTxt = '';
        foreach ($rows as $row) {
            if (
                ($i % 99 == 0 && $i != 0) ||
                ($splitType == 0 && $currentCddrop != $row['cddrop']) ||
                $currentCddesm != $row['cddesm'] ||
                $currentCdlinm != $row['cdlinm']
            ) {
                $filename = 'ord' . $octest->nuordc . '-' . $octest->cdcata . '-' . $rows[0]['desvid'] . '-';
                $filename .= ($currentCddesm > 0 ? $currentCddesm : '0') . '-' . $currentCdlinm . '-' . $currentCddrop . '-' . $csvIndex . '.csv';
                $filename = $this->filter_filename($filename);
                $diskManager->writeCsvExportOrders($filename, $orderTxt);
                $orderTxt = '';

                if ($i % 99 == 0) {
                    $csvIndex++;
                }

                if ($splitType == 0 && $currentCddrop != $row['cddrop']) {
                    $currentCddrop = $row['cddrop'];
                    $currentCddesm = $row['cddesm'];
                    $currentCdlinm = $row['cdlinm'];
                    $csvIndex = 1;
                    $i = 0;
                } else if ($currentCddesm != $row['cddesm']) {
                    $currentCddesm = $row['cddesm'];
                    $currentCdlinm = $row['cdlinm'];
                    $csvIndex = 1;
                    $i = 0;
                } else if ($currentCdlinm != $row['cdlinm']) {
                    $currentCdlinm = $row['cdlinm'];
                    $csvIndex = 1;
                    $i = 0;
                }
            }

            if (!empty($this->getAppUtils('lar_date_ddmmyy'))) {
                $defaultDtmcli = $this->getAppUtils('lar_date_ddmmyy');
            } else {
                $defaultDtmcli = !empty(substr($row['dtmcli'], 0, 6))
                    ? substr($row['dtmcli'], 0, 6)
                    : '';
            }
            $cdstag = str_pad(substr($row['cdstag'], 0, 4), 4, ' ');
            $cdlinm = str_pad(substr($row['cdlinm'], 0, 4), 4, '0', STR_PAD_LEFT);
            $cdanag = str_pad(substr($row['cdanag'], 0, 8), 8, '0', STR_PAD_LEFT);
            $cdagen = str_pad(substr($row['cdagen'], 0, 4), 4, '0', STR_PAD_LEFT);
            $nuordc = str_pad(substr($row['nuordc'], 0, 5), 5, '0', STR_PAD_LEFT);
            $dtcrea = str_pad(substr($row['dtcrea'], 0, 6), 6, ' ');
            $cdartn = str_pad(substr($row['cdartn'] . $row['cdvari'], 0, 10), 10, ' ');
            $cdpers = str_pad(substr($row['cdpers'], 0, 14), 14, ' ');
            $cdcolo = str_pad(substr($row['cdcolo'], 0, 5), 5, ' ');
            $quan01 = str_pad(substr($row['tg1'], 0, 6), 6, '0', STR_PAD_LEFT);
            $quan02 = str_pad(substr($row['tg2'], 0, 6), 6, '0', STR_PAD_LEFT);
            $quan03 = str_pad(substr($row['tg3'], 0, 6), 6, '0', STR_PAD_LEFT);
            $quan04 = str_pad(substr($row['tg4'], 0, 6), 6, '0', STR_PAD_LEFT);
            $quan05 = str_pad(substr($row['tg5'], 0, 6), 6, '0', STR_PAD_LEFT);
            $quan06 = str_pad(substr($row['tg6'], 0, 6), 6, '0', STR_PAD_LEFT);
            $quan07 = str_pad(substr($row['tg7'], 0, 6), 6, '0', STR_PAD_LEFT);
            $quan08 = str_pad(substr($row['tg8'], 0, 6), 6, '0', STR_PAD_LEFT);
            $quan09 = str_pad(substr($row['tg9'], 0, 6), 6, '0', STR_PAD_LEFT);
            $quan10 = str_pad(substr($row['tg10'], 0, 6), 6, '0', STR_PAD_LEFT);
            $prezzo = str_pad(substr($row['prezzo'], 0, 13), 13, '0', STR_PAD_LEFT);
            $dtmcli = str_pad($defaultDtmcli, 6, ' ');
            //$dtmcli = '150121';
            $sanitizedNotes = $row['notcli'];
            $sanitizedNotes = str_replace(';', ',', $sanitizedNotes);
            $sanitizedNotes = str_replace("\r", ' ', $sanitizedNotes);
            $sanitizedNotes = str_replace("\n", ' ', $sanitizedNotes);
            $sanitizedNotes = str_replace("\t", ' ', $sanitizedNotes);
            $notcli1 = str_pad(substr($sanitizedNotes, 0, 30), 30, ' ');
            $notcli2 = str_pad(substr($sanitizedNotes, 30, 30), 30, ' ');

            $orderTxt .=
                $cdstag . ';' . $cdlinm . ';' . $cdanag . ';' . $cdagen . ';' .
                $nuordc . ';' . $dtcrea . ';' . $cdartn . ';' . $cdpers . ';' .
                $cdcolo . ';' . $quan01 . ';' . $quan02 . ';' . $quan03 . ';' .
                $quan04 . ';' . $quan05 . ';' . $quan06 . ';' . $quan07 . ';' .
                $quan08 . ';' . $quan09 . ';' . $quan10 . ';' . $prezzo . ';' .
                $dtmcli . ';' . $rowEmpty1 . $notcli1 . ';' . $notcli2 . ';' .
                $rowEmpty2 . PHP_EOL;

            $totrow = $row['tg1'] + $row['tg2'] + $row['tg3'] + $row['tg4'];
            $totrow += ($row['tg5'] + $row['tg6'] + $row['tg7'] + $row['tg8']);
            $totrow += ($row['tg9'] + $row['tg10']);

            $totitm += $totrow;
            $totval += $row['prezzo'];

            $i++;
        }

        // Write last one
        $filename = 'ord' . $octest->nuordc . '-' . $octest->cdcata . '-' . $rows[0]['desvid'] . '-';
        $filename .= ($currentCddesm > 0 ? $currentCddesm : '0') . '-' . $currentCdlinm . '-' . $currentCddrop . '-' . $csvIndex . '.csv';
        $filename = $this->filter_filename($filename);
        $diskManager->writeCsvExportOrders($filename, $orderTxt);

        if ($this->getAppSettings('SendEmailWhenClosingOrder') > 0) {
            $anagra = Anagra::findCustomerByKey($octest->tpanag, $octest->cdanag);

            $this->prepareAndSendOrderEmail($octest, $anagra, $totval, $totitm, $totrow);

            if ($this->getAppSettings('SendEmailWhenClosingOrder') == 3) {
                $this->sendNotificationMail($octest, $anagra, $totval, $totitm, $totrow);
            }
        }
    }

    public function exportCsvZanottiOrder($octest)
    {
        $rows = Octest::getOrderForZanottiCsv($octest->nuordc);

        $order1Txt = ''; // Not available items
        $order2Txt = ''; // Available items
        $orderHeaderTxt = '';

        $totrow = count($rows);
        $totitm = 0;
        $totval = 0;

        $isSpecial = B2bAddinf::isSpecialAgent($octest->id_usr);

        foreach ($rows[0] as $key => $value) {
            $orderHeaderTxt .= is_numeric($key) ? '' : $key . ';';
        }
        $orderHeaderTxt .= $isSpecial ? "\r\n" : "\n";

        foreach ($rows as $row) {
            foreach ($row as $key => $value) {
                if (!is_numeric($key) && $key != 'availability') {
                    if ($row['availability'] == 0) {
                        $order1Txt .= $value . ';';
                    } else {
                        $order2Txt .= $value . ';';
                    }
                }
            }

            if ($row['availability'] == 0) {
                $order1Txt .= $isSpecial ? "\r\n" : "\n";
            } else {
                $order2Txt .= $isSpecial ? "\r\n" : "\n";
            }

            $totitm += intval($row['tot_pairs']);
            $totval += (intval($row['tot_pairs']) *
                floatval(str_replace(',', '.', $row['prezzo_unit'])) *
                (1 - (floatval(str_replace(',', '.', $row['perc_sconto'])) / 100)));
        }

        $date = new \DateTime();

        $diskManager = new DiskManager();
        if (!empty($order1Txt)) {
            $filename = $date->format('Ymd') . '_' . $octest->nuordc . '_b2b_1.csv';
            $diskManager->writeCsvExportOrders($filename, $orderHeaderTxt . $order1Txt, $isSpecial);
        }
        if (!empty($order2Txt)) {
            $filename = $date->format('Ymd') . '_' . $octest->nuordc . '_b2b_2.csv';
            $diskManager->writeCsvExportOrders($filename, $orderHeaderTxt . $order2Txt, $isSpecial);
        }

        if ($this->getAppSettings('SendEmailWhenClosingOrder') > 0) {
            $anagra = Anagra::findCustomerByKey($octest->tpanag, $octest->cdanag);
            $this->prepareAndSendOrderEmail($octest, $anagra, $totval, $totitm, $totrow);
        }
    }

    public function getAgentRecipients($id_usr)
    {
        $recipients = null;
        if ($this->getAppSettings('SendEmailWhenClosingOrder') == 2) {
            $user = B2bSysusr::findFirstById($id_usr);
            $indema = '';
            if ($user->type == 3) {
                $indema = B2bAddinf::getEmailForAgentFromUserId($id_usr);
            } else if ($user->type == 4) {
                $indema = B2bAddinf::getEmailForAgentFromCustomerUserId($id_usr);
            }
            if ($indema != '') {
                $recipients = explode(';', $indema);
            }
        }
        return $recipients;
    }

    public function prepareAndSendOrderEmail($octest, $anagra, $totval, $totitm, $totrow)
    {
        $order_date = explode("-", $octest->dtcrea);
        $dtcrea = $order_date[2] . '/' . $order_date[1] . '/' . $order_date[0];
        $nuordc = $octest->nuordc;
        $valuta = $this->getCurrencySymbol($anagra->cdvalu);
        $prezzo = $this->getFormattedPriceCurrencyPresent($totval, $valuta, $anagra->cdvalu);
        $totval = $prezzo['value'];

        $sender = $this->getAppUtils('company_extended');
        $octest = Octest::getGenericOrderFromNuordc($nuordc);
        $recipient = $octest->indema;
        $subject = self::getTranslatorFor()->_('_common.order') . ' #' . $nuordc;
        $subject .= ' - ' . $octest->cdcata . ' ' . $octest->dscata;
        $subject .= ' - ' . self::getTranslatorFor()->_($octest->tpordc == 0 ? 'order.availability' : 'order.reservation');
        $content = self::getTranslatorFor()->_(
            '_common.order.pdf',
            array(
                'nuordc' => $nuordc, 'dtcrea' => $dtcrea, 'totrow' => $totrow,
                'totitm' => $totitm, 'totval' => $totval, 'valuta' => $valuta,
                'link' => '<a href="https://' . $_SERVER['HTTP_HOST'] . '">https://' . $_SERVER['HTTP_HOST'] . '</a>',
                'company' => $this->getAppUtils('company_extended'),
                'phone' => $this->getAppUtils('tel'),
                'email' => $this->getAppUtils('email')
            )
        );

        $desvid = $anagra->desvid;
        $indema = $anagra->indema;

        $recipients = $this->getAgentRecipients($octest->id_usr);

        $this->sendEmail($sender, $recipient, $subject, $content, $recipients);
    }

    public function sendNotificationMail($octest, $anagra, $totval, $totitm, $totrow)
    {
        $nuordc = $octest->nuordc;

        $sender = $this->getAppUtils('company_extended');
        $anagra = Anagra::findCustomerByKey($octest->tpanag, $octest->cdanag);
        $text = Di::getDefault()->get('config')->release->user . ' - ';
        $text .= self::getTranslatorFor()->_('_common.order') . ' #' . $nuordc . ' - ';
        $text .= $anagra->desvid . ' - ' . $octest->cdcata;
        $subject = $content = $text;

        $recipient = '';
        $recipients = explode(';', $this->getAppUtils('email_for_notifyorder'));
        if (count($recipients) > 0 && $recipients[0] != '') {
            $recipient = $recipients[0];
            // Remove To recipients from BCC recipients
            unset($recipients[0]);
        }

        $attachment = realpath('..') . '/public/pdf/' . (new PdfController)->createOrderPdf($octest->nuordc, $octest->id_usr);

        $this->sendEmail($sender, $recipient, $subject, $content, $recipients, $attachment);
    }
    //endregion

    //region Budget functions
    public function getFixedBudgets($rawBudgets, $tpanag, $cdanag)
    {
        $budgets = array();

        if (!empty($rawBudgets) && count($rawBudgets) > 0) {
            $currentNubudg = $rawBudgets[0]['nubudg'];
            $budgets[$currentNubudg] = new \stdClass;
            $budgets[$currentNubudg]->nubudg = $rawBudgets[0]['nubudg'];
            $budgets[$currentNubudg]->cdstag = $rawBudgets[0]['cdstag'];
            $budgets[$currentNubudg]->dsstag = $rawBudgets[0]['dsstag'];
            $budgets[$currentNubudg]->cdtitl = $rawBudgets[0]['cdtitl'];
            $budgets[$currentNubudg]->dstitl = $rawBudgets[0]['dstitl'];
            $budgets[$currentNubudg]->cdlinm = $rawBudgets[0]['cdlinm'];
            $budgets[$currentNubudg]->dslinm = $rawBudgets[0]['dslinm'];
            $budgets[$currentNubudg]->cdserm = $rawBudgets[0]['cdserm'];
            $budgets[$currentNubudg]->dsserm = $rawBudgets[0]['dsserm'];
            $budgets[$currentNubudg]->cduscc = $rawBudgets[0]['cduscc'];
            $budgets[$currentNubudg]->dsuscc = $rawBudgets[0]['dsuscc'];
            $budgets[$currentNubudg]->qtabdg = $rawBudgets[0]['qtabdg'];
            $budgets[$currentNubudg]->valbdg = $rawBudgets[0]['valbdg'];
            $budgets[$currentNubudg]->qtatrg = $rawBudgets[0]['qtatrg'];
            $budgets[$currentNubudg]->valtrg = $rawBudgets[0]['valtrg'];
            $budgets[$currentNubudg]->totstg = 0;
            $budgets[$currentNubudg]->currentSituation = Octagl::getCurrentSituationForBudget(
                $tpanag,
                $cdanag,
                $budgets[$currentNubudg]->cdstag,
                $budgets[$currentNubudg]->cduscc,
                $budgets[$currentNubudg]->cdtitl,
                $budgets[$currentNubudg]->cdlinm,
                $budgets[$currentNubudg]->cdserm
            );

            $index = 1;
            for ($i = 0; $i < count($rawBudgets); $i++) {
                if ($rawBudgets[$i]['nubudg'] != $currentNubudg) {
                    $index = 1;
                    $currentNubudg = $rawBudgets[$i]['nubudg'];
                    $budgets[$currentNubudg] = new \stdClass;
                    $budgets[$currentNubudg]->nubudg = $rawBudgets[$i]['nubudg'];
                    $budgets[$currentNubudg]->cdstag = $rawBudgets[$i]['cdstag'];
                    $budgets[$currentNubudg]->dsstag = $rawBudgets[$i]['dsstag'];
                    $budgets[$currentNubudg]->cdtitl = $rawBudgets[$i]['cdtitl'];
                    $budgets[$currentNubudg]->dstitl = $rawBudgets[$i]['dstitl'];
                    $budgets[$currentNubudg]->cdlinm = $rawBudgets[$i]['cdlinm'];
                    $budgets[$currentNubudg]->dslinm = $rawBudgets[$i]['dslinm'];
                    $budgets[$currentNubudg]->cdserm = $rawBudgets[$i]['cdserm'];
                    $budgets[$currentNubudg]->dsserm = $rawBudgets[$i]['dsserm'];
                    $budgets[$currentNubudg]->cduscc = $rawBudgets[$i]['cduscc'];
                    $budgets[$currentNubudg]->dsuscc = $rawBudgets[$i]['dsuscc'];
                    $budgets[$currentNubudg]->qtabdg = $rawBudgets[$i]['qtabdg'];
                    $budgets[$currentNubudg]->valbdg = $rawBudgets[$i]['valbdg'];
                    $budgets[$currentNubudg]->qtatrg = $rawBudgets[$i]['qtatrg'];
                    $budgets[$currentNubudg]->valtrg = $rawBudgets[$i]['valtrg'];
                    $budgets[$currentNubudg]->totstg = 0;
                    $budgets[$currentNubudg]->currentSituation = Octagl::getCurrentSituationForBudget(
                        $tpanag,
                        $cdanag,
                        $budgets[$currentNubudg]->cdstag,
                        $budgets[$currentNubudg]->cduscc,
                        $budgets[$currentNubudg]->cdtitl,
                        $budgets[$currentNubudg]->cdlinm,
                        $budgets[$currentNubudg]->cdserm
                    );
                }

                $budgets[$currentNubudg]->totstg++;

                $cdstag = 'cdstg' . $index;
                $dsstag = 'dsstg' . $index;
                $qtastg = 'qtast' . $index;
                $valstg = 'valst' . $index;

                $budgets[$currentNubudg]->$cdstag = $rawBudgets[$i]['stgcmp'];
                $budgets[$currentNubudg]->$dsstag = $rawBudgets[$i]['dstcmp'];
                $budgets[$currentNubudg]->$qtastg = $rawBudgets[$i]['qtacmp'];
                $budgets[$currentNubudg]->$valstg = $rawBudgets[$i]['valcmp'];
                $index++;
            }
        }

        return $budgets;
    }

    private function getBudgets($nuordc, $tpanag, $cdanag)
    {
        $fullBudgets = array(
            'line' => array(),
            'drop' => array()
        );

        $dropIndexes = B2bBgtest::getSortedBudgetsFromOrder($nuordc, false);
        $lineIndexes = B2bBgtest::getSortedBudgetsFromOrder($nuordc, true);

        $rawBudgets = B2bBgtest::getBudgetInfoFromOrder($nuordc);
        $budgets = $this->getFixedBudgets($rawBudgets, $tpanag, $cdanag);

        if (!empty($budgets) && count($budgets) > 0) {
            for ($i = 0; $i < count($dropIndexes); $i++) {
                $fullBudgets['drop'][$i] = $budgets[$dropIndexes[$i]->nubudg];
            }
            for ($i = 0; $i < count($lineIndexes); $i++) {
                $fullBudgets['line'][$i] = $budgets[$lineIndexes[$i]->nubudg];
            }
        }

        return $fullBudgets;
    }
    //endregion

    /**
     * Assuming the platform supports 64 bits integers, which it does.
     * @return int
     * @see https://stackoverflow.com/a/25559420
     * */
    function microseconds()
    {
        $mt = explode(' ', microtime());
        return intval($mt[1] * 1E6) + intval(round($mt[0] * 1E6));
    }

    /**
     * @param int $watch
     */
    function TIMEIT(&$watch)
    {
        $watch = $this->microseconds();
    }

    /**
     * @param int $watch
     * @return int
     */
    function TIMEND(&$watch)
    {
        $temp = $watch;
        $watch = $this->microseconds();
        return $watch - $temp;
    }

    /**
     * @param int $watch
     * @param string $message
     * @return string
     */
    function logInterval(&$watch, $message)
    {
        return str_pad($this->TIMEND($watch), 8, ' ', STR_PAD_LEFT) . ' microseconds to complete ' . $message;
    }

    //region Common functions
    public function getCommonData($context, $id_usr = -1)
    {
        $res = array();

        //        $loggerine = DI::getDefault()->get('logger');

        /** @see https://docs.phalcon.io/3.4/api/Phalcon_Logger/#class-phalconloggerformatterline */
        /** @see https://github.com/phalcon/cphalcon/blob/v3.4.0/phalcon/logger/formatter/line.zep */
        //        $formatter = new LineFormatter('[%date%][%type%] %message%', 'D, d M y H:i:s.u O');
        //        $formatter->setDateFormat('D, d M y H:i:s.u O');
        //        $loggerine->setFormatter($formatter);
        //        $loggerine->info("LOGGGGGGGGGGGGINGGGGGGGGGGGGG");
        //        $loggerine->debug(json_encode(debug_backtrace(), JSON_PRETTY_PRINT));

        //        $watch = 0;
        //        $this->TIMEIT($watch);
        //        $loggerine->info($this->logInterval($watch,  "getSelectedCatalog"));

        $catalogs = $this->getAvailableCatalogs($id_usr);
        $ctlg_ok = $catalogs != null && count($catalogs) > 0;

        $order_info = self::getOrderInfo($id_usr);
        $isOrder = $order_info != null;

        /** @var \Phalcon\Session\AdapterInterface $session */
        $session = Di::getDefault()->get('session');
        $language = $session->get('language');
        $idlang = $language !== null && !empty($language) ? strtoupper($language) : 'IT';
        $catalogAccessType = $this->getAppSettings('CatalogAccessType');
        if ($session->has('ctl_view_mode')) {
            $catalogAccessType = $session->get('ctl_view_mode') === 'list' ? 1 : 0;
        }

        $selected_catalog = $this->getSelectedCatalog($isOrder, $order_info, $catalogs);
        $exist = isset($selected_catalog->cdcata) && Cttest::findFirstByCdcata($selected_catalog->cdcata) != null;

        $nulist = $isOrder && !empty($order_info->nulist) ? $order_info->nulist : $this->getDefaultNulist($id_usr);
        $lstest = Lstest::findFirstByNulist($nulist);
        $cdvalu = $lstest->cdvalu;
        $currency = $this->getCurrencySymbol($lstest->cdvalu);

        $user = B2bSysusr::findFirstById($id_usr);
        if ($user->type == 3 && $this->getAppSettings('PriceListsManagementForAgent') == 1) {
            $cdagen = B2bUsrage::findFirstByIdUsr($id_usr)->cdagen;
            $priceLists = Lstest::getAllAvailablePriceListsForAgent($cdagen);
        } else {
            $priceLists = Lstest::getAllAvailablePriceLists();
        }

        $customers = array();
        $destinations = array();
        $sales = array();
        $fullBudgets = array(
            'line' => array(),
            'drop' => array(),
        );
        if ($isOrder) {
            $brands = Titlin::getAllAvailableBrandsFromCatalog($exist ? $selected_catalog->cdcata : $order_info->cdcata);
            $lookbooks = Lktest::getAllLookbooksFromCatalog($exist ? $selected_catalog->cdcata : $order_info->cdcata);
            $sales = $this->getSalesModels($exist ? $selected_catalog->cdcata : $order_info->cdcata, $order_info, $this->getAppSettings('ParamShowNotAvailableItems'));
            $lines = count($brands) > 1 ? $this->getLinesFromBrands($brands, $exist ? $selected_catalog->cdcata : $order_info->cdcata) : $this->getLines($exist ? $selected_catalog->cdcata : $order_info->cdcata);
            $series = count($brands) > 1 ? array() : $this->getSeriesFromLines($lines, $exist ? $selected_catalog->cdcata : $order_info->cdcata);
            if ($this->getAppSettings('BudgetManagement') == 2) {
                $fullBudgets = $this->getBudgets($order_info->nuordc, $order_info->tpanag, $order_info->cdanag);
            }
        } else {
            $brands = $ctlg_ok ? Titlin::getAllAvailableBrandsFromCatalog($exist ? $selected_catalog->cdcata : $catalogs[0]->cdcata) : array();
            $lookbooks = $ctlg_ok ? Lktest::getAllLookbooksFromCatalog($exist ? $selected_catalog->cdcata : $catalogs[0]->cdcata) : array();
            $lines = $ctlg_ok && count($brands) > 0
                ? (count($brands) > 1 ? $this->getLinesFromBrands($brands, $exist ? $selected_catalog->cdcata : $catalogs[0]->cdcata) : $this->getLines($exist ? $selected_catalog->cdcata : $catalogs[0]->cdcata))
                : array();
            $series = !$ctlg_ok || count($brands) > 1 ? array() : $this->getSeriesFromLines($lines, $exist ? $selected_catalog->cdcata : $catalogs[0]->cdcata);

            switch ($user->type) {
                case 1:
                case 2:
                    // impossible to get here
                    break;
                case 3:
                    // agent
                    $isHeadquarter = Anaage::isHeadquarterAgent($id_usr);
                    if ($isHeadquarter) {
                        $customers = Anagra::getAllCustomers();
//                        $destinations = Desmer::getShippingsForHeadquarterAgentUser();
                    } else {
                        $usrage = B2bUsrage::findFirst(array('id_usr = :id_usr:', 'bind' => array('id_usr' => $id_usr)));
                        $customers = Anagra::getAllCustomersForAgent($usrage->cdagen);
//                        $destinations = Desmer::getShippingsForAgentUser($id_usr);
                    }
                    break;
                case 4:
                    // customer
                    $customers = Anagra::getCustomersFromUser($id_usr, $idlang);
//                    if (count($customers) == 1) {
//                        $destinations = Desmer::getShippingsForCustomer($customers[0]->tpanag, $customers[0]->cdanag);
//                    }
                    break;
                case 5:
                    // goods destination
                    $customers = Anagra::getCustomersForShippingUser($id_usr);
//                    $destinations = Desmer::getShippingsForShippingUser($id_usr);
                    break;
            }
        }

        // Indicative management
        $manageIndicative = $this->getAppSettings('ParamIndicativeManagement');
        if ($isOrder) {
            $tpindo = Anagra::getDefaultIndicativeForCustomer($order_info->tpanag, $order_info->cdanag);
            $indicatives = $tpindo != '' ? Indorc::findByTpindo($tpindo) : Indorc::find();
        } else {
            $indicatives = $manageIndicative > 0 ? Indorc::find() : array();
        }

        // Navbar Content
        $navbarContent = $this->getAppSettings('NavbarContent');
        $customMenu = array();
        switch ($navbarContent) {
            case 1:
                $modelTypes = Tpmode::getAllArticleModelTypesFromCatalog($selected_catalog->cdcata, array('lang' => strtolower($idlang), 'from' => 'all'));
                $genres = array();
                break;
            case 2:
                $modelTypes = array();
                $genres = array();
                $simpleGenres = Tpgene::getAllArticleGenresFromCatalog($selected_catalog->cdcata, array('lang' => strtolower($idlang), 'from' => 'all'));
                foreach ($simpleGenres as $genre) {
                    $genres[] = $this->getFullGenreForNavbar($genre, $selected_catalog->cdcata);
                }
                break;
            case 4:
                $customMenu = $this->getCustomMenuItems($selected_catalog->cdcata);
                $modelTypes = array();
                $genres = array();
                break;
            case 5:
                $modelTypes = array();
                $genres = array();
                $simpleGenres = Tpgene::getAllArticleGenresFromCatalog($selected_catalog->cdcata, array('lang' => strtolower($idlang), 'from' => 'all'));
                foreach ($simpleGenres as $genre) {
                    $genres[] = $this->getFullGenreForNavbar($genre, $selected_catalog->cdcata);
                }
                break;
            default:
                $modelTypes = array();
                $genres = array();
                break;
        }
        $galleries = $this->getAppSettings('EnableCatalogGalleries') > 0
            ? B2bGltest::getGalleriesForCatalog($selected_catalog->cdcata, $idlang)
            : array();

        $classifications = B2bClassificazione::getAvailableTree();

        // Can user do orders?
        $canDoOrder = $user->orders_enabled == 1;

        // Is agent?
        $isAgent = $id_usr != -1 && $user->type == 3;

        // Promo management
        $promo = array();
        $coupon_promo = $this->getAppSettings('ParamCouponPromo');
        if (in_array($context, array('cart', 'catalog', 'model')) && $isOrder && $coupon_promo == 2) {
            $promo = $this->getPromos($order_info->nuordc, $order_info->tpanag, $order_info->cdanag);
        }

        // Periods for order
        $periods = array();
        if ($this->getAppSettings('ParamDateManagement') == 5) {
            $periods1Step = Scacon::getTwoStepsPeriodsForCatalog($exist ? $selected_catalog->cdcata : $order_info->cdcata);
            foreach ($periods1Step as $scacon) {
                $currentPeriod = $scacon->toArray();
                $currentPeriod['secondStep'] = array($scacon->dtmcoi);

                $currentDate = $scacon->dtmcoi;
                while (strtotime($currentDate) < strtotime($scacon->dtmcof)) {
                    $currentDate = date('Y-m-d', strtotime($currentDate . ' +1 day'));
                    $currentPeriod['secondStep'][] = $currentDate;
                }
                $periods[] = $currentPeriod;
            }
        } else if ($this->getAppSettings('ParamDateManagement') < 3 || $this->getAppSettings('ParamDateManagementAvailability') < 3) {
            $periods = Scacon::getPeriodsForCatalog($exist ? $selected_catalog->cdcata : $order_info->cdcata);
        }

        $logoimg = B2bAddinf::getCustomLogoForCatalog($selected_catalog->cdcata);
        if ($logoimg == '') {
            $logoimg = $this->getAppUtils('logo_image');
        }
        $showStructureFilter = B2bFlvisi::findFirstByCodic1("struct") instanceof B2bFlvisi ? B2bFlvisi::findFirstByCodic1("struct")->flbloc == 0 : false;
        $showBrandsFilter = B2bFlvisi::findFirstByCodic1("brands") instanceof B2bFlvisi ? B2bFlvisi::findFirstByCodic1("brands")->flbloc == 0 : false;
        $showClassificationFilter = ($claVF = B2bFlvisi::findFirstByCodic1("b2bcla")) && $claVF instanceof B2bFlvisi && $claVF->flbloc == 0;

        $modelDetailStyle = $this->getAppSettings('ModelDetailStyle');

        // Common info
        $res = array(
            'address' => $this->getAppUtils('address') . ', ' . $this->getAppUtils('city') . ', ' . $this->getAppUtils('province') . ', ' . $this->getAppUtils('country'),
            'brands' => $brands,
            'budget' => $fullBudgets,
            'business' => $this->getAppUtils('business_name'),
            'canDoOrder' => $canDoOrder,
            'catalogs' => $catalogs,
            'cdvalu' => $cdvalu,
            'currency' => $currency,
            'customers' => $customers,
            'customMenu' => $customMenu,
//            'destinations' => $destinations,
            'email' => $this->getAppUtils('email'),
            'galleries' => $galleries,
            'genres' => $genres,
            'classifications' => $classifications,
            'indicatives' => $indicatives,
            'isOrder' => $isOrder,
            'labels' => Ctetic::getLabelsByCatalog(),
            'tipologieOrdine' => B2bTipord::find(['flbloc = 0', 'order' => 'seqrap ASC']),
            'lines' => $lines,
            'logoimg' => $logoimg,
            'lookbooks' => $lookbooks,
            'modelTypes' => $modelTypes,
            'old_orders' => Octest::getClosedOrders($id_usr),
            'order_info' => $order_info,
            'periods' => $periods,
            'priceLists' => $priceLists,
            'sales' => $sales,
            'selected_catalog' => $selected_catalog,
            'series' => $series,
            'supportavailable' => $this->isSupportAvailable(),
            'tel' => $this->getAppUtils('tel'),
            'tot' => ($isOrder && $order_info ? Occorp::getOrderTotals($order_info->nuordc) : null),

            // settings
            'addHeaderBtnLink' => $this->getAppUtils('additional_header_btn_link'),
            'addHeaderBtnText' => $this->getAppUtils('additional_header_btn_text'),
            'allowExcelCart' => $this->getAppSettings('AllowExcelCart') == 1,
            'budgetManagement' => $this->getAppSettings('BudgetManagement'),
            'catalogAccessType' => $catalogAccessType,
            'catalogMenuAlignment' => $this->getAppSettings('CatalogMenuAlignment'),
            'catalogProductType' => $this->getAppSettings('ProductTypeOnCatalog'),
            'productNameType' => $this->getAppSettings('ArticleName'),
            'changePriceList' => $this->getAppSettings('ChangePriceList'),
            'chooseLabel' => $this->getAppSettings('ParamLabel'),
            'choosePriceList' => $this->getAppSettings('ChoosePriceListOnNewOrder'),
            'closeQtyModal' => $this->getAppSettings('CloseModalAfterInsertQuantity') == 1,
            'CNCanSendOrders' => $this->getAppSettings('NewCustomerCanSendOrders'),
            'menageCustomer' => $this->getAppSettings('ManageCustomerStatus'),
            'coupon_promo' => $coupon_promo,
            'dateTypeAvaOrder' => $this->getAppSettings('ParamDateManagementAvailability'),
            'dateTypeResOrder' => $this->getAppSettings('ParamDateManagement'),
            'dateOffset' => $this->getAppSettings('ParamAvailabilityDateManagement'),
            'defaultOrderType' => $this->getAppSettings('DefaultOrderType'),
            'defaultShipping' => $this->getAppSettings('DefaultShipping'),
            'doubleRowsNewOrder' => $this->getAppSettings('EnableChoiceForDoubleRowsOnNewOrder'),
            'enableBarcode' => $this->getAppSettings('EnableBarcode'),
            'enableFabricView' => $this->getAppSettings('FabricVisualization'),
            'enableMinMulLabel' => $this->getAppSettings('EnableMinMulLabel') > 0,
            'enableXlsOrder' => $isAgent ? $this->getAppSettings('EnableOrderXmlAgent') : $this->getAppSettings('EnableOrderXmlCustomer'),
            'hasWizard' => $this->hasWizard($modelDetailStyle),
            'hideDeliveryDate' => $this->getAppSettings('HideDeliveryDateOnCreatingOrder'),
            'hideBlockedItems' => intval($this->getAppSettings('HideBlockedItems') ?: 0),
            'homepage' => $this->getAppSettings('StartingHomePage'),
            'newOrderLanding' => $this->getAppSettings('NewOrderLandingPage'),
            'indicativeText' => $this->getAppSettings('IndicativeText'),
            'manageIndicative' => $manageIndicative,
            'modelDetailStyle' => $modelDetailStyle,
            'modelDetailPickerSize' => $this->getAppSettings('ModelDetailPickerSize'),
            'highlightEffects' => $this->getAppSettings('HighlightEffects'),
            'modelDetailHighlight' => $this->getAppSettings('ModelDetailHighlight'),
            'NavbarContent' => $navbarContent,
            'orderInfoBtn' => $this->getAppSettings('OrderInfoButtonType'),
            'orderTypeChoice' => $isAgent ? $this->getAppSettings('OrderTypeAgent') : $this->getAppSettings('OrderTypeCustomer'),
            'paypal' => $this->getAppSettings('ParamEnableCreditCardPayment'),
            'popup' => $this->getAppSettings('OrderPopup'),
            'showAvailabilityFlag' => $this->getAppSettings('ShowAvailabilityFlag'),
            'showContactInfo' => $this->getAppSettings('ShowContactInfo'),
            'showCustomer' => $this->getAppSettings('ParamShowTabCustomer' . ($isAgent ? 'Agent' : 'Customer')),
            'showDeadlines' => $isAgent ? $this->getAppSettings('ParamShowTabDeadlinesAgent') : $this->getAppSettings('ParamShowTabDeadlinesCustomer'),
            'showDestinations' => $this->getAppSettings('ParamShowTabDestinations' . ($isAgent ? 'Agent' : 'Customer')),
            'showList' => $this->getAppSettings('ParamAvailabilityList'),
            'showOrders' => $this->getAppSettings('ParamShowTabOrders' . ($isAgent ? 'Agent' : 'Customer')),
            'showOrdersHistory' => $this->getAppSettings('ParamShowTabOrdersHistory'),
            'showInvoicesHistory' => $this->getAppSettings('ParamShowTabInvoicesHistory'),
            'showTransDocHistory' => $this->getAppSettings('ParamShowTabTransDocHistory'),
            'showProfile' => $this->getAppSettings('ParamShowTabProfile' . ($isAgent ? 'Agent' : 'Customer')),
            'showPriceOverImage' => $this->getAppSettings('ShowPriceOverImage') == 1,
            'showQuickOrder' => $this->getAppSettings('EnableQuickOrder'),
            'showVisual' => $this->getAppSettings('EnableVisualView') == 1,
            'useMoreCatalogs' => $this->getAppSettings('ParamUseMoreCatalogs'),
            'customShipping' => $this->getAppSettings('CustomShipping'),
            'customPayment' => $this->getAppSettings('CustomPayment'),
            'preselectFirstColor' => $this->getAppSettings('FirstColorSelected') == 1,
            'navbarBgColor' => $this->getAppSettings('NavbarBackgroundColor'),
        );

        if ($res['modelDetailStyle'] == 3) {
            $startTokens = explode('-', $this->getAppUtils('zan_date_start'));
            $endTokens = explode('-', $this->getAppUtils('zan_date_end'));
            $res['zanStartDate'] = $startTokens[2] . '-' . $startTokens[1] . '-' . $startTokens[0];
            $res['zanEndDate'] = $endTokens[2] . '-' . $endTokens[1] . '-' . $endTokens[0];
            $res['zanDefaultInd'] = $this->getAppUtils('zan_default_ind');
        }

        switch ($context) {
            case 'account':
                $agentCanEditXls = $this->getAppSettings('EnableOrderXmlAgent');
                $customerCanEditXls = $this->getAppSettings('EnableOrderXmlCustomer');
                $canEditXls = $isAgent
                    ? $agentCanEditXls == 2 || $agentCanEditXls == 3
                    : $customerCanEditXls == 2 || $customerCanEditXls == 3;

                $res['carriers'] = Anavet::find(array('order' => 'dsvett'));
                $res['countries'] = Ananaz::find(array('order' => 'dsnazi'));
                $res['deadlines'] = $this->getDeadlines($user->type, $customers);
                $res['orders'] = $this->getOrdersSummary($id_usr);
                $res['user'] = $user;
                $res['zones'] = Anazon::find(array('order' => 'dszona'));
                // settings
                $res['canEditXls'] = $canEditXls;
                $res['returnsmngmt'] = $this->getAppSettings('ParamReturnsManagement');
                $res['sendmaildatavar'] = $this->getAppSettings('ParamSendMailForVariations');
                $res['orderStateMgmt'] = $this->getAppSettings('OrderStateManagement');
                $res['cart_limit_mode'] = $this->getAppSettings('OrderLimit');
                $res['cart_limit_min_value'] = $this->getAppSettings('OrderLimitMinValue');
                break;
            case 'cart':
                $res['company'] = $this->getAppUtils('company_extended');
                $res['headerimg'] = $this->getAppUtils('header_image');
                $res['promo'] = $promo;
                // settings
                $res['applyTax'] = $this->getAppSettings('ApplyTaxOnOrder');
                $res['breakregqta'] = $this->getAppSettings('BreakRegqta');
                $res['cartMode'] = $this->getAppSettings('CartMode');
                $res['checkOrderPrices'] = $this->getAppSettings('PreventOrderToBeSentWithoutPrices');
                $res['description'] = $this->getAppSettings('ParamTypeDescrSummary');
                $res['enable_comp_note'] = $this->getAppSettings('ParamEnableCompanyNoteConcludeOrder');
                $res['enable_cust_note'] = $this->getAppSettings('ParamEnableCustomerNoteConcludeOrder');
                $res['imagesOnSummary'] = $this->getAppSettings('ImagesOnSummary');
                $res['multipleInsert'] = $this->getAppSettings('MultipleInsertQuantityOnCart');
                $res['paymentCondition'] = $this->getAppSettings('PaymentOnCloseOrder');
                $res['saveOrderType'] = $this->getAppSettings('ParamSaveOrderType');
                $res['shippingCondition'] = $this->getAppSettings('ShippingOnCloseOrder');
                $res['shippingsOnRows'] = $this->getAppSettings('ShippingsOnOrderRows');
                $res['showPublicPrice'] = $this->getAppSettings('ParamPriceSellPublicVisible');
                $res['showRowDelivery'] = $this->getAppSettings('ParamQuantityDeliveryView');
                $res['showRowIndicative'] = $this->getAppSettings('ParamQuantityIndicativeView');
                $res['showRowNotes'] = $this->getAppSettings('ParamQuantityNotesView');
                $res['showRowReference'] = $this->getAppSettings('ParamQuantityReferenceView');
                $res['viewregqta'] = $this->getAppSettings('ParamViewRegqtaAndCellSize');
                $res['cart_limit_mode'] = $this->getAppSettings('OrderLimit');
                $res['cart_limit_min_value'] = $this->getAppSettings('OrderLimitMinValue');
                break;
            case 'catalog':
            case 'info':
                $res['banner'] = $this->getAppUtils('banner');
                $res['headerimg'] = $this->getAppUtils('header_image');
                $res['promo'] = $promo;
                $res['gogatewayFeatures'] = $this->getAppUtils('enable_gogateway_features');
                // settings
                $res['breakregqta'] = $this->getAppSettings('BreakRegqta');
                $res['ItemsPerRow'] = $this->getAppSettings('ItemsPerRowOnVisualCatalog');
                $res['FeaturedSorting'] = $this->getAppSettings('FeaturedModelsSorting');
                $res['hideAvailability'] = $this->getAppSettings('HideAvailabilityOnAvailabilityOrder');
                $res['lookType'] = $this->getAppSettings('LookbookItemType');
                $res['paramStructFilter'] = $showStructureFilter;
                $res['paramBrandsFilter'] = $showBrandsFilter;
                $res['paramClassificationFilter'] = $showClassificationFilter;
                $res['shownotavailable'] = $this->getAppSettings('ParamShowNotAvailableItems');
                $res['showCatalogPrice'] = $this->getAppSettings('ParamShowPriceCatalog');
                $res['articleListType'] = $this->getAppSettings('ArticleDescriptionOnList');
                $res['imageOnCatalogList'] = $this->getAppSettings('ImageOnCatalogList');
                $res['visible_delivery'] = $this->getAppSettings('ParamQuantityDeliveryView');
                $res['visible_indicative'] = $this->getAppSettings('ParamQuantityIndicativeView');
                $res['visible_notes'] = $this->getAppSettings('ParamQuantityNotesView');
                $res['visible_reference'] = $this->getAppSettings('ParamQuantityReferenceView');
                break;
            case 'model':
//                $res['tot'] = Occorp::getCurrentCartTotal($id_usr);
                $res['headerimg'] = $this->getAppUtils('header_image');
                $res['promo'] = $promo;
                // settings
                $res['breakregqta'] = $this->getAppSettings('BreakRegqta');
                $res['changeModelPreview'] = $this->getAppSettings('ChangeModelPreview');
                $res['defaultImage'] = $this->getAppSettings('DefaultImageOnModelDetail');
                $res['description'] = $this->getAppSettings('ParamTypeDescrCatalogDetail');
                $res['hideAvailability'] = $this->getAppSettings('HideAvailabilityOnAvailabilityOrder');
                $res['multipledelivery'] = $this->getAppSettings('ParamQuantityMultipleDeliveryView');
                $res['noprice'] = $this->getAppSettings('ParamQuantityNoPrice');
                $res['noslider'] = $this->getAppSettings('RemoveSliderArticlesOnModelDetail');
                $res['printHtmlTags'] = $this->getAppSettings('EnableDescriptionLoadingOnProductInfo') > 0;
                $res['quickNavigation'] = $this->getAppSettings('QuickNavigation');
                $res['showMinMul'] = $this->getAppSettings('ShowMinMulOnModelDetail');
                $res['shownotavailable'] = $this->getAppSettings('ParamShowNotAvailableItems');
                $res['showPublicPrice'] = $this->getAppSettings('ParamPriceSellPublicVisible');
                $res['style'] = $this->getAppSettings('ParamModelDetailQuantityStyle');
                $res['variationenabled'] = $this->getAppSettings('ParamVariation');
                $res['viewregqta'] = $this->getAppSettings('ParamViewRegqtaAndCellSize');
                $res['visible_delivery'] = $this->getAppSettings('ParamQuantityDeliveryView');
                $res['visible_indicative'] = $this->getAppSettings('ParamQuantityIndicativeView');
                $res['visible_notes'] = $this->getAppSettings('ParamQuantityNotesView');
                $res['visible_reference'] = $this->getAppSettings('ParamQuantityReferenceView');
                break;
            case 'support':
                $res['user'] = $user;
                $res['ticket_argument'] = $this->getAppSettings('ParamQuantityReferenceView') == 1;
                break;
        }

        return $res;
    }
    //endregion

    /**
     * Recupera il MimeType da un file
     *
     * @param string $filePath
     * @return string
     */
    public function getMimeTypeByFile($filePath)
    {
        if (function_exists('finfo_open')) {
            $finfo = finfo_open(FILEINFO_MIME_TYPE);
            $finfoMime = strtolower(finfo_file($finfo, $filePath));
            finfo_close($finfo);
        } else {
            $finfoMime = strtolower(mime_content_type($filePath));
        }
        return $finfoMime;
    }

    /**
     * @param \PhpOffice\PhpSpreadsheet\RichText\RichText $richText
     * @return array|string|string[]|null
     */
    public function convertSpeadsheetRichTextToHtml($richText)
    {
        $htmlString = '<p>';
        foreach ($richText->getRichTextElements() as $index => $textElements) {
            foreach ($textElements->getText()->getRichTextElements() as $textElement) {
                $fontData = $textElement->getFont();
                $textValue = $textElement->getText();
                $textStr = (string)$textValue;
                if (!empty($textStr)) {
                    $re = '/^(?:[\w ]+;)+ ?$/m';
                    preg_match_all($re, $textStr, $matches);
                    if (!empty($matches[0])) {
                        foreach ($matches[0] as $match) {
                            $re2 = '/[\w ]+(?:;|$)/m';
                            $subst = "<li>$0</li>";
                            $textStr = str_replace($match, '<ul>' . preg_replace($re2, $subst, $match) . '</ul>', $textStr);
                        }
                    }
                    $style = '';
                    if ($fontData->getColor()->getRGB() != '000000') {
                        $style .= 'color:#' . $fontData->getColor()->getRGB() . ';';
                    }
                    if ($fontData->getSize() != '11') {
                        $style .= 'font-size:' . $fontData->getSize() . 'px;';
                    }
                    if ($fontData->getBold()) {
                        $style .= 'font-weight:bold;';
                    }
                    if ($fontData->getItalic()) {
                        $style .= 'font-style:italic;';
                    }
                    if ($fontData->getUnderline() != 'none' && $fontData->getStrikethrough()) {
                        $style .= 'text-decoration:underline line-through;';
                    } else {
                        if ($fontData->getUnderline() == 'single') {
                            $style .= 'text-decoration:underline;';
                        }
                        if ($fontData->getStrikethrough()) {
                            $style .= 'text-decoration:line-through;';
                        }
                    }

                    $tag = 'span';
                    if ($fontData->getSubscript()) {
                        $tag = 'sub';
                    } else if ($fontData->getSuperscript()) {
                        $tag = 'sup';
                    }

                    $htmlString .= '<' . $tag . (!empty($style) ? ' style="' . $style . '"' : '') . '>' . $textStr . '</' . $tag . '>';
                }
            }
        }
        $htmlString .= '</p>';
        return preg_replace("/\n/", '<br/>', $htmlString);
    }

    public static function generateRandomPassword($minLength, $moreSecure = false)
    {
        /**
         * Security warning:
         * this method not generate a cryptographically secure password
         * in newer PHP version (>7.0) use this instead
         * https://stackoverflow.com/questions/6101956/generating-a-random-password-in-php/31284266#31284266
         */
        $digits = '0123456789';
        $chars = 'abcdefghijklmnopqrstuvwxyz';
        $capital = strtoupper($chars);
        $symbols = '-=!@#$%^&*()_+,.<>?;:[]{}';

        $base = '';
        for ($i = 0; $i < $minLength; $i++) {
            $base .= str_shuffle($digits . $symbols . $chars . $capital . $digits . ($minLength >= 9 ? $symbols : ''));
        }

        $pwd = substr(str_shuffle($base), 0, $minLength);

        if ($moreSecure) {
            if (!preg_match('/[' . $digits . ']/', $pwd)) {
                $pwd .= substr(str_shuffle($digits), 0, 1);
            }
            if (!preg_match('/[' . $chars . ']/', $pwd)) {
                $pwd .= substr(str_shuffle($chars), 0, 1);
            }
            if (!preg_match('/[' . $capital . ']/', $pwd)) {
                $pwd .= substr(str_shuffle($digits), 0, 1);
            }
            if (!preg_match('/[' . preg_quote($symbols) . ']/', $pwd)) {
                $pwd .= substr(str_shuffle($symbols), 0, 1);
            }
            $pwd = str_shuffle($pwd);
        }

        return $pwd;
    }

    public function recuperaDescrizioneConsegnaBed($order_info)
    {
        //        return print_r($order_info, true);
        if ($order_info instanceof \Phalcon\Mvc\Model\Row) {
            $order_info = $order_info->toArray();
        }
        if (array_key_exists('dsscad', $order_info)) {
            return $order_info['dsscad'];
        }
        $params = [
            'cdcata' => $order_info['cdcata'],
            'dtmcli' => ($order_info['dtmcli_n'] ?: ($order_info['dtmcli_raw'] ?: $order_info['dtmcli']))
        ];
        $scacon = Scacon::findFirst([
            'cdcata = :cdcata: AND dtmcli = :dtmcli:',
            'bind' => $params
        ]);

        return (($scacon instanceof Scacon) ? $scacon->dsscad : $order_info['dtmcli']);
    }

    public static function dumpQuery($query, $params, $replaceVar = false, $die = false)
    {
        $query = preg_replace('/:(\w+):/i', ':$1', $query);
        preg_match_all('/Go2B\\\\Models\\\\(\w+)/i', $query, $matches);
        if (!empty($matches) && !empty($matches[0])) {
            $replacement = [];
            foreach ($matches[1] as $id => $className) {
                if (isset($matches[0][$id]) && class_exists($matches[0][$id])) {
                    $namespace = $matches[0][$id];
                    $instance = new $namespace();
                    $tableName = $instance->getSource();
                } else {
                    $tableName = trim(strtolower(preg_replace('/([A-Z])/', '_$1', $className)), ' _');
                }
                $replacement[$matches[0][$id]] = $tableName;
            }

            // Prima della sostituzione ordino per lunghezza della stringa,
            // così evitiamo di sostituire prima una porzione di un altra chiave
            uksort($replacement, function ($a, $b) {
                return strlen($b) - strlen($a);
            });
            $query = str_replace(array_keys($replacement), array_values($replacement), $query);
        }

        // Prima del controllo/sostituzione ordino per lunghezza della stringa,
        // così evitiamo di sostituire prima una porzione di un altra chiave
        uksort($params, function ($a, $b) {
            return strlen($b) - strlen($a);
        });

        preg_match_all('/:\b([\w-]+)\b/', $query, $placeholders);

        $notFoundParams = [];
        foreach ($params as $key => $value) {
            if (!preg_match('/:\b' . $key . '\b/', $query, $matches)) {
                $notFoundParams[] = $key;
            } else if ($replaceVar) {
                $query = str_replace(":$key", "'" . addcslashes($value, "'") . "'", $query);
            }
        }

        ob_start();
        echo '<pre>' . $query . PHP_EOL . PHP_EOL;
        var_dump([
            'params' => $params,
            'notFoundInSql' => $notFoundParams,
            'notFoundInParams' => array_diff($placeholders[1], array_keys($params)),
        ]);
        echo '</pre>';
        $output = ob_get_clean();

        if ($die) {
            echo $output;
            exit();
        }

        return $output;
    }

    public static function emptyOrSpace($s)
    {

        return (empty($s) || trim($s) == '');
    }
}
