<?php

namespace Go2B\Controllers;

use Go2B\Models\Anaart;
use Go2B\Models\Anagra;
use Go2B\Models\B2bApputi;
use Go2B\Models\B2bSysusr;
use Go2B\Models\B2bTkargo;
use Go2B\Models\B2bTkcorp;
use Go2B\Models\B2bTkstat;
use Go2B\Models\B2bTktest;
use Go2B\Models\B2bUsrana;
use Go2B\Models\Stoord;
use Phalcon\Http\Request;
use Phalcon\Mvc\Model\Resultset\Simple as Resultset;

class SupportController extends ControllerBase
{
    //region Initialize
    public function initialize()
    {
        $this->tag->setTitle('Support');
        parent::initialize();
    }
    //endregion

    //region Views functions
    public function indexAction()
    {
        $user = $this->dispatcher->getParam('user');
        $auth = $this->session->get('auth');
        $common = $this->utility->getCommonData('support', $auth['id']);
        $html = '';

        // Update support activity
        B2bSysusr::updateActivity($auth['id']);

        // Get all chats
        if (!file_exists('./chat')) {
            mkdir('./chat', 0777, true);
        }

        // Get current chat
        if (isset($user)) {
            $chat = file_get_contents('./chat/' . $user . '.txt');

            $all_chat = explode("\n", $chat);
            foreach ($all_chat as $msg) {
                $html .= $this->utility->getHtmlChat($msg, $user);
            }
        }

        $this->view->curr_chat = $html;
        $this->view->curr_user = $user;
        $this->view->user_type = $auth['type'];
        $this->view->common = $common;
        $this->view->chats = $this->getChats();

    }

    public function chatAction()
    {
        $cdtick = $this->dispatcher->getParam('cdtick');
        $auth = $this->session->get('auth');
        $common = $this->utility->getCommonData('support', $auth['id']);
        $ticket = B2bTktest::findFirstByCdtick($cdtick);
        $cdanag = B2bUsrana::findFirstByIdUsr($ticket->cduser)->cdanag;
        $messages_html = "";
        $can_edit = false;
        $processed = null;
        $valid = $this->validateTicket($ticket, $auth['id']);
        $is_open = false;

        if ($valid) {
            // ### Ticket Header ###
            $dsarti = Stoord::findFirstByCodart($ticket->codart)->desart;
            $processed = $ticket;
            $can_edit = $this->validateTicket($ticket, $auth['id'], true);
            $email = '(' . (!empty($ticket->inmail)
                    ? $ticket->inmail
                    : Anagra::findFirstByCdanag($cdanag)->indema) . ')';
            $is_open = $ticket->cdstat != 4;
            $processed->cdarti = $ticket->codart . ' - ' . $dsarti;
            $processed->cdargo = $this->translate(B2bTkargo::findFirstByCdargo($ticket->cdargo)->dsargo);
            $processed->dsuser = B2bSysusr::findFirstById($ticket->cduser)->username . ' ' . $email;
            $processed->dtcrea = $this->utility->getHumanDateTime($ticket->dtcrea);
            $processed->dtchiu = !empty($ticket->dtchiu) ? $this->utility->getHumanDateTime($ticket->dtchiu) : '-';
            $processed->update = $this->getLatestUpdate($cdtick);
            $processed->dsstat = $this->getTicketStatus($ticket->cdstat);
            // ### Ticket Header ###

            // ### Ticket Messages ###
            $messages = B2bTkcorp::find([
                'conditions' => 'cdtick = :cdtick:',
                'bind' => ['cdtick' => $cdtick],
                'order' => 'dtmodi ASC'
            ]);

            foreach ($messages as $message) {
                $sender_type = B2bSysusr::findFirstById($message->cduser)->type;
                $username = $sender_type <= 2 ? "Support" : B2bSysusr::findFirstById($message->cduser)->username;
                $show_type = $message->cduser == $auth['id'] ? 'out' : (
                B2bUsrana::findFirstByIdUsr($message->cduser)->cdanag == B2bUsrana::findFirstByIdUsr($auth['id'])->cdanag
                    ? 'out'
                    : 'in'
                );
                $messages_html .= $this->utility->getHtmlChatMessage($message, $show_type, $username, $sender_type);
            }
            // ### Ticket Messages ###
        } else {
            $this->flashSession->error('You don\'t have permission to access this ticket');
            $this->response->redirect('support/list');
        }

        $this->view->is_open = $is_open;
        $this->view->ticket = $processed;
        $this->view->messages = $messages_html;
        $this->view->can_edit = $can_edit;
        $this->view->user_type = $auth['type'];
        $this->view->curr_user = $auth['id'];
        $this->view->common = $common;
        $this->view->setVars($common);
    }

    public function listAction()
    {
        $auth = $this->session->get('auth');
        $hasSupport = $this->utility->getAppSettings('SupportAvailable') == 1;
        if ($hasSupport) {
            $common = $this->utility->getCommonData('support', $auth['id']);
            $tickets = B2bTktest::getTicketsList($auth['id']);
            $topics = B2bTkargo::find("flbloc = 0");
            // TODO filtrare anche sui ticket aperti (no nuovo ticket per ordine con ticket aperto)
            $orders = Stoord::find([
                'conditions' => 'cdanag = :cdanag:',
                'group' => 'tipdoc, numdoc',
                'order' => 'datdoc DESC, numdoc DESC',
                // Trasformiamo qualsiasi codice alfanumerico in solo numeri
                // dato che abbiamo il solo codice numerico in questa tabella.
                'bind' => ['cdanag' => intval(preg_replace('/[^\d]/i', '', B2bUsrana::findFirstByIdUsr($auth['id'])->cdanag))],
                'limit' => 5
            ]);

            $tickets_p = [];
            $orders_p = [];

            if (!empty($tickets)) {
                foreach ($tickets as $ticket) {
                    $ticket->dsstat = $this->getTicketStatus($ticket->cdstat);
                    $ticket->dtcrea = $this->utility->getHumanDateTime($ticket->dtcrea);
                    $ticket->update = $this->getLatestUpdate($ticket->cdtick);
                    $tickets_p[] = $ticket;
                }
            }

            if (count($topics) == 0) {
                B2bTkargo::populate();
                $topics = B2bTkargo::find("flbloc = 0");
            }

            foreach ($orders as $order) {
                $order->datdoc = $this->utility->getHumanDate($order->datdoc);
                $order->desord = $order->numdoc . ' - ' . $order->datdoc;
                $orders_p[] = $order;
            }

            $this->view->orders = $orders_p;
            $this->view->tickets = $tickets_p;
            $this->view->topics = $topics;
            $this->view->common = $common;
            $this->view->user_type = $auth['type'];
            $this->view->setVars($common);
        } else {
            $this->response->redirect('catalog/index');
        }
    }

    public function chatAdminAction()
    {
        $cdtick = $this->dispatcher->getParam('cdtick');
        $auth = $this->session->get('auth');
        $common = $this->utility->getCommonData('support', $auth['id']);
        $ticket = B2bTktest::findFirstByCdtick($cdtick);
        $cdanag = B2bUsrana::findFirstByIdUsr($ticket->cduser)->cdanag;
        $messages_html = "";
        $status_list = $this->getTicketStatus();
        $processed = null;
        $can_edit = false;
        $valid = $this->validateTicket($ticket, $auth['id'], true);
        $is_open = false;

        if ($valid) {
            // ### Ticket Header ###
            $dsarti = Stoord::findFirstByCodart($ticket->codart)->desart;
            $processed = $ticket;
            $can_edit = $this->validateTicket($ticket, $auth['id'], true);
            $email = '(' . (!empty($ticket->inmail)
                    ? $ticket->inmail
                    : Anagra::findFirstByCdanag($cdanag)->indema) . ')';
            $is_open = $ticket->cdstat != 4;
            $processed->cdarti = $ticket->codart . ' - ' . $dsarti;
            $processed->cdargo = $this->translate(B2bTkargo::findFirstByCdargo($ticket->cdargo)->dsargo);
            $processed->dsuser = B2bSysusr::findFirstById($ticket->cduser)->username . ' ' . $email;
            $processed->dtcrea = $this->utility->getHumanDateTime($ticket->dtcrea);
            $processed->dtchiu = !empty($ticket->dtchiu) ? $this->utility->getHumanDateTime($ticket->dtchiu) : '-';
            $processed->update = $this->getLatestUpdate($cdtick);
            $processed->dsstat = $this->getTicketStatus($ticket->cdstat);
            // ### Ticket Header ###

            // ### Ticket Messages ###
            $messages = B2bTkcorp::find([
                'conditions' => 'cdtick = :cdtick:',
                'bind' => ['cdtick' => $cdtick],
                'order' => 'dtmodi ASC'
            ]);

            foreach ($messages as $message) {
                $sender_type = B2bSysusr::findFirstById($message->cduser)->type;
                $username = $sender_type <= 2 ? "Support" : B2bSysusr::findFirstById($message->cduser)->username;
                $show_type = $message->cduser == $auth['id'] ? 'out' : (
                B2bUsrana::findFirstByIdUsr($message->cduser)->cdanag == B2bUsrana::findFirstByIdUsr($auth['id'])->cdanag
                    ? 'out'
                    : 'in'
                );
                $messages_html .= $this->utility->getHtmlChatMessage($message, $show_type, $username, $sender_type);
            }
            // ### Ticket Messages ###
        } else {
            $this->flashSession->error('You don\'t have permission to access this ticket');
            $this->response->redirect('support/list');
        }

        $this->view->is_open = $is_open;
        $this->view->ticket = $processed;
        $this->view->status = $status_list;
        $this->view->messages = $messages_html;
        $this->view->can_edit = $can_edit;
        $this->view->user_type = $auth['type'];
        $this->view->curr_user = $auth['id'];
        $this->view->common = $common;
        $this->view->setVars($this->getCommonVars());
    }

    public function listAdminAction()
    {
        $auth = $this->session->get('auth');
        $common = $this->utility->getCommonData('support', $auth['id']);
        $tickets = B2bTktest::getTicketsList($auth['id']);
        $topics = B2bTkargo::find("flbloc = 0");
        $orders = Stoord::find([
            'conditions' => 'cdanag = :cdanag:',
            'group' => 'numdoc',
            'order' => 'datdoc DESC, numdoc DESC',
            'bind' => ['cdanag' => B2bUsrana::findFirstByIdUsr($auth['id'])->cdanag],
            'limit' => 5
        ]);
        $tickets_p = [];
        $orders_p = [];

        if (!empty($tickets)) {
            foreach ($tickets as $ticket) {
                $ticket->dsstat = $this->getTicketStatus($ticket->cdstat);
                $ticket->dtcrea = $this->utility->getHumanDateTime($ticket->dtcrea);
                $ticket->update = $this->getLatestUpdate($ticket->cdtick);
                $tickets_p[] = $ticket;
            }
        }

        if (count($topics) == 0) {
            B2bTkargo::populate();
            $topics = B2bTkargo::find("flbloc = 0");
        }

        foreach ($orders as $order) {
            $order->datdoc = $this->utility->getHumanDate($order->datdoc);
            $order->desord = $order->numdoc . ' - ' . $order->datdoc;
            $orders_p[] = $order;
        }

        $this->view->orders = $orders_p;
        $this->view->tickets = $tickets_p;
        $this->view->topics = $topics;
        $this->view->common = $common;
        $this->view->user_type = $auth['type'];
        $this->view->setVars($this->getCommonVars());
    }

    //endregion

    //region Ajax functions
    public function getOrderRowsForModalAction()
    {
        $this->view->disable();

        $order_rows_p = [];

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $numdoc = $this->request->getPost('numdoc');
            $order_rows = Stoord::find([
                'conditions' => 'numdoc = :numdoc:',
                'order' => 'codart ASC',
                'bind' => ['numdoc' => $numdoc]
            ]);
            foreach ($order_rows as $row) {
                $row->dsarti = $row->codart . ' - ' . $row->desart;
                $order_rows_p[] = $row;
            }
        }
        echo json_encode($order_rows_p);
    }

    public function newTicketAction()
    {
        $this->view->disable();

        $data = [];



        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cduser = $this->session->get('auth')['id'];
            /** @var Anagra $anagra */
            $anagra = Anagra::findFirstByCdanag(B2bUsrana::findFirstByIdUsr($cduser)->cdanag);

            $cdargo = $this->request->getPost('cdargo');
            $numdoc = $this->request->getPost('numdoc');
            $codart = $this->request->getPost('codart');
            $codart = !empty($codart) ? $codart : null;
            $inmail = $this->request->getPost('inmail');
            $inmail = !empty($inmail) ? $inmail : $anagra->indema;
            $dstitl = $this->request->getPost('dstitl');
            $cdstat = '0';
            $dtcrea = date('Y-m-d H:i:s');

            $tktest = new B2bTktest();
            $tktest->cdargo = $cdargo;
            $tktest->numdoc = $numdoc;
            $tktest->codart = $codart;

            $this->logger->error("numdoc: " . $codart);
            $tktest->cduser = $cduser;
            $tktest->inmail = $inmail;
            $tktest->dstitl = $dstitl;
            $tktest->cdstat = $cdstat;
            $tktest->dtcrea = $dtcrea;
            $status = $tktest->save();

            if ($status) {
                $tkcorp = new B2bTkcorp();
                $tkcorp->cdtick = $tktest->cdtick;
                $tkcorp->cduser = $cduser;
                $tkcorp->descri = $this->request->getPost('descri');
                $tkcorp->dtmodi = $dtcrea;
                $status = $tkcorp->save();

                // Mandiamo una email al customer care - params[email_for_support]
                $newTkEmailRecipient = $this->utility->getAppUtils('email_for_support');
                $this->logger->debug("Ricerca email per il supporto: params[email_for_support] -> '$newTkEmailRecipient'" );
                if (empty($newTkEmailRecipient)) {
                    $newTkEmailRecipient = $this->utility->getAppUtils('email');
                    $this->logger->debug("Ricerca email per il supporto: params[email] -> '$newTkEmailRecipient'" );
                }

                if (!empty($newTkEmailRecipient)) {
                    $this->logger->debug("Email per il supporto trovata: " . $newTkEmailRecipient);
                    $sngCustomer = $this->config->release->user;
                    $portalUrl = "http://{$sngCustomer}.go-2b.it";
                    $title = 'Nuovo ticket nel <a href="' . $portalUrl . '">portale B2B</a>';
                    $dataTicket = date('d/m/Y');
                    $oraTicket = date('H:i:s');
                    $emailContent = <<<HTML
<h3>$title</h3>
<p>In data <u>$dataTicket</u> alle ore <u>$oraTicket</u> &egrave; stato creata una nuova richiesta al supporto clienti da:</p>
<p><b>$anagra->descri [$anagra->cdanag]</b>.</p>
<p>Email di riferimento:<br>$tktest->inmail</p>
<p>Messaggio inserito:<br>$tkcorp->descri</p>
HTML;

                    $this->utility->sendEmail('B2B Supporto', $newTkEmailRecipient, strip_tags($title), $emailContent);
                } else {
                    $this->logger->debug("Email per il supporto non presente");
                }

                if ($status) {
                    $data['status'] = 'OK';
                    $data['cdtick'] = $tktest->cdtick;
                } else {
                    $data['status'] = 'ERROR';
                    $data['message'] = "Error creating ticket message: \n" . $tkcorp->getMessages()[0];
                }
            } else {
                $data['status'] = 'ERROR';
                $data['message'] = "Error creating ticket: \n" . $tktest->getMessages()[0];
            }
        }
        echo json_encode($data);
    }

    public function getchatAction()
    {
        $this->view->disable();
        $auth = $this->session->get('auth');

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdtick = $request->getPost('cdtick');
            $data = [
                'cdtick' => $cdtick,
                'status' => null,
                'statusDesc' => '',
                'update' => '',
                'opened' => false,
                'editable' => false,
                'newMessages' => [],
            ];

            $ticket = B2bTktest::findFirstByCdtick($cdtick);
            if ($ticket instanceof B2bTktest) {
                $data['status'] = $ticket->cdstat;
                $data['opened'] = $ticket->cdstat < 4;
                $data['editable'] = $this->validateTicket($ticket, $auth['id'], true);
                $data['update'] = $this->getLatestUpdate($cdtick);
                $data['statusDesc'] = $this->getTicketStatus($ticket->cdstat);
                $web_count = $request->getPost('msg_count');
                $db_count = B2bTkcorp::count([
                    'conditions' => 'cdtick = :cdtick:',
                    'bind' => [
                        'cdtick' => $cdtick
                    ]
                ]);

                if ($web_count < $db_count) {
                    $messages = B2bTkcorp::find([
                        'conditions' => 'cdtick = :cdtick:',
                        'order' => 'dtmodi ASC',
                        'limit' => $db_count,
                        'offset' => $web_count,
                        'bind' => [
                            'cdtick' => $cdtick
                        ]
                    ]);
                    foreach ($messages as $message) {
                        $this->logger->error("messages: " . $message->descri);
                        $sender_type = B2bSysusr::findFirstById($message->cduser)->type;
                        $username = $sender_type <= 2 ? "Support" : B2bSysusr::findFirstById($message->cduser)->username;
                        $sender = empty(B2bUsrana::findFirstByIdUsr($message->cduser)) ? "" : B2bUsrana::findFirstByIdUsr($message->cduser)->cdanag;
                        $session_user = empty(B2bUsrana::findFirstByIdUsr($auth['id'])) ? "" : B2bUsrana::findFirstByIdUsr($auth['id'])->cdanag;
                        $show_type = $message->cduser == $auth['id'] ? 'out' : (
                        $sender == $session_user ? 'out' : 'in'
                        );
                        $data['messages'][] = $this->utility->getHtmlChatMessage($message, $show_type, $username, $sender_type);
                    }
                    $this->logger->warning("web_count: " . $web_count . " - db_count: " . $db_count);
                }
            } else {
                $data['error'] = $this->translate('support.error.ticket');
            }

            echo json_encode($data, JSON_NUMERIC_CHECK);
        }
    }

    public function sendchatAction()
    {
        $this->view->disable();

        $data = [];
        $auth = $this->session->get('auth');
        $user = $auth['id'] > 2 ? B2bSysusr::findFirstById($auth['id'])->username : "Support";
        $common = $this->utility->getCommonData('support', $auth['id']);

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $msg = $request->getPost('message');
            $cdtick = $request->getPost('cdtick');
            $allegati = $request->getPost('attachments', null, []);
            $result = B2bTkcorp::addMessage($cdtick, $msg, $auth['id'], json_encode($allegati));
            if ($result == "OK") {
                $data['status'] = "OK";
                $data['update'] = $this->getLatestUpdate($cdtick);
            } else {
                $data['status'] = "ERROR";
                $data['html'] = "<br> *** ERROR *** <br> Message not sent <!-- $result[0] -->";
            }
            echo json_encode($data);
        }
    }

    public function uploadAttachmentAction()
    {
        $data = [];
        $this->view->disable();
        $request = new Request();
        $auth = $this->session->get('auth');

        if (!empty($auth) && $request->hasPost('cdtick')) {
            $cdtick = $request->getPost('cdtick');
            $user = $auth['id'] > 2 ? B2bSysusr::findFirstById($auth['id'])->username : "Support";

            if (!empty($_FILES)) {
                $realFilename = $_FILES['file']['name'];
                $realFileExt = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION);
                $myFilename = uniqid($cdtick . '-');
                $tempFile = $_FILES['file']['tmp_name'];
                $targetPath = "./upload/support/";
                if (is_dir($targetPath) || mkdir($targetPath, 0777, true)) {
                    $targetFile = $targetPath . $myFilename . '.' . $realFileExt;

                    if (move_uploaded_file($tempFile, $targetFile)) {
                        $data['fileInfo'] = [
                            'filename' => $realFilename,
                            'url' => ltrim($targetPath, '.') . $myFilename . '/' . $realFilename,
                            'size' => $_FILES['file']['size'] ?: 0,
                        ];
                    }
                } else {
                    $data['error'] = $this->translate('dropzone.upload.error') . ' 3';
                }
            } else {
                $data['error'] = $this->translate('dropzone.upload.error') . ' 2';
            }
        } else {
            $data['error'] = $this->translate('dropzone.upload.error') . ' 1';
        }

        echo json_encode($data, JSON_NUMERIC_CHECK);
    }

    public function updatestateAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $auth = $this->session->get('auth');
            $cdtick = $request->getPost('cdtick');
            $cdstat = $request->getPost('cdstat');

            if (B2bTkstat::insertStateUpdate($cdtick, $cdstat, $auth['id'])) {
                echo B2bTktest::updateTicketState($cdtick, $cdstat) ? "OK" : "ERROR";
            } else {
                echo "ERROR";
            }
        }
    }

    public function addmessageAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $user = $_POST['user'];
            $message = $_POST['message'];
            $type = $_POST['type'];

            $html = '';

            B2bSysusr::updateActivity($this->session->get('auth')['id']);

            if (!file_exists('./chat')) {
                mkdir('./chat', 0777, true);
            }
            $chat = date("H:i d/m/Y") . ' ' . $type . ': ' . htmlentities($message);
            $file = './chat/' . $user . '.txt';
            if (!file_exists($file)) {
                file_put_contents($file, $chat);
            } else {
                file_put_contents($file, file_get_contents($file) . "\n" . $chat);
            }

            echo json_encode("OK");
        }
    }

    public function deletechatAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $user = $_POST['user'];

            B2bSysusr::updateActivity($this->session->get('auth')['id']);

            if (!file_exists('./chat')) {
                mkdir('./chat', 0777, true);
            }
            unlink('./chat/' . $user . '.txt');

            echo json_encode("OK");
        }
    }
    //endregion

    //region Custom functions
    private function getLatestUpdate($cdtick)
    {
        $last_update = B2bTkcorp::findFirst([
            "cdtick = :cdtick:",
            "bind" => ["cdtick" => $cdtick],
            "order" => "dtmodi DESC"
        ]);
        $last_update = $last_update ? $last_update->dtmodi : B2bTktest::findFirstByCdtick($cdtick)->dtcrea;
        return $this->utility->getHumanDateTime($last_update);
    }

    private function getTicketStatus($cdstat = null)
    {
        $status = '';
        $status_a = [];

        if (isset($cdstat)) {

            switch ($cdstat) {
                case 0:
                    $status .= $this->translate('support.status.open');
                    break;
                case 1:
                    $status .= $this->translate('support.status.in_progress');
                    break;
                case 2:
                    $status .= $this->translate('support.status.waiting.supplier');
                    break;
                case 3:
                    $status .= $this->translate('support.status.waiting.user');
                    break;
                case 4:
                    $status .= $this->translate('support.status.closed');
                    break;
                default:
                    $status .= $cdstat;
                    break;
            }
            return $status;
        } else {
            for ($i = 0; $i <= 4; $i++) {
                $this->logger->info("i: " . $i);
                $status_a[$i]['cdstat'] = $i;
                $status_a[$i]['dsstat'] = $this->getTicketStatus($i);
            }
            return $status_a;
        }
    }

    private function validateTicket($ticket, $iduser, $strict = false)
    {
        $user = B2bSysusr::findFirstById($iduser);
        if ($user->type <= B2bSysusr::TYPE_ADMIN || $user->type == B2bSysusr::TYPE_SUPPORT) {
            // Admin può vedere tutti i ticket
            return true;
        } else if ($ticket->cduser == $iduser) {
            return true;
        } else {
            $customer_id = B2bUsrana::findFirstByIdUsr($ticket->cduser)->cdanag;
            if (B2bUsrana::findFirstByIdUsr($iduser)->cdanag == $customer_id) {
                // Utenti appartenenti alla stessa azienda possono vedere i ticket se $strict = false
                return $strict ? false : true;
            }
        }

        return false;
    }

    public function getCommonVars()
    {
        $paymentType = $this->utility->getAppSettings('PaymentOnCloseOrder');
        $shippingType = $this->utility->getAppSettings('ShippingOnCloseOrder');
        $total_licenses = B2bApputi::findFirst(array("param = 'licenses'"));

        $commonVars = array(
            'licenses' => array(
                'licenses' => B2bSysusr::getLicensesCount(),
                'total_licenses' => $total_licenses != null ? $total_licenses->value : 0
            ),
            'enableBudget' => $this->utility->getAppSettings('BudgetManagement') > 0,
            'enableBlockedItems' => $this->utility->getAppSettings('EnableBlockedItems') > 0,
            'enableCheckPrices' => $this->utility->getAppSettings('PreventOrderToBeSentWithoutPrices') == 1,
            'enableColors' => in_array($this->utility->getAppSettings('ModelDetailStyle'), [1, 6, 7, 9]),
            'enableCoupon' => $this->utility->getAppSettings('ParamCouponPromo') == 1,
            'enableCustomFilter' => $this->utility->getAppSettings('EnableCustomFilter'),
            'enableCustomPayment' => $paymentType == 1 || $paymentType == 4,
            'enableCustomShipping' => $shippingType == 1 || $shippingType == 4,
            'enableCustomVariants' => $this->utility->getAppSettings('ModelDetailStyle') == 3,
            'enableCategoryBanner' => $this->utility->getAppSettings('CategoryBanner') == 1,
            'enableCustomFamily' => $this->utility->getAppSettings('ModelDetailStyle') == 2,
            'enableCustomMenu' => $this->utility->getAppSettings('NavbarContent') == 4,
            'enableGalleries' => $this->utility->getAppSettings('EnableCatalogGalleries') > 0,
            'enableSpecialSelections' => $this->utility->getAppSettings('SpecialSelections') > 0,
            'enableGoGatewayFeatures' => $this->utility->getAppUtils('enable_gogateway_features'),
            'enableSupportChat' => $this->utility->getAppSettings('SupportAvailable') > 0
        );

        if ($commonVars['enableGoGatewayFeatures'] == 1) {
            $commonVars['goGatewayFeatures'] = array(
                'enableAgentManager' => $this->utility->getManagementParam('EnableAgentManager')->value == 1,
                'enableAvailabilityManager' => $this->utility->getManagementParam('EnableAvailabilityManager')->value == 1,
                'enableBrandManager' => $this->utility->getManagementParam('EnableBrandManager')->value == 1,
                'enableCatalogManager' => $this->utility->getManagementParam('EnableCatalogManager')->value == 1,
                'enableConditionManager' => $this->utility->getManagementParam('EnableConditionManager')->value == 1,
                'enableExpirationManager' => $this->utility->getManagementParam('EnableExpirationManager')->value == 1,
                'enableGoAppUserManager' => $this->utility->getManagementParam('EnableGoAppUserManager')->value == 1,
                'enableLineManager' => $this->utility->getManagementParam('EnableLineManager')->value == 1,
                'enableLookbookManager' => $this->utility->getManagementParam('EnableLookbookManager')->value == 1,
                'enablePromoManager' => $this->utility->getManagementParam('EnablePromoManager')->value == 1,
                'enableSeasonsManager' => $this->utility->getManagementParam('EnableSeasonsManager')->value == 1,
                'enableSeriesManager' => $this->utility->getManagementParam('EnableSeriesManager')->value == 1,
                'enableSizeScaleManager' => $this->utility->getManagementParam('EnableSizeScaleManager')->value == 1,
            );
        }

        return $commonVars;
    }
    //endregion

    //region Aux functions
    private function getChats()
    {
        $path = './chat';
        $files = scandir($path);

        // Following code will remove . and .. from the returned array from scandir:
        $files = array_diff(scandir($path), array('.', '..'));

        $chats = array();
        foreach ($files as $file) {
            $curr_user = B2bSysusr::findFirstByUsername(str_replace('.txt', '', $file));
            if ($curr_user) {
                $now = time();
                $target1 = strtotime($curr_user->last_active);
                $target2 = strtotime($curr_user->last_login);
                $diff1 = $now - $target1;
                $diff2 = $now - $target2;

                $chats[] = array('user' => $curr_user->username,
                    'isonline' => $diff1 <= 900 || $diff2 <= 900,
                    'lines' => count(file($path . "/" . $file)));
            }
        }

        return $chats;
    }
    //endregion
}
