<?php

namespace Go2B\Controllers;

use Go2B\Models\Anaage;
use Go2B\Models\Cttest;
use Go2B\Models\Svanag;
use Go2B\Models\Svcorp;
use Go2B\Models\Svtest;
use Go2B\Models\Svtipo;
use Phalcon\Http\Request;
use Phalcon\Mvc\Model\Resultset\Simple as Resultset;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class StatisticsController extends ControllerBase
{
  //region Initialize
  public function initialize() {
    parent::initialize();
    $this->tag->setTitle($this->translate('_common.title.statistics'));
  }
  //endregion

  //region Views functions
  public function indexAction() {
    $auth       = $this->session->get('auth');
    $common     = $this->utility->getCommonData('statistics', $auth['id']);
    $customers  = Svanag::getCustomerStatsFromUser($auth['id']);

    $where  = '';
    $params = array();
    for ($i = 0; $i < count($customers); $i++) {
      $params['tipana' . $i] .= $customers[$i]->tipana;
      $params['codana' . $i] .= $customers[$i]->codana;
      $where .= "(s.tipana = :tipana" . $customers[$i]->tipana . ": AND s.codana = :codana" . $customers[$i]->codana . ":)";
      if ($i != count($customers) - 1) {
        $where .= ' OR ';
      }
    }

    if ($where != '') {
      $countries  = Svanag::getStatsCountries($where, $params);
      $zones      = Svanag::getStatsZones($where, $params);
      $catalogs   = Cttest::getAllCatalogsForUser($auth['id']);
      $ordertypes = Svtest::getStatsOrderTypes($where, $params);
      $seasons    = Svtest::getStatsSeasons($where, $params);
    } else {
      $countries = array();
      $zones = array();
      $catalogs = array();
      $ordertypes = array();
      $seasons = array();
    }

    $this->view->catalogs   = $catalogs;
    $this->view->lines      = Svtipo::getStatsLines();
    $this->view->series     = Svtipo::getStatsSeries();
    $this->view->customers  = $customers;
    $this->view->countries  = $countries;
    $this->view->zones      = $zones;
    $this->view->modeltypes = Svtipo::getStatsModelTypes();
    $this->view->ordertypes = $ordertypes;
    $this->view->genres     = Svtipo::getStatsGenres();
    $this->view->seasons    = $seasons;
    $this->view->common     = $common;
  }

  public function detailAction() {
    $auth     = $this->session->get('auth');
    $common   = $this->utility->getCommonData('statistics', $auth['id']);

    $typeStats   = isset($_POST['typeStats']) ? $_POST['typeStats'] : 'group_01';
    $catalogs    = isset($_POST['catalogs']) ? $_POST['catalogs'] : '';
    $customers   = isset($_POST['customers']) ? $_POST['customers'] : 'all';
    $lines       = isset($_POST['lines']) ? $_POST['lines'] : 'all';
    $countries   = isset($_POST['countries']) ? $_POST['countries'] : 'all';
    $series      = isset($_POST['series']) ? $_POST['series'] : 'all';
    $zones       = isset($_POST['zones']) ? $_POST['zones'] : 'all';
    $modeltypes  = isset($_POST['modeltypes']) ? $_POST['modeltypes'] : 'all';
    $ordertypes  = isset($_POST['ordertypes']) ? $_POST['ordertypes'] : 'all';
    $genres      = isset($_POST['genres']) ? $_POST['genres'] : 'all';
    $typeTime    = isset($_POST['typeTime']) ? $_POST['typeTime'] : '0';
    $time1       = isset($_POST['time1']) ? $_POST['time1'] : '_none';
    $time2       = isset($_POST['time2']) ? $_POST['time2'] : '_none';
    $time3       = isset($_POST['time3']) ? $_POST['time3'] : '_none';

    $multistats = false;
    if ($time2 != '_none' || $time3 != '_none') {
      $multistats = true;
    }

    $this->session->set('typeStats', $typeStats);
    $this->session->set('catalogs', $catalogs);
    $this->session->set('customers', $customers);
    $this->session->set('lines', $lines);
    $this->session->set('countries', $countries);
    $this->session->set('series', $series);
    $this->session->set('zones', $zones);
    $this->session->set('modeltypes', $modeltypes);
    $this->session->set('ordertypes', $ordertypes);
    $this->session->set('genres', $genres);
    $this->session->set('typeTime', $typeTime);
    $this->session->set('time1', $time1);
    $this->session->set('time2', $time2);
    $this->session->set('time3', $time3);

    $this->view->typeStats  = $typeStats;
    $this->view->catalogs   = $catalogs;
    $this->view->customers  = $customers;
    $this->view->lines      = $lines;
    $this->view->countries  = $countries;
    $this->view->series     = $series;
    $this->view->zones      = $zones;
    $this->view->modeltypes = $modeltypes;
    $this->view->ordertypes = $ordertypes;
    $this->view->genres     = $genres;
    $this->view->typeTime   = $typeTime;
    $this->view->time1      = $time1;
    $this->view->time2      = $time2;
    $this->view->time3      = $time3;

    $this->view->stats      = $this->getStats();
    $this->view->multistats = $multistats;
    $this->view->common     = $common;
  }
  //endregion

  //region Ajax functions
  public function createxlsAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $auth   = $this->session->get('auth');
      $agent  = $this->getAgentInfo($auth['id']);

      $info   = $_POST['info'];

      $rows   = $this->getStats();

      $spreadsheet = new Spreadsheet();
      $spreadsheet->getProperties()->setCreator('Sinergiattiva')->setTitle($this->translate('_common.statistics'));

      $columns = count($rows) > 0 ? count(get_object_vars((object)$rows[0])) : 0;

      $spreadsheet->setActiveSheetIndex(0);

      $objRichText = new \PhpOffice\PhpSpreadsheet\RichText\RichText();
      $objRichText->createText($this->translate('_common.agent.code') . ": " . $agent->cdagen . ' - ' . $this->translate('_common.agent') . ": " . $agent->dsagen);

      $activeSheet = $spreadsheet->getActiveSheet();
      $activeSheet->getCell('A1')->setValue($objRichText);

      $styleThickBrownBorderOutline = array(
        'borders' => array(
          'outline' => array(
            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
            'color' => array('argb' => 'FF000000'),
          ),
        ),
      );

      $activeSheet->getColumnDimension('A')->setAutoSize(true);
      $activeSheet->getColumnDimension('B')->setAutoSize(true);
      $activeSheet->getColumnDimension('C')->setAutoSize(true);

      switch ($columns) {
      case 3:
        $activeSheet->mergeCells('A1:C1');
        $activeSheet->getStyle('A1:C1')->applyFromArray($styleThickBrownBorderOutline);
        break;
      case 4:
        $activeSheet->mergeCells('A1:D1');
        $activeSheet->getStyle('A1:D1')->applyFromArray($styleThickBrownBorderOutline);
        $activeSheet->getColumnDimension('D')->setAutoSize(true);
        break;
      case 5:
        $activeSheet->mergeCells('A1:E1');
        $activeSheet->getStyle('A1:E1')->applyFromArray($styleThickBrownBorderOutline);
        $activeSheet->getColumnDimension('D')->setAutoSize(true);
        $activeSheet->getColumnDimension('E')->setAutoSize(true);
        break;
      case 6:
        $activeSheet->mergeCells('A1:F1');
        $activeSheet->getStyle('A1:EF')->applyFromArray($styleThickBrownBorderOutline);
        $activeSheet->getColumnDimension('D')->setAutoSize(true);
        $activeSheet->getColumnDimension('E')->setAutoSize(true);
        $activeSheet->getColumnDimension('F')->setAutoSize(true);
        break;
      case 7:
        $activeSheet->mergeCells('A1:G1');
        $activeSheet->getStyle('A1:G1')->applyFromArray($styleThickBrownBorderOutline);
        $activeSheet->getColumnDimension('D')->setAutoSize(true);
        $activeSheet->getColumnDimension('E')->setAutoSize(true);
        $activeSheet->getColumnDimension('F')->setAutoSize(true);
        $activeSheet->getColumnDimension('G')->setAutoSize(true);
        break;
      case 8:
        $activeSheet->mergeCells('A1:H1');
        $activeSheet->getStyle('A1:H1')->applyFromArray($styleThickBrownBorderOutline);
        $activeSheet->getColumnDimension('D')->setAutoSize(true);
        $activeSheet->getColumnDimension('E')->setAutoSize(true);
        $activeSheet->getColumnDimension('F')->setAutoSize(true);
        $activeSheet->getColumnDimension('G')->setAutoSize(true);
        $activeSheet->getColumnDimension('H')->setAutoSize(true);
        break;
      case 9:
        $activeSheet->mergeCells('A1:I1');
        $activeSheet->getStyle('A1:I1')->applyFromArray($styleThickBrownBorderOutline);
        $activeSheet->getColumnDimension('D')->setAutoSize(true);
        $activeSheet->getColumnDimension('E')->setAutoSize(true);
        $activeSheet->getColumnDimension('F')->setAutoSize(true);
        $activeSheet->getColumnDimension('G')->setAutoSize(true);
        $activeSheet->getColumnDimension('H')->setAutoSize(true);
        $activeSheet->getColumnDimension('I')->setAutoSize(true);
        break;
      case 10:
      default:
        $activeSheet->mergeCells('A1:J1');
        $activeSheet->getStyle('A1:J1')->applyFromArray($styleThickBrownBorderOutline);
        $activeSheet->getColumnDimension('D')->setAutoSize(true);
        $activeSheet->getColumnDimension('E')->setAutoSize(true);
        $activeSheet->getColumnDimension('F')->setAutoSize(true);
        $activeSheet->getColumnDimension('G')->setAutoSize(true);
        $activeSheet->getColumnDimension('H')->setAutoSize(true);
        $activeSheet->getColumnDimension('I')->setAutoSize(true);
        $activeSheet->getColumnDimension('J')->setAutoSize(true);
        break;
      }

      $styleThinBlackBorderOutline = array(
        'borders' => array(
          'outline' => array(
            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
            'color' => array('argb' => 'FF000000'),
          ),
        ),
      );

      switch ($info["typeStats"]) {
      case "group_02":
        $activeSheet->getCell('A2')->setValue(strtoupper($this->translate('statistics.group.modtype')));
        $activeSheet->getCell('B2')->setValue(strtoupper($this->translate('_common.brand')));
        $activeSheet->getCell('C2')->setValue(strtoupper($this->translate('_common.line')));
        $activeSheet->getStyle('A2:E2')->applyFromArray($styleThinBlackBorderOutline);
        $activeSheet->getStyle('A2:E2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

        if ($info['multistats'] == "false") {
          $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.quantity')));
          $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.amount.net')));
        } else {
          $activeSheet->getStyle('F2:G2')->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('F2:G2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
          if ($info['times'] == 2) {
            $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time']);
            $activeSheet->getCell('F2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time']);
            if (isset($info['time2'])) {
              $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time2']);
              $activeSheet->getCell('G2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time2']);
            } else {
              $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time3']);
              $activeSheet->getCell('G2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time3']);
            }
          } else {
            $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time']);
            $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time2']);
            $activeSheet->getCell('F2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time3']);
            $activeSheet->getCell('G2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time']);
            $activeSheet->getCell('H2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time2']);
            $activeSheet->getCell('I2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time3']);
            $activeSheet->getStyle('H2:I2')->applyFromArray($styleThinBlackBorderOutline);
            $activeSheet->getStyle('H2:I2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
          }
        }
        break;
      case "group_03":
        $activeSheet->getCell('A2')->setValue(strtoupper($this->translate('_common.brand')));
        $activeSheet->getCell('B2')->setValue(strtoupper($this->translate('_common.line')));
        $activeSheet->getStyle('A2:D2')->applyFromArray($styleThinBlackBorderOutline);
        $activeSheet->getStyle('A2:D2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

        if ($info['multistats'] == "false") {
          $activeSheet->getCell('C2')->setValue(strtoupper($this->translate('_common.quantity')));
          $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.amount.net')));
        } else {
          $activeSheet->getStyle('E2:F2')->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('E2:F2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
          if ($info['times'] == 2) {
            $activeSheet->getCell('C2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time']);
            $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time']);
            if (isset($info['time2'])) {
              $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time2']);
              $activeSheet->getCell('F2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time2']);
            } else {
              $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time3']);
              $activeSheet->getCell('F2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time3']);
            }
          } else {
            $activeSheet->getCell('C2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time']);
            $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time2']);
            $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time3']);
            $activeSheet->getCell('F2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time']);
            $activeSheet->getCell('G2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time2']);
            $activeSheet->getCell('H2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time3']);
            $activeSheet->getStyle('G2:H2')->applyFromArray($styleThinBlackBorderOutline);
            $activeSheet->getStyle('G2:H2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
          }
        }
        break;
      case "group_04":
        $activeSheet->getCell('A2')->setValue(strtoupper($this->translate('_common.brand')));
        $activeSheet->getCell('B2')->setValue(strtoupper($this->translate('_common.line')));
        $activeSheet->getCell('C2')->setValue(strtoupper($this->translate('_common.model')));
        $activeSheet->getStyle('A2:E2')->applyFromArray($styleThinBlackBorderOutline);
        $activeSheet->getStyle('A2:E2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

        if ($info['multistats'] == "false") {
          $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.quantity')));
          $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.amount.net')));
        } else {
          $activeSheet->getStyle('F2:G2')->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('F2:G2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
          if ($info['times'] == 2) {
            $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time']);
            $activeSheet->getCell('F2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time']);
            if (isset($info['time2'])) {
              $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time2']);
              $activeSheet->getCell('G2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time2']);
            } else {
              $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time3']);
              $activeSheet->getCell('G2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time3']);
            }
          } else {
            $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time']);
            $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time2']);
            $activeSheet->getCell('F2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time3']);
            $activeSheet->getCell('G2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time']);
            $activeSheet->getCell('H2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time2']);
            $activeSheet->getCell('I2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time3']);
            $activeSheet->getStyle('H2:I2')->applyFromArray($styleThinBlackBorderOutline);
            $activeSheet->getStyle('H2:I2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
          }
        }
        break;
      case "group_05":
        $activeSheet->getCell('A2')->setValue(strtoupper($this->translate('_common.brand')));
        $activeSheet->getCell('B2')->setValue(strtoupper($this->translate('_common.line')));
        $activeSheet->getCell('C2')->setValue(strtoupper($this->translate('_common.article')));
        $activeSheet->getStyle('A2:E2')->applyFromArray($styleThinBlackBorderOutline);
        $activeSheet->getStyle('A2:E2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

        if ($info['multistats'] == "false") {
          $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.quantity')));
          $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.amount.net')));
        } else {
          $activeSheet->getStyle('F2:G2')->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('F2:G2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
          if ($info['times'] == 2) {
            $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time']);
            $activeSheet->getCell('F2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time']);
            if (isset($info['time2'])) {
              $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time2']);
              $activeSheet->getCell('G2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time2']);
            } else {
              $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time3']);
              $activeSheet->getCell('G2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time3']);
            }
          } else {
            $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time']);
            $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time2']);
            $activeSheet->getCell('F2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time3']);
            $activeSheet->getCell('G2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time']);
            $activeSheet->getCell('H2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time2']);
            $activeSheet->getCell('I2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time3']);
            $activeSheet->getStyle('H2:I2')->applyFromArray($styleThinBlackBorderOutline);
            $activeSheet->getStyle('H2:I2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
          }
        }
        break;
      case "group_06":
        $activeSheet->getCell('A2')->setValue(strtoupper($this->translate('_common.brand')));
        $activeSheet->getCell('B2')->setValue(strtoupper($this->translate('_common.line')));
        $activeSheet->getCell('C2')->setValue(strtoupper($this->translate('statistics.group.modtype')));
        $activeSheet->getStyle('A2:E2')->applyFromArray($styleThinBlackBorderOutline);
        $activeSheet->getStyle('A2:E2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

        if ($info['multistats'] == "false") {
          $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.quantity')));
          $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.amount.net')));
        } else {
          $activeSheet->getStyle('F2:G2')->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('F2:G2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
          if ($info['times'] == 2) {
            $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time']);
            $activeSheet->getCell('F2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time']);
            if (isset($info['time2'])) {
              $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time2']);
              $activeSheet->getCell('G2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time2']);
            } else {
              $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time3']);
              $activeSheet->getCell('G2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time3']);
            }
          } else {
            $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time']);
            $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time2']);
            $activeSheet->getCell('F2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time3']);
            $activeSheet->getCell('G2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time']);
            $activeSheet->getCell('H2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time2']);
            $activeSheet->getCell('I2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time3']);
            $activeSheet->getStyle('H2:I2')->applyFromArray($styleThinBlackBorderOutline);
            $activeSheet->getStyle('H2:I2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
          }
        }
        break;
      case "group_07":
        $activeSheet->getCell('A2')->setValue(strtoupper($this->translate('_common.brand')));
        $activeSheet->getCell('B2')->setValue(strtoupper($this->translate('_common.line')));
        $activeSheet->getCell('C2')->setValue(strtoupper($this->translate('_common.series')));
        $activeSheet->getStyle('A2:E2')->applyFromArray($styleThinBlackBorderOutline);
        $activeSheet->getStyle('A2:E2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

        if ($info['multistats'] == "false") {
          $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.quantity')));
          $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.amount.net')));
        } else {
          $activeSheet->getStyle('F2:G2')->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('F2:G2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
          if ($info['times'] == 2) {
            $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time']);
            $activeSheet->getCell('F2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time']);
            if (isset($info['time2'])) {
              $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time2']);
              $activeSheet->getCell('G2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time2']);
            } else {
              $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time3']);
              $activeSheet->getCell('G2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time3']);
            }
          } else {
            $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time']);
            $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time2']);
            $activeSheet->getCell('F2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time3']);
            $activeSheet->getCell('G2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time']);
            $activeSheet->getCell('H2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time2']);
            $activeSheet->getCell('I2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time3']);
            $activeSheet->getStyle('H2:I2')->applyFromArray($styleThinBlackBorderOutline);
            $activeSheet->getStyle('H2:I2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
          }
        }
        break;
      case "group_08":
        $activeSheet->getCell('A2')->setValue(strtoupper($this->translate('_common.customer')));
        $activeSheet->getStyle('A2:C2')->applyFromArray($styleThinBlackBorderOutline);
        $activeSheet->getStyle('A2:C2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

        if ($info['multistats'] == "false") {
          $activeSheet->getCell('B2')->setValue(strtoupper($this->translate('_common.quantity')));
          $activeSheet->getCell('C2')->setValue(strtoupper($this->translate('_common.amount.net')));
        } else {
          $activeSheet->getStyle('D2:E2')->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('D2:E2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
          if ($info['times'] == 2) {
            $activeSheet->getCell('B2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time']);
            $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time']);
            if (isset($info['time2'])) {
              $activeSheet->getCell('C2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time2']);
              $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time2']);
            } else {
              $activeSheet->getCell('C2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time3']);
              $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time3']);
            }
          } else {
            $activeSheet->getCell('B2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time']);
            $activeSheet->getCell('C2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time2']);
            $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time3']);
            $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time']);
            $activeSheet->getCell('F2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time2']);
            $activeSheet->getCell('G2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time3']);
            $activeSheet->getStyle('F2:G2')->applyFromArray($styleThinBlackBorderOutline);
            $activeSheet->getStyle('F2:G2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
          }
        }
        break;
      case "group_09":
        $activeSheet->getCell('A2')->setValue(strtoupper($this->translate('_common.customer')));
        $activeSheet->getCell('B2')->setValue(strtoupper($this->translate('statistics.group.modtype')));
        $activeSheet->getStyle('A2:D2')->applyFromArray($styleThinBlackBorderOutline);
        $activeSheet->getStyle('A2:D2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

        if ($info['multistats'] == "false") {
          $activeSheet->getCell('C2')->setValue(strtoupper($this->translate('_common.quantity')));
          $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.amount.net')));
        } else {
          $activeSheet->getStyle('E2:F2')->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('E2:F2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
          if ($info['times'] == 2) {
            $activeSheet->getCell('C2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time']);
            $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time']);
            if (isset($info['time2'])) {
              $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time2']);
              $activeSheet->getCell('F2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time2']);
            } else {
              $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time3']);
              $activeSheet->getCell('F2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time3']);
            }
          } else {
            $activeSheet->getCell('C2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time']);
            $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time2']);
            $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time3']);
            $activeSheet->getCell('F2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time']);
            $activeSheet->getCell('G2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time2']);
            $activeSheet->getCell('H2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time3']);
            $activeSheet->getStyle('G2:H2')->applyFromArray($styleThinBlackBorderOutline);
            $activeSheet->getStyle('G2:H2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
          }
        }
        break;
      case "group_10":
        $activeSheet->getCell('A2')->setValue(strtoupper($this->translate('_common.customer')));
        $activeSheet->getCell('B2')->setValue(strtoupper($this->translate('_common.brand')));
        $activeSheet->getCell('C2')->setValue(strtoupper($this->translate('_common.line')));
        $activeSheet->getStyle('A2:E2')->applyFromArray($styleThinBlackBorderOutline);
        $activeSheet->getStyle('A2:E2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

        if ($info['multistats'] == "false") {
          $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.quantity')));
          $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.amount.net')));
        } else {
          $activeSheet->getStyle('F2:G2')->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('F2:G2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
          if ($info['times'] == 2) {
            $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time']);
            $activeSheet->getCell('F2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time']);
            if (isset($info['time2'])) {
              $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time2']);
              $activeSheet->getCell('G2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time2']);
            } else {
              $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time3']);
              $activeSheet->getCell('G2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time3']);
            }
          } else {
            $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time']);
            $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time2']);
            $activeSheet->getCell('F2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time3']);
            $activeSheet->getCell('G2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time']);
            $activeSheet->getCell('H2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time2']);
            $activeSheet->getCell('I2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time3']);
            $activeSheet->getStyle('H2:I2')->applyFromArray($styleThinBlackBorderOutline);
            $activeSheet->getStyle('H2:I2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
          }
        }
        break;
      case "group_11":
        $activeSheet->getCell('A2')->setValue(strtoupper($this->translate('_common.customer')));
        $activeSheet->getCell('B2')->setValue(strtoupper($this->translate('_common.brand')));
        $activeSheet->getCell('C2')->setValue(strtoupper($this->translate('_common.line')));
        $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.model')));
        $activeSheet->getStyle('A2:F2')->applyFromArray($styleThinBlackBorderOutline);
        $activeSheet->getStyle('A2:F2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

        if ($info['multistats'] == "false") {
          $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.quantity')));
          $activeSheet->getCell('F2')->setValue(strtoupper($this->translate('_common.amount.net')));
        } else {
          $activeSheet->getStyle('G2:H2')->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('G2:H2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
          if ($info['times'] == 2) {
            $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time']);
            $activeSheet->getCell('G2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time']);
            if (isset($info['time2'])) {
              $activeSheet->getCell('F2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time2']);
              $activeSheet->getCell('H2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time2']);
            } else {
              $activeSheet->getCell('F2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time3']);
              $activeSheet->getCell('H2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time3']);
            }
          } else {
            $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time']);
            $activeSheet->getCell('F2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time2']);
            $activeSheet->getCell('G2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time3']);
            $activeSheet->getCell('H2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time']);
            $activeSheet->getCell('I2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time2']);
            $activeSheet->getCell('J2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time3']);
            $activeSheet->getStyle('I2:J2')->applyFromArray($styleThinBlackBorderOutline);
            $activeSheet->getStyle('I2:J2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
          }
        }
        break;
      case "group_12":
        $activeSheet->getCell('A2')->setValue(strtoupper($this->translate('_common.customer')));
        $activeSheet->getCell('B2')->setValue(strtoupper($this->translate('_common.brand')));
        $activeSheet->getCell('C2')->setValue(strtoupper($this->translate('_common.line')));
        $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.article')));
        $activeSheet->getStyle('A2:F2')->applyFromArray($styleThinBlackBorderOutline);
        $activeSheet->getStyle('A2:F2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

        if ($info['multistats'] == "false") {
          $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.quantity')));
          $activeSheet->getCell('F2')->setValue(strtoupper($this->translate('_common.amount.net')));
        } else {
          $activeSheet->getStyle('G2:H2')->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('G2:H2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
          if ($info['times'] == 2) {
            $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time']);
            $activeSheet->getCell('G2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time']);
            if (isset($info['time2'])) {
              $activeSheet->getCell('F2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time2']);
              $activeSheet->getCell('H2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time2']);
            } else {
              $activeSheet->getCell('F2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time3']);
              $activeSheet->getCell('H2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time3']);
            }
          } else {
            $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time']);
            $activeSheet->getCell('F2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time2']);
            $activeSheet->getCell('G2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time3']);
            $activeSheet->getCell('H2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time']);
            $activeSheet->getCell('I2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time2']);
            $activeSheet->getCell('J2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time3']);
            $activeSheet->getStyle('I2:J2')->applyFromArray($styleThinBlackBorderOutline);
            $activeSheet->getStyle('I2:J2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
          }
        }
        break;
      case "group_01":
      default:
        $activeSheet->getCell('A2')->setValue(strtoupper($this->translate('statistics.group.modtype')));
        $activeSheet->getStyle('A2:C2')->applyFromArray($styleThinBlackBorderOutline);
        $activeSheet->getStyle('A2:C2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

        if ($info['multistats'] == "false") {
          $activeSheet->getCell('B2')->setValue(strtoupper($this->translate('_common.quantity')));
          $activeSheet->getCell('C2')->setValue(strtoupper($this->translate('_common.amount.net')));
        } else {
          $activeSheet->getStyle('D2:E2')->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('D2:E2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
          if ($info['times'] == 2) {
            $activeSheet->getCell('B2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time']);
            $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time']);
            if (isset($info['time2'])) {
              $activeSheet->getCell('C2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time2']);
              $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time2']);
            } else {
              $activeSheet->getCell('C2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time3']);
              $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time3']);
            }
          } else {
            $activeSheet->getCell('B2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time']);
            $activeSheet->getCell('C2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time2']);
            $activeSheet->getCell('D2')->setValue(strtoupper($this->translate('_common.quantity')) . " " . $info['time3']);
            $activeSheet->getCell('E2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time']);
            $activeSheet->getCell('F2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time2']);
            $activeSheet->getCell('G2')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['time3']);
            $activeSheet->getStyle('F2:G2')->applyFromArray($styleThinBlackBorderOutline);
            $activeSheet->getStyle('F2:G2')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
          }
        }
        break;
      }

      for ($i = 0; $i < count($rows); $i++) {
        switch ($info["typeStats"]) {
        case "group_02":
          $activeSheet->getStyle('D' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
          $activeSheet->getStyle('E' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
          $activeSheet->getStyle('A' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('B' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('C' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('D' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('E' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);

          if ($info['multistats'] == "false") {
            $activeSheet->getCell('A' . (3 + $i))->setValue($rows[$i]["tipmod"]);
            $activeSheet->getCell('B' . (3 + $i))->setValue($rows[$i]["titlin"]);
            $activeSheet->getCell('C' . (3 + $i))->setValue($rows[$i]["lineam"]);
            $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["qtatot1"]);
            $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["impnet1"]);
          } else {
            $activeSheet->getCell('A' . (3 + $i))->setValue($rows[$i]["mot"]);
            $activeSheet->getCell('B' . (3 + $i))->setValue($rows[$i]["brn"]);
            $activeSheet->getCell('C' . (3 + $i))->setValue($rows[$i]["lin"]);
            $activeSheet->getStyle('F' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $activeSheet->getStyle('G' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $activeSheet->getStyle('F' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            $activeSheet->getStyle('G' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            if ($info['times'] == 2) {
              $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["qty1"]);
              $activeSheet->getCell('F' . (3 + $i))->setValue($rows[$i]["imp1"]);
              if (isset($info['time2'])) {
                $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["qty2"]);
                $activeSheet->getCell('G' . (3 + $i))->setValue($rows[$i]["imp2"]);
              } else {
                $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["qty3"]);
                $activeSheet->getCell('G' . (3 + $i))->setValue($rows[$i]["imp3"]);
              }
            } else {
              $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["qty1"]);
              $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["qty2"]);
              $activeSheet->getCell('F' . (3 + $i))->setValue($rows[$i]["qty3"]);
              $activeSheet->getCell('G' . (3 + $i))->setValue($rows[$i]["imp1"]);
              $activeSheet->getCell('H' . (3 + $i))->setValue($rows[$i]["imp2"]);
              $activeSheet->getCell('I' . (3 + $i))->setValue($rows[$i]["imp3"]);
              $activeSheet->getStyle('H' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
              $activeSheet->getStyle('I' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
              $activeSheet->getStyle('H' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
              $activeSheet->getStyle('I' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            }
          }
          break;
        case "group_03":
          $activeSheet->getStyle('C' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
          $activeSheet->getStyle('D' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
          $activeSheet->getStyle('A' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('B' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('C' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('D' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);

          if ($info['multistats'] == "false") {
            $activeSheet->getCell('A' . (3 + $i))->setValue($rows[$i]["titlin"]);
            $activeSheet->getCell('B' . (3 + $i))->setValue($rows[$i]["lineam"]);
            $activeSheet->getCell('C' . (3 + $i))->setValue($rows[$i]["qtatot1"]);
            $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["impnet1"]);
          } else {
            $activeSheet->getCell('A' . (3 + $i))->setValue($rows[$i]["brn"]);
            $activeSheet->getCell('B' . (3 + $i))->setValue($rows[$i]["lin"]);
            $activeSheet->getStyle('E' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $activeSheet->getStyle('F' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $activeSheet->getStyle('E' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            $activeSheet->getStyle('F' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            if ($info['times'] == 2) {
              $activeSheet->getCell('C' . (3 + $i))->setValue($rows[$i]["qty1"]);
              $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["imp1"]);
              if (isset($info['time2'])) {
                $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["qty2"]);
                $activeSheet->getCell('F' . (3 + $i))->setValue($rows[$i]["imp2"]);
              } else {
                $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["qty3"]);
                $activeSheet->getCell('F' . (3 + $i))->setValue($rows[$i]["imp3"]);
              }
            } else {
              $activeSheet->getCell('C' . (3 + $i))->setValue($rows[$i]["qty1"]);
              $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["qty2"]);
              $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["qty3"]);
              $activeSheet->getCell('F' . (3 + $i))->setValue($rows[$i]["imp1"]);
              $activeSheet->getCell('G' . (3 + $i))->setValue($rows[$i]["imp2"]);
              $activeSheet->getCell('H' . (3 + $i))->setValue($rows[$i]["imp3"]);
              $activeSheet->getStyle('G' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
              $activeSheet->getStyle('H' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
              $activeSheet->getStyle('G' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
              $activeSheet->getStyle('H' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            }
          }
          break;
        case "group_04":
          $activeSheet->getStyle('D' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
          $activeSheet->getStyle('E' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
          $activeSheet->getStyle('A' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('B' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('C' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('D' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('E' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);

          if ($info['multistats'] == "false") {
            $activeSheet->getCell('A' . (3 + $i))->setValue($rows[$i]["titlin"]);
            $activeSheet->getCell('B' . (3 + $i))->setValue($rows[$i]["lineam"]);
            $activeSheet->getCell('C' . (3 + $i))->setValue($rows[$i]["codneu"] . " " . $rows[$i]["desneu"]);
            $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["qtatot1"]);
            $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["impnet1"]);
          } else {
            $activeSheet->getCell('A' . (3 + $i))->setValue($rows[$i]["brn"]);
            $activeSheet->getCell('B' . (3 + $i))->setValue($rows[$i]["lin"]);
            $activeSheet->getCell('C' . (3 + $i))->setValue($rows[$i]["mod"]);
            $activeSheet->getStyle('F' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $activeSheet->getStyle('G' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $activeSheet->getStyle('F' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            $activeSheet->getStyle('G' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            if ($info['times'] == 2) {
              $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["qty1"]);
              $activeSheet->getCell('F' . (3 + $i))->setValue($rows[$i]["imp1"]);
              if (isset($info['time2'])) {
                $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["qty2"]);
                $activeSheet->getCell('G' . (3 + $i))->setValue($rows[$i]["imp2"]);
              } else {
                $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["qty3"]);
                $activeSheet->getCell('G' . (3 + $i))->setValue($rows[$i]["imp3"]);
              }
            } else {
              $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["qty1"]);
              $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["qty2"]);
              $activeSheet->getCell('F' . (3 + $i))->setValue($rows[$i]["qty3"]);
              $activeSheet->getCell('G' . (3 + $i))->setValue($rows[$i]["imp1"]);
              $activeSheet->getCell('H' . (3 + $i))->setValue($rows[$i]["imp2"]);
              $activeSheet->getCell('I' . (3 + $i))->setValue($rows[$i]["imp3"]);
              $activeSheet->getStyle('H' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
              $activeSheet->getStyle('I' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
              $activeSheet->getStyle('H' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
              $activeSheet->getStyle('I' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            }
          }
          break;
        case "group_05":
          $activeSheet->getStyle('D' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
          $activeSheet->getStyle('E' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
          $activeSheet->getStyle('A' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('B' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('C' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('D' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('E' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);

          if ($info['multistats'] == "false") {
            $activeSheet->getCell('A' . (3 + $i))->setValue($rows[$i]["titlin"]);
            $activeSheet->getCell('B' . (3 + $i))->setValue($rows[$i]["lineam"]);
            $activeSheet->getCell('C' . (3 + $i))->setValue($rows[$i]["codart"] . " " . $rows[$i]["desart"]);
            $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["qtatot1"]);
            $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["impnet1"]);
          } else {
            $activeSheet->getCell('A' . (3 + $i))->setValue($rows[$i]["brn"]);
            $activeSheet->getCell('B' . (3 + $i))->setValue($rows[$i]["lin"]);
            $activeSheet->getCell('C' . (3 + $i))->setValue($rows[$i]["art"]);
            $activeSheet->getStyle('F' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $activeSheet->getStyle('G' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $activeSheet->getStyle('F' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            $activeSheet->getStyle('G' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            if ($info['times'] == 2) {
              $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["qty1"]);
              $activeSheet->getCell('F' . (3 + $i))->setValue($rows[$i]["imp1"]);
              if (isset($info['time2'])) {
                $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["qty2"]);
                $activeSheet->getCell('G' . (3 + $i))->setValue($rows[$i]["imp2"]);
              } else {
                $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["qty3"]);
                $activeSheet->getCell('G' . (3 + $i))->setValue($rows[$i]["imp3"]);
              }
            } else {
              $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["qty1"]);
              $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["qty2"]);
              $activeSheet->getCell('F' . (3 + $i))->setValue($rows[$i]["qty3"]);
              $activeSheet->getCell('G' . (3 + $i))->setValue($rows[$i]["imp1"]);
              $activeSheet->getCell('H' . (3 + $i))->setValue($rows[$i]["imp2"]);
              $activeSheet->getCell('I' . (3 + $i))->setValue($rows[$i]["imp3"]);
              $activeSheet->getStyle('H' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
              $activeSheet->getStyle('I' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
              $activeSheet->getStyle('H' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
              $activeSheet->getStyle('I' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            }
          }
          break;
        case "group_06":
          $activeSheet->getStyle('D' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
          $activeSheet->getStyle('E' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
          $activeSheet->getStyle('A' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('B' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('C' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('D' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('E' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);

          if ($info['multistats'] == "false") {
            $activeSheet->getCell('A' . (3 + $i))->setValue($rows[$i]["titlin"]);
            $activeSheet->getCell('B' . (3 + $i))->setValue($rows[$i]["lineam"]);
            $activeSheet->getCell('C' . (3 + $i))->setValue($rows[$i]["tipmod"]);
            $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["qtatot1"]);
            $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["impnet1"]);
          } else {
            $activeSheet->getCell('A' . (3 + $i))->setValue($rows[$i]["brn"]);
            $activeSheet->getCell('B' . (3 + $i))->setValue($rows[$i]["lin"]);
            $activeSheet->getCell('C' . (3 + $i))->setValue($rows[$i]["mot"]);
            $activeSheet->getStyle('F' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $activeSheet->getStyle('G' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $activeSheet->getStyle('F' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            $activeSheet->getStyle('G' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            if ($info['times'] == 2) {
              $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["qty1"]);
              $activeSheet->getCell('F' . (3 + $i))->setValue($rows[$i]["imp1"]);
              if (isset($info['time2'])) {
                $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["qty2"]);
                $activeSheet->getCell('G' . (3 + $i))->setValue($rows[$i]["imp2"]);
              } else {
                $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["qty3"]);
                $activeSheet->getCell('G' . (3 + $i))->setValue($rows[$i]["imp3"]);
              }
            } else {
              $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["qty1"]);
              $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["qty2"]);
              $activeSheet->getCell('F' . (3 + $i))->setValue($rows[$i]["qty3"]);
              $activeSheet->getCell('G' . (3 + $i))->setValue($rows[$i]["imp1"]);
              $activeSheet->getCell('H' . (3 + $i))->setValue($rows[$i]["imp2"]);
              $activeSheet->getCell('I' . (3 + $i))->setValue($rows[$i]["imp3"]);
              $activeSheet->getStyle('H' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
              $activeSheet->getStyle('I' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
              $activeSheet->getStyle('H' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
              $activeSheet->getStyle('I' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            }
          }
          break;
        case "group_07":
          $activeSheet->getStyle('D' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
          $activeSheet->getStyle('E' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
          $activeSheet->getStyle('A' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('B' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('C' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('D' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('E' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);

          if ($info['multistats'] == "false") {
            $activeSheet->getCell('A' . (3 + $i))->setValue($rows[$i]["titlin"]);
            $activeSheet->getCell('B' . (3 + $i))->setValue($rows[$i]["lineam"]);
            $activeSheet->getCell('C' . (3 + $i))->setValue($rows[$i]["seriem"]);
            $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["qtatot1"]);
            $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["impnet1"]);
          } else {
            $activeSheet->getCell('A' . (3 + $i))->setValue($rows[$i]["brn"]);
            $activeSheet->getCell('B' . (3 + $i))->setValue($rows[$i]["lin"]);
            $activeSheet->getCell('C' . (3 + $i))->setValue($rows[$i]["ser"]);
            $activeSheet->getStyle('F' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $activeSheet->getStyle('G' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $activeSheet->getStyle('F' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            $activeSheet->getStyle('G' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            if ($info['times'] == 2) {
              $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["qty1"]);
              $activeSheet->getCell('F' . (3 + $i))->setValue($rows[$i]["imp1"]);
              if (isset($info['time2'])) {
                $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["qty2"]);
                $activeSheet->getCell('G' . (3 + $i))->setValue($rows[$i]["imp2"]);
              } else {
                $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["qty3"]);
                $activeSheet->getCell('G' . (3 + $i))->setValue($rows[$i]["imp3"]);
              }
            } else {
              $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["qty1"]);
              $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["qty2"]);
              $activeSheet->getCell('F' . (3 + $i))->setValue($rows[$i]["qty3"]);
              $activeSheet->getCell('G' . (3 + $i))->setValue($rows[$i]["imp1"]);
              $activeSheet->getCell('H' . (3 + $i))->setValue($rows[$i]["imp2"]);
              $activeSheet->getCell('I' . (3 + $i))->setValue($rows[$i]["imp3"]);
              $activeSheet->getStyle('H' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
              $activeSheet->getStyle('I' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
              $activeSheet->getStyle('H' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
              $activeSheet->getStyle('I' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            }
          }
          break;
        case "group_08":
          $activeSheet->getStyle('B' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
          $activeSheet->getStyle('C' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
          $activeSheet->getStyle('A' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('B' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('C' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);

          if ($info['multistats'] == "false") {
            $activeSheet->getCell('A' . (3 + $i))->setValue($rows[$i]["ragsoc"] . " (" . $rows[$i]["codana"] . "), " . $rows[$i]["nazion"]);
            $activeSheet->getCell('B' . (3 + $i))->setValue($rows[$i]["qtatot1"]);
            $activeSheet->getCell('C' . (3 + $i))->setValue($rows[$i]["impnet1"]);
          } else {
            $activeSheet->getCell('A' . (3 + $i))->setValue($rows[$i]["cus"]);
            $activeSheet->getStyle('D' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $activeSheet->getStyle('E' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $activeSheet->getStyle('D' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            $activeSheet->getStyle('E' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            if ($info['times'] == 2) {
              $activeSheet->getCell('B' . (3 + $i))->setValue($rows[$i]["qty1"]);
              $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["imp1"]);
              if (isset($info['time2'])) {
                $activeSheet->getCell('C' . (3 + $i))->setValue($rows[$i]["qty2"]);
                $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["imp2"]);
              } else {
                $activeSheet->getCell('C' . (3 + $i))->setValue($rows[$i]["qty3"]);
                $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["imp3"]);
              }
            } else {
              $activeSheet->getCell('B' . (3 + $i))->setValue($rows[$i]["qty1"]);
              $activeSheet->getCell('C' . (3 + $i))->setValue($rows[$i]["qty2"]);
              $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["qty3"]);
              $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["imp1"]);
              $activeSheet->getCell('F' . (3 + $i))->setValue($rows[$i]["imp2"]);
              $activeSheet->getCell('G' . (3 + $i))->setValue($rows[$i]["imp3"]);
              $activeSheet->getStyle('F' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
              $activeSheet->getStyle('G' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
              $activeSheet->getStyle('F' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
              $activeSheet->getStyle('G' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            }
          }
          break;
        case "group_09":
          $activeSheet->getStyle('C' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
          $activeSheet->getStyle('D' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
          $activeSheet->getStyle('A' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('B' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('C' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('D' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);

          if ($info['multistats'] == "false") {
            $activeSheet->getCell('A' . (3 + $i))->setValue($rows[$i]["ragsoc"] . " (" . $rows[$i]["codana"] . "), " . $rows[$i]["nazion"]);
            $activeSheet->getCell('B' . (3 + $i))->setValue($rows[$i]["tipmod"]);
            $activeSheet->getCell('C' . (3 + $i))->setValue($rows[$i]["qtatot1"]);
            $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["impnet1"]);
          } else {
            $activeSheet->getCell('A' . (3 + $i))->setValue($rows[$i]["cus"]);
            $activeSheet->getCell('B' . (3 + $i))->setValue($rows[$i]["mot"]);
            $activeSheet->getStyle('E' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $activeSheet->getStyle('F' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $activeSheet->getStyle('E' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            $activeSheet->getStyle('F' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            if ($info['times'] == 2) {
              $activeSheet->getCell('C' . (3 + $i))->setValue($rows[$i]["qty1"]);
              $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["imp1"]);
              if (isset($info['time2'])) {
                $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["qty2"]);
                $activeSheet->getCell('F' . (3 + $i))->setValue($rows[$i]["imp2"]);
              } else {
                $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["qty3"]);
                $activeSheet->getCell('F' . (3 + $i))->setValue($rows[$i]["imp3"]);
              }
            } else {
              $activeSheet->getCell('C' . (3 + $i))->setValue($rows[$i]["qty1"]);
              $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["qty2"]);
              $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["qty3"]);
              $activeSheet->getCell('F' . (3 + $i))->setValue($rows[$i]["imp1"]);
              $activeSheet->getCell('G' . (3 + $i))->setValue($rows[$i]["imp2"]);
              $activeSheet->getCell('H' . (3 + $i))->setValue($rows[$i]["imp3"]);
              $activeSheet->getStyle('G' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
              $activeSheet->getStyle('H' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
              $activeSheet->getStyle('G' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
              $activeSheet->getStyle('H' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            }
          }
          break;
        case "group_10":
          $activeSheet->getStyle('D' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
          $activeSheet->getStyle('E' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
          $activeSheet->getStyle('A' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('B' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('C' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('D' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('E' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);

          if ($info['multistats'] == "false") {
            $activeSheet->getCell('A' . (3 + $i))->setValue($rows[$i]["ragsoc"] . " (" . $rows[$i]["codana"] . "), " . $rows[$i]["nazion"]);
            $activeSheet->getCell('B' . (3 + $i))->setValue($rows[$i]["titlin"]);
            $activeSheet->getCell('C' . (3 + $i))->setValue($rows[$i]["lineam"]);
            $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["qtatot1"]);
            $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["impnet1"]);
          } else {
            $activeSheet->getCell('A' . (3 + $i))->setValue($rows[$i]["cus"]);
            $activeSheet->getCell('B' . (3 + $i))->setValue($rows[$i]["brn"]);
            $activeSheet->getCell('C' . (3 + $i))->setValue($rows[$i]["lin"]);
            $activeSheet->getStyle('F' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $activeSheet->getStyle('G' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $activeSheet->getStyle('F' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            $activeSheet->getStyle('G' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            if ($info['times'] == 2) {
              $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["qty1"]);
              $activeSheet->getCell('F' . (3 + $i))->setValue($rows[$i]["imp1"]);
              if (isset($info['time2'])) {
                $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["qty2"]);
                $activeSheet->getCell('G' . (3 + $i))->setValue($rows[$i]["imp2"]);
              } else {
                $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["qty3"]);
                $activeSheet->getCell('G' . (3 + $i))->setValue($rows[$i]["imp3"]);
              }
            } else {
              $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["qty1"]);
              $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["qty2"]);
              $activeSheet->getCell('F' . (3 + $i))->setValue($rows[$i]["qty3"]);
              $activeSheet->getCell('G' . (3 + $i))->setValue($rows[$i]["imp1"]);
              $activeSheet->getCell('H' . (3 + $i))->setValue($rows[$i]["imp2"]);
              $activeSheet->getCell('I' . (3 + $i))->setValue($rows[$i]["imp3"]);
              $activeSheet->getStyle('H' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
              $activeSheet->getStyle('I' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
              $activeSheet->getStyle('H' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
              $activeSheet->getStyle('I' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            }
          }
          break;
        case "group_11":
          $activeSheet->getStyle('E' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
          $activeSheet->getStyle('F' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
          $activeSheet->getStyle('A' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('B' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('C' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('D' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('E' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('F' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);

          if ($info['multistats'] == "false") {
            $activeSheet->getCell('A' . (3 + $i))->setValue($rows[$i]["ragsoc"] . " (" . $rows[$i]["codana"] . "), " . $rows[$i]["nazion"]);
            $activeSheet->getCell('B' . (3 + $i))->setValue($rows[$i]["titlin"]);
            $activeSheet->getCell('C' . (3 + $i))->setValue($rows[$i]["lineam"]);
            $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["codneu"] . " " . $rows[$i]["desneu"]);
            $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["qtatot1"]);
            $activeSheet->getCell('F' . (3 + $i))->setValue($rows[$i]["impnet1"]);
          } else {
            $activeSheet->getCell('A' . (3 + $i))->setValue($rows[$i]["cus"]);
            $activeSheet->getCell('B' . (3 + $i))->setValue($rows[$i]["brn"]);
            $activeSheet->getCell('C' . (3 + $i))->setValue($rows[$i]["lin"]);
            $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["mod"]);
            $activeSheet->getStyle('G' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $activeSheet->getStyle('H' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $activeSheet->getStyle('G' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            $activeSheet->getStyle('H' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            if ($info['times'] == 2) {
              $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["qty1"]);
              $activeSheet->getCell('G' . (3 + $i))->setValue($rows[$i]["imp1"]);
              if (isset($info['time2'])) {
                $activeSheet->getCell('F' . (3 + $i))->setValue($rows[$i]["qty2"]);
                $activeSheet->getCell('H' . (3 + $i))->setValue($rows[$i]["imp2"]);
              } else {
                $activeSheet->getCell('F' . (3 + $i))->setValue($rows[$i]["qty3"]);
                $activeSheet->getCell('H' . (3 + $i))->setValue($rows[$i]["imp3"]);
              }
            } else {
              $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["qty1"]);
              $activeSheet->getCell('F' . (3 + $i))->setValue($rows[$i]["qty2"]);
              $activeSheet->getCell('G' . (3 + $i))->setValue($rows[$i]["qty3"]);
              $activeSheet->getCell('H' . (3 + $i))->setValue($rows[$i]["imp1"]);
              $activeSheet->getCell('I' . (3 + $i))->setValue($rows[$i]["imp2"]);
              $activeSheet->getCell('J' . (3 + $i))->setValue($rows[$i]["imp3"]);
              $activeSheet->getStyle('I' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
              $activeSheet->getStyle('J' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
              $activeSheet->getStyle('I' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
              $activeSheet->getStyle('J' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            }
          }
          break;
        case "group_12":
          $activeSheet->getStyle('E' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
          $activeSheet->getStyle('F' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
          $activeSheet->getStyle('A' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('B' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('C' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('D' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('E' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('F' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);

          if ($info['multistats'] == "false") {
            $activeSheet->getCell('A' . (3 + $i))->setValue($rows[$i]["ragsoc"] . " (" . $rows[$i]["codana"] . "), " . $rows[$i]["nazion"]);
            $activeSheet->getCell('B' . (3 + $i))->setValue($rows[$i]["titlin"]);
            $activeSheet->getCell('C' . (3 + $i))->setValue($rows[$i]["lineam"]);
            $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["codart"] . " " . $rows[$i]["desart"]);
            $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["qtatot1"]);
            $activeSheet->getCell('F' . (3 + $i))->setValue($rows[$i]["impnet1"]);
          } else {
            $activeSheet->getCell('A' . (3 + $i))->setValue($rows[$i]["cus"]);
            $activeSheet->getCell('B' . (3 + $i))->setValue($rows[$i]["brn"]);
            $activeSheet->getCell('C' . (3 + $i))->setValue($rows[$i]["lin"]);
            $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["art"]);
            $activeSheet->getStyle('G' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $activeSheet->getStyle('H' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $activeSheet->getStyle('G' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            $activeSheet->getStyle('H' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            if ($info['times'] == 2) {
              $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["qty1"]);
              $activeSheet->getCell('G' . (3 + $i))->setValue($rows[$i]["imp1"]);
              if (isset($info['time2'])) {
                $activeSheet->getCell('F' . (3 + $i))->setValue($rows[$i]["qty2"]);
                $activeSheet->getCell('H' . (3 + $i))->setValue($rows[$i]["imp2"]);
              } else {
                $activeSheet->getCell('F' . (3 + $i))->setValue($rows[$i]["qty3"]);
                $activeSheet->getCell('H' . (3 + $i))->setValue($rows[$i]["imp3"]);
              }
            } else {
              $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["qty1"]);
              $activeSheet->getCell('F' . (3 + $i))->setValue($rows[$i]["qty2"]);
              $activeSheet->getCell('G' . (3 + $i))->setValue($rows[$i]["qty3"]);
              $activeSheet->getCell('H' . (3 + $i))->setValue($rows[$i]["imp1"]);
              $activeSheet->getCell('I' . (3 + $i))->setValue($rows[$i]["imp2"]);
              $activeSheet->getCell('J' . (3 + $i))->setValue($rows[$i]["imp3"]);
              $activeSheet->getStyle('I' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
              $activeSheet->getStyle('J' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
              $activeSheet->getStyle('I' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
              $activeSheet->getStyle('J' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            }
          }
          break;
        case "group_01":
        default:
          $activeSheet->getStyle('B' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
          $activeSheet->getStyle('C' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
          $activeSheet->getStyle('A' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('B' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
          $activeSheet->getStyle('C' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);

          if ($info['multistats'] == "false") {
            $activeSheet->getCell('A' . (3 + $i))->setValue($rows[$i]["tipmod"]);
            $activeSheet->getCell('B' . (3 + $i))->setValue($rows[$i]["qtatot1"]);
            $activeSheet->getCell('C' . (3 + $i))->setValue($rows[$i]["impnet1"]);
          } else {
            $activeSheet->getCell('A' . (3 + $i))->setValue($rows[$i]["mot"]);
            $activeSheet->getStyle('D' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $activeSheet->getStyle('E' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $activeSheet->getStyle('D' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            $activeSheet->getStyle('E' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            if ($info['times'] == 2) {
              $activeSheet->getCell('B' . (3 + $i))->setValue($rows[$i]["qty1"]);
              $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["imp1"]);
              if (isset($info['time2'])) {
                $activeSheet->getCell('C' . (3 + $i))->setValue($rows[$i]["qty2"]);
                $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["imp2"]);
              } else {
                $activeSheet->getCell('C' . (3 + $i))->setValue($rows[$i]["qty3"]);
                $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["imp3"]);
              }
            } else {
              $activeSheet->getCell('B' . (3 + $i))->setValue($rows[$i]["qty1"]);
              $activeSheet->getCell('C' . (3 + $i))->setValue($rows[$i]["qty2"]);
              $activeSheet->getCell('D' . (3 + $i))->setValue($rows[$i]["qty3"]);
              $activeSheet->getCell('E' . (3 + $i))->setValue($rows[$i]["imp1"]);
              $activeSheet->getCell('F' . (3 + $i))->setValue($rows[$i]["imp2"]);
              $activeSheet->getCell('G' . (3 + $i))->setValue($rows[$i]["imp3"]);
              $activeSheet->getStyle('F' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
              $activeSheet->getStyle('G' . (3 + $i))->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
              $activeSheet->getStyle('F' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
              $activeSheet->getStyle('G' . (3 + $i))->applyFromArray($styleThinBlackBorderOutline);
            }
          }
          break;
        }
      }

      $objWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, 'Xlsx');
      $filename = 'stats_' . $agent->cdagen . '_' . date('Ymd') . '_' . date('His');
      $objWriter->save(str_replace('StatisticsController', $filename, str_replace('.php', '.xlsx', __FILE__)));
      chmod("../app/controllers/" . $filename . ".xlsx", 0777);
      if (!file_exists('../public/io/stats')) {
        mkdir('../public/io/stats', 0777, true);
      }
      rename("../app/controllers/" . $filename . ".xlsx", "../public/io/stats/" . $filename . ".xlsx");

      echo json_encode($filename . ".xlsx");
    }
  }

  public function getdashboardAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $auth   = $this->session->get('auth');

      $cdstag = isset($_POST['season']) ? $_POST['season'] : array();
      $dates  = isset($_POST['dates']) ? $_POST['dates'] : 'ALL';

      $date_max = date('Y-m-d');
      $date_min = date('Y-m-d');

      $where  = '';
      $params = array();
      if ($dates != 'ALL') {
        $dates_arr = explode(' - ', $dates);
        $items0 = explode('/', $dates_arr[0]);
        $items1 = explode('/', $dates_arr[1]);

        $minDate = $items0[2] . '-' . $items0[1] . '-' . $items0[0];
        $maxDate = $items1[2] . '-' . $items1[1] . '-' . $items1[0];

        $params = array('dtmin' => $minDate, 'dtmax' => $maxDate);
        $where  = 'AND t.datord >= :dtmin AND t.datord <= :dtmax';
      }

      // Overall analysis
      $totOrd = Svtest::getOrdersCount($cdstag, $auth['id'], $where, $params);
      $svcorp = Svcorp::getRowTotals($cdstag, $auth['id'], $where, $params);

      ini_set('max_execution_time', 300);

      // Top 10 quantity
      $svana1 = Svanag::getTop10QuantityCustomers($cdstag, $auth['id'], $where, $params);

      // Top 10 value
      $svana2 = Svanag::getTop10ValueCustomers($cdstag, $auth['id'], $where, $params);

      // Top 10 bestseller (quantity)
      $svart1 = Svtipo::getTop10QuantityBestellers($cdstag, $auth['id'], $where, $params);

      $svarti_ok_qty = [];
      foreach ($svart1 as $mod) {
        $mod_ok = $mod;
        if ($mod->flimag != "" && file_exists("../public/img/model/" . $mod->flimag)) {
          $mod_ok->flimag = "../img/model/" . $mod->flimag;
        } else {
          $mod_ok->flimag = "../assets/img/default_model.jpg";
        }
        $svarti_ok_qty[] = $mod_ok;
      }

      // Top 10 bestseller (value)
      $svart2 = Svtipo::getTop10ValueBestellers($cdstag, $auth['id'], $where, $params);

      $svarti_ok_val = [];
      foreach ($svart2 as $mod) {
        $mod_ok = $mod;
        if ($mod->flimag != "" && file_exists("../public/img/model/" . $mod->flimag)) {
          $mod_ok->flimag = "../img/model/" . $mod->flimag;
        } else {
          $mod_ok->flimag = "../assets/img/default_model.jpg";
        }
        $svarti_ok_val[] = $mod_ok;
      }

      // Trend
      $trend1 = Svtest::getQuantityTrend($cdstag, $auth['id'], $where, $params);
      $trend2 = Svtest::getValueTrend($cdstag, $auth['id'], $where, $params);

      $trend = array();
      if ($trend1 != false) {
        switch($type) {
        case "30dd":
          $date_min = date('Y-m-d', strtotime('-30 days'));
          break;
        case "15dd":
          $date_min = date('Y-m-d', strtotime('-15 days'));
          break;
        case "7dd":
          $date_min = date('Y-m-d', strtotime('-7 days'));
          break;
        case "all":
          $date_min = $trend1[0]->datord;
          $date_max = $trend1[count($trend1) - 1]->datord;
          break;
        }
      }

      $trend = $this->getTrendTemplate($date_min, $date_max);

      for ($i = 0; $i < count($trend1); $i++) {
        for ($j = 0; $j < count($trend); $j++) {
          if ($trend1[$i]->datord >= $trend[0]["date"] && $trend1[$i]->datord <= $trend[$j]["date"]) {
            $trend[$j]["qty"] += $trend1[$i]->tot_qty;
            break;
          }
        }
      }

      for ($i = 0; $i < count($trend2); $i++) {
        for ($j = 0; $j < count($trend); $j++) {
          if ($trend2[$i]->datord >= $trend[0]["date"] && $trend2[$i]->datord <= $trend[$j]["date"]) {
            $trend[$j]["val"] += $trend2[$i]->tot_val;
            break;
          }
        }
      }

      $response = array(
        'tot_ord'       => (int)$totOrd,
        'qty_tot'       => (int)$svcorp->tot_qty,
        'qty_avg_ord'   => $totOrd > 0 ? (int)$svcorp->tot_qty/$totOrd : "nd.",
        'val_tot'       => (int)$svcorp->tot_val,
        'val_avg_ord'   => $totOrd > 0 ? (int)$svcorp->tot_val/$totOrd : "nd.",
        'val_avg_prd'   => $svcorp->tot_qty > 0 ? (int)$svcorp->tot_val/$svcorp->tot_qty : "nd.",
        'top_10_qty'    => $svana1,
        'top_10_val'    => $svana2,
        'top_10_mod_qty'=> $svarti_ok_qty,
        'top_10_mod_val'=> $svarti_ok_val,
        'trend'         => $trend,
      );
      echo json_encode($response);
    }
  }
  //endregion

  //region Utility functions
  private function getAgentInfo($id_usr) {
    $agent = Anaage::getAgentFromUser($id_usr);
    return $agent != null ? $agent[0] : array("cdagen" => "", "dsagen" => "");
  }

  private function getStats() {
    $typeStats  = $this->session->get('typeStats');

    $catalogs   = $this->session->get('catalogs');
    $customers  = $this->session->get('customers');
    $countries  = $this->session->get('countries');
    $genres     = $this->session->get('genres');
    $lines      = $this->session->get('lines');
    $modeltypes = $this->session->get('modeltypes');
    $ordertypes = $this->session->get('ordertypes');
    $series     = $this->session->get('series');
    $zones      = $this->session->get('zones');

    $typeTime   = $this->session->get('typeTime');
    $time1      = $this->session->get('time1');
    $time2      = $this->session->get('time2');
    $time3      = $this->session->get('time3');

    $auth       = $this->session->get('auth');

    $selectOrder = "";
    $groupOrder = "";
    switch ($typeStats) {
    case "group_02":
			$select = "ti.tipmod AS tipmod, ti.titlin AS titlin, ti.lineam AS lineam";
      $groupOrder = "tipmod, titlin, lineam";
			$selectOuter = "r.tipmod AS mot, r.titlin AS brn, r.lineam AS lin";
			$groupOuter = "mot, brn, lin";
      break;
    case "group_03":
			$select = "ti.titlin AS titlin, ti.lineam AS lineam";
      $groupOrder = "titlin, lineam";
			$selectOuter = "r.titlin AS brn, r.lineam AS lin";
			$groupOuter = "brn, lin";
      break;
    case "group_04":
      $select = "ti.titlin AS titlin, ti.lineam AS lineam, ti.codneu AS codneu, ti.desneu AS desneu";
      $groupOrder = "titlin, lineam, codneu, desneu";
      $selectOuter = "r.titlin AS brn, r.lineam AS lin, CONCAT(r.codneu, ' ', r.desneu) AS 'mod'";
      $groupOuter = "brn, lin, r.codneu, r.desneu";
      break;
    case "group_05":
			$select = "ti.titlin AS titlin, ti,lineam AS lineam, ar.codart AS codart, ar.desart AS desart";
      $groupOrder = "titlin, lineam, codart, desart";
			$selectOuter = "r.titlin AS brn, r.lineam AS lin, CONCAT(r.codart, ' ', r.desart) AS art";
			$groupOuter = "brn, lin, r.codart, r.desart";
      break;
    case "group_06":
			$select = "ti.titlin AS titlin, ti.lineam AS lineam, ti.tipmod AS tipmod";
      $groupOrder = "titlin, lineam, tipmod";
			$selectOuter = "r.titlin AS brn, r.lineam AS lin, r.tipmod AS mot";
			$groupOuter = "brn, lin, mot";
      break;
    case "group_07":
			$select = "ti.titlin AS titlin, ti.lineam AS lineam, ti.seriem AS seriem";
      $groupOrder = "titlin, lineam, seriem";
			$selectOuter = "r.titlin AS brn, r.lineam AS lin, r.seriem AS ser";
			$groupOuter = "brn, lin, ser";
      break;
    case "group_08":
			$select = "an.ragsoc AS ragsoc, an.codana AS codana, an.nazion AS nazion";
      $groupOrder = "ragsoc, codana, nazion";
			$selectOuter = "CONCAT(r.ragsoc, ' (', r.codana, '), ', r.nazion) AS cus";
			$groupOuter = "r.codana";
      break;
    case "group_09":
			$select = "an.ragsoc AS ragsoc, an.codana AS codana, an.nazion AS nazion, ti.tipmod AS tipmod";
			$groupOrder = "ragsoc, codana, nazion, tipmod";
			$selectOuter = "CONCAT(r.ragsoc, ' (', r.codana, '), ', r.nazion) AS cus, r.tipmod AS mot";
			$groupOuter = "r.codana, mot";
      break;
    case "group_10":
			$select = "an.ragsoc AS ragsoc, an.codana AS codana, an.nazion AS nazion, ti.titlin AS titlin, ti.lineam AS lineam";
			$groupOrder = "ragsoc, codana, nazion, titlin, lineam";
			$selectOuter = "CONCAT(r.ragsoc, ' (', r.codana, '), ', r.nazion) AS cus, r.titlin AS brn, r.lineam AS lin";
			$groupOuter = "r.codana, brn, lin";
      break;
    case "group_11":
			$select = "an.ragsoc AS ragsoc, an.codana AS codana, an.nazion AS nazion, ti.titlin AS titlin, ti.lineam AS lineam, ti.codneu AS codneu, ti.desneu AS desneu";
			$groupOrder = "ragsoc, codana, nazion, titlin, lineam, codneu, desneu";
      $selectOuter = "CONCAT(r.ragsoc,  ' (', r.codana, '), ', r.nazion) AS cus, r.titlin AS brn, r.lineam AS lin, CONCAT(r.codneu, ' ', r.desneu) AS 'mod'";
			$groupOuter = "r.codana, brn, lin, r.codneu, r.desneu";
			break;
    case "group_12":
			$select = "an.ragsoc AS ragsoc, an.codana AS codana, an.nazion AS nazion, ti.titlin AS titlin, ti.lineam AS lineam, ar.codart AS codart, ar.desart AS desart";
			$groupOrder = "ragsoc, codana, nazion, titlin, lineam, codart, desart";
      $selectOuter = 'CONCAT(r.ragsoc, " (", r.codana, "), ", r.nazion) AS cus, r.titlin AS brn, r.lineam AS lin, CONCAT(r.codart, " ", r.desart) AS art';
			$groupOuter = "r.codana, brn, lin, r.codart, r.desart";
      break;
    case "group_13":
			$select = "te.agente AS agente, an.ragsoc AS ragsoc, an.codana AS codana, an.nazion AS nazion";
			$groupOrder = "agente, ragsoc, codana, nazion";
			$selectOuter = 'r.agente AS age, CONCAT(r.ragsoc, " (", r.codana, "), ", r.nazion) AS cus';
      $groupOuter = "age, r.codana";
      break;
    case "group_14":
			$select = "te.agente AS agente, an.ragsoc AS ragsoc, an.codana AS codana, an.nazion AS nazion, ti.tipmod AS tipmod";
			$groupOrder = "agente, ragsoc, codana, nazion, tipmod";
			$selectOuter = 'r.agente AS age, CONCAT(r.ragsoc, " (", r.codana, "), ", r.nazion) AS cus, r.tipmod AS mot';
			$groupOuter = "age, r.codana, mot";
      break;
    case "group_01":
    default:
      $select = "ti.tipmod AS tipmod";
      $groupOrder = "tipmod";
      $selectOuter = "r.tipmod AS mot";
      $groupOuter = "mot";
      break;
    }

    $fltCatalogs = "";
    $fltCountries = "";
    $fltCustomers = "";
    $fltGenres = "";
    $fltLines = "";
    $fltModelTypes = "";
    $fltOrderTypes = "";
    $fltSeries = "";
    $fltZones = "";
    if ($catalogs != "all") {
      $catJoin = "INNER JOIN ctarti ct ON ct.cdarti = co.codart ";
      for ($i = 0; $i < count($catalogs); $i++) {
        $fltCatalogs .= "ct.cdcata = '" . $catalogs[$i] . "' OR ";
      }
    } else {
      $catJoin = "";
    }
    if ($countries != "all") {
      for ($i = 0; $i < count($countries); $i++) {
        $fltCountries .= "an.nazion LIKE '" . $countries[$i] . "' OR ";
      }
    }
    if ($customers != "all") {
      for ($i = 0; $i < count($customers) ; $i++) {
        $fltCustomers .= "te.codana = '" . $customers[$i] . "' OR ";
      }
    }
    if ($genres != "all") {
      for ($i = 0; $i < count($genres); $i++) {
        $fltGenres .= "ti.genere = '" . $genres[$i] . "' OR ";
      }
    }
    if ($lines != "all") {
      for ($i = 0; $i < count($lines); $i++) {
        $fltLines .= "ti.lineam = '" . $lines[$i] . "' OR ";
      }
    }
    if ($modeltypes != "all") {
      for ($i = 0; $i < count($modeltypes); $i++) {
        $fltModelTypes .= "ti.tipmod = '" . $modeltypes[$i] . "' OR ";
      }
    }
    if ($ordertypes != "all") {
      for ($i = 0; $i < count($ordertypes); $i++) {
        $fltOrderTypes .= "te.tipord = '" . $ordertypes[$i] . "' OR ";
      }
    }
    if ($series != "all") {
      for ($i = 0; $i < count($series); $i++) {
        $fltSeries .= "ti.seriem = '" . $series[$i] . "' OR ";
      }
    }
    if ($zones != "all") {
      for ($i = 0; $i < count($zones); $i++) {
        $fltZones .= "an.zonage = '" . $zones[$i] . "' OR ";
      }
    }

    $phqlStart = "SELECT " . $select . ", ";
    $phqlSum1 = "SUM(co1.qtatot) AS qtatot1, SUM(co1.impnet) AS impnet1, 0 AS qtatot2, 0 AS impnet2, 0 AS qtatot3, 0 AS impnet3 ";
    $phqlSum2 = "0 AS qtatot1, 0 AS impnet1, SUM(co2.qtatot) AS qtatot2, SUM(co2.impnet) AS impnet2, 0 AS qtatot3, 0 AS impnet3 ";
    $phqlSum3 = "0 AS qtatot1, 0 AS impnet1, 0 AS qtatot2, 0 AS impnet2, SUM(co3.qtatot) AS qtatot3, SUM(co3.impnet) AS impnet3 ";

    $phqlBody = "
      FROM svcorp co
      INNER JOIN svtest te ON co.idtest = te.idtest
      INNER JOIN svanag an ON te.cdstag = an.cdstag AND te.tipana = an.tipana AND te.codana = an.codana
      INNER JOIN svarti ar ON te.cdstag = ar.cdstag AND co.codart = ar.codart
      INNER JOIN svtipo ti ON ar.cdstag = ti.cdstag AND ar.codneu = ti.codneu
      INNER JOIN b2b_usrage ua ON ua.cdagen = te.cdagen
      " .
      $catJoin .
      "WHERE ua.id_usr = " . $auth['id'] . " ";

    $arr_originals = array("an.",  "svanag an",  "ar.",  "svarti ar",  "co.",  "svcorp co",
                           "te.",  "svtest te",  "ti.",  "svtipo ti",  "ua.",  "b2b_usrage ua");
    $arr_replace1  = array("an1.", "svanag an1", "ar1.", "svarti ar1", "co1.", "svcorp co1",
                           "te1.", "svtest te1", "ti1.", "svtipo ti1", "ua1.", "b2b_usrage ua1");
    $arr_replace2  = array("an2.", "svanag an2", "ar2.", "svarti ar2", "co2.", "svcorp co2",
                           "te2.", "svtest te2", "ti2.", "svtipo ti2", "ua2.", "b2b_usrage ua2");
    $arr_replace3  = array("an3.", "svanag an3", "ar3.", "svarti ar3", "co3.", "svcorp co3",
                           "te3.", "svtest te3", "ti3.", "svtipo ti3", "ua3.", "b2b_usrage ua3");

    $phql1 = "";
    $phql2 = "";
    $phql3 = "";

    $phql1 = str_replace($arr_originals, $arr_replace1, $phqlStart) . $phqlSum1 . str_replace($arr_originals, $arr_replace1, $phqlBody);
    $phql2 = str_replace($arr_originals, $arr_replace2, $phqlStart) . $phqlSum2 . str_replace($arr_originals, $arr_replace2, $phqlBody);
    $phql3 = str_replace($arr_originals, $arr_replace3, $phqlStart) . $phqlSum3 . str_replace($arr_originals, $arr_replace3, $phqlBody);

    $multistats = false;
    if ($typeTime == 0) {
      $phql1 .= " AND ar1.cdstag = '" . $time1 . "' AND te1.cdstag = '" . $time1 . "' ";
      if ($time2 != "_none") {
        $multistats = true;
        $phql2 .= " AND ar2.cdstag = '" . $time2 . "' AND te2.cdstag = '" . $time2 . "' ";
      } else {
        $phql2 = '';
      }
      if ($time3 != "_none") {
        $multistats = true;
        $phql3 .= " AND ar3.cdstag = '" . $time3 . "' AND te3.cdstag = '" . $time3 . "' ";
      } else {
        $phql3 = '';
      }
    } else {
      $dates1 = explode(" - ", $time1);
      $items1_0 = explode("/", $dates1[0]);
      $items1_1 = explode("/", $dates1[1]);

      $phql1 .= "AND te1.datord >= '" . $items1_0[2] . "-" . $items1_0[1] . "-" . $items1_0[0] . "' ";
      $phql1 .= "AND te1.datord <= '" . $items1_1[2] . "-" . $items1_1[1] . "-" . $items1_1[0] . "' ";

      if ($time2 != '') {
        $multistats = true;
        $dates2 = explode(" - ", $time2);
        $items2_0 = explode("/", $dates2[0]);
        $items2_1 = explode("/", $dates2[1]);
        $phql2 .= "AND te2.datord >= '" . $items2_0[2] . "-" . $items2_0[1] . "-" . $items2_0[0] . "' ";
        $phql2 .= "AND te2.datord <= '" . $items2_1[2] . "-" . $items2_1[1] . "-" . $items2_1[0] . "' ";
      } else {
        $phql2 = '';
      }
      if ($time3 != '') {
        $multistats = true;
        $dates3 = explode(" - ", $time3);
        $items3_0 = explode("/", $dates3[0]);
        $items3_1 = explode("/", $dates3[1]);
        $phql3 .= "AND te3.datord >= '" . $items3_0[2] . "-" . $items3_0[1] . "-" . $items3_0[0] . "' ";
        $phql3 .= "AND te3.datord <= '" . $items3_1[2] . "-" . $items3_1[1] . "-" . $items3_1[0] . "' ";
      } else {
        $phql3 = '';
      }
    }

    if ($fltCatalogs != '') {
      $phql1 .= 'AND (' . str_replace($arr_originals, $arr_replace1, substr($fltCatalogs, 0, -4)) . ') ';
      if ($phql2 != '') {
        $phql2 .= 'AND (' . str_replace($arr_originals, $arr_replace2, substr($fltCatalogs, 0, -4)) . ') ';
      }
      if ($phql3 != '') {
        $phql3 .= 'AND (' . str_replace($arr_originals, $arr_replace3, substr($fltCatalogs, 0, -4)) . ') ';
      }
    }
    if ($fltCountries != '') {
      $phql1 .= 'AND (' . str_replace($arr_originals, $arr_replace1, substr($fltCountries, 0, -4)) . ') ';
      if ($phql2 != '') {
        $phql2 .= 'AND (' . str_replace($arr_originals, $arr_replace2, substr($fltCountries, 0, -4)) . ') ';
      }
      if ($phql3 != '') {
        $phql3 .= 'AND (' . str_replace($arr_originals, $arr_replace3, substr($fltCountries, 0, -4)) . ') ';
      }
    }
    if ($fltCustomers != '') {
      $phql1 .= 'AND (' . str_replace($arr_originals, $arr_replace1, substr($fltCustomers, 0, -4)) . ') ';
      if ($phql2 != '') {
        $phql2 .= 'AND (' . str_replace($arr_originals, $arr_replace2, substr($fltCustomers, 0, -4)) . ') ';
      }
      if ($phql3 != '') {
        $phql3 .= 'AND (' . str_replace($arr_originals, $arr_replace3, substr($fltCustomers, 0, -4)) . ') ';
      }
    }
    if ($fltGenres != '') {
      $phql1 .= 'AND (' . str_replace($arr_originals, $arr_replace1, substr($fltGenres, 0, -4)) . ') ';
      if ($phql2 != '') {
        $phql2 .= 'AND (' . str_replace($arr_originals, $arr_replace2, substr($fltGenres, 0, -4)) . ') ';
      }
      if ($phql3 != '') {
        $phql3 .= 'AND (' . str_replace($arr_originals, $arr_replace3, substr($fltGenres, 0, -4)) . ') ';
      }
    }
    if ($fltLines != '') {
      $phql1 .= 'AND (' . str_replace($arr_originals, $arr_replace1, substr($fltLines, 0, -4)) . ') ';
      if ($phql2 != '') {
        $phql2 .= 'AND (' . str_replace($arr_originals, $arr_replace2, substr($fltLines, 0, -4)) . ') ';
      }
      if ($phql3 != '') {
        $phql3 .= 'AND (' . str_replace($arr_originals, $arr_replace3, substr($fltLines, 0, -4)) . ') ';
      }
    }
    if ($fltModelTypes != '') {
      $phql1 .= 'AND (' . str_replace($arr_originals, $arr_replace1, substr($fltModelTypes, 0, -4)) . ') ';
      if ($phql2 != '') {
        $phql2 .= 'AND (' . str_replace($arr_originals, $arr_replace2, substr($fltModelTypes, 0, -4)) . ') ';
      }
      if ($phql3 != '') {
        $phql3 .= 'AND (' . str_replace($arr_originals, $arr_replace3, substr($fltModelTypes, 0, -4)) . ') ';
      }
    }
    if ($fltOrderTypes != '') {
      $phql1 .= 'AND ('. str_replace($arr_originals, $arr_replace1, substr($fltOrderTypes, 0, -4)) . ') ';
      if ($phql2 != '') {
        $phql2 .= 'AND (' . str_replace($arr_originals, $arr_replace2, substr($fltOrderTypes, 0, -4)) . ') ';
      }
      if ($phql3 != '') {
        $phql3 .= 'AND (' . str_replace($arr_originals, $arr_replace3, substr($fltOrderTypes, 0, -4)) . ') ';
      }
    }
    if ($fltSeries != '') {
      $phql1 .= 'AND (' . str_replace($arr_originals, $arr_replace1, substr($fltSeries, 0, -4)) . ') ';
      if ($phql2 != '') {
        $phql2 .= 'AND (' . str_replace($arr_originals, $arr_replace2, substr($fltSeries, 0, -4)) . ') ';
      }
      if ($phql3 != '') {
        $phql3 .= 'AND (' . str_replace($arr_originals, $arr_replace3, substr($fltSeries, 0, -4)) . ') ';
      }
    }
    if ($fltZones != '') {
      $phql1 .= 'AND (' . str_replace($arr_originals, $arr_replace1, substr($fltZones, 0, -4)) . ') ';
      if ($phql2 != '') {
        $phql2 .= 'AND (' . str_replace($arr_originals, $arr_replace2, substr($fltZones, 0, -4)) . ') ';
      }
      if ($phql3 != '') {
        $phql3 .= 'AND (' . str_replace($arr_originals, $arr_replace3, substr($fltZones, 0, -4)) . ') ';
      }
    }

    if ($multistats) {
      $phql = "SELECT  $selectOuter , SUM(r.qtatot1) AS qty1, SUM(r.impnet1) AS imp1";
      if ($phql2 != '') {
        $phql .= ', SUM(r.qtatot2) AS qty2, SUM(r.impnet2) AS imp2';
      }
      if ($phql3 != '') {
        $phql .= ', SUM(r.qtatot3) AS qty3, SUM(r.impnet3) AS imp3';
      }
      $phql .= ' FROM (';
      $phql .= " $phql1 GROUP BY $groupOrder ";
      if ($phql2 != '') {
        $phql .= " UNION $phql2 GROUP BY $groupOrder ";
      }
      if ($phql3 != '') {
        $phql .= " UNION $phql3 GROUP BY $groupOrder ";
      }
      $phql .=  " ORDER BY $groupOrder ";

      $phql .= ") AS r GROUP BY $groupOuter ";

      $sql = $this->db->prepare($phql);

      $sql->setFetchMode(\Phalcon\Db::FETCH_ASSOC);
      $sql->execute();
      $results = $sql->fetchAll();

      $full_stats = $results;
    } else {
      $sql = $this->db->prepare(" $phql1 GROUP BY $groupOrder ORDER BY $groupOrder ");

      $sql->setFetchMode(\Phalcon\Db::FETCH_ASSOC);
      $sql->execute();
      $results = $sql->fetchAll();

      $full_stats = $results;
    }

    if ($multistats) {
      $sql = $this->db->prepare($phql);
      $sql->setFetchMode(\Phalcon\Db::FETCH_ASSOC);
      $sql->execute();
      $results = $sql->fetchAll();

      $full_stats = $results;
    } else {
      $sql = $this->db->prepare(" $phql1 GROUP BY $groupOrder ORDER BY $groupOrder ");

      $sql->setFetchMode(\Phalcon\Db::FETCH_ASSOC);
      $sql->execute();
      $results = $sql->fetchAll();

      $full_stats = $results;
    }

    return $full_stats;
  }

  private function getTrendTemplate($date_min, $date_max) {
    $date_diff = date_diff(date_create($date_max), date_create($date_min))->days;

    $trend = array();
    if ($date_diff < 15) {
      for ($i = $date_diff; $i >= 0; $i--) {
        $trend[] = [ 'qty' => 0, 'val' => 0, 'date' => date('Y-m-d', strtotime('-' . $i . ' days', strtotime($date_max))) ];
      }
    } else {
      $days = $date_diff / 15;
      for ($i = 15; $i >= 0; $i--) {
        $trend[] = [ 'qty' => 0, 'val' => 0, 'date' => date('Y-m-d', strtotime('-' . (int)($i * $days) . ' days', strtotime($date_max))) ];
      }
    }

    return $trend;
  }
  //endregion
}
