<?php

namespace Go2B\Controllers;

use Go2B\Models\Anagra;
use Go2B\Models\Ananaz;
use Go2B\Models\Anaprov;
use Go2B\Models\B2bReqacc;
use Go2B\Models\B2bSysusr;
use Go2B\Models\B2bUsrage;
use Go2B\Models\B2bUsrana;
use Phalcon\Http\Request;

// Allows to authenticate users
class SessionController extends ControllerBase
{
    //region Initialize
    public function initialize()
    {
        $this->tag->setTitle('Login');
        parent::initialize();
    }
    //endregion

    //region Views functions
    public function loginAction()
    {
        $common = array();
        $common['isOrder'] = false;

        $this->utility->updateDatabase(); // check if database is already updated

        $this->view->common = $common;
        $this->view->useNewCustomerRef = $this->utility->getAppSettings('UseNewCustomerReferent');
        $this->view->logoimg = $this->utility->getAppUtils('logo_image');
        $this->view->login_bg = $this->utility->getAppUtils('login_bg');
        $this->view->reqaccess = $this->utility->getAppSettings('ParamNewRegistrationAvailable');
        $this->view->countries = Ananaz::find(array('order' => 'dsnazi'));
        $this->view->provinces = Anaprov::find(array('order' => 'dsprov'));
        $mandatoryFields = [];
        if (($fmvStr = $this->utility->getAppSettings('RegistrationMandatoryFields')) && !empty($fmvStr)) {
            $mandatoryFields = explode(',', $fmvStr);
            $mandatoryFields = array_map('trim', $mandatoryFields);
        }
        $this->view->mandatoryFields = $mandatoryFields;

        $this->view->lang = strtolower($this->utility->getLanguage());
    }

    public function registerAction()
    {
        $superadmin_available = B2bSysusr::findFirstByType(1) == null;
        $admin_available = B2bSysusr::findFirstByType(2) == null;
        $support_available = B2bSysusr::findFirstByType(6) == null;

        $this->view->superadmin_available = $superadmin_available;
        $this->view->admin_available = $admin_available;
        $this->view->support_available = $support_available;

        if ($this->request->isPost()) {
            $username = $this->request->getPost('username', 'alphanum');
            $password = $this->request->getPost('password');
            $repeatPassword = $this->request->getPost('repeatPassword');
            $type = $this->request->getPost('type');

            if ($password != $repeatPassword) {
                $this->view->username = $username;
                $this->view->type = $type;
                $this->view->error = 'password';
            } else {
                $user = new B2bSysusr();
                $user->username = $username;
                $user->password = sha1($password);
                $user->created_at = new \Phalcon\Db\RawValue('now()');
                $user->enabled = 1;
                $user->type = $type;
                $user->locale = 'it';

                if ($user->save() == false) {
                    $this->view->username = $username;
                    $this->view->type = $type;
                    $this->view->error = 'generic';
                } else {
                    return $this->forward('login');
                }
            }
        }
    }

    // This action authenticate and logs an user into the application
    public function startAction()
    {
        $this->view->disable();

        if ($this->request->isPost() && $this->request->hasPost('username') && $this->request->hasPost('password')) {
            $username = $this->request->getPost('username');
            $password = $this->request->getPost('password');
            $lang = $this->request->getPost('country');

            $this->clearCache();

            $user = B2bSysusr::findFirst(array(
                'username = :username: AND password = :password: AND enabled = 1',
                'bind' => array('username' => $username, 'password' => sha1($password)),
            ));

            if ($user instanceof B2bSysusr) {
                // Questo controllo lo abbiamo spento su richiesta di Matteo
//                if ($user->type == B2bSysusr::TYPE_CUSTOMER) {
//                    $activeCustomer = false;
//                    $userCustomer   = B2bUsrana::findFirstByIdUsr($user->id);
//                    if ($userCustomer && ($customer = Anagra::findCustomerByKey($userCustomer->tpanag, $userCustomer->cdanag))) {
//                        $activeCustomer = $customer->cdblco == 0;
//                    }
//
//                    if (!$activeCustomer) {
//                        $this->flashSession->error($this->translate('session.user.blocked'));
//                        $this->view->disable();
//
//                        $this->response->redirect('session/login')->send();
//                        exit();
//                    }
//                }

                $user->last_login = new \Phalcon\Db\RawValue('now()');
                $user->locale = $lang == 'gb' ? 'en' : $lang;
                $user->save();

                $this->_registerSession($user);
                $this->_redirectLoggedUser($user);
            } else {
                $this->flashSession->error($this->translate('session.user.incorrect'));
            }
        } else {
            $this->flashSession->error($this->translate('_common.form.emptydata'));
        }

        $this->response->redirect('session/login')->send();
        exit();
    }

    // Finishes the active session redirecting to the index
    public function endAction()
    {
        $this->session->destroy(true);
//        $this->flashSession->success('Goodbye!');
        $this->clearCache();
        $this->response->redirect('session/login')->send();
        exit();
    }

    public function switchAction()
    {
        try {
            $auth = $this->session->get('auth');
            if (empty($auth) || empty($auth['id'])) {
                throw new \Exception('User not logged yet');
            }

            if (!$this->request->isPost() || !$this->request->hasPost('id_user')) {
                throw new \Exception('Invalid account data');
            }

            $idUser = $this->request->getPost('id_user', 'int!');
            if (empty($idUser) || !($userToSwitch = B2bSysusr::findFirstById($idUser))) {
                throw new \Exception('User not found');
            }

            // Permessi
            if ($auth['role'] !== 'Admin') {
                throw new \Exception('Your role does not allow you to perform this action');
            }

            $this->_registerSession($userToSwitch);
            $this->_redirectLoggedUser($userToSwitch);
        } catch (\Exception $e) {
            $this->flashSession->error($e->getMessage());
            $this->response->redirect($this->request->getHTTPReferer())->send();
            exit();
        }
    }
    //endregion

    //region Ajax functions
    public function changelanguageAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $language = $_POST['language'] == 'gb' ? 'en' : $_POST['language'];
            if ($this->session->get('auth') != '') {
                B2bSysusr::updateLanguage($this->session->get('auth')['id'], $language);
            }
            $this->session->set('language', $language);
            echo json_encode('OK');
        }
    }

    public function saverequestAction()
    {
        $this->view->disable();
        $useNewCustomerRef = $this->utility->getAppSettings('UseNewCustomerReferent');
        $companyEmail = $this->view->companyemail = $this->utility->getAppUtils('email');
        //$companyEmail             = $this->utility->getAppUtils('email');
        // passo il parametro della mails
        $this->view->sendmailnewrequestaccess = $this->utility->getAppSettings('sendMailNewRequestAccess') == 1 ? true : false;
        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {

            $data = $_POST;
            B2bReqacc::createAccessRequest($data);

            if ($this->utility->getAppSettings('sendMailNewRequestAccess') == 1) {

                $emailBody = $this->translate('account.customer.signboard') . ": " . $data['descri'] . "<br />";
                $emailBody .= $this->translate('account.customer.vatcode') . ": " . $data['ivacfi'] . "<br />";
                $emailBody .= "Email: " . $companyEmail . "<br />";
                $emailBody .= $this->translate('account.customer.telephone') . ": " . $data['numtel'] . "<br />";
                $emailBody .= $this->translate('account.customer.address') . ": " . $data['indiri'] . "<br />";
                $emailBody .= $this->translate('account.customer.capzip') . ": " . $data['capind'] . "<br />";
                $emailBody .= $this->translate('account.customer.city') . ": " . $data['ccitta'] . "<br />";
                $emailBody .= $this->translate('account.customer.country') . ": " . $data['dsnazi'] . "<br />";
                $emailBody .= $this->translate('account.customer.province') . ": " . $data['provin'] . "<br />";
                $emailBody .= $this->translate('account.customer.sidcode') . ": " . $data['codsid'] . "<br />";
                $emailBody .= $this->translate('account.customer.emailpec') . ": " . $data['emapec'] . "<br />";
                $emailBody .= "***********************************************<br /><br />";
                $emailBody .= $this->translate('account.customer.businessname') . ": " . $data['desragsoc1'] . "<br />";
                $emailBody .= $this->translate('account.customer.address') . ": " . $data['desindi1'] . "<br />";
                $emailBody .= $this->translate('account.customer.capzip') . ": " . $data['descap1'] . "<br />";
                $emailBody .= $this->translate('account.customer.city') . ": " . $data['descitta1'] . "<br />";
                $emailBody .= $this->translate('account.customer.province') . ": " . $data['desprov1'] . "<br />";
                $emailBody .= $this->translate('account.customer.country') . ": " . $data['desdsnazi1'] . "<br />";
                if ($useNewCustomerRef) {
                    $emailBody .= $this->translate('account.customer.refname') . ": " . $data['refname'] . "<br />";
                    $emailBody .= $this->translate('account.customer.refnote') . ": " . $data['refnote'] . "<br />";
                    $emailBody .= $this->translate('account.customer.refemail') . ": " . $data['refemail'] . "<br />";
                    $emailBody .= $this->translate('account.customer.refntel') . ": " . $data['refntel'] . "<br />";
                }
                $emailBody .= "***********************************************<br /><br />";

                if (isset($data['desragsoc2'])) {
                    isset($data['desragsoc2']) ? $emailBody .= $this->translate('account.customer.businessname') . ": " . $data['desragsoc2'] . "<br />" : "";
                    isset($data['desindi2']) ? $emailBody .= $this->translate('account.customer.address') . ": " . $data['desindi2'] . "<br />" : "";
                    isset($data['descap2']) ? $emailBody .= $this->translate('account.customer.capzip') . ": " . $data['descap2'] . "<br />" : "";
                    isset($data['descitta2']) ? $emailBody .= $this->translate('account.customer.city') . ": " . $data['descitta2'] . "<br />" : "";
                    isset($data['desprov2']) ? $emailBody .= $this->translate('account.customer.province') . ": " . $data['desprov2'] . "<br />" : "";
                    isset($data['desdsnazi2']) ? $emailBody .= $this->translate('account.customer.country') . ": " . $data['desdsnazi2'] . "<br />" : "";
                    $emailBody .= "***********************************************<br /><br />";
                }

                if (isset($data['desragsoc3'])) {

                    isset($data['desragsoc3']) ? $emailBody .= $this->translate('account.customer.businessname') . ": " . $data['desragsoc3'] . "<br />" : "";
                    isset($data['desindi3']) ? $emailBody .= $this->translate('account.customer.address') . ": " . $data['desindi3'] . "<br />" : "";
                    isset($data['descap3']) ? $emailBody .= $this->translate('account.customer.capzip') . ": " . $data['descap3'] . "<br />" : "";
                    isset($data['descitta3']) ? $emailBody .= $this->translate('account.customer.city') . ": " . $data['descitta3'] . "<br />" : "";
                    isset($data['desprov3']) ? $emailBody .= $this->translate('account.customer.province') . ": " . $data['desprov3'] . "<br />" : "";
                    isset($data['desdsnazi3']) ? $emailBody .= $this->translate('account.customer.country') . ": " . $data['desdsnazi3'] . "<br />" : "";
                    $emailBody .= "***********************************************<br /><br />";
                }

                $emailBody .= $this->translate('account.customer.autogenerated');
                $subject = 'Request Access';
                $this->utility->sendEmail('Sinergiattiva B2B', $companyEmail, $subject, $emailBody, "", "");
            }
            // File csv
            $this->utility->accessRequestCreateCsv($data);
            echo json_encode('OK');
        }
    }

    public function emailrequestaccess()
    {
        // invio la mail tramite php
        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {

            $data = $_POST;
            $emailAdress = $this->getAppUtils('email');
            $subject = 'Request Access';
            /** DA TOGLIERE COMMENTO */
            //$this->sendEmail('Sinergiattiva B2B', $emailAdress, $subject, $data, "", "");
            $this->sendEmail('Sinergiattiva B2B', 'm.dilabio@synergical.it', $subject, $data, "", "");

            // Richiamo la funzione di invio email
            echo json_encode('OK');
        }
    }
    //endregion

    //region Aux functions
    private function clearCache()
    {
        // Delete cookies
//        $recentProducts = $this->cookies->get('recent-products');
//        $recentProducts->delete();
        $this->cookies->delete('recent-products');
    }

    // Register an authenticated user into session data
    private function _registerSession(B2bSysusr $user)
    {
        $code = null;
        switch ($user->type) {
            case 1:
            case 2:
                $role = 'Admin';
                break;
            case 6:
                $role = 'Support';
                break;
            default:
                $role = 'Users';
                if ($user->type == 3 && ($agent = B2bUsrage::findFirstByIdUsr($user->id)) && $agent instanceof B2bUsrage) {
                    $code = $agent->cdagen;
                } else if ($user->type == 4 && ($customer = B2bUsrana::findFirstByIdUsr($user->id)) && $customer instanceof B2bUsrana) {
                    $code = $customer->tpanag . '-' . $customer->cdanag;
                }
                break;
        }

        $this->session->set('auth', array(
            'id' => $user->id,
            'username' => $user->username,
            'role' => $role,
            'code' => $code,
            'type' => $user->type,
        ));
        $this->session->set('language', $user->locale == 'gb' ? 'en' : $user->locale);
    }

    private function _redirectLoggedUser($user)
    {
        $this->view->setMainView('index');
        switch ($user->type) {
            case 1:
            case 2:
                $this->response->redirect('admin/dashboard')->send();
                exit();
            case 6:
                $this->response->redirect('support/listAdmin')->send();
                exit();
            default:
                if ($this->utility->getAppSettings('StartingHomePage') == 0) {
                    $this->response->redirect('catalog/index')->send();
                } else {
                    $this->response->redirect('catalog/collection')->send();
                }
                exit();
        }
    }
    //endregion
}
