<?php

namespace Go2B\Controllers;

use Go2B\Library\DiskManager;
use Go2B\Models\Anaage;
use Go2B\Models\Anagra;
use Go2B\Models\Ascorp;
use Go2B\Models\Astest;
use Go2B\Models\B2bAddinf;
use Go2B\Models\B2bCusper;
use Go2B\Models\B2bOrdadd;
use Go2B\Models\B2bSysusr;
use Go2B\Models\Cttest;
use Go2B\Models\Desmer;
use Go2B\Models\Gopart;
use Go2B\Models\Lscorp;
use Go2B\Models\Ocasso;
use Go2B\Models\Occorp;
use Go2B\Models\Ocperc;
use Go2B\Models\Octagl;
use Go2B\Models\Octest;
use Go2B\Models\Smcorp;
use Go2B\Models\Scmcon;
use Go2B\Models\Sparti;
use Go2B\Models\Spmate;
use Go2B\Models\Tabvar;
use Phalcon\Http\Request;
use Phalcon\Di;
use Phalcon\Mvc\Model\Resultset\Simple as Resultset;

/**
 * @property-read DiskManager $diskManager
 * @property-read Phalcon\Mvc\View\SimpleView $pdfTemplate
 */
class PdfController extends ControllerBase
{
    //region Views functions
    public function ticklerAction()
    {
        $this->view->disable();

        $auth = $this->session->get('auth');
        $user = B2bSysusr::findFirstById($auth['id']);

        $idlang = $this->utility->getLanguage();

        if ($user->type == 3) {
            $tpanag = $this->dispatcher->getParam("tpanag");
            $cdanag = $this->dispatcher->getParam("cdanag");
        } else {
            $customers = $this->utility->getCustomersFromCustomerUserId($auth['id']);
            $tpanag = $customers[0]->tpanag;
            $cdanag = $customers[0]->cdanag;
        }

        $anagra = Anagra::getCustomerForPdf($tpanag, $cdanag, $idlang);

        $gopart = Gopart::getDeadlinesForCustomer($tpanag, $cdanag);

        $html = $this->view->getRender('pdf', 'ticklerpdf', ['anagra' => $anagra, 'gopart' => $gopart]);

        $pdf_name = "tickler-" . date("Ymd") . "-" . $anagra->tpanag . "-" . $anagra->cdanag . ".pdf";
        $html_name = "tickler-" . date("Ymd") . "-" . $anagra->tpanag . "-" . $anagra->cdanag . ".html";

        if (!$is_task) {
            $pdf_filename = './pdf/' . $pdf_name;
            $html_filename = './pdf/' . $html_name;
        } else {
            $pdf_filename = realpath('..') . '/public/pdf/' . $pdf_name;
            $html_filename = realpath('..') . '/public/pdf/' . $html_name;
        }

        $html = $this->view->getRender('pdf', $response['pdf'], $response['data']);

        $handle = fopen($html_filename, 'w+');
        fwrite($handle, $html);
        fclose($handle);

        if ($this->config->release->user != "root") {
            $this->diskManager->execLinuxShellCommandPdfGeneration($html_name, $pdf_name);
        } else {
            $this->diskManager->execWindowsShellCommandPdfGeneration($html_name, $pdf_name);
        }
    }

    public function orderAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $auth = $this->session->get('auth');
            $nuordc = $_POST['nuordc'];

            $pdf_name = $this->createOrderPdf($nuordc, $auth['id']);

            echo json_encode($pdf_name);
        }
    }

    public function orderFromAdminAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nuordc = $_POST['nuordc'];
            $id = Octest::findFirstByNuordc($nuordc)->id_usr;

            $pdf_name = $this->createOrderPdf($nuordc, $id);

            echo json_encode($pdf_name);
        }
    }
    //endregion

    //region Aux functions
    public function createOrderPdf($nuordc, $id_usr, $is_task = false)
    {
        // Order pdf
        /** @var Octest $order */
        $order = Octest::findFirstByNuordc($nuordc);

        list($anno, $mese, $giorno) = explode('-', $order->dtcrea);
        $pdf_name = 'order-' . $nuordc . '-' . $anno . $mese . $giorno . '.pdf';
//        $pdf_filename = ($is_task ? realpath('..') . '/public' : '.') . '/pdf/' . $pdf_name;
        $pdf_filename = APP_PATH . 'public/pdf/' . $pdf_name;

        $lang = $this->utility->getLanguage();
        $partialPdfList = $this->generatePartialsPdfOrder($order->nuordc, $id_usr, $lang);
        $this->diskManager->execShellCommandPdfsMerge($pdf_filename, $partialPdfList);

//        // Check for pdf conditions
//        $cdcata = $response['data']['octest']->cdcata;
//        $idlang = $response['data']['anagra']->idlang != ''
//            ? (in_array(strtoupper($response['data']['anagra']->idlang), array('IT', 'EN', 'ES', 'FR', 'DE'))
//                ? strtoupper($response['data']['anagra']->idlang)
//                : $this->customTranslationCodes('ZAN', strtoupper($response['data']['anagra']->idlang)))
//            : 'EN';
//        $conditionsPdfs = B2bAddinf::getPdfConditionsForCatalog($cdcata, $idlang);
//        if (count($conditionsPdfs) <= 0) {
//            $conditionsPdfs = B2bAddinf::getPdfConditionsForCatalog($cdcata, 'EN');
//        }
//
//        // Order pdf
//        $order_date = explode('/', $response['data']['octest']->dtcrea);
//        $pdf_name = 'order-' . $nuordc . '-' . $order_date[2] . $order_date[1] . $order_date[0] . (count($conditionsPdfs) > 0 ? '_temp' : '') . '.pdf';
//        $html_name = 'order-' . $nuordc . '-' . $order_date[2] . $order_date[1] . $order_date[0] . '.html';
//
//        if (!$is_task) {
//            $pdf_filename = './pdf/' . $pdf_name;
//            $html_filename = './pdf/' . $html_name;
//        } else {
//            $pdf_filename = realpath('..') . '/public/pdf/' . $pdf_name;
//            $html_filename = realpath('..') . '/public/pdf/' . $html_name;
//        }
//
//        $html = $this->view->getRender('pdf', $response['pdf'], $response['data']);
//
//        //if ($response['pdf'] != 'pdf_100' && $response['pdf'] != 'pdf_101') {
//        $handle = fopen($html_filename, 'w+');
//        fwrite($handle, $html);
//        fclose($handle);
//
//        //if ($this->config->release->user != "root") {
//        if (PHP_OS == 'WINNT') {
//            $this->diskManager->execWindowsShellCommandPdfGeneration($html_filename, $pdf_filename, $response['data']['orientation'] == 0);
//        } else {
//            $this->diskManager->execLinuxShellCommandPdfGeneration($html_filename, $pdf_filename, $response['data']['orientation'] == 0);
//        }
//
//        if (count($conditionsPdfs) > 0 && !$response['data']['specialBehaviour']) {
//            $pdf_conditions_filename = './upload/pdf/' . $conditionsPdfs[0]->valore;
//            if (PHP_OS == 'WINNT') {
//                $this->diskManager->execWindowsShellCommandPdfConditionsMerge(str_replace('_temp', '', $pdf_filename), $pdf_filename, $pdf_conditions_filename);
//            } else {
//                $this->diskManager->execLinuxShellCommandPdfConditionsMerge(str_replace('_temp', '', $pdf_filename), $pdf_filename, $pdf_conditions_filename);
//            }
//        }
//
//        $this->logger->info(print_r($pdf_filename, true));
//
//        /*} else {
//          $tokens = explode('__HTML_RENDERER_DIVIDER__', $html);
//
//          $handle = fopen($html_filename,'w+');
//          fwrite($handle, $tokens[0] . $tokens[1] . $tokens[3]);
//          fclose($handle);
//
//          if ($this->config->database->username != "root") {
//            shell_exec("wkhtmltopdf -O landscape $html_filename $pdf_filename");
//          } else {
//            shell_exec("c:\wkhtmltopdf\bin\wkhtmltopdf -O landscape $html_filename $pdf_filename");
//          }
//
//          // Description pdf
//          $pdf_name  = "order-" . $nuordc .  "-" . $order_date[2] . $order_date[1] . $order_date[0] . "-dsc.pdf";
//          $html_name = "order-" . $nuordc .  "-" . $order_date[2] . $order_date[1] . $order_date[0] . "-dsc.html";
//
//          if (!$is_task) {
//            $pdf_filename   = './pdf/' . $pdf_name;
//            $html_filename  = './pdf/' . $html_name;
//          } else {
//            $pdf_filename   = realpath('..') . '/public/pdf/' . $pdf_name;
//            $html_filename  = realpath('..') . '/public/pdf/' . $html_name;
//          }
//
//          $handle = fopen($html_filename,'w+');
//          fwrite($handle, $tokens[0] . $tokens[2] . $tokens[3]);
//          fclose($handle);
//
//          if ($this->config->database->username != "root") {
//            shell_exec("wkhtmltopdf $html_filename $pdf_filename");
//          } else {
//            shell_exec("c:\wkhtmltopdf\bin\wkhtmltopdf $html_filename $pdf_filename");
//          }
//        }*/

        return $pdf_name;
    }

    // Get assortment and its quantity for given assortment
    private function getPdfAssortment($cdartn, $cdtagl, $cdasso)
    {
        $assmod = Astest::getAssortmentQuantityForModel($cdartn, $cdtagl, $cdasso);

        $full_assmod = array();
        for ($i = 0; $i < count($assmod); $i++) {
            $curr_assmod = $assmod[$i];
            $curr_assmod->ascorp = $this->getAssortmentQty($cdtagl, $cdasso);
            $full_assmod[] = $curr_assmod;
        }

        return $full_assmod;
    }

    // Get all quantities/sizes for given assortment
    private function getAssortmentQty($cdtagl, $cdasso)
    {
        $ascorp = Ascorp::getAssortmentDetail($cdasso, $cdtagl);

        $ascorp_norm = array();
        for ($i = 0; $i < count($ascorp); $i++) {
            $ascorp_norm[$ascorp[$i]->taglia] = $ascorp[$i]->qtatgl;
        }

        return $ascorp_norm;
    }

    private function getPdfArticles($order, $style, $idlang)
    {
        $ordering = $this->utility->getAppSettings('ParamTypeOrdering');
        $hasConfigurator = $this->utility->getAppSettings('ModelDetailStyle') == 5;

        if ($hasConfigurator) {
            $articles = Occorp::getConfiguratorPdfOrderRows($order->nuordc, $ordering, $idlang);
        } else {
            $articles = Occorp::getPdfOrderRows($order->nuordc, $ordering, $style, $idlang);
        }

        $fullArticles = array();
        for ($i = 0; $i < count($articles); $i++) {
            $currArticle = (object)$articles[$i];
            $currArticle->octagl = '';
            $currArticle->totals = '';

            // Get prices
            $currArticle->prices = Lscorp::getArticlePrices($currArticle->cdarti, $order->nulist);

            // Get retail price
            $currArticle->retailPrice = '';
            if ($currArticle->prezzo_r > 0 && $currArticle->cdvalu_r != '') {
                $currArticle->retailPrice = $this->utility->getFormattedPriceWithCdvalu($currArticle->cdvalu_r, $currArticle->prezzo_r)['value'];
            }

            // Get size quantity
            $octagl = !$hasConfigurator || $currArticle->cdcolo != 'CUSTOM'
                ? Octagl::getSizeQuantityForPdf($currArticle->nurorc)
                : Octagl::getSizeQuantityForConfiguratorPdf($currArticle->nurorc);
            $currArticle->octagl = $octagl;

            // Get assortments
            $ocasso = Ocasso::getAssortmentQuantity($currArticle->nurorc);
            if (count($ocasso) > 0) {
                $full_ocasso = array();
                for ($j = 0; $j < count($ocasso); $j++) {
                    $curr_ocasso = $ocasso[$j];
                    $curr_ocasso->defini = '';

                    $defini = $this->getPdfAssortment($currArticle->cdartn, $currArticle->cdtagl, $curr_ocasso->cdasso);

                    if (count($defini) > 0) {
                        $curr_ocasso->defini = $defini;
                    }

                    $full_ocasso[] = $curr_ocasso;
                }

                $currArticle->ocasso = $full_ocasso;
            }

            // Get info for pdf_100, pdf_101
            if ($style == '100' || $style == '101') {
                if ($currArticle->cdvari != '') {
                    $variants = str_split($currArticle->cdvari);
                    $dsvari = '';
                    foreach ($variants as $cdvari) {
                        $tabvar = Tabvar::getCustomFromCdvariAndCdcata($cdvari, $order->cdcata);
                        $dsvari .= $cdvari . ' - ' . $tabvar->dsvari . '; ';
                    }
                    $currArticle->dsvari = substr($dsvari, 0, -2);
                }

                // Add shipping if needed
                $currArticle->shipping = $this->utility->getAppSettings('ShippingsOnOrderRows') == 1 && $currArticle->cddesm != ''
                    ? Desmer::getShippingForPdf($order->tpanag, $order->cdanag, $order->cddesm)
                    : null;

                if (!empty($currArticle->cdpers) && ($addvar = B2bCusper::findFirstByCdpers($currArticle->cdpers))) {
                    $currArticle->addvar = $addvar->additional_code;
                }
            }

            // Get features for pdf_200
            if ($style == '200') {
                $currArticle->features = Sparti::getAllFeatures($currArticle->cdarti);
            }

            // Resize images, but pdf_100, pdf_101
            if ($style != '100' && $style != '101') {
                // Create temporary folder for resized images
                $this->utility->checkOrCreateResizeFolder();

                // Copy image to temporary folder
                $imgurl = "img/model/" . $currArticle->flimag_n;
                $resize = "img/temp/resize/model/" . $currArticle->flimag_n;
                if ($currArticle->flimag_n != '' && file_exists($imgurl) && !file_exists($resize)) {
                    $this->utility->resizeImageForExcel($imgurl, $resize);
                }
                $imgurl = "img/model/" . $currArticle->flimag_i;
                $resize = "img/temp/resize/model/" . $currArticle->flimag_i;
                if ($currArticle->flimag_i != '' && file_exists($imgurl) && !file_exists($resize)) {
                    $this->utility->resizeImageForExcel($imgurl, $resize);
                }
                $imgurl = "img/model/" . $currArticle->flimag_c;
                $resize = "img/temp/resize/model/" . $currArticle->flimag_c;
                if ($currArticle->flimag_c != '' && file_exists($imgurl) && !file_exists($resize)) {
                    $this->utility->resizeImageForExcel($imgurl, $resize);
                }
            }

            // Add components (Rossetti)
            if ($hasConfigurator) {
                if ($currArticle->cdcolo == 'CUSTOM') {
                    $currArticle->components = Ocperc::getAllComponents($currArticle->cdarti);
                } else {
                    $currArticle->components = $currArticle->cdarti == $currArticle->cdartn
                        ? Spmate::getDefaultMaterialTypes($currArticle->cdarti)
                        : Smcorp::getAllComponents($currArticle->cdarti);
                }
            }

            // Calculate totals
            $totals = array();
            for ($j = 0; $j < count($currArticle->octagl); $j++) {
                $totals[$currArticle->octagl[$j]->taglia] = $currArticle->octagl[$j]->quanti;

                if (isset($currArticle->ocasso)) {
                    for ($k = 0; $k < count($currArticle->ocasso); $k++) {
                        if (array_key_exists($currArticle->octagl[$j]->taglia, $currArticle->ocasso[$k]->defini[0]->ascorp)) {
                            $totals[$currArticle->octagl[$j]->taglia] +=
                                ($currArticle->ocasso[$k]->quanti *
                                    $currArticle->ocasso[$k]->defini[0]->ascorp[$currArticle->octagl[$j]->taglia]);
                        }
                    }
                }
            }
            if (count($totals) > 0) {
                $currArticle->totals = $totals;
            }

            $fullArticles[] = $currArticle;
        }

        return $fullArticles;
    }

    private function getHtmlPdfOrder($nuordc, $id_usr)
    {
        $utility = new Utility();
        $style = $utility->getAppSettings('ParamTypePdfCompleteOrder');
        $descr = $utility->getAppSettings('ParamTypeDescrSummary');
        $label = $utility->getAppSettings('ParamLabel');
        $variant = $utility->getAppSettings('ParamVariation');
        $note = $utility->getAppSettings('AdditionalNotePdf');
        $showRP = $utility->getAppSettings('ParamPriceSellPublicVisible') == 1;
        $idlang = $utility->getLanguage();
        $orientation = $utility->getAppSettings('ParamPrintVertical');
        $pdf_footer_row_1 = $utility->getAppSettings('PdfFooterRow1');
        $pdf_footer_row_2 = $utility->getAppSettings('PdfFooterRow2');
        $pdf_footer_row_3 = $utility->getAppSettings('PdfFooterRow3');
        $details = array();
        $summary = array();
        $specialBehaviourAgent = false;
        $language = 'it';

        // Get order
        $octest = Octest::getOrderForPdf($nuordc, $idlang);

        // Get articles
        $articles = $this->getPdfArticles($octest, $style, $idlang);

        // Get customer
        $anagra = Anagra::getCustomerForPdf($octest->tpanag, $octest->cdanag, $idlang);

        // Get shipping
        $desmer = Desmer::getShippingForPdf($octest->tpanag, $octest->cdanag, $octest->cddesm);

        switch ($style) {
            case 1: // app param = 1
                $pdf = 'pdf_1';
                break;
            case 2: // app param = 2
                $pdf = 'pdf_2';
                break;
            case 3: // app param = 3
                $pdf = 'pdf_3';
                break;
            case 4: // app param = 5
                $pdf = 'pdf_4';
                break;
            case 5: // app param = 6
                $pdf = 'pdf_5';
                break;
            case 6: // app param = 7
                $pdf = 'pdf_6';
                break;
            case 7: // app param = 10
                $pdf = 'pdf_7';
                break;
            case 100:
                $pdf = 'pdf_100';
                $orientation = false;
                $details = Occorp::getPdfOrderRowsInfo($nuordc, $this->utility->getAppSettings('ParamTypeOrdering'), $idlang);
                break;
            case 101:
                $pdf = 'pdf_101';
                $orientation = false;
                $details = Occorp::getPdfOrderRowsInfo($nuordc, $this->utility->getAppSettings('ParamTypeOrdering'), $idlang);
                break;
            case 200:
                $pdf = 'pdf_200';
                $summary = $this->utility->getLinesSummary($articles, $octest);
                $specialBehaviourAgent = B2bAddinf::isSpecialAgent($octest->id_usr);
                $language = $this->session->get('language');
                break;
            case 300: // Dolly Noire
                $pdf = 'pdf_300';
                break;
            case 400: // Kocca
                $pdf = 'pdf_400';
                $orientation = false;
                break;
            case 999: // Joor
                $pdf = 'pdf_999';
                break;
            case 0: // app param = 0 - default
            default:
                $pdf = 'pdf_0';
                break;
        }

        // Get price list and currency
        $currency = $utility->getCurrencySymbol($octest->cdvalu);

        // Get agent
        if (B2bSysusr::findFirstById($id_usr)->type == 3) {
            $anaage = Anaage::getAgentFromUser($id_usr);
        } else {
            $anaage = null;
        }

        $data = array(
            'orientation' => $orientation,
            'label' => $label,
            'variant' => $variant,
            'showRP' => $showRP,
            'note' => $note,
            'currency' => $currency,
            'descr' => $descr,
            'ftr_row_1' => $pdf_footer_row_1,
            'ftr_row_2' => $pdf_footer_row_2,
            'ftr_row_3' => $pdf_footer_row_3,
            'anagra' => $anagra,
            'desmer' => $desmer,
            'anaage' => $anaage != null ? $anaage : -1,
            'octest' => $octest,
            'articles' => $articles,
            'details' => $details,
            'summary' => $summary,
            'language' => $language,
            'logo' => $utility->getAppUtils('logo_pdf'),
            'specialBehaviour' => $specialBehaviourAgent,
        );

        return array('pdf' => $pdf, 'data' => $data);
    }

    private function generatePartialsPdfOrder($nuordc, $id_usr, $lang = 'EN')
    {
        $ordineFinalePdf = ['_main', '_additional', '_conditions'];
        $additionalSections = [];
        $fileList = [];
        $baseFilename = '/tmp/pdf-order-' . $nuordc . '-' . time();

        try {
            $utility = new Utility();
            $sectionsOrderParam = $utility->getAppSettings('ParamPdfSectionsOrder');
            if (!empty($sectionsOrderParam)) {
                $ordineFinalePdf = explode(',', $sectionsOrderParam);
            }
            $style = $utility->getAppSettings('ParamTypePdfCompleteOrder');
            $descr = $utility->getAppSettings('ParamTypeDescrSummary');
            $label = $utility->getAppSettings('ParamLabel');
            $variant = $utility->getAppSettings('ParamVariation');
            $note = $utility->getAppSettings('AdditionalNotePdf');
            $showRP = $utility->getAppSettings('ParamPriceSellPublicVisible') == 1;
            $orientation = $utility->getAppSettings('ParamPrintVertical');
            $pdf_footer_row_1 = $utility->getAppSettings('PdfFooterRow1');
            $pdf_footer_row_2 = $utility->getAppSettings('PdfFooterRow2');
            $pdf_footer_row_3 = $utility->getAppSettings('PdfFooterRow3');
            $details = array();
            $summary = array();
            $specialBehaviourAgent = false;
            $language = 'it';

            // Get order
            $octest = Octest::getOrderForPdf($nuordc, $lang);

            // Get articles
            $articles = $this->getPdfArticles($octest, $style, $lang);

            // Get customer
            $anagra = Anagra::getCustomerForPdf($octest->tpanag, $octest->cdanag, $lang);

            // Get shipping
            $desmer = Desmer::getShippingForPdf($octest->tpanag, $octest->cdanag, $octest->cddesm);

            $cttest = Cttest::findFirstByCdcata($octest->cdcata);

            $additionalCosts = array_column(B2bOrdadd::find([
                'addval IS NOT NULL AND addval != \'\' AND nuordc = :nuordc:',
                'bind' => ['nuordc' => $nuordc]
            ])->toArray(), 'addval', 'addfld');

            switch ($style) {
                case 1: // app param = 1
                    $pdf = 'pdf_1';
                    break;
                case 2: // app param = 2
                    $pdf = 'pdf_2';
                    break;
                case 3: // app param = 3
                    $pdf = 'pdf_3';
                    break;
                case 4: // app param = 5
                    $pdf = 'pdf_4';
                    break;
                case 5: // app param = 6
                    $pdf = 'pdf_5';
                    break;
                case 6: // app param = 7
                    $pdf = 'pdf_6';
                    break;
                case 7: // app param = 10
                    $pdf = 'pdf_7';
                    break;
                case 100:
                    $pdf = 'pdf_100';
                    $orientation = false;
                    $details = Occorp::getPdfOrderRowsInfo($nuordc, $this->utility->getAppSettings('ParamTypeOrdering'), $lang);
                    $additionalSections[] = 'details';
                    break;
                case 101:
                    $pdf = 'pdf_101';
                    $orientation = false;
                    $details = Occorp::getPdfOrderRowsInfo($nuordc, $this->utility->getAppSettings('ParamTypeOrdering'), $lang);
                    $additionalSections[] = 'details';
                    break;
                case 200:
                    $pdf = 'pdf_200';
                    $summary = $this->utility->getLinesSummary($articles, $octest);
                    $specialBehaviourAgent = B2bAddinf::isSpecialAgent($octest->id_usr);
                    $language = $this->session->get('language');
                    break;
                case 300: // Dolly Noire
                    $pdf = 'pdf_300';
                    break;
                case 999: // Joor
                    $pdf = 'pdf_999';
                    break;
                case 400: // Kocca
                    $pdf = 'pdf_400';
                    $orientation = false;
                    break;
                case 0: // app param = 0 - default
                default:
                    $pdf = 'pdf_0';
                    break;
            }

            // Get price list and currency
            $currency = $utility->getCurrencySymbol($octest->cdvalu);

            // Get agent
            if (B2bSysusr::findFirstById($id_usr)->type == 3) {
                $anaage = Anaage::getAgentFromUser($id_usr);
            } else {
                $anaage = null;
            }

            $logo = $utility->getAppUtils('logo_pdf');
            $imgurl = '';
            if (!empty($logo)) {
                $imgurl = 'img/' . $logo;
            }
            $viewData = [
                'config' => $this->config,
                'orientation' => $orientation,
                'label' => $label,
                'variant' => $variant,
                'showRP' => $showRP,
                'note' => $note,
                'currency' => $currency,
                'descr' => $descr,
                'ftr_row_1' => $pdf_footer_row_1,
                'ftr_row_2' => $pdf_footer_row_2,
                'ftr_row_3' => $pdf_footer_row_3,
                'anagra' => $anagra,
                'desmer' => $desmer,
                'anaage' => $anaage != null ? $anaage : -1,
                'octest' => $octest,
                'cttest' => $cttest,
                'articles' => $articles,
                'details' => $details,
                'summary' => $summary,
                'language' => $language,
                'logo' => $logo,
                'imgurl' => $imgurl,
                'exist_logo' => $imgurl != '' && $this->diskManager->fileExistsInPublic($imgurl),
                'specialBehaviour' => $specialBehaviourAgent,
                'additionalCosts' => $additionalCosts,
            ];

            if ($pdf == "pdf_400") { // Kocca
                $taglie = $this->db->query(
                    "SELECT cdtagl, taglia, postgl
      FROM postgl WHERE postgl.cdtagl IN (SELECT DISTINCT tipolo.cdtagl
                        FROM occorp
                                 INNER JOIN octest ON occorp.nuordc = octest.nuordc
                                 INNER JOIN anaart ON anaart.cdarti = occorp.cdarti
                                 INNER JOIN tipolo ON anaart.cdartn = tipolo.cdartn
                        WHERE occorp.nuordc = :nuordc)
ORDER BY postgl.cdtagl, postgl.postgl ASC ", array("nuordc" => $octest->nuordc))->fetchAll();
                $scala_taglie = [];
                foreach ($taglie as $taglia ){
                    $scala_taglie[$taglia['cdtagl']][] = $taglia['taglia'];
                }
                $maxDimension = 0;
                $indexCdTagl = [];
                $start = 0;
                foreach ($scala_taglie as $key => $values) {
                    $indexCdTagl[$key] = (++$start);
                    $viewData['scala_taglie'][$key] = $values;
                    $maxDimension = max($maxDimension, count($values));
                }
                $viewData['scala_taglie'] = array_values($viewData['scala_taglie']);

                $groupItem = array();
                foreach ($articles as $article) {
                    if (!in_array($article->dsserm, $groupItem)) {
                        $groupItem[] = $article->dsserm;
                    }
                }

                $viewData['maxDimension'] = $maxDimension;
                $viewData['groupItem'] = $groupItem;
                $viewData['indexCdTagl'] = $indexCdTagl;
            }

            $fileList['_main'] = $baseFilename . '-main.pdf';
            $html = $this->pdfTemplate->render($pdf, $viewData);
            $handle = fopen($baseFilename . '-main.html', 'w+');
            fwrite($handle, $html);
            fclose($handle);

            $this->diskManager->execShellCommandPdfGeneration($baseFilename . '-main.html', $fileList['_main'], $orientation == 0);

            foreach ($additionalSections as $additionalSection) {
                $fileList[$additionalSection] = $baseFilename . '-' . $additionalSection . '.pdf';
                $html = $this->pdfTemplate->render($pdf . '_' . $additionalSection, $viewData);
                $handle = fopen($baseFilename . '-' . $additionalSection . '.html', 'w+');
                fwrite($handle, $html);
                fclose($handle);
                $this->diskManager->execShellCommandPdfGeneration($baseFilename . '-' . $additionalSection . '.html', $fileList[$additionalSection], $orientation == 0);
            }

            $conditionsPdfs = B2bAddinf::getPdfConditionsForCatalog($octest->cdcata, $lang);
            if (count($conditionsPdfs) <= 0) {
                $conditionsPdfs = B2bAddinf::getPdfConditionsForCatalog($octest->cdcata, 'EN');
            }
            if (count($conditionsPdfs) > 0) {
                $fileList['_conditions'] = APP_PATH . 'public/upload/pdf/' . $conditionsPdfs[0]->valore;
            } else {
                // Proviamo a generare un pdf con le condizioni generali di vendita (in html) inserite nei parametri
                $templateConditions = 'pdf_x_conditions';
                if ($this->diskManager->fileExists(APP_PATH . $this->config->application->viewsDir . 'pdf/'. $pdf . '_conditions.volt', DiskManager::FILE_TEST_MODE_READ)) {
                    $templateConditions = $pdf . '_conditions';
                }

                $viewData['conditionsHtml'] = $utility->getAppUtils('descr_'. strtolower($lang));
                if (empty($viewData['conditionsHtml'])) {
                    $viewData['conditionsHtml'] = $utility->getAppUtils('descr_en');
                }
                if (empty($viewData['conditionsHtml'])) {
                    $viewData['conditionsHtml'] = $utility->getAppUtils('descr_it');
                }

                if (!empty($viewData['conditionsHtml'])) {
                    $fileList['_conditions'] = $baseFilename . '-conditions.pdf';
                    $html = $this->pdfTemplate->render($templateConditions, $viewData);
                    $handle = fopen($baseFilename . '-conditions.html', 'w+');
                    fwrite($handle, $html);
                    fclose($handle);
                    $this->diskManager->execShellCommandPdfGeneration($baseFilename . '-conditions.html', $fileList['_conditions'], $templateConditions != 'pdf_x_conditions' && $orientation == 0);
                }
            }
        } catch (\Exception $exception) {
            $this->logger->error('Errore durante la creazione del PDF => ' . $exception->getMessage());
        }

        $finalList = [];
        foreach ($ordineFinalePdf as $item) {
            if ($item == '_additional') {
                foreach ($additionalSections as $additionalSection) {
                    if (!empty($fileList[$additionalSection])) {
                        $finalList[] = $fileList[$additionalSection];
                    }
                }
            } else if (!empty($fileList[$item])) {
                $finalList[] = $fileList[$item];
            }
        }

        return $finalList;
    }

    // Translates custom 'anagra->idlang' values to ISO standards
    private function customTranslationCodes($company, $cust_lang)
    {
        $it = 'IT';
        $en = 'EN';
        $es = 'ES';
        $fr = 'FR';
        $de = 'DE';
        $iso_lang = '';

        switch ($company) {
            case 'ZAN': // Zanotti
                switch ($cust_lang) {
                    case '1':
                        $iso_lang = $it;
                        break;
                    case '2':
                        $iso_lang = $en;
                        break;
                    case '4':
                        $iso_lang = $en;
                        break;
                    case '25':
                        $iso_lang = $en;
                        break;
                    case '32':
                        $iso_lang = $en;
                        break;
                    case '33':
                        $iso_lang = $en;
                        break;
                    case 'I':
                        $iso_lang = $en;
                        break;
                    default:
                        $iso_lang = $en;
                }
                break;
            default:
                $iso_lang = $en;
        }

        return $iso_lang;
    }
    //endregion
}
