<?php

namespace Go2B\Controllers;

class InfoController extends ControllerBase
{
  //region Initialize
  public function initialize() {
    parent::initialize();
    $this->tag->setTitle('Info');
  }
  //endregion

  //region Views functions
  public function salesconditionsAction() {
    $auth     = $this->session->get('auth');
    $common   = $this->utility->getCommonData('catalog', $auth['id']);

    $this->view->common     = $common;
      $lang = strtolower($this->utility->getLanguage());
      if(!in_array($lang, ['it', 'en', 'de', 'fr', 'es'])) {
          $lang =  'it';
      }
      $this->view->idlang     = strtoupper($lang);
      $this->view->conditions      = $this->utility->getAppUtils('descr_' . $lang);
  }

  public function shipmentconditionsAction() {
    $auth = $this->session->get('auth');
    $this->view->common = $this->utility->getCommonData('catalog', $auth['id']);
    $lang = strtolower($this->utility->getLanguage());
    $this->view->idlang = strtoupper($lang);
    $this->view->conditions = $this->getShipmentConditions($lang);
  }

  public function contactsAction() {
    $auth     = $this->session->get('auth');
    $common   = $this->utility->getCommonData('catalog', $auth['id']);

    $this->view->common     = $common;
    $this->view->business   = $this->utility->getAppUtils('business_name');
    $this->view->address    = $this->utility->getAppUtils('address');
    $this->view->city       = $this->utility->getAppUtils('city');
    $this->view->cap        = $this->utility->getAppUtils('cap');
    $this->view->province   = $this->utility->getAppUtils('province');
    $this->view->country    = $this->utility->getAppUtils('country');
    $this->view->tel        = $this->utility->getAppUtils('tel');
    $this->view->email      = $this->utility->getAppUtils('email');
    $this->view->fb_link    = $this->utility->getAppUtils('fb_link');
    $this->view->ig_link    = $this->utility->getAppUtils('ig_link');
    $this->view->tw_link    = $this->utility->getAppUtils('tw_link');
  }
  //endregion
}
