<?php

namespace Go2B\Controllers;

use Phalcon\Cli\Console as ConsoleApp;
use Phalcon\Di\FactoryDefault\Cli as CliDI;
use Phalcon\Http\Request;
use Phalcon\Mvc\Model\Resultset\Simple as Resultset;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Go2B\Forms\CatalogForm;
use Go2B\Models\Abagen;
use Go2B\Models\Anaage;
use Go2B\Models\Anaart;
use Go2B\Models\Anaper;
use Go2B\Models\Anatgl;
use Go2B\Models\Artcol;
use Go2B\Models\Astest;
use Go2B\Models\B2bAddinf;
use Go2B\Models\B2bCtllog;
use Go2B\Models\B2bSysusr;
use Go2B\Models\B2bUsrage;
use Go2B\Models\B2bUsrcpn;
use Go2B\Models\B2bUsrctl;
use Go2B\Models\Ctanag;
use Go2B\Models\Ctarti;
use Go2B\Models\Ctetic;
use Go2B\Models\Cttest;
use Go2B\Models\Desart;
use Go2B\Models\Dscorp;
use Go2B\Models\Imgart;
use Go2B\Models\Linmod;
use Go2B\Models\Lkarti;
use Go2B\Models\Lkcorp;
use Go2B\Models\Lkimag;
use Go2B\Models\Lkmode;
use Go2B\Models\Lktest;
use Go2B\Models\Lstest;
use Go2B\Models\Occorp;
use Go2B\Models\Octest;
use Go2B\Models\Pagcon;
use Go2B\Models\Postgl;
use Go2B\Models\Psagen;
use Go2B\Models\Pvcorp;
use Go2B\Models\Pvgrup;
use Go2B\Models\Pvtest;
use Go2B\Models\Regvar;
use Go2B\Models\Scacon;
use Go2B\Models\Scmcon;
use Go2B\Models\Sermod;
use Go2B\Models\Tabstg;
use Go2B\Models\Tipolo;
use Go2B\Models\Titlin;
use Go2B\Models\Tpcond;
use Go2B\Models\Tpmode;
use Go2B\Models\Tpocon;
use Go2B\Models\Tppaga;
use Go2B\Models\Tpport;

class GomanagementController extends AdminBase {
  //region Views functions
  public function agentsListAction() {
    $this->view->agents = Anaage::find();
    $this->view->lstest = Lstest::find();
    $this->view->setVars($this->getCommonVars());
  }

  public function availabilityAction() {
    $this->view->catalogs = Cttest::find();
    $this->view->setVars($this->getCommonVars());
  }

  public function brandsAction() {
    $this->view->brands = Titlin::find();
    $this->view->setVars($this->getCommonVars());
  }

  public function catalogDetailAction() {
    $cdcata = urldecode($this->dispatcher->getParam('cdcata'));

    //$articles = Ctarti::getCatalogDetail($cdcata);
    //$this->view->mainTableHtml  = $this->getCatalogArticlesTableHtml($articles, $cdcata);

    //$models = Ctarti::getCatalogDetailModels($cdcata);
    //$this->view->mainTableHtml = $this->getCatalogModelsTableHtml($models, $cdcata);
    $categories = Ctarti::getCatalogDetailCategories($cdcata);
    $this->view->mainTableHtml = $this->getCatalogCategoriesTableHtml($categories, $cdcata);
    $this->view->enableSorting = $this->utility->getAppSettings('EnableCatalogSorting') > 0;
    $this->view->syncImageType = $this->utility->getAppSettings('SyncImageType');

    $this->view->seasons = Tabstg::find();
    $this->view->catalog = Cttest::findFirstByCdcata($cdcata);
    $this->view->setVars($this->getCommonVars());

    $this->view->familyGroups  = $this->view->enableCustomFamily ? Regvar::find() : null;
  }

  public function catalogManagerAction() {
    $this->view->catalogs = Cttest::getAllCatalogs();
    $this->view->setVars($this->getCommonVars());
  }

  public function catalogSortingAction() {
    $cdcata = urldecode($this->dispatcher->getParam('cdcata'));

    $this->view->categories   = Ctarti::getCategoriesRows($cdcata);
    $this->view->sortingType  = $this->utility->getAppSettings('EnableCatalogSorting');
    $this->view->models   = Ctarti::getCatalogDetailModels($cdcata);
    $this->view->catalog  = Cttest::getSortingCatalog($cdcata);
    $this->view->setVars($this->getCommonVars());
  }

  public function conditionsAction() {
    $type = $this->dispatcher->getParam('type');

    if ($type == 'payment') {
      $this->view->items = Tppaga::getAllPayments();
    } else if ($type == 'shipping') {
      $this->view->items = Tpport::getAllShippings();
    }

    $this->view->type       = $type;
    $this->view->seasons    = Tabstg::getAllSeasons(true);
    $this->view->conditions = Tpcond::find();
    $this->view->setVars($this->getCommonVars());
  }

  public function createCatalogAction() {
    $this->view->form     = new CatalogForm(null, null);
    $this->view->articles = Anaart::getAllArticlesFromCatalog();
    $this->view->models   = Tipolo::getAllModelsFromCatalog();
    $this->view->lines    = Linmod::getAllLinesFromCatalog();
    $this->view->seasons  = Tabstg::find();
    $this->view->setVars($this->getCommonVars());
  }

  public function devicesAction() {
    $this->view->devices = Psagen::getAllDevices();
    $this->view->setVars($this->getCommonVars());
  }

  public function downloadImageXlsTemplateAction() {
    $this->view->cdcata = $_POST['cdcata'];
    $this->view->setVars($this->getCommonVars());
  }

  public function downloadSortingCatalogXlsAction() {
    $this->view->cdcata = $_POST['cdcata'];
    $this->view->models = $_POST['models'];
    $this->view->setVars($this->getCommonVars());
  }

  public function editDeviceAction() {
    $cdagen = $this->dispatcher->getParam('cdagen');

    if (!empty($cdagen)) {
      $this->view->abagen = Abagen::findFirstByCdagen($cdagen);
      $this->view->anaage = Anaage::findFirstByCdagen($cdagen);
      $this->view->psagen = Psagen::findByCdagen($cdagen);
    } else {
      $this->view->agents = Anaage::find();
    }

    $this->view->cdagen     = $cdagen;
    $this->view->conditions = Tpcond::find();
    $this->view->setVars($this->getCommonVars());
  }

  public function editLookbookAction() {
    $cdlkbk = $this->dispatcher->getParam('cdlkbk');
    $lkcorp = Lkcorp::getMinimalLooksFromLookbook($cdlkbk);

    $looks  = array();

    $lookType = $this->utility->getAppSettings('LookbookItemType');
    foreach ($lkcorp as $look) {
      $lkimag = Lkimag::getImagesForLook($cdlkbk, $look->cdlook);

      $images = array();
      // Check upload folder
      if (!file_exists('./upload/CONVERT')) {
        mkdir('./upload/CONVERT', 0777, true);
      }

      foreach ($lkimag as $image) {
        $size = getimagesize('./upload/' . $image->filimg);
        $image->size = $size;
        array_push($images, $image);
      }

      $look->lkimag = $images;

      switch ($lookType) {
        case 0:
          $look->items = Lkmode::getMinimalModelsForLook($cdlkbk, $look->cdlook);
          break;
        case 1:
          $look->items = Lkarti::getMinimalArticlesForLook($cdlkbk, $look->cdlook);
          break;
        case 2:
          $look->items = Lkarti::getMinimalLardiniArticlesForLook($cdlkbk, $look->cdlook);
          break;
      }

      array_push($looks, $look);
    }

    $this->view->looksHtml  = $this->getLooksHtml($looks, $lookType);
    $this->view->lookbook   = Lktest::getLookbook($cdlkbk);
    $this->view->lookType   = $lookType;
    $this->view->setVars($this->getCommonVars());
  }

  public function editPromoAction() {
    $cdprom = $this->dispatcher->getParam("cdprom");

    if (!empty($cdprom)) {
      $promo  = Pvtest::getPromo($cdprom);
      $rows   = Pvcorp::getAllPromoDetailsForPromo($cdprom);
      $groups = Pvgrup::getPromoGroups($cdprom);
    } else {
      $promo  = null;
      $rows   = null;
      $groups = null;
    }

    $this->view->brands     = Titlin::getAllBrandsForPromo($cdprom);
    $this->view->lines      = Linmod::getAllLinesForPromo($cdprom);
    $this->view->series     = Sermod::getAllSeriesForPromo($cdprom);
    $this->view->modelTypes = Tpmode::getAllModelTypesForPromo($cdprom);
    $this->view->models     = Tipolo::getAllModelsForPromo($cdprom);
    $this->view->articles   = Anaart::getAllArticlesForPromo($cdprom);

    $this->view->cdprom = $cdprom;
    $this->view->promo  = $promo;
    $this->view->rows   = $rows;
    $this->view->groups = $groups;
    $this->view->setVars($this->getCommonVars());
  }

  public function expirationsAction() {
    $this->view->catalogs   = Cttest::find();
    $this->view->conditions = Tpcond::find();
    $this->view->lines      = Linmod::find();
    $this->view->series     = Sermod::getAllSeries(true);
    $this->view->models     = Tipolo::find();
    $this->view->articles   = Anaart::getAllArticles();

    $this->view->mode   = urldecode($this->dispatcher->getParam('mode'));
    $this->view->sel_cd = urldecode($this->dispatcher->getParam('cdstag'));
    $this->view->sel_tp = urldecode($this->dispatcher->getParam('tpcond'));
    $this->view->setVars($this->getCommonVars());
  }

  public function linesAction() {
    $this->view->lines = Linmod::find();
    $this->view->brands = Titlin::getAllBrands();
    $this->view->setVars($this->getCommonVars());
  }

  public function lookbookManagerAction() {
    $this->view->catalogs   = Cttest::find();
    $this->view->lookbooks  = Lktest::getAllLookbooks($this->utility->getAppSettings('LookbookItemType'));
    $this->view->setVars($this->getCommonVars());
  }

  public function promoAction() {
    $this->view->promos = Pvtest::getAllPromos();
    $this->view->setVars($this->getCommonVars());
  }

  public function seasonsAction() {
    $this->view->seasons = Tabstg::find();
    $this->view->setVars($this->getCommonVars());
  }

  public function seriesAction() {
    $this->view->series = Sermod::find();
    $this->view->lines  = Linmod::getAllLines();
    $this->view->setVars($this->getCommonVars());
  }

  public function sizesAction() {
    $scales = Anatgl::getAllScales();
    $max_pos = 0;
    $sizes = [];

    $fullScales = array();
    foreach ($scales as $scale) {
      $currScale = $scale;
      $rawSizes = Postgl::getAllSizes($scale['cdtagl']);
      $sizes = array();
      foreach ($rawSizes as $size) {
        $sizes[$size['postgl']] = $size;
        $max_pos = $size['postgl'] > $max_pos ? $size['postgl'] : $max_pos;
      }
      $currScale['sizes'] = $sizes;
      //$sizes[$scale->cdtagl] = $row;
      $fullScales[] = $currScale;
    }

    $this->view->scales = $fullScales;
    //$this->view->sizes = $sizes;
    $this->view->numsizes = $max_pos;
    $this->view->setVars($this->getCommonVars());
  }
  //endregion

  //region Ajax functions: Agents list
  public function insertAgentAction() {
    $this->view->disable();
    $request = new Request();

    if ($request->isPost() && $request->isAjax()) {
      $cdagen = $this->request->getPost("cdagen");
      if (Anaage::findFirstByCdagen($cdagen)) {
        echo json_encode($this->translate('_common.alreadypresent'));
        return;
      }

      $anaage = new Anaage();
      $anaage->cdagen = $cdagen;
      $anaage->dsagen = $this->request->getPost("dsagen");
      $anaage->seqrap = $this->request->getPost("seqrap");
      $anaage->fltota = $this->request->getPost("fltota");
      $anaage->nulist = $this->request->getPost("nulist");

      $anaage->save();
      echo json_encode('OK');
    }
  }

  public function updateAgentAction() {
    $this->view->disable();
    $request = new Request();

    if ($request->isPost() && $request->isAjax()) {
      $anaage = Anaage::findFirstByCdagen($request->getPost('cdagen'));
      $anaage->dsagen = $request->getPost('dsagen');
      $anaage->seqrap = $request->getPost('seqrap');
      $anaage->fltota = $request->getPost('fltota');
      $anaage->nulist = $request->getPost('nulist');

      $anaage->save();

      echo json_encode('OK');
    }
  }

  public function deleteAgentAction() {
    $this->view->disable();
    $request = new Request();

    if ($request->isPost() && $request->isAjax()) {
      $cdagen = $request->getPost('cdagen');
      Anaage::findFirstByCdagen($cdagen)->delete();
      B2bAddinf::deleteAgentEmail($cdagen);
      $user = B2bUsrage::findFirstByCdagen($cdagen);

      if ($user) {
        $id_usr = $user->id_usr;
        B2bSysusr::deleteUser($id_usr);
        B2bUsrage::deleteUser($id_usr);
        B2bUsrcpn::deleteAllRecordsForIdUsr($id_usr);
        B2bUsrctl::deleteAllCatalogsForUser($id_usr);
      }

      echo json_encode('OK');
    }
  }
  //endregion

  //region Ajax functions: Brand manager
  public function insertBrandAction() {
    $this->view->disable();
    $request = new Request();

    if ($request->isPost() && $request->isAjax()) {
      $cdtitl = $this->request->getPost("cdtitl");
      if (Titlin::findFirstByCdtitl($cdtitl)) {
        echo json_encode($this->translate('_common.alreadypresent'));
        return;
      }

      $titlin = new Titlin();
      $titlin->cdtitl = $cdtitl;
      $titlin->dstitl = $this->request->getPost("dstitl");
      $titlin->seqrap = $this->request->getPost("seqrap");
      $titlin->flimag = "";

      $titlin->save();
      echo json_encode('OK');
    }
  }

  public function updateBrandAction() {
    $this->view->disable();
    $request = new Request();

    if ($request->isPost() && $request->isAjax()) {
      $titlin = Titlin::findFirstByCdtitl($request->getPost('cdtitl'));
      $titlin->dstitl = $request->getPost('dstitl');
      $titlin->seqrap = $request->getPost('seqrap');
      $titlin->save();
      echo json_encode('OK');
    }
  }

  public function deleteBrandAction() {
    $this->view->disable();
    $request = new Request();

    if ($request->isPost() && $request->isAjax()) {
      $cdtitl = $request->getPost('cdtitl');

      if (count(Linmod::findByCdtitl($cdtitl)) > 0) {
        echo json_encode($this->translate('admin.brands.error'));
        return;
      }

      Titlin::findFirstByCdtitl($cdtitl)->delete();
      echo json_encode('OK');
    }
  }
  //endregion

  //region Ajax functions: Line manager
  public function insertLineAction() {
    $this->view->disable();
    $request = new Request();

    if ($request->isPost() && $request->isAjax()) {
      $cdlinm = $this->request->getPost("cdlinm");
      if (Linmod::findFirstByCdlinm($cdlinm)) {
        echo json_encode($this->translate('_common.alreadypresent'));
        return;
      }

      $linmod = new Linmod();
      $linmod->cdlinm = $cdlinm;
      $linmod->dslinm = $this->request->getPost("dslinm");
      $linmod->cdtitl = $this->request->getPost("cdtitl");
      $linmod->seqrap = $this->request->getPost("seqrap");

      $linmod->save();
      echo json_encode('OK');
    }
  }

  public function updateLineAction() {
    $this->view->disable();
    $request = new Request();

    if ($request->isPost() && $request->isAjax()) {
      $cdlinm = $request->getPost('cdlinm');
      $dslinm = $request->getPost('dslinm');
      $cdtitl = $request->getPost('cdtitl');
      $seqrap = $request->getPost('seqrap');

      $linmod = Linmod::findFirstByCdlinm($cdlinm);
      $linmod->dslinm = $dslinm;
      $linmod->seqrap = $seqrap;
      $linmod->cdtitl = $cdtitl;
      $linmod->save();

      echo json_encode('OK');
    }
  }

  public function deleteLineAction() {
    $this->view->disable();
    $request = new Request();

    if ($request->isPost() && $request->isAjax()) {
      $cdlinm = $request->getPost('cdlinm');

      if (count(Sermod::findByCdlinm($cdlinm)) > 0) {
        echo json_encode($this->translate('admin.lines.error'));
        return;
      }

      Linmod::findFirstByCdlinm($cdlinm)->delete();
      echo json_encode('OK');
    }
  }
  //endregion

  //region Ajax functions: Season manager
  public function insertSeasonAction() {
    $this->view->disable();
    $request = new Request();

    if ($request->isPost() && $request->isAjax()) {
      $cdstag = $this->request->getPost("cdstag");
      if (Tabstg::findFirstByCdstag($cdstag)) {
        echo json_encode($this->translate('_common.alreadypresent'));
        return;
      }

      $tabstg = new Tabstg();
      $tabstg->cdstag = $cdstag;
      $tabstg->dsstag = $this->request->getPost("dsstag");
      $tabstg->collez = $this->request->getPost("collez");

      $tabstg->save();
      echo json_encode('OK');
    }
  }

  public function updateSeasonAction() {
    $this->view->disable();
    $request = new Request();

    if ($request->isPost() && $request->isAjax()) {
      $tabstg = Tabstg::findFirstByCdstag($request->getPost('cdstag'));
      $tabstg->dsstag = $request->getPost('dsstag');
      $tabstg->collez = $request->getPost('collez');
      $tabstg->save();
      echo json_encode('OK');
    }
  }

  public function deleteSeasonAction() {
    $this->view->disable();
    $request = new Request();

    if ($request->isPost() && $request->isAjax()) {
      $cdstag = $request->getPost('cdstag');

      if (
        count(Octest::findByCdstag($cdstag)) > 0 ||
        count(Tipolo::findByCdstag($cdstag)) > 0 ||
        count(Cttest::findByCdstag($cdstag)) > 0
      ) {
        echo json_encode($this->translate('admin.seasons.error'));
        return;
      }

      Tabstg::findFirstByCdstag($cdstag)->delete();
      echo json_encode('OK');
    }
  }
  //endregion

  //region Ajax functions: Series manager
  public function insertSeriesAction() {
    $this->view->disable();
    $request = new Request();

    if ($request->isPost() && $request->isAjax()) {
      $cdserm = $this->request->getPost("cdserm");
      $cdlinm = $this->request->getPost("cdlinm");
      if (Sermod::findFirst(array(
        'cdserm = ?0 AND cdlinm = ?1',
        'bind' => array($cdserm, $cdlinm)
      ))) {
        echo json_encode($this->translate('_common.alreadypresent'));
        return;
      }

      $sermod = new Sermod();
      $sermod->cdserm = $cdserm;
      $sermod->cdlinm = $cdlinm;
      $sermod->dsserm = $this->request->getPost("dsserm");
      $sermod->seqrap = $this->request->getPost("seqrap");

      $sermod->save();
      echo json_encode('OK');
    }
  }

  public function updateSeriesAction() {
    $this->view->disable();
    $request = new Request();

    if ($request->isPost() && $request->isAjax()) {
      $cdserm = $request->getPost('cdserm');
      $dsserm = $request->getPost('dsserm');
      $cdlinm = $request->getPost('cdlinm');
      $seqrap = $request->getPost('seqrap');

      $sermod = Sermod::findFirst(array(
        'cdserm = ?0 AND cdlinm = ?1',
        'bind' => array($cdserm, $cdlinm)
      ));

      $sermod->dsserm = $dsserm;
      $sermod->seqrap = $seqrap;
      $sermod->save();

      echo json_encode('OK');
    }
  }

  public function deleteSeriesAction() {
    $this->view->disable();
    $request = new Request();

    if ($request->isPost() && $request->isAjax()) {
      $cdserm = $request->getPost('cdserm');
      $cdlinm = $request->getPost('cdlinm');

      if (count(Tipolo::find(array(
        'cdserm = ?0 AND cdlinm = ?1',
        'bind' => array($cdserm, $cdlinm)
      ))) > 0) {
        echo json_encode($this->translate('admin.series.error'));
        return;
      }

      Sermod::findFirst(array(
        'cdserm = ?0 AND cdlinm = ?1',
        'bind' => array($cdserm, $cdlinm)
      ))->delete();

      echo json_encode('OK');
    }
  }
  //endregion

  //region Ajax functions: Scale manager
  public function insertScaleAction() {
    $this->view->disable();
    $request = new Request();

    if ($request->isPost() && $request->isAjax()) {
      $cdtagl = $this->request->getPost("cdtagl");

      if (Anatgl::findFirstByCdtagl($cdtagl)) {
        echo json_encode($this->translate('_common.alreadypresent'));
        return;
      }

      $anatgl = new Anatgl();
      $anatgl->cdtagl = $cdtagl;
      $anatgl->dstagl = $this->request->getPost("dstagl");
      $anatgl->save();

      $positions = json_decode($this->request->getPost("positions"));
      $sizes = json_decode($this->request->getPost("sizes"));

      foreach ($positions as $key => $value) {
        $postgl = new Postgl();
        $postgl->cdtagl = $cdtagl;
        $postgl->postgl = $value;
        $postgl->taglia = $sizes[$key];
        $postgl->save();
      }
      echo json_encode('OK');
    }
  }

  public function updateScaleAction() {
    $this->view->disable();
    $request = new Request();

    if ($request->isPost() && $request->isAjax()) {
      $cdtagl = $request->getPost('cdtagl');
      $dstagl = $request->getPost('dstagl');
      $pos = json_decode($this->request->getPost("positions"));
      $siz = json_decode($this->request->getPost("sizes"));

      $anatgl = Anatgl::findFirstByCdtagl($cdtagl);
      $anatgl->dstagl = $dstagl;
      $anatgl->save();

      $sizes = Postgl::findByCdtagl($cdtagl);
      $msg = "OK";
      $i = 0;

      foreach ($sizes as $size) {
        if ($i == count($pos)) {
          if (count(Occorp::getNumOrdersFromSize($cdtagl, $size->taglia)) == 0) {
            // se non ci sono ordini cancello la taglia
            $size->delete();
          } else {
            $msg = $this->translate('admin.scale.error.size');
          }
          continue;
        }
        $s_val = $siz[$i];
        $p_val = $pos[$i++];

        if ($size->postgl != $p_val || $size->taglia != $s_val) {
          if ($size->postgl != $p_val) {
            $postgl = Postgl::findFirst(array(
              'cdtagl = ?0 AND postgl = ?1',
              'bind' => array($cdtagl, $p_val)
            ));

            if ($postgl) {
              // posizione ripetuta
              $msg = $this->translate('admin.scale.error.pos');
              continue;
            }
          }
          Postgl::updateSize($cdtagl, $size->postgl, $p_val, $size->taglia, $s_val);
        }
      }

      while ($i != count($pos)) {
        // taglie da inserire
        $postgl = new Postgl();
        $postgl->cdtagl = $cdtagl;
        $postgl->postgl = $pos[$i];
        $postgl->taglia = $siz[$i++];
        $postgl->save();
      }

      echo json_encode($msg);
    }
  }

  public function deleteScaleAction() {
    $this->view->disable();
    $request = new Request();

    if ($request->isPost() && $request->isAjax()) {
      $cdtagl = $request->getPost('cdtagl');
      if (count(Tipolo::findByCdtagl($cdtagl)) > 0) {
        echo json_encode($this->translate('admin.scale.error'));
        return;
      }

      $sizes = Postgl::findByCdtagl($cdtagl);
      foreach ($sizes as $size) {
        if (count(Occorp::getNumOrdersFromSize($cdtagl, $size->taglia)) == 1) {
          echo json_encode($this->translate('admin.scale.error.size'));
          return;
        }
      }

      Anatgl::findFirstByCdtagl($cdtagl)->delete();
      foreach ($sizes as $size) {
        $size->delete();
      }

      echo json_encode('OK');
    }
  }
  //endregion

  //region Ajax functions: Catalog manager
  public function deleteCatalogsAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $catalogs = $request->getPost('catalogs');

      $auth = $this->session->get('auth');
      foreach ($catalogs as $cdcata) {
        Ctanag::findByCdcata($cdcata)->delete();
        B2bCtllog::insertLogOperationForDeleteCatalog($cdcata, 1, $auth['username'], $auth['id']);
        Ctarti::findByCdcata($cdcata)->delete();
        Ctetic::findByCdcata($cdcata)->delete();
        Cttest::findByCdcata($cdcata)->delete();
      }
      // check if mysql's command "OPTIMIZE TABLE" is available

      echo json_encode('OK');
    }
  }

  public function checkCatalogCodeAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $cdcata   = $request->getPost("cdcata");
      $results  = Cttest::findByCdcata($cdcata);
      echo json_encode(count($results) > 0 ? 'OK' : 'NO');
    }
  }

  public function insertCatalogAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $cdcata  = $request->getPost('cdcata');
      $cdstag  = isset($_POST['cdstag']) ? $_POST['cdstag'] : '';
      $dscata  = $request->getPost('dscata');
      $seqrap  = $request->getPost('seqrap');
      $dates   = $request->getPost('dates');

      $arr_dates  = explode(" - ", $dates);
      $arr_dtiniz = explode("/", $arr_dates[0]);
      $arr_dtfine = explode("/", $arr_dates[1]);

      $dtiniz = $arr_dtiniz[2] . "-" . $arr_dtiniz[1] . "-" . $arr_dtiniz[0];
      $dtfine = $arr_dtfine[2] . "-" . $arr_dtfine[1] . "-" . $arr_dtfine[0];

      Cttest::saveNewCatalog($cdcata, $dscata, $seqrap, $dtiniz, $dtfine, $cdstag);

      echo json_encode('OK');
    }
  }

  public function deleteFromCatalogAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $mode   = $request->getPost('mode');
      $codice = $request->getPost('codice');
      $cdcata = $request->getPost('cdcata');

      $auth = $this->session->get('auth');
      switch ($mode) {
        case 'titl':
          B2bCtllog::insertLogOperationForBrand($codice, $cdcata, 1, 'DELETE', $auth['username'], $auth['id']);
          Ctarti::deleteAllArticlesForCatalogAndBrand($cdcata, $codice);
          break;
        case 'linm':
          B2bCtllog::insertLogOperationForLine($codice, $cdcata, 1, 'DELETE', $auth['username'], $auth['id']);
          Ctarti::deleteAllArticlesForCatalogAndLine($cdcata, $codice);
          break;
        case 'serm':
          B2bCtllog::insertLogOperationForSeries($request->getPost('codic2'), $codice, $cdcata, 1, 'DELETE', $auth['username'], $auth['id']);
          Ctarti::deleteAllArticlesForCatalogAndSeries($cdcata, $request->getPost('codic2'), $codice);
          break;
        case 'artn':
          B2bCtllog::insertLogOperationForModel($codice, $cdcata, 1, 'DELETE', $auth['username'], $auth['id']);
          Ctarti::deleteAllArticlesForCatalogAndModel($cdcata, $codice);
          break;
        case 'arti':
          B2bCtllog::insertLogOperation($cdarti, $cdcata, 1, 'DELETE', $auth['username'], $auth['id']);
          Ctarti::deleteArticleFromCatalog($cdcata, $cdarti);
          break;
      }

      // check if mysql's command "OPTIMIZE TABLE" is available

      echo json_encode('OK');
    }
  }

  public function getAllImagesAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $mode   = $request->getPost("mode");
      $codice = $request->getPost("codice");

      switch ($mode) {
        case 'titl':
          $titlin = Titlin::findFirstByCdtitl($codice);
          $filimg = $titlin->flimag;
          break;
        case 'linm':
          $linmod = Linmod::findFirstByCdlinm($codice);
          $filimg = $linmod->flimag;
          break;
        case 'serm':
          $codic2 = $request->getPost("codic2");
          $sermod = Sermod::findFirst(array("cdlinm = :codic2: AND cdserm = :codice:", "bind" => array('codice' => $codice, 'codic2' => $codic2)));
          $filimg = $sermod->flimag;
          break;
      }

      $images = $this->getAllUploadImages(true, 'brand');

      $html = '';
      if (count($images) > 0) {
        for ($i = 0; $i < count($images); $i++) {
          if ($i % 12 == 0)
            $html .= "<div class='row'>";

          $html .= "<div class='col-md-1 img-selector ";
          if ($images[$i]['file'] == $filimg) {
            $html .= "img-selected";
          }
          $html .= "' title='" . $images[$i]['file'] . "'>";
          $html .= "<img src='../../" . $images[$i]['path'] . $images[$i]['file'] . "' alt='" . $images[$i]['file'] . "'/>";
          $html .= "<div>" . $images[$i]['file'] . "</div>";
          $html .= "</div>";

          if ($i % 12 == 11 || $i == count($images) - 1)
            $html .= "</div>";
        }
      }

      echo json_encode($html);
    }
  }

  public function editArticleAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $cdarti = $request->getPost('cdarti');
      $anaart = Anaart::getMinimalArticle($cdarti);

      $title = $this->translate('_common.article') . ': ' . $cdarti . ' - ' . $anaart->dsarti;

      echo json_encode(array(
        'title'         => $title,
        'defaultImg'    => $anaart->flimag,
      ));
    }
  }

  public function editModelAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $cdartn = $request->getPost("cdartn");
      $cdcata = $request->getPost("cdcata");

      $tipolo = Tipolo::getMinimalModel($cdartn);
      $imgart = Imgart::getImagesForModel($cdartn);
      $articles = Ctarti::getAllArticlesFromCatalogAndModel($cdcata, $cdartn);

      $title = $this->translate('_common.model') . ': ' . $cdartn . ' - ' . $tipolo->dsartn;

      $articleTable = "";
      for ($i = 0; $i < count($articles); $i++) {
        $url = file_exists('./img/model/' . $articles[$i]->flimag)
          ? 'img/model/' . $articles[$i]->flimag
          : 'upload/' . $articles[$i]->flimag;

        $articleTable .=
          "<div class='row modal-edit-model-article-row'>
            <div class='col-md-3 cdarti'>" . $articles[$i]->cdarti . "</div>
            <div class='col-md-5'>" . $articles[$i]->dsarti . "</div>
            <div class='col-md-4'>
              <div class='flimag' style='float:left'>" . $articles[$i]->flimag . "</div>
              <div class='remove-article-from-model'><a style='cursor:pointer' title='" . $this->translate('admin.catalog.delete.article') . "'><i class='fa fa-times'></i></a></div>
              <div style='float:right'>
                <form action='" . $this->url->get('admin/uploadImage') . "' class='dropzone dropzone-article'
                  data-url='" . $url . "' data-img='" . $articles[$i]->flimag . "'></form>
              </div>
            </div>
          </div>";
      }

      echo json_encode(array(
        'title'         => $title,
        'defaultImg'    => $tipolo->flimag,
        'galleryImg'    => $imgart,
        'articleTable'  => $articleTable,
      ));
    }
  }

  public function saveEditArticleAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $cdarti           = $request->getPost("cdarti");
      $defaultImage     = $request->getPost("defaultImage");
      $descriptions     = $request->getPost("descriptions");

      // Default image
      $anaart = Anaart::findFirstByCdarti($cdarti);
      $anaart->flimag = $defaultImage != '' ? $defaultImage : new \Phalcon\Db\RawValue('""');
      Anaart::safelySave($anaart);

      // Technical and commercial info
      $desart = Desart::find(array('tpinpu = "AR" AND codice = :codice:', 'bind' => array('codice' => $cdarti)));
      $desart->delete();
      foreach ($descriptions as $item) {
        if ($item['text'] != '') {
          $desart = new Desart();
          $desart->tpinpu = 'AR';
          $desart->codice = $cdarti;
          $desart->tpdesc = $item['type'];
          $desart->idlang = strtoupper($item['lang']);
          $desart->descri = $item['text'];
          $desart->save();
        }
      }

      echo json_encode('OK');
    }
  }

  public function saveEditModelAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $cdartn           = $request->getPost("cdartn");
      $cdcata           = $request->getPost("cdcata");
      $defaultImage     = $request->getPost("defaultImage");
      $galleryImage     = $request->getPost("galleryImage");
      $descriptions     = $request->getPost("descriptions");
      $currentArticles  = $request->getPost("currentArticles");

      // Default image
      $tipolo = Tipolo::findFirstByCdartn($cdartn);
      $tipolo->flimag = $defaultImage;
      Tipolo::safelySave($tipolo);

      // Gallery images
      Imgart::deleteAllImagesForModel($cdartn);
      if ($galleryImage != '' && count($galleryImage) > 0) {
        $i = 2;
        foreach ($galleryImage as $img) {
          Imgart::saveModelImage($i, $cdartn, $img);
          $i++;
        }
      }

      // Technical and commercial info
      Desart::deleteAllDescriptionsForModel($cdartn);
      foreach ($descriptions as $item) {
        if ($item['text'] != '') {
          Desart::saveModelDescription($cdartn, $item['type'], $item['lang'], $item['text']);
        }
      }

      // Remove articles in current catalog
      $auth = $this->session->get('auth');
      B2bCtllog::insertLogOperationForModel($cdartn, $cdcata, 1, 'DELETE', $auth['username'], $auth['id']);
      Ctarti::deleteAllArticlesForCatalogAndModel($cdcata, $cdartn);

      // Insert articles in current catalog
      if ($currentArticles != null && count($currentArticles) > 0) {
        foreach ($currentArticles as $anaartToInsert) {
          B2bCtllog::insertLogOperation($anaartToInsert['cdarti'], $cdcata, 1, 'INSERT', $auth['username'], $auth['id']);
          Ctarti::insertArticleForCatalog($cdcata, $anaartToInsert['cdarti']);
          if (isset($anaartToInsert['flimag'])) {
            Anaart::updateArticleImage($anaartToInsert['cdarti'], $anaartToInsert['flimag']);
          }
        }
      }

      echo json_encode('OK');
    }
  }

  public function getCatalogDetailArticlesAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $cdcata = $request->getPost("cdcata");
      $cdstag = $request->getPost("cdstag");

      $articles = Anaart::getAllArticlesFromCatalog($cdcata, $cdstag);

      echo json_encode($articles);
    }
  }

  public function getCatalogDetailModelsAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $cdcata = $request->getPost("cdcata");
      $cdstag = $request->getPost("cdstag");

      $models = Tipolo::getAllModelsFromCatalog($cdcata, $cdstag);

      echo json_encode($models);
    }
  }

  public function getCatalogDetailLinesAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $cdcata = $request->getPost("cdcata");
      $cdstag = $request->getPost("cdstag");

      $lines = Linmod::getAllLinesFromCatalog($cdcata, $cdstag);

      echo json_encode($lines);
    }
  }

  public function getCatalogDetailSeasonsAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $cdcata = $request->getPost("cdcata");

      $seasons = Tipolo::getAllSeasonsFromCatalog($cdcata);

      echo json_encode($seasons);
    }
  }

  public function getCategoryDetailAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $cdcata = $request->getPost("cdcata");
      $cdtitl = $request->getPost("cdtitl");
      $cdlinm = $request->getPost("cdlinm");
      $cdserm = $request->getPost("cdserm");
      $categoryId = $request->getPost("categoryId");

      $models = Ctarti::getCatalogDetailModels($cdcata, $cdtitl, $cdlinm, $cdserm);

      $html = $this->getCatalogModelDetailRowsHtml($models, $cdcata, $categoryId);

      echo json_encode(array('success' => true, 'html' => $html));
    }
  }

  public function getCatalogSortingAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $cdcata = $request->getPost("cdcata");
      $zone   = $request->getPost("zone");
      $cdtitl = $request->getPost("cdtitl");
      $cdlinm = $request->getPost("cdlinm");
      $cdserm = $request->getPost("cdserm");

      $items = array(
        'cdcata' => $cdcata,
        'cdtitl' => $cdtitl,
        'cdlinm' => $cdlinm,
        'cdserm' => $cdserm,
        'idlang' => $this->utility->getLanguage(),
        'isSpecialSorting' => $zone > 0
      );
      $models = Tipolo::getAllSimpleModelsForCatalog($items);

      $html = $this->getCatalogSortingHtml($models);

      echo json_encode($html);
    }
  }

  public function saveSortedCatalogAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $cdcata = $request->getPost("cdcata");
      $zone   = $request->getPost("zone");
      $models = $request->getPost("models");
      $useCustom = $request->getPost("useCustom");

      if (filter_var($useCustom, FILTER_VALIDATE_BOOLEAN)) {
        B2bAddinf::insertCustomSortingFlagForCatalog($cdcata);
        $seqrapField = $zone == 0 ? 'seqrap' : 'seqra2';
        foreach ($models as $model) {
          B2bAddinf::insertCustomSeqrap($model[0], $seqrapField, $model[1]);
        }
      } else {
        B2bAddinf::deleteCustomSortingFlagForCatalog($cdcata);
        B2bAddinf::deleteCustomSortingForCatalog($cdcata);
      }

      echo json_encode('OK');
    }
  }

  public function updateCatalogAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $cdcata   = $request->getPost('cdcata');
      $cdstag   = $request->getPost('cdstag');
      $dscata   = $request->getPost('dscata');
      $seqrap   = $request->getPost('seqrap');
      $dates    = $request->getPost('dates');
      $fltipo   = $request->getPost('fltipo');
      $cdregv   = $request->getPost('cdregv');

      $arr_dates  = explode(" - ", $dates);
      $arr_dtiniz = explode("/", $arr_dates[0]);
      $arr_dtfine = explode("/", $arr_dates[1]);

      $dtiniz = $arr_dtiniz[2] . "-" . $arr_dtiniz[1] . "-" . $arr_dtiniz[0];
      $dtfine = $arr_dtfine[2] . "-" . $arr_dtfine[1] . "-" . $arr_dtfine[0];

      $cttest = Cttest::findFirstByCdcata($cdcata);
      $cttest->dscata = $dscata;
      $cttest->cdstag = $cdstag;
      $cttest->seqrap = $seqrap;
      $cttest->dtiniz = $dtiniz;
      $cttest->dtfine = $dtfine;
      $cttest->flescl = 0;
      $cttest->fltipo = $fltipo;
      $cttest->cdregv = $cdregv;
      $cttest->save();

      echo json_encode('OK');
    }
  }

  public function insertArticlesToCatalogAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $this->view->disable();

      $mode   = $request->getPost("mode");
      $cdcata = $request->getPost("cdcata");
      $data   = $request->getPost("data");
      $length = count($data);

      $auth = $this->session->get('auth');
      switch ($mode) {
          // articles
        case 0:
          // insert articles from selection
          Ctarti::insertArticlesToCatalog($cdcata, $data);

          if (count($data) > 0) {
            $auth = $this->session->get('auth');
            foreach ($data as $article) {
              B2bCtllog::insertLogOperation($article['cdarti'], $cdcata, 1, 'DELETE', $auth['username'], $auth['id']);
            }
          }

          // reload
          $results = Anaart::getAllArticlesFromCatalog($cdcata);
          break;

          // models
        case 1:
          // insert articles from models
          Ctarti::insertArticlesToCatalogFromModels($data, $cdcata);

          if (count($data) > 0) {
            foreach ($data as $model) {
              B2bCtllog::insertLogOperationForModel($model['cdartn'], $cdcata, 1, 'INSERT', $auth['username'], $auth['id']);
            }
          }

          // reload
          $results = Tipolo::getAllModelsFromCatalog($cdcata);
          break;

          // lines
        case 2:
          // insert articles from lines
          Ctarti::insertArticlesToCatalogFromLines($data, $cdcata);

          if (count($data) > 0) {
            foreach ($data as $line) {
              B2bCtllog::insertLogOperationForLine($line['cdlinm'], $cdcata, 1, 'INSERT', $auth['username'], $auth['id']);
            }
          }

          // reload
          $results = Linmod::getAllLinesFromCatalog($cdcata);
          break;

          // seasons
        case 3:
          // insert articles from seasons
          Ctarti::insertArticlesToCatalogFromSeasons($data, $cdcata);

          if (count($data) > 0) {
            foreach ($data as $season) {
              B2bCtllog::insertLogOperationForSeason($season['cdstag'], $cdcata, 1, 'INSERT', $auth['username'], $auth['id']);
            }
          }

          // reload
          $results = Tipolo::getAllSeasonsFromCatalog($cdcata);
          break;
      }

      echo json_encode($results);
    }
  }

  public function assignImageAutoAllAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $cdcata = $request->getPost('cdcata');
      $reassi = $request->getPost('reassi');
      $syncType = $this->utility->getAppSettings('SyncType');

      /*
      When calling assign image inside model detail:
      - if reassi = 1 -> assign all model images from MODE, MOD1 on + article images, even if they are present
      - if reassi = 0 -> assign all model images from MODE, MOD1 on + article images ONLY if not present
      */

      ini_set('max_execution_time', 0);
      if ($syncType == 0) {
        $models = Tipolo::getModelCodesFromCatalog($cdcata);
        foreach ($models as $model) {
          $this->assignImageModelCtarti($model->cdartn);
          $this->assignImageModAggCtarti($model->cdartn, $reassi);
          $this->assignImageModArtCtarti($model->cdartn, $cdcata, $reassi);
        }
      } else {
        for ($i = 0; $i < 7; $i++) {
          $this->assignImagesSpecial($cdcata, $syncType, $reassi == 1, '', $i, false);
        }
      }
      ini_set('max_execution_time', 300);

      echo json_encode('OK');
    }
  }
  //endregion

  //region Ajax functions: Lookbook manager
  public function saveLookbookAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $cdcata = $request->getPost('cdcata');
      $cdlkbk = $request->getPost('cdlkbk');
      $dslkbk = $request->getPost('dslkbk');
      $filimg = $request->getPost('filimg');

      if ($filimg == null)
        $filimg = ' ';

      $lktest = Lktest::findFirstByCdlkbk($cdlkbk);

      if ($lktest != null) {
        echo json_encode('PR');
      } else {
        Lktest::createNewLookbook($cdlkbk, $dslkbk, $cdcata, $filimg, $this->utility->getAppSettings('LookbookItemType'));
        echo json_encode('OK');
      }
    }
  }

  public function deleteLookbookAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $cdlkbk = $request->getPost('cdlkbk');

      Lktest::deleteLookbook($cdlkbk);
      if ($this->utility->getAppSettings('LookbookItemType') == 0) {
        Lkmode::deleteLookbook($cdlkbk);
      } else {
        Lkarti::deleteLookbook($cdlkbk);
      }
      Lkcorp::deleteLookbook($cdlkbk);
      Lkimag::deleteLookbook($cdlkbk);

      echo json_encode('OK');
    }
  }

  public function saveEditLookbookAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $cdlkbk = $request->getPost('cdlkbk');
      $dslkbk = $request->getPost('dslkbk');
      $filimg = $request->getPost('filimg');
      $lkcorp = $request->getPost('lkcorp');

      $lookType = $this->utility->getAppSettings('LookbookItemType');

      Lktest::updateLookbook($cdlkbk, $dslkbk, $filimg);

      // remove all info about this lookbook
      Lkimag::deleteLookbook($cdlkbk);
      if ($this->utility->getAppSettings('LookbookItemType') == 0) {
        Lkmode::deleteLookbook($cdlkbk);
      } else {
        Lkarti::deleteLookbook($cdlkbk);
      }
      Lkcorp::deleteLookbook($cdlkbk);

      if ($lkcorp != null && count($lkcorp) > 0) {
        foreach ($lkcorp as $look) {
          $cdlook = $look['cdlook'];
          $dslook = $look['dslook'];
          $seqrap = $look['seqrap'];

          $i = 0;
          foreach ($look['lkimag'] as $filimg) {
            Lkimag::insertNewLookImage($cdlkbk, $cdlook, $i, $filimg);
            $i++;
          }

          if ($look["items"]) {
            switch ($lookType) {
              case 0:
                $i = 0;
                foreach ($look["items"] as $cdartn) {
                  Lkmode::insertNewModelIntoLook($cdlkbk, $cdlook, $cdartn, $i);
                  $i++;
                }
                break;
              case 1:
                $i = 0;
                foreach ($look["items"] as $cdarti) {
                  Lkarti::insertNewArticleIntoLook($cdlkbk, $cdlook, $cdarti, $i, '');
                  $i++;
                }
                break;
              case 2:
                $i = 0;
                foreach ($look["items"] as $codes) {
                  $tokens = explode('&', $codes);
                  $el = explode(',', str_replace('code=', '', $tokens[0]));
                  $img = str_replace('img=', '', $tokens[1]);
                  Lkarti::insertNewLardiniArticleIntoLook($cdlkbk, $cdlook, $el[0], $el[1], $el[2], $i, $img);
                  $i++;
                }
                break;
            }
          }

          Lkcorp::createNewLook($cdlkbk, $cdlook, $dslook, $seqrap);
        }
      }


      echo json_encode("OK");
    }
  }

  public function getLookbookPageAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $index    = $request->getPost('index');

      $lookType = $this->utility->getAppSettings('LookbookItemType');
      $html     = $this->getLookbookPageHtml($index, $lookType);

      echo json_encode($html);
    }
  }

  public function getLookbookItemsOptionsAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $codes  = $request->getPost('codes');
      $codes  = $codes != '' ? $codes : array();
      $cdlkbk = $request->getPost('cdlkbk');

      $lookType = $this->utility->getAppSettings('LookbookItemType');

      $html     = '';
      switch ($lookType) {
        case 0:
          $items = Tipolo::getModelsFromLookbook($cdlkbk);
          break;
        case 1:
          $items = Anaart::getArticlesFromLookbook($cdlkbk);
          break;
        case 2:
          $items = Anaart::getLardiniArticlesFromLookbook($cdlkbk);
          break;
      }

      if (count($items) > 0) {
        foreach ($items as $item) {
          switch ($lookType) {
            case 0:
              $code         = htmlspecialchars($item->cdartn);
              $description  = htmlspecialchars($item->dsartn);
              $line         = htmlspecialchars($item->cdlinm);
              $series       = htmlspecialchars($item->cdserm);
              $html .=
                "<option value='$code'" . (in_array($code, $codes) ? " selected='selected'" : '') . '>' .
                $line . ' - ' . ($series != '' ? $series . ' - ' : '') . $code . ' - ' . $description .
                '</option>';
              break;
            case 1:
              $code         = htmlspecialchars($item->cdarti);
              $description  = htmlspecialchars($item->dsarti);
              $line         = htmlspecialchars($item->cdlinm);
              $series       = htmlspecialchars($item->cdserm);
              $html .=
                "<option value='$code'" . (in_array($code, $codes) ? " selected='selected'" : '') . '>' .
                $line . ' - ' . ($series != '' ? $series . ' - ' : '') . $code . ' - ' . $description .
                '</option>';
              break;
            case 2:
              $code         = htmlspecialchars($item->cdarti) . ' - ' . htmlspecialchars($item->cdpers) . ' - ' . htmlspecialchars($item->cdcolo);
              $html .=
                "<option value='$code'" . (in_array($code, $codes) ? " selected='selected'" : '') . '>' . $code . '</option>';
              break;
          }
        }
      }

      echo json_encode($html);
    }
  }

  public function getModelsForLookFromSearchAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $search = $request->getPost('search');
      $cdcata = $request->getPost('cdcata');

      $models = Tipolo::getModelsForLookFromSearch($search, $cdcata);

      $results = '';
      if (count($models) >  0) {
        foreach ($models as $model) {
          $results .= '<div class="selectable-item" data-cdartn="' . $model->cdartn . '">' . $model->cdartn . '</div>';
        }
      }

      echo json_encode(array('results' => $results));
    }
  }

  public function getFabricsForLookFromModelAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $cdartn = $request->getPost('cdartn');
      $cdcata = $request->getPost('cdcata');

      $fabrics = Anaper::getFabricsForLookFromModel($cdartn, $cdcata);

      $results = '';
      if (count($fabrics) >  0) {
        foreach ($fabrics as $fabric) {
          $results .= '<div class="selectable-item" data-cdpers="' . $fabric->cdpers . '">' . $fabric->cdpers . '</div>';
        }
      }

      echo json_encode(array('results' => $results));
    }
  }

  public function getColorsForLookFromModelAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $cdartn = $request->getPost('cdartn');
      $cdpers = $request->getPost('cdpers');
      $cdcata = $request->getPost('cdcata');

      $colors = Artcol::getColorsForLookFromModel($cdartn, $cdpers, $cdcata);

      $results = '';
      if (count($colors) >  0) {
        foreach ($colors as $color) {
          $results .= '<div class="selectable-item" data-cdcolo="' . $color->cdcolo . '">' . $color->cdcolo . '</div>';
        }
      }

      echo json_encode(array('results' => $results));
    }
  }

  public function getLookArticleCustomImagesAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $codes  = $request->getPost('codes');
      $codes  = $codes != '' ? $codes : array();
      $cdlkbk = $request->getPost('cdlkbk');

      $articleTable = "";
      for ($i = 0; $i < count($codes); $i++) {
        if ($this->utility->getAppSettings('LookbookItemType') == 1) {
          $article = Anaart::getMinimalArticle($codes[$i]);
          $flimag = $article->flimag;
          $img = $flimag;
        } else {
          $tokens = explode('&', $codes[$i]);
          $el = explode(',', str_replace('code=', '', $tokens[0]));
          $article = Anaart::getArticleFromCdarti($el[0]);
          $article->cdarti = $el[0];
          $article->cdpers = $el[1];
          $article->cdcolo = $el[2];
          $flimag = $article->flimag_arti != '' ? $article->flimag_arti : $article->flimag_artn;
          $img = str_replace('img=', '', $tokens[1]) ? str_replace('img=', '', $tokens[1]) : $flimag;
        }

        $url = file_exists('./upload/looks/' . $img)
          ? 'upload/looks/' . $img
          : 'img/model/' . $img;

        $articleTable .=
          "<div class='row modal-edit-model-article-row'>
            <div class='col-md-3 codes' data-codes='" . $article->cdarti . "," . $article->cdpers . "," . $article->cdcolo . "'>" . $article->cdarti . "</div>
            <div class='col-md-3'>" . $article->cdpers . "</div>
            <div class='col-md-2'>" . $article->cdcolo . "</div>
            <div class='col-md-4'>
              <div class='flimag' style='float:left'>" . $img . "</div>
              <div style='float:right'>
                <form action='" . $this->url->get('admin/uploadImage/looks') . "' class='dropzone dropzone-article'
                  data-url='" . $url . "' data-img='" . $img . "'></form>
              </div>
            </div>
          </div>";
      }
      echo json_encode(array('articleTable'  => $articleTable));
    }
  }
  //endregion

  //region Ajax functions: Device manager
  public function saveDeviceAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $cdagen   = $request->getPost('cdagen');
      $tpcond   = $request->getPost('tpcond');
      $fltota   = $request->getPost('fltota');
      $fllist   = $request->getPost('fllist');

      $psagen   = $request->getPost('psagen');

      $error = false;
      Psagen::deleteAgent($cdagen);
      Abagen::deleteAgent($cdagen);

      for ($i = 0; $i < count($psagen); $i++) {
        Psagen::insertNewDevice($cdagen, $psagen[$i][0], $psagen[$i][1], $psagen[$i][2]);
      }

      Abagen::insertNewAgent($cdagen, $tpcond, $fltota, $fllist);

      echo json_encode("OK");
    }
  }

  public function deleteDeviceAction() {
    $this->view->disable();
    $request = new Request();

    if ($request->isPost() && $request->isAjax()) {
      $cdagen = $request->getPost('cdagen');
      $cdpost = $request->getPost('cdpost');

      Psagen::deleteDeviceForAgent($cdagen, $cdpost);
      if (count(Psagen::findByCdagen($cdagen)) == 0) {
        Abagen::deleteAgent($cdagen);
      }

      echo json_encode('OK');
    }
  }
  //endregion

  //region Ajax functions: Condition manager
  public function getCheckedConditionsAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $tpcond = $request->getPost("tpcond");
      $cdstag = $request->getPost("cdstag");
      $type   = $request->getPost("type");

      $items = $type == 'p' ? Pagcon::getConditions($cdstag, $tpcond) : Tpocon::getConditions($cdstag, $tpcond);

      echo json_encode($items);
    }
  }

  public function updateConditionsAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $type   = $request->getPost("type");
      $tpcond = $request->getPost("tpcond");
      $cdstag = $request->getPost("cdstag");
      $tpitem = $request->getPost("tpitem");

      if ($type == 'p') {
        Pagcon::deleteConditions($cdstag, $tpcond);
        foreach ($tpitem as $item) {
          Pagcon::insertCondition($cdstag, $tpcond, $item[0], $item[1]);
        }
      } else {
        Tpocon::deleteConditions($cdstag, $tpcond);
        foreach ($tpitem as $item) {
          Tpocon::insertCondition($cdstag, $tpcond, $item[0], $item[1]);
        }
      }

      echo json_encode("OK");
    }
  }

  public function updateDefaultConditionsAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $type   = $request->getPost("type");
      $tpitem = $request->getPost("tpitem");

      if ($type == 'p') {
        Tppaga::resetDefcon();
        foreach ($tpitem as $item) {
          Tppaga::updateDefcon($item, 1);
        }
      } else {
        Tpport::resetDefcon();
        foreach ($tpitem as $item) {
          Tpport::updateDefcon($item, 1);
        }
      }

      echo json_encode("OK");
    }
  }
  //endregion

  //region Ajax functions: Expiration manager
  public function getDeliveryDatesAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $cdcata = $request->getPost("cdcata");
      $tpcond = $request->getPost("tpcond");

      $dates = Scacon::getDatesFromCatalog($cdcata, $tpcond);

      echo json_encode($dates);
    }
  }

  public function getSpecialDeliveryDatesAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $cdcata = $request->getPost("cdcata");

      $dates = Scmcon::getDatesFromCatalog($cdcata);

      echo json_encode($dates);
    }
  }

  public function saveExpirationConditionAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $type   = $request->getPost("type");
      $mode   = $request->getPost("mode");
      $cdcata = $request->getPost("cdcata");
      $tpcond = $request->getPost("tpcond");
      $seqrap = $request->getPost("seqrap");
      $dtmini = $request->getPost("dtmini");
      $dtmaxi = $request->getPost("dtmaxi");
      $dtmcli = $request->getPost("dtmcli");
      $dsscad = $request->getPost("dsscad");
      $dtmcoi = $request->getPost("dtmcoi");
      $dtmcof = $request->getPost("dtmcof");

      $arr_dtmini = explode("/", $dtmini);
      $arr_dtmaxi = explode("/", $dtmaxi);
      $arr_dtmcli = explode("/", $dtmcli);
      $arr_dtmcoi = explode("/", $dtmcoi);
      $arr_dtmcof = explode("/", $dtmcof);

      $dtmini = $arr_dtmini[2] . "-" . $arr_dtmini[1] . "-" . $arr_dtmini[0];
      $dtmaxi = $arr_dtmaxi[2] . "-" . $arr_dtmaxi[1] . "-" . $arr_dtmaxi[0];
      $dtmcli = $arr_dtmcli[2] . "-" . $arr_dtmcli[1] . "-" . $arr_dtmcli[0];
      $dtmcoi = $arr_dtmcoi[2] . "-" . $arr_dtmcoi[1] . "-" . $arr_dtmcoi[0];
      $dtmcof = $arr_dtmcof[2] . "-" . $arr_dtmcof[1] . "-" . $arr_dtmcof[0];

      if ($mode == "new" || $mode == "duplicate") {
        $seqrap = Scacon::getMaxSeqrap($cdcata, $tpcond) + 1;
        Scacon::insertExpiration($cdcata, $tpcond, $seqrap, $dtmini, $dtmaxi, $dtmcli, $dsscad, $dtmcoi, $dtmcof);
      } else if ($mode == "edit") {
        Scacon::updateExpiration($cdcata, $tpcond, $seqrap, $dtmini, $dtmaxi, $dtmcli, $dsscad, $dtmcoi, $dtmcof);
      }

      echo json_encode('OK');
    }
  }

  public function saveSpecialExpirationConditionAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $mode   = $request->getPost("mode");

      $cdstag = $request->getPost("cdstag");
      $seqrap = $request->getPost("seqrap");

      $dtmini = $request->getPost("dtmini");
      $dtmaxi = $request->getPost("dtmaxi");
      $dtmcli = $request->getPost("dtmcli");
      $dsscad = $request->getPost("dsscad");
      $cdlinm = $request->getPost("cdlinm");
      $cdserm = $request->getPost("cdserm");
      $cdartn = $request->getPost("cdartn");
      $cdarti = $request->getPost("cdarti");

      $arr_dtmini = explode("/", $dtmini);
      $arr_dtmaxi = explode("/", $dtmaxi);
      $arr_dtmcli = explode("/", $dtmcli);

      $dtmini = $arr_dtmini[2] . "-" . $arr_dtmini[1] . "-" . $arr_dtmini[0];
      $dtmaxi = $arr_dtmaxi[2] . "-" . $arr_dtmaxi[1] . "-" . $arr_dtmaxi[0];
      $dtmcli = $arr_dtmcli[2] . "-" . $arr_dtmcli[1] . "-" . $arr_dtmcli[0];

      if ($mode == "new" || $mode == "duplicate") {
        $seqrap = Scmcon::getMaxSeqrap($cdcata) + 1;
        Scmcon::insertExpiration($cdcata, $cdlinm, $cdserm, $cdartn, $cdarti, $seqrap, $dtmini, $dtmaxi, $dtmcli, $dsscad);
      } else if ($mode == "edit") {
        Scmcon::insertExpiration($cdcata, $cdlinm, $cdserm, $cdartn, $cdarti, $seqrap, $dtmini, $dtmaxi, $dtmcli, $dsscad);
      }

      echo json_encode('OK');
    }
  }

  public function deleteExpirationConditionAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $cdcata = $request->getPost("cdcata");
      $tpcond = $request->getPost("tpcond");
      $seqrap = $request->getPost("seqrap");

      Scacon::deleteExpiration($cdstag, $tpcond, $seqrap);

      echo json_encode('OK');
    }
  }

  public function deleteSpecialExpirationConditionAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $cdcata = $request->getPost("cdcata");
      $cdlinm = $request->getPost("cdlinm");
      $cdserm = $request->getPost("cdserm");
      $cdartn = $request->getPost("cdartn");
      $cdarti = $request->getPost("cdarti");
      $seqrap = $request->getPost("seqrap");

      Scmcon::deleteSpecialExpiration($cdstag, $cdlinm, $cdserm, $cdartn, $cdarti, $seqrap);

      echo json_encode('OK');
    }
  }
  //endregion

  //region Ajax functions: Availability manager
  public function getArticleAvailabilityToEditAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $cdarti   = $request->getPost('cdarti');

      $sizes = Postgl::getAllSizesWithAvailabilityForArticle($cdarti);
      $asso  = Astest::getAllAssortmentsForArticleWithAvailability($cdarti);

      echo json_encode(array('sizes' => $sizes, 'asso' => $asso));
    }
  }

  public function editArticleAvailabilityAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $cdarti   = $request->getPost('cdarti');
      $sizes    = $request->getPost('sizes');
      $asso     = $request->getPost('asso');

      Dscorp::deleteArticleAvailabity($cdarti);

      if (!empty($sizes) && count($sizes) > 0) {
        foreach ($sizes as $item) {
          Dscorp::insertArticleAvailability($cdarti, $item['taglia'], $item['quanti']);
       }
      }

      if (!empty($asso) && count($asso) > 0) {
        foreach ($asso as $item) {
          Dscorp::insertArticleAssortmentAvailability($cdarti, $item['cdasso'], $item['quanti']);
        }
      }

      echo json_encode('OK');
    }
  }

  public function loadArticlesAvailabilityAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $cdcata = $request->getPost('cdcata');

      $articles = Dscorp::getArticlesWithAvailability($cdcata);

      $fullArticles = array();
      foreach ($articles as $item) {
        $currentArticle = $item;
        $currentArticle->sizes = Postgl::getAllSizesWithAvailabilityForArticle($item->cdarti);
        $currentArticle->asso  = Astest::getAllAssortmentsForArticleWithAvailability($item->cdarti);
        $fullArticles[] = $currentArticle;
      }

      $html = $this->getArticlesAvailabilityHtml($fullArticles);

      echo json_encode(array('response' => 'OK', 'html' => $html));
    }
  }

  public function loadArticlesWithEmptyAvailabilityAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $cdcata = $request->getPost('cdcata');

      $articles = Ctarti::getArticlesWithoutAvailability($cdcata);

      echo json_encode($articles);
    }
  }

  public function deleteArticleAvailabilityAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $cdarti   = $request->getPost('cdarti');

      Dscorp::deleteArticleAvailabity($cdarti);

      echo json_encode('OK');
    }
  }
  //endregion

  //region Ajax functions: Promo manager
  public function savePromoAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $update   = $request->getPost('update');

      // pvtest
      $cdprom   = $request->getPost('cdprom');
      $dsprom   = $request->getPost('dsprom');
      $flescl   = $request->getPost('flescl');
      $validity = $request->getPost('validity');

      // pvcorp
      $tpinpu   = $request->getPost('tpinpu');
      $valore   = $request->getPost('valore');
      $quanti   = $request->getPost('quanti');
      $prezzo   = $request->getPost('prezzo');
      $scont1   = $request->getPost('scont1');
      $scont2   = $request->getPost('scont2');
      $scont3   = $request->getPost('scont3');
      $provvi   = $request->getPost('provvi');
      $preven   = $request->getPost('preven');
      $seqrap   = $request->getPost('seqrap');

      // pvgrup
      $pvgrup   = $request->getPost('pvgrup');

      $pvtest = Pvtest::findFirstByCdprom($cdprom);

      if (($update == 0 && $pvtest != null) || ($update == 1 && $pvtest == null)) {
        echo json_encode('AP');
      } else {
        $dates = explode (' - ', $validity);
        $in_tk = explode ('/', $dates[0]);
        $fi_tk = explode ('/', $dates[1]);

        if ($update == 0) {
          $pvtest = new Pvtest();
        }
        $pvtest->cdprom = $cdprom;
        $pvtest->dsprom = $dsprom;
        $pvtest->dtiniz = $in_tk[2] . "-" . $in_tk[1] . "-" . $in_tk[0];
        $pvtest->dtfine = $fi_tk[2] . "-" . $fi_tk[1] . "-" . $fi_tk[0];
        $pvtest->tputil = "OC";
        $pvtest->valore = 0;
        $pvtest->quanti = 0;
        $pvtest->flescl = $flescl;
        $pvtest->seqapp = 0;
        $pvtest->tipapp = new \Phalcon\Db\RawValue('');
        $pvtest->scont1 = 0;
        $pvtest->scont2 = 0;
        $pvtest->scont3 = 0;
        $pvtest->provvi = 0;
        $pvtest->tpport = new \Phalcon\Db\RawValue('');
        $pvtest->tpanag = new \Phalcon\Db\RawValue('');
        $pvtest->cdanag = new \Phalcon\Db\RawValue('');

        if ($pvtest->save() === false) {
          echo json_encode("PT");
        } else {
          $nurpro = 0;
          if ($update == 0) {
            $nurpro = Pvcorp::getMaxNurpro();
          } else {
            Pvcorp::deletePromoDetails($cdprom);
          }

          for ($i = 0; $i < count($valore); $i++) {
            $nurpro = $nurpro + 1;

            $cdtitl = $tpinpu == "TL" && $pvgrup[0][0] == "TL" ? $pvgrup[0][1] : '';
            if ($tpinpu != "LI" && $tpinpu != "SE"){
              $cdlinm = new \Phalcon\Db\RawValue('');
            } else if ($tpinpu == "LI") {
              $cdlinm = $pvgrup[0][0] == "LI" ? $pvgrup[0][1] : new \Phalcon\Db\RawValue('');
            } else {
              $cdlinm = $pvgrup[0][0] == "SE" ? $pvgrup[0][2] : new \Phalcon\Db\RawValue('');
            }
            $cdserm = $tpinpu == "SE" && $pvgrup[0][0] == "SE" ? $pvgrup[0][1] : new \Phalcon\Db\RawValue('');
            $tpmode = $tpinpu == "TM" && $pvgrup[0][0] == "TM" ? $pvgrup[0][1] : new \Phalcon\Db\RawValue('');
            $cdartn = $tpinpu == "AN" && $pvgrup[0][0] == "AN" ? $pvgrup[0][1] : new \Phalcon\Db\RawValue('');
            $cdarti = $tpinpu == "AR" && $pvgrup[0][0] == "AR" ? $pvgrup[0][1] : new \Phalcon\Db\RawValue('');
            Pvcorp::insertNewPromoDetail(
              $nurpro,
              $cdprom,
              $seqrap[$i],
              $tpinpu,
              $cdtitl,
              $cdlinm,
              $cdserm,
              $tpmode,
              $cdartn,
              $cdarti,
              $valore[$i],
              $quanti[$i],
              $prezzo[$i],
              $scont1[$i],
              $scont2[$i],
              $scont3[$i],
              $provvi[$i],
              $preven[$i]
            );
          }

          // TODO
          if ($tpinpu == "GR") {
            $nurgrp = 0;

            if ($update == 0) {
              $nurpro = Pvgrup::getMaxNurgrp();
            } else {
              Pvgrup::deletePromoGroups($cdprom);
            }

            for ($i = 0; $i < count($pvgrup); $i++) {
              $nurgrp = $nurgrp + 1;

              $cdtitl = $pvgrup[$i][0] == 'TL' && $pvgrup[$i][0] == 'TL' ? $pvgrup[$i][1] : new \Phalcon\Db\RawValue('');
              if ($pvgrup[$i][0] != 'LI' && $pvgrup[$i][0] != 'SE'){
                $cdlinm = new \Phalcon\Db\RawValue('');
              } else if ($pvgrup[$i][0] == 'LI') {
                $cdlinm = $pvgrup[$i][0] == 'LI' ? $pvgrup[$i][1] : new \Phalcon\Db\RawValue('');
              } else {
                $cdlinm = $pvgrup[$i][0] == 'SE' ? $pvgrup[$i][2] : new \Phalcon\Db\RawValue('');
              }
              $cdserm = $pvgrup[$i][0] == 'SE' && $pvgrup[$i][0] == 'SE' ? $pvgrup[$i][1] : new \Phalcon\Db\RawValue('');
              $cdartn = $pvgrup[$i][0] == 'AN' && $pvgrup[$i][0] == 'AN' ? $pvgrup[$i][1] : new \Phalcon\Db\RawValue('');
              $cdarti = $pvgrup[$i][0] == 'AR' && $pvgrup[$i][0] == 'AR' ? $pvgrup[$i][1] : new \Phalcon\Db\RawValue('');
              $tpmode = $pvgrup[$i][0] == 'TM' && $pvgrup[$i][0] == 'TM' ? $pvgrup[$i][1] : new \Phalcon\Db\RawValue('');
              Pvgrup::insertNewPromoGroup(
                $nurgrp,
                $cdprom,
                $pvgrup[$i][0],
                $cdtitl,
                $cdlinm,
                $cdserm,
                $cdartn,
                $cdarti,
                $tpmode
              );
            }
          }

          echo json_encode('OK');
	      }
      }
    }
  }

  public function deletePromoAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $cdprom   = $request->getPost('cdprom');

      Pvtest::deletePromo($cdprom);
      Pvcorp::deletePromoDetails($cdprom);
      Pvgrup::deletePromoGroups($cdprom);

      echo json_encode('OK');
    }
  }
  //endregion

  //region Html functions: Catalog manager
  function getCatalogArticlesTableHtml($articles, $cdcata) {
    $current_cdtitl = '';
    $current_cdlinm = '';
    $current_cdserm = '';
    $current_cdartn = '';
    $old_cdtitl = '';
    $old_cdlinm = '';
    $old_cdserm = '';
    $old_cdartn = '';
    $current_variations = 0;
    $html_articles = '';
    $html_model1 = '';
    $html_model2 = '';
    $full_html = '';

    $index = 0;

    for ($i = 0; $i < count($articles); $i++) {
      $article = $articles[$i];

      if (
        $current_cdtitl != $article->cdtitl ||
        $current_cdlinm != $article->cdlinm ||
        $current_cdserm != $article->cdserm ||
        $current_cdartn != $article->cdartn
      ) {

        // Save if we have to start a new row
        if ($i != 0) {
          $full_html .= $html_model1 . $current_variations . $html_model2 . $html_articles;
          $html_model1 = '';
          $html_model2 = '';
          $html_articles = '';
          $current_variations = 0;
        }

        $old_cdtitl = $current_cdtitl;
        $old_cdlinm = $current_cdlinm;
        $old_cdserm = $current_cdserm;

        if ($current_cdtitl != $article->cdtitl) {
          $current_cdtitl = $article->cdtitl;

          $full_html .=
            '<tr style="background-color:#d6d6d6;color:#333333;font-weight:bold"
              class="BR-' . $article->cdtitl . '">
              <td></td>
              <td>BR</td>
              <td>' . $article->cdtitl . '</td>
              <td></td>
              <td>' . $article->dstitl . '</td>
              <td></td>
              <td></td>
              <td>' . $article->titl_img . '</td>
              <td style="text-align:center">
                <span>
                  <a href="#" class="mod-titl" data-toggle="modal" data-target=".modal-brand-edit"
                    data-codice="' . $article->cdtitl . '" data-cdcata="' . $cdcata . '"
                    title="' . $this->translate('_common.edit') . '">
                    <span class="glyphicon glyphicon-edit" aria-hidden="true" style="margin-right:20px"></span>
                  </a>
                  <a href="#" class="del-titl" data-toggle="modal" data-target=".modal-brand"
                    data-codice="' . $article->cdtitl . '" data-cdcata="' . $cdcata . '"
                    title="' . $this->translate('_common.delete') . '">
                    <span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
                  </a>
                </span>
              </td>
            </tr>';
        }

        if ($current_cdlinm != $article->cdlinm) {
          $current_cdlinm = $article->cdlinm;

          $full_html .=
            '<tr style="background-color:#e1e1e1;color:#333333;font-weight:bold"
              class="BR-' . $article->cdtitl . ' LI-' . $article->cdlinm . '"
              data-cdtitl="' . $article->cdtitl . '" data-cdlinm="' . $article->cdlinm . '">
              <td></td>
              <td>LI</td>
              <td>&middot;&middot;&middot; ' . $article->cdlinm . '</td>
              <td></td>
              <td>' . $article->dslinm . '</td>
              <td></td>
              <td></td>
              <td>' . $article->linm_img . '</td>
              <td style="text-align:center">
                <span>
                  <a href="#" class="mod-linm" data-toggle="modal" data-target=".modal-line-edit" data-codice="' . $article->cdlinm . '"
                    data-cdcata="' . $cdcata . '" title="' . $this->translate('_common.edit') . '">
                    <span class="glyphicon glyphicon-edit" aria-hidden="true" style="margin-right:20px"></span>
                  </a>
                  <a href="#" class="del-linm" data-toggle="modal" data-target=".modal-line" data-codice="' . $article->cdlinm . '"
                    data-cdcata="' . $cdcata . '" title="' . $this->translate('_common.delete') . '">
                    <span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
                  </a>
                </span>
              </td>
            </tr>';
        }

        if ($old_cdlinm != $article->cdlinm || $current_cdserm != $article->cdserm) {
          $current_cdserm = $article->cdserm;

          $full_html .=
            '<tr style="background-color:#f1f1f1;color:#333333;font-weight:bold"
              class="BR-' . $article->cdtitl . ' LI-' . $article->cdlinm . ' SE-' . $article->cdserm . '"
              data-cdtitl="' . $article->cdtitl . '" data-cdlinm="' . $article->cdlinm . '"
              data-cdserm="' . $article->cdserm . '">
              <td></td>
              <td>SE</td>
              <td>&middot;&middot;&middot;&middot;&middot;&middot; ' . $article->cdserm . '</td>
              <td></td>
              <td>' . $article->dsserm . '</td>
              <td></td>
              <td></td>
              <td>' . $article->serm_img . '</td>
              <td style="text-align:center">
                <span>
                  <a href="#" class="mod-serm" data-toggle="modal" data-target=".modal-series-edit"
                    data-codice="' . $article->cdserm . '" data-codic2="' . $article->cdlinm . '" data-cdcata="' . $cdcata . '"
                    title="' . $this->translate('_common.edit') . '">
                    <span class="glyphicon glyphicon-edit" aria-hidden="true" style="margin-right:20px"></span>
                  </a>
                  <a href="#" class="del-serm" data-toggle="modal" data-target=".modal-series"
                    data-codice="' . $article->cdserm . '" data-codic2="' . $article->cdlinm . '" data-cdcata="' . $cdcata . '"
                    title="' . $this->translate('_common.delete') . '">
                    <span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
                  </a>
                </span>
              </td>
            </tr>';
        }

        $current_cdartn = $article->cdartn;

        $html_model1 .=
          '<tr style="background-color:white" data-seqnum="pos' . $index . '" data-id="' . str_replace('.', '_', $current_cdartn) . '"
            class="model-row BR-' . $article->cdtitl . ' LI-' . $article->cdlinm . ' SE-' . $article->cdserm . ' AN-' . str_replace('.', '_', str_replace(' ', '', $current_cdartn)) . '"
            data-cdtitl="' . $article->cdtitl . '" data-cdlinm="' . $article->cdlinm . '"
            data-cdserm="' . $article->cdserm . '" data-cdartn="' . str_replace('.', '_', str_replace(' ', '', $current_cdartn)) . '">
            <td>
              <a title="' . $this->translate('admin.catalog.seearticles') . '" class="articles-viewer" href="#">
                <span class="glyphicon glyphicon-plus" aria-hidden="true"></span>
              </a>
            </td>
            <td>MO</td>
            <td></td>
            <td>' . $article->cdartn . ' <a href="#' . $article->cdartn . '"></a></td>
            <td>' . $article->dsartn . '</td>
            <td style="text-align:center">';

        $index++;

        $escaped_artn_comm = '';
        $artn_comm_it = rtrim(str_replace("'", "\'", $article["artn_comm_it"]));
        $artn_comm_en = rtrim(str_replace("'", "\'", $article["artn_comm_en"]));
        $artn_comm_es = rtrim(str_replace("'", "\'", $article["artn_comm_es"]));
        $artn_comm_fr = rtrim(str_replace("'", "\'", $article["artn_comm_fr"]));
        $artn_comm_de = rtrim(str_replace("'", "\'", $article["artn_comm_de"]));
        if ($artn_comm_it != '') {
          $escaped_artn_comm .= ($escaped_artn_comm != '' ? '/' : '') . 'IT:' . $artn_comm_it;
        }
        if ($artn_comm_en != '') {
          $escaped_artn_comm .= ($escaped_artn_comm != '' ? '/' : '') . 'EN:' . $artn_comm_en;
        }
        if ($artn_comm_es != '') {
          $escaped_artn_comm .= ($escaped_artn_comm != '' ? '/' : '') . 'ES:' . $artn_comm_es;
        }
        if ($artn_comm_fr != '') {
          $escaped_artn_comm .= ($escaped_artn_comm != '' ? '/' : '') . 'FR:' . $artn_comm_fr;
        }
        if ($artn_comm_de != '') {
          $escaped_artn_comm .= ($escaped_artn_comm != '' ? '/' : '') . 'DE:' . $artn_comm_de;
        }
        if ($escaped_artn_comm != '') {
          $html_model1 .= '<a href="#" title="' . $escaped_artn_comm . '" data-id="comm-' . $article->cdartn . '"
            data-it="' . $artn_comm_it . '" data-en="' . $artn_comm_en . '" data-es="' . $artn_comm_es . '"
            data-fr="' . $artn_comm_fr . '" data-de="' . $artn_comm_de . '">
              <span class="glyphicon glyphicon-bookmark" aria-hidden="true" style="margin:0 5px"></span>
            </a>';
        }

        $escaped_artn_tecn = '';
        $artn_tecn_it = rtrim(str_replace("'", "\'", $article["artn_tecn_it"]));
        $artn_tecn_en = rtrim(str_replace("'", "\'", $article["artn_tecn_en"]));
        $artn_tecn_es = rtrim(str_replace("'", "\'", $article["artn_tecn_es"]));
        $artn_tecn_fr = rtrim(str_replace("'", "\'", $article["artn_tecn_fr"]));
        $artn_tecn_de = rtrim(str_replace("'", "\'", $article["artn_tecn_de"]));
        if ($artn_tecn_it != '') {
          $escaped_artn_tecn .= ($escaped_artn_tecn != '' ? '/' : '') . 'IT:' . $artn_tecn_it;
        }
        if ($artn_tecn_en != '') {
          $escaped_artn_tecn .= ($escaped_artn_tecn != '' ? '/' : '') . 'EN:' . $artn_tecn_en;
        }
        if ($artn_tecn_es != '') {
          $escaped_artn_tecn .= ($escaped_artn_tecn != '' ? '/' : '') . 'ES:' . $artn_tecn_es;
        }
        if ($artn_tecn_fr != '') {
          $escaped_artn_tecn .= ($escaped_artn_tecn != '' ? '/' : '') . 'FR:' . $artn_tecn_fr;
        }
        if ($artn_tecn_de != '') {
          $escaped_artn_tecn .= ($escaped_artn_tecn != '' ? '/' : '') . 'DE:' . $artn_tecn_de;
        }
        if ($escaped_artn_tecn != '') {
          $html_model1 .= '<a href="#" title="' . $escaped_artn_tecn . '" data-id="tecn-' . $article->cdartn . '"
            data-it="' . $artn_tecn_it . '" data-en="' . $artn_tecn_en . '" data-es="' . $artn_tecn_es . '"
            data-fr="' . $artn_tecn_fr . '" data-de="' . $artn_tecn_de . '">
              <span class="glyphicon glyphicon-bookmark" aria-hidden="true" style="margin:0 5px"></span>
            </a>';
        }

        $html_model1 .=
          '</td>
            <td style="text-align:center" class="articles-counter">';

        $html_model2 .=
          '</td>
            <td>' . $article->artn_img . '</td>
            <td style="text-align:center">
              <span>
                <a href="#" class="mod-artn" data-toggle="modal" data-target=".modal-edit-model"
                  data-cdcata="' . $cdcata . '" data-cdartn="' . $article->cdartn . '"
                  title="' . $this->translate("_common.edit") . '">
                  <span class="glyphicon glyphicon-edit" aria-hidden="true" style="margin-right:20px"></span>
                </a>
                <a href="#" class="del-artn" data-toggle="modal" data-target=".modal-model"
                  data-codice="' . $article->cdartn . '" data-cdcata="' . $cdcata . '"
                  title="' . $this->translate("_common.delete") . '">
                  <span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
                </a>
              </span>
            </td>
          </tr>';
      }

      $html_articles .=
        '<tr style="display:none;background-color:#e3e7eb" data-seqnum="pos' . $index . '" data-id="' . str_replace(".", "_", $article->cdarti) . '"
          class="' . str_replace(".", "_", $article->cdartn) . '
          BR-' . $article->cdtitl . ' LI-' . $article->cdlinm . ' SE-' . $article->cdserm . '
          AN-' . str_replace(".", "_", str_replace(' ', '', $article->cdartn)) . ' AR-' . str_replace(".", "_", str_replace(' ', '', $article->cdarti)) . '"
          data-cdtitl="' . $article->cdtitl . '" data-cdlinm="' . $article->cdlinm . '" data-cdserm="' . $article->cdserm . '"
          data-cdartn="' . str_replace(".", "_", str_replace(' ', '', $article->cdartn)) . '" data-cdarti="' . str_replace(".", "_", str_replace(' ', '', $article->cdarti)) . '">
          <td></td>
          <td>AR</td>
          <td></td>
          <td>' . $article->cdarti . '</td>
          <td>' . $article->dsarti . '</td>
          <td style="text-align:center">';
      $index++;

      $escaped_arti_comm = '';
      $arti_comm_it = rtrim(str_replace("'", "\'", $article["arti_comm_it"]));
      $arti_comm_en = rtrim(str_replace("'", "\'", $article["arti_comm_en"]));
      $arti_comm_es = rtrim(str_replace("'", "\'", $article["arti_comm_es"]));
      $arti_comm_fr = rtrim(str_replace("'", "\'", $article["arti_comm_fr"]));
      $arti_comm_de = rtrim(str_replace("'", "\'", $article["arti_comm_de"]));

      if ($arti_comm_it != '') {
        $escaped_arti_comm .= ($escaped_arti_comm != '' ? '/' : '') . 'IT:' . $arti_comm_it;
      }
      if ($arti_comm_en != '') {
        $escaped_arti_comm .= ($escaped_arti_comm != '' ? '/' : '') . 'EN:' . $arti_comm_en;
      }
      if ($arti_comm_es != '') {
        $escaped_arti_comm .= ($escaped_arti_comm != '' ? '/' : '') . 'ES:' . $arti_comm_es;
      }
      if ($arti_comm_fr != '') {
        $escaped_arti_comm .= ($escaped_arti_comm != '' ? '/' : '') . 'FR:' . $arti_comm_fr;
      }
      if ($arti_comm_de != '') {
        $escaped_arti_comm .= ($escaped_arti_comm != '' ? '/' : '') . 'DE:' . $arti_comm_de;
      }
      if ($escaped_arti_comm != '') {
        $html_articles .= '<a href="#" title="' . $escaped_arti_comm . '" data-id="comm-arti-' . $article->cdarti . '"
          data-it="' . $arti_comm_it . '" data-en="' . $arti_comm_en . '" data-es="' . $arti_comm_es . '"
          data-fr="' . $arti_comm_fr . '" data-de="' . $arti_comm_de . '">
            <span class="glyphicon glyphicon-bookmark" aria-hidden="true" style="margin:0 5px"></span>
          </a>';
      }

      $escaped_arti_tecn = '';
      $arti_tecn_it = rtrim(str_replace("'", "\'", $article["arti_tecn_it"]));
      $arti_tecn_en = rtrim(str_replace("'", "\'", $article["arti_tecn_en"]));
      $arti_tecn_es = rtrim(str_replace("'", "\'", $article["arti_tecn_es"]));
      $arti_tecn_fr = rtrim(str_replace("'", "\'", $article["arti_tecn_fr"]));
      $arti_tecn_de = rtrim(str_replace("'", "\'", $article["arti_tecn_de"]));

      if ($arti_tecn_it != '') {
        $escaped_arti_tecn .= ($escaped_arti_tecn != '' ? '/' : '') . 'IT:' . $arti_tecn_it;
      }
      if ($arti_tecn_en != '') {
        $escaped_arti_tecn .= ($escaped_arti_tecn != '' ? '/' : '') . 'EN:' . $arti_tecn_en;
      }
      if ($arti_tecn_es != '') {
        $escaped_arti_tecn .= ($escaped_arti_tecn != '' ? '/' : '') . 'ES:' . $arti_tecn_es;
      }
      if ($arti_tecn_fr != '') {
        $escaped_arti_tecn .= ($escaped_arti_tecn != '' ? '/' : '') . 'FR:' . $arti_tecn_fr;
      }
      if ($arti_tecn_de != '') {
        $escaped_arti_tecn .= ($escaped_arti_tecn != '' ? '/' : '') . 'DE:' . $arti_tecn_de;
      }
      if ($escaped_arti_tecn != '') {
        $html_articles .= '<a href="#" title="' . $escaped_arti_tecn . '" data-id="tecn-arti-' . $article->cdarti . '"
          data-it="' . $arti_tecn_it . '" data-en="' . $arti_tecn_en . '" data-es="' . $arti_tecn_es . '"
          data-fr="' . $arti_tecn_fr . '" data-de="' . $arti_tecn_de . '">
            <span class="glyphicon glyphicon-bookmark" aria-hidden="true" style="margin:0 5px"></span>
          </a>';
      }

      $html_articles .=
        '</td>
          <td></td>
          <td>' . $article->arti_img . '</td>
          <td style="text-align:center">
            <span data-toggle="modal" data-target=".modal-edit-article">
              <a href="#" class="mod-arti" data-cdarti="' . $article->cdarti . '"
                data-cdcata="' . $cdcata . '" title="' . $this->translate('_common.edit') . '">
                <span class="glyphicon glyphicon-edit" aria-hidden="true" style="margin-right:20px"></span>
              </a>
            </span>
            <span data-toggle="modal" data-target=".modal-article">
              <a href="#" class="del-arti" data-cdarti="' . $article->cdarti . '"
                data-cdcata="' . $cdcata . '" title="' . $this->translate('_common.delete') . '">
                <span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
              </a>
            </span>
          </td>
        </tr>';

      if ($i == count($articles) - 1) {
        $full_html .= $html_model1 . ($current_variations + 1) . $html_model2 . $html_articles;
        $html_model1 = '';
        $html_model2 = '';
        $html_articles = '';
        $current_variations = 0;
      }
      $current_variations++;
    }

    return $full_html;
  }

  function getCatalogModelsTableHtml($models, $cdcata) {
    $current_cdtitl = '';
    $current_cdlinm = '';
    $current_cdserm = '';
    $old_cdtitl = '';
    $old_cdlinm = '';
    $old_cdserm = '';
    $html_articles = '';
    $full_html = '';

    $index = 0;

    for ($i = 0; $i < count($models); $i++) {
      $model = $models[$i];

      if (
        $current_cdtitl != $model->cdtitl ||
        $current_cdlinm != $model->cdlinm ||
        $current_cdserm != $model->cdserm
      ) {

        $old_cdtitl = $current_cdtitl;
        $old_cdlinm = $current_cdlinm;
        $old_cdserm = $current_cdserm;

        if ($current_cdtitl != $model->cdtitl) {
          $current_cdtitl = $model->cdtitl;

          $full_html .=
            '<tr style="background-color:#d6d6d6;color:#333333;font-weight:bold"
              class="BR-' . $model->cdtitl . '">
              <td>BR</td>
              <td>' . $model->cdtitl . '</td>
              <td></td>
              <td>' . $model->dstitl . '</td>
              <td></td>
              <td></td>
              <td>' . $model->titl_img . '</td>
              <td style="text-align:center">
                <span>
                  <a href="#" class="mod-titl" data-toggle="modal" data-target=".modal-brand-edit"
                    data-codice="' . $model->cdtitl . '" data-cdcata="' . $cdcata . '"
                    title="' . $this->translate('_common.edit') . '">
                    <span class="glyphicon glyphicon-edit" aria-hidden="true" style="margin-right:20px"></span>
                  </a>
                  <a href="#" class="del-titl" data-toggle="modal" data-target=".modal-brand"
                    data-codice="' . $model->cdtitl . '" data-cdcata="' . $cdcata . '"
                    title="' . $this->translate('_common.delete') . '">
                    <span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
                  </a>
                </span>
              </td>
            </tr>';
        }

        if ($current_cdlinm != $model->cdlinm) {
          $current_cdlinm = $model->cdlinm;

          $full_html .=
            '<tr style="background-color:#e1e1e1;color:#333333;font-weight:bold"
              class="BR-' . $model->cdtitl . ' LI-' . $model->cdlinm . '"
              data-cdtitl="' . $model->cdtitl . '" data-cdlinm="' . $model->cdlinm . '">
              <td>LI</td>
              <td>&middot;&middot;&middot; ' . $model->cdlinm . '</td>
              <td></td>
              <td>' . $model->dslinm . '</td>
              <td></td>
              <td></td>
              <td>' . $model->linm_img . '</td>
              <td style="text-align:center">
                <span>
                  <a href="#" class="mod-linm" data-toggle="modal" data-target=".modal-line-edit" data-codice="' . $model->cdlinm . '"
                    data-cdcata="' . $cdcata . '" title="' . $this->translate('_common.edit') . '">
                    <span class="glyphicon glyphicon-edit" aria-hidden="true" style="margin-right:20px"></span>
                  </a>
                  <a href="#" class="del-linm" data-toggle="modal" data-target=".modal-line" data-codice="' . $model->cdlinm . '"
                    data-cdcata="' . $cdcata . '" title="' . $this->translate('_common.delete') . '">
                    <span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
                  </a>
                </span>
              </td>
            </tr>';
        }

        if ($old_cdlinm != $model->cdlinm || $current_cdserm != $model->cdserm) {
          $current_cdserm = $model->cdserm;

          $full_html .=
            '<tr style="background-color:#f1f1f1;color:#333333;font-weight:bold"
              class="BR-' . $model->cdtitl . ' LI-' . $model->cdlinm . ' SE-' . $model->cdserm . '"
              data-cdtitl="' . $model->cdtitl . '" data-cdlinm="' . $model->cdlinm . '"
              data-cdserm="' . $model->cdserm . '">
              <td>SE</td>
              <td>&middot;&middot;&middot;&middot;&middot;&middot; ' . $model->cdserm . '</td>
              <td></td>
              <td>' . $model->dsserm . '</td>
              <td></td>
              <td></td>
              <td>' . $model->serm_img . '</td>
              <td style="text-align:center">
                <span>
                  <a href="#" class="mod-serm" data-toggle="modal" data-target=".modal-series-edit"
                    data-codice="' . $model->cdserm . '" data-codic2="' . $model->cdlinm . '" data-cdcata="' . $cdcata . '"
                    title="' . $this->translate('_common.edit') . '">
                    <span class="glyphicon glyphicon-edit" aria-hidden="true" style="margin-right:20px"></span>
                  </a>
                  <a href="#" class="del-serm" data-toggle="modal" data-target=".modal-series"
                    data-codice="' . $model->cdserm . '" data-codic2="' . $model->cdlinm . '" data-cdcata="' . $cdcata . '"
                    title="' . $this->translate('_common.delete') . '">
                    <span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
                  </a>
                </span>
              </td>
            </tr>';
        }
      }

      $full_html .=
        '<tr style="background-color:white" id="pos' . $index . '" data-seqnum="pos' . $index . '" data-id="' . str_replace('.', '_', $model->cdartn) . '"
          class="model-row BR-' . $model->cdtitl . ' LI-' . $model->cdlinm . ' SE-' . $model->cdserm . ' AN-' . str_replace('.', '_', str_replace(' ', '', $model->cdartn)) . '"
          data-cdtitl="' . $model->cdtitl . '" data-cdlinm="' . $model->cdlinm . '"
          data-cdserm="' . $model->cdserm . '" data-cdartn="' . str_replace('.', '_', str_replace(' ', '', $model->cdartn)) . '">
          <td>MO</td>
          <td></td>
          <td>' . $model->cdartn . ' <a href="#' . $model->cdartn . '"></a></td>
          <td>' . $model->dsartn . '</td>
          <td style="text-align:center">';

      $index++;

      $escaped_artn_comm = '';
      $artn_comm_it = rtrim(str_replace("'", "\'", $model->artn_comm_it));
      $artn_comm_en = rtrim(str_replace("'", "\'", $model->artn_comm_en));
      $artn_comm_es = rtrim(str_replace("'", "\'", $model->artn_comm_es));
      $artn_comm_fr = rtrim(str_replace("'", "\'", $model->artn_comm_fr));
      $artn_comm_de = rtrim(str_replace("'", "\'", $model->artn_comm_de));
      if ($artn_comm_it != '') {
        $escaped_artn_comm .= ($escaped_artn_comm != '' ? '/' : '') . 'IT:' . $artn_comm_it;
      }
      if ($artn_comm_en != '') {
        $escaped_artn_comm .= ($escaped_artn_comm != '' ? '/' : '') . 'EN:' . $artn_comm_en;
      }
      if ($artn_comm_es != '') {
        $escaped_artn_comm .= ($escaped_artn_comm != '' ? '/' : '') . 'ES:' . $artn_comm_es;
      }
      if ($artn_comm_fr != '') {
        $escaped_artn_comm .= ($escaped_artn_comm != '' ? '/' : '') . 'FR:' . $artn_comm_fr;
      }
      if ($artn_comm_de != '') {
        $escaped_artn_comm .= ($escaped_artn_comm != '' ? '/' : '') . 'DE:' . $artn_comm_de;
      }
      if ($escaped_artn_comm != '') {
        $full_html .= '<a href="#" title="' . $escaped_artn_comm . '" data-id="comm-' . $model->cdartn . '"
          data-it="' . $artn_comm_it . '" data-en="' . $artn_comm_en . '" data-es="' . $artn_comm_es . '"
          data-fr="' . $artn_comm_fr . '" data-de="' . $artn_comm_de . '">
            <span class="glyphicon glyphicon-bookmark" aria-hidden="true" style="margin:0 5px"></span>
          </a>';
      }

      $escaped_artn_tecn = '';
      $artn_tecn_it = rtrim(str_replace("'", "\'", $model->artn_tecn_it));
      $artn_tecn_en = rtrim(str_replace("'", "\'", $model->artn_tecn_en));
      $artn_tecn_es = rtrim(str_replace("'", "\'", $model->artn_tecn_es));
      $artn_tecn_fr = rtrim(str_replace("'", "\'", $model->artn_tecn_fr));
      $artn_tecn_de = rtrim(str_replace("'", "\'", $model->artn_tecn_de));
      if ($artn_tecn_it != '') {
        $escaped_artn_tecn .= ($escaped_artn_tecn != '' ? '/' : '') . 'IT:' . $artn_tecn_it;
      }
      if ($artn_tecn_en != '') {
        $escaped_artn_tecn .= ($escaped_artn_tecn != '' ? '/' : '') . 'EN:' . $artn_tecn_en;
      }
      if ($artn_tecn_es != '') {
        $escaped_artn_tecn .= ($escaped_artn_tecn != '' ? '/' : '') . 'ES:' . $artn_tecn_es;
      }
      if ($artn_tecn_fr != '') {
        $escaped_artn_tecn .= ($escaped_artn_tecn != '' ? '/' : '') . 'FR:' . $artn_tecn_fr;
      }
      if ($artn_tecn_de != '') {
        $escaped_artn_tecn .= ($escaped_artn_tecn != '' ? '/' : '') . 'DE:' . $artn_tecn_de;
      }
      if ($escaped_artn_tecn != '') {
        $full_html .= '<a href="#" title="' . $escaped_artn_tecn . '" data-id="tecn-' . $model->cdartn . '"
          data-it="' . $artn_tecn_it . '" data-en="' . $artn_tecn_en . '" data-es="' . $artn_tecn_es . '"
          data-fr="' . $artn_tecn_fr . '" data-de="' . $artn_tecn_de . '">
            <span class="glyphicon glyphicon-bookmark" aria-hidden="true" style="margin:0 5px"></span>
          </a>';
      }

      $full_html .=
        '</td>
        <td style="text-align:center" class="articles-counter">' . $model->num_variations . '</td>
        <td>' . $model->artn_img . '</td>
        <td style="text-align:center">
          <span>
            <a href="#" class="mod-artn" data-toggle="modal" data-target=".modal-edit-model"
              data-cdcata="' . $cdcata . '" data-cdartn="' . $model->cdartn . '"
              title="' . $this->translate("_common.edit") . '">
              <span class="glyphicon glyphicon-edit" aria-hidden="true" style="margin-right:20px"></span>
            </a>
            <a href="#" class="del-artn" data-toggle="modal" data-target=".modal-model"
              data-codice="' . $model->cdartn . '" data-cdcata="' . $cdcata . '"
              title="' . $this->translate("_common.delete") . '">
              <span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
            </a>
          </span>
        </td>
      </tr>';
    }

    return $full_html;
  }

  function getCatalogModelDetailRowsHtml($models, $cdcata, $categoryId) {
    $full_html = '';
    for ($i = 0; $i < count($models); $i++) {
      $model = $models[$i];

      $full_html .=
        '<tr style="background-color:white"
          class="model-row ' . $categoryId . '-detail BR-' . $model->cdtitl . ' LI-' . $model->cdlinm . ' SE-' . $model->cdserm . ' AN-' . str_replace('.', '_', str_replace(' ', '', $model->cdartn)) . '"
          data-id="' . str_replace('.', '_', $model->cdartn) . '"
          data-cdtitl="' . $model->cdtitl . '" data-cdlinm="' . $model->cdlinm . '"
          data-cdserm="' . $model->cdserm . '" data-cdartn="' . str_replace('.', '_', str_replace(' ', '', $model->cdartn)) . '">
          <td>MO</td>
          <td></td>
          <td>' . $model->cdartn . ' <a href="#' . $model->cdartn . '"></a></td>
          <td>' . $model->dsartn . '</td>
          <td style="text-align:center">';

      $escaped_artn_comm = '';
      $artn_comm_it = rtrim(str_replace("'", "\'", $model->artn_comm_it));
      $artn_comm_en = rtrim(str_replace("'", "\'", $model->artn_comm_en));
      $artn_comm_es = rtrim(str_replace("'", "\'", $model->artn_comm_es));
      $artn_comm_fr = rtrim(str_replace("'", "\'", $model->artn_comm_fr));
      $artn_comm_de = rtrim(str_replace("'", "\'", $model->artn_comm_de));
      if ($artn_comm_it != '') {
        $escaped_artn_comm .= ($escaped_artn_comm != '' ? '/' : '') . 'IT:' . $artn_comm_it;
      }
      if ($artn_comm_en != '') {
        $escaped_artn_comm .= ($escaped_artn_comm != '' ? '/' : '') . 'EN:' . $artn_comm_en;
      }
      if ($artn_comm_es != '') {
        $escaped_artn_comm .= ($escaped_artn_comm != '' ? '/' : '') . 'ES:' . $artn_comm_es;
      }
      if ($artn_comm_fr != '') {
        $escaped_artn_comm .= ($escaped_artn_comm != '' ? '/' : '') . 'FR:' . $artn_comm_fr;
      }
      if ($artn_comm_de != '') {
        $escaped_artn_comm .= ($escaped_artn_comm != '' ? '/' : '') . 'DE:' . $artn_comm_de;
      }
      if ($escaped_artn_comm != '') {
        $full_html .= '<a href="#" title="' . $escaped_artn_comm . '" data-id="comm-' . $model->cdartn . '"
          data-it="' . $artn_comm_it . '" data-en="' . $artn_comm_en . '" data-es="' . $artn_comm_es . '"
          data-fr="' . $artn_comm_fr . '" data-de="' . $artn_comm_de . '">
            <span class="glyphicon glyphicon-bookmark" aria-hidden="true" style="margin:0 5px"></span>
          </a>';
      }

      $escaped_artn_tecn = '';
      $artn_tecn_it = rtrim(str_replace("'", "\'", $model->artn_tecn_it));
      $artn_tecn_en = rtrim(str_replace("'", "\'", $model->artn_tecn_en));
      $artn_tecn_es = rtrim(str_replace("'", "\'", $model->artn_tecn_es));
      $artn_tecn_fr = rtrim(str_replace("'", "\'", $model->artn_tecn_fr));
      $artn_tecn_de = rtrim(str_replace("'", "\'", $model->artn_tecn_de));
      if ($artn_tecn_it != '') {
        $escaped_artn_tecn .= ($escaped_artn_tecn != '' ? '/' : '') . 'IT:' . $artn_tecn_it;
      }
      if ($artn_tecn_en != '') {
        $escaped_artn_tecn .= ($escaped_artn_tecn != '' ? '/' : '') . 'EN:' . $artn_tecn_en;
      }
      if ($artn_tecn_es != '') {
        $escaped_artn_tecn .= ($escaped_artn_tecn != '' ? '/' : '') . 'ES:' . $artn_tecn_es;
      }
      if ($artn_tecn_fr != '') {
        $escaped_artn_tecn .= ($escaped_artn_tecn != '' ? '/' : '') . 'FR:' . $artn_tecn_fr;
      }
      if ($artn_tecn_de != '') {
        $escaped_artn_tecn .= ($escaped_artn_tecn != '' ? '/' : '') . 'DE:' . $artn_tecn_de;
      }
      if ($escaped_artn_tecn != '') {
        $full_html .= '<a href="#" title="' . $escaped_artn_tecn . '" data-id="tecn-' . $model->cdartn . '"
          data-it="' . $artn_tecn_it . '" data-en="' . $artn_tecn_en . '" data-es="' . $artn_tecn_es . '"
          data-fr="' . $artn_tecn_fr . '" data-de="' . $artn_tecn_de . '">
            <span class="glyphicon glyphicon-bookmark" aria-hidden="true" style="margin:0 5px"></span>
          </a>';
      }

      $full_html .=
        '</td>
        <td style="text-align:center" class="articles-counter">' . $model->num_variations . '</td>
        <td>' . $model->artn_img . '</td>
        <td style="text-align:center">
          <span>
            <a href="#" class="mod-artn" data-toggle="modal" data-target=".modal-edit-model"
              data-cdcata="' . $cdcata . '" data-cdartn="' . $model->cdartn . '"
              title="' . $this->translate("_common.edit") . '">
              <span class="glyphicon glyphicon-edit" aria-hidden="true" style="margin-right:20px"></span>
            </a>
            <a href="#" class="del-artn" data-toggle="modal" data-target=".modal-model"
              data-codice="' . $model->cdartn . '" data-cdcata="' . $cdcata . '"
              title="' . $this->translate("_common.delete") . '">
              <span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
            </a>
          </span>
        </td>
      </tr>';
    }

    return $full_html;
  }

  function getCatalogCategoriesTableHtml($categories, $cdcata) {
    $current_cdtitl = '';
    $current_cdlinm = '';
    $current_cdserm = '';
    $old_cdtitl = '';
    $old_cdlinm = '';
    $old_cdserm = '';
    $full_html = '';

    $index = 0;
    for ($i = 0; $i < count($categories); $i++) {
      $category = $categories[$i];

      if (
        $current_cdtitl != $category->cdtitl ||
        $current_cdlinm != $category->cdlinm ||
        $current_cdserm != $category->cdserm
      ) {

        $old_cdtitl = $current_cdtitl;
        $old_cdlinm = $current_cdlinm;
        $old_cdserm = $current_cdserm;

        if ($current_cdtitl != $category->cdtitl) {
          $current_cdtitl = $category->cdtitl;

          $full_html .=
            '<tr style="background-color:#d6d6d6;color:#333333;font-weight:bold"
              id="category-' . $index . '"
              class="BR-' . $category->cdtitl . '">
              <td>BR</td>
              <td>' . $category->cdtitl . '</td>
              <td></td>
              <td>' . $category->dstitl . '</td>
              <td></td>
              <td></td>
              <td>' . $category->titl_img . '</td>
              <td style="text-align:center">
                <span>
                  <a href="#" class="mod-titl" data-toggle="modal" data-target=".modal-brand-edit"
                    data-codice="' . $category->cdtitl . '" data-cdcata="' . $cdcata . '"
                    title="' . $this->translate('_common.edit') . '">
                    <span class="glyphicon glyphicon-edit" aria-hidden="true" style="margin-right:20px"></span>
                  </a>
                  <a href="#" class="del-titl" data-toggle="modal" data-target=".modal-brand"
                    data-codice="' . $category->cdtitl . '" data-cdcata="' . $cdcata . '"
                    title="' . $this->translate('_common.delete') . '">
                    <span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
                  </a>
                </span>
              </td>
            </tr>';
          $index++;
        }

        if ($current_cdlinm != $category->cdlinm) {
          $current_cdlinm = $category->cdlinm;

          $full_html .=
            '<tr style="background-color:#e1e1e1;color:#333333;font-weight:bold"
              id="category-' . $index . '"
              class="BR-' . $category->cdtitl . ' LI-' . $category->cdlinm . '"
              data-cdtitl="' . $category->cdtitl . '" data-cdlinm="' . $category->cdlinm . '">
              <td>LI ' . ($category->cdserm == '' ? '<i class="fa fa-plus category-opener"></i>' : '') . '</td>
              <td>&middot;&middot;&middot; ' . $category->cdlinm . '</td>
              <td></td>
              <td>' . $category->dslinm . '</td>
              <td></td>
              <td></td>
              <td>' . $category->linm_img . '</td>
              <td style="text-align:center">
                <span>
                  <a href="#" class="mod-linm" data-toggle="modal" data-target=".modal-line-edit" data-codice="' . $category->cdlinm . '"
                    data-cdcata="' . $cdcata . '" title="' . $this->translate('_common.edit') . '">
                    <span class="glyphicon glyphicon-edit" aria-hidden="true" style="margin-right:20px"></span>
                  </a>
                  <a href="#" class="del-linm" data-toggle="modal" data-target=".modal-line" data-codice="' . $category->cdlinm . '"
                    data-cdcata="' . $cdcata . '" title="' . $this->translate('_common.delete') . '">
                    <span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
                  </a>
                </span>
              </td>
            </tr>';
          $index++;
        }

        if ($category->cdserm != '' && ($old_cdlinm != $category->cdlinm || $current_cdserm != $category->cdserm)) {
          $current_cdserm = $category->cdserm;

          $full_html .=
            '<tr style="background-color:#f1f1f1;color:#333333;font-weight:bold"
              id="category-' . $index . '"
              class="BR-' . $category->cdtitl . ' LI-' . $category->cdlinm . ' SE-' . $category->cdserm . '"
              data-cdtitl="' . $category->cdtitl . '" data-cdlinm="' . $category->cdlinm . '"
              data-cdserm="' . $category->cdserm . '">
              <td>SE <i class="fa fa-plus category-opener"></i></td>
              <td>&middot;&middot;&middot;&middot;&middot;&middot; ' . $category->cdserm . '</td>
              <td></td>
              <td>' . $category->dsserm . '</td>
              <td></td>
              <td></td>
              <td>' . $category->serm_img . '</td>
              <td style="text-align:center">
                <span>
                  <a href="#" class="mod-serm" data-toggle="modal" data-target=".modal-series-edit"
                    data-codice="' . $category->cdserm . '" data-codic2="' . $category->cdlinm . '" data-cdcata="' . $cdcata . '"
                    title="' . $this->translate('_common.edit') . '">
                    <span class="glyphicon glyphicon-edit" aria-hidden="true" style="margin-right:20px"></span>
                  </a>
                  <a href="#" class="del-serm" data-toggle="modal" data-target=".modal-series"
                    data-codice="' . $category->cdserm . '" data-codic2="' . $category->cdlinm . '" data-cdcata="' . $cdcata . '"
                    title="' . $this->translate('_common.delete') . '">
                    <span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
                  </a>
                </span>
              </td>
            </tr>';
          $index++;
        }
      }
    }

    return $full_html;
  }

  function getCatalogSortingHtml($models) {
    $html = '';

    if (count($models) > 0) {
      $currentCdtitl = $models[0]->cdtitl;
      $currentCdlinm = $models[0]->cdlinm;
      $currentCdserm = $models[0]->cdserm;

      $html = '<div class="x_panel">';

      $html .= '<div class="x_title">';
      $html .= '<h2>' . $models[0]->dstitl . ' / ' . $models[0]->dslinm . (!empty($models[0]->cdserm) ? ' / ' . $models[0]->dsserm : '') . '</h2>';
      $html .= '<div class="clearfix"></div>';
      $html .= '</div>';

      $html .= '<div class="x_content">';
      $html .= '<div class="row">';

      foreach ($models as $model) {
        if ($model->cdtitl != $currentCdtitl || $model->cdlinm != $currentCdlinm || $model->cdserm != $currentCdserm) {
          $currentCdtitl = $model->cdtitl;
          $currentCdlinm = $model->cdlinm;
          $currentCdserm = $model->cdserm;

          $html .= '</div><!-- /row -->';
          $html .= '</div><!-- /x_content -->';
          $html .= '</div><!-- /x_panel -->';
          $html .= '<div class="x_panel">';

          $html .= '<div class="x_title">';
          $html .= '<h2>' . $model->dstitl . ' / ' . $model->dslinm . (!empty($model->cdserm) ? ' / ' . $model->dsserm : '') . '</h2>';
          $html .= '<div class="clearfix"></div>';
          $html .= '</div>';

          $html .= '<div class="x_content">';
          $html .= '<div class="row">';
        }

        $html .= '<div class="col-md-4 sorting-box card draggable-card" draggable="true" ';
        $html .= 'data-cdartn="' . $model->cdartn . '" data-dstmod="' . $model->dstmod . ' "';
        $html .= 'data-category="' . $model->dstitl . ' - '. $model->dslinm . (!empty($model->dsserm) ? ' - ' . $model->dsserm : '') . '"';
        $html .= 'data-seqrap="' . $model->seqrap . '" data-seqra2="' . $model->seqra2 . '">';
        $html .= '<div class="inner-container">';
        $html .= $this->elements->getModelImgOrDefaultHtmL($model->flimag, $model->dsartn, ['style' => 'width:100%']);
        $html .= '<div style="font-weight:bold">' . $model->cdartn . '</div>';
        $html .= '</div>';
        $html .= '</div>';
      }

      $html .= '</div><!-- /row -->';
      $html .= '</div><!-- /x_content -->';
      $html .= '</div><!-- /x_panel -->';
    }

    return $html;
  }
  //endregion

  //region Html functions: Lookbook manager
  function getLookbookPageHtml($index, $lookType) {
    $index++;
    $html =
      '<li class="ui-state-default look-box" id="">
        <div class="row horizontal-block">' .
      $this->getLayoutSelectorHtml(true) .
      $this->getHorizontalBlockDetailHtml(false, $index++, $lookType) .
      $this->getVerticalBlockDetailHtml(true, $index++, $lookType) .
      '</div>
      </li>';

    return $html;
  }

  function getLayoutSelectorHtml($isHorizontal) {
    return
      '<div class="col-md-2" style="height:230px;border-right:1px solid #D6D6D6">
        <div class="row">
          <div class="col-md-2"><span class="fa fa-arrows-v" style="margin-left:5px;margin-top:5px;font-size:20px"></span></div>
          <div class="col-md-10">
            <h4 style="margin-top:0">' . $this->translate('admin.lookbook.pagelayout') . '</h4>
            <div style="float:left;clear:both;width:100%">
              <select class="select2_single form-control look-layout" tabindex="-1">
                <option value="horizontal" ' . ($isHorizontal ? 'selected' : '') . '>' . $this->translate('admin.lookbook.horizontal') . '</option>
                <option value="vertical" ' . ($isHorizontal ? '' : 'selected') . '>' . $this->translate('admin.lookbook.vertical') . '</option>
              </select>
            </div>
          </div>
        </div>
        <div class="row" style="margin-left:2px;margin-top:125px">
          <a href="#" class="remove-page">
            <span class="fa fa-close" style="font-size:20px"></span>
            <span style="vertical-align:text-bottom">' . $this->translate('admin.lookbook.removepage') . '</span>
          </a>
        </div>
      </div>';
  }

  function getHorizontalBlockDetailHtml($isHidden, $index, $lookType, $look = null) {
    return
      '<div class="col-md-10 horizontal-block-detail" ' . ($isHidden ? 'style="display:none"' : '') . '>
        <div class="row">
          <div class="col-md-3">' . $this->getDropzoneHtml($look != '' ? $look->lkimag : '') . '</div>
          <div class="col-md-9">
            <div class="row">' . $this->getDescriptionBlockHtml($look != '' ? $look->dslook : '') . '</div>
            <div class="row" style="padding-top:50px">' . $this->getItemsBlockHtml($lookType, $look != null ? count($look->items) : '') . '</div>
            <div class="row" style="padding-top:15px">' . $this->getAddRemoveButtonHtml($index, $lookType, $look) . '</div>
          </div>
        </div>
      </div>';
  }

  function getVerticalBlockDetailLookHtml($isFirst, $index, $lookType, $look = null) {
    return
      '<div class="col-md-6 ' . ($isFirst ? 'first' : 'second') . '-vertical-look" style="height:230px;border-right:1px solid #D6D6D6">
        <div class="row">
          <div class="col-md-5">' . $this->getDropzoneHtml($look != '' ? $look->lkimag : '') . '</div>
          <div class="col-md-7">
            <div class="row">' . $this->getDescriptionBlockHtml($look != '' ? $look->dslook : '') . '</div>
            <div class="row" style="padding-top:50px">' . $this->getItemsBlockHtml($lookType, $look != null ? count($look->items) : '') . '</div>
            <div class="row" style="padding-top:15px">' . $this->getAddRemoveButtonHtml($index, $lookType, $look) . '</div>
          </div>
        </div>
      </div>';
  }

  function getVerticalBlockDetailHtml($isHidden, $index, $lookType, $look = null) {
    $html =
      '<div class="col-md-10 vertical-block-detail" ' . ($isHidden ? 'style="display:none"' : '') . '>
        <div class="row">' .
      $this->getVerticalBlockDetailLookHtml(true, $index, $lookType, $look);
    $index++;

    $html .=
      $this->getVerticalBlockDetailLookHtml(false, $index, $lookType, $look) .
      '</div>
      </div>';

    return $html;
  }

  function getDropzoneHtml($lkimag = '') {
    $html =
      '<h4 style="margin-top:0">' . $this->translate('_common.images') . '</h4>
      <div style="float:left;clear:both" data-images="';

    if ($lkimag != '' && count($lkimag) > 0) {
      foreach ($lkimag as $img) {
        $html .= $img->filimg . ";";
      }
    }

    $html .= '">
        <form action="' . $this->url->get('admin/uploadImage') . '" class="dropzone look-images" style="height:200px!important;min-height:200px!important"></form>
      </div>';

    return $html;
  }

  function getDescriptionBlockHtml($description) {
    return
      '<div class="col-md-12">
        <h4 style="margin-top:0">' . $this->translate('_common.description') . '</h4>
        <div style="width:90%"><input type="text" class="form-control look-description" value="' . $description . '"></div>
      </div>';
  }

  function getItemsBlockHtml($lookType, $count) {
    return
      '<div class="col-md-12">
        <h4 style="margin-top:0">' . ($lookType == 0 ? $this->translate('_common.models') : $this->translate('_common.articles')) . '</h4>
        <div class="num-look-items">' . $count . '</div>
      </div>';
  }

  function getAddRemoveButtonHtml($index, $lookType, $look = null) {
    $dataItems  = '';
    if ($look != null && count($look->items) > 0) {
      foreach ($look->items as $item) {
        $dataItems .=
          ($lookType != 2
            ? 'code=' . $item->code . '&'
            : 'code=' . $item->code . ',' . $item->cdpers . ',' . $item->cdcolo . '&') .
          ($lookType == 0
            ? 'img=' . ''
            : 'img=' . $item->image . ';');
      }
    }

    $html =
      '<div class="look-container" data-items="' . $dataItems . '" data-index="' . $index . '">
        <div class="col-md-12">
          <button type="button" class="btn btn-default btn-left addremove-items fl">' .
      ($lookType == 0 ? $this->translate('admin.lookbook.addremovemodels') : $this->translate('admin.lookbook.addremovearticles')) .
      '</button>
          <div class="loader fl" style="display:none"><img src="' . $this->config->application->baseUri . 'assets/img/loading.gif" alt="Preloader" style="height:30px;width:30px"/></div>
        </div>';

    if ($lookType > 0) {
      $html .=
        '<div class="col-md-12">
          <button type="button" class="btn btn-default btn-left assign-images fl">' .
        $this->translate('admin.lookbook.assignimages') .
        '</button>
          <div class="loader fl" style="display:none"><img src="' . $this->config->application->baseUri . 'assets/img/loading.gif" alt="Preloader" style="height:30px;width:30px"/></div>
        </div>';
    }
    $html .= '</div>';

    return $html;
  }

  function getLooksHtml($looks, $lookType) {
    $html = '';

    $needSecondVertical = false;
    $currentIsVertical  = false;
    $index = 0;

    for ($i = 0; $i < count($looks); $i++) {
      $look = $looks[$i];
      $currentIsVertical = count($look->lkimag) == 0 || $look->lkimag[0]->size[0] <= $look->lkimag[0]->size[1];
      if (!$needSecondVertical && !$currentIsVertical) {
        // Horizontal look
        $html .=
          '<li class="ui-state-default look-box" id="' . $look->cdlook . '">
            <div class="row horizontal-block">' .
          $this->getLayoutSelectorHtml(true) .
          $this->getHorizontalBlockDetailHtml(false, $index++, $lookType, $look) .
          $this->getVerticalBlockDetailHtml(true, $index++, $lookType) .
          '</div>
          </li>';
      } else if (!$needSecondVertical && $currentIsVertical) {
        // First vertical look
        $needSecondVertical = true;

        $html .=
          '<li class="ui-state-default look-box" id="' . $look->cdlook . '">
            <div class="row vertical-block">' .
          $this->getLayoutSelectorHtml(false) .
          '<!-- block detail -->
              <div class="col-md-10 vertical-block-detail">
                <div class="row">
                  <!-- first vertical look -->' .
          $this->getVerticalBlockDetailLookHtml(true, $index++, $lookType, $look) .
          '<!-- /first vertical look -->';

        // If this one is the last look
        if ($i == count($looks) - 1) {
          $html .=
            '<!-- second vertical look (empty) -->' .
            $this->getVerticalBlockDetailLookHtml(false, $index++, $lookType) .
            '<!-- /second vertical look (empty) -->
                </div>
              </div>
              <!-- /block detail -->
              <!-- block detail -->' .
            $this->getHorizontalBlockDetailHtml(true, $index++, $lookType) .
            '<!-- /block detail -->
            </div>
            <!-- /vertical block -->
          </li>';
        }
      } else if ($needSecondVertical && !$currentIsVertical) {
        // We have an horizontal look after a single vertical look
        $needSecondVertical = false;

        // Fill with an empty second vertical look and an empty horizontal look, then close li
        $html .=
          '<!-- second vertical look (empty) -->' .
          $this->getVerticalBlockDetailLookHtml(false, $index++, $lookType) .
          '<!-- /second vertical look (empty) -->
              </div>
            </div>
            <!-- /block detail -->
            <!-- block detail -->' .
          $this->getHorizontalBlockDetailHtml(true, $index++, $lookType) .
          '<!-- /block detail -->
          </div>
          <!-- /vertical block -->
        </li>
        <li class="ui-state-default look-box" id="' . $look->cdlook . '">
          <!-- horizontal block -->
          <div class="row horizontal-block">' .
          $this->getLayoutSelectorHtml(true) .
          $this->getHorizontalBlockDetailHtml(false, $index++, $lookType, $look) .
          $this->getVerticalBlockDetailHtml(true, $index++, $lookType) .
          '</div>
          <!-- /horizontal block -->
        </li>';
      } else if ($needSecondVertical && $currentIsVertical) {
        // This one is the last vertical look of the row
        $needSecondVertical = false;

        $html .=
          '<!-- second vertical look -->' .
          $this->getVerticalBlockDetailLookHtml(false, $index++, $lookType, $look) .
          '<!-- /second vertical look -->
              </div>
            </div>
            <!-- /block detail -->
            <!-- block detail -->' .
          $this->getHorizontalBlockDetailHtml(true, $index++, $lookType) .
          '<!-- /block detail -->
          </div>
          <!-- /vertical block -->
        </li>';
      }
    }

    return $html;
  }
  //endregion

  //region Html functions: Availability manager
  private function getArticlesAvailabilityHtml($articles) {
    $html = '';

    if (count($articles) > 0) {
      $maxColumns = 0;
      foreach ($articles as $article) {
        $currentColumns = count($article->sizes) + count($article->asso);
        if ($currentColumns > $maxColumns) {
          $maxColumns = $currentColumns;
        }
      }

      $width = $maxColumns > 0 ? 100 / $maxColumns : 0;

      foreach ($articles as $article) {
        $html .= '<tr>';
        $html .= '<td style="width:21%">' . $article->cdarti . '</td>';
        $html .= '<td style="width:21%">' . $article->dsarti . '</td>';
        $html .= '<td style="width:50%;padding:0!important;">';

        for ($i = 0; $i < count($article->sizes); $i++) {
          $size = $article->sizes[$i];

          $html .= '<div class="fl center" style="width:' . $width . '%;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;';
          if (count($article->asso) > 0 || ($i != count($article->sizes) - 1 || (count($article->sizes) + count($article->asso) < $maxColumns))) {
            $html .= ';border-right:1px solid #ddd';
          }
          $html .= '" title="' . $size->taglia . '">';
          $html .= '<span style="font-weight:bold">' . $size->taglia . '</span><br/>';
          $html .= '<span>' . ($size->quanti > 0 ? $size->quanti : 0) . '</span>';
          $html .= '</div>';
        }

        for ($i = 0; $i < count($article->asso); $i++) {
          $asso = $article->asso[$i];

          $html .= '<div class="fl center" style="width:' . $width . '%;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;';
          if ($i != count($article->asso) - 1 || (count($article->sizes) + count($article->asso) < $maxColumns)) {
            $html .= ';border-right:1px solid #ddd';
          }
          $html .= '" title="' . $asso->cdasso . '">';
          $html .= '<span style="font-weight:bold">' . $asso->cdasso . '</span><br/>';
          $html .= '<span>' . ($asso->quanti > 0 ? $asso->quanti : 0) . '</span>';
          $html .= '</div>';
        }

        // Fill empty spaces
        if (count($article->sizes) + count($article->asso) < $maxColumns) {
          $remainingColumns = $maxColumns - count($article->sizes) - count($article->asso);
          for ($i = 0; $i < $remainingColumns; $i++) {
            $html .= '<div class="fl center" style="width:' . $width . '%;';
            if ($i != $remainingColumns - 1) {
              $html .= ';border-right:1px solid #ddd';
            }
            $html .= '">';
            $html .= '<span>&nbsp;</span><br/>';
            $html .= '<span>&nbsp;</span><br/>';
            $html .= '</div>';
          }
        }

        $html .= '</td>';

        $html .= '<td class="center">';
        $html .= '<span>';
        $html .= '<a href="#" title="' . $this->translate('_common.edit') . '" class="edit" ';
        $html .= 'data-toggle="modal" data-target="#modal-edit" data-cdarti="' . $article->cdarti . '">';
        $html .= '<span class="glyphicon glyphicon-edit mr-20x" aria-hidden="true"></span>';
        $html .= '</a>';
        $html .= '<a href="#" title="' . $this->translate('_common.delete') . '" class="delete" ';
        $html .= 'data-toggle="modal" data-target="#modal-delete" data-cdarti="' . $article->cdarti . '">';
        $html .= '<span class="glyphicon glyphicon-remove" aria-hidden="true"></span>';
        $html .= '</a>';
        $html .= '</span>';
        $html .= '</td>';

        $html .= '</tr>';
      }
    }

    return $html;
  }
  //endregion

  //region Aux functions: Catalog manager
  function getAllUploadImages($onlyVertical = false, $where = '') {
    if (!file_exists('./upload')) {
      mkdir('./upload', 0777, true);
    }
    $files = scandir('./upload/');

    array_splice($files, 0, 2);

    $images = [];
    foreach ($files as $file) {
      if ((substr($file, -3, 3) == 'jpg') || (substr($file, -3, 3) == 'JPG')) {
        if ($onlyVertical) {
          list($width, $height) = getimagesize('./upload/' . $file);
          if ($height / $width > 1.1) {
            $images[] = array(
              'path'  => 'upload/',
              'file'  => $file
            );
          }
        } else {
          $images[] = array(
            'path'  => 'upload/',
            'file'  => $file
          );
        }
      }
    }

    if (!file_exists('./img/' . $where)) {
      mkdir('./img/' . $where, 0777, true);
    }
    $files = scandir('./img/' . $where . '/');

    array_splice($files, 0, 2);

    foreach ($files as $file) {
      if ((substr($file, -3, 3) == 'jpg') || (substr($file, -3, 3) == 'JPG')) {
        if ($onlyVertical) {
          list($width, $height) = getimagesize('./img/' . $where . '/' . $file);
          if ($height / $width > 1.1) {
            $images[] = array(
              'path'  => 'img/' . $where . '/',
              'file'  => $file
            );
          }
        } else {
          $images[] = array(
            'path'  => 'img/' . $where . '/',
            'file'  => $file
          );
        }
      }
    }

    return $images;
  }
  //endregion
}
