<?php

namespace Go2B\Controllers;

use Go2B\Models\Anaart;
use Go2B\Models\Anaper;
use Go2B\Models\Artcol;
use Go2B\Models\B2bApputi;
use Go2B\Models\B2bSysusr;
use Go2B\Models\Ctarti;
use Go2B\Models\Imgart;
use Go2B\Models\Tipolo;
use Phalcon\Http\Request;

class AdminBase extends ControllerBase
{
    protected $isSuperadmin = false;

    //region Initialize
    public function initialize()
    {
        $this->isSuperadmin = $this->session->get('auth')['type'] == 1;
        $this->tag->setTitle('Admin');
        parent::initialize();
    }
    //endregion

    public function getIsSuperAdmin()
    {
        return $this->isSuperadmin;
    }

    //region Ajax functions: Sync
    public function syncAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $tipoSync = null;
            if(! empty($request->getPost('sync'))){
                $tipoSync = $request->getPost('sync');
            }
            $this->utility->manualSync($tipoSync);
            echo json_encode("OK");
        }
    }
    //endregion

    //region Upload functions
    public function uploadLogoAction()
    {
        $this->view->disable();

        if (!empty($_FILES)) {
            $tempFile   = $_FILES['file']['tmp_name']; //3
            $targetPath = "./img/"; //4
            if (!is_dir($targetPath) && !mkdir($targetPath, 0777, true)) {
                die("Error creating folder $targetPath");
            }
            $targetFile = $targetPath . $_FILES['file']['name']; //5

            move_uploaded_file($tempFile, $targetFile); //6
        }
    }

    public function uploadFileAction()
    {
        $this->view->disable();

        if (!empty($_FILES)) {
            $tempFile   = $_FILES['file']['tmp_name']; //3
            $targetPath = "./upload/media/"; //4
            if (!is_dir($targetPath) && !mkdir($targetPath, 0777, true)) {
                die("Error creating folder $targetPath");
            }
            $targetFile = $targetPath . $_FILES['file']['name']; //5

            move_uploaded_file($tempFile, $targetFile); //6
            //chmod($targetFile,0755);
        }

        return $this->response->redirect('admin/media?s=1');
    }

    public function uploadColorImageAction()
    {
        $this->view->disable();

        if (!empty($_FILES)) {
            $tempFile   = $_FILES['file']['tmp_name']; //3
            $targetPath = "./upload/colors/"; //4
            if (!is_dir($targetPath) && !mkdir($targetPath, 0777, true)) {
                die("Error creating folder $targetPath");
            }
            $targetFile = $targetPath . $_FILES['file']['name']; //5

            move_uploaded_file($tempFile, $targetFile); //6
            //chmod($targetFile,0755);
        }

        echo json_encode('OK');
    }

    public function uploadVariantImageAction()
    {
        $this->view->disable();

        if (!empty($_FILES)) {
            $tempFile   = $_FILES['file']['tmp_name']; //3
            $targetPath = "./upload/variants/"; //4
            if (!is_dir($targetPath) && !mkdir($targetPath, 0777, true)) {
                die("Error creating folder $targetPath");
            }
            $targetFile = $targetPath . $_FILES['file']['name']; //5

            move_uploaded_file($tempFile, $targetFile); //6
            //chmod($targetFile,0755);
        }

        echo json_encode('OK');
    }

    public function uploadImageAction()
    {
        $this->view->disable();

        $where = $this->dispatcher->getParam('where');

        if (!empty($_FILES)) {
            $tempFile   = $_FILES['file']['tmp_name']; //3
            $targetPath = './upload/' . ($where != '' ? $where . '/' : ''); //4
            if (!is_dir($targetPath) && !mkdir($targetPath, 0777, true)) {
                die("Error creating folder $targetPath");
            }
            $targetFile = $targetPath . $_FILES['file']['name']; //5

            // If it is video, create thumbnail preview
            if (substr($targetFile, -3) == 'mp4') {
                $rootDir = realpath($_SERVER["DOCUMENT_ROOT"]);
                $movie   = $rootDir . $this->config->application->baseUri . '/public/upload/' . $_FILES['file']['name'];

                if ($this->config->release->user != "root") {
                    $this->diskManager->createPreviewImageForVideoOnLinux($movie);
                } else {
                    $this->diskManager->createPreviewImageForVideoOnWindows($movie);
                }
            }

            move_uploaded_file($tempFile, $targetFile); //6
        }
    }

    public function uploadImageBrandAction()
    {
        $this->view->disable();

        $where = $this->dispatcher->getParam('where');

        if (!empty($_FILES)) {
            $tempFile   = $_FILES['file']['tmp_name']; //3
            $targetPath = './upload/' . ($where != '' ? $where . '/' : ''); //4
            if (!is_dir($targetPath) && !mkdir($targetPath, 0777, true)) {
                die("Error creating folder $targetPath");
            }
            $targetFile = $targetPath . $_FILES['file']['name']; //5

            // If it is video, create thumbnail preview
            if (substr($targetFile, -3) == 'mp4') {
                $rootDir = realpath($_SERVER["DOCUMENT_ROOT"]);
                $movie   = $rootDir . $this->config->application->baseUri . '/public/upload/' . $_FILES['file']['name'];

                if ($this->config->release->user != "root") {
                    $this->diskManager->createPreviewImageForVideoOnLinux($movie);
                } else {
                    $this->diskManager->createPreviewImageForVideoOnWindows($movie);
                }
            }

            move_uploaded_file($tempFile, $targetFile); //6
        }
    }

    //endregion

    //region Automatic image assignment
    public function assignImagesSpecial($cdcata, $syncType, $isReassign, $catalogsString = '', $i = 0, $output = false)
    {
        try {
            //      for ($i = 0; $i <= 6; $i++) {
            $currentStepIndex = $i + 1;
            $syncType = $this->utility->getAppSettings('SyncType');
            $elements         = Imgart::getAllImagesToFindAndSync($cdcata, $syncType == 1, $isReassign, $i, $syncType);

            $totElements = count($elements);
            if ($totElements > 0) {
                $j = 0;
                foreach ($elements as $element) {
                    $currentElementIndex = $j + 1;

                    if ($output) {
                        $message = 'Step: ' . $currentStepIndex . '/7 - ' . $catalogsString . ' - ' . $this->translate('_common.image') . ': ' . $currentElementIndex . '/' . $totElements;
                        echo $message . "\n";
                        ob_flush();
                        flush();
                    }

                    $j++;
                    $model = '\Go2B\Models\\' . ucfirst($element['tablen']);

                    $imageFile = false;

                    foreach ([$element['flima1'], $element['flima2'], $element['flima3']] as $image) {
                        if (!$imageFile && $image != '') {
//                            $this->logger->debug("CERCO IMG: " . $image);
                            $glob = glob('../public/img/model/' . $image);
                            if ($glob && count($glob) > 0 && file_exists($glob[0])) {
//                                $this->logger->debug("IMG TROVATA: " . $glob[0]);
                                $imageFile = str_replace('../public/img/model/', '', $glob[0]);
                                break;
                            }
//                            $this->logger->debug("IMG NON TROVATA: " . $glob[0]);
                        }
                    }

                    if ($imageFile) {
                        if (file_exists('../public/img/temp/resize/model/' . $imageFile)) {
                            unlink('../public/img/temp/resize/model/' . $imageFile);
                        }
                        if ($element['keyna3'] != '') {
                            $model::updateImage($element['keynam'], $element['keyna2'], $imageFile, $element['keyna3']);
                        } else {
                            $model::updateImage($element['keynam'], $element['keyna2'], $imageFile);
                        }
                    }
                }

                $elements = null;
            }
            //  }
        } catch (\Exception $ex) {
            $this->logger->error($ex->getMessage());
        }
    }

    public function assignImageModelCtarti($cdartn)
    {
        $tmp = $cdartn;

        $imgneu_underl = false;
        if ($imgneu_underl) {
            $tmp = trim($tmp);
            $tmp .= '_';
        }

        $tmp = $this->normalizeSearchCode($tmp);

        $file = $this->searchFirstFile($tmp);
        if ($file) {
            Tipolo::updateModelImage($cdartn, $file);
            return $file;
        }

        return '';
    }

    public function assignImageModAggCtarti($cdartn, $reassign)
    {
        $locmod = $this->normalizeSearchCode($cdartn);

        $imgmod_maxnum = 6;
        $ret           = array();
        for ($i = 2; $i < $imgmod_maxnum; $i++) {
            $tpimag = 'MOD' . $i;

            // 1: tpimag codic1 codic2 seqrap flimag
            $imgart = Imgart::find(array('tpimag = :tpimag: AND codic1 = :cdartn:', 'bind' => array('tpimag' => $tpimag, 'cdartn' => $cdartn)));
            if (count($imgart) > 0) {
                if (!$reassign) {
                    continue;
                } else {
                    $imgart->delete();
                }
            }

            $possiblePaths = array(
                //'./upload/',
                './img/model/',
            );
            $possibleSuffixes = array(
                '.jpg',
                '.JPG',
            );

            foreach ($possiblePaths as $path) {
                foreach ($possibleSuffixes as $suffix) {
                    $tmp      = $locmod . '_' . $tpimag . $suffix;
                    $fullPath = $path . $tmp;

                    if (file_exists($fullPath)) {
                        Imgart::saveImageFromAutoProcess($tpimag, $cdartn, $tmp);
                        $ret[] = array('tpimag' => $tpimag, 'filimg' => $tmp);
                        break;
                    }
                }
            }
        }

        return $ret;
    }

    public function assignImageModArtCtarti($cdartn, $cdcata, $reassign)
    {
        // 1) cdarti 2) cdlinm 3) cdcolo 4) flimag 5) dscolo
        $articles = Ctarti::getAllArticlesFromCatalogAndModel($cdcata, $cdartn);

        $ret = [];
        if (count($articles) > 0) {
            foreach ($articles as $ctarti) {
                $cdarti = $ctarti->cdarti;
                $filimg = $ctarti->flimag;

                $cdpers = Anaart::getCdpersFromCdarti($cdarti);

                // anaper
                if ($cdpers != '') {
                    $this->assignImageAnaper($cdpers, $reassign);
                }

                // artcol
                $this->assignImageArtcol($cdarti, $reassign);

                if ($filimg != '') {
                    if (!$reassign && $filimg != '&nbsp;') {
                        continue;
                    } else {
                        Anaart::updateArticleImage($cdarti, '');
                    }
                }

                // 1 - cdarti
                $codric = $this->normalizeSearchCode($cdarti);
                if ($file = $this->searchFirstFile($codric)) {
                    Anaart::updateArticleImage($cdarti, $file);
                    $ret[] = array('cdarti' => $cdarti, 'filimg' => $file);
                    continue;
                }

                // 2 - cdlinm.cdcolo
                $codric = $this->normalizeSearchCode($ctarti->cdlinm . '.' . $ctarti->cdcolo);
                if ($file = $this->searchFirstFile($codric)) {
                    Anaart::updateArticleImage($cdarti, $file);
                    $ret[] = array('cdarti' => $cdarti, 'filimg' => $file);
                    continue;
                }

                // 3 - cdcolo
                $codric = $this->normalizeSearchCode($ctarti->cdcolo);
                if ($file = $this->searchFirstFile($codric)) {
                    Anaart::updateArticleImage($cdarti, $file);
                    $ret[] = array('cdarti' => $cdarti, 'filimg' => $file);
                    continue;
                }

                // 4 - cdartn_dscolo
                $codric = $this->normalizeSearchCode($cdartn . '_' . $ctarti->dscolo);
                if ($file = $this->searchFirstFile($codric)) {
                    Anaart::updateArticleImage($cdarti, $file);
                    $ret[] = array('cdarti' => $cdarti, 'filimg' => $file);
                    continue;
                }

                $modelImage = Tipolo::getModelImage($cdartn);
                if ($modelImage != '') {
                    Anaart::updateArticleImage($cdarti, $modelImage);
                    $ret[] = array('cdarti' => $cdarti, 'filimg' => $modelImage);
                }
            }
        }

        return $ret;
    }

    private function assignImageAnaper($cdpers, $reassign)
    {
        $flimag = Anaper::getFabricImage($cdpers);
        if ($reassign || ($flimag == '' || $flimag == '&nbsp;')) {
            $codric = $this->normalizeSearchCode($cdpers);
            if ($file = $this->searchFirstFile($codric)) {
                Anaper::updateFabricImage($cdpers, $file);
            }
        }
    }

    private function assignImageArtcol($cdarti, $reassign)
    {
        $colors = Artcol::findByCdarti($cdarti);

        if (count($colors) > 0) {
            foreach ($colors as $color) {
                $cdcolo = $color->cdcolo;
                $filimg = $color->flimag;

                $artcol = Artcol::findFirst(array('cdarti = :cdarti: AND cdcolo = :cdcolo:', 'bind' => array('cdarti' => $cdarti, 'cdcolo' => $cdcolo)));
                if ($filimg != '') {
                    if (!$reassign && $filimg != '&nbsp;') {
                        continue;
                    } else {
                        Artcol::updateColorImage($cdarti, $cdcolo, '');
                    }
                }

                $tokens = explode(' ', $cdarti);
                if (count($tokens) == 2) {
                    $cdartn = $tokens[0];
                    $cdpers = $tokens[1];
                } else {
                    $cdartn = '';
                    $cdpers = '';
                }

                // 1 - cdarti_cdcolo
                $codric = $this->normalizeSearchCode($cdarti . '_' . $cdcolo);
                if ($file = $this->searchFirstFile($codric)) {
                    Artcol::updateColorImage($cdarti, $cdcolo, $file);
                    continue;
                }

                // 2 - cdpers_cdcolo
                $codric = $this->normalizeSearchCode($cdpers . '_' . $cdcolo);
                if ($file = $this->searchFirstFile($codric)) {
                    Artcol::updateColorImage($cdarti, $cdcolo, $file);
                    continue;
                }

                // 3 - cdcolo
                $codric = $this->normalizeSearchCode($cdcolo);
                if ($file = $this->searchFirstFile($codric)) {
                    Artcol::updateColorImage($cdarti, $cdcolo, $file);
                    continue;
                }

                // 4 - dscolo
                $codric = $this->normalizeSearchCode($artcol->dscolo);
                if ($file = $this->searchFirstFile($codric)) {
                    Artcol::updateColorImage($cdarti, $cdcolo, $file);
                }
            }
        }
    }

    private function normalizeSearchCode($codric)
    {
        $expage_sepbar = '_';

        if (empty($codric)) {
            return '';
        }

        $codric = trim($codric);

        if (substr($codric, -1) == '.') {
            $codric = substr_replace($codric, '0', -1, 1);
        }

        if (substr($codric, 0) == '.') {
            $codric = substr_replace($codric, '_', 0, 1);
        }

        $old_chars = array('  ', ' ', '*', "'", "/");
        $new_chars = array(" ", "_", "#", "", $expage_sepbar);

        return str_replace($old_chars, $new_chars, $codric);

        //if ( !stringaVuota(expage_rimcrt) )
        //{
        //numcrt = atoi(left(tmp,expage_rimcrt,1));
        //strcpy(elecrt,expage_rimcrt+1);

        //for ( i=0; i<numcrt; i++ )
        //{
        //left(tmp,codric,1);
        //if ( idx(codric,tmp) ) strcpy(codric,codric+1);
        //}
        //}
    }

    private function searchFirstFile($file)
    {
        $ret = false;

        $possiblePaths = array(
            //'./upload/',
            './img/model/',
        );
        $possibleSuffixes = array(
            '.jpg',
            '.JPG',
        );

        foreach ($possiblePaths as $path) {
            foreach ($possibleSuffixes as $suffix) {
                if (file_exists($path . $file . $suffix)) {
                    return $file . $suffix;
                }
            }
        }

        $goimag_chkfil = $this->config->param->chkfil;
        if (!$goimag_chkfil) {
            foreach ($possiblePaths as $path) {
                foreach ($possibleSuffixes as $suffix) {
                    $files = glob($path . $file . '*' . $suffix);
                    if (count($files) > 0) {
                        return str_replace($path, '', $files[0]);
                    }
                }
            }
        }

        return $ret;
    }
    //endregion

    //region Utility functions
    public function getCommonVars()
    {
        $paymentType  = $this->utility->getAppSettings('PaymentOnCloseOrder');
        $shippingType = $this->utility->getAppSettings('ShippingOnCloseOrder');
        $commonVars   = array(
            'licenses'                     => $this->getLicenses(),
            'enableBudget'                 => $this->utility->getAppSettings('BudgetManagement') > 0,
            'enableBlockedItems'           => $this->utility->getAppSettings('EnableBlockedItems') > 0,
            'enableCheckPrices'            => $this->utility->getAppSettings('PreventOrderToBeSentWithoutPrices') == 1,
            'enableColors'                 => in_array($this->utility->getAppSettings('ModelDetailStyle'), [1, 6, 7, 9]),
            'enableCoupon'                 => $this->utility->getAppSettings('ParamCouponPromo') == 1,
            'enableCustomFilter'           => $this->utility->getAppSettings('EnableCustomFilter'),
            'enableCustomPayment'          => $paymentType == 1 || $paymentType == 4,
            'enableCustomShipping'         => $shippingType == 1 || $shippingType == 4,
            'enableCustomVariants'         => $this->utility->getAppSettings('ModelDetailStyle') == 3,
            'enableCategoryBanner'         => $this->utility->getAppSettings('CategoryBanner') == 1,
            'enableBrandBanner'            => $this->utility->getAppSettings('BrandBanner') == 1,
            'enableParamCollectionNoTitle' => $this->utility->getAppSettings('ParamCollectionNoTitle') == 1,
            'enableVariantInCollection'    => $this->utility->getAppSettings('VariantInCollection') == 1,
            'enableMaxDiscontInCollection' => $this->utility->getAppSettings('MaxDiscountInCollection') == 1,
            'enableShowFilterLeftSide'     => $this->utility->getAppSettings('ShowFilterLeftSide') == 1,
            'enableColoredPriceBackground' => $this->utility->getAppSettings('ColoredPriceBackground') == 1,
            'enableCustomFamily'           => $this->utility->getAppSettings('ModelDetailStyle') == 2,
            'enableCustomMenu'             => $this->utility->getAppSettings('NavbarContent') == 4,
            'enableGalleries'              => $this->utility->getAppSettings('EnableCatalogGalleries') > 0,
            'enableClassifications'        => $this->utility->getAppSettings('EnableProductClassifications') > 0,
            'enableSpecialSelections'      => $this->utility->getAppSettings('SpecialSelections') > 0,
            'enableGoGatewayFeatures'      => $this->utility->getAppUtils('enable_gogateway_features'),
            'enableSupportChat'            => $this->utility->getAppSettings('SupportAvailable') > 0,
            'enableCustomerManagement'     => $this->utility->getAppSettings('ManageCustomerStatus') > 0,
            'cart_limit_mode'              => $this->utility->getAppSettings('OrderLimit'),
            'cart_limit_min_value'         => $this->utility->getAppSettings('OrderLimitMinValue'),
            'ParamAdvancedSync'            => $this->utility->getAppSettings('ParamAdvancedSync'),
        );

        if ($commonVars['enableGoGatewayFeatures'] == 1) {
            $commonVars['goGatewayFeatures'] = array(
                'enableAgentManager'        => $this->utility->getManagementParam('EnableAgentManager')->value == 1,
                'enableAvailabilityManager' => $this->utility->getManagementParam('EnableAvailabilityManager')->value == 1,
                'enableBrandManager'        => $this->utility->getManagementParam('EnableBrandManager')->value == 1,
                'enableCatalogManager'      => $this->utility->getManagementParam('EnableCatalogManager')->value == 1,
                'enableConditionManager'    => $this->utility->getManagementParam('EnableConditionManager')->value == 1,
                'enableExpirationManager'   => $this->utility->getManagementParam('EnableExpirationManager')->value == 1,
                'enableGoAppUserManager'    => $this->utility->getManagementParam('EnableGoAppUserManager')->value == 1,
                'enableLineManager'         => $this->utility->getManagementParam('EnableLineManager')->value == 1,
                'enableLookbookManager'     => $this->utility->getManagementParam('EnableLookbookManager')->value == 1,
                'enablePromoManager'        => $this->utility->getManagementParam('EnablePromoManager')->value == 1,
                'enableSeasonsManager'      => $this->utility->getManagementParam('EnableSeasonsManager')->value == 1,
                'enableSeriesManager'       => $this->utility->getManagementParam('EnableSeriesManager')->value == 1,
                'enableSizeScaleManager'    => $this->utility->getManagementParam('EnableSizeScaleManager')->value == 1,
            );
        }

        return $commonVars;
    }

    public function getLicenses()
    {
        $total_licenses = B2bApputi::findFirst(array("param = 'licenses'"));

        return array(
            'licenses'       => intval(B2bSysusr::getLicensesCount()),
            'total_licenses' => intval($total_licenses != null ? $total_licenses->value : 0),
        );
    }
    //endregion
}
