<?php

namespace Go2B\Controllers;

use Exception;
use Go2B\Library\Environment;
use Go2B\Models\Ageana;
use Go2B\Models\Anaage;
use Go2B\Models\Anagra;
use Go2B\Models\Ananaz;
use Go2B\Models\Anavet;
use Go2B\Models\Anazon;
use Go2B\Models\B2bAddinf;
use Go2B\Models\B2bBgtest;
use Go2B\Models\B2bSysusr;
use Go2B\Models\B2bTkargo;
use Go2B\Models\B2bUsrage;
use Go2B\Models\B2bUsrana;
use Go2B\Models\Ctetic;
use Go2B\Models\Desmer;
use Go2B\Models\Gopart;
use Go2B\Models\Lstest;
use Go2B\Models\Stoord;
use Go2B\Models\Tabstg;
use Go2B\Models\Tppaga;
use Go2B\Models\Tpport;
use Go2B\Plugins\Nav\ApiKOC;
use Phalcon\Http\Request;

class AccountController extends ControllerBase
{
    //region Initialize
    public function initialize()
    {
        $this->tag->setTitle('Account');
        parent::initialize();
    }
    //endregion

    //region Views functions
    public function infoAction()
    {
        $auth = $this->session->get('auth');
        $common = $this->utility->getCommonData('account', $auth['id']);
        $tab = $this->dispatcher->getParam('tab');

        if (isset($_GET['c']) && isset($_GET['t'])) {
            $selectedCustomer = array(
                'tpanag' => $_GET['t'],
                'cdanag' => $_GET['c'],
            );
        } else {
            $selectedCustomer = '';
        }

        $topics = B2bTkargo::find("flbloc = 0");
        if ($topics->count() == 0) {
            B2bTkargo::populate();
            $topics = B2bTkargo::find("flbloc = 0");
        }

        if ($auth['type'] == 3) {
            $newCustomerInfo = array(
                'labels' => Ctetic::getLabelsByCatalog(),
                'countries' => Ananaz::find(array('order' => 'dsnazi')),
                'zones' => Anazon::find(array('order' => 'dszona')),
                'carriers' => Anavet::find(array('order' => 'dsvett')),
                'priceLists' => Anaage::isHeadquarterAgent($auth['id'])
                    ? Lstest::getAllPriceListsForAgent(-1)
                    : Lstest::getAllPriceListsForAgent(Anaage::getAgentFromUser($auth['id'])->cdagen),
                'payments' => Tppaga::find(array('order' => 'dspaga')),
                'shipments' => Tpport::find(array('order' => 'dstpor')),
            );
            $this->view->newCustomerInfo = $newCustomerInfo;
        }

        if ($auth['type'] == 3 && $common['budgetManagement'] > 0) {
            $this->view->seasons = Tabstg::find();
        }

        $this->view->isSpecialAgent = B2bAddinf::isSpecialAgent($auth['id']);

        $customer = B2bUsrana::findFirstByIdUsr($auth['id']);
        $user['type'] = $auth['type'] == 3 ? 'AG' : 'CL';
        $user['code'] = $auth['type'] == 3
            ? B2bUsrage::findFirstByIdUsr($auth['id'])->cdagen
            : B2bUsrana::findFirstByIdUsr($auth['id'])->cdanag;
        $filters['date_start'] = date('Y-m-d', strtotime('today -7days'));
        $filters['date_end'] = date('Y-m-d');
        $ordersHistory = Stoord::getFilteredHistory($user, 'OR', $filters);
        $transDocHistory = Stoord::getFilteredHistory($user, 'DT', $filters);
        $invoicesHistory = Stoord::getFilteredHistory($user, 'FT', $filters);

        //    var_dump(count($ordersHistory), count($transDocHistory), count($invoicesHistory));
        //    exit();

        // TODO ?? questa funziona solo se siamo loggati come clienti! vero ??
        $orders = Stoord::find([
            'conditions' => 'cdanag = :cdanag:',
            'group' => 'numdoc',
            'order' => 'datdoc DESC, numdoc DESC',
            'bind' => ['cdanag' => $customer->cdanag],
            'limit' => 5
        ]);
        $orders_p = [];
        foreach ($orders as $order) {
            $order->datdoc = $this->utility->getHumanDate($order->datdoc);
            $order->desord = $order->numdoc . ' - ' . $order->datdoc;
            $orders_p[] = $order;
        }

        $destinations = [];
        switch ($user['type']) {
            case 1:
            case 2:
                // impossible to get here
                break;
            case 3:
                // agent
                $isHeadquarter = Anaage::isHeadquarterAgent($auth['id']);
                if ($isHeadquarter) {
                    $destinations = Desmer::getShippingsForHeadquarterAgentUser();
                } else {
                    $destinations = Desmer::getShippingsForAgent($auth['code']);
                }
                break;
            case 4:
                // customer
                $destinations = Desmer::getShippingsForCustomer($customer->tpanag, $customer->cdanag);
                break;
            case 5:
                // goods destination
                $destinations = Desmer::getShippingsForShippingUser($auth['id']);
                break;
        }

        $this->view->destinations = $destinations;
        $this->view->ordersHistory = $ordersHistory;
        $this->view->invoicesHistory = $invoicesHistory;
        $this->view->transDocHistory = $transDocHistory;
        $this->view->selectedCustomer = $selectedCustomer;
        $this->view->topics = $topics;
        $this->view->orders = $orders_p;
        $this->view->error = $this->dispatcher->getParam('error');
        $this->view->common = $common;
        $this->view->tab = $tab;
        $this->view->lang = $this->di->get('session')->get('language');
        $this->view->tab_newclient = Environment::getCustomParam('ParamViewNewClient');
    }

    public function downloadXlsTemplateAction()
    {
        $this->view->nuordc = $_POST['nuordc'];
        $this->view->permissions = $_POST['permissions'];
        $this->view->common = $this->utility->getCommonData('account', $this->session->get('auth')['id']);
    }
    //endregion

    //region Ajax functions
    public function changePasswordAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $old_password = $_POST['old_password'];
            $new_password = $_POST['new_password'];

            $auth = $this->session->get('auth');

            $success = B2bSysusr::changePassword($auth['username'], $old_password, $new_password);

            echo json_encode($success ? 'OK' : 'WP');
        }
    }

    public function loadCustomerInfoAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $tpanag = $_POST['tpanag'];
            $cdanag = $_POST['cdanag'];

            $idlang = $this->utility->getLanguage();

            $auth = $this->session->get('auth');
            $anagra = Anagra::getCustomer($tpanag, $cdanag, $idlang);
            if ($auth['type'] == 3) {
                $desmer = Desmer::getShippingsForAgent($auth['code'], $anagra);
            } else {
                $desmer = Desmer::getShippingsForCustomer($tpanag, $cdanag);
            }

            $res = array(
                'anagra' => $this->getHtmlAnagra($anagra),
                'desmer' => $this->getHtmlDesmer($desmer)
            );

            if ($anagra === false) {
                echo json_encode("ER");
            } else {
                echo json_encode($res);
            }
        }
    }

    private function getHtmlAnagra($anagra)
    {
        $html = '';

        $labels = Ctetic::getLabelsByCatalog();
        $countries = Ananaz::find(array('order' => 'dsnazi'));
        $priceLists = Lstest::find(array('order' => 'dslist'));
        $zones = Anazon::find(array('order' => 'dszona'));

        $html .= "<input type='hidden' id='multi-anagra-tpanag' name='multi-anagra-tpanag' value='" . $anagra->tpanag . "'/>";

        // Open row
        $html .= "<div class='row account-section bottom-border'>";

        // cdanag
        $html .= "<div class='col-6 col-lg-4'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.code') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control' id='multi-anagra-cdanag' ";
        $html .= "name='multi-anagra-cdanag' value='" . $anagra->cdanag . "' disabled />";
        $html .= "</div>";
        $html .= "</div>";

        // descri
        $html .= "<div class='col-6 col-lg-4'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.businessname') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control' id='multi-anagra-descri' ";
        $html .= "name='multi-anagra-descri' value='" . $anagra->descri . "' disabled />";
        $html .= "</div>";
        $html .= "</div>";

        // codfis
        $html .= "<div class='col-6 col-lg-4'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.taxcode') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control' id='multi-anagra-codfis' ";
        $html .= "name='multi-anagra-codfis' value='" . $anagra->codfis . "' disabled />";
        $html .= "</div>";
        $html .= "</div>";

        // pariva
        $html .= "<div class='col-6 col-lg-4'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.vatcode') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control' id='multi-anagra-pariva' ";
        $html .= "name='multi-anagra-pariva' value='" . $anagra->pariva . "' disabled />";
        $html .= "</div>";
        $html .= "</div>";

        // uffipa
        $html .= "<div class='col-6 col-lg-4'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.code.pa') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control' id='multi-anagra-uffipa' ";
        $html .= "name='multi-anagra-uffipa' value='" . $anagra->uffipa . "' disabled />";
        $html .= "</div>";
        $html .= "</div>";

        // codupr
        $html .= "<div class='col-6 col-lg-4'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.code.pr') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control' id='multi-anagra-codupr' ";
        $html .= "name='multi-anagra-codupr' value='" . $anagra->codupr . "' disabled />";
        $html .= "</div>";
        $html .= "</div>";

        // indpec
        $html .= "<div class='col-6 col-lg-4'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.pec') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control' id='multi-anagra-indpec' ";
        $html .= "name='multi-anagra-indpec' value='" . $anagra->indpec . "' disabled />";
        $html .= "</div>";
        $html .= "</div>";

        // desvid
        $html .= "<div class='col-6 col-lg-4'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.signboard') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control' id='multi-anagra-desvid' ";
        $html .= "name='multi-anagra-desvid' value='" . $anagra->desvid . "' disabled />";
        $html .= "</div>";
        $html .= "</div>";

        // Close Row
        $html .= "</div>";

        // Open row
        $html .= "<div class='row account-section bottom-border pt-20x'>";

        // indiri
        $html .= "<div class='col-12 col-lg-4'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.address') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control readonly' id='multi-anagra-indiri' ";
        $html .= "name='multi-anagra-indiri' value='" . $anagra->indiri . "' disabled />";
        $html .= "</div>";
        $html .= "</div>";

        $html .= "<div class='col-12 col-lg-4'>";
        // ccitta
        $html .= "<div style='width:50%;margin-right:4%' class='float-left'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.city') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control readonly' id='multi-anagra-ccitta' ";
        $html .= "name='multi-anagra-ccitta' value='" . $anagra->ccitta . "' disabled />";
        $html .= "</div>";
        $html .= "</div>";
        // provin
        $html .= "<div style='width:18%;margin-right:4%' class='float-left'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.province') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control readonly' id='multi-anagra-provin' ";
        $html .= "name='multi-anagra-provin' value='" . $anagra->provin . "' disabled />";
        $html .= "</div>";
        $html .= "</div>";
        // codcap
        $html .= "<div style='width:24%' class='float-left'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.capzip') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control readonly' id='multi-anagra-codcap' ";
        $html .= "name='multi-anagra-codcap' value='" . $anagra->codcap . "' disabled />";
        $html .= "</div>";
        $html .= "</div>";

        $html .= "</div>";

        // cdnazi
        $html .= "<div class='col-6 col-lg-2'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.country') . "</div>";
        $html .= "<div class='account-field form-element form-select'>";
        $html .= "<select class='form-control readonly' id='multi-anagra-cdnazi' name='multi-anagra-cdnazi' disabled>";
        $html .= "<option value='null' ";
        if ($anagra->cdnazi == "") {
            $html .= "selected";
        }
        $html .= ">&nbsp;</option>";
        foreach ($countries as $ananaz) {
            $html .= "<option value='" . $ananaz->cdnazi . "' ";
            if ($anagra->cdnazi == $ananaz->cdnazi) {
                $html .= "selected";
            }
            $html .= ">" . $ananaz->dsnazi . "</option>";
        }
        $html .= "</select>";
        $html .= "</div>";
        $html .= "</div>";

        // cdzona
        $html .= "<div class='col-6 col-lg-2'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.zone') . "</div>";
        $html .= "<div class='account-field form-element form-select'>";
        $html .= "<select class='form-control readonly' id='multi-anagra-cdzona' name='multi-anagra-cdzona' disabled>";
        $html .= "<option value='null' ";
        if ($anagra->cdzona == "") {
            $html .= "selected";
        }
        $html .= ">&nbsp;</option>";
        foreach ($zones as $anazon) {
            $html .= "<option value='" . utf8_encode($anazon->cdzona) . "' ";
            if ($anagra->cdzona == $anazon->cdzona) {
                $html .= "selected";
            }
            $html .= ">" . utf8_encode($anazon->dszona) . "</option>";
        }
        $html .= "</select>";
        $html .= "</div>";
        $html .= "</div>";

        $html .= "<div class='col-12 col-lg-4'>";
        // intern
        $html .= "<div style='width:20%;margin-right:4%' class='float-left'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.countrycode') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control readonly' id='multi-anagra-intern' ";
        $html .= "name='multi-anagra-intern' value='" . $anagra->intern . "' disabled />";
        $html .= "</div>";
        $html .= "</div>";
        // numtel
        $html .= "<div style='width:36%;margin-right:4%' class='float-left'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.telephone') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control readonly' id='multi-anagra-numtel' ";
        $html .= "name='multi-anagra-numtel' value='" . $anagra->numtel . "' disabled />";
        $html .= "</div>";
        $html .= "</div>";
        // numte2
        $html .= "<div style='width:36%' class='float-left'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.telephone.other') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control readonly' id='multi-anagra-numte2' ";
        $html .= "name='multi-anagra-numte2' disabled />";
        $html .= "</div>";
        $html .= "</div>";

        $html .= "</div>";

        // indema
        $html .= "<div class='col-6 col-lg-4'>";
        $html .= "<div class='account-title'>" . $this->translate('_common.email') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control' id='multi-anagra-indema' ";
        $html .= "name='multi-anagra-indema' value='" . $anagra->indema . "' disabled />";
        $html .= "</div>";
        $html .= "</div>";

        // indem2
        $html .= "<div class='col-6 col-lg-4'>";
        $html .= "<div class='account-title'>" . $this->translate('_common.email.other') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control' id='multi-anagra-indem2' ";
        $html .= "name='multi-anagra-indem2' value='" . $anagra->indem2 . "' disabled />";
        $html .= "</div>";
        $html .= "</div>";

        $html .= "<div class='col-12 col-lg-4'>";
        // empty
        $html .= "<div style='width:20%;margin-right:4%' class='float-left'>&nbsp;</div>";
        // numcel
        $html .= "<div style='width:36%;margin-right:4%' class='float-left'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.mobilephone') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control readonly' id='multi-anagra-numcel' ";
        $html .= "name='multi-anagra-numcel' value='" . $anagra->numcel . "' disabled />";
        $html .= "</div>";
        $html .= "</div>";
        // numfax
        $html .= "<div style='width:36%' class='float-left'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.fax') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control readonly' id='multi-anagra-numfax' ";
        $html .= "name='multi-anagra-numfax' value='" . $anagra->numfax . "' disabled />";
        $html .= "</div>";
        $html .= "</div>";

        $html .= "</div>";

        // Close row
        $html .= "</div>";

        // Open row
        $html .= "<div class='row account-section pt-20x pb-40x'>";

        $html .= "<div class='col-6 col-lg-4'>";
        // codabi
        $html .= "<div style='width:20%;margin-right:4%' class='float-left'>";
        $html .= "<div class='account-title'>ABI</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control readonly' id='multi-anagra-codabi' ";
        $html .= "name='multi-anagra-codabi' value='" . $anagra->codabi . "' disabled />";
        $html .= "</div>";
        $html .= "</div>";

        // codcab
        $html .= "<div style='width:20%;margin-right:4%' class='float-left'>";
        $html .= "<div class='account-title'>CAB</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control readonly' id='multi-anagra-codcab' ";
        $html .= "name='multi-anagra-codcab' value='" . $anagra->codcab . "' disabled />";
        $html .= "</div>";
        $html .= "</div>";

        // cdiban
        $html .= "<div style='width:52%' class='float-left'>";
        $html .= "<div class='account-title'>IBAN</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control readonly' id='multi-anagra-cdiban' ";
        $html .= "name='multi-anagra-cdiban' value='" . $anagra->cdiban . "' disabled />";
        $html .= "</div>";
        $html .= "</div>";

        $html .= "</div>";

        // tppaga
        $html .= "<div class='col-6 col-lg-4'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.payment') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control' id='multi-anagra-tppaga' ";
        $html .= "name='multi-anagra-tppaga' value='" . $anagra->dspaga . "' disabled />";
        $html .= "</div>";
        $html .= "</div>";

        // tpport
        $html .= "<div class='col-6 col-lg-4'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.shipment') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control' id='multi-anagra-tpport' ";
        $html .= "name='multi-anagra-tpport' value='" . $anagra->dstpor . "' disabled />";
        $html .= "</div>";
        $html .= "</div>";

        // nulist
        $html .= "<div class='col-6 col-lg-2'>";
        $html .= "<div class='account-title text-capitalize'>" . $this->translate('_common.pricelist') . "</div>";
        $html .= "<div class='account-field form-element form-select'>";
        $html .= "<select class='form-control readonly' id='multi-anagra-nulist' name='multi-anagra-nulist' disabled>";
        $html .= "<option value='null' ";
        if ($anagra->nulist == "") {
            $html .= "selected";
        }
        $html .= ">&nbsp;</option>";
        foreach ($priceLists as $lstest) {
            $html .= "<option value='" . $lstest->dslist . "' ";
            if ($anagra->nulist == $lstest->nulist) {
                $html .= "selected";
            }
            $html .= ">" . $lstest->dslist . "</option>";
        }
        $html .= "</select>";
        $html .= "</div>";
        $html .= "</div>";

        // cdvett
        $html .= "<div class='col-6 col-lg-4'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.carrier') . "</div>";
        $html .= "<div class='account-field form-element form-select'>";
        $html .= "<select class='form-control readonly' id='multi-anagra-cdvett' name='multi-anagra-cdvett' disabled>";
        $html .= "<option value='null' ";
        if ($anagra->cdvett == "") {
            $html .= "selected";
        }
        $html .= ">&nbsp;</option>";

        $carriers = Anavet::find(array('order' => 'dsvett'));
        foreach ($carriers as $anavet) {
            $html .= "<option value='" . $anavet->cdvett . "' ";
            if ($anagra->cdvett == $anavet->cdvett) {
                $html .= "selected";
            }
            $html .= ">" . $anavet->dsvett . "</option>";
        }
        $html .= "</select>";
        $html .= "</div>";
        $html .= "</div>";

        // cdagen
        $html .= "<div class='col-6 col-lg-4'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.agent') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control' id='multi-anagra-cdagen' ";
        $html .= "name='multi-anagra-cdagen' value='" . $anagra->dsagen . "' disabled />";
        $html .= "</div>";
        $html .= "</div>";

        if ($this->utility->getAppSettings('ParamSendMailForVariations') == 1) {
            $html .= "<div class='col-6 col-lg-4'>";
            $html .= "<div style='margin-top:19px;margin-right:-7px'>";
            $html .= "<a href='#' data-tpanag='" . $anagra->tpanag . "' data-cdanag='" . $anagra->cdanag . "' ";
            $html .= "class='btn btn-generic' ";
            $html .= "id='multi-anagra-require-modify'>" . $this->translate('account.customer.requiremodify') . "</a>";
            $html .= "</div>";
            $html .= "</div>";
        }
        $html .= "</div>";

        return $html;
    }

    private function getHtmlDesmer($destinations)
    {
        $html = '';

        $countries = Ananaz::find(array('order' => 'dsnazi'));
        $zones = Anazon::find(array('order' => 'dszona'));

        foreach ($destinations as $desmer) {
            // Title row
            $html .= "<div class='destination-card-title'>";
            $html .= "<div class='row account-section bottom-border pb-10x'>";
            $html .= $this->translate('account.customer.destination') . " " . $desmer->cddesm . " - " . $desmer->desvid;
            $html .= "</div>";
            $html .= "</div>";

            // Open card
            $html .= "<div class='destination-card'>";

            // Open row
            $html .= "<div class='row account-section pt-20x pb-40x'>";

            // cddesm
            $html .= "<div class='col-4'>";
            $html .= "<div class='account-title'>" . $this->translate('account.customer.address') . "</div>";
            $html .= "<div class='account-field form-element'>";
            $html .= "<input type='text' class='form-control readonly' ";
            $html .= "id='" . $desmer->cddesm . "-indiri' name='" . $desmer->cddesm . "-indiri' ";
            $html .= "value='" . $desmer->indiri . "' disabled />";
            $html .= "</div>";
            $html .= "</div>";

            $html .= "<div class='col-4'>";
            // ccitta
            $html .= "<div style='width:50%;margin-right:4%' class='float-left'>";
            $html .= "<div class='account-title'>" . $this->translate('account.customer.city') . "</div>";
            $html .= "<div class='account-field form-element'>";
            $html .= "<input type='text' class='form-control readonly' ";
            $html .= "id='" . $desmer->cddesm . "-ccitta' name='" . $desmer->cddesm . "-ccitta' ";
            $html .= "value='" . $desmer->ccitta . "' disabled />";
            $html .= "</div>";
            $html .= "</div>";
            // provin
            $html .= "<div style='width:18%;margin-right:4%' class='float-left'>";
            $html .= "<div class='account-title'>" . $this->translate('account.customer.province') . "</div>";
            $html .= "<div class='account-field form-element'>";
            $html .= "<input type='text' class='form-control readonly' ";
            $html .= "id='" . $desmer->cddesm . "-provin' name='" . $desmer->cddesm . "-provin' ";
            $html .= "value='" . $desmer->provin . "' disabled />";
            $html .= "</div>";
            $html .= "</div>";
            //codcap
            $html .= "<div style='width:24%' class='float-left'>";
            $html .= "<div class='account-title'>" . $this->translate('account.customer.capzip') . "</div>";
            $html .= "<div class='account-field form-element'>";
            $html .= "<input type='text' class='form-control readonly' ";
            $html .= "id='" . $desmer->cddesm . "-codcap' name='" . $desmer->cddesm . "-codcap' ";
            $html .= "value='" . $desmer->codcap . "' disabled />";
            $html .= "</div>";
            $html .= "</div>";

            $html .= "</div>";

            // cdnazi
            $html .= "<div class='col-2'>";
            $html .= "<div class='account-title'>" . $this->translate('account.customer.country') . "</div>";
            $html .= "<div class='account-field form-element form-select'>";
            $html .= "<select class='form-control readonly' ";
            $html .= "id='" . $desmer->cddesm . "-cdnazi' name='" . $desmer->cddesm . "-cdnazi' disabled>";
            $html .= "<option value='null' ";
            if ($desmer->cdnazi == "") {
                $html .= "selected";
            }
            $html .= ">&nbsp;</option>";
            foreach ($countries as $ananaz) {
                $html .= "<option value='" . $ananaz->cdnazi . "' ";
                if ($desmer->cdnazi == $ananaz->cdnazi) {
                    $html .= "selected";
                }
                $html .= ">" . $ananaz->dsnazi . "</option>";
            }
            $html .= "</select>";
            $html .= "</div>";
            $html .= "</div>";

            // cdzona
            $html .= "<div class='col-2'>";
            $html .= "<div class='account-title'>" . $this->translate('account.customer.zone') . "</div>";
            $html .= "<div class='account-field form-element form-select'>";
            $html .= "<select class='form-control readonly' id='" . $desmer->cddesm . "-cdzona' ";
            $html .= "name='" . $desmer->cddesm . "-cdzona' disabled>";
            $html .= "<option value='null' ";
            if ($desmer->cdzona == "") {
                $html .= "selected";
            }
            $html .= ">&nbsp;</option>";
            foreach ($zones as $anazon) {
                $html .= "<option value='" . utf8_encode($anazon->cdzona) . "' ";
                if ($desmer->cdzona == $anazon->cdzona) {
                    $html .= "selected";
                }
                $html .= ">" . utf8_encode($anazon->dszona) . "</option>";
            }
            $html .= "</select>";
            $html .= "</div>";
            $html .= "</div>";

            $html .= "<div class='col-4'>";
            // intern
            $html .= "<div style='width:20%;margin-right:4%' class='float-left'>";
            $html .= "<div class='account-title'>" . $this->translate('account.customer.countrycode') . "</div>";
            $html .= "<div class='account-field form-element'>";
            $html .= "<input type='text' class='form-control readonly' ";
            $html .= "id='" . $desmer->cddesm . "-intern' name='" . $desmer->cddesm . "-intern' ";
            $html .= "value='" . $desmer->intern . "' disabled />";
            $html .= "</div>";
            $html .= "</div>";
            // numtel
            $html .= "<div style='width:36%;margin-right:4%' class='float-left'>";
            $html .= "<div class='account-title'>" . $this->translate('account.customer.telephone') . "</div>";
            $html .= "<div class='account-field form-element'>";
            $html .= "<input type='text' class='form-control readonly' ";
            $html .= "id='" . $desmer->cddesm . "-numtel' name='" . $desmer->cddesm . "-numtel' ";
            $html .= "value='" . $desmer->numtel . "' disabled />";
            $html .= "</div>";
            $html .= "</div>";
            // numte2
            $html .= "<div style='width:36%' class='float-left'>";
            $html .= "<div class='account-title'>" . $this->translate('account.customer.telephone.other') . "</div>";
            $html .= "<div class='account-field form-element'>";
            $html .= "<input type='text' class='form-control readonly' ";
            $html .= "id='" . $desmer->cddesm . "-numte2' name='" . $desmer->cddesm . "-numte2' ";
            $html .= "disabled />";
            $html .= "</div>";
            $html .= "</div>";

            $html .= "</div>";

            // referent
            $html .= "<div class='col-4'>";
            $html .= "<div class='account-title'>" . $this->translate('account.customer.referent.main') . "</div>";
            $html .= "<div class='account-field form-element'><input type='text' class='form-control readonly' disabled /></div>";
            $html .= "</div>";

            // referent other
            $html .= "<div class='col-4'>";
            $html .= "<div class='account-title'>" . $this->translate('account.customer.referent.other') . "</div>";
            $html .= "<div class='account-field form-element'><input type='text' class='form-control readonly' disabled /></div>";
            $html .= "</div>";

            $html .= "<div class='col-4'>";
            // empty
            $html .= "<div style='width:20%;margin-right:4%' class='float-left'>&nbsp;</div>";
            // numcel
            $html .= "<div style='width:36%;margin-right:4%' class='float-left'>";
            $html .= "<div class='account-title'>" . $this->translate('account.customer.mobilephone') . "</div>";
            $html .= "<div class='account-field form-element'>";
            $html .= "<input type='text' class='form-control readonly' ";
            $html .= "id='" . $desmer->cddesm . "-numcel' name='" . $desmer->cddesm . "-numcel' ";
            $html .= "value='" . $desmer->numcel . "' disabled />";
            $html .= "</div>";
            $html .= "</div>";
            // numfax
            $html .= "<div style='width:36%' class='float-left'>";
            $html .= "<div class='account-title'>" . $this->translate('account.customer.fax') . "</div>";
            $html .= "<div class='account-field form-element'>";
            $html .= "<input type='text' class='form-control readonly' ";
            $html .= "id='" . $desmer->cddesm . "-numfax' name='" . $desmer->cddesm . "-numfax' ";
            $html .= "value='" . $desmer->numfax . "' disabled />";
            $html .= "</div>";
            $html .= "</div>";

            $html .= "</div>";

            $html .= "<div class='col-4'>&nbsp;</div>";
            if ($this->utility->getAppSettings('ParamSendMailForVariations') == 1) {
                $html .= "<div class='col-4'>";
                $html .= "<div class='text-right' style='margin-top:19px;margin-right:-7px'>";
                $html .= "<a href='#' data-cddesm='" . $desmer->cddesm . "' ";
                $html .= "data-desvid='" . $desmer->desvid . "' data-tpanag='" . $desmer->tpanag . "' ";
                $html .= "data-cdanag='" . $desmer->cdanag . "' ";
                $html .= "class='btn btn-generic desmer-require-modify'>";
                $html .= $this->translate('account.customer.requiremodify');
                $html .= "</a>";
                $html .= "</div>";
                $html .= "</div>";
            }

            // Close row
            $html .= "</div>";

            // Close carc
            $html .= "</div>";
        }

        return $html;
    }

    public function loadNewDesmerFormAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $tpanag = $_POST['tpanag'];
            $cdanag = $_POST['cdanag'];

            $idlang = $this->utility->getLanguage();
            $anagra = Anagra::getCustomer($tpanag, $cdanag, $idlang);
            $res = array(
                'desmerForm' => $this->getHtmlNewDesmer()
            );

            if ($anagra === false) {
                echo json_encode("ER");
            } else {
                echo json_encode($res);
            }
        }
    }

    private function getHtmlNewDesmer()
    {
        $html = '';
        $countries = Ananaz::find(array('order' => 'dsnazi'));
        $zones = Anazon::find(array('order' => 'dszona'));

        // Title row
        $html .= "<div class='destination-card-title'>";
        $html .= "    <div class='row account-section bottom-border pb-10x'>";
        $html .= "        <span style='font-weight: bold; font-size:18px;'>" . $this->translate('admin.customers.newshipping') . "</span>";
        $html .= "    </div>";
        $html .= "</div>";

        // Open card
        $html .= "<div class='destination-card'>";

        // Open row
        $html .= "<div style='margin-top: 5px' class='row account-section'>";
        // desvid
        $html .= "<div class='col-6 col-lg-4'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.signboard') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control' id='multi-anagra-desvid' ";
        $html .= "name='desvid' value=''/>";
        $html .= "</div>";
        $html .= "</div>";

        // descri
        $html .= "<div class='col-6 col-lg-4'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.businessname') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control' id='multi-anagra-descri' ";
        $html .= "name='descri' value='' />";
        $html .= "</div>";
        $html .= "</div>";
        // Close first row
        $html .= "</div>";

        // Open second row
        $html .= "<div class='row account-section'>";
        // cdnazi
        $html .= "<div class='col-6 col-lg-3'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.country') . "</div>";
        $html .= "<div class='account-field form-element form-select'>";
        $html .= "<select class='form-control readonly' id='multi-anagra-cdnazi' name='cdnazi'>";
        $html .= "<option value='null' ";
        $html .= ">&nbsp;</option>";
        foreach ($countries as $ananaz) {
            $html .= "<option value='" . $ananaz->cdnazi . "' ";
            $html .= ">" . $ananaz->dsnazi . "</option>";
        }
        $html .= "</select>";
        $html .= "</div>";
        $html .= "</div>";
        // indiri
        $html .= "<div class='col-12 col-lg-4'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.address') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control readonly' id='multi-anagra-indiri' ";
        $html .= "name='indiri' value=''/>";
        $html .= "</div>";
        $html .= "</div>";
        // ccitta
        $html .= "<div class='col-6 col-lg-3'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.city') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control readonly' id='multi-anagra-ccitta' ";
        $html .= "name='ccitta' value=''/>";
        $html .= "</div>";
        $html .= "</div>";
        // provin
        $html .= "<div class='col-6 col-lg-1'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.province') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control readonly' id='multi-anagra-provin' ";
        $html .= "name='provin' value=''>";
        $html .= "</div>";
        $html .= "</div>";
        // codcap
        $html .= "<div class='col-6 col-lg-1'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.capzip') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control readonly' id='multi-anagra-codcap' ";
        $html .= "name='codcap' value=''/>";
        $html .= "</div>";
        $html .= "</div>";
        // Close second row
        $html .= "</div>";

        // Open third row
        $html .= "<div class='row account-section'>";
        // numtel
        $html .= "<div class='col-6 col-lg-2'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.telephone') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control readonly' id='multi-anagra-numtel' ";
        $html .= "name='numtel' value=''/>";
        $html .= "</div>";
        $html .= "</div>";

        // indema
        $html .= "<div class='col-6 col-lg-2'>";
        $html .= "<div class='account-title'>" . $this->translate('_common.email') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control' id='multi-anagra-indema' ";
        $html .= "name='indema' value=''/>";
        $html .= "</div>";
        $html .= "</div>";

        // numcel
        $html .= "<div class='col-6 col-lg-2'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.mobilephone') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control readonly' id='multi-anagra-numcel' ";
        $html .= "name='numcel' value=''/>";
        $html .= "</div>";
        $html .= "</div>";
        // numfax
        $html .= "<div class='col-6 col-lg-2'>";
        $html .= "<div class='account-title'>" . $this->translate('account.customer.fax') . "</div>";
        $html .= "<div class='account-field form-element'>";
        $html .= "<input type='text' class='form-control readonly' id='multi-anagra-numfax' ";
        $html .= "name='numfax' value=''/>";
        $html .= "</div>";
        $html .= "</div>";

        $html .= "<div class='col-4'>";
        $html .= "<div class='text-right' style='margin-top:19px;margin-right:-7px'>";
        $html .= "<a href='#' class='btn btn-generic desmer-create-new'>";
        $html .= $this->translate('_common.save');
        $html .= "</a>";
        $html .= "</div>";
        $html .= "</div>";

        // Close third row
        $html .= "</div>";

        // Close card
        $html .= "</div>";

        return $html;
    }

    public function createNewDesmerAction()
    {
        $this->view->disable();

        if ($this->request->isPost() && $this->request->isAjax()) {
            $this->response->setContentType("application/json");

            $res = [];
            try {
                $desmerData = $this->request->getPost();
                $auth = $this->session->get('auth');

                $customer = Anagra::findCustomerByKey($desmerData['tpanag'], $desmerData['cdanag']);
                if (!$customer instanceof Anagra) {
                    throw new \Exception('Customer not found', 002);
                }

                if ($auth['type'] == B2bSysusr::TYPE_AGENT) {
                    $availableCustomerCodes = Anaage::getAvailableCustomerAndDestinationCodeListForCdagen($auth['code']);

                    if (!in_array("{$customer->tpanag}-{$customer->cdanag}", $availableCustomerCodes["C"])) {
                        throw new \Exception('Auth error', 001);
                    }
                } else if ($auth['type'] == B2bSysusr::TYPE_CUSTOMER && $auth['code'] !== $desmerData['tpanag'] . '-' . $desmerData['cdanag']) {
                    throw new \Exception('Auth error', 001);
                }

                // Setto cddesm prima cosi sono sicuro che la funzione 'clearUncompletedNewDesmer'
                // la elimina correttamente in caso di errore
                $desmerData['cddesm'] = uniqid($desmerData['cdanag'] . '-');
                Desmer::saveNewDesmer($desmerData);

                if ($auth['type'] == B2bSysusr::TYPE_AGENT) {
                    $desmer = Desmer::getShippingsForAgent($auth['code'], $customer);
                } else {
                    $desmer = Desmer::getShippingsForCustomer($desmerData['tpanag'], $desmerData['cdanag']);
                }

                $res['desmer'] = $this->getHtmlDesmer($desmer);
            } catch (Exception $e) {
                Desmer::clearUncompletedNewDesmer($desmerData);
                $res = [
                    'error' => $e->getCode(),
                    'message' => $e->getMessage(),
                ];
            }

            // Set the content of the response
            $this->response->setContent(json_encode($res));
        }

        //Return the response
        return $this->response;
    }

    public function loadDeadlinesForCustomerAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $tpanag = $_POST['tpanag'];
            $cdanag = $_POST['cdanag'];

            $gopart = Gopart::getDeadlinesForCustomer($tpanag, $cdanag);

            if ($gopart == false) {
                echo json_encode("ER");
            } else {
                echo json_encode($gopart);
            }
        }
    }

    public function loadHistoryAction()
    {
        $this->view->disable();
        $auth = $this->session->get('auth');
        $request = new Request();

        if ($request->isPost() && $request->isAjax()) {
            // Faccio questo str_replace() perché strtotime() interpreta le date con gli '/' secondo lo standard americano mm/dd/yyyy,
            // invece, le date che hanno come separatore '.' oppure '-' vengono interpretate secondo lo standard europeo dd-mm-yyyy
            $eu_date_start = str_replace('/', '-', $_POST['date_start']);
            $eu_date_end = str_replace('/', '-', $_POST['date_end']);

            $type = $_POST['type'];

            $filters['date_start'] = date('Y-m-d', strtotime($eu_date_start));
            $filters['date_end'] = date('Y-m-d', strtotime($eu_date_end));
            if (!empty($_POST['search'])) {
                $filters['search'] = $_POST['search'];
            }
            $html = "";

            //$this->logger->info(print_r($filters, true));

            $user['type'] = $auth['type'] == 3 ? 'AG' : 'CL';
            $user['code'] = $auth['type'] == 3
                ? B2bUsrage::findFirstByIdUsr($auth['id'])->cdagen
                : B2bUsrana::findFirstByIdUsr($auth['id'])->cdanag;
            $history = Stoord::getFilteredHistory($user, $type, $filters);

            if ($history) {
                switch ($type) {
                    case 'OR':
                        $html .= $this->getHtmlOrderHistory($history);
                        break;
                    case 'FT':
                        $html .= $this->getHtmlInvoiceHistory($history);
                        break;
                    case 'DT':
                        $html .= $this->getHtmlTransDocHistory($history);
                        break;
                }
            }

            if ($history == false) {
                echo json_encode("ER");
            } else {
                echo json_encode(array('html' => $html));
            }
        }
    }

    private function getHtmlOrderHistory($stoord)
    {
        $html = '';
        // ROWS
        foreach ($stoord as $row) {
            $daf_flt = $row['qtadaf'] > 0 ? 'dafatt' : '';
            $das_flt = $row['qtadas'] > 0 ? 'dasped' : '';

            $html_row = '<div class="row order-history-row" style="cursor:pointer" data-numdoc="' . $row["numdoc"] . '" data-filter="' . $row["numdoc"] . ' ' . $row["cdanag"] . ' ' . $row["ragsoc"] . ' ' . $daf_flt . ' ' . $das_flt . '">';
            $html_row .= "<div class='col-orh-numdoc'>" . $row['numdoc'] . "</div>";
            $html_row .= "<div class='col-orh-datdoc'>" . $row['datdoc'] . "</div>";
            $html_row .= "<div class='col-orh-datspe'>" . ($row['datspe'] == '0000-00-00' ? '' : $row['datspe']) . "</div>";
            $html_row .= "<div class='col-orh-cdanag'>" . $row['cdanag'] . "</div>";
            $html_row .= "<div class='col-orh-ragsoc'>" . $row['ragsoc'] . "</div>";
            $html_row .= "<div class='col-orh-qtaord'>" . $row['qtaord'] . "</div>";
            $html_row .= "<div class='col-orh-qtafat'>" . $row['qtafat'] . "</div>";
            $html_row .= "<div class='col-orh-qtadaf'>" . $row['qtadaf'] . "</div>";
            $html_row .= "<div class='col-orh-qtaspe'>" . $row['qtaspe'] . "</div>";
            $html_row .= "<div class='col-orh-qtadas'>" . $row['qtadas'] . "</div>";
            $html_row .= "<div class='col-orh-impord'>" . number_format(floatval($row['impord']), 2, ',', '.') . "</div>";
            $html_row .= "<div class='col-orh-impfat'>" . number_format(floatval($row['impfat']), 2, ',', '.') . "</div>";
            $html_row .= "<div class='col-orh-impdaf'>" . number_format(floatval($row['impdaf']), 2, ',', '.') . "</div>";
            $html_row .= "<div class='col-orh-impspe'>" . number_format(floatval($row['impspe']), 2, ',', '.') . "</div>";
            $html_row .= "<div class='col-orh-impdas'>" . number_format(floatval($row['impdas']), 2, ',', '.') . "</div>";
            $html_row .= "</div>";

            $html .= $html_row;
        }
        return $html;
    }
    //endregion

    //region Utility functions

    private function getHtmlInvoiceHistory($stoord)
    {
        $html = '';
        // ROWS
        foreach ($stoord as $row) {
            $html_row = '<div class="row invoice-history-row" data-numdoc="' . $row["numdoc"] . '" data-filter="' . $row["numdoc"] . ' ' . $row["cdanag"] . ' ' . $row["ragsoc"] . '">';
            $html_row .= "<div class='col-inh-numdoc'>" . $row['numdoc'] . "</div>";
            $html_row .= "<div class='col-inh-cdanag'>" . $row['cdanag'] . "</div>";
            $html_row .= "<div class='col-inh-ragsoc'>" . $row['ragsoc'] . "</div>";
            $html_row .= "<div class='col-inh-datdoc'>" . $row['datdoc'] . "</div>";
            $html_row .= "<div class='col-inh-datspe'>" . ($row['datspe'] == '0000-00-00' ? '' : $row['datspe']) . "</div>";
            $html_row .= "<div class='col-inh-qtafat'>" . $row['qtafat'] . "</div>";
            $html_row .= "<div class='col-inh-impfat'>" . number_format(floatval($row['impfat']), 2, ',', '.') . "</div>";
            $html_row .= "</div>";

            $html .= $html_row;
        }
        return $html;
    }

    private function getHtmlTransDocHistory($stoord)
    {
        $html = '';
        // ROWS
        foreach ($stoord as $row) {
            $daf_flt = $row['qtadaf'] > 0 ? 'dafatt' : '';

            $html_row = '<div class="row transdoc-history-row" data-numdoc="' . $row["numdoc"] . '" data-filter="' . $row["numdoc"] . ' ' . $row["cdanag"] . ' ' . $row["ragsoc"] . ' ' . $daf_flt . '">';
            $html_row .= "<div class='col-tdh-numdoc'>" . $row['numdoc'] . "</div>";
            $html_row .= "<div class='col-tdh-cdanag'>" . $row['cdanag'] . "</div>";
            $html_row .= "<div class='col-tdh-ragsoc'>" . $row['ragsoc'] . "</div>";
            $html_row .= "<div class='col-tdh-datdoc'>" . $row['datdoc'] . "</div>";
            $html_row .= "<div class='col-tdh-datspe'>" . ($row['datspe'] == '0000-00-00' ? '' : $row['datspe']) . "</div>";
            $html_row .= "<div class='col-tdh-qtafat'>" . $row['qtafat'] . "</div>";
            $html_row .= "<div class='col-tdh-qtadaf'>" . $row['qtadaf'] . "</div>";
            $html_row .= "<div class='col-tdh-qtaspe'>" . $row['qtaspe'] . "</div>";
            $html_row .= "<div class='col-tdh-impfat'>" . number_format(floatval($row['impfat']), 2, ',', '.') . "</div>";
            $html_row .= "<div class='col-tdh-impdaf'>" . number_format(floatval($row['impdaf']), 2, ',', '.') . "</div>";
            $html_row .= "<div class='col-tdh-impspe'>" . number_format(floatval($row['impspe']), 2, ',', '.') . "</div>";
            $html_row .= "</div>";

            $html .= $html_row;
        }
        return $html;
    }

    public function loadHistoryDetailAction()
    {
        $this->view->disable();
        $request = new Request();

        if ($request->isPost() && $request->isAjax()) {
            $numdoc = $_POST['numdoc'];
            $type = $_POST['type'];
            $html = "";

            $history_det = Stoord::getFilteredHistoryRows($numdoc, $type);

            if ($history_det) {
                switch ($type) {
                    case 'OR':
                        $html .= $this->getHtmlOrderHistoryDetail($history_det, $numdoc);
                        break;
                    case 'FT':
                        $html .= $this->getHtmlInvoiceHistoryDetail($history_det, $numdoc);
                        break;
                    case 'DT':
                        $html .= $this->getHtmlTransDocHistoryDetail($history_det, $numdoc);
                        break;
                }
            }

            if ($history_det == false) {
                echo json_encode("ER");
            } else {
                echo json_encode(array('html' => $html));
            }
        }
    }

    private function getHtmlOrderHistoryDetail($stoord, $numdoc)
    {
        // HEADER
        $html = "<div class='row row-orh-header row-orh-$numdoc text-bold active' style='background: #bdf;'>";
        $html .= "<div class='col-orh col-orh-numdoc'></div>";
        $html .= "<div class='col-orh col-orh-datdoc'></div>";
        $html .= "<div class='col-orh col-orh-datspe'></div>";
        $html .= "<div class='col-orh col-orh-cdanag'>" . $this->translate('_common.code') . "</div>";
        $html .= "<div class='col-orh col-orh-ragsoc'>" . $this->translate('_common.description') . "</div>";
        $html .= "<div class='col-orh col-orh-qtaord'></div>";
        $html .= "<div class='col-orh col-orh-qtafat'></div>";
        $html .= "<div class='col-orh col-orh-qtadaf'></div>";
        $html .= "<div class='col-orh col-orh-qtaspe'></div>";
        $html .= "<div class='col-orh col-orh-qtadas'></div>";
        $html .= "<div class='col-orh col-orh-impord'></div>";
        $html .= "<div class='col-orh col-orh-impfat'></div>";
        $html .= "<div class='col-orh col-orh-impdaf'></div>";
        $html .= "<div class='col-orh col-orh-impspe'></div>";
        $html .= "<div class='col-orh col-orh-impdas'></div>";
        $html .= "</div>";

        // ROWS
        foreach ($stoord as $row) {
            $daf_flt = $row->qtadaf > 0 ? 'dafatt' : '';
            $das_flt = $row->qtadas > 0 ? 'dasped' : '';

            $html_row = '<div class="row row-orh row-orh-' . $row->numdoc . ' text-bold active" style="background:#f5f5ff;line-height: 20px;font-size:12px" data-filter="' . $row->codart . ' ' . $row->desart . ' ' . $row->numdoc . ' ' . $row->cdanag . ' ' . $row->ragsoc . ' ' . $daf_flt . ' ' . $das_flt . '">';
            $html_row .= "<div class='col-orh col-orh-numdoc'></div>";
            $html_row .= "<div class='col-orh col-orh-datdoc'></div>";
            $html_row .= "<div class='col-orh col-orh-datspe text-right'>
                      <a href='#' data-toggle='modal' data-target='#modal-new-ticket' onclick='updatePar(\"$row->numdoc\", \"$row->codart\")'><i class='fa fa-life-ring'></i></a>
                    </div>";
            $html_row .= "<div class='col-orh col-orh-cdanag'>$row->codart</div>";
            $html_row .= "<div class='col-orh col-orh-ragsoc'>$row->desart</div>";
            $html_row .= "<div class='col-orh col-orh-qtaord'>$row->qtaord</div>";
            $html_row .= "<div class='col-orh col-orh-qtafat'>$row->qtafat</div>";
            $html_row .= "<div class='col-orh col-orh-qtadaf'>$row->qtadaf</div>";
            $html_row .= "<div class='col-orh col-orh-qtaspe'>$row->qtaspe</div>";
            $html_row .= "<div class='col-orh col-orh-qtadas'>$row->qtadas</div>";
            $html_row .= "<div class='col-orh col-orh-impord'>" . number_format(floatval($row->impord), 2, ',', '.') . "</div>";
            $html_row .= "<div class='col-orh col-orh-impfat'>" . number_format(floatval($row->impfat), 2, ',', '.') . "</div>";
            $html_row .= "<div class='col-orh col-orh-impdaf'>" . number_format(floatval($row->impdaf), 2, ',', '.') . "</div>";
            $html_row .= "<div class='col-orh col-orh-impspe'>" . number_format(floatval($row->impspe), 2, ',', '.') . "</div>";
            $html_row .= "<div class='col-orh col-orh-impdas'>" . number_format(floatval($row->impdas), 2, ',', '.') . "</div>";
            $html_row .= "</div>";

            $html .= $html_row;
        }
        return $html;
    }

    private function getHtmlInvoiceHistoryDetail($stoord, $numdoc)
    {
        // HEADER
        $html = "<div class='row row-inh-header row-inh-$numdoc text-bold active' style='background: #bdf;'>";
        $html .= "<div class='col-inh col-inh-numdoc'></div>";
        $html .= "<div class='col-inh col-inh-cdanag'>" . $this->translate('_common.code') . "</div>";
        $html .= "<div class='col-inh col-inh-ragsoc'>" . $this->translate('_common.description') . "</div>";
        $html .= "<div class='col-inh col-inh-datdoc'></div>";
        $html .= "<div class='col-inh col-inh-datspe'></div>";
        $html .= "<div class='col-inh col-inh-qtafat'></div>";
        $html .= "<div class='col-inh col-inh-impfat'></div>";
        $html .= "</div>";

        // ROWS
        foreach ($stoord as $row) {
            $html_row = '<div class="row row-inh row-inh-' . $row->numdoc . ' text-bold active" style="background:#f5f5ff;line-height: 20px;font-size:12px" data-filter="' . $row->codart . ' ' . $row->desart . ' ' . $row->numdoc . ' ' . $row->cdanag . ' ' . $row->ragsoc . '">';
            $html_row .= "<div class='col-inh col-inh-numdoc'></div>";
            $html_row .= "<div class='col-inh col-inh-cdanag'>$row->codart</div>";
            $html_row .= "<div class='col-inh col-inh-ragsoc'>$row->desart</div>";
            $html_row .= "<div class='col-inh col-inh-datdoc'></div>";
            $html_row .= "<div class='col-inh col-inh-datspe'></div>";
            $html_row .= "<div class='col-inh col-inh-qtafat'>$row->qtafat</div>";
            $html_row .= "<div class='col-inh col-inh-impfat'>" . number_format(floatval($row->impfat), 2, ',', '.') . "</div>";
            $html_row .= "</div>";

            $html .= $html_row;
        }
        return $html;
    }

    private function getHtmlTransDocHistoryDetail($stoord, $numdoc)
    {
        // HEADER
        $html = "<div class='row row-tdh-header row-tdh-$numdoc text-bold active' style='background: #bdf;'>";
        $html .= "<div class='col-tdh col-tdh-numdoc'></div>";
        $html .= "<div class='col-tdh col-tdh-cdanag'>" . $this->translate('_common.code') . "</div>";
        $html .= "<div class='col-tdh col-tdh-ragsoc'>" . $this->translate('_common.description') . "</div>";
        $html .= "<div class='col-tdh col-tdh-datdoc'></div>";
        $html .= "<div class='col-tdh col-tdh-datspe'></div>";
        $html .= "<div class='col-tdh col-tdh-qtafat'></div>";
        $html .= "<div class='col-tdh col-tdh-qtadaf'></div>";
        $html .= "<div class='col-tdh col-tdh-qtaspe'></div>";
        $html .= "<div class='col-tdh col-tdh-impfat'></div>";
        $html .= "<div class='col-tdh col-tdh-impdaf'></div>";
        $html .= "<div class='col-tdh col-tdh-impspe'></div>";
        $html .= "</div>";

        // ROWS
        foreach ($stoord as $row) {
            $daf_flt = $row->qtadaf > 0 ? 'dafatt' : '';

            $html_row = '<div class="row row-tdh row-tdh-' . $row->numdoc . ' text-bold active" style="background:#f5f5ff;line-height: 20px;font-size:12px" data-filter="' . $row->codart . ' ' . $row->desart . ' ' . $row->numdoc . ' ' . $row->cdanag . ' ' . $row->ragsoc . ' ' . $daf_flt . '">';
            $html_row .= "<div class='col-tdh col-tdh-numdoc'></div>";
            $html_row .= "<div class='col-tdh col-tdh-cdanag'>$row->codart</div>";
            $html_row .= "<div class='col-tdh col-tdh-ragsoc'>$row->desart</div>";
            $html_row .= "<div class='col-tdh col-tdh-datdoc'></div>";
            $html_row .= "<div class='col-tdh col-tdh-datspe'></div>";
            $html_row .= "<div class='col-tdh col-tdh-qtafat'>$row->qtafat</div>";
            $html_row .= "<div class='col-tdh col-tdh-qtadaf'>$row->qtadaf</div>";
            $html_row .= "<div class='col-tdh col-tdh-qtaspe'>$row->qtaspe</div>";
            $html_row .= "<div class='col-tdh col-tdh-impfat'>" . number_format(floatval($row->impfat), 2, ',', '.') . "</div>";
            $html_row .= "<div class='col-tdh col-tdh-impdaf'>" . number_format(floatval($row->impdaf), 2, ',', '.') . "</div>";
            $html_row .= "<div class='col-tdh col-tdh-impspe'>" . number_format(floatval($row->impspe), 2, ',', '.') . "</div>";
            $html_row .= "</div>";

            $html .= $html_row;
        }
        return $html;
    }

    public function sendEditRequestAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $subject = $_POST['subject'];
            $content = $_POST['content'];
            $email = $this->utility->getAppUtils('email');

            // Add email to mail queue
            //B2bMsgque::saveRecord($email, $subject, $content, 0);

            echo json_encode('OK');
        }
    }

    public function saveNewCustomerAction()
    {
        $this->view->disable();

        $auth = $this->session->get('auth');
        if ($this->request->isPost() && $this->request->isAjax() && $auth['type'] == 3) {
            $checkSDI = strlen($this->request->getPost('codupr') == 6) ? true : false;

            $values = array(
                'descri' => $_POST['descri'],
                'indiri' => $_POST['indiri'],
                'ccitta' => $_POST['ccitta'],
                'provin' => $_POST['provin'],
                'cdnazi' => $_POST['cdnazi'],
                'codcap' => $_POST['codcap'],
                'codfis' => $_POST['codfis'],
                'pariva' => $_POST['pariva'],
                'uffipa' => ($checkSDI ? $this->request->getPost('uffipa') : ''),
                'codupr' => (!$checkSDI ? $this->request->getPost('codupr') : ''),
                'desvid' => $_POST['desvid'],
                'cdzona' => $_POST['cdzona'] != 'null' ? $_POST['cdzona'] : '',
                'intern' => $_POST['intern'],
                'indema' => $_POST['indema'],
                'indem2' => $_POST['indem2'],
                'numtel' => $_POST['numtel'],
                'numte2' => $_POST['numte2'],
                'numcel' => $_POST['numcel'],
                'numfax' => $_POST['numfax'],
                'websit' => $_POST['websit'],
                'indpec' => $_POST['indpec'],
                'codabi' => $_POST['codabi'],
                'codcab' => $_POST['codcab'],
                'cdiban' => $_POST['cdiban'],
                'tppaga' => $_POST['tppaga'] != 'null' ? $_POST['tppaga'] : '',
                'tpport' => $_POST['tpport'] != 'null' ? $_POST['tpport'] : '',
                'cdvett' => $_POST['cdvett'],
                'nulist' => $_POST['nulist'],
                'cdagen' => $auth['code'],
            );

            if (Anagra::checkIfCustomerExists($values['codfis'], $values['pariva'], $values['cdnazi'])) {
                echo json_encode('AP');
            } else {
                $result = Anagra::saveNewCustomer($values);
                if ($result === true) {
                    echo json_encode('OK');
                } else {
                    // Restituisci l'errore al client
                    echo json_encode($result);
                }
            }
            exit;
        }
    }

    public function loadBudgetForCustomerAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $tpanag = $_POST['tpanag'];
            $cdanag = $_POST['cdanag'];
            $cdstag = $_POST['cdstag'];

            $rawBudgets = B2bBgtest::getAllBudgetInfoFromCustomerAndSeason($tpanag, $cdanag, $cdstag);
            $budgets = $this->utility->getFixedBudgets($rawBudgets, $tpanag, $cdanag);

            if (count($budgets) > 0) {
                $lineIndexes = B2bBgtest::getSortedBudgetsFromCustomerAndSeason($tpanag, $cdanag, $cdstag);
                $fullBudgets = array();
                for ($i = 0; $i < count($lineIndexes); $i++) {
                    $fullBudgets[$i] = $budgets[$lineIndexes[$i]->nubudg];
                }

                $addBrand = false;
                $currentBrandCode = $fullBudgets[0]->cdtitl;
                foreach ($fullBudgets as $item) {
                    if ($item->cdtitl != $currentBrandCode) {
                        $addBrand = true;
                        break;
                    }
                }

                $nulist = $this->utility->getDefaultNulistFromCustomer($tpanag, $cdanag);
                $lstest = Lstest::findFirstByNulist($nulist);
                $currency = $this->utility->getCurrencySymbol($lstest->cdvalu);

                $lineColumnWidth = 300;
                $otherColumnWidth = 150;
                $title = $this->translate('_common.line') . ' - ' . $this->translate('_common.drop');
                $html = $this->elements->getBudgetHeaderHtml($lineColumnWidth, $otherColumnWidth, 'px', $fullBudgets[0], $title, false, false, false);
                $html .= $this->elements->getBudgetForCustomerBodyHtml($lineColumnWidth, $otherColumnWidth, 'px', $fullBudgets, $addBrand, $currency, true, false, false, false);
            } else {
                $html = $this->translate('account.budget.no');
            }

            echo json_encode(array('html' => $html));
        }
    }
    //endregion
}
