<?php

use Go2B\Controllers\Utility;
use Go2B\Library\AjaxHtmlBuilder;
use Go2B\Library\DiskManager;
use Go2B\Library\Elements;
use Go2B\Library\Filters;
use Go2B\Library\NavbarBuilder;
use Go2B\Library\Translator;
use Go2B\Plugins\NotFoundPlugin;
use Go2B\Plugins\SecurityPlugin;
use Phalcon\Cache\Backend\File as BackFile;
use Phalcon\Cache\Frontend\Data as FrontData;
use Phalcon\Crypt;
use Phalcon\Events\Manager as EventsManager;
use Phalcon\Flash\Session as FlashSession;
use Phalcon\Flash\Direct as FlashDirect;
use Phalcon\Http\Response\Cookies;
use Phalcon\Logger\Adapter\File as FileAdapter;
use Phalcon\Mvc\Dispatcher;
use Phalcon\Mvc\Model\Metadata\Memory as MetaData;
use Phalcon\Mvc\Url as UrlProvider;
use Phalcon\Mvc\View;
use Phalcon\Mvc\View\Engine\Volt as VoltEngine;
use Phalcon\Session\Adapter\Files as SessionAdapter;
use Rest\Components\Repositories\AccessTokenRepository;
use Rest\Components\Repositories\AuthCodeRepository;
use Rest\Components\Repositories\ClientRepository;
use Rest\Components\Repositories\RefreshTokenRepository;
use Rest\Components\Repositories\ScopeRepository;
use Rest\Components\Repositories\UserRepository;
use League\OAuth2\Server\AuthorizationServer;
use League\OAuth2\Server\ResourceServer;
use League\OAuth2\Server\Grant\AuthCodeGrant;
use League\OAuth2\Server\Grant\ClientCredentialsGrant;
use League\OAuth2\Server\Grant\ImplicitGrant;
use League\OAuth2\Server\Grant\PasswordGrant;
use League\OAuth2\Server\Grant\RefreshTokenGrant;

class Services extends \Go2B\Library\Base\Services
{
    protected function initRouter()
    {
        $router = new \Phalcon\Mvc\Router();

        //region Account routes
        $router->add("/account/info", array(
            'controller' => 'account',
            'action' => 'info'
        ));

        $router->add("/account/info/{tab}", array(
            'controller' => 'account',
            'action' => 'info'
        ));

        $router->add("/account/info/{tab}/{error}", array(
            'controller' => 'account',
            'action' => 'info'
        ));
        //endregion

        //region Admin routes
        $router->add("/admin/categoryBanner/{category}", array(
            'controller' => 'admin',
            'action' => 'categoryBanner'
        ));


        $router->add("/admin/customers", array(
            'controller' => 'admin',
            'action' => 'customers'
        ));

        $router->add("/admin/customers/{page}", array(
            'controller' => 'admin',
            'action' => 'customers'
        ));

        $router->add("/admin/customflt", array(
            'controller' => 'admin',
            'action' => 'customflt'
        ));

        $router->add("/admin/customflt/{tpfilt}", array(
            'controller' => 'admin',
            'action' => 'customflt'
        ));

        $router->add("/admin/customfamily/{cdregv}", array(
            'controller' => 'admin',
            'action' => 'customfamily'
        ));

        $router->add("/admin/customvar/{cdregv}/{tpvari}", array(
            'controller' => 'admin',
            'action' => 'customvar'
        ));

        $router->add("/admin/editCustomDiscount/{numdis}", array(
            'controller' => 'admin',
            'action' => 'editCustomDiscount'
        ));

        $router->add("/admin/gallery/{nugall}", array(
            'controller' => 'admin',
            'action' => 'gallery'
        ));

        $router->add("/admin/localization/{table}", array(
            'controller' => 'admin',
            'action' => 'localization'
        ));

        $router->add("/admin/modifyModelInfo/{cdartn}", array(
            'controller' => 'admin',
            'action' => 'modifyModelInfo'
        ));

        $router->add("/admin/order/{mode}/{nuordc}", array(
            'controller' => 'admin',
            'action' => 'order'
        ));

        $router->add("/admin/order/{mode}/{nuordc}/{tab}", array(
            'controller' => 'admin',
            'action' => 'order'
        ));

        $router->add("/admin/specialSelectionDetail/{cdspsl}", array(
            'controller' => 'admin',
            'action' => 'specialSelectionDetail'
        ));

        $router->add("/admin/uploadImage/{where}", array(
            'controller' => 'admin',
            'action' => 'uploadImage'
        ));

        $router->add("/admin/uploadImageBrand/{where}", array(
            'controller' => 'admin',
            'action' => 'uploadImageBrand'
        ));
        //endregion

        //region Cart routes
        $router->add("/cart/index/{nuordc}", array(
            'controller' => 'cart',
            'action' => 'index'
        ));

        $router->add("/cart/payStripe/{nuordc}", array(
            'controller' => 'cart',
            'action' => 'payStripe'
        ));
        //endregion

        //region Catalog routes
        $router->add("/catalog/collection", array(
            'controller' => 'catalog',
            'action' => 'collection'
        ));

        $router->add('/catalog/collection/{cdtitl}', array(
            'controller' => 'catalog',
            'action' => 'collection'
        ));

        $router->add('/catalog/collection/{cdtitl}/{cdlinm}', array(
            'controller' => 'catalog',
            'action' => 'collection'
        ));

        $router->add('/catalog/collection/{cdtitl}/{cdlinm}/{cdserm}', array(
            'controller' => 'catalog',
            'action' => 'collection'
        ));

        $router->add("/catalog/list", array(
            'controller' => 'catalog',
            'action' => 'list'
        ));

        $router->add('/catalog/list/{cdtitl}', array(
            'controller' => 'catalog',
            'action' => 'list'
        ));

        $router->add('/catalog/list/{cdtitl}/{cdlinm}', array(
            'controller' => 'catalog',
            'action' => 'list'
        ));

        $router->add('/catalog/list/{cdtitl}/{cdlinm}/{cdserm}', array(
            'controller' => 'catalog',
            'action' => 'list'
        ));

        $router->add("/catalog/fabric", array(
            'controller' => 'catalog',
            'action' => 'fabric'
        ));

        $router->add('/catalog/fabric/{cdtitl}', array(
            'controller' => 'catalog',
            'action' => 'fabric'
        ));

        $router->add('/catalog/fabric/{cdtitl}/{cdlinm}', array(
            'controller' => 'catalog',
            'action' => 'fabric'
        ));

        $router->add('/catalog/fabric/{cdtitl}/{cdlinm}/{cdserm}', array(
            'controller' => 'catalog',
            'action' => 'fabric'
        ));

        $router->add('/catalog/fabricDetail/{cdpers}', array(
            'controller' => 'catalog',
            'action' => 'fabricDetail'
        ));

        $router->add("/catalog/index/{cdcata}", array(
            'controller' => 'catalog',
            'action' => 'index'
        ));

        $router->add('/catalog/loadFiltersSelection/{cdspsl}', array(
            'controller' => 'catalog',
            'action' => 'loadFiltersSelection'
        ));

        $router->add("/catalog/look/{cdlkbk}/{cdlook}", array(
            'controller' => 'catalog',
            'action' => 'look'
        ));

        $router->add("/catalog/lookbook/{cdlkbk}", array(
            'controller' => 'catalog',
            'action' => 'lookbook'
        ));

        $router->add("/catalog/promo/{cdprom}", array(
            'controller' => 'catalog',
            'action' => 'promo'
        ));

        $router->add('/catalog/selection/{cdspsl}', array(
            'controller' => 'catalog',
            'action' => 'selection'
        ));

        $router->add("/catalog/setFilterFromHomepage/{tpbloc}/{codice}", array(
            'controller' => 'catalog',
            'action' => 'setFilterFromHomepage'
        ));

        $router->add("/catalog/setFilterFromHomepage/{tpbloc}/{codice}/{cdtitl}/{cdlinm}", array(
            'controller' => 'catalog',
            'action' => 'setFilterFromHomepage'
        ));

        $router->add("/catalog/tag/{tag}", array(
            'controller' => 'catalog',
            'action' => 'tag'
        ));
        //endregion

        //region GoManagement routes
        $router->add("/gomanagement/catalogDetail/{cdcata}", array(
            'controller' => 'gomanagement',
            'action' => 'catalogDetail'
        ));

        $router->add("/gomanagement/catalogSorting/{cdcata}", array(
            'controller' => 'gomanagement',
            'action' => 'catalogSorting'
        ));

        $router->add("/gomanagement/conditions/{type}", array(
            'controller' => 'gomanagement',
            'action' => 'conditions'
        ));

        $router->add("/gomanagement/editDevice/{cdagen}", array(
            'controller' => 'gomanagement',
            'action' => 'editDevice'
        ));

        $router->add("/gomanagement/editLookbook/{cdlkbk}", array(
            'controller' => 'gomanagement',
            'action' => 'editLookbook'
        ));

        $router->add("/gomanagement/editPromo/{cdprom}", array(
            'controller' => 'gomanagement',
            'action' => 'editPromo'
        ));

        $router->add("/gomanagement/expirations/{mode}/{cdstag}", array(
            'controller' => 'gomanagement',
            'action' => 'expirations'
        ));

        $router->add("/gomanagement/expirations/{mode}/{cdstag}/{tpcond}", array(
            'controller' => 'gomanagement',
            'action' => 'expirations'
        ));
        //endregion

        //region Model routes
        $router->add("/model/ajax/deleteOrderRowFromArticleWizard", array(
            'controller' => 'model',
            'action' => 'deleteOrderRowFromArticleWizard'
        ));

        $router->add("/model/ajax/getArticleImagesPreview", array(
            'controller' => 'model',
            'action' => 'getArticleImagesPreview'
        ));

        $router->add("/model/ajax/getColorImagesPreview", array(
            'controller' => 'model',
            'action' => 'getColorImagesPreview'
        ));

        $router->add("/model/ajax/getComponentImages", array(
            'controller' => 'model',
            'action' => 'getComponentImages'
        ));

        $router->add("/model/ajax/getComponentMaterial", array(
            'controller' => 'model',
            'action' => 'getComponentMaterial'
        ));

        $router->add("/model/ajax/getCurrentArticle", array(
            'controller' => 'model',
            'action' => 'getCurrentArticle'
        ));

        $router->add("/model/ajax/getCurrentArticleJson", array(
            'controller' => 'model',
            'action' => 'getCurrentArticleJson'
        ));

        $router->add("/model/ajax/saveOrderRowsFromCurrentArticleJson", array(
            'controller' => 'model',
            'action' => 'saveOrderRowsFromCurrentArticleJson'
        ));

        $router->add("/model/ajax/getCurrentDesiderata", array(
            'controller' => 'model',
            'action' => 'getCurrentDesiderata'
        ));

        $router->add("/model/ajax/getCurrentDesiderataSizes", array(
            'controller' => 'model',
            'action' => 'getCurrentDesiderataSizes'
        ));

        $router->add("/model/ajax/getCustomConfigurationWizard", array(
            'controller' => 'model',
            'action' => 'getCustomConfigurationWizard'
        ));

        $router->add("/model/ajax/getSizesForArticleWizard", array(
            'controller' => 'model',
            'action' => 'getSizesForArticleWizard'
        ));

        $router->add("/model/ajax/getSizesForFabricWizard", array(
            'controller' => 'model',
            'action' => 'getSizesForFabricWizard'
        ));

        $router->add("/model/ajax/getSizesForConfiguratorWizard", array(
            'controller' => 'model',
            'action' => 'getSizesForConfiguratorWizard'
        ));

        $router->add("/model/ajax/getSizesFromColor", array(
            'controller' => 'model',
            'action' => 'getSizesFromColor'
        ));

        $router->add("/model/ajax/loadLinkedBuy", array(
            'controller' => 'model',
            'action' => 'loadLinkedBuy'
        ));

        $router->add("/model/ajax/loadQuickShop", array(
            'controller' => 'model',
            'action' => 'loadQuickShop'
        ));

        $router->add("/model/ajax/loadRecents", array(
            'controller' => 'model',
            'action' => 'loadRecents'
        ));

        $router->add("/model/ajax/loadRelated", array(
            'controller' => 'model',
            'action' => 'loadRelated'
        ));

        $router->add("/model/ajax/saveCustomArticle", array(
            'controller' => 'model',
            'action' => 'saveCustomArticle'
        ));

        $router->add("/model/ajax/savedesiderataqty", array(
            'controller' => 'model',
            'action' => 'savedesiderataqty'
        ));

        $router->add("/model/ajax/saveNewCustomFromConfigurator", array(
            'controller' => 'model',
            'action' => 'saveNewCustomFromConfigurator'
        ));

        $router->add("/model/ajax/saveOrderRow", array(
            'controller' => 'model',
            'action' => 'saveOrderRow'
        ));

        $router->add("/model/ajax/saveOrderRows", array(
            'controller' => 'model',
            'action' => 'saveOrderRows'
        ));

        $router->add("/model/ajax/saveOrderRowsFromArticleWizard", array(
            'controller' => 'model',
            'action' => 'saveOrderRowsFromArticleWizard'
        ));

        $router->add("/model/ajax/saveOrderRowsFromFabricWizard", array(
            'controller' => 'model',
            'action' => 'saveOrderRowsFromFabricWizard'
        ));

        $router->add("/model/{cdartn}", array(
            'controller' => 'model',
            'action' => 'index'
        ));

        $router->add("/model/{cdartn}/{cdpers}/{cdcolo}", array(
            'controller' => 'model',
            'action' => 'index'
        ));

        $router->add("/model/fullscreen/{code}", array(
            'controller' => 'model',
            'action' => 'fullscreen'
        ));

        //$router->add("/model/fullscreenvar/{type}/{code}", array(
        $router->add("/model/fullscreenvar/var", array(
            'controller' => 'model',
            'action' => 'fullscreenvar'
        ));

        $router->add("/model/img360/{cdartn}", array(
            'controller' => 'model',
            'action' => 'img360'
        ));

        $router->add("/model/wizard/{cdartn}", array(
            'controller' => 'model',
            'action' => 'wizard'
        ));

        $router->add("/model/wizard/{cdartn}/{cdpers}", array(
            'controller' => 'model',
            'action' => 'wizard'
        ));
        //endregion

        //region Pdf routes
        $router->add("/pdf/order/{nuordc}", array(
            'controller' => 'pdf',
            'action' => 'order'
        ));

        $router->add("/pdf/tickler/{tpanag}/{cdanag}", array(
            'controller' => 'pdf',
            'action' => 'tickler'
        ));
        //endregion

        //region Support routes
        $router->add("/support/chat/{cdtick}", array(
            'controller' => 'support',
            'action' => 'chat'
        ));

        $router->add("/support/list", array(
            'controller' => 'support',
            'action' => 'list'
        ));

        $router->add("/support/chatAdmin/{cdtick}", array(
            'controller' => 'support',
            'action' => 'chatAdmin'
        ));

        $router->add("/support/listAdmin", array(
            'controller' => 'support',
            'action' => 'listAdmin'
        ));

        $router->add("/support/index/{user}", array(
            'controller' => 'support',
            'action' => 'index'
        ));
        //endregion

        //region API routes
        $router->addPost("/api/v1/login", array(
            'controller' => 'rest',
            'action' => 'login'
        ));

        $router->addGet("/api/v1/catalogs", array(
            'controller' => 'rest',
            'action' => 'getCatalogs'
        ));

        /*
            $router->add("/api/v1/renewToken", array(
              'controller'  => 'api/rest',
              'action'      => 'renewToken'
            ));

            $router->add("/api/v1/getCatalogs", array(
              'controller'  => 'db',
              'action'      => 'getCatalogs'
            ));*/
        //endregion

        $router->setDefaultNamespace('Go2B\Controllers');

        return $router;
    }

    // We register the events manager
    protected function initDispatcher()
    {
        $eventsManager = new EventsManager;

        // Check if the user is allowed to access certain action using the SecurityPlugin
        $eventsManager->attach('dispatch:beforeDispatch', new SecurityPlugin);

        // Handle exceptions and not-found exceptions using NotFoundPlugin
        $eventsManager->attach('dispatch:beforeException', new NotFoundPlugin);

        $dispatcher = new Dispatcher;
        $dispatcher->setEventsManager($eventsManager);

        return $dispatcher;
    }

    // The URL component is used to generate all kind of urls in the application
    protected function initUrl()
    {
        $url = new UrlProvider();
        $url->setBaseUri($this->get('config')->application->baseUri);
        return $url;
    }

    protected function initView()
    {
        $view = new View();
        $view->setViewsDir(APP_PATH . $this->get('config')->application->viewsDir);
        $view->setMainView('index');

        $view->registerEngines(array(
            '.volt' => 'volt'
        ));

        return $view;
    }

    // Setting up volt
    protected function initSharedVolt($view, $di)
    {
        $volt = new VoltEngine($view, $di);

        if (!file_exists(APP_PATH . 'cache/volt/')) {
            mkdir(APP_PATH . 'cache/volt/', 0777, true);
        }

        $volt->setOptions(array(
            "compiledPath" => APP_PATH . "cache/volt/"
        ));

        $volt->getCompiler()->addFunction('_', function ($resolvedArgs) {
            return '$t->_(' . $resolvedArgs . ')';
        });

        $compiler = $volt->getCompiler();
        $compiler->addFilter('round', 'round');
        $compiler->addFunction('getimagesize', 'getimagesize');
        $compiler->addFunction('is_a', 'is_a');
        $compiler->addFunction('min', 'min');
        $compiler->addFunction('max', 'max');
        $compiler->addFunction('is_scalar', 'is_scalar');
        $compiler->addFunction('is_numeric', 'is_numeric');
        $compiler->addFunction('range', 'range');
        $compiler->addFunction('str_replace', 'str_replace');
        $compiler->addFunction('substr', 'substr');
        $compiler->addFunction('strlen', 'strlen');
        $compiler->addFunction('urlencode', 'urlencode');
        $compiler->addFunction('strtotime', 'strtotime');
        $compiler->addFunction('htmlspecialchars', 'htmlspecialchars');
        $compiler->addFunction('addslashes', 'addslashes');
        $compiler->addFunction('nl2br', 'nl2br');
        $compiler->addFunction('array_push', 'array_push');
        $compiler->addFunction('array_pop', 'array_pop');
        $compiler->addFunction('key_exists', 'key_exists');
        $compiler->addFunction('array_keys', 'array_keys');
        $compiler->addFunction('key', 'key');
        $compiler->addFunction(
            'img_exists',
            function ($resolvedArgs, $exprArgs) {
                $el = explode(',', $resolvedArgs);
                return $el[0] . " != '' && file_exists(" . $el[1] . ")";
            }
        );
        $compiler->addFilter(
            'currency',
            function ($resolvedArgs, $exprArgs) {
                return "number_format(floatval(" . $resolvedArgs . "), 2, ',', '.')";
            }
        );

        return $volt;
    }

    /**
     * TODO: The slowest option! Consider using memcached/redis or another faster caching system than file...
     * Using the file cache just for the sake of the simplicity here
     */
    protected function initCache()
    {
        // Cache data for one day by default
        $frontCache = new FrontData(array(
            'lifetime' => 3600
        ));

        if (!file_exists(APP_PATH . 'cache/backend/')) {
            mkdir(APP_PATH . 'cache/backend/', 0777, true);
        }

        // File cache settings
        $cache = new BackFile($frontCache, array(
            'cacheDir' => APP_PATH . 'cache/backend/'
        ));

        return $cache;
    }

    protected function initRateLimits($limitType, $identifier, $app)
    {
        // @var \Phalcon\Cache\Backend\File $cache
        $cache = $app->cache;
        // @var \Phalcon\Config\Adapter\Ini $config
        $config = $app->config;

        $limitName = $limitType . 'Limits';
        $secondsName = $limitType . 'Seconds';
        $limit = $config->api->$limitName;
        $seconds = $config->api->$secondsName;

        if ($limit != '' && $seconds != '') {
            $cacheName = (new Utility)->filter_filename($limitName . $identifier, true);

            if ($cache->exists($cacheName, $seconds)) {
                $rate = $cache->get($cacheName, $seconds);
                // using FileCache with many concurrent connections around 10% of the time boolean is returned instead of the real cache data.
                if (gettype($rate) === 'boolean') {
                    $httpStatusCode = 500;
                    $message = 'Please try again in a moment';

                    $app->response->setContentType("application/json");
                    $app->response->setStatusCode($httpStatusCode, \Rest\Components\HttpStatusCodes::getMessage($httpStatusCode))->sendHeaders();
                    echo json_encode($message);
                    return false;
                }
                $rate['remaining']--;
                $resetAfter = $rate['saved'] + $seconds - time();
                if ($rate['remaining'] > -1) {
                    $cache->save($cacheName, $rate, $resetAfter);
                }
            } else {
                $rate = ['remaining' => $limit - 1, 'saved' => time()];
                $cache->save($cacheName, $rate, $seconds);
                $resetAfter = $seconds;
            }

            $app->response->setHeader('X-Rate-Limit-Limit', $limit);
            $app->response->setHeader('X-Rate-Limit-Remaining', ($rate['remaining'] > -1 ? $rate['remaining'] : 0) . ' ');
            $app->response->setHeader('X-Rate-Limit-Reset', $resetAfter . ' ');

            if ($rate['remaining'] > -1) {
                return true;
            } else {
                $httpStatusCode = 429;
                $message = 'Too Many Requests';

                $app->response->setContentType("application/json");
                $app->response->setStatusCode($httpStatusCode, \Rest\Components\HttpStatusCodes::getMessage($httpStatusCode))->sendHeaders();
                echo json_encode($message);
                return false;
            }
        }
        return false;
    }

    /**
     * If our request contains a body, it has to be valid JSON.  This parses the
     * body into a standard Object and makes that available from the DI.  If this service
     * is called from a function, and the request body is nto valid JSON or is empty,
     * the program will throw an Exception.
     */
    protected function initRequestBody($app)
    {
        $in = trim($app->request->getJsonRawBody());
        // JSON body could not be parsed, throw exception
        if ($in === '') {
            throw new HttpException(
                'There was a problem understanding the data sent to the server by the application.',
                409,
                array(
                    'dev' => 'The JSON body sent to the server was unable to be parsed.',
                    'internalCode' => 'REQ1000',
                    'more' => ''
                )
            );
        }
        return $in;
    }

    protected function initResourceServer($di)
    {
        $server = new ResourceServer(
            new AccessTokenRepository(),            // instance of AccessTokenRepositoryInterface
            'file://' . __DIR__ . '/' . $this->get('config')->get('api')->get('oAuthPublic')  // the authorization server's public key
        );
        return $server;
    }

    protected function initAuthorizationServer()
    {
        $api = $this->get('config')->get('api');

        $clientRepository = new ClientRepository();
        $accessTokenRepository = new AccessTokenRepository();
        $scopeRepository = new ScopeRepository();
        $userRepository = new UserRepository();
        $refreshTokenRepository = new RefreshTokenRepository();
        $authCodeRepository = new AuthCodeRepository();

        $accessTokenLifetime = new \DateInterval($api->get('oAuthAccessTokenLifetime'));
        $refreshTokenLifetime = new \DateInterval($api->get('oAuthRefreshTokenLifetime'));
        $authorizationCodeLifetime = new \DateInterval($api->get('oAuthAuthorizationCodeLifetime'));

        $server = new AuthorizationServer(
            $clientRepository,                 // instance of ClientRepositoryInterface
            $accessTokenRepository,            // instance of AccessTokenRepositoryInterface
            $scopeRepository,                  // instance of ScopeRepositoryInterface
            'file://' . __DIR__ . '/' . $api->oAuthPrivate,    // path to private key
            'file://' . __DIR__ . '/' . $api->oAuthPublic      // path to public key
        );
        $server->setEncryptionKey('Z4KrinJNfNN0oMuJTdZr0DCOOCFbRFY/YnPcafGXpC0=');

        // Enable the password grant on the server
        $passwordGrant = new PasswordGrant($userRepository, $refreshTokenRepository);
        $passwordGrant->setRefreshTokenTTL($refreshTokenLifetime);
        $server->enableGrantType($passwordGrant, $accessTokenLifetime);

        // Enable the authentication code grant on the server
        $authCodeGrant = new AuthCodeGrant($authCodeRepository, $refreshTokenRepository, $authorizationCodeLifetime);
        $authCodeGrant->setRefreshTokenTTL($refreshTokenLifetime);
        $server->enableGrantType($authCodeGrant, $accessTokenLifetime);

        // Enable the refresh token grant on the server
        $refreshTokenGrant = new RefreshTokenGrant($refreshTokenRepository);
        $refreshTokenGrant->setRefreshTokenTTL($refreshTokenLifetime);
        $server->enableGrantType($refreshTokenGrant, $accessTokenLifetime);

        // Enable the client credentials grant on the server
        $clientCredentialsGrant = new ClientCredentialsGrant();
        $server->enableGrantType($clientCredentialsGrant, $accessTokenLifetime);

        // Enable the implicit grant on the server
        $server->enableGrantType(
            new ImplicitGrant($accessTokenLifetime),
            $accessTokenLifetime
        );

        return $server;
    }

    protected function initSecurity()
    {
        $security = new \Phalcon\Security();

        // Set the password hashing factor to 12 rounds
        $security->setWorkFactor(12);
        $security->setDefaultHash(\Phalcon\Security::CRYPT_BLOWFISH_Y);

        return $security;
    }

    // Database connection is created based in the parameters defined in the configuration file
    protected function initSharedDb()
    {
        $config = $this->get('config')->get('database')->toArray();
        $config['options'] = array(PDO::MYSQL_ATTR_INIT_COMMAND => 'SET NAMES utf8', PDO::ATTR_PERSISTENT => false);
        $config['charset'] = 'utf8';

        $dbClass = '\Phalcon\Db\Adapter\Pdo\\' . $config['adapter'];
        unset($config['adapter']);

        return new $dbClass($config);
    }

    // If the configuration specify the use of metadata adapter use it or use memory otherwise
    protected function initModelsMetadata()
    {
        return new MetaData();
    }

    // Start the session the first time some component request the session service
    protected function initSession()
    {
        $session = new SessionAdapter([
            'uniqueId' => $this->get('config')->get('release')->get('user')
        ]);
        $session->start();
        return $session;
    }

    // Register the flash service with custom CSS classes
    protected function initSharedFlash()
    {
        $flash = new FlashDirect(array(
            'error' => 'alert alert-danger alert-dismissible fade show in',
            'success' => 'alert alert-success alert-dismissible fade show in',
            'notice' => 'alert alert-info alert-dismissible fade show in',
            'warning' => 'alert alert-warning alert-dismissible fade show in'
        ));
        $flash->setImplicitFlush(false);
        return $flash;
    }

    // Register the flash session service with custom CSS classes
    protected function initFlashSession()
    {
        return new FlashSession(array(
            'error' => 'alert alert-danger alert-dismissible fade show in',
            'success' => 'alert alert-success alert-dismissible fade show in',
            'notice' => 'alert alert-info alert-dismissible fade show in',
            'warning' => 'alert alert-warning alert-dismissible fade show in'
        ));
    }

    // Register user components
    protected function initAjaxHtmlBuilder()
    {
        return new AjaxHtmlBuilder();
    }

    protected function initDiskManager()
    {
        return new DiskManager();
    }

    protected function initTranslator()
    {
        return new Translator();
    }

    protected function initFilters()
    {
        return new Filters();
    }

    protected function initElements()
    {
        return new Elements();
    }

    protected function initNavbarBuilder()
    {
        return new NavbarBuilder();
    }

    protected function initUtility()
    {
        return new Utility();
    }

    // Register logger
    protected function initLogger()
    {
        $config = $this->get('config');
        $targetPath = APP_PATH . $config->application->logDir;
        if (!is_dir($targetPath) && !mkdir($targetPath, 0777, true)) {
            die("Error creating folder $targetPath");
        }

        // Trova tutti i file di log presenti nella directory
        $logFiles = glob($targetPath . '*.log');

        // Ordina i file per data di modifica
        usort($logFiles, function ($a, $b) {
            return filemtime($a) < filemtime($b);
        });

        // Rimuovi i file di log che superano il limite massimo
        while (count($logFiles) >= 12) {
            $fileToRemove = array_pop($logFiles);
            unlink($fileToRemove);
        }

        // Crea un nuovo file di log per il mese corrente
        $currentMonthLog = $targetPath . date('Y-m') . '.log';
        if (!file_exists($currentMonthLog)) {
            file_put_contents($currentMonthLog, '');
            chmod($currentMonthLog, 0777);
        }

        $logger = new FileAdapter($currentMonthLog);
        return $logger;
    }

    // Register cookies
    protected function initCookies()
    {
        $cookies = new Cookies();
        $cookies->useEncryption(true);
        return $cookies;
    }

    // Register crypt
    protected function initCrypt()
    {
        $crypt = new Crypt();

        /**
         * Set the cipher algorithm.
         *
         * The `aes-256-gcm' is the preferable cipher, but it is not usable until the
         * openssl library is upgraded, which is available in PHP 7.1.
         *
         * The `aes-256-ctr' is arguably the best choice for cipher
         * algorithm in these days.
         */
        $crypt->setCipher('aes-256-ctr');

        /**
         * Setting the encryption key.
         *
         * The key should have been previously generated in a cryptographically safe way.
         *
         * Bad key:
         * "le password"
         *
         * Better (but still unsafe):
         * "#1dj8$=dp?.ak//j1V$~%*0X"
         *
         * Good key:
         * "T4\xb1\x8d\xa9\x98\x054t7w!z%C*F-Jk\x98\x05\\\x5c"
         *
         * Use your own key. Do not copy and paste this example key.
         */
        $key = "E(H+MbQeShVmYq3t6w9z$=&F)J@NcRfU";

        $crypt->setKey($key);

        return $crypt;
    }

    protected function initI18n()
    {
        $language = $this->get('session')->get('language');

        if (!$language) {
            $this->get('session')->set('language', 'it');
            $language = 'it';
        }

        //        $translationPath = APP_PATH . '/app/messages/' . $language;
        //
        //        require $translationPath . '/main.php';
        //
        //        // Return a translation object
        //        return new NativeArray(array(
        //            'content' => $messages
        //        ));

        //        $t = new Translator();
        //
        //        // Return a translation object
        //        return new NativeArray(array(
        //            'content' => $t->getTranslatedStrings($language)
        //        ));

        return Utility::loadTranslatorFor($language);
    }

    protected function initPdfTemplate()
    {
        $config = $this->get('config');
        $view = new Phalcon\Mvc\View\Simple();
        $view->setViewsDir(APP_PATH . $config->application->viewsDir . '/pdf/');
        $view->setVar('mt', $this->get('i18n'));
        //        $view->setVar('config', $this->get('config'));
        $view->setVar('utility', $this->get('utility'));
        $view->registerEngines(array(
            '.volt' => 'volt'
        ));
        return $view;
    }
}
